/*
 * (C) 1993 Luigi Rizzo, Dipartimento di Ingegneria dell'Informazione
 *     Universita' di Pisa, Italy (luigi@iet.unipi.it)
 *
 * This program will read binary files ld.com and bridge.com
 * producing an image file (image.rom) for a 32K ROM
 * The image is made as follows:
 *
 * offset    0h: LD.COM (must be less than 128 bytes)
 * offset  100h: BRIDGE.COM (must be less than 32K)
 * The sum modulo 256 of the eprom must be 0 in order to be bootable.
 * image.c will patch a free location in order to insure this.
 *
 * This program is provided as an example only. We didn't try it
 * on DOS, where there might be problems with BINARY files.
 * You are welcome to make any changes that are necessary to
 * make it reliable (please report them, so that I can make them).
 * available.
 *
 */
#include <stdio.h>

#define IMAGE_SIZE 32768

#define LOADER "ld.com"
#define BRIDGE "bridge.com"
#define IMAGE "image.rom"
#define ORG 0x100

#ifdef MSDOS
#  define RMODE "r+b"
#  define WMODE "w+b"
#else
#  define RMODE "r"
#  define WMODE "w"
#endif
unsigned char image[IMAGE_SIZE];
main()
{
    unsigned int i,sum;
    FILE *f;

    for (i=0;i<IMAGE_SIZE;i++) image[i]=0xff; /* fill with FFFF */

    f=fopen(LOADER,RMODE);
    if (f==NULL) {
	fprintf(stderr,"Can't open loader file %s\n",LOADER);
	exit(1);
    }
    i=fread(image,1,ORG+1,f);
    if (i>ORG) {
	fprintf(stderr,"Loader %s too big (%d instead of 256 bytes)\n",
		LOADER,i);
	exit(2);
    }
    fprintf(stderr,"%s: %d bytes\n",LOADER,i);
    fclose(f);
    f=fopen(BRIDGE,RMODE);
    if (f==NULL) {
	fprintf(stderr,"Can't open bridge file %s\n",BRIDGE);
	exit(3);
    }
    i=fread(image+ORG,1,IMAGE_SIZE-ORG,f);
    if (i>=IMAGE_SIZE-ORG) {
	fprintf(stderr,"Image %s too big (%d instead of %d bytes)\n",
		BRIDGE,i,IMAGE_SIZE-ORG);
	exit(4);
    }
    fprintf(stderr,"%s: %d bytes\n",BRIDGE,i);
    fclose(f);
    sum=0;
    for (i=0;i<IMAGE_SIZE-1; i++) sum += image[i];
    sum= sum & 0xff;
    image[IMAGE_SIZE-1]= (0x100 - sum) & 0xff;
    f=fopen(IMAGE,WMODE);
    if (f==NULL) {
	fprintf(stderr,"Can't open image file %s\n",IMAGE);
	exit(5);
    }
    i=fwrite(image,1,IMAGE_SIZE,f);
    if (i!=IMAGE_SIZE) {
	fprintf(stderr,"Can't write Image %s (%d instead of %d bytes)\n",
		IMAGE,i,IMAGE_SIZE);
	exit(6);
    }
    fclose(f);
}
