/***
 *** Another debugging tool for checking the parallel port
 ***/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "io_ports.h"
#ifdef linux
#include <linux/lp.h>
#endif
#ifdef __FreeBSD__
#define	LP_PERRORP	0x08
#define	LP_PSELECD	0x10
#define	LP_POUTPA	0x20
#define	LP_PACK		0x40
#define	LP_PBUSY 	0x80
#endif

#define IBUFLEN 128
#define LPT1_BASE  (0x378)             /* where LPT1: is on most h/w */

/* These assume that 'base' == LPT1_BASE or equiv. */
#define lp_data   (base)               /* write to this to change D0-D7 */
#define lp_status (base+1)             /* read from this to get status */
#define lp_ctl    (base+2)             /* write to change the ctl lines */


int base = LPT1_BASE;

int
main(int argc, char *argv[])
{
    char buf[IBUFLEN];
    unsigned char ch;

    if (argc == 2)
	base = atoi(argv[1]);
    if ((argc != 1) || (!base)) {
	fputs("Bad usage! No biscuit!\n", stderr);
	exit(8);
    }

    open_io();  /* opens /dev/port */

    printf("base = %d (0x%x)\n", base, base);

    while (fgets(buf, IBUFLEN, stdin)) {
	if (buf[0] == '?') {
	    ch = in_byte(lp_data);
	    printf("<-- %d (0x%02x)\n", (int)ch, (int)ch);
	} else if (!buf[0] || buf[0] == '\n') {
	    ch = in_byte(lp_status);
	    printf("<+1 %d (0x%02x):", (int)ch, (int)ch);
	    if (!(ch & LP_PBUSY))
		printf(" BUSY");
	    if (!(ch & LP_PACK))
		printf(" ACK");
	    if (ch & LP_POUTPA)
		printf(" OUT-OF-PAPER");
	    if (ch & LP_PSELECD)
		printf(" ONLINE");
	    if (!(ch & LP_PERRORP))
		printf(" ERROR");
	    printf("\n");
	} else {
	    ch = (unsigned char)atoi(buf);
	    out_byte(lp_data, ch);
	    printf("--> %d (0x%02x)\n", (int)ch, (int)ch);
	}
    }
    close_io();  /* release /dev/port */
    return(0);
}
