;;---------------- File: wd8003e.inc ------------------------
COMMENT^
   Copyright (C) 1989 Northwestern University, Vance Morrison
  
   Permission to view, compile, and modify for LOCAL (intra-organization)
   USE ONLY is hereby granted, provided that this copyright and permission
   notice appear on all copies.  Any other use by permission only.
  
   Northwestern University makes no representations about the suitability
   of this software for any purpose.  It is provided "as is" without expressed
   or implied warranty.  See the copywrite notice file for complete details.
  
   17apr93 Alessandro Fanelli, Luigi Rizzo (luigi@iet.unipi.it)
  
   wd8003 holds the interface routines for the western digital ethernet card
   WD8003E or the starlan card WD8003S.  Althougth this routine will work
   for any of the above cards, it has been optimized for the Ethernet card.
  
   The functions provided by this file are

     WD_CARD MACRO ioaddr, memseg, memsize_k, bit16
     WDE_DEFINE name
     WDE_IF_R_ACCESS name, no_packet
     WDE_IF_R_CONT name, ok
     WDE_IF_R_FREE name
     WDE_IF_W_ACCESS name, no_buffer
     WDE_IF_W_WRITE name
     WDE_IF_SET_ADDRESS name
     WDE_IF_COPY name
  
   Variables set by this module
  
     c_wde_&name&_declared		;; one if this interface exists
     c_if_&name&_mtu			;; the maximum trans unit
  

---------------------------------------------------------------
^
 
    include wd.inc
 
;;----------------------------------------------------------------
;; data storage needed by this module

wde_data  STRUC
    wde_new_bndry	DB 0
wde_data ENDS

;;******************************************************************************
 
 
;;-------------------------------------------------------------------
;; WD_CARD ioaddr, memseg, memsize_k, 16bit
;;	Called to define a new card. It calls two macros:
;;	WDE_DECLARE which declares an interface object
;;	IF_DECLARE which sets IF name and type for future use
WD_CARD MACRO ioaddr, memseg, memsize_k, bit16
    WDE_DECLARE %cur_if, ioaddr, memseg, 0H, 1, memsize_k*4, %bit16  ;;
	;; mem_off=0, promiscuous , 256byte-pages, 16bit
    IF_DECLARE %cur_if, %cur_if, WDE
    cur_if = cur_if + 1
ENDM ;;--------------------------------------------------------------
 
 
;;-------------------------------------------------------------------
;;   IF_DECLARE name, io_address, shr_seg, shr_off
;;       declares an interface object.  'io_address' is the address of the
;;       start of the 8003E control registers.  'shr_seg'  and
;;       'shr_off' is the address of the WD8003 card buffer
;;       This address must be a multiple of 512.  If 'promiscuous' is not
;;       zero (or blank),the interface is configured so that every packet on
;;       the ethernet is received.  'total_pg' if not blank, is the total
;;       amount of pages of shared memory.  (default = 32 pages = 8K)
;;       if 'bits16' is non-blank and equal to 1, then the card is assumed
;;       to be a WD8013EBT card.  It it is 2, then it is a WD8013 card but
;;       we have disabled 16bit transfers (some hardware doesn't like it)
;;
;; No code, only some definitions

WDE_DECLARE MACRO name, io_addr, shr_seg, shr_off, promiscuous, total_pg, bits16
    .ERRB <name>
    .ERRB <io_addr>
    .ERRB <shr_seg>
    .ERRB <shr_off>
 
    .DATA
    c_wde_&name&_declared     = 1
    c_wde_&name&_io           = io_addr       ;; set compile time values
    c_wde_&name&_shared_off   = shr_off
    c_wde_&name&_shared_seg   = shr_seg
    IF shr_seg lt 8000h
        .err Shared memory MUST be above 80000H
    ENDIF
 
    c_wde_&name&_stop_pg      = STOP_PG
    IFNB <total_pg>
        c_wde_&name&_stop_pg  = 0&total_pg
    ENDIF
 
    c_wde_&name&_promiscuous = 0
    IFNB <promiscuous>
        c_wde_&name&_promiscuous = 0&promiscuous
    ENDIF
 
    c_wde_&name&_bits16       = 0
    IFNB <bits16>
        c_wde_&name&_bits16   = 0&bits16
    ENDIF
 
    IF c_wde_&name&_bits16 eq 1
	;; note these can only touch registers AX and DX
	WDE_16BIT_ON MACRO myname
	    PORT_WRITE LAAR, c_wde_&myname&_io,LAN16ENB or LA19 or MEM16ENB
	ENDM
 
	WDE_16BIT_OFF MACRO  myname
	    PORT_WRITE LAAR, c_wde_&myname&_io,LAN16ENB or LA19
	ENDM
 
        MEM_DECLARE_16BIT WDE_16BIT_ON, WDE_16BIT_OFF, name
    ELSE
        MEM_DECLARE_8BIT
    ENDIF
 
    c_if_&name&_mtu = 1514
    externdef wde_&name&_data:wde_data
    externdef if_address:word
    .CODE
    externdef wde_&name&_real_define:near
ENDM ;; WDE_DECLARE
;;******************************************************************************
 
 
;;******************************************************************************
;;   WDE_DEFINE name
;;      sets asside memory an name object and initializes it.  This
;;      routine is a no-op if 'name' was not declared
;; Registers: see wde_real_define
;;	IN:	--
;;	OUT:	--
;;	CHANGE: AX, BX, CX, DX, SI

;;
WDE_DEFINE MACRO name
    IFDEF c_wde_&name&_declared
	call wde_&name&_real_define
    ENDIF
ENDM
 
;;******************************************************************************
;;   IF_REAL_DEFINE name
;; Registers:
;;	IN:	--
;;	OUT:	--
;;	CHANGE: AX, BX, CX, DX, SI
;;
;;	Should try to use BP as base to the data area for the card
;;	so that can change this to be a real subroutine.
;;

WDE_REAL_DEFINE MACRO name
    LOCAL loop1, loop2, loop3, around, resetwait
    LOCAL card_found
    .errb <name>
 
IFDEF c_wde_&name&_declared
    .DATA
    wde_&name&_data    wde_data      <>  ;; create storage needed
;; Registers: NONE 
    .CODE
wde_&name&_real_define:	;; this is a global label
    ; look for card
    mov cx, 6                    ;; get the ethernet address
    mov bx, OFFSET if_address+ 8*name
    mov si, OFFSET ct_&name&_ha+5  ;; for printing ethernet address
    mov dx, c_wde_&name&_io+ADDROM ;; point to the Ethernet address ROM
    mov ah,0 ;; for checksum
loop1:		;; read hardware address
    in AL, DX
    add ah,al
    mov [BX], AL
    mov [si], AL    ;; store in print order
    dec si
    inc DX
    inc BX
    loop loop1

    in AL, DX	;; read two more bytes
    inc DX
    add ah,al
    in AL, DX
    add ah,al
    cmp ah, 0ffh	;; checksum
    jz card_found
    ret ;; card not found
card_found:
    mov if_found[name],1
 
    PORT_WRITE W83CREG, c_wde_&name&_io, MSK_RESET;; reset card
    PORT_WRITE W83CREG, c_wde_&name&_io, 0 ;; deassert
 
;;   this sets bit 6 (0 justified) of register offset 0x05, it will enable
;;   the lan controller to access shared RAM 16 bits at a time
;;   In addition, this routine maintains address bit 19
;;   (previous cards assumed this bit high...we must do it manually)
 
;;  note: this is a write only register and only exists on the WD8013
    IF c_wde_&name&_bits16 eq 1
	PORT_WRITE LAAR, c_wde_&name&_io,LAN16ENB+LA19
	    ;; set bit19 of address & 16 bit mode for card
    ENDIF
 
    ;; register 0 is the MSR (Memory base reg) -- also W83CREG
    ;; this will enable the on board ram
    PORT_WRITE W83CREG,c_wde_&name&_io,(c_wde_&name&_shared_seg+(c_wde_&name&_shared_off/16))/512
 
    PORT_WRITE CMDR, c_wde_&name&_io, MSK_STP+MSK_PG0+MSK_RD2 ;; RESET,goto pg0
    xor AL, AL                              ;; clear RBCR0,1
    PORT_WRITE RBCR0, c_wde_&name&_io
    PORT_WRITE RBCR1, c_wde_&name&_io
 
resetwait:          ;; make sure reset is complete
    PORT_READ ISR, c_wde_&name&_io
    test AL, MSK_RST
    jz resetwait
 
    mov AL, MSK_BMS + MSK_FT10              ;; select FIFO threshold = 8 bytes
    IF c_wde_&name&_bits16 EQ 1
        or AL, MSK_WTS              ;; FOR 16 BIT OPERATION
    ENDIF
    PORT_WRITE DCR, c_wde_&name&_io
 
    xor AL, AL                              ;; turn off receiving
    PORT_WRITE RCVR, c_wde_&name&_io
    PORT_WRITE TCR, c_wde_&name&_io, MSK_LBm1 ;; enter loopback mode 1
 
    PORT_WRITE PSTART,c_wde_&name&_io,STRT_PG ;; start page of input buffer
    PORT_WRITE PSTOP,c_wde_&name&_io,c_wde_&name&_stop_pg;; end pg of in buffer
    PORT_WRITE BNRY, c_wde_&name&_io, STRT_PG
 
    PORT_WRITE ISR, c_wde_&name&_io , -1  ;; clear all status bits
    PORT_WRITE IMR, c_wde_&name&_io,0     ;; no interupts
 
    PORT_WRITE CMDR,c_wde_&name&_io,MSK_STP+MSK_PG1+MSK_RD2 ;; page 1
 
    mov CX, 6                               ;; set the ethernet address
    mov BX, OFFSET if_address + 8*name
    mov DX, c_wde_&name&_io+PAR0
loop2:
    mov AL, [BX]        ;; get 1 byte into AL
    out DX, AL          ;; write to PAR
    inc BX
    inc DX
    loop loop2
 
    IF c_wde_&name&_promiscuous NE 0
        mov AL, 0FFH
    ELSE
        xor AL, AL
    ENDIF
    mov CX, 8                   ;; set the multicast address to all 1/0's
    mov DX, c_wde_&name&_io+MAR0
loop3:
    out DX, AL
    inc DX
    loop loop3
 
    PORT_WRITE CURR, c_wde_&name&_io, STRT_PG+1  ;; Set input pointer for queue
 
    PORT_WRITE CMDR, c_wde_&name&_io, MSK_STA + MSK_PG0 + MSK_RD2
    ;; make sure we are on page 0  and start the NIC 8390
 
    xor AL, AL                              ;; loopback off
    PORT_WRITE TCR, c_wde_&name&_io
 
                          ;; set receiver mode
    IF c_wde_&name&_promiscuous ne 0
        mov AL, MSK_AB+MSK_AM+MSK_PRO             ;; promiscuous
    ELSE
        mov AL, MSK_AB                            ;; just broadcasts + to me
    ENDIF
    PORT_WRITE RCVR, c_wde_&name&_io
 
    RET
endif
ENDM
;;******************************************************************************
 
 
;;******************************************************************************
;;   IF_R_ACCESS name, no_packet
;;       IF_R_ACCESS waits for the next packet to come from the the board
;;       associated with 'name' and returns a pointer to the begining of
;;       an ethernet packet in BX:ES.  CX holds the length of the packet
;;       R_ACCESS jumps to 'no_packet' if there are no packets waiting to
;;       be read in
;; Registers:
;;	IN:	--
;;	OUT:	ES:BX=ptr to pkt, CX=len
;;	CHANGE: AX, BX, CX, DX, ES
;;	fast...

WDE_IF_R_ACCESS MACRO name, no_packet
    LOCAL inside
    LOCAL good_packet
    LOCAL wrapped
    LOCAL new_wrapped
    LOCAL bad_packet
    LOCAL ok_status
    LOCAL good_length
    LOCAL truncate
    .errb <no_packet>
 
    PORT_WRITE CMDR,c_wde_&name&_io,MSK_PG0+MSK_RD2;; read BNRY reg. into AL
    PORT_READ BNRY, c_wde_&name&_io
;;REG: AL=BNRY 
    inc AL                          ;; increment with wrap around
    cmp AL, c_wde_&name&_stop_pg
    jb inside		;; no need to wrap
    mov AL, STRT_PG
inside:
    mov BH, AL                      ;; save it in BH
 
    PORT_WRITE CMDR, c_wde_&name&_io, MSK_PG1+MSK_RD2 ;; read CURR reg. into AL
    PORT_READ CURR, c_wde_&name&_io
 
;;REG: AL=CURR, BH=succ(BNRY)
    cmp AL, BH
    je no_packet
 
    COUNT_CYCLE %(RX_BASE_CTR+name)   ;; count # pkt rx from name card
    mov byte ptr if_address[8*name+6],1 ; mark active...
    xor BL, BL                      ;; BX now holds pointer to packet
    mov DX, c_wde_&name&_shared_seg   ;; ES = segment address
    mov ES, DX
    mov AH, ES:[BX+c_wde_&name&_shared_off]   ;; get the status
    cmp AH, SMK_PRX                 ;; is it good
    jz ok_status
    cmp AH, SMK_PRX+SMK_PHY
    jnz bad_packet
 
ok_status:
    mov AH, ES:[BX+1+c_wde_&name&_shared_off] ;; pointer to the next packet
        ;; sanity check on next packet pointer AH
    cmp BH, AL                              ;; is BNDRY+1 <= CURR?
    ja wrapped
    cmp AH, BH
    jb bad_packet
    cmp AH, AL
    jbe good_packet
    jmp bad_packet
wrapped:
    cmp AH, BH
    jb new_wrapped
    cmp AH, c_wde_&name&_stop_pg
    jnb bad_packet
    jmp good_packet
new_wrapped:
    cmp AH, STRT_PG
    jb bad_packet
    cmp AH, AL
    jbe good_packet
bad_packet:
    COUNT_CYCLE %(BAD_RX_BASE+name)
    ;; set BNDRY = BNDRY+1 and try again
    PORT_WRITE CMDR, c_wde_&name&_io, MSK_PG0 + MSK_RD2 ;; page 0
 
    PORT_WRITE BNRY, c_wde_&name&_io, BH   ;; write the new BNRY register
    jmp no_packet                         ;; return bad status

good_packet:
 
    mov wde_&name&_data.wde_new_bndry, AH      ;; save it for R_FREE
    mov CX, ES:[BX+c_wde_&name&_shared_off+2]    ;; load the length
    add BX, c_wde_&name&_shared_off+4 ;; BX point to begining of the packet
    sub CX, 4
    cmp CX, 1536                               ;; sanity check
    jle good_length
    cmp CH, CL
    jne truncate
    xor CH, CH                         ;; fix western digital bug
    jmp good_length
truncate:
    mov CX, 1536
good_length:
    COUNT_CYCLE %(RX_BYTE_BASE+name), CX ;; XXX
ENDM
;;******************************************************************************
 
 
;;******************************************************************************
;;   IF_R_FREE  name
;;       After the client is through processing the packet returned by
;;       IF_R_ACCESS, IF_R_FREE must be called to inform 'name' that the
;;       memory that the packet was in can be reused for future packets.
;;
;; Registers:
;;	IN:	--
;;	OUT:	--
;;	CHNG:	AL, DX
;;	Fast

WDE_IF_R_FREE MACRO name
    LOCAL inside
    .errb <name>
 
    PORT_WRITE CMDR, c_wde_&name&_io, MSK_PG0 + MSK_RD2  ;; page 0
 
    mov AL, wde_&name&_data.wde_new_bndry       ;; Retrieve NEW_BOUNDRY
    dec AL
    cmp AL, STRT_PG
    jge inside
    mov AL, c_wde_&name&_stop_pg-1
inside:                         ;; write the new BNRY register
    PORT_WRITE BNRY, c_wde_&name&_io
ENDM
;;******************************************************************************
 
 
;;******************************************************************************
;;   WDE_IF_R_CONT name, ok
;;      IF_R_CONT determines if the packet returned by R_READ in BX:ES
;;      of length CX is contiguous (ES is unused). If it is it jumps
;;	to 'ok' otherwise
;;       it just returns
;;
;; Registers:
;;	IN:	BX=pkt offset, CX=pkt len
;;	OUT:	cy set if contiguous
;;	CHNG:	AX
;;	Fast

WDE_IF_R_CONT MACRO name, ok
    .errb <ok>
 
    mov AX, BX
    add AX, CX
    cmp AX, OFFSET c_wde_&name&_shared_off+c_wde_&name&_stop_pg*256
    jb ok
ENDM
;;******************************************************************************
 
 
;;******************************************************************************
;;   IF_W_ACCESS name, no_buffer
;;       IF_W_ACCESS returns a pointer to an output buffer for a packet.  The
;;       pointer is returned in DI:ES.  If the ouptut buffer is busy, this
;;       routine will jump to 'no_buffer'.  The output buffer  min(CX, 1536)
;;       bytes long
;;
;; It would be nice to be able to use a register as a name -- LR
;; Must preserve BX, SI, BP
;; Registers:
;;	IN:	--
;;	OUT:	ES:DI out buffer address
;;	CHNG:	AL, DX, DI, ES
;;	Busy waiting
WDE_IF_W_ACCESS MACRO name, no_buffer
    LOCAL wait_loop
    .errb <no_buffer>
 
    mov DX, c_wde_&name&_io + CMDR
    mov DI, 15000       ;; so we don't wait forever ; old value di=65000
    mov AL, byte ptr if_address[8*name+6] ;; status...
    and al,1 ;; packet transmitted byte
    jnz wait_loop ;; was successful
    mov DI, 1024 ;; short wait if not
wait_loop:
    dec DI
    jz no_buffer
    in al,dx
    test AL, MSK_TXP
    jnz wait_loop

    mov DI, c_wde_&name&_shared_off       ;; return DI:ES pointer
    mov DX, c_wde_&name&_shared_seg
    mov ES, DX
ENDM
;;******************************************************************************
 
 
;;******************************************************************************
;;   IF_W_WRITE name
;;       IF_W_WRITE actually signals the ethernet board to write a packet to
;;       the ethernet.  The packet is assumed to be in the buffer returned by
;;       IF_W_ACCESS. CX is the length of the packet to send.
;;
;; It would be nice to be able to use a register as a name -- LR
;;
;; Registers:
;;	IN:	CX=length
;;	OUT:	--
;;	CHNG:	AL, DX
;;	Very fast.
;;
;; Note: this could be changed by entering with the base c_wde_&name&_io in DX

WDE_IF_W_WRITE MACRO name
    .errb <name>
    mov SI, c_wde_&name&_io
    lea dx, [si+CMDR]
    mov al, MSK_PG0 + MSK_RD2        ;; make sure we are in register page 0
    out dx,al
    lea dx, [si+TSR]
    in al, dx
    mov byte ptr if_address[8*name+6],al ;; save tx status
    lea dx, [si+TBCR0]
    mov al,cl
    out dx,al ;; set length
    PORT_WRITE TBCR1, c_wde_&name&_io, CH
 
    xor AL, AL                        ;; tell card packet begins at page 0
    PORT_WRITE TPSR, c_wde_&name&_io
    PORT_WRITE CMDR, c_wde_&name&_io, MSK_TXP + MSK_RD2  ;; send the packet
ENDM
;;******************************************************************************
 
 
;;******************************************************************************
;;   IF_SET_ADDRESS name
;;       IF_SET_ADDRESS sets the hardware address to be the value
;;       pointed to by SI.  Note this function may be a no-op if the
;;       hardware address cannot be set (ETHERNET for example)
;;
;; 
WDE_IF_SET_ADDRESS MACRO name
    .err    ;; we don't support setting ethernet addresses (yet)
    ENDM
;;******************************************************************************
 
 
;;******************************************************************************
;;   IF_COPY name
;;      IF_COPY copys a packet from the input buffer (pointed
;;      to by SI and the immediate segment register given in IF_DECLARE)
;;	to an output
;;      buffer (pointed to by DI and dest_reg) of length CX.   It assumes the
;;      output buffer is contiguous.  (and the caller shouln't care if the
;;      input buffer is contiguous)
;;
;;	IN:	? imm_seg:SI=src pkt, CX=len, ES:DI=dest
;;	OUT:	--
;;	CHNG:	AX, CX, DX, SI, DI
 
WDE_IF_COPY MACRO name
    local wrap, nowrap, done, no_time1, no_time2
    .errb <name>
 
    mov DX, DS				;; save DS
    mov AX, c_wde_&name&_shared_seg	;; immediate
    mov DS, AX
 
    mov AX, OFFSET c_wde_&name&_shared_off+c_wde_&name&_stop_pg*256
    sub AX, SI				;; AX holds length to wrap line
    cmp AX, CX
    
    jae nowrap		;; new- dont wrap if AX >=  packet lenght
;;  jl wrap		;; original - wrap if AX less than packet lenght
;;  MEM_COPY ;; new
;;  jmp done		;; new
wrap:
    xchg AX, CX                       ;; length is now length to wrap line
    sub AX, CX                        ;; AX holds remainder
    MEM_COPY
 
    mov SI, OFFSET c_wde_&name&_shared_off+STRT_PG*256
    mov CX, AX
nowrap: 
    MEM_COPY
done:
    mov DS, DX                            ;; restore DS
ENDM
;;******************************************************************************
;; --------------- end of file ----------------
