/* --------------------------------------------------------------------
   Project: PAL: Palmtop Application Library
   Module:  SHOWTOP.C
   Author:  Dave Vickers
   Started: 20. Jan. 95
   Modified: 11. Aug. 99 (Jean-Jacques Moreau)
   Subject: Show top line of the screen
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                          standard includes
   -------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>

/* --------------------------------------------------------------------
                           local includes
   -------------------------------------------------------------------- */
#include "pal.h"
#include "palpriv.h"

/* --------------------------------------------------------------------
   ShowTopLine:
   Display a string on the top line of the HP display.
   Inputs:
      char *pTitle     - Title string for left  part of top line.
      char *pTime      - Title string for right part of top line.
                         (optional)
   Note: if two strings are given, one is displayed flush left and
   the other one flush right - if only one title is given, it will
   be centered.
   -------------------------------------------------------------------- */

void ShowTopLine(char *pTitle, char *pTime)
{
   if(!PalStateSaved++) SaveState(&PalState);
   SetColor(BLACK_COLOR);
   SetRule(FORCE_RULE);
   Rectangle(0, 0, MAX_X-1, 1+FNTD(SMALL_FONT), SOLID_FILL);

   SetColor(WHITE_COLOR);
   SetRule(TXT_RULE);
   SelectFont(SMALL_FONT);
   WriteText(pTime ? 0 : (MAX_X-FNTW(SMALL_FONT)*strlen(pTitle))/2,
             1, pTitle);
   if(pTime) {
      WriteText(MAX_X - 2 - (FNTW(SMALL_FONT) * strlen(pTime)), 1, pTime);
   }
   if(!--PalStateSaved) RestoreState(&PalState);
}


/* --------------------------------------------------------------------
   ShowTab:
   Display a centered string on the top line of the HP display.
   Inputs:
      char *pTitle     - Title string for center part of top line.
   -------------------------------------------------------------------- */

void ShowTab(char *pTitle)
{
   unsigned char AngleLeft[] = {
   0x01, 0x00, 0x01, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0xFF, 0xE0,
   0xFF, 0xC0, 0xFF, 0x80, 0xFF, 0x00, 0xFE, 0x00, 0xFC, 0x00,
   0xF8, 0x00, 0xF0, 0x00, 0xE0, 0x00, 0xC0, 0x00, 0x00, 0x00,
   0x00, 0x00,
   };

   unsigned char AngleRight[] = {
   0x01, 0x00, 0x01, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0F, 0xFF,
   0x07, 0xFF, 0x03, 0xFF, 0x01, 0xFF, 0x00, 0xFF, 0x00, 0x7F,
   0x00, 0x3F, 0x00, 0x1F, 0x00, 0x0F, 0x00, 0x07, 0x00, 0x03,
   0x00, 0x00,
   };

   if(!PalStateSaved++) SaveState(&PalState);
   SetColor(WHITE_COLOR);
   SetRule(FORCE_RULE);
   Rectangle(213, 0, MAX_X-213, 1+FNTD(SMALL_FONT), SOLID_FILL);

   PutImg(213-6, 0, FORCE_RULE, (IMGHDR*)AngleLeft);;
   PutImg(MAX_X-213-6, 0, FORCE_RULE, (IMGHDR*)AngleRight);;

   SetColor(BLACK_COLOR);
   SetRule(TXT_RULE);
   SelectFont(SMALL_FONT);
   WriteText((MAX_X-FNTW(SMALL_FONT)*strlen(pTitle))/2, 1, pTitle);
   if(!--PalStateSaved) RestoreState(&PalState);
}