' STRING.BAS  10.06.2003

function istr.bsrchas(carr(), cstr1, ibeg, iend, ipos, ilen, icas)
   '
   '  IN: carr() - string array to be searched (must be sorted, ascending).
   '      cstr1  - string to search for in string array carr().
   '      ibeg   - search begins at this index in the array.
   '      iend   - search ends at this index in the array.
   '      ipos   - search begins at this position in each array element.
   '      ilen   - to compare whole strings, set to max.value (i.e. 9999),
   '               else pad cstr1 to ilen bytes (compare length = ilen).
   '      icas   - TRUE if search is case-sensitive.
   '
   ' OUT: function returns array position if match found, else returns -1.
   '
   itop = iend + 1                           'set top position of binary search
   ilow = ibeg - 1                           'set low position of binary search
   while itop - ilow > 1                     'loop until mid position not avail.
      imid = ilow + (itop - ilow) \ 2        'set mid position of binary search
      if icas then                            'case-sensitive flag is set to ON
         if cstr1 <= mid$(carr(imid), ipos, ilen) then'search string l.e. target
            itop = imid                     'move search to lower part of range
         else                                'search string is g.t. target data
            ilow = imid                     'move search to upper part of range
         end if
      else                                   'case-sensitive flag is set to OFF
         if ucase$(cstr1) <= ucase$(mid$(carr(imid), ipos, ilen)) then'<=target
            itop = imid                     'move search to lower part of range
         else                                'search string is g.t. target data
            ilow = imid                     'move search to upper part of range
         end if
      end if
   wend
   if itop > iend then                    'search moved beyond top end of range
      itop = iend                         'set top position to top end of range
   end if
   if icas then                               'case-sensitive flag is set to ON
      if cstr1 = mid$(carr(itop), ipos, ilen) then  'search string==target data
         istr.bsrchas = itop              'return array position = top position
      else                            'search string does NOT equal target data
         istr.bsrchas = -1          'set return array position=zero (NOT found)
      end if
   else                                      'case-sensitive flag is set to OFF
      if ucase$(cstr1) = ucase$(mid$(carr(itop), ipos, ilen)) then'=target data
         istr.bsrchas = itop              'return array position = top position
      else                            'search string does NOT equal target data
         istr.bsrchas = -1          'set return array position=zero (NOT found)
      end if
   end if
end function

function lstr.bsrchfs(cbuf, cstr1, lbeg, lend, ipos, ifil, icas)
   '  IN: cbuf  - file buffer to be searched (must be sorted, ascending).
   '      cstr1 - string to search for in cbuf (pad to fixed length).
   '      lbeg  - search begins at this byte position in the file.
   '      lend  - search ends at this byte position in the file.
   '      ipos  - search begins at this position in cbuf buffer.
   '      ifil  - DOS file number for the file to be searched.
   '      icas  - TRUE if search is case-sensitive.
   '
   ' OUT: function returns file position if match found, else returns -1.
   '
   ibuflen = len(cbuf)                     'record length same as buffer length
   ltop = lend + ibuflen                     'set top position of binary search
   llow = lbeg - ibuflen                     'set low position of binary search
   ilen = len(cstr1)                       'get the length of the search string
   while ltop - llow > ibuflen               'loop until mid position not avail.
      lmid = llow + ((ltop - llow) \ (ibuflen * 2)) * ibuflen 'set mid position
      get ifil, lmid, cbuf                    'load target data at mid position
      if icas then                            'case-sensitive flag is set to ON
         if cstr1 <= mid$(cbuf, ipos, ilen) then'search string l.e. target data
            ltop = lmid                     'move search to lower part of range
         else                                'search string is g.t. target data
            llow = lmid                     'move search to upper part of range
         end if
      else                                   'case-sensitive flag is set to OFF
         if ucase$(cstr1) <= ucase$(mid$(cbuf, ipos, ilen)) then'search<=target
            ltop = lmid                     'move search to lower part of range
         else                                'search string is g.t. target data
            llow = lmid                     'move search to upper part of range
         end if
      end if
   wend
   if ltop > lend then                    'search moved beyond top end of range
      ltop = lend                         'set top position to top end of range
   end if
   get ifil, ltop, cbuf                       'load target data at top position
   if icas then                               'case-sensitive flag is set to ON
      if cstr1 = mid$(cbuf, ipos, ilen) then  'search string equals target data
         lstr.bsrchfs = ltop             'return record position = top position
      else                            'search string does NOT equal target data
         lstr.bsrchfs = -1         'set return record position=zero (NOT found)
      end if
   else                                      'case-sensitive flag is set to OFF
      if ucase$(cstr1) = ucase$(mid$(cbuf, ipos, ilen)) then  'search == target
         lstr.bsrchfs = ltop             'return record position = top position
      else                            'search string does NOT equal target data
         lstr.bsrchfs = -1         'set return record position=zero (NOT found)
      end if
   end if
end function

function istr.fmti(cfldval, cfldtyp, ifldlen)   'reformat to internal data type
   select case cfldtyp                               'select on data field type
      case "A"                                            'ASCII byte (0 - 255)
         ifldval = pdqvali(cfldval)                   'convert string to number
         cfldval = char(ifldval)                'convert number to Btrieve data
      case "D"                                  'Btrieve date field type (DMYY)
         idateok = 0                              'initialize valid date format
         ipos1 = istr.lnsp(1, cfldval)             'position of first separator
         if ipos1 = 2 or ipos1 = 3 or ipos1 = 5 then '1st date segment is valid
            csep = mid$(cfldval, ipos1, 1)           'date separation character
            if instr("|-./", csep) > 1 then          'separator char. was valid
               ipos2 = istr.lnsp(ipos1 + 1, cfldval) 'position of 2nd separator
               if ipos2 = ipos1 + 2 or ipos2 = ipos1 + 3 then'2nd segment valid
                  if mid$(cfldval, ipos2, 1) = csep then  '1st & 2nd sep. match
                     ipos3 = istr.lnsp(ipos2 + 1, cfldval)  '3rd separator posn.
                     if ipos3 = ipos2 + 2 or ipos3 = ipos2 + 3 _
                     or ipos3 = ipos2 + 5 then       '3rd date segment is valid
                        if ipos1 = 5 and ipos3 <= ipos2 + 3 then'yyyy/m/d format
                           idateok = 3                  'return yyyy/m/d format
                           iyears = pdqvali(mid$(cfldval, 1, 4))
                           imonth = pdqvali(mid$(cfldval, ipos1 + 1, 2))
                           idayno = pdqvali(mid$(cfldval, ipos2 + 1, 2))
                        elseif ipos1 <= 3 then         'm/d/yy or d/m/yy format
                           iyears = pdqvali(mid$(cfldval, ipos2 + 1, _
                                                 ipos3 - ipos2 - 1))
                           if csep = "." then              'd/m/yy format found
                              idateok = 2                 'return d/m/yy format
                              imonth = pdqvali(mid$(cfldval, ipos1 + 1, 2))
                              idayno = pdqvali(mid$(cfldval, 1, 2))
                           else                            'm/d/yy format found
                              idateok = 1                 'return m/d/yy format
                              imonth = pdqvali(mid$(cfldval, 1, 2))
                              idayno = pdqvali(mid$(cfldval, ipos1 + 1, 2))
                           end if
                        end if
                     end if
                  end if
               end if
            end if
         end if
         if idateok then                        'separators and numerics are OK
            if iyears >= 80 and iyears <= 99 then       '2-digit year 1980-1999
               iyears = iyears + 1900                     'add century to years
            elseif iyears >= 0 and iyears <= 79 then    '2-digit year 2000-2079
               iyears = iyears + 2000                     'add century to years
            end if
            if imonth < 1 or imonth > 12 _               'month value NOT valid
            or idayno < 1 or idayno > 31 _               'dayno value NOT valid
            or iyears < 1900 or iyears > 2099 then       'years value NOT valid
               idateok = 0                        'set date format to NOT valid
            end if
         end if
         if idateok = 0 then                          'this is NOT a valid date
            idayno = 0                                    'default to zero days
            imonth = 0                                  'default to zero months
            iyears = 0                                   'default to zero years
         end if
         cfldval = char(idayno) + char(imonth) + mki$(iyears)  'format the date
      case "I"                                           'Integer (up to 32767)
         ifldval = pdqvali(cfldval)                   'convert string to number
         cfldval = mki$(ifldval)                'convert number to Btrieve data
      case "I4", _                                       'IEEE single-precision
           "I8", _                                       'IEEE double-precision
           "M4", _                                        'MBF single-precision
           "M8"                                           'MBF double-precision
         dfldval = dfn.round(val(cfldval), 7)         'convert string to number
         if dfldval = 0 then                           'value of number is zero
            cfldval = string$(midchar(cfldtyp, 2) - 48, 0)  'return ASCII zeros
         elseif cfldtyp = "I4" then                      'IEEE single-precision
            cfldval = mks$(dfldval)             'convert number to Btrieve data
         elseif cfldtyp = "I8" then                      'IEEE double-precision
            cfldval = mkd$(dfldval)             'convert number to Btrieve data
         elseif cfldtyp = "M4" then                       'MBF single-precision
            cfldval = cmks(csng(dfldval))       'convert number to Btrieve data
         else  'cfldtyp = "M8"                            'MBF double-precision
            cfldval = cmkd(dfldval)             'convert number to Btrieve data
         end if
      case "L"                                     'Long Int (up to 2147483647)
         lfldval = pdqvall&(cfldval)                  'convert string to number
         cfldval = mkl$(lfldval)                'convert number to Btrieve data
      case "T"                                  'Btrieve time field type (SSMH)
         ihours = pdqvali(mid$(cfldval, 1, 2))                     'hours field
         iminno = pdqvali(mid$(cfldval, 4, 2))                   'minutes field
         isecno = pdqvali(mid$(cfldval, 7, 2))                   'seconds field
         cfldval = char(0) + char(isecno) + char(iminno) + char(ihours)
      case else                                     'String and all other types
         if left$(cfldtyp, 1) = "S" then                'String data type field
            ctmp1 = cfldval                            'make copy of field data
            cfldval = space$(ifldlen)              'create correct-length field
            lset cfldval = ctmp1                'put field data copy into field
         else                                'user specified invalid field type
            i = ifn.msgs("Unspecified field type: " + cfldtyp, 5, 24, 79, 1, 1)
         end if                         'display error message [above] and exit
   end select
end function

function istr.fmtx(cfldval, cfldtyp, dfactor, iround, isql)  'reformat external
   select case cfldtyp                               'select on data field type
      case "A"                                            'ASCII byte (0 - 255)
         ifldval = asc(cfldval)                         'convert byte to number
         cfldval = ltrim$(str$(ifldval))              'convert number to string
      case "D"                                        'Btrieve date type (DMYY)
         idayno = asc(mid$(cfldval, 1, 1))                      'date day field
         imonth = asc(mid$(cfldval, 2, 1))                    'date month field
         iyears = cvi(mid$(cfldval, 3, 2))                     'date year field
         if imonth < 1 or imonth > 12 _                          'invalid month
         or idayno < 1 or idayno > 31 _                       '..or invalid day
         or iyears < 1900 or iyears > 2099 then              '..or invalid year
            if isql then                                    'output format=SQL7
               cfldval = "01/01/1900"                      'delault SQL7 format
            elseif imonth + idayno + iyears = 0 then        'date is empty/NULL
               cfldval = "  /  /    "                      'delault date format
            else                                         'date has invalid data
               cfldval = "**/**/****"                     'delault error format
            end if
         else                                     'month day and year are valid
            cfldval = right$("0"   + ltrim$(str$(imonth)), 2) + "/" + _
                      right$("0"   + ltrim$(str$(idayno)), 2) + "/" + _
                      right$("000" + ltrim$(str$(iyears)), 4)  'format the date
         end if
      case "I"                                           'Integer (up to 32767)
         ifldval = cvi(cfldval)                      'convert integer to number
         cfldval = ltrim$(str$(ifldval))              'convert number to string
      case "I4", _                                       'IEEE single-precision
           "I8", _                                       'IEEE double-precision
           "M4", _                                        'MBF single-precision
           "M8"                                           'MBF double-precision
         if cfldtyp = "I4" then                          'IEEE single-precision
            dfldval = cvs(cfldval)                      'convert data to number
         elseif cfldtyp = "I8" then                      'IEEE double-precision
            dfldval = cvd(cfldval)                      'convert data to number
         elseif cfldtyp = "M4" then                       'MBF single-precision
            dfldval = fcvs(cfldval)                     'convert data to number
         else  'cfldtyp = "M8"                            'MBF double-precision
            dfldval = dcvd(cfldval)                     'convert data to number
         end if
         if dfn.round(dfactor, 7) <> 0 then           'factor value is non-zero
            dfldval = dfldval * dfactor               'multiply value by factor
         end if
         if abs(dfldval) > 9999999999# then            'value is outside range!
            dfldval = 9999999999# * sgn(dfldval)        'reset value to maximum
         elseif abs(dfldval) < .0000000001# then       'value is outside range!
            dfldval = 0                                 'reset value to minimum
         else                                            'value is within range
            dfldval = dfn.round(dfldval, abs(iround))     'round returned value
         end if
         cfldval = ltrim$(str$(dfldval))              'convert number to string
         idecpos = instr(cfldval, ".")                  'decimal point position
         if idecpos then                               'decimal point was found
            ideclen = abs(iround) - (len(cfldval) - idecpos) 'dec. places req'd.
            if ideclen > 0 and iround > 0 then        'OK to add decimal places
               cfldval = cfldval + string$(ideclen, "0")    'add decimal places
            elseif ideclen < 0 then                      'too many extra places
               cfldval = left$(cfldval, len(cfldval) + ideclen)  'remove extras
            end if
         elseif iround > 0 then                        'decimal places required
            cfldval = cfldval + "." + string$(iround, "0")  'add decimal places
         end if
      case "L"                                     'Long Int (up to 2147483647)
         lfldval = cvl(cfldval)                      'convert longint to number
         cfldval = ltrim$(str$(lfldval))              'convert number to string
      case "T"                                        'Btrieve time type (SSMH)
         if cstr.trim(cfldval) = "" then                 'time is zero or blank
            cfldval = string$(4, 0)                        'set Btrieve default
         end if
         ihours = asc(mid$(cfldval, 4, 1))                         'hours field
         iminno = asc(mid$(cfldval, 3, 1))                       'minutes field
         isecno = asc(mid$(cfldval, 2, 1))                       'seconds field
         if ihours > 23 or iminno > 59 or isecno > 59 _
         or ihours + iminno + isecno = 0 then                     'invalid time
            if isql then                                 'output format is SQL7
               ihours = 12                                   'set default hours
               iminno = 0                                  'set default minutes
               isecno = 0                                  'set default seconds
            else                                        'output format NOT SQL7
               ihours = 0                                    'set default hours
               iminno = 0                                  'set default minutes
               isecno = 0                                  'set default seconds
            end if
         end if
         cfldval = right$("0" + ltrim$(str$(ihours)), 2) + ":" + _
                   right$("0" + ltrim$(str$(iminno)), 2) + ":" + _
                   right$("0" + ltrim$(str$(isecno)), 2)       'format the time
      case else                                  'all other non-specified types
         if left$(cfldtyp, 1) = "S" then                'String data type field
            cfldval = cstr.trim(cfldval)         'strip nulls&blanks from field
            if cfldval = "" and isql then        'String field is empty or null
               cfldval = " "                    'set output value to string=' '
            end if
         else                                'user specified invalid field type
            i = ifn.msgs("Unspecified field type: " + cfldtyp, 5, 24, 79, 1, 1)
         end if                         'display error message [above] and exit
   end select
end function

function istr.isdate(cfldval)             'return status for valid date formats

   ' NOTE: This function does NOT validate the date, just the date format.
   '
   '  IN: cfldval - possible date in y/m/d, d/m/y, or m/d/y format
   '
   ' OUT: 0 = not a valid date
   '      1 = m/d/yy or m/d/yyyy
   '      2 = d/m/yy or d/m/yyyy
   '      3 = yyyy/m/d       NOTE: year must be 4 digits for year-first formats

   idateok = 0                               'preset non-valid date format type
   ipos1 = istr.lnsp(1, cfldval)                   'position of first separator
   if ipos1 = 2 or ipos1 = 3 or ipos1 = 5 then     '1st separator posn.is valid
      csep = mid$(cfldval, ipos1, 1)                 'date separation character
      if instr("|-./", csep) > 1 then                'separator char. was valid
         ipos2 = istr.lnsp(ipos1 + 1, cfldval)       'position of 2nd separator
         if ipos2 = ipos1 + 2 or ipos2 = ipos1 + 3 then'2nd separator pos.valid
            if mid$(cfldval, ipos2, 1) = csep then   '1st & 2nd separator match
               ipos3 = istr.lnsp(ipos2 + 1, cfldval) 'position of 3rd separator
               if ipos3 = ipos2 + 2 or ipos3 = ipos2 + 3 or ipos3 = ipos2 + 5 then
                  if ipos1 = 5 and ipos3 <= ipos2 + 3 then     'yyyy/m/d format
                     idateok = 3                        'return yyyy/m/d format
                  elseif ipos1 <= 3 then               'm/d/yy or d/m/yy format
                     if csep = "." then                    'd/m/yy format found
                        idateok = 2                       'return d/m/yy format
                     else                                  'm/d/yy format found
                        idateok = 1                       'return m/d/yy format
                     end if
                  end if
               end if
            end if
         end if
      end if
   end if
   istr.isdate = idateok      'return valid date format or not valid (0) status
end function

function istr.isnumber(cfldval)                'return status for valid numbers

   '  IN: cfldval - possible number, possibly negative, possible decimal places
   '
   ' OUT: 0 = not a valid number
   '      1 = integer number, positive
   '      2 = integer number, negative
   '      3 = float number, positive
   '      4 = float number, negative

   inumber = 0                             'preset non-valid number format type
   ilength = len(cfldval)                     'get length of passed field value
   ibegpos = istr.lcsp(1, cfldval, " ")        'position of the first character
   iendpos = istr.rcsp(ilength, cfldval, " ")   'position of the last character
   if ibegpos <= iendpos then                    'non-blank character(s) found!
      if midchar(cfldval, ibegpos) = 45 then        'a negative sign was found!
         inegpos = ibegpos                          'set negative sign position
      else                                        'negative sign was not found!
         inegpos = ibegpos - 1                  'set negative posn. < fld.begin
      end if
      idecpos = istr.rcfn(iendpos, cfldval, ".") 'initialize posn. of dec.point
      if idecpos = 0 then                        'a decimal point was not found
         idecpos = iendpos + 1                    'set dec.point > end of field
      end if
      if istr.rcfn(idecpos - 1, cfldval, ".") = 0 then 'only one decimal point!
         for ipos = inegpos + 1 to iendpos      'loop thru non-blank characters
            ichr = midchar(cfldval, ipos)        'character at current position
            select case ichr                     'select char.@current position
               case 44                            'digit separ. (",") character
                  if ipos > idecpos or (idecpos - ipos) mod 4 > 0 then
                     inumber = 0                  'set valid number value FALSE
                     exit for                     'number not valid - exit loop
                  end if
               case 46                           'decimal point (".") character
               case 48 to 57                       'digit ("0" - "9") character
                  inumber = 1                      'set valid number value TRUE
               case else                         'invalid character @ position?
                  if inumber then               'valid number already indicated
                     if iendpos = ipos + 3 then  'field terminates after 'E-0n'
                        if ucase$(mid$(cfldval, ipos, 2)) = "E-" then 'exponent
                           if istr.lnsp(ipos + 2, cfldval) = ipos + 4 then
                              iexp = pdqvali(mid$(cfldval, ipos + 2, 2))'getExp.
                              if iexp >= 1 and iexp <= 39 then  'valid exponent
                                 exit for   'end of field; no. w/exponent valid
                              end if
                           end if
                        end if
                     end if
                  end if
                  inumber = 0                     'set valid number value FALSE
                  exit for                        'number not valid - exit loop
            end select
         next
         if inumber then                             'a valid number was found!
            if inegpos = ibegpos then                'number found is negative!
               inumber = inumber + 1                 'add the negative property
            end if
            if idecpos <= iendpos then         'number found is floating point!
               inumber = inumber + 2           'add the floating point property
            end if
         end if
      end if
   end if
   istr.isnumber = inumber  'return valid number format or not valid (0) status
end function

function istr.lcfn(iofs, cstr1, cchr)     'get position of first cchr from left
   ichr = asc(cchr)                                    'get ASCII value of cchr
   for ipos = iofs to len(cstr1)                     'loop thru cstr1 from left
      if midchar(cstr1, ipos) = ichr then         'match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   istr.lcfn = ipos                                   'return matching position
end function

function istr.lcsp(iofs, cstr1, cchr)     'get pos. of first non-cchr from left
   ichr = asc(cchr)                                    'get ASCII value of cchr
   for ipos = iofs to len(cstr1)                     'loop thru cstr1 from left
      if midchar(cstr1, ipos) <> ichr then    'non-match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   istr.lcsp = ipos                                  'return non-match position
end function

function istr.lnsp(iofs, cstr1)           'get pos. of first non-num. from left
   for ipos = iofs to len(cstr1)                     'loop thru cstr1 from left
      ichr = midchar(cstr1, ipos)                      'get ASCII value of cchr
      if ichr < 48 or ichr > 57 then          'non-match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   istr.lnsp = ipos                                  'return non-match position
end function

function istr.lnspc(iofs, cstr1)          'get pos. of first non-num. from left
   ibeg = istr.lcsp(iofs, cstr1, " ")       'skip past any leading blank spaces
   for ipos = ibeg to len(cstr1)                     'loop thru cstr1 from left
      ichr = midchar(cstr1, ipos)                      'get ASCII value of cchr
      if not(ichr >= 48 and ichr <= 57 or ichr = 44) then     'non-match found!
         exit for                                         'exit the search loop
      end if
   next
   istr.lnspc = ipos                                 'return non-match position
end function

function istr.lnspf(iofs, cstr1)          'get pos. of first non-num. from left
   ibeg = istr.lcsp(iofs, cstr1, " ")       'skip past any leading blank spaces
   for ipos = ibeg to len(cstr1)                     'loop thru cstr1 from left
      ichr = midchar(cstr1, ipos)                      'get ASCII value of cchr
      if not(ichr >= 48 and ichr <= 57 or ichr = 46) then     'non-match found!
         exit for                                         'exit the search loop
      end if
   next
   istr.lnspf = ipos                                 'return non-match position
end function

function istr.rcfn(iofs, cstr1, cchr)    'get position of first cchr from right
   ichr = asc(cchr)                                    'get ASCII value of cchr
   for ipos = iofs to 1 step -1                     'loop thru cstr1 from right
      if midchar(cstr1, ipos) = ichr then         'match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   istr.rcfn = ipos                                   'return matching position
end function

function istr.rcsp(iofs, cstr1, cchr)    'get pos. of first non-cchr from right
   ichr = asc(cchr)                                    'get ASCII value of cchr
   for ipos = iofs to 1 step -1                     'loop thru cstr1 from right
      if midchar(cstr1, ipos) <> ichr then    'non-match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   istr.rcsp = ipos                                  'return non-match position
end function

function istr.rnsp(iofs, cstr1)          'get pos. of first non-num. from right
   for ipos = iofs to 1 step -1                     'loop thru cstr1 from right
      ichr = midchar(cstr1, ipos)                      'get ASCII value of cchr
      if ichr < 48 or ichr > 57 then          'non-match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   istr.rnsp = ipos                                  'return non-match position
end function

function istr.rnspc(iofs, cstr1)         'get pos. of first non-num. from right
   iend = istr.rcsp(iofs, cstr1, " ")      'skip past any trailing blank spaces
   for ipos = iend to 1 step -1                     'loop thru cstr1 from right
      ichr = midchar(cstr1, ipos)                      'get ASCII value of cchr
      if not(ichr >= 48 and ichr <= 57 or ichr = 44) then     'non-match found!
         exit for                                         'exit the search loop
      end if
   next
   istr.rnspc = ipos                                 'return non-match position
end function

function istr.rnspf(iofs, cstr1)         'get pos. of first non-num. from right
   iend = istr.rcsp(iofs, cstr1, " ")      'skip past any trailing blank spaces
   for ipos = iend to 1 step -1                     'loop thru cstr1 from right
      ichr = midchar(cstr1, ipos)                      'get ASCII value of cchr
      if not(ichr >= 48 and ichr <= 57 or ichr = 46) then     'non-match found!
         exit for                                         'exit the search loop
      end if
   next
   istr.rnspf = ipos                                 'return non-match position
end function

function istr.rsfn(iofs, cstr1, cfnd)    'get position of first cfnd from right
   ilen = len(cfnd)                                'get length of search string
   for ipos = iofs to 1 step -1                     'loop thru cstr1 from right
      if mid$(cstr1, ipos, ilen) = cfnd then      'match found at position ipos
         exit for                                         'exit the search loop
      end if
   next
   istr.rsfn = ipos                                   'return matching position
end function

function istr.rcmt(clin)              'remove comment text from BASIC code line
   icmt = instr(clin, char(39))          'position of comment character in line
   iqt2 = 0                          'set iqt2 for initialization of iqt1 below
   do                          'begin loop to find non-quoted comment character
      iqt1 = instr(iqt2 + 1, clin, char(34))   '1st double-quote char. position
      iqt2 = instr(iqt1 + 1, clin, char(34))   '2nd double-quote char. position
      if icmt > 0 and (icmt < iqt1 or iqt1 = 0) then   'comment character found
         exit do                 'valid comment position established; exit loop
      end if            'else: comment not found or follows 1st quote character
      if iqt2 = 0 then        'quote characters NOT found or unterminated quote
         icmt = len(clin) + 1           'set virtual comment position to EOL +1
         exit do                       'comment position established; exit loop
      end if                  'else: double-quote characters found in text line
      if icmt > 0 and icmt < iqt2 then  'comment character surrounded by quotes
         icmt = instr(iqt2 + 1, clin, char(39)) 'position of next comment char.
      end if              'NOTE: Don't exit loop when iqt1 > 0 and iqt1 < icmt,
   loop                   '      i.e., when first quote occurs prior to comment
   lset clin = left$(clin, icmt - 1)  'remove comment text from BASIC code line
end function

function istr.sort(cstr1(), itot)         'sort a zero-based-index string array
   'Note: istr.sort sorts zero-based-index arrays. 'itot' is the
   '      total of elements and not the upper bound of the array.
   irdx = itot \ 2                  'initialize sort radix to midpoint of array
   while irdx > 0                     'loop until radix reaches a value of zero
      for itap = 0 to (itot - irdx - 1)            'loop thru top part of array
         for ilap = itap to 0 step -irdx           'loop thru low part of array
            if cstr1(ilap) > cstr1(ilap + irdx) then'low value>high-index value
               swap cstr1(ilap), cstr1(ilap + irdx)'swap lower value/high value
            else                                 'low value <= high-index value
               exit for                          'no swap here; exit inner loop
            end if
         next
      next
      irdx = irdx \ 2              'divide radix by 2; test for > 0 at loop end
   wend
end function

function istr.sort2(cstr1(), cstr2(), itot)'sort zero-based-index string arrays
   'Note: istr.sort sorts zero-based-index arrays. 'itot' is the
   '      total of elements and not the upper bound of the array.
   irdx = itot \ 2                  'initialize sort radix to midpoint of array
   while irdx > 0                     'loop until radix reaches a value of zero
      for itap = 0 to (itot - irdx - 1)            'loop thru top part of array
         for ilap = itap to 0 step -irdx           'loop thru low part of array
            if cstr1(ilap) > cstr1(ilap + irdx) then'low value>high-index value
               swap cstr1(ilap), cstr1(ilap + irdx)'swap lower value/high value
               swap cstr2(ilap), cstr2(ilap + irdx)'swap lower value/high value
            else                                 'low value <= high-index value
               exit for                          'no swap here; exit inner loop
            end if
         next
      next
      irdx = irdx \ 2              'divide radix by 2; test for > 0 at loop end
   wend
end function

function cstr.trim(cstr1) static          'trim blanks and ASCII 0's from cstr1
   for ibeg = 1 to len(cstr1)               'loop thru the target string buffer
      ichr = midchar(cstr1, ibeg)           'current character in string buffer
      if ichr <> 32 and ichr <> 0 THEN  'current character non-zero & non-blank
         exit for             'exit loop with non-zero/non-blank begin position
      end if
   next
   for iend = len(cstr1) to ibeg step -1    'loop thru the target string buffer
      ichr = midchar(cstr1, iend)           'current character in string buffer
      if ichr <> 32 and ichr <> 0 THEN  'current character non-zero & non-blank
         exit for               'exit loop with non-zero/non-blank end position
      end if
   next
   cstr.trim = mid$(cstr1, ibeg, iend - ibeg + 1) 'return left- & right-trimmed
end function
