'/* CALLIST2.BAS Make call tree from BASIC program and procedure list */
'/*              By: Dale Thorn                                       */
'/*              Rev. 22.02.2001                                      */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'getdir.h'
'$include: 'getline.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'

type cpas                             'structure for params passed to functions
   ccurfil as string * 60                 'current filename open for processing
   ccurpos as string * 8                 'current process byte position in file
   ccurprc as string * 60                    'current procedure being processed
   cstklvl as string * 2                   'current process level (string form)
   ifilno1 as integer                      'DOS handle for current process file
   ifilno2 as integer                        'DOS handle for the procedure file
   ifilno3 as integer                      'DOS handle for the text output file
   ifilno4 as integer                       'DOS handle for miscellaneous files
   ilinlen as integer                      'length of current process text line
   ilinpos as integer                       'position in curr.process text line
   ilv1prc as integer                       'TRUE if processing base-level proc.
   imaxlvl as integer                         'maximum stack level we processed
   ioffset as integer                        'offset for current line in buffer
   istklvl as integer                      'current stack level being processed
   lcurpos as long                       'current process byte position in file
   lsavpos as long                       'saved copy of 'lcurpos' byte position
   ltopptr as long                     'current byte position in procedure file
end type

declare function ifn.pushstk(cp as cpas, cbuf2, cindent, cstk, ctempfile)
declare function ifn.rbldlevel(cp as cpas, cbuf, lcnt, ilvl)
declare function ifn.rbldlist(cp as cpas, cbuf, lcnt)
declare function io.ktst(inop)

'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'getdir.bas'
'$include: 'getline.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

dim cp as cpas                        'initialize the pass-parameters structure
dim cvbp(128)                        'initialize VB project .VBP contents array

cls                                                'clear the DOS window screen
ccmd = ucase$(rtrim$(command$))             'get user's command-line parameters
if ccmd = "" then                            'user did NOT enter a command line
   cmsg = "Usage:  CALLIST2  filename    "        'set the initial message text
   ctmp = space$(4)                                 'set the left margin spaces
   locate 5, 1, 1                                   'locate cursor for messages
   print ctmp; cmsg                                 'display first user message
   mid$(cmsg, 1) = space$(6)                      'blank 'Usage:' in msg.string
   mid$(cmsg, len(cmsg) - 2) = "/A"                'insert '/A' into msg.string
   print ctmp; cmsg                                'display second user message
   mid$(cmsg, len(cmsg) - 2) = "/N"                'insert '/N' into msg.string
   print ctmp; cmsg                                 'display third user message
   print                                           'blank line between messages
   print                                           'blank line between messages
   print ctmp; "If '/A' specified, process all duplicate calls for output list"
   print ctmp; "If '/N' specified, do not allow duplicate calls in output list"
   print ctmp; "If no switch specified, allow duplicate calls <= current level"
   close                                                  'close all open files
   system                                           'return to operating system
end if

ipos1 = instr(ccmd, "/A")         'check selection to allow ALL duplicate calls
ipos2 = instr(ccmd, "/N")          'check selection to allow NO duplicate calls
if ipos1 then                       'user selected to allow ALL duplicate calls
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))   'remove '/A'
   idup = 2                          'set the flag to allow ALL duplicate calls
elseif ipos2 then                    'user selected to allow NO duplicate calls
   ccmd = rtrim$(left$(ccmd, ipos2 - 1) + mid$(ccmd, ipos2 + 2))   'remove '/N'
   idup = 0                           'set the flag to allow NO duplicate calls
else                        'user did NOT make a selection; set flag to default
   idup = 1             'set the flag to allow duplicate calls <= current level
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if len(cnam) = 0 or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") _
or iprm >= 0 then        'user gave an invalid filename or supplied a parameter
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)
end if                       'display invalid-filename message [above] and exit
clst = "Callist1.txt"          'initialize the name for the procedure list file
cdst = "Callist2.txt"          'initialize the name for the call tree list file

i = ifn.open(cp.ifilno1, cfil, "B", lof1)      'open source file in binary mode
if lof1 < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1) 'display error msg. & exit
elseif lof1 = 0 then                          'source file nonexistent or empty
   i = ifn.kill(cp.ifilno1, cfil)                    'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)
end if                              'display the error message [above] and exit
i = ifn.open(cp.ifilno2, clst, "B", lof2)   'open procedure file in binary mode
if lof2 = 0 then                           'procedure file nonexistent or empty
   i = ifn.kill(cp.ifilno2, clst)          'kill the zero-length procedure file
   i = ifn.msgs(clst + " not found", 5, 24, 79, 1, 1)
end if                              'display the error message [above] and exit
llstcount = lof2 \ 134               'no. of records in the procedure list file
cp.ifilno3 = freefile                 'get next DOS file handle for output file
open cdst for output as cp.ifilno3     'open call tree list file in output mode

i = ifn.msgs("Processing: ", 5, 24, 79, 0, 0)'display user message and continue

shell "dir " + cfil + " > dsrc.dir"       'get the full path of the source file
cp.ifilno4 = freefile                      'get next DOS handle for temp. files
open "dsrc.dir" for input as cp.ifilno4    'open the temp file to find the path
do                                         'loop thru temp file to get the path
   line input #cp.ifilno4, cfilepath        'read a new line from the temp file
   i = ifn.gdirhdr(cfilepath)               'try to extract path from text line
loop while cfilepath = ""                    'loop until source file path found
lset cfilepath = ucase$(cfilepath)            'uppercase the source file's path
cfil = cfilepath + ucase$(cnam + "." + cext)   'rebuild from full path+filename
close cp.ifilno4                                'completed; close 1st temp file

i = ifn.gdir("dsrc.dir", cvbpfil, "", "", cfilepath + "*.vbp", 0, 0, 0)
i = ifn.kill(cp.ifilno4, "dsrc.dir")            'completed; close the temp file
ivbpmax = -1                                    'initialize VBP() array maximum
if cvbpfil <> "" then                             '.VBP' file found in filepath
   open cfilepath + cvbpfil for input as cp.ifilno4    'open target '.VBP' file
   while not eof(cp.ifilno4)                       'loop thru all lines in file
      line input #cp.ifilno4, clin                  'read line from '.VBP' file
      clin = ucase$(rtrim$(clin))                    'uppercase and r'trim line
      'Note on Instr() call below: BASIC will return a position of one (1) if
      'the 2nd parameter is a zero-length string, hence a test for posn. > 1.
      if instr("|.BAS|.CLS|.FRM", right$(clin, 4)) > 1 then 'target file found!
         ipos1 = instr(clin, "=")                    '=' char. position in line
         ipos2 = instr(clin, ";")                    ';' char. position in line
         if ipos1 < ipos2 then                       '=' char.occurs before ';'
            ipos1 = ipos2                             'set position to ';' posn.
         end if
         clin = ltrim$(mid$(clin, ipos1 + 1))      'extract path+file from line
         ipos2 = len(cfilepath)                   'set end position to '\' char.
         while left$(clin, 3) = "..\"             'loop while path not explicit
            ipos1 = istr.rcfn(ipos2 - 1, cfilepath, "\")  'begin posn.='\' posn.
            clin = mid$(clin, 4)                    'remove '..\' from the line
            ipos2 = ipos1                          'move end posn.to begin posn.
         wend
         ivbpmax = ivbpmax + 1      'explicit path set; increment array maximum
         cvbp(ivbpmax) = left$(cfilepath, ipos2) + clin 'put path+file to array
      end if
   wend
   i = istr.sort(cvbp(), ivbpmax + 1)     'sort all path+filenames in the array
end if

cp.ilv1prc = 0               'initialize "processing base-level procedure" flag
cp.imaxlvl = 1                  'initialize highest stack level same as current
cp.istklvl = 1                   'set current stack processing level to one (1)
cp.cstklvl = " 1"                 'current stack processing level (string form)
cbuf0 = space$(600)           'initialize non-uppercase binary text line buffer
cbuf1 = space$(600)           'initialize the binary text line retrieval buffer
cbuf2 = space$(134)           'initialize the binary procedure list file buffer
cp.ccurprc = space$(60)          'initialize the current-process procedure name
lset cp.ccurfil = cfil          'set current filename to user's target filename
cp.ccurpos = space$(7) + "1"    'current processing byte position (string form)
cstk = cp.ccurprc + cp.ccurfil + cp.ccurpos 'push current data on process stack
cindent = "1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 "

while cp.istklvl > 0                  'loop until all files have been processed
   close cp.ifilno1                      'close file handle for current process
   i = ifn.open(cp.ifilno1, cp.ccurfil, "B", llof) 'open current file as binary
   if llof = 0 then                       'current file is nonexistent or empty
      i = ifn.kill(cp.ifilno1, cp.ccurfil)           'kill the zero-length file
      i = ifn.msgs(rtrim$(cp.ccurfil) + " not found", 5, 24, 79, 1, 1)
   end if                           'display the error message [above] and exit
   cp.lcurpos = val(right$(cstk, 8))    'process byte position for current file
   do                                  'loop until current file exhausted (EOF)
      cp.lsavpos = cp.lcurpos            'save current file processing position
      i = ifn.getline(cbuf1, clin, cp.lcurpos, cp.ifilno1, 0, 0)'read curr.line
      if clin <> "" then                    'current line was successfully read
         i = ifn.rtab(clin, 1)                'remove any "hard" tabs from line
         cp.ioffset = len(clin) - len(ltrim$(clin))    'offset of clin in cbufx
         lset cbuf0 = ltrim$(clin)            'left-justify text line in buffer
         i = istr.rcmt(cbuf0)                  'remove BASIC comments from line
         lset cbuf1 = ucase$(cbuf0)              'uppercase text line in buffer
         if instr("END SUB|END FUN", left$(cbuf1, 7)) then
            clin = ""            'end of procedure [above]; set clin = "" (EOF)
         end if
      end if
      if clin = "" then                        'EOF or end of current procedure
         'Note on current positioning:  When we push a procedure onto the stack
         'at level 1, if that procedure is a call, we need to resume processing
         'at the byte position immediately following the call, whereas if the
         'procedure is a code block in the original source file we encountered
         'during normal text line processing, we need to resume from the byte
         'position following the 'END SUB / END FUNCTION' line.
         if cp.istklvl = 2 and cp.ilv1prc then      'about to return to level 1
            rset cp.ccurpos = ltrim$(str$(cp.lcurpos))    'set process position
            mid$(cstk, len(cstk) - 135) = cp.ccurpos     'save process position
            cp.ilv1prc = 0           'clear "processing level-1 procedure" flag
         end if
         cstk = left$(cstk, len(cstk) - 128)  'pop current file & posn. f/stack
         lset cp.ccurfil = right$(cstk, 68)  'current file is from top of stack
         cp.istklvl = cp.istklvl - 1         'decrement the current stack level
         if idup = 1 then                  'duplicate calls <= current level OK
            i = ifn.rbldlevel(cp, cbuf2, llstcount, cp.istklvl)'erase lvl.flags
         end if
         exit do                            'processing complete; get next line
      end if
      cp.ilinlen = len(rtrim$(cbuf1))       'default line length for processing
      if cp.istklvl = 1 then                'current file is user's target file
         ipos1 = instr(cbuf1, " ")            'space following possible keyword
         select case left$(cbuf1, ipos1 - 1)  'select poss.proctype declaration
            case "PUBLIC", _
                 "PRIVATE", _
                 "STATIC"                           'procedure type declaration
               ipos2 = instr(ipos1 + 1, cbuf1, " ")   'space following proctype
            case else                           'procedure type declaration n/a
               ipos2 = ipos1                  'set 2nd position to 1st position
               ipos1 = 0                 'set 1st position to beginning of line
         end select
         select case mid$(cbuf1, ipos1 + 1, ipos2 - ipos1 - 1)'select procedure
            case "SUB", _
                 "FUNCTION"                       'actual valid procedure found
               ipos3 = instr(ipos2 + 1, cbuf1, "(")'opening paren for procedure
               cp.ilinlen = istr.rcsp(ipos3 - 1, cbuf1, " ")   'set line length
               cp.ilv1prc = not 0      'set "processing level-1 procedure" flag
            case else                                'valid procedure NOT found
         end select
      end if
      cp.ilinpos = 1                    'initialize the current buffer position
      while cp.ilinpos < cp.ilinlen        'loop until we reach the end-of-line
         ibeg1 = 0                     'initialize the procedure begin position
         iend1 = 0                       'initialize the procedure end position
         while cp.ilinpos <= cp.ilinlen and iend1 = 0 'loop until possible proc
            ichr = midchar(cbuf1, cp.ilinpos)'character at curr.buffer position
            if instr("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_", char(ichr)) then
               if ibeg1 = 0 then              'procedure begin position NOT set
                  ibeg1 = cp.ilinpos          'set the procedure begin position
               end if
               cp.ilinpos = cp.ilinpos + 1    'move buffer position to new char.
            elseif ibeg1 then        'no match on curr.char. but begin posn.set
               iend1 = cp.ilinpos - 1 'set end position to last character match
            else                       'no match and begin position not yet set
               cp.ilinpos = cp.ilinpos + 1    'move buffer position to new char.
            end if
         wend
         if ibeg1 > 0 then                   'possible procedure name was found
            if iend1 = 0 then                'procname continued to end of line
               iend1 = cp.ilinpos - 1          'set end position to end of line
            end if
            if ibeg1 = 1 and _     'TRUE if actually a property of a VB control
            mid$(cbuf1, istr.lcsp(iend1 + 1, cbuf1, " "), 1) = "=" then
               i = 0         'set loop value to NOT process the VB control name
            else              'current procedure NOT a property of a VB control
               cproc = left$(mid$(cbuf1, ibeg1, iend1 - ibeg1 + 1), 60)'curproc.
               for i = len(cstk) - 127 to 1 step -128 'loop thru proced. levels
                  if cproc = ucase$(rtrim$(mid$(cstk, i, 60))) then'proc.match!
                     exit for'current procedure matches parent procedure, so...
                  end if     '.....don't process same procedure in endless loop
               next
            end if
            if i < 0 then      'above loop done; procedure not already in stack
               cproc1 = cproc + space$(60 - len(cproc))  'pad cproc to 60 chars.
               lend1 = (llstcount - 1) * 134 + 1   'set 1st byte of last record
               cp.ltopptr = lstr.bsrchfs(cbuf2, cproc1, 1&, lend1, 1, cp.ifilno2, 0)
               'In the below loop, make sure that when the procedure name is a
               'match for the current procedure ('cproc', above), that cbuf2's
               'filename field matches the user's current target filename, or
               'that cbuf2's filename is contained in the current project and
               'cbuf2's "Publ"/"Priv" field is "Publ", or if a VB project is
               'not indicated, that cbuf2's "Publ"/"Priv" field is "Publ".
               do                            'loop until EOF or procedure match
                  if cp.ltopptr < 0 or cp.ltopptr > lend1 then    'out of range
                     lset cbuf2 = ""           'clear buffer to eliminate match
                     ctempproc = ""            'clear comp. name for below test
                     exit do                    'beyond EOF, just exit the loop
                  end if
                  get cp.ifilno2, cp.ltopptr, cbuf2'search result (above/below)
                  ctempproc = ucase$(rtrim$(left$(cbuf2, 60)))'result procedure
                  if ctempproc <> cproc then 'called proc.NOT found in procfile
                     exit do       'procedures do NOT match; just exit the loop
                  end if
                  ctempfile = rtrim$(mid$(cbuf2, 61, 60)) 'filename for 'cproc'
                  if ctempfile = rtrim$(cp.ccurfil) then'procedure in curr.file
                     exit do              'procedure/file match; just exit loop
                  end if
                  ipublic = (mid$(cbuf2, 121, 4) <> "Priv")'proc.is Public proc?
                  if ivbpmax >= 0 then          'target file is in a VB project
                     ltop2 = istr.bsrchas(cvbp(), ctempfile, 0, ivbpmax, 1, 9999, 1)
                     if ltop2 >= 0 and ipublic then   'file is in this project!
                        exit do    'file in project and proc. Public; exit loop
                     end if
                  elseif ipublic then       'target file is NOT in a VB project
                     exit do   'file NOT in project but proc. Public; exit loop
                  end if
                  cp.ltopptr = cp.ltopptr + 134  'move to next procedure record
               loop
               if cproc = ctempproc then   'called proc.& searched proc. match!
                  if midchar(cbuf2, 134) = 10 or idup = 2 then   'OK to process
                     i = ifn.pushstk(cp, cbuf2, cindent, cstk, ctempfile)
                     exit do   '"recursing" called routine; open & process file
                  end if
               end if
            end if
         end if
      wend
      if io.ktst(0) = 27 then                         'user pressed the ESC key
         i = ifn.rbldlist(cp, cbuf2, llstcount)  'restore l/f bytes in proclist
         i = ifn.msgs("ESC key selected - program aborted", 5, 24, 79, 0, 1)
      end if                  'user pressed ESC; abort and exit program [above]
   loop
   if io.ktst(0) = 27 then                            'user pressed the ESC key
      i = ifn.rbldlist(cp, cbuf2, llstcount)     'restore l/f bytes in proclist
      i = ifn.msgs("ESC key selected - program aborted", 5, 24, 79, 0, 1)
   end if                     'user pressed ESC; abort and exit program [above]
wend

i = ifn.rbldlist(cp, cbuf2, llstcount)     'restore l/f bytes in procedure list
i = ifn.msgs("Output file: Callist2.txt", 5, 24, 79, 0, 1) 'disp.message & exit
close                                 'close all files in case not closed above
system                                   'exit program in case not exited above

function ifn.pushstk(cp as cpas, cbuf2, cindent, cstk, ctempfile)
   mid$(cbuf2, 134) = char(cp.istklvl + 10)     'set proc.flag to called status
   put cp.ifilno2, cp.ltopptr, cbuf2            'write record to procedure file
   rset cp.cstklvl = ltrim$(str$(cp.istklvl))     'save the current stack level
   lset cp.ccurprc = rtrim$(left$(cbuf2, 60))  'save the current procedure name
   locate 5, 17, 0                              'set cursor to display procname
   print cp.cstklvl; " "; cp.ccurprc;             'display the current procname
   if cp.istklvl > 15 then                        'indent too much for tab posn.
      print #cp.ifilno3, left$(cindent, cp.istklvl * 2 - 3); _
                         char(254); cp.ccurprc; " "; ctempfile 'print user text
   elseif cp.istklvl > 1 then                  'indent OK for tab() positioning
      print #cp.ifilno3, left$(cindent, cp.istklvl * 2 - 3); _
                         char(254); cp.ccurprc; tab(91); ctempfile  'print text
   else                       'stack level = 1; NO indent for tab() positioning
      print #cp.ifilno3, cp.ccurprc; tab(91); ctempfile        'print user text
   end if
   if cp.ilinpos < cp.ilinlen then           'more data to process on this line
      cp.lcurpos = cp.lsavpos + cp.ioffset + cp.ilinpos - 1
   end if                            'adjust current file/line position [above]
   rset cp.ccurpos = ltrim$(str$(cp.lcurpos))     'set current process position
   mid$(cstk, len(cstk) - 7) = cp.ccurpos        'save current process position
   lset cp.ccurfil = ctempfile                    'set the new current filename
   rset cp.ccurpos = mid$(cbuf2, 125, 8)          'set the new current position
   cstk = cstk + cp.ccurprc + cp.ccurfil + cp.ccurpos 'push new data onto stack
   cp.istklvl = cp.istklvl + 1                   'increment current stack level
   if cp.imaxlvl < cp.istklvl then               'maximum level < current level
      cp.imaxlvl = cp.istklvl                  'set maximum level=current level
   end if
end function

function ifn.rbldlevel(cp as cpas, cbuf, lcnt, ilvl) 'restore l/f's in proclist
   for l = 1 to lcnt                         'loop thru the procedure list file
      get cp.ifilno2, clng(l - 1) * 134 + 1, cbuf'get curr.record from listfile
      if midchar(cbuf, 134) > ilvl + 10 then 'proc was called at a higher level
         mid$(cbuf, 134) = char(10)         'replace altered byte with ASCII 10
         put cp.ifilno2, clng(l - 1) * 134 + 1, cbuf'put curr.record to listfile
      end if
   next
end function

function ifn.rbldlist(cp as cpas, cbuf, lcnt)    'restore l/f bytes in proclist
   for l = 1 to lcnt                         'loop thru the procedure list file
      get cp.ifilno2, clng(l - 1) * 134 + 1, cbuf'get curr.record from listfile
      mid$(cbuf, 134) = char(10)            'replace altered byte with ASCII 10
      put cp.ifilno2, clng(l - 1) * 134 + 1, cbuf'write curr.record to listfile
   next
end function

function io.ktst(inop)                              ' return last key (no wait)
   ckey = inkey$                                      ' get key from key buffer
   if ckey <> "" then                               ' key buffer contains a key
      if asc(ckey) then                               ' key value in first byte
         inop = asc(ckey)                                 ' key value to return
      else                                        ' zero value ("extended" key)
         inop = asc(mid$(ckey, 2)) + 128           ' add 128 to 2nd byte of key
      end if
   else                                     ' key buffer does NOT contain a key
      inop = 0                                   ' set return key value to zero
   end if
   io.ktst = inop                         ' return key value to calling program
end function
