Polymath Class Complex
Local

   Real variable re
   Real variable im

---

: Reading re im ;
: Writing --> im --> re ;
: Initialize writing ;

Polymath Global

: +      rot + rot rot + swap ;

: -      rot swap - rot rot - swap ;

: *      { a b c d }
         (a*c)-(b*d)
         (a*d)+(b*c)  ;

: /      { a b c d }
         (c*c)+(d*d) { cd }
         ((a*c)+(b*d))/cd
         ((c*b)-(a*d))/cd ;

: Magz   dup * swap dup * + sqrt ;

: Theta  radians over over swap / atan
         If(rot>=0)        swap drop
         else if(swap>=0)  pi+
              else         pi-
              endif
         endif;

: Polar  { a b }
         Magz(a,b)
         Theta(a,b) ;

: Rect   { r t }
         r*cos(t)
         r*sin(t) ;

: Cinv   { a b }
         (a*a)+(b*b) { r2 }
         a/r2
         --1 *(b/r2) ;

: Exz    { a b }
         Exp(a)
         dup*cos(b)
         swap*sin(b) ;

: Lnz    Complex Polar swap ln swap ; Polymath

: dup    over over;

: swap   Roll(4) Roll(4);

: rot    Roll(6) Roll(6);

: over   Pick(4) Pick(4);

: drop   drop drop;

\  ----------  Word Descriptions  ----------

Polymath definitions
: Startup
  Blk("Complex")
  explanation
  begin
     prompt
     Compile Complex words
     prompt
  again;

Document Startup
                           COMPLEX VARIABLES

This is a relatively short application that provides an abstract data type,
or class, for declaring complex variables.  To use it, you must first create
some complex variables.  For example,

                       1 2 Complex variable x
                       3 4 Complex variable y
.break
A number of complex operations have been defined.  For example, the normal
arithmetic functions are used with complex variables just as they are with
real variables:

                       x+y    ==>      4 ,   6
                       x-y    ==>     -2 ,  -2
                       x*y    ==>     -5 ,  10
                       x/y    ==>    .44 , .08

For documentation on the numerous other complex operations that are
available, type

                           COMPLEX WORDS$

Complex

Document +
+ ( z1 z2 --- z1+z2)

Add two complex numbers.$

Document -
-  ( z1 z2 --- z1-z2 )

Subtract one complex number from another.$

Document *
*  ( z1 z2 --- z1*z2 )

Multiply two complex numbers.$

Document /
/  ( z1 z2 --- z1/z2 )

Divide one complex number into another.$

Document Magz
Magz  ( z --- |z| )

Return the magnitude of a complex number.$

Document Theta
Theta  ( z --- arg(z) )

Return the argument or angle of a complex number in radians.$

Document Polar
Polar  ( z --- rt )

Convert a complex in rectangular form to its polar form.

The rectangular form consists of two real numbers, one representing a
distance along the real axis, and the second representing a distance
along the imaginary axis.

The Polar form consists of the magnitude of the complex number, along
with the angle in radians from the real axis.  The angle ranges from a
value of -pi to +pi.$

Document Rect
Rect  ( rt --- z )

Convert a complex in polar form to its rectangular form.

The rectangular form consists of two real numbers, one representing a
distance along the real axis, and the second representing a distance
along the imaginary axis.

The Polar form consists of the magnitude of the complex number, along
with the angle in radians from the real axis.  The angle ranges from a
value of -pi to +pi.$

Document Cinv
Cinv  ( z --- 1/z )

Return the inverse of a complex number.$

Document Exz
Exz  ( z --- e**z )

Return to value of the natural number e raised to the power of the
complex number z.  This is the inverse of the Lnz function.$

Document Lnz
Exz  ( z --- ln(z) )

Return the natural logarithm of the complex number z.$

Document dup
dup ( z1 --- z1 z1 )

Copy the complex number z1 onto the top of the stack.  this is the
complex counterpart of dup.$

Document swap
swap  ( z1 z2 --- z2 z1 )

Move the second complex number on the stack to the top.  This is the
complex counterpart of swap.$

Document rot
rot  ( z1 z2 z3 --- z2 z3 z1 )

Move the third complex number on the stack to the top.  This is the
complex counterpart of rot.$

Document over
over  ( z1 z2 --- z1 z2 z1 )

Copy the second complex number on the stack onto the top.  This is the
complex counterpart of over.$

Document drop
drop  ( z1 --- )

Remove the top complex number from the stack.  This is the complex
counterpart of drop.$

Polymath Definitions
