
;       LOCATE.COM   v1.30   09-08-2002   C. Dye   raster@highfiber.com
;
;       Freeware.  Copyright 1995-2002, Charles Dye.  No warranty!
;
;       LOCATE.S is a source file for Eric Isaacson's excellent A86
;       assembler.  Assemble by typing:  A86 LOCATE.S
;
;       You may copy or distribute these files by whatever means.
;       If you wish to distribute a modified version, please include
;       my name and version number, as well as your name and a
;       summary of changes made.
;
;       I'm providing source in case anyone really wants (or needs) to
;       modify LOCATE.  It's big and ugly and messy; this utility has
;       grown by accretion.  So, don't view this as any example of
;       programming technique.


radix 16

doscall macro                          ; call to dos int_21 with a
mov ah,#1                              ; one-byte function in ah
int 21
#em

doscall2 macro                         ; call to dos int_21 with a
mov ax,#1                              ; two-byte function in ax
int 21
#em

dosprint macro                         ; call to dos string-print function
mov dx,offset #1
call strout
#em

zprint macro                           ; call to program's asciiz-print
mov di,offset #1                       ; subroutine
call zprint1
#em

bomb macro                             ; jump to handler for various errors
call bombs_away                        ; does not return!
dw #1                                  ; inline:  address of error message
db #2                                  ; inline:  errorlevel return code
#em

zero macro                             ; set word quantity to zero
xor #1, #1
#em

testzero macro                         ; test word register for zero
or #1, #1
#em


setflag macro
   bytenum = #1 / 8
   bitval  = bit (7 - (#1 mod 8))
   or b [flags + bytenum],bitval
#em

clearflag macro
   bytenum = #1 / 8
   bitmask = 0ff - (bit (7 - (#1 mod 8)))
   and b [flags + bytenum],bitmask
#em

toggleflag macro
   bytenum = #1 / 8
   bitval  = bit (7 - (#1 mod 8))
   xor b [flags + bytenum],bitval
#em

testflag macro
   bytenum = #1 / 8
   bitval  = bit (7 - (#1 mod 8))
   test b [flags + bytenum],bitval
#em

set2flags macro
   byte1num = #1 / 8
   byte2num = #2 / 8
   bit1val  = bit (7 - (#1 mod 8))
   bit2val  = bit (7 - (#2 mod 8))
   ##if (byte1num eq byte2num)
      or b [flags + byte1num], (bit1val or bit2val)
   ##else
      or b [flags + byte1num], bit1val
      or b [flags + byte2num], bit2val
   ##endif
#em

clear2flags macro
   byte1num = #1 / 8
   byte2num = #2 / 8
   bit1val  = bit (7 - (#1 mod 8))
   bit2val  = bit (7 - (#2 mod 8))
   ##if (byte1num eq byte2num)
      and b [flags + byte1num], 0ff xor (bit1val or bit2val)
   ##else
      and b [flags + byte1num], 0ff - bit1val
      and b [flags + byte2num], 0ff - bit2val
   ##endif
#em

test2flags macro
   byte1num = #1 / 8
   byte2num = #2 / 8
   bit1val  = bit (7 - (#1 mod 8))
   bit2val  = bit (7 - (#2 mod 8))
   ##if (byte1num eq byte2num)
      test b [flags + byte1num], (bit1val or bit2val)
   ##else
      test b [flags + byte1num], bit1val
      jne > m10
      test b [flags + byte2num], bit2val
      m10:
   ##endif
#em


max_fn_len   equ  0104                 ; maximum length of a filespec
max_lfn_len  equ  0210                 ; maximum length of a long filename


env_seg  equ  002c                     ; segment of environment block

country  equ  005c                     ; put country data in the psp
country_date equ country + 00
country_thou equ country + 07
country_deci equ country + 09
country_tsep equ country + 0d
country_time equ country + 11

f_year         equ  0070               ; also use psp for temp variables
f_month        equ  0072               ; used in day-of-the-week calculation
f_julian       equ  0074
f_dow          equ  0076

in_month       equ  0070               ; re-use same variables
in_day         equ  0072               ; for date input
in_year        equ  0074

in_hour        equ  0070               ; re-use same variables
in_minute      equ  0072               ; for time input
in_second      equ  0074

working_end    equ  0078               ; pointer to end of working filespec

tree_seg       equ  007a               ; segment of 64k tree buffer

dta_address    equ  0080               ; default location of dos dta
find_attr      equ  0095               ; attribute  of found item
find_time      equ  0096               ; time stamp of found item
find_date      equ  0098               ; date stamp of found item
find_size_lo   equ  009a               ; size of found item, low word
find_size_hi   equ  009c               ; size of found item, high word
find_name      equ  009e               ; filename of found item

dp_t1          equ  00f0               ; low  word for decimal print routine
dp_t2          equ  00f2               ; high word for decimal print routine
dp_t3          equ  00f4               ; normally holds ascii 'es'
dp_t4          equ  00f6               ; count of characters pushed on stack

exttmp         equ  00f7               ; holds extension for /x testing


; ----------  Flag numbers used by setflag, clearflag, testflag, etc. macros

flag_sw_h       equ  00      ; only list Hidden or System items           /H
flag_sw_x       equ  01      ; only list .COM .EXE and .BAT files         /X
flag_sw_s       equ  02      ; size range specified                    /0 /S
flag_sw_nr      equ  03      ; don't recurse into subdirectories         /NR
flag_sw_t       equ  04      ; search current directory and path only     /T
flag_sw_r       equ  05      ; don't search Removable or Remote drives    /R
flag_stdout     equ  06      ; output is to the console (not redirected)
flag_no_early   equ  07      ; disable check for 'early' switches
flag_sw_g       equ  08      ; go to directory                            /G
flag_went       equ  09      ; directory has been changed
flag_sw_d       equ  0a      ; /D specified on command line       /D /D- /D+
flag_sw_m       equ  0b      ; skip check for duplicate drives            /M
flag_dir_shown  equ  0c      ; peter mode -- directory has been displayed
flag_macro      equ  0d      ; macro output, not batch                 /O /C
flag_user_dir   equ  0e      ; the user specified a directory to search
flag_env_parse  equ  0f      ; parsing from the environment variable
flag_got_lfn    equ  10      ; got equivalent long filename in buffer
flag_user_drvs  equ  11      ; user specified drive(s) to search
flag_sw_k       equ  12      ; kill (delete) found items                  /K
flag_sw_y       equ  13      ; no prompting                               /Y
flag_sw_c       equ  14      ; send output to command shell               /C
flag_use_video  equ  15      ; okay to use video bios for output
flag_user_time  equ  16      ; user specified time format            /12 /24
flag_user_24h   equ  17      ; user specifed 24-hour format              /24
flag_unc        equ  18      ; filename begins with \\
flag_sw_nc      equ  19      ; do not canonicalize directory name        /NC
flag_quote      equ  1a      ; parsing between double-quote marks
flag_inverse    equ  1b      ; parsing inverse class                      [^
flag_no_shell   equ  1c      ; disable output to shell
flag_sw_i       equ  1d      ; display index instead of kilo/megabytes    /I
flag_user_secs  equ  1e      ; user specified seconds in time1
flag_lfn_chop   equ  1f      ; truncate long filenames to fit display     /L
flag_lfn_api    equ  20      ; long filename api is supported
flag_4dos       equ  21      ; being run under the 4dos shell
flag_exec_ext   equ  22      ; current file has a special extension

num_flags       equ  1 + flag_4dos
num_flag_bytes  equ  (num_flags / 8) + (((num_flags mod 8) ne 0) and 1)

cr     equ   0d
lf     equ   0a

; --------------------------------------------------------------------------


begin:                                 ; CHECK FOR A VALID VERSION OF DOS:
cld
doscall2 3000                          ; do old-style dos version check
cmp al,03
ja dos_okay                            ; dos 4 or better is okay
jb dos_bad                             ; dos 2 or worse is NOT okay
cmp ah,14
jae dos_okay                           ; dos 3.20 or better is okay
dos_bad:                               ; very old version of dos:
bomb msg_dos_bad,05                    ; complain and exit with errorlevel 5

dos_okay:
mov b [dos_ver],al                     ; save dos version
mov ax,0d44d
zero bx
int 2f                                 ; 4dos identify call
cmp ax,44dd                            ; is 4dos present in memory?
jne not_4dos                           ; if not, skip ahead
cmp cx,w [0016]                        ; is 4dos this program's parent?
jne not_4dos                           ; if not, skip ahead
setflag flag_4dos                      ; note we are running under 4dos

not_4dos:
push cs,cs
pop  ds,es
mov dx,offset fn_c_root                ; ds:dx points to root name
mov di,offset cmd_buf                  ; es:di points to info buffer
mov cx,0040                            ; size of buffer (arbitrary)
zero bx                                ; assume no filesystem flags
stc
doscall2 71a0                          ; win95 'get volume info' call
jc no_lfn_support                      ; if error, bug out
and bx,4002                            ; check 'preserve case' and 'lfn' bits
cmp bx,4002                            ; are both set?
jne no_lfn_support                     ; if not, bug out
setflag flag_lfn_api                   ; note that lfn support is present

no_lfn_support:
mov ax,0b700                           ; IS APPEND INSTALLED?
int 2f
cmp al,0ff
jne no_append                          ; no, skip ahead
mov ax,0b706                           ; yes, get append state
int 2f
test bl,01                             ; is append enabled?
je no_append                           ; no, skip ahead
mov w [append_hack],bx                 ; yes, save append state
and bx,0fffe                           ; clear 'enabled' bit
mov ax,0b707                           ; set append state
int 2f
no_append:                             ; append is not a problem now

config_mem:                            ; CONFIGURE MEMORY:
cmp sp,(offset end_of_data) + 0800
jb > l07
mov sp,(offset end_of_data) + 0800     ; allow 2k of stack
push cs
pop es                                 ; get code segment into .es
mov bx,segment_size                    ; and new size in .bx
doscall 4a                             ; for dos resize memory-block function
jnc > l05
l07:                                   ; if any error,
bomb msg_resize_error,04               ; complain and exit with errorlevel 4
l05:
cmp b [dos_ver],05                     ; under dos 5 or later,
jb > l10
doscall2 5800                          ; get memory allocation strategy
if nc mov b [mem_strat],al             ; and save it
doscall2 5802                          ; get upper memory link state
if nc mov b [umb_link],al              ; and save it
mov bx,0080
doscall2 5801                          ; strategy first fit high then low
mov bx,0001
doscall2 5803                          ; link in upper memory
l10:
mov bx,1000
doscall 48                             ; request 64kb for tree buffer
if c bomb msg_alloc_error,04           ; complain and exit with errorlevel 4
mov w [tree_seg],ax                    ; save segment for tree buffer
cmp b [dos_ver],05
jb > l15                               ; under dos 5 or later,
mov bl,b [mem_strat]
mov bh,00
doscall2 5801                          ; restore original allocation strategy
mov bl,b [umb_link]
mov bh,00
doscall2 5803                          ; restore original umb link state
l15:
mov dx,offset dta_address              ; set dta to 0080h
doscall 1a                             ; (this is dos default)
mov dx,offset new_int24                ; grab the dos critical-error int.
doscall2 2524                          ; to disable 'abort-retry-fail' msg.
mov bx,0001                            ; examine stdout handle :
doscall2 4400                          ; get ioctl handle info
and dl,82
cmp dl,82                              ; output to the console?
jne not_pausing                        ; if not, skip ahead
mov b [lines_max],16                   ; output is to screen, so set up for
mov b [lines_count],16                 ;    automatic scroll pausing
setflag flag_stdout                    ;    note output is to the screen
setflag flag_use_video                 ;    okay to use video bios for output
doscall2 3515
mov w [int_15_vec],bx                  ; get current int 15 handler's address
mov w [int_15_vec_hi],es               ; and save it
mov dx,offset new_int15
doscall2 2515                          ; hook int 15
push cs
pop es                                 ; point es:di
mov di,offset cmd_buf                  ; to temporary buffer
mov ax,0f00
int 10                                 ; get current video mode
mov b [vid_page],bh                    ; and stash the page number
mov ax,1b00                            ; vga call:
zero bx
int 10                                 ; get state information
cmp al,1b                              ; was call successful?
jne not_pausing                        ; if not, done with paging setup
mov al,b [cmd_buf+22]                  ; if so, get number of rows
sub al,02                              ; subtract 2 lines
mov b [lines_max],al                   ; save result
mov b [lines_count],al                 ; as number of lines to scroll
mov ax,w [cmd_buf+05]                  ; get number of columns
mov w [columns],ax
dec ax                                 ; minus one
mov bl,0f
div bl                                 ; and divide by fifteen
mov b [wide_max],al                    ; to get max columns for wide display
call default_colors                    ; choose colors for display
not_pausing:

mov dx,offset country
doscall2 3800                          ; get current country info
doscall2 6601                          ; also get code page info
if nc mov w [code_page],bx             ; and save it if no error
mov b [extensions],':'                 ; empty the extensions buffer

call parse_env                         ; handle any locate= environment var.

mov di,offset fn_buf                   ; COPY FILENAME INTO BUFFER :
mov si,0081                            ; start at beginning of command tail
parse_fn:
lodsb                                  ; get a character
call force_uc                          ; convert lowercase to upper
cmp al,'"'                             ; quote mark?
jne > l10
toggleflag flag_quote                  ; if so, toggle the quote mode flag
jmp parse_fn                           ; and continue with next character
l10:
testflag flag_quote                    ; between quotes?
jne parse_fn_0                         ; if so, skip space and switch tests
call test_space                        ; is it a space?
je parse_fn_sp                         ; if so, go deal with it
testflag flag_no_early
jne parse_fn_0
cmp di,offset fn_buf
jne parse_fn_0                         ; if the first character
cmp al,'/'                             ; is a slash
je early_switch
cmp al,'-'                             ; or a dash,
jne parse_fn_0
early_switch:                          ; this is an 'early switch' :
mov w [fn_buf+0],'.' by '*'
mov w [fn_buf+2],00  by '*'            ; use default filespec of *.*
jmp parse_sw                           ; and skip ahead to the switch parser

parse_fn_0:
cmp al,09                              ; is it a tab?
if e mov al,20                         ; if so, convert to a space
cmp al,'/'                             ; is it a slash?
if e mov al,'\'                        ; if so, convert to a backslash
cmp al,'\'                             ; is it a slash or backslash?
if e setflag flag_user_dir             ; if so, note user specified directory
cmp al,':'
je parse_colon
mov ah,00
mov w [di],ax                          ; stash character in buffer
inc di
cmp di,(offset fn_buf) + max_fn_len -1 ; is the buffer full yet?
jb parse_fn                            ; nope, loop back for more
err_buffer_full:                       ; yes,
bomb msg_buffer_full,02                ; complain and exit with errorlevel 2
parse_fn_sp:                           ; space or end-of-line found:
jc parse_fn_cr                         ; if it was a space
cmp di,offset fn_buf                   ;    and no filename found yet,
je parse_fn                            ;    ignore it and loop back
parse_fn_cr:                           ; end of line, or end of filename :
cmp di,offset fn_buf                   ; is there a filename in the buffer?
jne parse_fn_okay                      ; yes, continue
mov w [fn_buf+0],'.' by '*'
mov w [fn_buf+2],00  by '*'            ; no, use default filespec of *.*

parse_fn_okay:                         ; GOT A FILENAME IN THE BUFFER :
call test_eol                          ; at the end of the command line?
jne parse_sw                           ; no, parse any command-line switches
jmp parse_done                         ; yes, done parsing command line
parse_sw:                              ; look for switches :
lodsb                                  ; get a character
call test_switch                       ; return, space or switch char?
jnc parse_sw1
jmp parse_done                         ; if return, we are done parsing
parse_sw1:
je parse_sw                            ; space or switch, ignore it
call force_uc                          ; otherwise, force uppercase
mov di,0ffff
parse_sw2:
inc di                                 ; look at next char. in switch table
mov ah,b [switches+di]
cmp ah,00                              ; is it a null?
je parse_syn                           ; if so, syntax error
cmp ah,al                              ; is it equal to the current char?
jne parse_sw2                          ; if not, keep looking
shl di,01
mov bx,w [switch_routines+di]          ; found it:  get the routine's address
jmp bx                                 ; and go there

parse_syn:
jmp syntax                             ; any other switch = syntax error

parse_colon:                           ; found a colon:
testflag flag_user_drvs                ; drive already specified?
jne parse_colon_2                      ; if so, be cool about it
mov w [ddrv_table+0],0ffff
mov w [ddrv_table+2],0ffff             ; default to not searching any drives!
setflag flag_user_drvs                 ; note that drives have been specified
parse_colon_2:
mov ch,00
cmp di,offset fn_buf                   ; is there anything before the colon?
jne parse_colon_3                      ; if so, deal with it
doscall 19                             ; if not, use current drive
call drive_bit1                        ; convert to bit pointer
xor ah,0ff                             ; invert bit mask
and b [ddrv_table+bx],ah               ; and permit this drive
jmp parse_colon_4
parse_colon_3:                         ; something before the colon:
dec di
mov al,b [di]                          ; get previous character
mov b [di],00                          ; and erase it
cmp al,'-'
je parse_colon_range
call test_letter                       ; was character a letter?
jne parse_colon_bad                    ; if not, error
mov ch,al                              ; remember drive letter
call drive_bit                         ; convert drive letter to bit pointer
xor ah,0ff                             ; invert bit mask
and b [ddrv_table+bx],ah               ; and permit this drive
cmp di,offset fn_buf                   ; any characters before this one?
jne parse_colon_3                      ; if so, deal with them
parse_colon_4:                         ; done parsing drive letter(s):
cmp b [si],'/'                         ; if character after colon is a slash
je > l5
cmp b [si],'-'                         ; or a minus,
jne > l6
l5:
setflag flag_no_early                  ; disable early-switch test
l6:
jmp parse_fn                           ; get filename (or another drive!)

parse_colon_bad:                       ; drive letter wasn't a letter:
bomb msg_bad_drv,02                    ; complain and exit with errorlevel 2

parse_colon_range:                     ; found a dash; parse drive range:
cmp ch,00                              ; was there an end drive?
je parse_colon_bad                     ; if not, error
cmp di,offset fn_buf                   ; was dash at the start of the buffer?
jc parse_colon_bad                     ; if so, error
dec di
mov al,b [di]                          ; examine character before the dash
call test_letter                       ; if it was not a letter,
jne parse_colon_bad                    ; error!
cmp al,ch                              ; drives in ascending order?
jbe > l2                               ; if so, skip ahead
mov b [di],ch                          ; if not, swap drive letters
mov ch,al                              ; into ascending order
l2:
mov al,b [di]                          ; get start drive letter
call drive_bit                         ; convert drive letter to bit pointer
xor ah,0ff                             ; invert bit mask
and b [ddrv_table+bx],ah               ; and permit this drive
cmp ch,b [di]                          ; hit the end of the range yet?
je > l3                                ; if so, exit loop
inc b [di]                             ; otherwise, increment drive
jmp l2                                 ; loop back for next drive in range
l3:                                    ; done parsing drive range
mov ch,00                              ; note no ending drive
mov b [di],ch                          ; erase start drive letter
cmp di,offset fn_buf                   ; at the start of the buffer?
je parse_colon_4                       ; if so, done parsing drive list
jmp parse_colon_3                      ; if not, get next drive letter

switch_t:                              ; /t = time, or path
call next_char                         ; examine the next character
call test_time_date                    ; is it one of , ; : = ? or a digit ?
if e jmp switch_ti                     ; if so, this is a time switch
setflag flag_sw_t                      ; if not, path search, set path flag
jmp skip_word                          ; and skip any nonswitch characters

switch_x:
setflag flag_sw_x                      ; /x = set exe flag
call next_char                         ; examine the next character
call test_colon                        ; is it a colon or equals sign ?
jne > l20                              ; if not, exit
inc si                                 ; skip over the colon
mov bx,offset extensions               ; point to start of extensions buffer
l10:
cmp b [bx],':'                         ; find the end of extensions buffer
je > l30
add bx,0003
cmp bx,(offset extensions + (3 * 010xd))
jb l10
l20:
jmp skip_word
l30:
zero di                                ; start at beginning of extension
mov w [bx],di                          ; and assume it's empty
mov w [bx+1],di
l32:
call next_char                         ; examine next character
call force_uc                          ; as uppercase
call test_xsep                         ; comma, colon or semicolon?
je > l80                               ; if so, go handle
call test_switch                       ; switch character, space or eol?
je > l80                               ; if so, go handle
cmp al,'*'                             ; asterisk?
if e mov al,'?'                        ; treat like question mark
inc si
cmp di,0002                            ; already have three characters?
ja l32                                 ; if so, ignore this one
mov b [bx+di],al                       ; if not, add this character to buffer
inc di
jmp short l32                          ; and loop back for more
l80:                                   ; got an extension into buffer :
add bx,0003                            ; point to next slot
cmp bx,(offset extensions + (3 * 010xd))   ; have room for another?
jae l20                                ; if not, just exit
mov b [bx],':'                         ; mark new end of buffer
call test_xsep                         ; was character a comma or semicolon?
jne l20                                ; if not, exit /x handler
inc si
jmp short l30

switch_r:
setflag flag_sw_r                      ; /r = set no removable/remote flag
jmp skip_word                          ; and skip any nonswitch characters

switch_h:
setflag flag_sw_h                      ; /h = find only system and hidden
jmp skip_word                          ; skip any nonswitch characters

switch_m:
setflag flag_sw_m                      ; /m = skip test for duplicate drives
jmp skip_word                          ; skip any nonswitch characters

switch_d:                              ; /d = include directories, or not
call next_char                         ; look at next character
call force_uc
call test_time_date                    ; if it's a colon, equals, or query,
je switch_u_go
cmp al,'!'                             ; or an exclamation point,
je switch_u_go                         ; treat this like a /u
cmp al,'*'
je switch_u_go
cmp al,'T'
je switch_u_go
testflag flag_env_parse                ; parsing from environment?
if e setflag flag_sw_d                 ; if not, note /d was on command line
cmp al,'+'                             ; look at character after the d :
je parse_sw_dp                         ; plus, show directories only
cmp al,'-'
je parse_sw_dm                         ; minus, show files only
call test_switch
je parse_sw_d_nada                     ; nothing, show files and directories
jmp switch_u_bad                       ; anything else, syntax error
parse_sw_dp:                           ; /d+
or b [attrib_care],10
or b [attrib_value],10                 ; display directories only
inc si
jmp switch_done
parse_sw_dm:                           ; /d-
call files_only                        ; display files only
inc si
jmp switch_done
parse_sw_d_nada:                       ; /d
and b [attrib_care],0ef                ; don't care about directory bit
jmp switch_done
switch_u_go:                           ; /d referring to date :
jmp switch_u_alt                       ; treat like /u

files_only:
or b [attrib_care],10
and b [attrib_value],0ef
ret

switch_k:                              ; /k = kill (delete) items
testflag flag_env_parse                ; parsing from environment?
jne > l1                               ; if so, disregard /k
setflag flag_sw_k                      ; set flag
l1:
jmp skip_word

switch_y:                              ; /y = yes (no confirm on delete)
testflag flag_env_parse                ; parsing from environment?
jne > l1                               ; if so, disregard /y
setflag flag_sw_y                      ; set flag
l1:
jmp skip_word

switch_g:                              ; /g = go to directory
setflag flag_sw_g                      ; set flag
call next_char                         ; look at next char
call force_uc
cmp al,'F'                             ; /gf = go to first directory
je > l10
call test_colon                        ; is it a colon or equals sign?
je switch_f                            ; if so, treat like a /f argument
cmp al,'-'                             ; is it a minus?
je switch_f                            ; if so, treat like a /f argument
call test_digit                        ; is it a digit?
je switch_f                            ; if so, treat like a /f argument
jmp skip_word                          ; otherwise, continue parsing normally
l10:
mov w [max_count],0001
jmp skip_word

switch_f:                              ; /f = max count of files to find
zero cx                                ; assume no number
call next_char                         ; look at character after the 'f'
call test_colon                        ; if it's a colon,
if e inc si                            ; skip over the colon
call next_char                         ; get next character:
cmp al,'-'                             ; is it a minus?
je parse_sw_fy                         ; if so, exit without zero check
call test_digit                        ; is it a digit?
jne parse_sw_fx                        ; if not, exit /f parser
call parse_word                        ; get the number after /f
jc parse_sw_fz                         ; if overflow, error
parse_sw_fx:
testzero cx                            ; do we have a number?
jne parse_sw_fy                        ; if so, exit happily
inc cx                                 ; if not, assume /f1
parse_sw_fy:    
mov w [max_count],cx
jmp switch_done                        ; done with /f parser
parse_sw_fz:                           ; /f number too damn big :
bomb msg_fz,10                         ; complain and exit with errorlevel 16

switch_p:                              ; /p = peter display
clearflag flag_sw_i
switch_p_2:
mov b [display],dm_peter               ; set for peter mode
mov b [wide_count],00                  ; not wide
jmp skip_word                          ; and skip any nonswitch characters

switch_w:                              ; /w = wide peter display
mov b [display],dm_peter               ; set for peter mode
mov al,b [wide_max]
mov b [wide_count],al                  ; five columns wide
jmp skip_word                          ; and skip any nonswitch characters

switch_i:                              ; /i = display index numbers
setflag flag_sw_i                      ; instead of kb/mb
jmp switch_p_2

switch_two:                            ; /2 = undefined!
call next_char
cmp al,'4'                             ; unless the next character is '4',
je switch_twenty_four                  ; /2 is always a syntax error
jmp syntax

switch_twenty_four:                    ; /24 = force 24-hour display
set2flags flag_user_time, flag_user_24h
jmp skip_word_1

switch_one:                            ; /1 = undefined!
call next_char
cmp al,'2'                             ; unless the next character is '2',
je switch_twelve                       ; /1 is always a syntax error
jmp syntax

switch_twelve:                         ; /12 = force 12-hour display
setflag flag_user_time
clearflag flag_user_24h
jmp skip_word_1

switch_s:                              ; /s = summary only
call next_char                         ; examine the next character
cmp al,'?'                             ; syntax request?
je switch_s_query                      ; if so, go handle that
call test_colon                        ; is it a colon?
je switch_size                         ; if so, this is really a size range
call test_digit                        ; is it a digit?
je switch_size                         ; if so, this is really a size range
call test_lsep                         ; comma or semicolon?
je switch_size                         ; if so, this is really a size range
mov b [display],dm_summary             ; really /s, so force summary mode
jmp skip_word

switch_s_query:
dosprint msg_size_query
call append_restore
doscall2 4c10

switch_size:                           ; user specified a size range :
call next_char
call test_colon                        ; is the next character a colon?
if e inc si                            ; if so, ignore it
call next_char
call test_lsep                         ; is the next character a comma?
je switch_size_top                     ; if so, go get the maximum size
call test_digit                        ; is the next character a digit?
jne switch_size_bad                    ; if not, error so bomb out
call input_size                        ; read minimum size
mov w [size_1+0],ax
mov w [size_1+2],dx                    ; save minimum size
setflag flag_sw_s                      ; set size range flag
call next_char                         ; examine the next character
cmp al,'!'                             ; exclamation point?
jne > l20
inc si                                 ; if so, skip over it
mov ax,w [size_1+0]
mov dx,w [size_1+2]                    ; move the minimum size
mov w [size_2+0],ax
mov w [size_2+2],dx                    ; into the maximum size
jmp skip_word                          ; and exit
l20:
call test_lsep                         ; is it a comma or semicolon?
jne switch_size_done                   ; if not, done with /s so exit
switch_size_top:
inc si                                 ; skip past the comma
call next_char
call test_digit                        ; is the next character a digit?
jne switch_size_bad                    ; if not, error so bomb out
call input_size                        ; read maximum size
mov w [size_2+0],ax
mov w [size_2+2],dx                    ; save maximum size
setflag flag_sw_s                      ; set size range flag
switch_size_done:
jmp skip_word

switch_size_bad:                       ; syntax error in size range :
bomb msg_err_size,10                   ; complain and abort

input_size:                            ; get a file size :
zero cx                                ; use .cx for the high word
mov di,cx                              ; and .di for the low  word
mov bx,000a
input_size_loop:
call next_char                         ; examine the next character
call test_digit                        ; is it a digit?
jne input_size_x                       ; if not, done reading numeric part
inc si                                 ; if so, increment pointer
sub al,'0'
cbw                                    ; convert ascii digit to a word value
push ax                                ; and save it
mov ax,cx                              ; get the high word
mul bx                                 ; and multiply by ten
testzero dx                            ; overflow?
jne input_size_err                     ; if so, go handle it
mov cx,ax                              ; save the new high word
mov ax,di                              ; get the low word
mul bx                                 ; and multiply by ten
mov di,ax                              ; stash the new low word
add cx,dx                              ; and add any overflow to high word
jc input_size_err
pop ax                                 ; get the value of most recent digit
add di,ax                              ; and add it to the low word
adc cx,0000                            ; add any overflow to the high word
jc input_size_err
jmp input_size_loop                    ; and loop back for the next digit

input_size_x:                          ; done parsing numeric part:
call next_char                         ; examine the next character
call force_uc                          ; in uppercase
cmp al,'M'                             ; is it an 'm' ?
je input_size_meg                      ; if so, convert to megabytes
cmp al,'K'                             ; is it a 'k' ?
jne input_size_done                    ; if so, convert to kilobytes
mov bl,0a                              ; a kilobyte is 2^10 bytes....
jmp input_size_big
input_size_meg:
mov bl,14                              ; a megabyte is 2^20 bytes....
input_size_big:
shl di,1                               ; multiply the low word by two
rcl cx,1                               ; and the high word
jc input_size_err                      ; if overflow, barf
dec bl
jne input_size_big                     ; loop back for next left shift
inc si                                 ; skip over the 'k' or 'm'
input_size_done:
mov dx,cx
mov ax,di                              ; return desired size in dx:ax
ret

input_size_err:
bomb msg_fz,10

switch_b_nada:                         ; /b specified, with no prefix:
mov b [bat_buf],00                     ; empty the batch prefix buffer
dec si                                 ; undo that last lodsb
jmp skip_word                          ; and carry on with parse

switch_b:                              ; /b:"prefix"
clearflag flag_macro                   ; note that this is /b, not /o
switch_b_o:                            ; parser for /b and /o:
zero bx                                ; no characters in batch buffer
mov b [bat_buf],bl                     ; empty the batch prefix buffer
mov b [bat_args],bl                    ; no batch arguments yet
switch_b1:                             ; scan for first quote mark:
call next_char                         ; get the next character
call test_switch
jc switch_b_nada                       ; if carriage return, abort
je switch_b_nada                       ; if switch, abort
inc si
cmp al,'?'
je switch_b_qgo                        ; /b? or /o? is a syntax request
cmp al,'0'
je switch_b1b                          ; 0 means no %args wanted
call test_digit                        ; any other digit?
jne switch_b1a                         
mov b [bat_args],al                    ; if so, store it
jmp switch_b1
switch_b_qgo:
jmp switch_b_query
switch_b1b:
mov b [bat_args],00                    ; 0, store null
jmp switch_b1
switch_b1a:
cmp al,'"'                             ; found the first quote yet?
jne switch_b1                          ; if not, loop back
switch_b2:                             ; found the first quote:
call next_char                         ; get the next character
cmp al,09
if e mov al,20                         ; replace any tabs with spaces
call test_eol                          ; is it the end of the line?
je switch_b3                           ; if so, bad string, so abort
inc si
cmp al,'"'                             ; is it the second quote?
je switch_b3                           ; if so, deal with that
mov b [bat_buf+bx],al                  ; otherwise, stash the character
inc bx                                 ; and increment the buffer pointer
cmp bx,0051                            ; batch buffer overflow yet?
jne switch_b2                          ; if not, loop back for another char.
bomb msg_bat_ovf,10                    ; complain and exit with errorlevel 16
switch_b3:                             ; found the second quote:
cmp b [bat_buf],00                     ; something's in the buffer, right?
je switch_b_x                          ; if not, just leave the buffer empty
testflag flag_macro                    ; is this a /o string?
jne switch_b4                          ; if so, skip over space check
mov al,b [bat_buf-1+bx]                ; look at the last character in buffer
call test_space                        ; was the last character a space ?
je switch_b4                           ; if so, don't add a final space
mov b [bat_buf+bx],20                  ; otherwise ...
inc bx                                 ; add a final space
switch_b4:
mov w [bat_buf+bx],0001                ; always terminate with an 01,00
mov b [display],dm_batch               ; display mode is 02 for batch
testflag flag_macro
je switch_b_x
mov b [display],dm_macro               ; or 03 for macro output
call preparse_macro_string
switch_b_x:
jmp skip_word

switch_b_bad:                          ; bad syntax after /b or /o:
call append_restore                    ; prepare for error message
switch_b_query:
clearflag flag_sw_c
testflag flag_macro                    ; was it /b or /o?
jne switch_o_bad
dosprint msg_bad_bat                   ; print /b error message
jmp switch_b_o_bad
switch_o_bad:
dosprint msg_bad_format                ; print /o error message
switch_b_o_bad:
call append_restore
doscall2 4c10                          ; and exit

switch_o:                              ; /o:"format"
setflag flag_macro                     ; note that this is /o, not /b
clearflag flag_sw_c                    ; output is not to the command shell
jmp switch_b_o                         ; and use the /b parser

switch_c:                              ; /c:"format"
setflag flag_macro                     ; note that this is /c, not /b
setflag flag_sw_c                      ; output is to the command shell
jmp switch_b_o                         ; and use the /b parser

preparse_macro_string:
mov w [amp_h_point],0000               ; no header string
mov b [num_blank_lines+3],00           ; no summary, no blank lines
mov bp,offset bat_buf
preparse_1:
mov cl,00
l2:
mov al,b [bp]
inc bp
call force_uc
cmp al,01
jbe > l9
cmp cl,00
je > l4
cmp al,'H'
je preparse_macro_h
cmp al,'C'
je preparse_macro_c
cmp al,'U'
je preparse_macro_u
l4:
cmp al,'&'
je > l6
mov cl,01
l6:
xor cl,01
jmp l2
l9:
ret
preparse_macro_h:
mov w [amp_h_point],bp
or b [num_blank_lines+3],01            ; one blank line
jmp preparse_1
preparse_macro_u:
or b [num_blank_lines+3],81            ; one blank line, include summary
jmp preparse_1
preparse_macro_c:
mov al,b [bp]
inc bp
cmp al,01
jbe > l9
call force_uc
zero bx
l1:
cmp al,b [attr1+bx]
je > l2
inc bx
cmp bx,0005
je > l9
jne l1
l2:
mov al,b [bp]
inc bp
cmp al,01
jbe > l9
cmp al,'&'
je > l9
mov bl,al                              ; .bl holds delimiter character
mov cx,00                              ; .cl amp status, .ch how many delim's
l3:
mov al,b [bp]
inc bp
call force_uc
cmp al,01
jbe > l9
cmp cl,00
je > l4
cmp al,'H'
je > l9
cmp al,'C'
je > l9
cmp al,'U'
je > l9
l4:
cmp al,'&'
je > l6
mov cl,01
l6:
xor cl,01
cmp al,bl
jne l3
inc ch
cmp ch,02
jne l3
jmp preparse_1
l9:
jmp fout_con_bad

switch_n:                              ; /n = bare naked / file list
call next_char
call force_uc
cmp al,'R'
je switch_nr
cmp al,'P'
je switch_np
cmp al,'V'
je switch_nv
cmp al,'A'
je switch_na
cmp al,'C'
je switch_nc
call test_switch
if ne jmp syntax
mov b [display],dm_naked
jmp skip_word                          ; skip any nonswitch characters

switch_nr:                             ; /nr = no recurse
setflag flag_sw_nr
jmp skip_word_1

switch_np:                             ; /np = no pause
mov b [lines_count],00
jmp skip_word_1

switch_nv:                             ; /nv = do not output using video bios
clearflag flag_use_video
jmp skip_word_1

switch_na:                             ; /na = do not strip accents
mov w [code_page],0000
jmp skip_word_1

switch_nc:                             ; /nc = do not canonicalize
setflag flag_sw_nc
jmp skip_word_1

switch_l:                              ; /l = display long filenames
testflag flag_lfn_api                  ; are long filename calls supported?
je > l10                               ; if not, ignore this switch
mov b [display],dm_longnames           ; note display type
clearflag flag_lfn_chop                ; assume no lfn chopping
testflag flag_stdout                   ; unless output is to the console
je > l10
setflag flag_lfn_chop
l10:
call next_char                         ; examine the next character
cmp al,'+'                             ; if plus,
je switch_lp                           ; enable chopping
cmp al,'-'                             ; if minus,
je switch_lm                           ; disable chopping
jne switch_lx
switch_lp:                             ; /l+
setflag flag_lfn_chop                  ; permit lfn chopping
inc si
jmp switch_lx                          ; and exit
switch_lm:                             ; /l-
clearflag flag_lfn_chop                ; disable lfn chopping
inc si
switch_lx:
jmp skip_word                          ; and exit

switch_a:                              ; /a = check attributes :
call next_char                         ; look at next character after /a
cmp al,'?'
je switch_a_query
call test_colon                        ; is it a colon or equals sign?
if e inc si                            ; if so, just skip over it
switch_a00:
mov cl,00                              ; start with no attribute bits
switch_a0:
call next_char                         ; look at the next character
cmp al,'-'                             ; if it's a minus,
je switch_a_minus                      ;    attribute must be cleared
cmp al,'+'                             ; if it's a plus,
je switch_a_plus                       ;    attribute must be set
call test_switch                       ; if it's a switch,
je switch_a_exit                       ; done with this routine
call force_uc
mov di,0004
switch_a1:
cmp al,b [attr1+di]                    ; is it an attribute letter?  adshr
je switch_a_attr                       ; if so, deal with it
dec di
cmp di,0ffff
jne switch_a1                          ; otherwise, fall through to ....

switch_a_bad:                          ; bad syntax after /a:
call append_restore                    ; prepare for error message
switch_a_query:
dosprint msg_bad_chk                   ; print /a error message
call append_restore
doscall2 4c10                          ; and exit

switch_a_exit:                         ; done parsing /a string:
cmp cl,00                              ; have any bits pending?
jne switch_a_bad                       ; if so, syntax error
jmp parse_sw                           ; continue parsing switches

switch_a_attr:                         ; attribute letter:
or cl,b [attr_v+di]                    ; set the appropriate bit in .cl
inc si
jmp switch_a0                          ; and loop back to parse next char.

switch_a_plus:                         ; attribute bit(s) must be set :
cmp cl,00                              ; were any attributes specified?
je switch_a_bad                        ;    if not, problem
or b [attrib_value],cl                 ; this attribute must be set
jmp switch_a_care

switch_a_minus:                        ; attribute bit(s) must be clear:
cmp cl,00                              ; were any attributes specified?
je switch_a_bad                        ;    if not, problem
xor cl,0ff
and b [attrib_value],cl                ; this attribute must be clear
xor cl,0ff
switch_a_care:
or b [attrib_care],cl                  ; note that we care about this bit
inc si                                 ; on to the next character
test cl,10                             ; was the d bit specified?
je > l10                               ; if not, never mind....
testflag flag_env_parse                ; parsing from environment?
jne > l10
setflag flag_sw_d                      ; if not, note /d on command line
l10:
jmp switch_a00                         ; and continue parsing

switch_z:                              ; /z = customize colors
call next_char                         ; examine next character :
call test_colon                        ; is it a colon or equals sign?
if e inc si                            ; if so, just skip over it
mov ah,b [color]
mov cl,04
mov ch,ah                              ; get original background color
shr ch,cl                              ; in  lower four bits of .ch
and ah,0f0                             ; and upper four bits of .ah
zero bx
l10:
call next_char                         ; get character from command line
call test_hex_digit                    ; is it a hex digit?
cmp al,0ff
if e jmp syntax                        ; if not, syntax error!
inc si
cmp al,ch                              ; does it match the background color?
jne > l20                              ; if so,
mov al,0b                              ; substitute bright cyan
test ah,80                             ; for low-order backgrounds
je > l20
mov al,00                              ; or black for high-order
l20:
or al,ah                               ; combine with background color
mov b [col_normal+bx],al               ; and stash in the colors table
inc bx
cmp bl,05                              ; got five colors yet?
jne l10                                ; if not, loop back for the next one
call normal_color                      ; use the normal color
jmp skip_word

switch_zero:                           ; /0 = only find empty (0-byte) files
setflag flag_sw_s                      ; set size range flag
zero ax                                ; put a zero value
mov w [size_1+0],ax
mov w [size_1+2],ax                    ; into the minimum size
mov w [size_2+0],ax
mov w [size_2+2],ax                    ; and the maximum size
jmp skip_word                          ; and exit

switch_v:                              ; /V = swap pause-keys enter and space
mov ax,w [pause_line_char]             ; get the pause keys
mov b [pause_line_char+0],ah
mov b [pause_line_char+1],al
mov cx,0005                            ; swap five chars in pause message :
mov di,offset msg_pause_page
l0:
mov al,b [di]
mov ah,b [di + (msg_pause_line - msg_pause_page)]
mov b [DI],ah
mov b [di + (msg_pause_line - msg_pause_page)],al
inc di
loop l0
jmp skip_word

switch_uj:                             ; /uj = force japanese date format
mov b [country_date],02                ; japan date format  yyyy/mm/dd
jmp switch_uk2                         ; other settings like u.k.

switch_uk:                             ; /uk = force united kingdom output
mov b [country_date],01                ; u.k. date format   dd/mm/yyyy 
switch_uk2:
mov b [country_time],01                ; twenty-four hour clock
jmp switch_usa2                        ; other country setting like u.s.

switch_usa:                            ; /us = force united states output
mov b [country_date],00                ; u.s. date format   mm-dd-yyyy
mov b [country_time],00                ; twelve-hour clock
switch_usa2:
mov b [country_tsep],':'               ; colon time separator
mov b [country_thou],','               ; comma thousands separator
mov b [country_deci],'.'               ; period decimal point
inc si                                 ; skip over s j or k
call next_char                         ; and examine next character
call test_colon                        ; colon or equals sign?
je switch_u_alt                        ; if so, go parse trailing date(s)
jmp skip_word                          ; if not, done parsing /us /uj /uk

switch_u:                              ; /u = check update stamp:
call next_char                         ; look at next character
call force_uc
cmp al,'S'                             ; is it an s?
je switch_usa                          ; if so, force us output
cmp al,'K'                             ; is it a k?
je switch_uk                           ; if so, force uk output
cmp al,'J'                             ; is it a j?
je switch_uj                           ; if so, use japanese date format
cmp al,'I'
je switch_uj
cmp al,'T'                             ; a t is okay (short for today)
je switch_u_alt
call test_letter                       ; but any other letter
if e jmp switch_u_bad                  ; will trigger a syntax error

switch_u_alt:                          ; entry from /d: code
cmp al,'?'                             ; syntax request?
if e jmp switch_u_query                ; if so, go handle that
call test_colon                        ; is it a colon or equals sign?
if e inc si                            ; if so, skip over it
call next_char                         ; look at next character
call force_uc
call test_letter                       ; is it a letter?
jne switch_u2                          ; if not, not a dow so parse normally
inc si
call next_char                         ; examine character after that
dec si
call force_uc
call test_letter                       ; is *it* a letter?
jne switch_u2                          ; if not, not a dow so parse normally
jmp switch_u_dow                       ; if it is, assume this is a dow

switch_u_nada:                         ; /u with no dates specified :
zero ax
mov w [date_1],ax                      ; date_1 defaults to minimum
dec ax
mov w [date_2],ax                      ; date_2 defaults to maximum
jmp switch_done                        ; and exit

switch_u2:                             ; not a dow or other /u oddball :
call next_char                         ; look at the next character:
call force_uc
call test_lsep                         ; is it a comma or semicolon?
je switch_u_d2                         ; if so, read in date2
call test_switch                       ; is it a switch?
je switch_u_nada                       ; if so, exit
call parse_date                        ; date1 was specified:  read it in
jc switch_u_bad                        ; if any problems, abort
mov w [date_1],ax                      ; otherwise, save date1

call next_char                         ; look at the next character:
call test_lsep                         ; is it a comma or semicolon?
je switch_u_d2                         ; if so, read in date2
cmp al,'!'                             ; exclamation point?
jne switch_u_x                         ; if not, exit /u
inc si
mov ax,w [date_1]                      ; if so, move date1
mov w [date_2],ax                      ; into date2
jmp switch_u_x                         ; and exit /u

switch_u_d2:                           ; date2 was specified:
inc si                                 ; skip over comma or semicolon
call parse_date                        ; read in date2
jc switch_u_bad                        ; if any problems, abort
mov w [date_2],ax                      ; otherwise, save date2

switch_u_x:                            ; done parsing /u:
jmp switch_done

switch_u_bad:                          ; any error in /u:
call append_restore                    ; prepare to print error message
switch_u_query:
dosprint msg_bad_ud                    ; print error message
call show_date_format                  ; and describe the current date format
call append_restore
doscall2 4c10                          ; and exit with errorlevel 16

switch_u_dow:                          ; user is searching by day of week :
call parse_dow                         ; get a dow
jc switch_u_bad                        ; if it's not valid, error
call next_char                         ; examine next character
cmp al,'-'                             ; dash?  if so, go handle dow range
je > l20
mov bh,01                              ; set bit in .bh
mov cl,bl                              ; according to user-specified dow
shl bh,cl
or b [check_dow],bh                    ; add to dow mask
call test_lsep                         ; list separator?
jne > l40                              ; if not, exit
l10:
inc si                                 ; increment pointer
jmp switch_u_dow                       ; and loop back for more user dows
l20:                                   ; user specified a range :
inc si                                 ; skip over the dash
mov ch,bl                              ; store the first dow in .ch
call parse_dow                         ; and get the next dow
jc switch_u_bad                        ; if any problem, error
call next_char                         ; examine the next character
cmp al,'-'                             ; it had better not be another dash
je switch_u_bad                        ; if it is, problem
mov cl,bl                              ; leave the second dow in .cl
cmp ch,cl                              ; specified out of order?
ja > l21
mov cl,ch
mov ch,bl                              ; if so, reverse them
l21:
mov bh,01
shl bh,cl
l22:
or b [check_dow],bh
inc cl
shl bh,01
cmp cl,ch
jbe l22
call test_lsep
je l10
l40:
jmp switch_done

date_today_go:
jmp date_today

parse_date:                            ; read in date :
call next_char
call force_uc
cmp al,'T'
je date_today_go
cmp al,'!'
je date_today_go
cmp al,'*'
je date_today_go
call parse_word                        ; get the first number
jc parse_date_bad                      ; and abort if any problem with it
mov w [in_month],cx                    ; store it in the 'month' variable
call next_char                         ; look at the next character
call test_dsep                         ; is it a date separator?
jne parse_date_bad                     ; if not, abort
inc si                                 ; skip over the date separator
call parse_word                        ; and read in the second number
jc parse_date_bad                      ; abort if any problem with it
mov w [in_day],cx                      ; store it in the 'day' variable
call next_char                         ; look at the next character
call test_dsep                         ; is it a date separator?
je parse_date_05                       ; if so, continue normally
doscall 2a                             ; if not, get current date from dos
mov w [in_year],cx                     ; and use current year
cmp b [country_date],01                ; european date format?
je parse_date_eur                      ; if so, adjust it
jmp parse_date_combine                 ; us or japan format, leave it alone.
parse_date_bad:                        ; any error whilst reading in date :
stc                                    ; exit with carry set
ret
parse_date_05:                         ; a third number (year) was specified:
inc si                                 ; skip over the date separator
call parse_word                        ; and read in the third number
jc parse_date_bad                      ; abort if any problem with it
mov w [in_year],cx                     ; store it in the year variable

parse_date_world:                      ; internat'l: rearrange date if needed
mov al,b [country_date]                ; check date format
cmp al,00                              ; u.s. format?  mm-dd-yyyy
je parse_date_combine                  ; if so, leave date alone
cmp al,01                              ; european format?  dd-mm-yyyy
je parse_date_eur                      ; if so, fix it
mov ax,w [in_day]                      ; japanese format:  yyyy-mm-dd
mov bx,w [in_month]
mov cx,w [in_year]
mov w [in_month],ax                    ; move 'day' value into 'month'
mov w [in_day],cx                      ; move 'year' value into 'day'
mov w [in_year],bx                     ; move 'month' value into 'year'
jmp parse_date_combine
parse_date_eur:                        ; european format:  dd-mm-yyyy
mov ax,w [in_day]
mov bx,w [in_month]
mov w [in_day],bx                      ; move 'month' value into 'day'
mov w [in_month],ax                    ; move 'day' value into 'month'

parse_date_combine:                    ; combine date vars into a single word
mov ax,w [in_day]                      ; get 'day' variable
cmp ax,001f
ja parse_date_bad                      ; above 31 is bad
mov bx,w [in_month]                    ; get 'month' variable
cmp bx,000f
ja parse_date_bad                      ; above 15 is bad
mov cl,05
shl bx,cl                              ; multiply months by 32
or ax,bx                               ; and add to date
mov bx,w [in_year]                     ; get 'year' variable
cmp bx,080xd                           ; year 00 through 79?
jae parse_date_10
add bx,020xd                           ; add 20 (year 2000 through 2079)
jmp parse_date_20
parse_date_10:
cmp bx,0100xd                          ; year 80 through 99?
jae parse_date_15
sub bx,080xd                           ; subtract 80 (year 1980 through 1999)
jmp parse_date_20
parse_date_15:
sub bx,01980xd                         ; otherwise, subtract 1980
cmp bx,007f                            ; to get dos year 0 - 127
if a jmp parse_date_bad                ; anything bigger than 127 is an error
parse_date_20:
mov cl,09
shl bx,cl                              ; multiply dos year by 512
or ax,bx                               ; and add to date
clc
ret                                    ; done parsing year

date_today:                            ; 't' '!' or '*' found:
inc si                                 ; skip over it
doscall 2a                             ; get current date from dos
mov w [in_year],cx                     ; stash year
mov b [in_month],dh                    ; stash month
mov b [in_day],dl                      ; stash day
mov b [in_month+1],00
mov b [in_day+1],00                    ; month and day as byte quantities
call next_char                         ; is the next character
cmp al,'-'                             ; a minus sign?
jne parse_date_combine                 ; if not, done with 'today' parse
inc si                                 ; if so, skip over the minus
call parse_word                        ; and get the quantity to subtract
if c jmp parse_date_bad                ; bomb if any error
                                       ; quantity to subtract is in .cx
call next_char                         ; look at the next character
call force_uc
cmp al,'D'                             ; letter 'd' ?
je subtract_days                       ; if so, quantity is in days
cmp al,'W'                             ; letter 'w' ?
jne > l10                              ; if so,
mov ax,cx                              ; quantity is in weeks
mov bx,0007
mul bx                                 ; so multiply by seven to get days
testzero dx                            ; overflow?
jne date_subtract_bad                  ; if so, go handle error
mov cx,ax                              ; if not,
jmp subtract_days                      ; subtract appropriate number of days
l10:
cmp al,'Y'                             ; letter 'y' ?
je subtract_years                      ; if so, quantity is in years
cmp al,'M'                             ; letter 'm' ?
je subtract_months                     ; if so, quantity is in months
jmp before_today                       ; no letter, assume years

subtract_days:                         ; subtract a number of days :
inc si                                 ; skip over letter
before_today:
cmp cx,w [in_day]                      ; less than today's date?
jae > l20
sub w [in_day],cx                      ; if so, simply subtract it
jmp parse_date_combine                 ; and exit
l20:
sub cx,w [in_day]                      ; if not, subtract date from quantity
dec w [in_month]                       ; and decrement the month
cmp w [in_month],0000                  ; month underflow?
je > l30
call max_day                           ; if not, fix date
mov b [in_day],al                      ; to the last of the month
jmp before_today                       ; and loop back
l30:
mov w [in_month],000c                  ; if so, set date
mov w [in_day],001f                    ; to december 31st
dec w [in_year]                        ; and decrement year
cmp w [in_year],01980xd                ; underflow?
jae before_today                       ; if not, loop back
                                       ; if so, fall through to ...
date_subtract_bad:                     ; handle date-subtract error :
bomb msg_err_date,10

subtract_years:
inc si
mov ax,w [in_year]
sub ax,cx
cmp ax,01980xd
jb date_subtract_bad
cmp ax,w [in_year]
ja date_subtract_bad
mov w [in_year],ax
cmp w [in_month],0002
jne > l10
cmp w [in_day],001d
jne > l10
call max_day
mov b [in_day],al
l10:
jmp parse_date_combine

subtract_months:
inc si
l10:
cmp cx,w [in_month]
jae > l30
sub w [in_month],cx
call max_day
cmp al,b [in_day]
jae > l20
mov b [in_day],al
l20:
jmp parse_date_combine
l30:
sub cx,w [in_month]
mov w [in_month],000c
dec w [in_year]
cmp w [in_year],01980xd
jae l10
jmp date_subtract_bad

max_day:
mov bx,w [in_month]
mov al,b [months_table+bx-1]
cmp al,1e
jae > l28
mov al,1c
cmp w [in_year],02100xd
je > l28
test b [in_year],03
jne > l28
inc al
l28:
ret

parse_dow:                             ; PARSE DAY OF THE WEEK :
call next_char                         ; get first letter in .al
inc si                                 ; and point to second
mov bl,al                              ; save first letter
call next_char                         ; get second letter in .al
inc si                                 ; and skip over it
mov ah,al
mov al,bl                              ; swap first and second letters
and ax,0dfdf                           ; and force both to uppercase
zero bx                                ; start at beginning of list
l10:
cmp ax,w [dow_short+bx]                ; compare dow short name against list
je > l30                               ; if it matches, we have a valid name
inc bx                                 ; otherwise, increment index
inc bx
cmp bx,0010                            ; fell off the end of the list?
jb l10                                 ; if not, keep trying
stc                                    ; if so, exit with carry set
ret
l30:                                   ; matched a day-of-week name :
shr bx,01                              ; divide index by two
l32:
call next_char                         ; look at the next character
call force_uc
call test_letter                       ; is it a letter?
jne > l35                              ; if not, exit
inc si                                 ; if so,  ignore it
jmp l32
l35:
clc                                    ; exit with carry clear
ret

switch_ti:                             ; /t = check time stamp:
call next_char                         ; look at next character
cmp al,'?'                             ; syntax request?
if e jmp switch_ti_query               ; if so, go handle it
call test_colon                        ; is it a colon or equals sign?
if e inc si                            ; if so, skip over the colon
call next_char                         ; look at next character
call test_lsep                         ; is it a comma or semicolon?
je switch_ti_t2                        ; if so, go read in time2
call test_switch                       ; is it a switch character?
je switch_ti_nada                      ; if so, exit with no time range
call test_digit                        ; is it a digit?
jne switch_ti_bad                      ; if not, abort
mov w [in_second],0000
call parse_time                        ; time1 was specified:  read it in
jc switch_ti_bad                       ; if any problem, abort
mov w [time_1],ax                      ; otherwise, save time1
call next_char                         ; look at next character
call test_lsep                         ; is it a comma or semicolon?
je switch_ti_t2                        ; if so, go read in time2
cmp al,'!'                             ; exclamation point?
je switch_tib_x                        ; if so, move time1 to time2 and exit
jmp switch_ti_x                        ; otherwise, exit /t
switch_ti_nada:                        ; /t with no times specified :
zero ax
mov w [time_1],ax                      ; time_1 defaults to minimum
dec ax
mov w [time_2],ax                      ; time_2 defaults to maximum
jmp switch_done                        ; and exit
switch_tib_x:                          ; /t time1!
mov ax,w [time_1]                      ; move time1
testflag flag_user_secs
jne > l1
or ax,001f
l1:
mov w [time_2],ax                      ; into time2
jmp skip_word
switch_ti_t2:                          ; time2 was specified :
inc si                                 ; skip over comma or semicolon
call next_char                         ; look at next character
call test_digit                        ; is it a digit?
jne switch_ti_bad                      ; if not, abort
mov w [in_second],003b
call parse_time                        ; read in time2
jc switch_ti_bad                       ; if any problems, abort
mov w [time_2],ax                      ; otherwise, save time2
switch_ti_x:                           ; done parsing /t :
jmp switch_done

switch_ti_bad:                         ; any error in /t :
call append_restore                    ; prepare to print error message
switch_ti_query:
dosprint msg_bad_ti                    ; print error message
call append_restore
doscall2 4c10                          ; and exit with errorlevel 16

parse_time:                            ; read in time from command line :
clearflag flag_user_secs               ; assume no seconds on command line
call parse_word                        ; get the first number
jc parse_time_bad                      ; and abort if any problem with it
mov w [in_hour],cx                     ; store it in the 'hour' variable
call next_char                         ; look at the next character
call test_tsep                         ; is it a time separator?
jne parse_time_bad                     ; if not, abort
inc si                                 ; skip over the time separator
call parse_word                        ; read in the second number
jc parse_time_bad                      ; and abort if any problem
mov w [in_minute],cx                   ; store it in the 'minutes' variable
call next_char                         ; look at the next character
call test_tsep                         ; is it a time separator?
jne > l5                               ; if not, use the default for seconds
inc si                                 ; if so, skip over the time separator
call parse_word                        ; read in the third number
jc parse_time_bad                      ; abort if any problem
mov w [in_second],cx                   ; store it in the 'seconds' variable
setflag flag_user_secs                 ; note that the user specified seconds
l5:                                    ; got both, or all three, numbers :
mov bx,w [in_hour]                     ; examine hours value
cmp bx,0001                            ; below 1?
jb no_am_pm                            ; if so, don't check for am/pm flag
cmp bx,000c                            ; above 12?
ja no_am_pm                            ; if so, don't check for am/pm flag
call next_char                         ; look at next character
call force_uc
cmp al,'A'                             ; is it an 'a' ?
je parse_time_am                       ; if so, make it morning
cmp al,'P'                             ; is it a 'p' ?
je parse_time_pm                       ; if so, evening hour
jmp no_am_pm                           ; anything else, deal with later
parse_time_bad:                        ; error in user's time :
stc                                    ; exit with carry set
ret
parse_time_pm:                         ; evening hour :
inc si                                 ; skip over the 'p'
cmp bx,000c                            ; is it 12 pm?
je ignore_any_m                        ; if so, don't adjust it
add bx,000c                            ; any pm hour except 12,
mov w [in_hour],bx                     ; add 12 to get 24-hour format
jmp ignore_any_m
parse_time_am:                         ; morning hour :
inc si                                 ; skip over the 'a'
cmp bx,000c                            ; is it 12 am?
jne ignore_any_m                       ; if not, no adjustment needed
mov w [in_hour],0000                   ; if so, convert to midnight
ignore_any_m:
call next_char                         ; look at next character
call force_uc
cmp al,'M'                             ; is it an 'm' ?
jne no_am_pm                           ; if not, don't worry about it yet
inc si                                 ; if so, go ahead and ignore it
no_am_pm:
cmp w [in_hour],0018                   ; is hour equal to 24 ?
jne parse_time_combine                 ; if not, don't worry about it
mov w [in_hour],0000                   ; fix hours to indicate midnight
parse_time_combine:
mov ax,w [in_second]                   ; get seconds variable
cmp ax,003f                            ; seconds in legal range?
ja parse_time_bad                      ; if not, abort
shr ax,01                              ; divide seconds by two
mov bx,w [in_minute]                   ; get minutes variable
cmp bx,003f                            ; minutes in legal range?
ja parse_time_bad                      ; if not, abort
mov cl,05
shl bx,cl                              ; multiply minutes by 32
or ax,bx                               ; and add in to time
mov bx,w [in_hour]                     ; get hours variable
cmp bx,001f                            ; hours in legal range?
ja parse_time_bad                      ; if not, abort
mov cl,0b
shl bx,cl                              ; multiply hours by 2048
or ax,bx                               ; and add in to time
clc                                    ; exit with happiness
ret

parse_word:                            ; read in a decimal number:
zero cx                                ; start with zero
call next_char                         ; look at next character
call test_digit                        ; is it a digit?
jne parse_word_bad                     ; if not, error
parse_word_1:
inc si
sub al,'0'                             ; convert digit to
cbw                                    ; a 16-bit value
push ax                                ; and save it
mov ax,000a
mul cx                                 ; multiply old value by ten
testzero dx                            ; any overflow?
jne parse_word_bad                     ; if so, error
pop dx
add ax,dx                              ; add in the value of the latest digit
jc parse_word_bad                      ; overflow?  if so, error
mov cx,ax                              ; save the new working value
call next_char                         ; move on to next character:
call test_digit                        ; is it also a digit?
je parse_word_1                        ; if so, keep parsing
clc                                    ; return number in .cx, carry clear
ret
parse_word_bad:                        ; any error:
stc                                    ; exit with carry set
ret

next_char:                             ; look ahead at next char to parse:
testflag flag_env_parse
jne next_char_e
mov al,b [si]                          ; get next character from command line
ret
next_char_e:
mov al,b [es:si]                       ; or next character from environment
ret

skip_word_1:                           ; used for two-character switches :
inc si                                 ; increment pointer and fall through

skip_word:                             ; valid switch:  skip remaining chars
testflag flag_env_parse
jne skip_env_word
lodsb                                  ; get a character
call test_switch                       ; return, switch, space?
jc parse_done                          ; return = done parsing
jne skip_word                          ; non-switch, non-space = lose it
jmp parse_sw                           ; otherwise, loop back for next switch
skip_env_word:
jmp parse_env_2

switch_done:
testflag flag_env_parse
jne skip_env_word
jmp parse_sw

parse_done:                            ; DONE READING IN COMMAND LINE:

mov bl,01                              ; drive a:
doscall2 440e                          ; ioctl get-drive-map function
jc no_drv_b_fix                        ; if any error, skip this routine
cmp al,00                              ; only one floppy present in system?
je no_drv_b_fix                        ; if more than one, don't do b: fix
or b [ddrv_table],02                   ; don't search drive b:
mov bl,01                              ; drive a:
doscall2 440f                          ; map floppy as drive a:
no_drv_b_fix:

dots_fix:                              ; FIX FOR FILESPEC OF JUST '.' OR '..'
mov si,offset fn_buf
mov bl,'\'
call find_last                         ; look for backslashes in filespec:
mov bx,offset fn_buf                   ; if none, look at start of fn_buf
je dots_fix_0
mov bx,ax
inc bx                                 ; if found, look just after the last
dots_fix_0:
cmp b [bx],'.'                         ; does the filespec start with '.' ?
jne dots_fix_x                         ; if not, never mind
cmp b [bx+1],00
jne dots_fix_1                         ; filespec of just . ?
mov w [bx+1],00 by '\'                 ; if so, change to .\
setflag flag_user_dir                  ; note:  user specified dir.
jmp dots_fix_x
dots_fix_1:
cmp w [bx+1],00 by '.'
jne dots_fix_x                         ; filespec of just .. ?
mov w [bx+2],00 by '\'                 ; if so, change to ..\
setflag flag_user_dir                  ; note:  user specified dir.
dots_fix_x:

mov si,offset fn_buf                   ; LOOK FOR DIRECTORY SPEC:
call find_last_bs                      ; find the last \ within filename buf.
jne dir_spec                           ; if found, skip ahead
mov si,offset fn_buf
mov di,offset fs_buf                   ; no directory was specified:
no_dir_spec_1:
mov al,b [si]                          ; copy filename
call force_roman
mov b [di],al                          ; into filespec buffer
inc si
inc di
cmp al,00
je no_dir_spec_2
cmp di,offset fs_buf + 30              ; filespec longer than 47 chars?
jb no_dir_spec_1                       ; no, continue copying
jmp err_buffer_full                    ; yes, print error message and abort
no_dir_spec_2:                         ; done copying filename :
mov w [fn_buf],00 by '\'               ; use default directory of '\'
jmp dir_spec_x                         ; and exit

dir_spec:                              ; A DIRECTORY WAS SPECIFIED:
mov dx,ax                              ; save offset of last '\'
mov si,ax
inc si                                 ; look at character after last '\':
cmp b [si],00                          ; is there any filespec?
jne dir_spec_1                         ; yes, skip ahead
mov w [fs_buf+0],'.' by '*'            ; directory specified, no filespec:
mov w [fs_buf+2], 00 by '*'            ; use default of *.*
jmp dir_spec_x
dir_spec_1:                            ; directory and filespec both spec'ed:
mov di,offset fs_buf
dir_spec_2:
mov al,b [si]                          ; copy filename
call force_roman
mov b [di],al                          ; into filespec buffer
inc si
inc di
cmp al,00
je dir_spec_3
cmp di,offset fs_buf + 30              ; filespec longer than 47 chars?
jb dir_spec_2                          ; no, continue copying
jmp err_buffer_full                    ; yes, print error message and abort
dir_spec_3:                            ; done copying filename :
push dx
pop si
inc si                                 ; change character after last '\'
mov b [si],00                          ; to a null
dir_spec_x:

nr_fix:
testflag flag_sw_nr                    ; did the user specify /nr ?
je nr_fix_x                            ; if not, no fix needed
testflag flag_user_dir                 ; did the user specify a directory ?
jne nr_fix_x                           ; if so,  no fix needed
mov w [fn_buf+0],'\' by '.'            ; /nr with no directory specified:
mov b [fn_buf+2],00                    ;    poke in a period and backslash
setflag flag_user_dir                  ;    pretend they're the user's
nr_fix_x:
                                       ; CHECK DIR SPEC FOR WILDCARDS:
mov bl,'?'                             ; is there a question mark
mov si,offset fn_buf                   ;    in the directory name buffer?
call find_first
jne dir_spec_wc                        ; if so, error
mov bl,'*'                             ; is there an asterisk
mov si,offset fn_buf                   ;    in the directory name buffer?
call find_first
je dir_fix_xx                          ; if not, no wildcards, all is okay
dir_spec_wc:                           ; wildcard in directory name:
bomb msg_dir_wc,02                     ; complain and exit with errorlevel 2

dir_fix_xx:                            ; DONE MESSING WITH DIRECTORY NAME :
mov bl,'.'
mov si,offset fs_buf                   ; look for '.' in filespec
call find_first
jne dot_found_1
mov w [si],'*' by '.'                  ; if there is no period, add '.*'
inc si
inc si
mov b [si],00                          ; and terminal null to filespec
cmp si,fs_buf + 30                     ; buffer overflow?
jb dot_found_x                         ; no, done messing with extension
jmp err_buffer_full                    ; yes, print error message and abort
dot_found_1:                           ; there is a period:
testflag flag_sw_x                     ; was /X specified?
je dot_found_x
inc si                                 ; if so,
mov w [si],00 by '*'                   ; change extension to '*'
cmp si,fs_buf + 2f                     ; buffer overflow?
jb dot_found_x                         ; no, done messing with extension
jmp err_buffer_full                    ; yes, print error message and abort
dot_found_x:                           ; DONE MESSING WITH FILESPEC EXTENSION

mov si,offset fs_buf - 1               ; BEGIN SEARCH FOR CLASS WILDCARDS :
l05:
inc si
l06:
mov al,b [si]                          ; examine next character
cmp al,00                              ; end of filespec buffer?
if e jmp drv_fix                       ; if so, done searching for classes
cmp al,'['                             ; start of class definition?
jne l05                                ; if not, loop back and keep looking
inc si                                 ; skip over the open bracket
push si                                ; save offset of next character
clearflag flag_inverse                 ; assume it's not an inverse class
cmp b [si],'^'                         ; is this an inverse class?
jne > l10
inc si                                 ; if so, skip over the caret
setflag flag_inverse                   ; and note this as an inverse class
l10:
cmp b [si],']'                         ; empty class?
jne > l15                              ; if so,
err_class:                             ; error in class definition :
bomb msg_err_class,02                  ; complain and exit with errorlevel 2
l15:
mov bl,b [next_class]                  ; get number of next class def block
cmp bl,0b
jb > l17
bomb msg_err_classes,02
l17:
mov bh,00                              ; as a word
mov cl,05
shl bx,cl                              ; multiply by 32
add bx,offset class_blocks             ; get pointer to class def block
mov di,0020
l20:                                   ; fill class definition block with
dec di                                 ; zeroes
mov b [bx+di],00
jne l20
l25:
lodsb                                  ; get character from class definition
call force_uc                          ; convert character to uppercase
cmp al,00                              ; no closure to class?
je err_class                           ; if so, bomb the hell out
cmp al,'.'                             ; period inside class?
je err_class                           ; if so, bomb out
cmp al,'?'
je err_class
cmp al,'*'
je err_class
cmp al,']'                             ; end of class definition?
je > l30                               ; if so, exit class loop
mov ch,00                              ; not doing a range
cmp b [si],'-'
jne > l26
inc si
mov ch,al
lodsb
call force_uc
cmp al,00
je err_class
cmp al,']'
je err_class
cmp al,ch
jbe > l251
mov ah,al
mov al,ch
mov ch,ah
l251:
sub ch,al
l26:
mov cl,al
and cl,0f                              ; get shift count in .cl
mov dx,0001
shl dx,cl                              ; and bit value in dx
shr ax,01
shr ax,01
shr ax,01
and ax,001e
mov di,ax                              ; word pointer in .di
l27:
or w [bx+di],dx                        ; set appropriate bit in class block
cmp ch,00                              ; doing a range?
je l25                                 ; if not, loop back for next character
dec ch
rol dx,01
cmp dx,0001
jne l27
inc di
inc di
jmp l27
l30:
testflag flag_inverse                  ; is this an inverse class?
je > l40
zero di
l35:
xor b [bx+di],0ff                      ; if so, invert all bits
inc di                                 ; in the definition block
cmp di,0020
jne l35
l40:                                   ; done setting up definition block :
pop di                                 ; get pointer to next character
mov al,b [next_class]
add al,41                              ; convert class number to a letter
mov b [di],al                          ; and poke it into the filespec
inc di                                 ; point just past that
inc b [next_class]                     ; next class found uses next number
push di
call copy_si_di_z                      ; and move the remainder down
pop si
jmp l06                                ; and scan on for next class

drv_fix:                               ; DONE MESSING WITH FILESPEC CLASSES :
testflag flag_user_dir                 ; was a directory name specified?
je drv_fix_x                           ; if not, skip drive fix
testflag flag_user_drvs                ; was a drive specified?
jne drv_fix_x                          ; if so, skip drive fix
doscall 19                             ; dos get-current-drive function
add al,'A'                             ; convert to a letter
mov b [drv1],al                        ;    and use for first drive
mov b [drv2],al                        ;    and last drive
setflag flag_user_drvs                 ; pretend this is user-specified drive
drv_fix_x:

;  RECONCILE SWITCHES :
testflag flag_user_drvs                ; if searching user-specified drives,
je reconcile1        
clearflag flag_sw_r                    ;    disregard any /R
reconcile1:
testflag flag_sw_g                     ; if /G specified
je reconcile2
clearflag flag_sw_k                    ; disable any /K
cmp w [max_count],0000                 ; if /G specified with no /F number,
jne reconcile2
call ia_display                        ;    force interactive display modes
reconcile2:
cmp b [display],dm_batch               ; if display mode is batch
jb reconcile3
cmp b [display],dm_macro               ; or macro output,
ja reconcile3
cmp b [bat_buf],00                     ; and the batch buffer is empty,
jne reconcile3
mov b [display],dm_peter               ;    do a peter-style display instead
mov b [wide_count],00
reconcile3:
test2flags flag_sw_x, flag_sw_s        ; if /x or size range was specified,
je reconcile4
call files_only                        ;    find files only, like /d-
reconcile4:
testflag flag_user_drvs                ; if no drive specified,
jne reconcile6
doscall 19
cmp al,02                              ; and current drive is c: or higher,
jb reconcile6
mov b [drv1],'C'                       ;    start search at c: instead of a:
reconcile6:
cmp b [display],dm_batch               ; if display mode is batch
jne reconcile7
testflag flag_sw_d                     ;     and user didn't specify /d,
jne reconcile7
call files_only                        ;     find files only, like /d-
reconcile7:
mov ax,w [date_1]
cmp ax,w [date_2]
jbe reconcile8                         ; if date_1 is greater than date_2,
mov bx,w [date_2]
mov w [date_2],ax                      ;     swap them!
mov w [date_1],bx
reconcile8:
mov ax,w [time_1]
cmp ax,w [time_2]
jbe > l20                              ; if time_1 is greater than time_2,
mov bx,w [time_2]
mov w [time_2],ax                      ;     swap them!
mov w [time_1],bx
l20:
mov ax,w [size_1+0]                    ; if size_1 is greater than size_2,
mov dx,w [size_1+2]
cmp dx,w [size_2+2]
jb > l30
ja > l25
cmp ax,w [size_2+0]
jbe > l30
l25:                                   ;     swap them!
mov bx,w [size_2+0]
mov w [size_2+0],ax
mov w [size_1+0],bx
mov bx,w [size_2+2]
mov w [size_2+2],dx
mov w [size_1+2],bx
l30:
testflag flag_user_time                ; if /12 or /24 was specified,
je reconcile9
mov al,00
testflag flag_user_24h
je > l35
inc al
l35:
mov b [country_time],al                ;    set country_time appropriately
reconcile9:
testflag flag_sw_k                     ; if /k was specified,
je reconcile10
testflag flag_sw_d
jne > l1                               ;    if /k with no /d /d- /d+
call files_only                        ;    find files only, like /d-
l1:
testflag flag_sw_y                     ; if /k was specified without /y,
jne reconcile10
call ia_display                        ;    force interactive display modes
reconcile10:
cmp b [display],dm_macro
je reconcile12                         ; if /o was not specified,
mov w [amp_h_point],0000               ;     clear the amp-h pointer
reconcile12:
cmp b [display],dm_macro               ; if macro output,
jne > l14
testflag flag_sw_c                     ;     if /c,
je > l15
mov b [lines_count],00                 ;     disable pausing
call empty_cmd_buf                     ;     empty the command buffer
cmp w [shell_pnt],0000
jne > l12                              ;     ensure that comspec= was found
bomb msg_err_no_comspec,08             ;     if not, abort with errorlevel 8
l12:
testflag flag_sw_y
jne > l15                              ;     if /c with no /y,
call ia_display                        ;     force interactive display
jmp > l15
l14:                                   ; if not macro output,
clearflag flag_sw_c                    ;     output is not to command shell
l15:

cmp b [extensions],':'
jne > l43
mov di,offset extensions
mov si,offset execnames
testflag flag_4dos
jne > l42
add si,0003
l42:
call copy_si_di_z
l43:

call dupe_drives                       ; check for duplicate drive mappings
cmp b [display],dm_batch               ; in batch mode?
jne alls_well_2
zprint msg_bat_begin                   ; if so, print the '@echo off' message
alls_well_2:
cmp w [fn_buf+0],'\' by '\'
jne > l3
setflag flag_unc
l3:
mov bl,b [display]
mov bh,00
test b [num_blank_lines+bx],01
if ne call terminate_line

start_locate:                          ; ABOUT TO START TREE CONSTRUCTION:
testflag flag_sw_t                     ; was /t specified?
je start_loc_0                         ; if not, continue
jmp use_path                           ; if so, we use an entirely different
start_loc_0:                           ;    routine to construct the tree
testflag flag_unc                      ; is this a unc filespec?
je > l5                                ; no, continue normally
mov si,offset fn_buf                   ; yes, skip following stuff
jmp start_loc_5
l5:
mov al,b [drv1]                        ; get current drive letter
call drive_bit                         ; and convert to bit address
test b [ddrv_table+bx],ah              ; is this drive excluded?
jne start_loc_not                      ; if so, don't use it.  duh.
testflag flag_sw_r                     ; was /r specified?
je start_loc_2                         ; if not, skip the following tests:
mov bl,b [drv1]                        ; get current drive
sub bl,40                              ; and convert to a 1-based number
doscall2 4408                          ; ioctl:  is drive removable?
jnc start_loc_1                        ; if call fails, skip this drive
start_loc_not:
jmp next_drive
start_loc_1:                           ; ioctl call succeeded:
test al,01                             ; is drive removable?
je start_loc_not                       ; if so, skip this drive
mov bl,b [drv1]                        ; get current drive
sub bl,40                              ; and convert to a 1-based number
doscall2 4409                          ; ioctl:  is drive remote?
jc start_loc_not                       ; if call fails, skip this drive
test dh,90                             ; is drive remote or subst'ed?
jne start_loc_not                      ; if so, skip this drive
start_loc_2:                           ; drive passes /r test, if needed:
mov dl,b [drv1]                        ; get current drive
sub dl,40                              ; and convert to a 1-based number
doscall 36                             ; dos:  get disk free space
cmp ax,0ffff                           ; is this a valid drive?
je start_loc_not                       ; if not, skip this drive

start_loc_4:                           ; search this drive :
mov al,b [drv1]                        ; poke the drive letter
mov ah,':'                             ; and a colon
mov w [working],ax                     ; into the working buffer
mov di,(offset working) + 2
mov si,offset fn_buf                   ; add the user's directory spec
call copy_si_di_z                      ; (normally just a backslash, null)

truename_dir:                          ; attempt to canonicalize dirname :
testflag flag_sw_nc
jne truename_dir_xx
zero bx                                ; convenient zero
testflag flag_lfn_api                  ; long filename calls supported?
je truename_dir_short                  ; if not, go do short truename
truename_dir_long:
mov si,offset working                  ; source ds:si is working buffer
push cs
pop es
mov di,offset lfn_buffer               ; target es:di is the lfn buffer
mov w [di],bx                          ; empty the truename buffer
mov cx,8001                            ; long to short, don't fix subst
stc
doscall2 7160                          ; long filename truename call
jc truename_dir_short                  ; any problem, go do short instead
mov si,offset lfn_buffer
cmp w [si+1], '\' by ':'               ; got a valid truename?
jne truename_dir_short                 ; if not, go do short instead
mov di,offset working                  ; copy canonicalized directory name
call copy_essi_di_z                    ; into the working buffer
jmp truename_dir_xx                    ; done canonicalizing directory name
truename_dir_short:                    ; canonicalize without lfn support :
mov si,offset working
call find_null
mov w [si],00 by '?'                   ; poke in a question mark temporarily
push si
push ds
pop es
mov si,offset working                  ; source ds:si is the working buffer
mov di,offset end_of_data              ; target es:di is truename buffer
mov w [di],bx                          ; empty the truename buffer
stc
doscall 60                             ; canonicalize
pop si
mov b [si],bl                          ; and remove that question mark
jc truename_dir_xx                     ; any problem, skip it
cmp w [end_of_data+1],'\' by ':'       ; got a valid truename?
jne truename_dir_xx                    ; if not, skip it
mov si,offset end_of_data              ; start at the beginning
mov di,offset working
l30:
mov al,b [si]                          ; get a byte from the truename buffer
cmp al,'?'                             ; converting any question marks
if e mov al,00                         ; to nulls
mov b [di],al                          ; and copy to working buffer
inc si
inc di
cmp al,00                              ; until done
jne l30
truename_dir_xx:

mov si,offset working

start_loc_5:                           ; copy starting directory spec
zero di                                ; to the start
mov es,w [tree_seg]                    ; of the tree buffer
call copy_si_esdi_z
mov b [es:di],00                       ; finish up with a second null
mov w [tree_end],di                    ; and save offset of 2nd null

main_loop:                             ; MAIN LOCATE LOOP:
mov di,offset working
mov es,w [tree_seg]
zero si                                ; copy the first directory in tree
call copy_essi_di_z                    ; buffer to the working buffer
cmp di,(offset working) + max_fn_len
ja working_overflow
dec di
mov w [working_end],di                 ; save the offset of dirname's null
mov si,offset star_dot_star            ; add a filespec of *.*
call copy_si_di_z                      ; to the directory name
cmp di,(offset working) + max_fn_len
ja working_overflow
clearflag flag_dir_shown               ; current directory not yet shown
mov dx,offset working
mov cx,0016                            ; include hidden, system, subdirs
doscall 4e                             ; in dos find-first-match function
jnc found_something                    ; did dos find a match?
jmp next_dir                           ; no, use the next dir in tree buffer
working_overflow:
bomb msg_working_ov,09
found_something:                       ; yes, dos found a match:
clearflag flag_got_lfn                 ; note no long filename in buffer
cmp b [find_name],'.'                  ; was it the stupid . or .. entry?
je next_file                           ; if so, ignore it
mov si,offset find_name                ; copy the filename
mov di,w [working_end]                 ; into the working buffer
call copy_si_di_z                      ; right after the directory name:
cmp di,(offset working) + max_fn_len
ja working_overflow
test b [find_attr],10                  ; is the item a subdirectory?
je add_tree_not                        ; if not, don't add it to tree buffer
test2flags flag_sw_nr, flag_sw_t       ; switch /NR or /T specified?
jne add_tree_not                       ; if so, don't add it to tree buffer
mov di,w [tree_end]                    ; ADD THIS DIRECTORY TO TREE BUFFER :
mov si,offset working                  ; copy the working buffer
call copy_si_esdi_z                    ; to the end of the tree buffer
dec di
mov w [es:di],00 by '\'                ; then add a backslash
inc di
inc di
mov b [es:di],00                       ; and a double-null
mov ax,di                              ;    new code to watch tree_end:
cmp ax,w [tree_end]                    ;    has pointer overflowed?
jae add_tree_20                        ;    if not, continue
jmp err_tree_ov                        ;    if so, barf and die
add_tree_20:
mov w [tree_end],di                    ; save offset of the second null
add_tree_not:
call test_filename                     ; print filename if it matches spec.
next_file:                             ; look for next file in this directory
testflag flag_stdout                   ;    was output redirected?
je next_file1                          ;    if so, skip keyboard check
testflag flag_sw_c                     ;    output to command shell?
jne next_file1                         ;    if so, skip keyboard check
mov ah,01
int 16                                 ;    was a key pressed?
je next_file1                          ;    if not, go look for next file
mov al,b [lines_max]                   ;    key was hit:  enable scroll-
mov b [lines_count],al                 ;    pausing (it might be off)
call pause                             ;    and pause for user keystrokes
next_file1:                            ; look for next file in this directory
doscall 4f                             ; dos find-next function
jc next_dir                            ; if no more matches, do next dir
jmp found_something                    ; if another match, loop back, do it
next_dir:
call peter_line_fix                    ; do line feeds as needed
zero si                                ; start at beginning of tree buffer
call find_es_null                      ; and look for the first null
inc ax                                 ; is the character after it
cmp ax,w [tree_end]                    ; the final, tree-ending null?
je next_drive                          ; if so, skip ahead, do next drive
mov si,ax                              ; if not, more directories in tree buf
zero di                                ; so copy entire tree buffer down
call copy_essi_esdi_zz                 ; to overwrite first directory in it
mov w [tree_end],di                    ; save new end-of-tree pointer
jmp main_loop                          ; and loop back to do new 1st dir.
next_drive:                            ; THE TREE BUFFER HAS BEEN EXHAUSTED:
testflag flag_sw_t                     ; is this a /t path search?
jne final_exit                         ; if so, exit program now
testflag flag_unc                      ; is this a unc-type filespec?
jne final_exit                         ; if so, bug out
mov al,b [drv1]
cmp al,b [drv2]                        ; is this the final drive?
je final_exit                          ; if so, exit program
inc al                                 ; increment drive letter
mov b [drv1],al                        ; save new drive letter
jmp start_locate                       ; loop back, start a new tree

final_exit_1go:
jmp final_exit_1

final_exit:                            ; DONE SEARCHING FOR FILES:
mov ax,w [entry_count]
or ax,w [entry_count_hi]               ; were any files found?
jne final_1
jmp nothing_found                      ; if not, skip ahead ...
final_1:
mov bl,b [display]
mov bh,00
test b [num_blank_lines+bx],80         ; allowed to print extra info?
je final_exit_1go                      ; if not, skip ahead
call peter_line_fix
cmp b [display],dm_peter
je final_1a
cmp b [display],dm_longnames
je final_1a
cmp w [amp_h_point],0000
jne final_1a
call terminate_line                    ; some matches, print a blank line
final_1a:
mov dx,w [entry_count_hi]
mov ax,w [entry_count]                 ; get the big count value of entries
mov ch,00
call dec_print_big                     ; and print it out
mov b [msg_num_entries+5],ah
zprint msg_num_entries                 ; 'entries' message

mov dx,w [files_count_hi]
mov ax,w [files_count]                 ; get the big count value of files
mov ch,00
call dec_print_big                     ; and print it out
mov b [msg_num_files+5],ah
zprint msg_num_files                   ; 'files' message
testflag flag_sw_h                     ; displaying only hidden or system?
jne zero_hfiles                        ; if so, skip over h/s count display
mov al,b [attrib_care]
and al,b [attrib_value]                ; did the user require either of
test al,06                             ; h or s to be set?
jne zero_hfiles                        ; if so, skip over h/s count display
mov ax,w [hfiles_count]
or ax,w [hfiles_count_hi]              ; were any h/s files found?
je zero_hfiles                         ; if not, skip over h/s count display
zprint msg_hs
mov dx,w [hfiles_count_hi]
mov ax,w [hfiles_count]
mov ch,00
call dec_print_big                     ; display number of h/s files found
zprint msg_hs1
zero_hfiles:                           ; done with h/s files count display
zprint msg_num_files1

mov dx,w [dirs_count_hi]
mov ax,w [dirs_count]                  ; get the big count of directories
mov ch,00
call dec_print_big                     ; and print it out
mov b [msg_num_dirs+0a],ax
cmp ax,0ffff
jne num_dirs_plural
mov b [msg_num_dirs+9],'y'
num_dirs_plural:
zprint msg_num_dirs                    ; 'directories' message
testflag flag_sw_h                     ; displaying only hidden or system?
jne zero_hdirs                         ; if so, skip over h/s count display
mov al,b [attrib_care]
and al,b [attrib_value]                ; did the user require either of
test al,06                             ; h or s to be set?
jne zero_hdirs                         ; if so, skip over h/s count display
mov ax,w [hdirs_count]
or ax,w [hdirs_count_hi]               ; were any h/s dir's found?
je zero_hdirs                          ; if not, skip over h/s count display
zprint msg_hs
mov dx,w [hdirs_count_hi]
mov ax,w [hdirs_count]
mov ch,00
call dec_print_big                     ; display number of h/s dir's found
zprint msg_hs1
zero_hdirs:                            ; done with h/s dir's count display
zprint msg_num_dirs1

cmp w [max_count],0000                 ; was /f specified?
je final_exit_1b                       ; if not, we're done
mov ax,w [max_count]
cmp ax,w [entry_count]                 ; did we actually reach the /f max?
jne final_exit_1a                      ; if not, we're done
push ax
dosprint msg_maybe_more                ; if so, warn before finishing
pop ax
mov ch,00
call dec_print_small
dosprint msg_maybe_more_1
zprint msg_maybe_more_3
jmp final_exit_1a

final_exit_1b:                         ; if /f was not specified
testflag flag_went                     ; but the directory was changed by /g,
je final_exit_1a
zprint msg_maybe_more_2                ; print a slightly different warning

final_exit_1a:
mov ax,w [files_count]
or ax,w [files_count_hi]
je final_exit_1
dosprint msg_file_totals
mov ax,w [file_totals]
mov dx,w [file_totals_hi]
call show_size_totals
final_exit_1:
mov ax,w [kill_count]
or ax,w [kill_count_hi]
je no_kills_display
call terminate_line                    ; blank line
mov ax,w [kill_count]
mov dx,w [kill_count_hi]               ; get the big count value of files
mov ch,00
call dec_print_big                     ; and print it out
mov b [msg_num_files+5],ah
zprint msg_num_files                   ; 'files' message
dosprint msg_num_killed                ; 'killed' message
mov ax,w [kill_totals]
mov dx,w [kill_totals_hi]
call show_size_totals                  ; display total of deleted file sizes
no_kills_display:
mov ax,w [rmdir_count]
or ax,w [rmdir_count_hi]
je no_rmdir_display
mov ax,w [kill_count]
or ax,w [kill_count_hi]
jne > l4
call terminate_line                    ; blank line
l4:
mov dx,w [rmdir_count_hi]
mov ax,w [rmdir_count]                 ; get the big count of directories
mov ch,00
call dec_print_big                     ; and print it out
mov b [msg_num_dirs+0a],ax
cmp ax,0ffff
jne > l5
mov b [msg_num_dirs+9],'y'
l5:
zprint msg_num_dirs                    ; 'subdirectories' message
zprint msg_num_removed                 ; 'killed' message
no_rmdir_display:

call append_restore
doscall2 4c00                          ; and exit with errorlevel 00
nothing_found:
mov bl,b [display]
mov bh,00
test b [num_blank_lines+bx],80         ; allowed to print extra info?
je final_exit_2                        ; if not, skip ahead
zprint msg_nothing                     ; no matches, print a sorry message
final_exit_2:
call append_restore
doscall2 4c01                          ; and exit with errorlevel 01

test_filename:                         ; DOES FILENAME MATCH USER PATTERN?
mov si,w [working_end]                 ; start of found file's name
mov di,offset fs_buf                   ; start of user's filespec
mov b [pending_splats],00              ; note:  no splats pending
test_fn_1:                             ; loop to compare name with user spec.
mov al,b [si]                          ; al = byte from actual filename
call force_roman                       ; force to uppercase with no accents
mov ah,b [di]                          ; ah = byte from user template
cmp al,00                              ; end of filename?
je test_fn_z                           ; yes, go to special handler for that
cmp al,ah                              ; do they match?
je test_fn_m                           ; yes!  that's easy!  continue
cmp al,'.'
je > l1
cmp ah,'?'                             ; question mark in user filespec?
je test_fn_m                           ; yes, accept character
cmp ah,'['
jne > l1
call class_test
jnc test_fn_m
l1:
cmp ah,'*'                             ; asterisk in user filespec?
je test_fn_a                           ; yes, go to splat handler
                                       ; no, mismatch -- fall through to ...

test_fn_n:                             ; filename mismatch:
cmp b [pending_splats],00              ; any splats pending?
jne > l1
ret                                    ; no splats pending, exit w/ no action
l1:                                    ; one or more splats pending:
pop di                                 ; get pointer into found filename
pop si                                 ; get pointer into user template
cmp b [si],'.'                         ; starting at a period?
je > l4                                ; if so, desplat
cmp b [si],00                          ; starting at a null?
je > l4                                ; if so, desplat
inc si                                 ; otherwise, nudge filename pointer
push si
push di                                ; re-save both pointers
jmp test_fn_1                          ; and continue with compare
l4:                                    ; remove pending splats:
dec b [pending_splats]                 ; reduce splat count
jmp test_fn_n                          ; and try again

test_fn_m:                             ; this character matches:
inc di                                 ; increment pointers
inc si
jmp test_fn_1                          ; and loop back for next character

test_fn_a:                             ; found a splat:
inc di                                 ; bump template pointer
push si
push di                                ; save both filename pointers
inc b [pending_splats]                 ; count this splat
jmp test_fn_1                          ; and continue comparison

test_fn_z:                             ; end of filename:
mov ah,b [di]                          ; continue scanning through template
inc di
cmp ah,00                              ; hit end of user template?
je test_fn_y                           ; if so, filespec matches -- accept it
cmp ah,'*'                             ; asterisks remaining in template?
je test_fn_z                           ; asterisks are okay, skip over them
cmp ah,'.'                             ; period remaining in template?
je test_fn_z                           ; those are okay, skip them as well
jne test_fn_n                          ; anything else is a mismatch!

test_fn_y:                             ; FILENAME MATCHES USER FILESPEC :
mov al,b [pending_splats]              ; any splats pending?
cbw
shl ax,01                              ; multiply number of splats by four
shl ax,01
add sp,ax                              ; to remove pointers from stack
mov b [pending_splats],00              ; then zero pending-splats count

                                       ; CHECK FOR EXECUTABLE EXTENSIONS :
clearflag flag_exec_ext                ; assume not a special file
test b [find_attr],10                  ; is this item a subdirectory?
jne test_fn_xx                         ; if so, then it's not a special file
mov w [exttmp],0000h
mov b [exttmp+2],00h
mov si,w [working_end]                 ; in the filename,
mov bl,'.'                             ; search for the period
call find_first                        ; found a period?
je test_ex_1                           ; if not, assume empty extension
mov si,ax                              ; if so,
inc si                                 ; skip over the period
mov di,offset exttmp                   ; and copy the filename extension
call copy_si_di_z                      ; into the exttmp buffer
test_ex_1:
mov bx,offset extensions
test_ex_2:
zero si
cmp b [bx],':'                         ; end of the extensions buffer?
je test_fn_xx                          ; if so, no match
test_ex_3:
mov al,b [bx+si]
mov ah,b [exttmp+si]
cmp ah,00
je > l10
cmp al,'?'
je > l20
l10:
cmp al,ah
jne > l30
l20:
inc si
cmp si,0003
jne test_ex_3
setflag flag_exec_ext
jmp test_attr
l30:
add bx,0003
cmp bx,(offset extensions + (010xd * 3))
jb test_ex_2
test_fn_xx:
testflag flag_sw_x
je test_attr
ret

test_attr:                             ; FILENAME IS ACCEPTABLE:
mov al,b [attrib_care]
mov ah,al
and al,b [attrib_value]                ; attributes we must match
and ah,b [find_attr]                   ; value of those attribs for this file
cmp al,ah                              ; are they the same?
je attr_pass                           ; if so, display this file/directory
jmp not_kill                           ; if not, don't display it
attr_pass:
testflag flag_sw_h                     ; was /h specified?
je attr_pass_1                         ; if not, skip following test
test b [find_attr],06                  ; is file either hidden or system?
jne attr_pass_1
jmp not_kill                           ; if neither, don't display
attr_pass_1:                           ; FILENAME AND ATTRIB ARE ACCEPTABLE:
call compute_julian                    ; convert file date to julian and dow
mov ax,w [find_date]                   ; get file's date stamp
cmp ax,w [date_1]                      ; compare stamp against starting date
if b jmp not_kill                      ; if earlier, forget it
cmp ax,w [date_2]                      ; compare stamp against ending date
if a jmp not_kill                      ; if later, forget it
cmp b [check_dow],00
je date_pass_3
mov cl,b [f_dow]
mov al,01
shl al,cl
test b [check_dow],al
jne date_pass_3
jmp not_kill
date_pass_3:
mov ax,w [find_time]                   ; get file's time stamp
cmp ax,w [time_1]                      ; compare stamp against starting time
if b jmp not_kill                      ; if earlier, forget it
cmp ax,w [time_2]                      ; compare stamp against ending time
if a jmp not_kill                      ; if later, forget it
mov ax,w [find_size_lo]
mov dx,w [find_size_hi]                ; get file size in dx:ax
cmp dx,w [size_1+2]
if b jmp not_kill
ja > l10
cmp ax,w [size_1+0]
if b jmp not_kill
l10:
cmp dx,w [size_2+2]
if a jmp not_kill
jb > l20
cmp ax,w [size_2+0]
if a jmp not_kill
l20:
item_is_spiffing:                      ; FOUND ITEM IS WHOLLY ACCEPTABLE :
call empty_cmd_buf                     ; wipe out any buffered command data
mov al,b [col_hidden]                  ; use the 'hidden' color
test b [find_attr],06                  ; if the item is hidden
jne > l10
mov al,b [col_subdir]                  ; use the 'subdir' color
test b [find_attr],10                  ; if the item is a subdirectory
jne > l10
mov al,b [col_exec]                    ; use the 'executable' color
testflag flag_exec_ext                 ; if the item is a special file
jne > l10
mov al,b [col_normal]                  ; otherwise use the 'normal' color
l10:
mov b [col_item],al
mov bl,b [display]                     ; which display routine to use?
mov bh,00                              ; convert to a word
shl bx,01                              ; and multiply by two
mov ax,w [disp_routines+bx]            ; get the address of display routine
jmp ax                                 ; to jump to


show_peter:                            ; PETER-STYLE FILENAME OUTPUT:
testflag flag_dir_shown                ; has the current dir been displayed?
jne peter_dir_done                     ; if so, don't display it again
call fout_pat                          ; display directory name
call terminate_line                    ; and terminate line
setflag flag_dir_shown                 ; note that dir was printed
peter_dir_done:
cmp b [wide_count],00
je peter_long
call fout_2sp                          ; display two spaces
call fout_jus
dec b [wide_count]
cmp b [wide_count],00
jne peter_wide_4
mov al,b [wide_max]
mov b [wide_count],al
call terminate_line
peter_wide_4:
jmp name_done

peter_long:                            ; standard peter-syle display :
testflag flag_sw_i
je > l05
mov b [dp_min],07
mov ax,w [entry_count]
mov dx,w [entry_count_hi]
inc ax
jne > l03
inc dx
l03:
mov ch,00
call dec_print_big
l05:
mov cx,0003
call fout_tab_1                        ; tab in three spaces
call fout_jus                          ; show the justified filename
call fout_2sp                          ; and another space
call fout_dow                          ; display day of the week
call space_out                         ; and one space
call show_date                         ; display date in correct local format
call show_time                         ; display time in correct local format
call fout_bra                          ; display attributes
call fout_2sp                          ; and two spaces
test b [find_attr],10
je > l10
mov cx,0007
call fout_tab_1
dosprint msg_info_dir
jmp > l20
l10:
call show_size_pretty
testflag flag_sw_i
jne > l20
call fout_2sp
call show_size_kb_mb
l20:
call terminate_line                    ; end output line
jmp name_done

batch_output:                          ; BATCH-FILE OUTPUT :
zprint bat_buf                         ; print command first
call fout_fil                          ; then the fully qualified filename
cmp b [bat_args],00                    ; supposed to print any %x arguments ?
je bat_line_done                       ; no, skip ahead
mov b [msg_bat_arg+2],'1'              ; yes, start with %1
do_bat_args:
zprint msg_bat_arg                     ; print numerical argument
inc b [msg_bat_arg+2]                  ; and increment the number
mov al,b [msg_bat_arg+2]
cmp al,b [bat_args]                    ; done yet ?
jna do_bat_args                        ; if not, loop back for next
bat_line_done:
call terminate_line                    ; terminate print line
jmp name_done                          ; done with batch output

formatted_output:                      ; PRINT OUT /O STRING:
zero bx
mov bp,offset bat_buf                  ; start at the beginning
mov w [condition_point],bx
mov b [condition_char],bl              ; no conditional string in progress
cmp w [amp_h_point],bx
je fout1
testflag flag_dir_shown
je > l1
mov bp,w [amp_h_point]
l1:
setflag flag_dir_shown
fout1:
mov dl,b [bp]                          ; get a character from the buffer
inc bp
cmp dl,01                              ; hit the end of the buffer yet?
jbe fout_x                             ; if so, done with /o string
cmp dl,b [condition_char]
je fout_skip
cmp dl,'&'                             ; is it an ampersand?
je fout_sw                             ; if so, treat as a macro switch
call dlout                             ; if not, just print it out
jmp fout1                              ; and loop back for the next char.

fout_sw:                               ; found an ampersand:
mov al,b [bp]                          ; get the next character after it
call force_uc                          ; and convert to uppercase
zero bx                                ; from the top:
fout_sw1:
mov ah,b [fout_switches+bx]            ; find it in the list of switch chars.
cmp ah,00                              ; if not found,
je > l1                                ; just print an & and the character
cmp al,ah
je fout_sw2                            ; if found,
inc bx
jmp fout_sw1
l1:
call fout_amp
jmp fout1

fout_sw2:
inc bp                                 ; skip over the switch char.
shl bx,01                              ; multiply the index by two
mov ax,w [fout_routines+bx]            ; get address of appropriate routine
call ax                                ; and go do it!
jmp fout1                              ; then continue with main macro loop

fout_x:                                ; end of the /o string:
call terminate_line                    ; terminate the output line
jmp name_done                          ; and we're done printing the filename

fout_skip:
mov bp,w [condition_point]
inc bp
mov w [condition_point],0000
mov b [condition_char],00
jmp fout1

fout_amp:                              ; macro &&
mov dl,'&'                             ; just print an ampersand
fout_amp_1:
jmp dlout

fout_esc:                              ; macro &e
mov dl,1b                              ; print an ascii escape
jmp fout_amp_1

fout_quo:                              ; macro &q
mov dl,'"'                             ; print a quote mark
jmp fout_amp_1

fout_fil:                              ; macro &f
mov si,offset working                  ; print out the full filespec
fout_fil0:
mov dl,b [si]                          ; get a byte from the working buffer
inc si
cmp dl,00                              ; end of buffer yet?
je ret                                 ; if so, exit
call dlout                             ; if not, print the character
jmp fout_fil0                          ; and loop back for the next one

fout_buk:                              ; macro &s
mov si,offset working+0002             ; print out the filespec without
testflag flag_unc                      ; a drive letter
je fout_fil0
mov si,offset working
jmp fout_fil0

fout_dir:                              ; macro &d
call find_last_bs_w                    ; find the last backslash in filespec
cmp ax,offset working+0002             ; is this item in the root directory?
ja fout_dir1
inc ax                                 ; if so, stop just after it
fout_dir1:                             ; if not, stop at it
mov cx,ax                              ; save the offset of character to zero
mov bx,offset working                  ; from the start of the working buffer
fout_dir2:
mov dl,b [bx]                          ; get a character from the dir name
inc bx
call dlout                             ; and print it out
cmp bx,cx                              ; printed the last character yet?
jb fout_dir2                           ; no, loop back
fout_fil2:
ret                                    ; yes, done

fout_pat:                              ; macro &p
call find_last_bs_w                    ; find the last backslash in filespec
inc ax                                 ; stop just after it
jmp fout_dir1                          ; print directory name with &d routine

fout_gob:                              ; macro &g
call find_last_bs_w                    ; find the last backslash in filespec
cmp ax,offset working + 2
ja > l10
inc ax
l10:
mov cx,ax
mov bx,offset working
testflag flag_unc
jne > l20
inc bx
inc bx
l20:
mov ah,02
jmp fout_dir2

fout_nam:                              ; macro &n
call find_last_bs_w                    ; find the last backslash in filespec
mov si,ax
inc si                                 ; starting just after it,
jmp fout_fil0                          ; print filespec with &f routine

fout_jus:                              ; macro &j
mov al,b [col_item]                    ; use the item's appropriate color
mov b [color],al
call find_last_bs_w                    ; find the last backslash in filespec
mov si,ax
inc si                                 ; starting just after it,
mov cx,0d
l3:
lodsb
call peter_case
mov dl,al
cmp dl,00
je > l5
call dlout
dec cx
jmp l3
l5:
mov al,b [col_normal]                  ; return to the normal default color
mov b [color],al
jmp fout_tab_1

fout_roo:                              ; macro &r
call find_last_bs_w                    ; find the last backslash in filespec
mov si,ax
inc si                                 ; starting just after it,
fout_roo1:
mov dl,b [si]                          ; get a character from filespec
inc si
cmp dl,00                              ; end of filespec yet?
je fout_roo2                           ; if so, done
cmp dl,'.'                             ; found the extension separator yet?
je fout_roo2                           ; if so, done
call dlout                             ; otherwise, print it out
jmp fout_roo1                          ; and loop back for the next char
fout_roo2:
ret

fout_ext:                              ; macro &x
call find_last_bs_w                    ; find the last backslash in filespec
mov si,ax
inc si                                 ; starting just after it,
mov bl,'.'
call find_last                         ; find the period
je fout_roo2                           ; if not found, simply exit
mov si,ax                              ; if found,
inc si                                 ; starting just after the period,
fout_ext1:
mov dl,b [si]                          ; get a character from the extension
inc si
cmp dl,00                              ; null?  if so, done
je fout_roo2
call dlout                             ; print it out
jmp fout_ext1                          ; and loop back for the next

fout_att:                              ; macro &a
mov ah,b [find_attr]                   ; get attributes byte in .ah
zero si       
test ah,20                             ; character before 'A'
call fout_att2                         ; set according to 'archive me' bit
test ah,04                             ; character before 'S'
call fout_att2                         ; set according to 'system' bit
test ah,02                             ; character before 'H'
call fout_att2                         ; set according to 'hidden' bit
test ah,01                             ; character before 'R'
call fout_att2                         ; set according to 'read-only' bit
dosprint msg_attrib_2                  ; print the whole mess out
ret                                    ; done with this macro
fout_att2:
mov dl,'-'                             ; bit clear, use a minus
je fout_att3
mov dl,'+'                             ; bit set, use a plus
fout_att3:
mov b [msg_attrib_2+si],dl             ; poke plus or minus into string
add si,0003                            ; and advance the pointer
ret

fout_let:                              ; macro &l
testflag flag_unc
jne ret
mov dl,b [working+0]
call dlout                             ; print the first character
mov dl,':'                             ; and a colon
call dlout                             ; also pretty cheap
ret

fout_inz:
mov b [dp_space],'0'
fout_ins:
mov al,b [bp]
cmp al,'0'
je > l10
jb > l20
cmp al,'9'
ja > l20
sub al,'0'
mov b [dp_min],al
jmp > l15
l10:
mov b [dp_min],0a
l15:
inc bp
l20:
mov ax,w [entry_count]
mov dx,w [entry_count_hi]
inc ax
jne > l95
inc dx
l95:
mov ch,80
call dec_print_big
ret

fout_win:                              ; macro &w
call get_long_filename                 ; convert short filename to long
if c jmp fout_fil                      ; if error, display full 8.3 filename
mov si,offset lfn_buffer               ; start at the beginning
jmp > l10                              ; print out long filename

fout_ldn:                              ; macro &y
call get_long_filename                 ; convert short filename to long
if c jmp fout_pat                      ; if error, display short pathname
call grope_lfn                         ; search for final backslash in lfn
if e jmp fout_pat                      ; if there is none, do &p instead
mov si,offset lfn_buffer               ; start at the beginning
jmp fout_lfn_buf                       ; print out long filename

fout_zin:                              ; macro &z
call get_long_filename                 ; convert short filename to long
if c jmp fout_nam                      ; if error, display 8.3 filename
call grope_lfn                         ; search for final backslash in lfn
if e jmp fout_nam                      ; if there is none, do &n instead
mov si,bx
inc si                                 ; start just past the backslash
l10:
mov bx,0ffff                           ; and fall through to ....

fout_lfn_buf:                          ; routine used to print long filenames
testflag flag_lfn_chop                 ; supposed to chop long filenames?
je > l45                               ; if not, don't worry about it
mov cx,w [lfn_chop]
inc cx
inc cx
mov di,si
l05:
mov dl,b [di]
inc di
cmp dl,00
je > l10
inc cx
cmp di,bx
jna l05
l10:                                   ; done walking long filename :
cmp cx,w [columns]                     ; enough space to print entire string?
jb > l45                               ; yes, go ahead and do it
cmp bx,0ffff
jne > l20
mov bx,si
add bx,w [columns]
sub bx,w [lfn_chop]
sub bx,0007
mov ch,80
jmp > l50
l20:
sub cx,w [columns]
add si,cx
add si,0004
mov dl,'"'
call dlout
mov dl,'.'
call dlout
call dlout
call dlout
mov ch,00
jmp > l55
l45:
mov ch,00                              ; no ellipsis
l50:
mov dl,'"'
call dlout                             ; print an opening quote mark
l55:
mov dl,b [si]                          ; get a character from lfn buffer
inc si
cmp dl,00                              ; hit the end of the buffer?
je > l60                               ; if so, exit
call dlout                             ; if not, print the character
cmp si,bx
jna l55                                ; and loop back for next
l60:
test ch,80                             ; need an ellipsis?
je > l65                               ; no, branch ahead
mov dl,'.'
call dlout                             ; yes, print three periods
call dlout
call dlout
l65:                                   ; done with ellipsis :
mov dl,'"'
call dlout                             ; print closing quote mark
ret                                    ; and exit

get_long_filename:                     ; convert short filename to long :
testflag flag_lfn_api                  ; are long filenames supported?
je get_lfn_err                         ; if not, exit with carry set
testflag flag_got_lfn                  ; already converted this filename?
jne get_lfn_okay                       ; if so, exit with carry clear
mov si,offset working                  ; ds:si points to 8.3 filename
push es
push cs
pop es
mov di,offset lfn_buffer               ; es:di points to lfn buffer
mov cx,8002
stc
doscall2 7160                          ; truename:  convert to long filename
pop es
jc get_lfn_err                         ; if any problem, exit with carry set
setflag flag_got_lfn
get_lfn_okay:                          ; all is hunky dory
clc                                    ; so exit with carry clear
ret
get_lfn_err:                           ; error converting filename :
stc                                    ; and exit with carry set
ret

grope_lfn:                             ; find final backslash in lfn buffer :
mov si,offset lfn_buffer
call find_last_bs
mov bx,ax
ret

fout_lbn:                              ; macro &v
call get_long_filename                 ; convert short filename to long
if c jmp fout_roo                      ; if error, display short basename
zero bx                                ; starting location of part to display
mov si,bx
mov cx,0ffff                           ; ending location of part to display
l10:
mov al,[lfn_buffer+si]                 ; parse through long filename....
cmp al,'.'                             ; found a period?
jne > l20
mov cx,si                              ; if so, note end of string to display
l20:
inc si
cmp al,'\'                             ; found a backslash?
jne > l30
mov bx,si                              ; if so, start of string to display
l30:
cmp al,00                              ; found a null?
jne l10                                ; if not, continue search
mov si,bx                              ; start at beginning of basename....
l40:
mov dl,[lfn_buffer+si]                 ; get a character from long filename
cmp dl,00                              ; end of filename?
je ret                                 ; if so, exit
cmp si,cx                              ; start of extension?
je ret                                 ; if so, exit
inc si
call dlout                             ; otherwise, display the character
jmp short l40                          ; and continue bravely onward
ret

fout_lex:                              ; macro &k
call get_long_filename                 ; convert short filename to long
if c jmp fout_ext                      ; if error, display short extension
call grope_lfn                         ; find last backslash in buffer
je ret                                 ; if no backslash, exit
zero cx
mov si,bx
l10:
inc si
mov al,[si]                            ; hunt through lfn buffer :
cmp al,00                              ; hit the end of the filename?
je > l20                               ; if so, done searching for dots
cmp al,'.'                             ; found a dot?
jne l10                                ; if so,
mov cx,si                              ; remember its location
jmp l10
l20:                                   ; done with dot search :
testzero cx                            ; found any dots?
je ret                                 ; if not, just exit
mov si,cx
l30:
inc si
mov dl,[si]                            ; get a character from long filename
cmp dl,00
je ret
call dlout
jmp l30
ret

fout_siz:
test b [find_attr],10
jne > l1
mov dx,w [find_size_hi]
mov ax,w [find_size_lo]
mov ch,80
mov b [dp_min],0a
jmp dec_print_big
l1:
mov cx,000a
jmp fout_tab_1

fout_con:
cmp b [condition_char],00
jne fout_con_bad
mov al,b [bp]
inc bp
cmp al,01
jbe fout_con_bad
call force_uc
zero si
l1:
cmp al,b [attr1+si]
je > l2
inc si
cmp si,0005
je fout_con_bad
jne l1
l2:
mov cl,b [attr_v+si]                   ; save attribute to test in .cl
mov al,b [bp]
cmp al,01
jbe fout_con_bad
cmp al,'&'
je fout_con_bad
mov b [condition_char],al              ; save delimiter character
push bp                                ; save address of true string on stack
call condition_find_sub                ; find next delimiter char
push bp                                ; save address of false string on stack
call condition_find_sub                ; find final delimiter char
mov w [condition_point],bp             ; and store its address
test b [find_attr],cl                  ; check specified attribute
je > l4
pop bp
pop bp
inc bp
ret
l4:
pop bp
inc bp
pop cx
ret

fout_con_bad:
bomb msg_err_condition,10

condition_find_sub:
inc bp
mov al,b [bp]
cmp al,01
jbe fout_con_bad
cmp al,b [condition_char]
jne condition_find_sub
ret

fout_2sp:
mov cx,0002
jmp fout_tab_1
fout_tab:
mov cx,0005
fout_tab_1:
mov dl,20
l1:
call dlout
loop l1
ret

fout_dow:                              ; display day of the week :
mov dl,b [f_dow]
mov dh,00
shl dx,01
shl dx,01
add dx,offset dow_names
call strout
ret

fout_hue:                              ; macro &+   set output color
mov al,b [bp]                          ; examine next character in buffer
cmp al,'0'
jb ret                                 ; is it a digit in the range 0-5 ?
cmp al,'5'                             ; if not, just bug out
ja ret
inc bp
sub al,'0'
mov ah,00
mov si,ax
mov al,b [col_normal+si]
mov b [color],al
ret

bare_naked:
zprint working
jmp name_done

lfn_output:                            ; OUTPUT VIA /L METHOD:
testflag flag_dir_shown
jne > l10
mov w [lfn_chop],0000
call fout_ldn
call terminate_line
setflag flag_dir_shown
l10:
call fout_jus
call space_out
call show_date
call fout_siz
call fout_2sp
mov al,b [col_item]
mov b [color],al
mov w [lfn_chop],0027
call fout_zin
call terminate_line
jmp name_done

name_done:                             ; DONE PRINTING FILENAME BY WHATEVER
inc w [entry_count]                    ; MEANS:
jne attr_done_0
inc w [entry_count_hi]                 ; increment the big entry count
attr_done_0:
test b [find_attr],10                  ; file or directory?
jne attr_done_dir
inc w [files_count]
jne add_filesize
inc w [files_count_hi]                 ; increment the big file count
add_filesize:
mov ax,w [find_size_lo]
add w [file_totals],ax
mov ax,w [find_size_hi]
adc w [file_totals_hi],ax
test_hfiles:
test b [find_attr],06                  ; is this file hidden or system?
je attr_done_1                         ; if not, don't bump h/s files count
inc w [hfiles_count]
jne attr_done_1
inc w [hfiles_count_hi]                ; increment the big h/s files count
jmp attr_done_1
attr_done_dir:
inc w [dirs_count]
jne test_hdirs
inc w [dirs_count_hi]                  ; increment the big directory count
test_hdirs:
test b [find_attr],06                  ; is this directory hidden or system?
je attr_done_1                         ; if not, don't bump h/s dir's count
inc w [hdirs_count]
jne attr_done_1
inc w [hdirs_count_hi]                 ; increment the big h/s dir's count
attr_done_1:
testflag flag_sw_g                     ; was /g specified?
je not_goto                            ; if not, don't worry about it
cmp w [max_count],0000                 ; /g:  was a count specified?
je goto_ask                            ; no, ask the user whether to go
mov ax,w [max_count]                   ; yes:  is this the final find?
cmp ax,w [entry_count]
jne not_goto                           ; no, never mind
je goto_dir                            ; final find, go to directory
goto_ask:                              ; /g specified, no count:
call control_color                     ; use the 'control message' color
dosprint msg_go_ask
call normal_color                      ; use the 'normal items' color
call ask_yorn                          ; ask user whether or not to go
jne not_goto                           ; if no, forget it
goto_dir:
call go_there                          ; go to directory
jmp final_exit                         ; and exit this program

not_goto:
testflag flag_sw_k                     ; was /k specified?
je not_kill                            ; if not, don't worry about it
testflag flag_sw_y                     ; was /y specified?
jne kill_you_betcha                    ; if so, kill file without asking
call control_color                     ; use the 'control messages' color
dosprint msg_kill_ask
call normal_color                      ; use the 'normal items' color
call ask_yorn                          ; ask user whether or not to delete
jne not_kill                           ; if no, forget it
kill_you_betcha:
call kill_file                         ; terminate file with prejudice

not_kill:
cmp w [max_count],0000                 ; was there a /f specified?
je attr_done_2                         ; if not, exit
mov ax,w [max_count]                   ; /f was specified:
cmp ax,w [entry_count]                 ; have we shown enough entries?
jne attr_done_2                        ; if not, exit
pop ax                                 ; whoops, all done:  clear the stack
jmp final_exit                         ;   and i am outta here!
attr_done_2:
ret

fout_bra:
zero si                                ; pointer to bit-name letters
mov cl,20                              ; highest bit is #5 (archive)
attr_loop:
mov dl,'.'                             ; assume a dot
test b [find_attr],cl                  ; is this bit set?
je attr_go                             ; clear, use the dot
mov dl,b [attr1+si]                    ; set, get the bit-name letter instead
attr_go:
call dlout                             ; print dot or letter
inc si                                 ; and move along
attr_skip:
shr cl,1                               ; and shift right to next bit
cmp cl,08                              ; bit 3 (volume label/lfn) we don't
je attr_skip                           ; care about, so skip it
cmp cl,00                              ; run out of bits?
jne attr_loop                          ; no, loop back for next
ret                                    ; yes, exit

show_size_totals:
mov w [find_size_lo],ax
mov w [find_size_hi],dx                ; save size total (for kb/mb later)
mov ch,00                              ; with commas,
call dec_print_big                     ; display total of sizes
cmp ah,0ff
if e mov ah,20
mov b [msg_info_open+05],ah            ; pluralize 'bytes' string correctly
dosprint msg_info_open                 ; display 'bytes' string
call show_size_kb_mb_1                 ; display file size in kb or megs
call terminate_line                    ; done with file info, complete line
ret

fout_pre:                              ; display file size in bytes:
show_size_pretty:
test b [find_attr],10
je > l10
mov cx,000d
jmp fout_tab_1
l10:
mov b [dp_min],0d                      ; thirteen digits for size display
mov dx,w [find_size_hi]
mov ax,w [find_size_lo]                ; get the file's size
mov ch,00
call dec_print_big                     ; and display it
ret

fout_kmb:                              ; display file size in kb or megs:
show_size_kb_mb:
test b [find_attr],10
je show_size_kb_mb_1
mov cx,0009
jmp fout_tab_1
show_size_kb_mb_1:
mov dx,w [find_size_hi]
mov ax,w [find_size_lo]
cmp dx,0010                            ; is the file 1 mb or larger?
jae show_size_mb                       ; if so, show file size in megs
show_size_kb:                          ; otherwise, report file size in kb:
mov dx,w [find_size_hi]
mov ax,w [find_size_lo]                ; dword file size
mov cl,0a
shr ax,cl                              ; divide low word by 1024
mov cl,06
shl dx,cl                              ; get most significant bits
or ax,dx
mov ch,80
mov b [dp_min],04
call dec_print_small                   ; and display kb value
mov ax,w [find_size_lo]                ; get fractional kb
shr ax,01                              ; in al (0 to 255)
shr ax,01
call show_fraction                     ; and display fractional kb
dosprint msg_info_kb                   ; show 'kilobytes' message
ret
show_size_mb:                          ; report file size in mb:
mov ax,w [find_size_hi]
mov cl,04
shr ax,cl                              ; file size in mb
mov ch,80
mov b [dp_min],04
call dec_print_small                   ; display mb value
mov ax,w [find_size_lo]
mov dx,w [find_size_hi]
mov cl,0c
shr ax,cl
mov cl,04
shl dx,cl
or ax,dx                               ; fractional mb value (0-255) in al
call show_fraction                     ; display fractional mb
dosprint msg_info_mb                   ; show 'megabytes' message
ret

show_date:                             ; display file's date stamp:
call fout_dat
jmp fout_2sp

fout_dat:
mov al,b [country_date]                ; check country's date format
cmp al,01
je show_datee                          ; 01, european date format
cmp al,02
je show_datej                          ; 02, japanese date format
mov ax,w [find_date]
testzero ax                            ; date value of zero?
je show_date_null                      ; if so, just display a blank
call show_month                        ; display the month
call space_out                         ; and a space
mov ax,w [find_date]                   ; file's date stamp:
and al,1f                              ; get day value in al
mov ah,80                              ; without leading zeroes,
call time_print                        ; print day
call space_out                         ; and a space
show_year:
mov ax,w [find_date]                   ; file's date stamp:
mov cl,09
shr ax,cl                              ; get year value in al
add ax,01980xd                         ; and normalize
mov ch,80
call dec_print_small                   ; print the year
ret

show_date_null:
mov cx,000b
jmp fout_tab_1

show_datee:                            ; show date, european:
mov ax,w [find_date]                   ; file's date stamp:
testzero ax                            ; null date?
je show_date_null                      ; if so, just display a blank
and ax,001f                            ; get day value in al
or ah,80
call time_print                        ; print day without leading zeroes
call space_out                         ; and a space
call show_month                        ; display the month
call space_out                         ; and another space
jmp show_year                          ; display the year and exit

show_datej:                            ; show date, japanese :
call space_out                         ; display a leading space
fout_da2:                              ; show date, iso :
call show_year                         ; display the year
mov dl,'-'
call dlout                             ; and a dash
mov ax,w [find_date]
mov cl,5
shr ax,cl
and al,0f
call time_print
mov dl,'-'
call dlout                             ; and a third space
mov ax,w [find_date]                   ; file's date stamp:
and ax,001f                            ; get day value in al
call time_print                        ; print day with leading zeroes
ret

show_month:
mov dx,w [find_date]
and dh,01
mov cl,05
shr dx,cl                              ; get month value in dx
cmp dl,00
je > l10
cmp dl,0c
ja > l10
dec dl
shl dx,1
shl dx,1
add dx,offset month_names
jmp strout
l10:
push dx
call space_out
pop ax
jmp time_print

show_time:                             ; display file's time stamp:
call fout_tim
jmp fout_2sp

fout_ti2:
mov bh,b [country_tsep]
mov b [country_tsep],':'
mov bl,00
call > l10
mov b [country_tsep],bh
ret

fout_tim:
mov bl,80
l10:
mov ax,w [find_time]                   ; file's time stamp:
mov cl,0b
shr ax,cl                              ; get hour in al
mov ch,20
cmp b [country_time],00                ; do the locals use a 24-hour clock?
jne show_time_20                       ; if so, skip all am / pm fiddling
cmp bl,00
je show_time_20
mov ch,'a'                             ; assume a.m.
cmp al,00                              ; is it midnight?
jne show_time_15                       ; no, continue ....
mov al,0c                              ; display midnight as '12 am'
jmp show_time_20
show_time_15:                          ; not midnight:
cmp al,0c                              ; is it before noon?
jb show_time_20                        ; if so, don't need to manipulate it
mov ch,'p'                             ; noon or later:  display as 'pm'
cmp al,0c                              ; is it noon?
je show_time_20                        ; if so, display as '12 pm'
sub al,0c                              ; otherwise, normalize hours
show_time_20:                          ; done fiddling with hours:
mov ah,bl                              ; suppress leading zeroes
call time_print                        ; and print hours
mov dl,b [country_tsep]
call dlout                             ; followed by the time separator char
mov ax,w [find_time]                   ; file's time stamp:
and ah,07
mov cl,05
shr ax,cl                              ; get minutes in al
call time_print                        ; print minutes with leading zeroes
mov dl,b [country_tsep]
call dlout                             ; print time separator
mov ax,w [find_time]                   ; file's time stamp:
and ax,001f                            ; mask off seconds field
shl ax,01                              ; and multiply by two
call time_print                        ; display seconds with leading zeroes
l20:
cmp bl,00
je ret
mov dl,ch
jmp dlout

show_fraction:                         ; al contains a value 0-255:
push ax                                ; save it
mov dl,b [country_deci]
call dlout                             ; display a decimal point
pop ax                                 ; al contains 0-255:
mov ah,00                              ; convert to word length
mov bl,64
mul bl                                 ; multiply by 100
test al,80
je show_frac_fix
cmp ah,063
jae show_frac_fix
inc ah
show_frac_fix:
mov al,ah                              ; then divide by 256
mov ah,00                              ; and fall through

time_print:
mov dx,'0' by '0'
time_print_1:
cmp al,0a
jb time_print_2
sub al,0a
inc dl
jmp time_print_1
time_print_2:
add dh,al
test ah,80
je time_print_3
cmp dl,'0'
jne time_print_3
mov dl,20
time_print_3:
call dlout
mov dl,dh
jmp dlout

peter_line_fix:
testflag flag_dir_shown
je peter_line_x
call terminate_line
clearflag flag_dir_shown
mov al,b [wide_count]
cmp al,00
je peter_line_x
cmp al,b [wide_max]
je peter_line_x
call terminate_line
mov al,b [wide_max]
mov b [wide_count],al
peter_line_x:
ret

path_bad:                              ; no path variable:
jmp main_loop                          ; exit.  search only current directory

use_path:                              ; FILL TREE BUFFER FROM PATH VARIABLE:
doscall 19                             ; get the current drive
add al,'A'                             ; and convert to a letter
mov ah,':'                             ; add a colon
mov es,w [tree_seg]                    ; segment of tree buffer
zero si                                ; at the beginning:
mov w [es:si],ax                       ; poke the drive letter and colon
inc si
inc si
mov b [es:si],'\'                      ; add a backslash
inc si
doscall 19                             ; get the current drive again
mov dl,al
inc dl                                 ; convert to a 1-based number in dl
mov ds,w [tree_seg]                    ; ds:si points right after the \
doscall 47                             ; add the current directory after \
push cs
pop ds                                 ; put ds back where god intended
mov es,w [tree_seg]                    ; es points to the tree buffer 
zero si
call find_es_null                      ; find the terminal null
cmp ax,0004                            ; is the current directory the root?
jb use_path_fix
mov b [es:si],'\'                      ; if not, add a final backslash
inc si
use_path_fix:
mov w [es:si],0000                     ; add a double-null
inc si
mov w [tree_end],si                    ; and save offset of the 2nd null

cmp w [env_seg],0008                   ; reasonable segment for environment?
jna path_bad                           ; if not, something is wrong

mov bp,offset var_path                 ; look for the path= variable
call find_env_var
jne path_bad                           ; if no path= variable, abort
mov w [env_temp],si                    ; save pointer

path_loop:
mov es,w [env_seg]
mov si,w [env_temp]                    ; pointer into path value
mov di,offset working                  ; pointer into working buffer
mov dl,00                              ; no last character
path_loop_1:
mov al,b [es:si]                       ; get a byte from path value
inc si                                 ; and increment pointer
call force_uc                          ; no lowercase, please
call test_space_1                      ; is it a space ?
je path_loop_1                         ; if so, ignore it
cmp al,'/'                             ; is it a slash? (should never happen)
jne path_loop_2
mov al,'\'                             ; if so, substitute a backslash
path_loop_2:
cmp al,';'                             ; semicolon = end of directory name
je path_loop_3
cmp al,00                              ; null = end of directory name
je path_loop_3
mov b [di],al                          ; otherwise, copy into working buffer
inc di
mov dl,al                              ; and save this character as last char
jmp path_loop_1                        ; and loop back for next
path_loop_3:                           ; directory name in working buffer :
cmp di,offset working                  ; is there really?
je path_whoops                         ;    maybe not ...
cmp dl,'\'                             ; was the last character a backslash?
je path_loop_4
mov b [di],'\'                         ; if not, add a backslash to the end
inc di
path_loop_4:
mov w [env_temp],si                    ; save pointer into environment
mov b [di],00                          ; null-terminate the working dir name
mov dl,al                              ; and stash the semicolon or null
mov si,offset working                  ; compare the directory name
mov es,w [tree_seg]                    ; with the first directory in the
zero di                                ; tree buffer (the current directory)
call compare_si_esdi_z                 ; are they identical?
je path_loop_5                         ; if so, don't add this directory
mov si,offset working                  ; probably not a duplicate:
mov di,w [tree_end]
call copy_si_esdi_z                    ; copy directory onto end of tree
mov b [es:di],00                       ; and add a second null
mov w [tree_end],di                    ; save address of second null
path_loop_5:
cmp dl,00                              ; found the null at end of path var?
jne path_loop                          ; no, loop back for next dir name
path_bad_2:
jmp main_loop                          ; done filling tree_buffer from path
path_whoops:                           ; working buffer is empty!  this may
cmp al,00                              ; happen with pathological paths.
je path_bad_2                          ; abort if end of variable reached;
mov w [env_temp],si                    ; otherwise, attempt to continue
jmp path_loop                          ; parsing path variable.

compute_julian:                        ; calculate file's julian and dow :
mov dx,w [find_date]
mov ax,dx                              ; get file date stamp in .ax
mov cl,09
shr ax,cl                              ; get year in .ax (0 = 1980)
mov w [f_year],ax                      ; save year
mov b [months_table+01],1c             ; assume 28 days in february
cmp ax,0120xd                          ; year 2100?
je > l2                                ; if so, not a leap year
test b [f_year],03                     ; is year divisible by 4?
jne > l2                               ; if not, not a leap year
inc b [months_table+01]                ; leap year; 29 days in february
l2:
mov ax,dx                              ; get file date stamp in .ax
mov cl,05
shr ax,cl
and ax,000f                            ; get month in .ax
je julian_error                        ; month of zero?  if so, illegal
cmp al,0c                              ; month above 12 ?
ja julian_error                        ; if so, illegal
mov w [f_month],ax                     ; save month
mov ax,dx                              ; get file date stamp in .ax
and ax,001f                            ; get date in .ax
je julian_error                        ; date of zero?  if so, illegal
mov bx,w [f_month]
dec bx
mov cl,b [months_table+bx]             ; get length of current month in .cl
cmp al,cl                              ; date greater than maximum?
ja julian_error                        ; if so, illegal
inc ax
mov w [f_julian],ax                    ; save date+1 as julian number
compute_julian_alt:
zero bx
l3:
mov al,b [months_table+bx]             ; get length of month
cbw                                    ; as a word
inc bx
cmp bx,w [f_month]                     ; hit the correct month yet?
je > l4                                ; yes, exit this loop
add w [f_julian],ax                    ; no, add month length into julian
jmp l3                                 ; and loop back for next month
l4:                                    ; added in lengths of previous months:
mov bx,w [f_year]                      ; get year in .bx
or bx,bx                               ; dos year zero?
je > l8                                ; if so, skip following calculations
mov ax,bx
mov dx,0365xd
mul dx                                 ; multiply year number by 365
add w [f_julian],ax                    ; and add into the julian number
mov ax,bx
dec ax                                 ; decrement year number
shr ax,01                              ; divide by four
shr ax,01
inc ax                                 ; and add one
add w [f_julian],ax                    ; to get number of leap days
cmp bx,0120xd                          ; year greater than 2100?
jbe > l8                               ; if so, subtract one
dec w [f_julian]                       ; (no february 29, 2100)
l8:                                    ; got the julian number:
mov ax,w [f_julian]
zero dx
mov cx,0007                            ; divide julian number by seven
div cx                                 ; to get the day of the week
mov b [f_dow],dl                       ; save day of the week
ret                                    ; and exit
julian_error:                          ; error calculating julian :
mov w [f_julian],0000                  ; supply a bogus julian of zero
mov b [f_dow],07                       ; and a bogus day-of-the-week
ret                                    ; and exit

go_there:
test b [find_attr],10
jne go_there_10
call find_last_bs_w
cmp ax,working + 0002
ja go_there_5
inc ax
go_there_5:
mov si,ax
mov b [cs:si],00
push si
go_there_10:
mov dx,offset working
doscall 3b
mov dl,b [working]
sub dl,'A'
doscall 0e
setflag flag_went
test b [find_attr],10
jne go_there_20
pop si
mov b [si],'\'
go_there_20:
ret

kill_file:                             ; terminate file with prejudice:
mov dx,offset working                  ; pointer to filename
zero cx                                ; no attributes
doscall2 4301                          ; clear all attributes for file
jc kill_file_prob                      ; if any error, skip ahead to handler
test b [find_attr],10                  ; is this file a subdirectory?
jne kill_subdir                        ; if so, remove subdirectory instead
mov dx,offset working                  ; pointer to filename
doscall 41                             ; delete this file
jc kill_file_prob                      ; if any error, skip ahead to handler
inc w [kill_count]
jne > l0                               ; if no errors, count this as a kill
inc w [kill_count_hi]
l0:
mov ax,w [find_size_lo]
add w [kill_totals],ax                 ; add file's size
mov ax,w [find_size_hi]                ; into total size of killed files
adc w [kill_totals_hi],ax
testflag flag_sw_y                     ; if /y was not specified,
jne > l1
zprint msg_killed                      ; print the 'file deleted' message
l1:
ret                                    ; and exit

kill_file_prob:
cmp ax,0005                            ; access denied error?
je kill_access_denied                  ; if so, handle specially
push ax                                ; any other problem, save error code
dosprint msg_err_delete                ; print error message
pop ax
mov ch,00
call dec_print_small                   ; and dos error code
call terminate_line                    ; terminate print line
ret                                    ; and exit
kill_access_denied:
test b [find_attr],10
jne > l1
zprint msg_access_denied
ret
l1:
zprint msg_rmdir_denied
ret

kill_subdir:                           ; remove subdirectory:
mov dx,offset working                  ; pointer to directory name
doscall 3a                             ; remove it
jc kill_file_prob                      ; any problem, go to error handler
inc w [rmdir_count]
jne > l0                               ; if no errors, count this subdir
inc w [rmdir_count_hi]
l0:
testflag flag_sw_y
jne > l1
zprint msg_rmdir                       ; print the 'file deleted' message
l1:
ret

ask_yorn:                              ; used by /G and /K to get a Y or N :
mov ah,01h                             ; keyboard:  check key buffer status
int 16h
pushf                                  ; save status
mov ah,00h                             ; keyboard:  get key
int 16h
popf                                   ; are we flushing the key buffer?
jne ask_yorn                           ; if so, loop back for more
cmp ax,3d00
je yorn_abort                          ; f3 = abort program
cmp al,1b
je yorn_abort                          ; esc = abort program
cmp al,11
je yorn_abort                          ; control-q = abort program (^c, ^brk)
cmp ax,3c00
je yorn_cont                           ; f2 = disable /G /K /C
and al,0df                             ; force uppercase
cmp al,'Q'
je yorn_abort                          ; Q = abort program
cmp al,'C'
je yorn_cont                           ; C = disable /G /K /C
cmp al,'N'
je yorn_no                             ; N = no  (ordinary answer)
cmp al,'Y'
jne ask_yorn                           ; Y = yes (ordinary answer)
yorn_no:
push ax                                ; save the keystroke
call unpause                           ; erase the prompt line
mov al,b [lines_max]
mov b [lines_count],al                 ; reset line count; prevent pausing
pop ax                                 ; get the keystroke:
cmp al,'Y'                             ; was it Yes?
ret

yorn_abort:                            ; user pressed f3 or esc:
jmp pause_brk                          ; treat just like pause routine would

yorn_cont:                             ; user pressed f2 or q:
clearflag flag_sw_g                    ; turn /G off
clearflag flag_sw_k                    ; turn /K off
setflag flag_no_shell                  ; turn /C off
mov al,'N'                             ; and act like the user pressed n
jmp yorn_no

dupe_drives:                           ; CHECK FOR DUPLICATE DRIVE MAPPINGS:
testflag flag_sw_m                     ; did the user specify /M ?
jne ret                                ; if so, exit this routine
testflag flag_sw_t                     ; did the user specify /T ?
jne ret                                ; if so, exit this routine
testflag flag_user_drvs                ; did the user specify a drive(s)?
jne ret                                ; if so, exit this routine
                                       ; initialize dupe-drive workspace:
mov ax,00 by 'A'                       ; start with drive a:
zero bx                                ; and slot #0
mov es,w [tree_seg]                    ; use tree buffer for workspace
ddrv3:
mov w [es:bx],ax                       ; poke drive letter into slot
inc bh                                 ; next slot
inc al                                 ; and next drive letter
cmp al,'Z'                             ; run out of drive letters yet?
jna ddrv3                              ; if not, loop back
mov w [tree_end],0000                  ; initialize assign-list index
ddrv4:
mov bx,w [tree_end]                    ; get assign-list index
mov si,4000                            ; offset of local-name buffer
mov di,4100                            ; offset of network-name buffer
push es                                ; segment of network-name buffer
pop ds                                 ; segment of local-name buffer
mov b [si],00                          ; empty the local-name buffer
mov b [di],00                          ; empty the network-name buffer
doscall2 5f02                          ; get assign-list entry:
push cs
pop ds                                 ; get my data segment back!
jc ddrv11                              ; if out of entries, exit
mov ax,w [es:4000]                     ; check the local name:
cmp ah,':'                             ; is the second character a colon?
jne ddrv10                             ; if not, continue with next entry
call test_letter                       ; is the first character a letter?
jne ddrv10                             ; if not, continue with next entry
sub al,'A'                             ; convert drive letter to number
mov bh,al
mov bl,00                              ; bx contains 256*drive
mov si,4100                            ; si points to network-name buffer
mov cl,00                              ; no backslashes copied yet
ddrv6:
mov al,b [es:si]                       ; copy the network name
mov b [es:bx],al                       ; to the drive's slot (256*drive)
inc si
inc bx
cmp al,'\'                             ; was that a backslash?
jne ddrv7
inc cl                                 ; if so, count it
cmp cl,04                              ; was it the fourth backslash?
je ddrv8                               ; if so, force end of netname
ddrv7:
cmp al,00                              ; was character the terminal null?
jne ddrv6                              ; if not, loop back for next char
je ddrv10                              ; if so, done copying netname
ddrv8:                                 ; four backslashes:
mov b [es:bx],00                       ; null-terminate the destination name
ddrv10:                                ; increment assign-list entry
inc w [tree_end]
jmp ddrv4
ddrv11:                                ; DONE BUILDING DUPE-DRIVE WORKSPACE:
mov w [tree_end],0100                  ; start upper drive at 1 (b:)
ddrv12:
mov w [env_temp],0000                  ; start lower drive at 0 (a:)
ddrv13:
mov bx,w [tree_end]                    ; bx points to upper drive slot
mov bp,w [env_temp]                    ; bp points to lower drive slot
zero si                                ; start at beginning of netname
ddrv14:
mov al,b [es:bx+si]                    ; get a character from upper netname
cmp al,b [es:bp+si]                    ; compare against lower netname
jne ddrv16                             ; if mismatch, try next lower drive
inc si                                 ; character matches:
cmp al,00                              ; was it the terminal null?
jne ddrv14                             ; if not, loop back for next char.
mov al,b [tree_end+1]                  ; get the drive number
call drive_bit1                        ; and convert to a bit pointer
or b [ddrv_table+bx],ah                ; set the bit in the dupe drive table
jmp ddrv18                             ; and move on to the next upper drive
ddrv16:                                ; increment lower drive:
mov bx,w [env_temp]
add bx,0100
mov w [env_temp],bx
cmp bx,w [tree_end]
jne ddrv13
ddrv18:                                ; increment upper drive:
mov bx,w [tree_end]
add bx,0100
mov w [tree_end],bx
cmp bx,1a00
jb ddrv12
ret                                    ; done checking for dupe drives

drive_bit:                             ; CONVERT DRIVE LETTER TO BIT POINTER:
sub al,'A'                             ; al holds 0-based drive number
drive_bit1:
mov bl,al 
mov cl,03
shr bl,cl
mov bh,00                              ; bx holds drive/8
mov cl,al
and cl,07                              ; cl holds (drive and 07)
mov ah,01
shl ah,cl                              ; ah holds 2^(drive and 07)
ret                                    ; return byte ptr. in bx and bit in ah


parse_env:
cmp w [env_seg],0008                   ; reasonable segment for environment?
jna ret                                ; if not, abort
parse_env_1:
mov bp,offset var_comspec              ; look for the command shell filespec
call find_env_var
jne > l10                              ; if it was found,
mov w [shell_pnt],si                   ; save a pointer to it
l10:
mov bp,offset var_locate
call find_env_var                      ; find any 'locate' variable
jne ret                                ; exit if not found
setflag flag_env_parse                 ; note: parsing from environment
parse_env_2:
mov al,b [es:si]                       ; get a character from environment:
call force_uc                          ; uppercase it
inc si
cmp al,00                              ; end of the environment var?
je parse_env_x                         ; if so, exit
call test_switch                       ; switch or space?
je parse_env_2                         ; if so, ignore it
mov di,0ffff
parse_env_4:
inc di                                 ; look at next char. in switch table
cmp b [switches+di],00                 ; is it a null?
je parse_env_syn                       ; if so, syntax error
cmp b [switches+di],al                 ; is it equal to the current char?
jne parse_env_4                        ; if not, keep looking
shl di,01
mov bx,w [switch_routines+di]          ; found it:  get the routine's address
jmp bx                                 ; and go there
parse_env_x:                           ; done parsing from enviroment block:
clearflag flag_env_parse               ; note it and exit
ret
parse_env_syn:                         ; illegal command in environment:
mov b [msg_env_err1],al
bomb msg_env_err,10                    ; complain and exit with errorlevel 16

find_env_var:
cmp w [env_seg],0008                   ; valid segment for environment block?
ja find_env_var0                       ; if so, continue
mov al,00
cmp al,0ff                             ; if not,
ret                                    ; return with z clear for failure
find_env_var0:
mov es,w [env_seg]                     ; segment of environment block
zero bx                                ; start of table:
find_env_var1:
zero si
find_env_var2:
mov al,b [es:bx+si]                    ; get a character from env table
cmp al,b [bp+si]                       ; and compare against desired name
jne find_env_var8                      ; mismatch, find next var name
inc si
cmp al,'='                             ; found the terminal = ?
jne find_env_var2                      ; no, continue comparing names
mov ax,si
add bx,ax
mov si,bx                              ; return offset of char. after =
cmp al,al                              ; with z set for success
ret
find_env_var8:                         ; look for next variable name:
inc bx                                 ; scan forward
cmp b [es:bx],00                       ; until the first null
jne find_env_var8
inc bx                                 ; the character after the null:
cmp b [es:bx],00                       ; is it another null?
jne find_env_var1                      ; no, found the next var name -- cont.
cmp b [es:bx],0ff                      ; out of variables - exit with z clear
ret

class_test:                            ; compare character against class def:
inc di                                 ; point to class letter
push di                                ; and save the pointer
push ax                                ; save characters to test
mov bl,b [di]                          ; get class letter
sub bl,41                              ; convert to a number
mov bh,00
mov cl,05
shl bx,cl                              ; multiply by 32
add bx,offset class_blocks             ; get pointer to class block
call force_uc
mov cl,al
and cl,0f                              ; get shift count in .cl
mov dx,0001
shl dx,cl
mov cl,03
shr ax,cl
and ax,001e
mov di,ax
pop ax
test w [bx+di],dx
je > l10
pop di
clc
ret
l10:
pop di
stc
ret

test_switch:                           ; EXAMINE CHARACTER IN .AL:
cmp al,'/'                             ; if a switch, exit with carry clear
je test_sw_1                           ;    and zero set
cmp al,'-'                             ; otherwise, return flags as in
je test_sw_1                           ;    following routine
cmp al,','
je test_sw_1

test_space:                            ; EXAMINE CHARACTER IN .AL:
cmp al,00
je test_sw_cr                          ; if end of line, exit with carry set
test_space_1:
cmp al,cr
je test_sw_cr                          ; if space, exit with carry clear
cmp al,20                              ;    and zero set
je test_sw_1                           ; otherwise, exit with carry and
cmp al,09                              ;    zero clear
test_sw_1:
clc
ret
test_sw_cr:
stc
ret

test_eol:                              ; DOES .AL CONTAIN A NULL OR EOL ?
cmp al,00
je ret
cmp al,cr
ret

test_digit:                            ; EXAMINE CHARACTER IN .AL:
cmp al,'0'
jb test_digit_x                        ; is it a digit?
cmp al,'9'                             ; if so, exit with zero flag set
ja test_digit_x                        ; if not, exit with zero flag clear
cmp al,al
test_digit_x:
ret

test_hex_digit:
call force_uc
cmp al,'0'
jb > l20
cmp al,'9'
ja > l10
sub al,'0'
ret
l10:
cmp al,'A'
jb > l20
cmp al,'F'
ja > l20
sub al,37
ret
l20:
mov al,0ff
ret

test_time_date:
call test_digit
je > l1
call test_lsep
je > l1
cmp al,'?'
je > l1

test_colon:                            ; EXAMINE CHARACTER IN .AL:
cmp al,':'
je > l1                                ; if it's a colon or equals sign,
cmp al,'='                             ; exit with z-flag set
l1:                                    ; otherwise, exit with z-flag clear
ret

test_dsep:                             ; EXAMINE CHARACTER IN .AL:
cmp al,'-'
je > l1                                ; is it a date separator?
cmp al,'/'                             ; if so, exit with zero flag set
je > l1                                ; if not, exit with zero flag clear
cmp al,'.'
l1:
ret

test_tsep:                             ; EXAMINE CHARACTER IN .AL:
cmp al,':'
je > l1                                ; is it a time separator?
cmp al,'.'                             ; if so, exit with zero flag set
l1:                                    ; if not, exit with zero flag clear
ret

test_xsep:
cmp al,':'
je > l1
jne test_lsep1

test_lsep:                             ; EXAMINE CHARACTER IN .AL:
cmp al,'~'
je > l1
test_lsep1:
cmp al,','
je > l1                                ; is it a list separator?
cmp al,';'                             ; if so, exit with z-flag set
l1:                                    ; if not, exit with z-flag clear
ret

test_letter:                           ; EXAMINE CHARACTER IN .AL:
cmp al,'A'                             ; less than letter a ?
jb > l2                                ; if so, this is not a letter
cmp al,'Z'                             ; less than or equal to a capital z ?
jbe > l4                               ; if so, this is a letter
l2:                                    ; not a letter:
ret                                    ; exit with z-flag clear
l4:                                    ; is a letter:
cmp al,al                              ; exit with z-flag set
ret


force_roman:                           ; strip accent and force uppercase :
test al,80h                            ; extended character?
je force_uc                            ; no, use standard uppercase routine
push bx
push cx
mov cx,w [code_page]                   ; get current code page in .cx
jcxz > l40                             ; romanization disabled?  if so, exit
mov bx,offset accent_tables            ; start at beginning of roman tables
l10:
cmp w [bx],cx                          ; correct table for this code page?
je > l30                               ; if so, go romanize character
l20:                                   ; no, search for start of next table
inc bx
inc bx                                 ; skip two bytes....
cmp b [bx],00h                         ; end of current table?
jne l20                                ; no, loop back, keep looking
inc bx                                 ; yes, skip over the terminal null
cmp w [bx],0000h                       ; end of roman tables?
je > l40                               ; if so, exit
jmp l10                                ; if not, loop back, try next table
l30:                                   ; found the correct accent table :
inc bx                                 ; skip over table number
inc bx
cmp b [bx],00h                         ; end of this accent table?
je > l40                               ; if so, exit with character unchanged
cmp b [bx],al                          ; found this character in the table?
jne l30                                ; no, loop back and keep looking
mov al,b [bx+1]                        ; yes, substitute correct roman letter
l40:
pop cx                                 ; recover registers
pop bx
ret                                    ; and exit

peter_case:
test b [find_attr],10
je force_lc

force_uc:                              ; FORCE CHARACTER IN .AL TO UPPERCASE:
cmp al,'a'
jb > l1
cmp al,'z'
ja > l1
and al,0df
l1:
ret

force_lc:                              ; FORCE CHARACTER IN .AL TO LOWERCASE:
cmp al,'A'
jb > l1
cmp al,'Z'
ja > l1
or al,20
l1:
ret

find_last_bs_w:
mov si,offset working
find_last_bs:
mov bl,'\'

find_last:                             ; SEARCH ASCIIZ STRING AT [SI] FOR
zero ax                                ; LAST OCURRENCE OF CHARACTER IN BL:
find_last_1:
mov bh,b [si]                          ; if found, exit with offset of last
cmp bh,00                              ; match in ax and zf clear
je find_last_x
cmp bh,bl                              ; if not found, exit with ax=0000
jne find_last_2                        ; and zf set
mov ax,si
find_last_2:
inc si
jmp find_last_1
find_last_x:
testzero ax
ret

find_first:                            ; SEARCH ASCIIZ STRING AT [SI] FOR
zero ax                                ; FIRST OCURRENCE OF CHARACTER IN BL:
find_first_1:
mov bh,b [si]                          ; if found, exit with offset of first
cmp bh,00                              ; match in ax and si, and zf clear
je find_first_x
cmp bh,bl                              ; if not found, exit with ax=0000
jne find_first_2                       ; and zf set
mov ax,si
jmp find_first_x
find_first_2:
inc si
jmp find_first_1
find_first_x:
testzero ax
ret

find_null:                             ; FIND FIRST NULL BYTE AFTER [SI]:
cmp b [si],00
je find_null_x                         ; return offset in si and ax
inc si
jmp find_null
find_null_x:
mov ax,si
ret

find_es_null:                          ; FIND FIRST NULL BYTE AFTER [ES:SI]:
cmp b [es:si],00
je find_null_x                         ; return offset in si and ax
inc si
jmp find_es_null

copy_si_di_z:                          ; COPY ASCIIZ STRING FROM [SI] TO [DI]
lodsb
mov b [di],al                          ; will malf if copying up to an
inc di                                 ; overlapping block
cmp al,00
jne copy_si_di_z
ret

copy_si_esdi_z:                        ; COPY ASCIIZ FROM [SI] TO [ES:DI]:
mov al,b [si]
mov b [es:di],al
inc si
inc di
cmp al,00
jne copy_si_esdi_z
ret

copy_essi_di_z:                        ; COPY ASCIIZ FROM [ES:SI] TO [DI]:
mov al,b [es:si]
mov b [di],al
inc si
inc di
cmp al,00
jne copy_essi_di_z
ret

copy_essi_esdi_zz:                     ; COPY BLOCK FROM [ES:SI] TO [ES:DI]:
es lodsb                               ; block ends in null word (not byte)
stosb
cmp al,00
jne copy_essi_esdi_zz
cmp b [es:si],al
jne copy_essi_esdi_zz
mov b [es:di],al
ret

compare_si_esdi_z:                     ; COMPARE ASCIIZ STRING AT [SI] TO
mov al,b [si]                          ; STRING AT [ES:DI]:
cmp al,b [es:di]
jne compare_x                          ; returns zf set if strings are equal,
cmp al,00                              ; zf clear if strings are not equal
je compare_x
inc si
inc di
jmp compare_si_esdi_z
compare_x:
ret

zprint1:                               ; PRINT ASCIIZ STRING, PAUSE IF NEEDED
mov cl,00                              ; no ctrl-a character found
zprint2:
mov dl,b [di]                          ; get a character
inc di                                 ; and increment pointer
cmp dl,01                              ; found a control-a?
jne zprint3                            ; no, continue
mov cl,01                              ; yes, note it
jmp zprint2                            ; and loop back
zprint3:
cmp dl,00                              ; found the terminal null?
je zprintx                             ; if so, exit the print loop
cmp dl,0ff                             ; print-nothing character?
je zprint2                             ; if so, ignore it and loop back
call dlout                             ; if not, print the character
jmp zprint2                            ; and loop back for more
zprintx:                               ; found the terminal null:
cmp cl,01                              ; was there a control-a in the string?
je ret                                 ; if so, exit with no cr/lf
terminate_line:
fout_ter:
call normal_color
mov dl,cr
call dlout                             ; print a return
mov dl,0a
call dlout                             ; and a line feed
testflag flag_stdout                   ; was output redirected?
je zprint_add                          ; if so, skip check for control key
mov ah,02
int 16                                 ; get keyboard shift status
test al,04                             ; was control pressed?
je zprint_add                          ; if not, don't do control-key delay
push es
mov es,0040                            ; segment for bios data area
keydelay1:
test b [es:006c],01                    ; wait for an even jiffy
jne keydelay1
keydelay2:
test b [es:006c],01                    ; then wait for an odd jiffy
je keydelay2
pop es
zprint_add:
cmp b [lines_count],00                 ; are we counting lines?
jne zprint_c                           ; yes, count this one
ret                                    ; no, exit this routine
zprint_c:                              ; counting lines :
dec b [lines_count]                    ; decrement line count
cmp b [lines_count],00                 ; time for a pause yet?
jne ret                                ; no, exit routine
mov al,b [lines_max]                   ; time for a pause --
mov b [lines_count],al                 ; reset line count and fall through

pause:                                 ; PAUSE TO PREVENT SCROLLING:
dosprint msg_pause                     ; print hit-a-key message
pause_1:
mov ah,01h                             ; keyboard:  check key buffer status
int 16h
pushf                                  ; save status
mov ah,00h                             ; keyboard:  get key
int 16h
popf                                   ; are we flushing the key buffer?
jne pause_1                            ; if so, loop back for more
call force_uc
cmp al,b [pause_line_char]             ; enter key?
je pause_cr                            ; yes, scroll line
cmp al,b [pause_page_char]             ; space bar?
je pause_sp                            ; yes, scroll page
cmp ax,3d00                            ; f3 key?
je pause_brk                           ; yes, abort program now
testzero ax                            ; break key?
je pause_brk                           ; yes, abort program now
cmp al,03                              ; control-c?
je pause_brk                           ; yes, abort program now
cmp al,11                              ; control-q?  (remapped ^c or break)
je pause_brk                           ; yes, abort program now
cmp al,1b                              ; escape?
je pause_brk                           ; yes, abort program now
cmp al,'C'                             ; c key?
je pause_esc                           ; yes, no more pauses
cmp al,'/'                             ; slash key?
je pause_half                          ; yes, scroll a half page
jne pause_1                            ; no, not a legal key, loop back

pause_esc:
mov b [lines_count],00                 ; "c" pressed:  disable pausing
pause_sp:
call unpause                           ; erase the hit-a-key message
ret                                    ; and exit

pause_cr:
mov b [lines_count],01
jmp pause_sp

pause_half:                            ; slash pressed:  scroll half page
mov al,b [lines_max]                   ; get number of lines to scroll
shr al,01                              ; divide lines by two
mov b [lines_count],al                 ; save new scroll value
jmp pause_sp

pause_brk:                             ; control-c hit:
call unpause
call append_restore
dosprint msg_abort
doscall2 4c03                          ; squiff program with errorlevel 03

unpause:
mov dl,cr
call dlout
mov cx,004f
call fout_tab_1
mov dl,cr
jmp dlout

pause_line_char:                       ; character to scroll a line :
db 0d                                  ; default is enter
pause_page_char:                       ; character to scroll a page :
db 20                                  ; default is space


control_color:                         ; use the 'control message' color :
mov al,b [col_control]
mov b [color],al
ret

normal_color:                          ; use the 'normal items' color :
mov al,b [col_normal]
mov b [color],al
ret

default_colors:
mov ah,08                              ; video:  get character and attribute
mov bh,b [vid_page]                    ; for current display page
int 10
mov b [col_normal],ah                  ; save character color as default
mov b [color],ah                       ; and current color
and ah,0f0                             ; keep background color in .ah
mov si,offset colors_list
test ah,80
je > l10
add si,0005
l10:
call next_color                        ; get a color from the list
mov b [col_subdir],al                  ; use it as the 'subdir' color
call next_color                        ; get a color from the list
mov b [col_hidden],al                  ; use it as the 'hidden' color
call next_color                        ; get a color from the list
mov b [col_control],al                 ; use it as the 'control' color
call next_color                        ; get a color from the list
mov b [col_exec],al                    ; use it as the 'executable' color
mov al,b [vid_page]
shl al,1
add al,50
cbw
mov w [cursor_pnt],ax
ret

next_color:
lodsb
or al,ah
cmp al,b [col_normal]
je next_color
ret

colors_list:
db 0b,0e,0c,02,0f,00,01,02,04,05


dec_print_small:                       ; DISPLAY WORD IN AX:
zero dx                                ; fall through ....

dec_print_big:                         ; DISPLAY DOUBLEWORD IN DX:AX
mov w [dp_t1],ax                       ; save the doubleword value
mov w [dp_t2],dx                       ; for later use
mov b [dp_t4],00
mov bx,'s' by 'e'
testzero dx
jne dec_print_plural
cmp ax,0001
jne dec_print_plural
mov bx,0ffff
dec_print_plural:
mov w [dp_t3],bx
mov bx,000a                            ; ten decimal is our divisor
push bx                                ; also our end-of-stack marker
mov cl,00                              ; init digits-between-commas count
dec_print_1:                           ; main decimal division loop
zero dx
mov ax,w [dp_t2]                       ; dx:ax contains the high word as quad
div bx                                 ; divide by ten
mov w [dp_t2],ax                       ; save new high-order word
mov ax,w [dp_t1]                       ; get the old low word
div bx                                 ; and divide by ten
mov w [dp_t1],ax                       ; save new low word
add dx,'0'                             ; convert remainder to ascii digit
push dx                                ; and save it on the stack
inc b [dp_t4]
testzero ax                            ; anything left?
jne dec_print_12                       ; if so, continue with divisions
cmp w [dp_t2],ax
je dec_print_15                        ; if not, print out digits
dec_print_12:
test ch,80                             ; supposed to print commas?
jne dec_print_1                        ; if not, loop back for next digit
inc cl                                 ; increment digits-between-commas
cmp cl,03                              ; three digits yet?
jne dec_print_1                        ; if not, loop back for next digit
mov cl,00                              ; yes, zero counter
mov dl,b [country_thou]                ; and push a comma on the stack
push dx
inc b [dp_t4]
jmp dec_print_1                        ; and loop back for next digit
dec_print_15:                          ; done with divisions:
cmp b [dp_min],00                      ; right-justified?
je dec_print_2                         ; if not, print digits now
mov cl,b [dp_min]
sub cl,b [dp_t4]
jbe dec_print_2
mov ch,00
mov dl,20
dec_print_17:
call dlout
loop dec_print_17
dec_print_2:                           ; decimal printout loop
pop dx                                 ; get a digit from the stack
cmp dx,000a                            ; hit the end of stack yet?
je dec_print_3                         ; if so, exit decimal print routine
call dlout                             ; otherwise, print the digit
jmp dec_print_2                        ; and loop back for next digit
dec_print_3:
mov b [dp_min],00
mov b [dp_space],20
mov ax,w [dp_t3]
ret

dp_space  equ  dec_print_17 - 0001     ; space character for justification


space_out:                             ; display a single space :
mov dl,20                              ; load .dl and fall through

dlout:                                 ; display character in .dl :
testflag flag_sw_c                     ; output to the command shell?
jne dlout_shell                        ; if so, go do that
testflag flag_use_video                ; output to the screen?
jne dlout_bios                         ; if so, use the video bios instead
mov ah,02                              ; otherwise,
int 21                                 ; use the plain old boring dos routine
ret

dlout_bios:
push ax
push bx
push cx
push dx
push es
mov es,0040
mov al,dl                              ; get character to print in .al
mov bh,b [vid_page]                    ; display page
mov bl,b [color]                       ; and current color
cmp al,20                              ; control character?
jb > l10                               ; if so, go handle it
mov cx,0001                            ; once only
mov ah,09                              ; video:  write char and attribute
int 10                                 ; video bios call
mov bx,w [cursor_pnt]
mov dl,b [es:bx]
inc dl
cmp dl,b [columns]
je > l08
mov b [es:bx],dl
jmp > l20
l08:
mov bh,b [vid_page]                    ; display page
mov bl,b [color]                       ; and current color
l10:
mov ah,0e                              ; video:  write character
int 10                                 ; video bios call
l20:
pop es
pop dx
pop cx
pop bx
pop ax
ret

dlout_shell:
cmp dl,cr
je shell_prompt
cmp dl,0a
je ret
cmp dl,20
jne > l10
cmp b [count_byte],02
je ret
l10:
push bx
push dx
mov dh,0d
mov bl,b [count_byte]
mov bh,00
cmp bl,7e
jae shell_overflow
mov w [cmd_buf+bx],dx
inc bx
mov b [count_byte],bl
pop dx
pop bx
ret

shell_overflow:
bomb msg_err_shell_over,07

shell_prompt:
clearflag flag_sw_c
push ax
push bx
push cx
push dx
cmp b [count_byte],02                  ; is the command buffer empty?
if e jmp shell_denied                  ; if so, just bug out
dosprint msg_spawn
mov bx,offset cmd_buf+0002
l20:
mov dl,b [bx]
inc bx
call dlout
cmp dl,0d
jne l20
mov dl,0a
call dlout
testflag flag_sw_y
jne > l30
call control_color
dosprint msg_xeq_ask
call normal_color
call ask_yorn
if ne jmp shell_denied
l30:

; spawn command shell
mov ax,w [cmd_buf+0002]
and ax,0dfdf
cmp ax,'E' by 'S'
jne > l33
mov ax,w [cmd_buf+0004]
and al,0df
cmp ax,20 by 'T'
jne > l33
call internal_set
jmp shell_denied
l33:
mov ax,w [env_seg]
mov w [exec_env_seg],ax
mov ax,offset count_byte
mov w [exec_cmd_ofs],ax
push cs
pop ax
mov w [exec_cmd_seg],ax

push es                                ; save current value of .es
mov bx,w [tree_end]                    ; get pointer to end of tree buffer
cmp bx,0ffe0                           ; is it very high?
jae > l35                              ; if so, don't shrink tree buffer
mov cl,04
shr bx,cl                              ; divide to get size in paragraphs
inc bx
inc bx                                 ; and add two
mov ax,w [tree_seg]
cmp ax,0a000                           ; is the tree buffer in upper memory?
jae > l35                              ; if so, don't bother to shrink it
mov es,ax
doscall 4a                             ; shrink the tree buffer temporarily
if c bomb msg_err_resize_tree,04       ; if any error, go handle it
l35:
push cs
pop es
mov bx,offset exec_block               ; es:bx points to parameter block
mov dx,w [shell_pnt]
mov ds,w [env_seg]                     ; ds:dx points to shell's filename
push bp
doscall2 4b00                          ; spawn command shell
pop bp
push cs
pop ds                                 ; point .ds back to the code segment
jnc > l40                              ; if dos reported an error,
push ax                                ; save the error number
dosprint msg_err_spawn                 ; print an error message
pop ax                                 ; get the error number
call dec_print_small                   ; and display that
call terminate_line                    ; finish the output line
l40:
mov es,w [tree_seg]
mov bx,1000                            ; resize the tree buffer to 64k
doscall 4a                             ; dos resize-memory function
if c bomb msg_err_resize_tree,04       ; if any error, go handle it
pop es                                 ; restore original value of .es
mov dx,offset dta_address              ; restore the dta to 0080h
doscall 1a                             ; (dos default)

mov ah,01
int 16                                 ; check keyboard
je no_key                              ; if no key in buffer, never mind
mov ah,00
int 16                                 ; get keystroke from buffer
testzero ax
je spawn_brk                           ; if control-break, abort
cmp al,03
je spawn_brk                           ; if control-c, abort
cmp al,11
je spawn_brk                           ; if control-q, abort
no_key:

shell_denied:
call empty_cmd_buf
testflag flag_no_shell
if e setflag flag_sw_c
pop dx
pop cx
pop bx
pop ax
ret

spawn_brk:
call append_restore
dosprint msg_abort
doscall2 4c03                          ; squiff program with errorlevel 03


internal_set:
push es,si,di
; ------------------ Find the name and length of the new environment string :
mov bx,offset cmd_buf+0004
l10:
inc bx
cmp b [bx],20
je l10
if b jmp int_set_syn
mov w [intset_new],bx                  ; offset - start of variable name
l20:
mov al,b [bx]
call force_uc
cmp al,20
if b jmp int_set_syn
mov b [bx],al                          ; force variable name to uppercase
inc bx
cmp al,'='
jne l20
zero si
cmp b [bx],0d
je > l50
mov bx,w [intset_new]
l30:
inc si
cmp b [bx+si],0d
jne l30
inc si
l50:
mov w [intset_newlen],si
; ----------------------------- Find the parent program's environment block :
push cs
pop es
l60:
mov ax,es
mov bx,w [es:0016]
cmp bx,ax
je > l70
mov es,bx
jmp l60
l70:
mov ax,w [es:env_seg]
cmp ax,0008
if na jmp int_set_seg
mov w [intset_seg],ax
; ---------------- Get current and maximum sizes for the parent environment :
dec ax
mov es,ax
mov al,b [es:0000]
cmp al,'M'
je > l80
cmp al,'Z'
if ne jmp int_set_seg
l80:
cmp bx,w [es:0001]
if ne jmp int_set_seg
mov bx,w [es:0003]
test bh,0f0
if ne jmp int_set_seg
mov cl,04
shl bx,cl
dec bx
mov w [intset_max],bx
mov es,w [intset_seg]
zero si
cmp b [es:si],00
je > l100
l90:
inc si
cmp w [es:si],0000
jne l90
l100:
inc si
mov w [intset_cur],si
; -------------- Find current offset and size of environment string, if any :
zero bx
mov w [intset_old],bx
mov w [intset_oldlen],bx
l110:
cmp b [es:bx],00
je > l160
zero si
mov di,w [intset_new]
l120:
mov al,b [es:bx+si]
cmp al,b [di]
jne > l130
cmp al,'='
je > l140
inc si
inc di
jmp l120
l130:
inc bx
cmp b [es:bx],00
jne l130
inc bx
jmp l110
l140:
mov w [intset_old],bx
zero si
l150:
inc si
cmp b [es:bx+si],00
jne l150
inc si
mov w [intset_oldlen],si
l160:
; -------------------------- Check whether there is room for the new string :
mov ax,w [intset_cur]                  ; get size of environment in use
sub ax,w [intset_oldlen]               ; subtract size of old string, if any
add ax,w [intset_newlen]               ; add size of the new string, if any
cmp ax,w [intset_max]                  ; would we overflow the env block?
if a jmp int_set_ovr
; --------------------------------------------------- Delete the old string :
mov di,w [intset_old]
mov si,di
add si,w [intset_oldlen]
cmp si,di
je > l180
l170:
mov al,b [es:si]
mov b [es:di],al
inc si
inc di
cmp si,w [intset_cur]
jbe l170
mov ax,w [intset_cur]
sub ax,w [intset_oldlen]
mov w [intset_cur],ax
l180:
; --------------------------------------------------- Append the new string :
cmp w [intset_newlen],0000
je > l210
mov si,w [intset_new]
mov di,w [intset_cur]
l190:
mov al,b [si]
cmp al,0d
je > l200
mov b [es:di],al
inc si
inc di
jmp l190
l200:
mov w [es:di],0000
l210:
; ------------------------------------------------------- Clean up and exit :
pop di,si,es
ret

int_set_syn:                           ; syntax error on set command :
dosprint msg_err_intsyn
pop di,si,es
ret

int_set_seg:
dosprint msg_err_intseg
pop di,si,es
ret

int_set_ovr:
dosprint msg_err_intover
pop di,si,es
ret

strout:
push bx
push dx
mov bx,dx
l10:
mov dl,b [bx]
inc bx
cmp dl,'$'
je > l20
call dlout
jmp l10
l20:
pop dx
pop bx
ret


empty_cmd_buf:
mov b [count_byte],02
mov w [cmd_buf+0],'C' by '/'
mov b [cmd_buf+2],0d
ret

show_date_format:
dosprint msg_date_format
mov dx,offset msg_date_fmt_0
cmp b [country_date],00
je show_date_format_1
mov dx,offset msg_date_fmt_1
cmp b [country_date],01
je show_date_format_1
mov dx,offset msg_date_fmt_2
show_date_format_1:
call strout
ret

ia_display:                            ; FORCE INTERACTIVE DISPLAY MODES:
mov dx,offset fn_con                   ; open a file handle specifically
doscall2 3d41                          ; to the console -- don't trust stderr
push ax                                ; because 4dos can redirect it
mov cx,0001                            ; force stdout
mov bx,ax                              ; to the new console handle
doscall 46
pop bx                                 ; then close the duplicate handle
doscall 3e
mov b [wide_count],00                  ; don't permit wide-Peter display
cmp b [display],dm_summary
jne > l0
mov b [display],dm_peter               ; or summary-only mode
l0:
ret

bombs_away:                            ; HANDLE VARIOUS ERRORS:
call append_restore                    ; reset output to console
dosprint msg_err_begin                 ; print start of error message
pop di
mov dx,w [di]                          ; get pointer to error message
doscall 09                             ; print error message
mov al,b [di+02]                       ; get errorlevel
doscall 4c                             ; and exit program
int 20

append_restore:                        ; RESTORE APPEND STATE, IF CHANGED:
zero cx                                ; convenient zero
cmp w [append_hack],cx                 ; was append state changed?
je append_rest_x                       ; no, exit
mov bx,w [append_hack]                 ; yes, get original state
mov ax,0b707
int 2f                                 ; set append state
mov w [append_hack],cx                 ; clear append-fix flag
append_rest_x:
cmp w [int_15_vec_hi],cx               ; did we hook int 15?
je restore_int15_x                     ; if not, don't restore it.  duh.
mov dx,w [int_15_vec]
mov ds,w [int_15_vec_hi]               ; get original int 15 vector in ds:dx
doscall2 2515                          ; and plug it back in
push cs
pop ds                                 ; get correct data segment back
mov w [int_15_vec_hi],cx               ; clear int-15-fix flag
restore_int15_x:

error_output:                          ; PREPARE TO PRINT AN ERROR MESSAGE:
mov bx,0002                            ; copy standard error handle
mov cx,0001                            ; to standard output handle
doscall 46                             ; dos force-duplicate-handle function
clear2flags flag_sw_c, flag_use_video  ; no video bios or shell output
ret

err_tree_ov:                           ; TREE BUFFER OVERFLOW:
bomb msg_tree_ov,06                    ; complain and exit with errorlevel 6


syntax:                                ; SYNTAX ERROR:
call append_restore
switch_query:
dosprint msg_syntax                    ; print syntax message
call append_restore
doscall2 4c10                          ; and abort

new_int24:                             ; NEW CRITICAL-ERROR HANDLER:
mov al,03                              ; always fail
iret                                   ; pretty simple, huh?

new_int15:                             ; NEW INT 15 HANDLER:
pushf                                  ; save flags
push es                                ; and .es register on stack
mov es,0040                            ; bios data area is at segment 0040
cmp ah,4f                              ; key intercept interrupt?
jne new_15_x                           ; if not, exit
test b [es:0017],04                    ; is control key pressed?
je new_15_x                            ; if not, exit
cmp al,37                              ; control-print screen?
je > l10                               ; if so, prevent it
cmp al,19                              ; control-p?
jne > l20                              ; if so, prevent it
l10:                                   ; convert control-p or control-prtscn
mov al,1c                              ; to a harmless control-a
l20:
cmp al,2e                              ; control-c?
je new_15_fix                          ; if so, change it to control-q
cmp al,46                              ; control-break?
jne new_15_x                           ; if not, exit
and b [es:0096],0fd                    ; disregard previous 0e0 scancode
new_15_fix:                            ;    from control-break sequence
mov al,10                              ; substitute control-q scancode
new_15_x:
pop es                                 ; recover .es register
popf                                   ; and flags from the stack
jmp far [cs:int_15_vec]                ; and resume normal keystroke handling


;  --------------------------------------------------------------------------
;            STRINGS AND OTHER MOSTLY STATIC DATA BEGIN HERE
;  --------------------------------------------------------------------------

;  Null-terminated list of legal switch letters.  Note that there are several
;  two-character switches, as /D: /T: /NS /12 /24.  The single-character
;  switch routines (/D /T /N /1 /2 /U) are responsible for checking for any
;  second character, and jumping to a different parser if appropriate.  So
;  modify this table with care.

switches:
db 'PAWSBOCNLI2TXRHDFGMU1KYVZ0?',00

;  Offsets of parser routines corresponding to the switches above.

switch_routines:
dw switch_p, switch_a, switch_w, switch_s, switch_b, switch_o
dw switch_c, switch_n, switch_l, switch_i, switch_two
dw switch_t, switch_x, switch_r, switch_h, switch_d, switch_f
dw switch_g, switch_m, switch_u, switch_one, switch_k
dw switch_y, switch_v, switch_z, switch_zero, switch_query


;  Null-terminated list of macros for /O.  All are preceded with an
;  ampersand.

fout_switches:
db 'FDPNRXS$ABE&T_QLWZ123JCHI456GUY#@78VK+',00

;  Offsets of output routines corresponding to the macros above.

fout_routines:
dw fout_fil, fout_dir, fout_pat, fout_nam, fout_roo, fout_ext, fout_buk
dw fout_buk, fout_att, fout_bra, fout_esc, fout_amp, fout_ter, fout_ter
dw fout_quo, fout_let, fout_win, fout_zin, fout_dat, fout_tim, fout_siz
dw fout_jus, fout_con, fout_ter, fout_tab, fout_dow, fout_pre, fout_kmb
dw fout_gob, fout_fil2, fout_ldn, fout_ins, fout_inz, fout_da2, fout_ti2
dw fout_lbn, fout_lex, fout_hue

;  Offsets of output routines for /P /S /B /O /N /L.

disp_routines:
dw show_peter, name_done, batch_output, formatted_output
dw bare_naked, lfn_output

;  Number of blank 'header' lines to print for each display mode
;  /P /S /B /O /N /L.  Bit 7, if set, causes the final summary counts to
;  be displayed.  This table may be altered before the start of the filename
;  search; so far, only /O does so.

num_blank_lines:
db 81,80,00,00,00,81


;  Names of days of the week; the 8th entry is for invalid dates like
;  February 31.  All entries must be exactly four characters long, including
;  the trailing dollar signs.

dow_names:
  db 'Sun$Mon$Tue$Wed$Thu$Fri$Sat$---$'
; db 'Dim$Lun$Mar$Mer$Jeu$Ven$Sam$---$'          ; french
; db 'Dom$Lun$Mar$Mi$Jeu$Vie$Sb$---$'          ; spanish
; db 'Son$Mon$Die$Mit$Don$Fre$Sam$---$'          ; german
; db 'Dom$Lun$Mar$Mer$Gio$Ven$Sab$---$'          ; italian


;  Short names of days of the week; this table is used for /D: input.  Again
;  the 8th is for invalid dates.  All entries must be exactly two characters
;  long, and uppercase.

dow_short:
  db 'SUMOTUWETHFRSAXX'
; db 'DILUMAMEJEVESAXX'                          ; french
; db 'DOLUMAMIJEVISAXX'                          ; spanish
; db 'SOMODIMIDOFRSAXX'                          ; german
; db 'DOLUMAMEGIVESAXX'                          ; italian


;  Names of months.  Each entry is four characters long, including the
;  trailing dollar sign.

month_names:
  db 'Jan$Feb$Mar$Apr$May$Jun$Jul$Aug$Sep$Oct$Nov$Dec$'


;  Month lengths in hex.  Second entry gets poked according to leapness.

months_table:
db 1f, 1c, 1f, 1e, 1f, 1e, 1f, 1f, 1e, 1f, 1e, 1f


msg_markver:

db 'VeRsIoN=1.30',00
db 'CoPyRiGhT=Copyright 1995-2002, Charles Dye',00

msg_syntax:
db cr,lf
db 'LOCATE.COM   v1.30   09-08-2002   C. Dye   raster@highfiber.com',cr,lf
db 'Freeware.  Copyright 1995-2002, Charles Dye.  No warranty!',cr,lf
db lf
db 'Syntax:  LOCATE [filespec] [switches]',cr,lf
db '  /H   Hidden or system        /D-  find files, not Directories',cr,lf
db '  /X   .COM, .EXE, .BAT        /D+  find Directories only',cr,lf
db '  /Fn  only First n items      /D   find both (default)',cr,lf
db '  /A   check Attributes        /T   path search',cr,lf
db '  /0   0-byte files            /R   local hard drives only',cr,lf
db '  /G   Go to directory         /K   Kill (delete) items',cr,lf
db '  /N   bare Naked display      /W   Wide display',cr,lf
db '  /S   Summary info only       /P   Peter-style display',cr,lf
db '  /L   Win95 Long filenames    /NP  No Paging',cr,lf
db lf
db '  /B:"command" Batch output    /D:[start][,end]  Date range',cr,lf
db '  /O:"string"  macro Output    /T:[start][,end]  Time range',cr,lf
db '  /C:"string"  run Commands    /S:[small][,big]  Size range',cr,lf
db lf
db 'Space between the filespec and any switches.  Output will be paged',cr,lf
db 'unless it is redirected or /NP used.  Specify default switches in a',cr,lf
db 'LOCATE= variable.  Try /D? /T? /S? /A? /B? or /O? for more help.',cr,lf
db '$'

msg_err_begin:
db cr,lf,'Error:  $'

msg_resize_error:
db 'Not enough memory for program!',cr,lf,'$'

msg_alloc_error:
db 'Allocating tree buffer!',cr,lf,'$'

msg_dos_bad:
db 'Requires DOS 3.2 or higher!',cr,lf,'$'

msg_buffer_full:
db 'Filespec too long!',cr,lf,'$'

msg_bad_drv:
db 'Illegal drive spec!',cr,lf,'$'

msg_dir_wc:
db 'Wildcards not allowed in directory name!',cr,lf,'$'

msg_fz:
db 'Numeric overflow!',cr,lf,'$'

msg_err_class:
db 'Bad class definition!',cr,lf,'$'

msg_err_classes:
db 'Too many classes!',cr,lf,'$'

msg_err_date:
db 'Underflow in date!',cr,lf,'$'

msg_err_spawn:
db '   DOS error on spawn:  $'

msg_err_no_comspec:
db 'COMSPEC variable not set!',cr,lf,'$'

msg_err_resize_tree:
db 'Resizing tree buffer!',cr,lf,'$'

msg_err_size:
db 'File size range!',cr,lf,'$'

msg_err_intsyn:
db 'SET:  Syntax error',cr,lf,'$'

msg_err_intseg:
db "SET:  Can't find parent environment",cr,lf,'$'

msg_err_intover:
db 'SET:  Out of environment space',cr,lf,'$'


msg_bad_bat:
db cr,lf
db '/B:"command"   Batch output, with a command',cr,lf
db '/Bn:"command"  with a command and n arguments  (n is 1 to 9)',cr,lf
db lf
db 'LOCATE C:*.MS /B3:"ATTRIB"  would produce lines like:',cr,lf
db lf
db '   @echo off',cr,lf
db '   ATTRIB C:\CHKLIST.MS %1 %2 %3',cr,lf
db lf
db '/B implies an automatic /D-.  Use a /D or /D+ on the command line',cr,lf
db 'to override.',cr,lf
db '$'

msg_bad_format:
db cr,lf
db '/O:"string"  macro Output',cr,lf
db '/C:"string"  run Commands      Either may include:',cr,lf
db lf
db '   &F  fully qualified filename     C:\WINDOWS\WIN.COM',cr,lf
db '   &D  directory name, canonical    C:\WINDOWS',cr,lf
db '   &P  directory name with \        C:\WINDOWS\',cr,lf
db '   &N  filename                     WIN.COM',cr,lf
db '   &R  filename without extension   WIN',cr,lf
db '   &X  extension only               COM',cr,lf
db '   &S  filespec without drive       \WINDOWS\WIN.COM',cr,lf
db '   &L  drive letter                 C:',cr,lf
db '   &A  attributes, standard         +A -S -H -R',cr,lf
db '   &B  attribute bits               A....',cr,lf
db '   &W  Win95 full LFN               "C:\Directory Name\Long File Name"',cr,lf
db '   &Z  Win95 LFN, filename only     "Long File Name"',cr,lf
db '   &T  terminate line',cr,lf
db '   &&  ampersand    &E  escape    &Q  quote mark',cr,lf
db '   &1  date         &2  time      &3  file size',cr,lf
db '$'

msg_bad_chk:
db cr,lf
db '/A...   check Attributes',cr,lf
db lf
db '   /A:A+  Archive bit must be set',cr,lf
db '   /A:A-  Archive bit must be clear',cr,lf
db '   /A:S+  System bit must be set',cr,lf
db '   /A:H+  Hidden bit must be set',cr,lf
db '   /A:A-RH+  Archive clear, Read-only and Hidden set',cr,lf
db '$'

msg_bad_ud:
db cr,lf
db '/D+   find Directories only',cr,lf
db '/D-   files only, no Directories',cr,lf
db '/D    both files and Directories (default)',cr,lf
db lf
db '/D:[start][,end]   only Dates in range',cr,lf
db '/D:date!   only one specific date',cr,lf
db '/D:T       only items dated today',cr,lf
db lf
db '/US   show dates in US format:  Jan 31 1996',cr,lf
db '/UK   show dates in UK format:  31 Jan 1996',cr,lf
db '/UJ   show dates in ISO format:  1996-01-31',cr,lf
db lf
db '$'

msg_bad_ti:
db cr,lf
db '/T    search only current directory and path',cr,lf
db lf
db '/T:[start][,end]   check Time stamps',cr,lf
db '/T:time!   only one specific time',cr,lf
db lf
db '$'

msg_size_query:
db cr,lf
db '/S     display Summary only, not found items',cr,lf
db lf
db '/S:[small][,big]   only files in Size range',cr,lf
db '/S:size!   only one specific size',cr,lf
db lf
db 'Size may end in K for Kilobytes, or M for Megabytes.',cr,lf
db lf
db '$'

msg_bat_ovf:
db '/B or /O string -- 80 characters max!',cr,lf,'$'

msg_tree_ov:
db 'Tree buffer overflow!',cr,lf,'$'

msg_working_ov:
db 'Working buffer overflow!',cr,lf,'$'

msg_err_shell_over:
db 'Command buffer overflow!',cr,lf,'$'

msg_env_err:
db 'Illegal switch "'
msg_env_err1:
db '#" in LOCATE variable!',cr,lf,'$'

msg_err_delete:
db 'Unable to delete:  DOS error $'

msg_rmdir_denied:
db 'Directory not empty, or '

msg_access_denied:
db 'Access denied',00

msg_err_condition:
db '&C syntax!',cr,lf,'$'

msg_bat_begin:
db '@echo off',00

msg_bat_arg:
db ' %1',01,00

msg_pause:
db cr,'  <Space> scroll page, <Enter> scroll line, <Esc> abort, <C> continuous :$'

msg_pause_page  equ  msg_pause + 04       ;  these offsets are used by the /V
msg_pause_line  equ  msg_pause + 19       ;  routine to swap pause keys

msg_go_ask:
db cr,'Go there?  [Y/N/Q] $'

msg_kill_ask:
db cr,'Delete this?  [Y/N/Q] $'

msg_xeq_ask:
db 'Execute?  [Y/N/Q] $'

msg_killed:
db 'File deleted.',00

msg_rmdir:
db 'Directory removed.',00

msg_spawn:
db cr,lf,'Locate> $'

msg_abort:
db cr,lf,'   *** Abort ***',cr,lf,'$'

attr1:
db 'ADSHR'

attr_v:
db 20,10,04,02,01

msg_attrib_2:
db '-A -S -H -R$'

msg_info_dir:
db '<Dir>$'

msg_info_open:
db ' bytes  $'

msg_info_kb:
db ' K$'

msg_info_mb:
db ' M$'

msg_nothing:
db 'No matches found.',00

msg_num_entries:
db ' items found:  ',01,00

msg_num_files:
db ' files',01,00

msg_num_files1:
db ', ',01,00

msg_num_dirs:
db ' directories',01,00

msg_num_dirs1:
db '.',00

msg_hs:
db ' (',01,00

msg_hs1:
db ' H/S)',01,00

msg_maybe_more:
db '   /F$' 
msg_maybe_more_1:
db ' was specified$'

msg_maybe_more_2:
db '   /G search ended'

msg_maybe_more_3:
db '; there may be more.',00

msg_file_totals:
db '   Total of file sizes:  $'

msg_num_killed:
db ' deleted; total of sizes:  $'

msg_num_removed:
db ' removed.',00

star_dot_star:
db '*.*',00

execnames:
db 'BTMCOMEXEBAT:',00

msg_date_format:
db 'Local date format:  $'

msg_date_fmt_0:
db 'MM-DD-YYYY',cr,lf,'$'

msg_date_fmt_1:
db 'DD-MM-YYYY',cr,lf,'$'

msg_date_fmt_2:
db 'YYYY-MM-DD',cr,lf,'$'

var_locate:
db 'LOCATE='

var_path:
db 'PATH='

var_comspec:
db 'COMSPEC='

fn_con:
db 'CON',00

fn_c_root:
db 'C:\',00


;  --------------------------------------------------------------------------
;                  CHARACTER TABLES FOR 'ROMANIZING' LETTERS
;  --------------------------------------------------------------------------

accent_tables:

dw 0437xd                              ; for code page 437 :
db 080,'C', 081,'U', 082,'E', 083,'A', 084,'A', 085,'A', 086,'A', 087,'C'
db 088,'E', 089,'E', 08a,'E', 08b,'I', 08c,'I', 08d,'I', 08e,'A', 08f,'A'
db 090,'E', 091,092, 093,'O', 094,'O', 095,'O', 096,'U', 097,'U', 098,'Y'
db 099,'O', 09a,'U', 0a0,'A', 0a1,'I', 0a2,'O', 0a3,'U', 0a4,'N', 0a5,'N'
db 00                                  ; end of code page 437

dw 0850xd                              ; for code page 850 :
db 080,'C', 081,'U', 082,'E', 083,'A', 084,'A', 085,'A', 086,'A', 087,'C'
db 088,'E', 089,'E', 08a,'E', 08b,'I', 08c,'I', 08d,'I', 08e,'A', 08f,'A'
db 090,'E', 091,092, 093,'O', 094,'O', 095,'O', 096,'U', 097,'U', 098,'Y'
db 099,'O', 09a,'U', 09b,09d, 0a0,'A', 0a1,'I', 0a2,'O', 0a3,'U', 0a4,'N'
db 0a5,'N', 0b5,'A', 0b6,'A', 0b7,'A', 0c6,'A', 0c7,'A', 0d0,0d1, 0d2,'E'
db 0d3,'E', 0d4,'E', 0d6,'I', 0d7,'I', 0d8,'I', 0de,'I', 0e0,'O', 0e2,'O'
db 0e3,'O', 0e4,'O', 0e5,'O', 0e7,0e8, 0e9,'U', 0ea,'U', 0eb,'U', 0ec,'Y'
db 0ed,'Y'
db 00                                  ; end of code page 850

dw 0863xd                              ; for code page 863 :
db 080,'C', 081,'U', 082,'E', 083,'A', 084,'A', 085,'A', 087,'C', 088,'E'
db 089,'E', 08a,'E', 08b,'I', 08c,'I', 08e,'A', 090,'E', 091,'E', 092,'E'
db 093,'O', 094,'E', 095,'I', 096,'U', 097,'U', 099,'O', 09a,'U', 09d,'U'
db 09e,'U', 0a2,'O', 0a3,'U', 0a8,'I'
db 00                                  ; end of code page 863

dw 0000xd                              ; end of accent tables


;  --------------------------------------------------------------------------
;                            INITIALIZED VARIABLES
;  --------------------------------------------------------------------------


display:
db 00

;  Values for the above :

dm_peter      equ  00
dm_summary    equ  01
dm_batch      equ  02
dm_macro      equ  03
dm_naked      equ  04
dm_longnames  equ  05


flags:
db num_flag_bytes dup 00


pending_splats:                        ; number of asterisks which might be
db 00                                  ; re-evaluated to make filespec match

attrib_care:                           ; which attributes must we match?
db 00                                  ; bit set = care, clear = don't care

attrib_value:                          ; values of the attributes we care
db 00                                  ; about

check_dow:                             ; zero if doesn't matter, or bits set
db 00                                  ; for days:  0=sun, 1=mon, etc.

bat_args:                              ; null if no %args needed, or
db 00                                  ; '1' to '9' for last %arg

condition_char:                        ; character which ends a conditional
db 00                                  ; macro string

next_class:                            ; number of next class def block
db 00

color:                                 ; current color for bios output
db 00

col_normal:                            ; color for normal files
db 00

col_subdir:                            ; color for normal subdirectories
db 00

col_hidden:                            ; color for hidden or system items
db 00

col_control:                           ; color for program control messages
db 00

col_exec:                              ; color for 'executable' files
db 00

col_item:                              ; color for the current item
db 00

vid_page:                              ; current video display page
db 00

dp_min:                                ; decimal-print routine :
db 00                                  ; minimum number of chars to print

lines_max:                             ; lines to scroll before pausing:
db 00                                  ; normally 22, but vga may differ

lines_count:                           ; used internally for scroll pauses:
db 00                                  ; 00 = not pausing

wide_count:                            ; used for /w listing
db 00

dos_ver:                               ; dos major version number
db 00

mem_strat:                             ; original memory allocation strategy
db 00

umb_link:                              ; original umb link state
db 00

wide_max:                              ; maximum width for /w
db 05

drv1:                                  ; first drive to search
db 'A'

drv2:                                  ; last drive to search
db 'Z'


even                                   ; WORD-LENGTH VARIABLES :

tree_end:                              ; offset of second consecutive null
dw 0000

env_temp:                              ; used by path parse routine
dw 0000

date_1:                                ; starting date of range to accept
dw 0000

time_1:                                ; start of time range to accept
dw 0000

size_1:                                ; low end of size range to accept
dw 0000,0000

date_2:                                ; ending date of range to accept
dw 0ffff

time_2:                                ; end of time range to accept
dw 0ffff

size_2:                                ; high end of size range to accept
dw 0ffff,0ffff

columns:                               ; width of display
dw 0050                                ; assume 80 columns

code_page:                             ; assume page 437 by default
dw 0437xd

lfn_chop:
dw 0000

entry_count:                           ; number of files/directories found
dw 0000
entry_count_hi:
dw 0000

files_count:                           ; number of files found
dw 0000
files_count_hi:
dw 0000

dirs_count:                            ; number of directories found
dw 0000
dirs_count_hi:
dw 0000

hfiles_count:                          ; hidden/system files found:
dw 0000
hfiles_count_hi:
dw 0000

hdirs_count:                           ; hidden/system directories found:
dw 0000
hdirs_count_hi:
dw 0000

kill_count:                            ; number of files deleted
dw 0000
kill_count_hi:
dw 0000

rmdir_count:                           ; number of subdirectories removed
dw 0000
rmdir_count_hi:
dw 0000

file_totals:                           ; total size of all files found
dw 0000
file_totals_hi:
dw 0000

kill_totals:                           ; total size of all files deleted
dw 0000
kill_totals_hi:
dw 0000

max_count:                             ; maximum matches to report
dw 0000

append_hack:                           ; used to hack around append, if
dw 0000                                ; present:

shell_pnt:                             ; offset of comspec variable in the
dw 0000                                ; environment block, or 0000 for none

condition_point:                       ; where to go when condition_char
dw 0000                                ; is found in macro string

amp_h_point:                           ; points just past &h macro -- i.e.,
dw 0000                                ; just after header string

int_15_vec:                            ; original destination of int 15
dw 0000                                ; vector.  i hook int 15 to trap
int_15_vec_hi:                         ; control-break and control-c.
dw 0000

cursor_pnt:
dw 0000

; -------------------------------------- used when spawning the command shell

exec_block:
exec_env_seg:  dw 0000
exec_cmd_ofs:  dw 0000
exec_cmd_seg:  dw 0000
exec_cmd_fcb:  dw 0000,0000,0000,0000

; -------------------------------------- used by the internal 'set' support

intset_seg     equ  exec_env_seg       ; segment of parent program's
                                       ; environment block

intset_new     equ  exec_cmd_ofs       ; pointer to name of environment
                                       ; variable to create or change

intset_max     equ  exec_cmd_seg       ; maximum length of parent program's
                                       ; environment block

intset_newlen:                         ; length of new environment string
dw 0000                                ; to create or update

intset_old:                            ; offset of old variable in parent's
dw 0000                                ; environment, or zero if undefined

intset_oldlen:                         ; length of old variable in parent's
dw 0000                                ; environment, or zero if none

intset_cur:                            ; total length of all env. strings
dw 0000                                ; in parent program's environment

; --------------------------------------

ddrv_table:                            ; bitmapped table of duplicate drives
db 04 dup 00


end_of_code:

;  --------------------------------------------------------------------------
;                            UNINITIALIZED BUFFERS
;  --------------------------------------------------------------------------


fn_buf        equ  end_of_code         ; user's filespec goes here :
                                       ; will finally hold just the dir name

working       equ  fn_buf + max_fn_len           ; working filespec buffer

bat_buf       equ  working + max_fn_len          ; batch prefix

fs_buf        equ  bat_buf + 0053      ; filespec stripped from dir spec
                                       ; with room for several wildcards

count_byte    equ  fs_buf + 0030       ; number of characters in cmd_buf
cmd_buf       equ  count_byte + 1      ; command string to pass to shell

lfn_buffer    equ  cmd_buf + 007f

; room for ten character-class definitions of 32 bytes each

class_blocks  equ  lfn_buffer + max_lfn_len

; room for ten extensions (executable or user-defined) of three chars each

extensions    equ  class_blocks + (010xd * 20)

end_of_data   equ  extensions   + (010xd * 3)

segment_size  equ  ((end_of_data + 080f) / 10)


;
;  ERRORLEVELS :
;
;     00  File(s) found
;     01  No match found
;     02  Filespec error
;     03  User break may return this value
;     04  Memory allocation error
;     05  Bad DOS
;     06  Tree buffer overflow
;     07  Command buffer overflow
;     08  Can't find COMSPEC
;     09  Working buffer overflow
;     10  Bad switch or syntax request
;
;
;  VERSION LOG:
;
;  v1.00   06-10-1995
;          Supports /T /X /R /N /D- and /D+
;
;  v1.01   06-12-1995
;          Fixes a bug in /T USE_PATH which prevented proper handling of the
;          root directory when it was current.  Does not attempt to search
;  drive B: on a single-drive system.
;
;  v1.02   06-15-1995
;          Provides a count of matches found.  The decimal-print routine
;          will probably crash if more than 650,000 matches are found.
;  No count messages will be printed if /N was specified.
;
;  v1.03   06-19-1995
;          Better decimal-print routine:  will correctly display up to
;          2^32-1 files.  If only one match is found, will display
;  "1 match" instead of "1 matches".
;
;  v1.04   06-22-1995
;          Hacked to bypass APPEND if installed and active.
;
;  v1.05   07-10-1995
;          Adds /H (list only hidden/system items.)  Final count is now
;          broken down into file and directory counts.
;
;  v1.06   10-21-1995
;          Adds /Fn (find first n files) and /I (displays more info,
;          in a somewhat Peter-like format.)
;
;  v1.06a  11-05-1995
;          The decimal-print routine now prints commas in large numbers.
;          Space bar allowed (as well as Return) to un-pause output.
;  Unused attributes shown as a period, instead of a space; meanings of
;  attribute letters are listed in the syntax message.
;
;  v1.06b  11-07-1995
;          Undocumented switch /$ suppresses display of drive letters.
;          Program will abort if TREE_END variable wraps around end of
;  64K buffer.
;
;  v1.06c  11-13-1995
;          Final file and directory counts include a subcount of hidden or
;          system files/directories.  If /H was specified, the subcounts
;  will be suppressed since they must match the main counts.
;
;  v1.07   11-20-1995
;          /$ behaves more sensibly (only searches one drive, invokes /N
;          automatically.)  If user specifies a filespec of only . or ..
;  these will now be handled correctly.  Parser is now simpler (uses lookup-
;  and-jump table, not monster case switch.)
;
;  v1.08   11-25-1995
;          Adds /B:"command" for automatic batch file creation.  If there
;          are no command line arguments at all, uses a default filespec
;  of *.*
;
;  v1.09   12-08-1995
;          Checks for duplicate drive mappings.  If more than one drive
;          letter is mapped to the same drive, only the lowest will be
;  searched.  /M defeats the drive-mapping check.
;
;  v1.09a  12-12-1995
;          New switch /S displays summary info (counts) only, not the
;          list of file/directory names.
;
;  v1.09b  12-14-1995
;          /R now officially skips network and SUBST'ed drives.
;
;  v1.09c  12-26-1995
;          Makes the pause routine more Peterlike.
;
;  v1.09d  12-28-1995
;          Allows a keystroke to pause a continuous listing.
;
;  v1.10   01-01-1996
;          Now checks for a LOCATE= environment variable.  All switches are
;          legal in the LOCATE variable except for /B.  Adds /F- which
;  'undoes' any previous /F, setting MAX_COUNT to zero.  New switches:  /W -
;  wide Peter display.  /P - long Peter display.  /A - Peter display (long or
;  wide).  Also fixes a bug in the handling of . and ..
;
;  v1.10a  01-03-1996
;          Trivial change in the handling of /P.  (Now identical to /A.)
;
;  v1.10b  01-17-1996
;          Allows use of the Control key to slow down scrolling.  Long live
;          the C64!
;
;  v1.11   02-02-1996
;          Fixes a bug:  LOCATE \FILENAME did not restrict the search to the
;          current drive, as documented; fixed.  Minimum DOS version reduced
;  to 3.2.  Error messages now printed to STDERR, not STDOUT.
;
;  v1.11a  02-06-1996
;          Long-Peter display now includes attributes.
;
;  v1.11b  02-09-1996
;          Includes a total of sizes of all files found.
;
;  v1.12   02-16-1996
;          Minor changes:  removes duplicate environment-search code in
;          USE_PATH; trivial changes to syntax display; removes an unused
;  error message.
;
;  v1.12a  02-21-1996
;          /B now permits a number of arguments to be printed after the
;          filenames.  LOCATE C: /H /B3:"ATTRIB"  will produce lines like:
;  ATTRIB C:\MSDOS.SYS %1 %2 %3
;
;  v1.12b  03-06-1996
;          LOCATE . and LOCATE .. now restrict the search to the current
;          drive, as documented.  (LOCATE .\ and so forth did work
;  correctly.)  Basically, the v1.11 bug fix broke the v1.10 bug fix.  Oops.
;
;  v1.13   03-10-1996
;          Adds /O (macro output) and /G (go to directory).  /R now has no
;          effect when a drive is specified.  The buffer for /B and /O
;  strings has been increased to 80 bytes from 64.  Fixes a minor bug in the
;  handling of /F- /G- and /D- which could prevent the next switch from being
;  handled properly.
;
;  v1.13a  03-19-1996
;          Checks each drive for validity before starting search on it.
;          This will speed things up a great deal when (1) Netware client
;  software is loaded, and (2) a network cable is not connected.
;
;  v1.13b  03-20-1996
;          Exactly like v1.13a, except the drive-valid tests are done in
;          a different order (to avoid hitting drives which wouldn't be
;  accessed anyway.)
;
;  v1.14   03-25-1996
;          The /A Peter-style display is now the default.  New switch
;          /J (plain Jane) provides the old, default display format.
;  /P and /A are now allowed to override /W.  Also, more code in DOTS_FIX to
;  handle . and .. after a backslash:  unlikely syntax such as C:\DOS\. or
;  C:/DOS/.. and so on.  Spells 'continuous' correctly.
;
;  v1.15   03-31-1996
;          Major cleanup of the display-modes code.  Combines several
;          byte-sized flag variables into multifunction, bitmapped
;  variables.  Also, fixes nasty handling of /B:"FOO" /B.  /X now always
;  implies /D-.
;
;  v1.15a  04-07-1996
;          Minor change to SHOW_FRACTION routine.  Now it rounds up,
;          so the last digit is more accurate.
;
;  v1.16   05-21-1996
;          New switch /L displays Win95 long filenames.  New macros &W
;          and &Z display long filenames (corresponding to &F and &N
;  respectively).  Summary count says 'items found' instead of 'matches'.
;  SHOW_FRACTION won't round up past .99.  User may now specify multiple
;  drives; drive specs may be separated from filespec by spaces.  /V is no
;  longer supported.  If the current drive is C: or higher, and the user did
;  not specify a drive, the search starts at drive C: instead of A:.  New
;  switch /C checks file attributes.  'Bytes' message now pluralizes
;  correctly.  /B implies /D- unless the user specifies /D+ or /D on the
;  command line.
;
;  v1.17   07-04-1996
;          Incorporates Polite Tourist suggestions, courtesy Yves
;          Bellefeuille:  LOCATE now respects Config.sys COUNTRY directives.
;  New switches:  /U checks date stamps; /US overrides COUNTRY, forcing
;  United States output; /2 provides a two-column display; /12 and /24 change
;  time output.  File sizes are somewhat right-justified.  Control-C and
;  Control-Break are trapped.  New macros &1, &2, &3 output date, time, and
;  size, respectively.
;
;  v1.17a  07-12-1996
;          Forcing 12-hour or 24-hour mode is deferred until command-line
;          parsing is completed.  Accept /U! as a synonym for /UT.  Accept
;  Control-C and Control-Break at /G prompt.
;
;  v1.17b  09-06-1996
;          Minor cosmetic changes to display of file sizes.  Files of
;          1000K but less than 1M will now be correctly right-justified.
;
;  v1.17c  10-04-1996
;          New macro &J displays filename right-padded with spaces (for
;          justification) and Peter-cased.  Syntax message now includes
;  copyright and freeware notices, and my new email address.
;
;  v1.18   10-27-1996
;          New switch /K kills (deletes) files.  New switch /Y (yes) disables
;          verification for /K.  In pause mode, the slash key now scrolls a
;  half page.
;
;  v1.18a  11-11-1996
;          Fixes bugs created by v1.16 changes.  LOCATE \DIR\SPEC would
;          search multiple drives, from A: or C: through the current drive.
;  LOCATE D:/FOO would not correctly substitute a backslash for the slash.
;  Drive specs longer than the filespec would also cause problems:  CDE:?
;  would search for items named ?DE; fixed.
;
;  v1.18b  11-16-1996
;          Allows /K to remove empty subdirectories; combine /K with /D+
;          or /D to kill subdirectories only, or subdirectories and files.
;  No support for removal of non-empty subdirectories.  /K with no /D+ or /D
;  will default to files only, as before.  More work on the v1.16 mess:  now
;  LOCATE C:-W will search for files named -W on drive C:.  LOCATE C: -W will
;  do a Wide display of drive C: as documented.  /K not allowed in LOCATE
;  variable.
;
;  v1.19   11-25-1996
;          New switch /0 finds only empty files (file size of zero bytes.)
;
;  v1.20   12-11-1996
;          Major revision of asterisk wildcard handling.  Asterisks are now
;          allowed at the beginning or in the middle of a filename or
;  extension, not just the end.  FS_BUF expanded to 19 characters plus null
;  (was 12 characters plus null) to allow for several * wildcards.
;
;  v1.21   02-25-1997
;          New macros:  &Ca'True'False' conditional macro to print one of
;          two strings according to value of an attribute bit; &H to define
;  a 'header' string to be printed only once per subdirectory; &4 to print
;  the day of the week; &5 to print a file's size in 'pretty' format; &6 to
;  print a file's size as kilobytes or megabytes; &I to print a five-space
;  tab.  &3 (file size) modified to pad the size to eight characters or print
;  eight spaces for a subdirectory entry -- &5 and &6 behave similarly.  &U
;  permits printing the final summary info, normally suppressed for macro
;  output.
;
;  Syntax messages from /? /C? /U? etc. may now be redirected to a file or
;  device.  (Syntax messages caused by syntax errors will still go to the
;  console.)  Close quotes no longer required for /B and /O strings.
;          
;  v1.22   05-09-1997
;          Another housecleaning on the display code:  /O now does indirect
;          calls, not indirect jumps; several redundant routines removed.
;  Day-of-week code revamped (now computes 16-bit julians instead of 32-bit.)
;  DOWs now included in peter-style display by default.  Brackets no longer
;  printed around attributes (affects &B macro as well.)  Removed switches /J
;  /I /$ and /2 -- all but /2 can be faked using /O.  Better test for output
;  redirection.  New switches:  /NP no pausing, /NR no recursion.  Now allows
;  drive ranges to be specified using a dash:  LOCATE F-I:FOO.ZIP will search
;  drives F: G: H: and I:
;
;  v1.22a  05-27-1997
;          Fix for bug in /NR (lost filespec if no directory specified)
;
;  v1.22b  05-28-1997
;          Fix for stupid bug in decimal-input routine (overflow-detection
;          code would crash if the number overflowed the wrong way)
;
;  v1.23   06-09-1997
;          Adds support for screen heights greater than 25 lines.  Adds
;          limited support for UNC-style filenames.  Removes the two spaces
;  printed after &B.  Adds a blank line at the top of /O output if &U is
;  used.  Fixes nasty bugs in &S and &N caused by removal of an unreleased
;  print-to-video feature.  Fixes incorrect handling of /NP and /NR when they
;  occur in the environment variable.
;
;  v1.23a  06-23-1997
;          If drive B: does not exist (i.e., a single-floppy machine) it
;          will not be searched even if the user specifies that it should.
;
;  v1.23b  08-02-1997
;          Added a new, space-saving error-handler routine; arguments are
;          passed inline.  Code is slightly smaller.
;
;  v1.23c  08-16-1997
;          New switch /V to swap the pause-keys Enter and Space.  Put it in
;          the LOCATE variable if you prefer Enter to scroll a page, and
;  Space to scroll a line.  Also, parent-directory names now displayed with a
;  trailing backslash.
;
;  v1.24   10-05-1997
;          New switch /T: to search by time.  Now uses /D: for date search
;          (/U is still available.)  Allows subtracting x number of days
;  (weeks, months, years) from today's date.  /D:dow to search by day-of-the-
;  the-week.  FS_BUF expanded again to 47 characters plus null.  Unixy
;  character-class wildcards.  New /UK and /UJ to force U.K. and Japanese
;  date formats.  New /E displays seconds in times.  New macro &G prints the
;  canonical directory name, like &D, but without the drive letter:  useful
;  for copy scripts.  /Y is now disallowed in the LOCATE variable.
;
;  Removed the assumption that STDOUT is always to the console -- 4DOS can
;  redirect it.  Trapped Control-P and Control-Print Screen.
;
;  (v1.251  12-18-1997)
;
;  v1.24a  02-11-1998
;          Permits the tilde to be used as a list separator.  COMMAND.COM
;          splits batch arguments at commas or semicolons, making it
;  difficult to pass switches like /D:MON,WED,FRI to a batch file.  Now
;  /D:MON~WED~FRI is a legal alternative.
;
;  v1.25   02-16-1998
;          Mass reorganization of /L display -- now it looks more like /P.
;          Only SFN, date, attribs and size are shown in addition to the LFN.
;  /L having been the last of the two-line modes, removed the requirement for
;  scroll length to be even.  New macro &Y provides long parent-directory
;  name, corresponding to &P.  Also, LOCATE now uses screen widths of more
;  than 80 columns for /W and /L.
;
;  v1.25a  07-23-1998
;          New macros &# and &@ to display the number of the current item.
;          May be followed by a single digit to justify to n characters.
;  &# will left-pad with spaces; &@ will left-pad with zeros.  Otherwise, the
;  two macros are identical.  New display mode /I is similar to /P but shows
;  the index number.
;
;  v1.25b  08-30-1998
;          NUL may end the command line as well as CR.  (Fix for FreeDOS
;          compatibility issue.)
;
;  v1.25c  09-05-1998
;          Fixes the last fix, which bollixed the /T path search.
;
;  v1.25d  09-30-1998
;          Now runs correctly on systems with an 8086 or 8088 CPU.
;
;  v1.26   01-02-1999   15,360 bytes
;          Adds support for video-BIOS output (color.)  New execute command
;          /C.  Attribute check moved to /A.  /GF go to first.
;  /NV do not use video bios.  /S: size range.  Changes to date display.
;  /E gone.  (H/S) display suppressed if the user requires either of H or S
;  to be set.  Allow illegal values in /D: and /T:.  Rewrite of /I handling.
;  /L now compatible with Caldera's LFN support.  No longer shows 'bytes'
;  string for every file; 13 columns for file size.  /Z:ndhc user colors.
;  Found and fixed a truly obscure bug in /A attribute check; /A:D- or /A:D+
;  would not override /D- default for /B and /K.  Also, /A string is now
;  required to end with a plus or minus.
;
;  v1.26a  04-17-1999   15,364 bytes                          CFED175B  4C68
;          Fixes for two bugs in the internal SET handler.  If the very first
;          variable in the environment block was to be changed, LOCATE would
;  create a second instance without deleting the original -- leaving two
;  environment variables with the same name.  Also, now correctly handles the
;  (very unlikely) case of a completely empty environment block.
;
;  v1.27   10-04-1999   15,704 bytes                          A06BB013  1571
;          Strips any accent marks from letters when comparing.  Supports
;          code pages 437, 850, and 863.  Use new switch /Q to disable.
;  Began compressing the executable using UPX.
;
;  v1.28   11-07-1999   15,506 bytes                          92585710  BD3F
;          Buffers expanded to allow for extra-long "short" filenames under
;          Windows 95.  All or part of the filespec on the command line may
;  now be enclosed in quotes to "trap" spaces.  The directory name is now
;  canonicalized to fix . and .. entries.  Under Windows 95 this has the
;  happy side effect of automagically converting long directory names to
;  short form, so you can now do LOCATE "C:\PROGRAM FILES\*.EXE" or the like.
;  Use new /NC to disable this feature.  Switch /Q (do not strip accents) has
;  been moved to /NA.
;
;  v1.28a  09-16-2000   15,506 bytes                          EA6DB9B4  400D
;          Fix for a serious bug pointed out by Bjorn Simonsen:  filename
;          canonicalization was stepping on "character class" definitions,
;  breaking all bracket expressions.  Oops.
;
;  v1.29   10-08-2000   15,696 bytes                          89B019D9  F200
;          /X changes:  When running under 4DOS, .BTM is considered an
;          'executable' extension.  Also, it is now possible to specify a
;  list of extensions, i.e. LOCATE /X:JPG,JPE,GIF,TIF to find graphics files.
;  Tree buffer is now allocated in upper memory if possible.  New macros to
;  give consistent date and time stamps regardless of country settings:
;  &7 date in ISO format, no leading space; &8 time in 24-hour format, with
;  leading zero.  /UI is now a synonym for /UJ.
;
;  v1.29a  10-29-2001   15,696 bytes                          D13E7AC0  4143
;          Fix for a nasty little bug which could frag a random chunk of
;          memory if extensions were specified using /X:xxx.  Oops!
;
;  v1.29b  10-31-2001   15,696 bytes                          19C8A241  2BDF
;          The final file size display did not include the size in K or M
;          if the last item found was a subdirectory; fixed.
;
;  v1.30   09-08-2002   15,886 bytes                          07EC3EBF  EA5C
;          Adds three new macros:  &V long filename base name, &K long
;          filename extension, &+ set output color.  Added a fifth color
;          for executable files.
