/* LOKI.C -- Loki Text Editor

	Written April 1994 by Craig A. Finseth
	Copyright 1994 by Craig A. Finseth
*/

#include "loki.h"

void edit(void);

/* ------------------------------------------------------------ */

#if !defined(SYSMGR)
int
main(argc,argv)
	int argc;
	char *argv[];
	{
	int cnt;
	char *rfile = RES_FILENAME;

	key_method = NUL;
	screen_type = 102;
	xprintf("Loki, Copyright 1994,5 by Craig A. Finseth\n");

	if (argc < 1) {
usage:
		xprintf("usage is: loki [-options]\n\
	-k <type>	key input method\n\
	-r <file>	specify alternate resource file\n\
	-s <type>	screen type\n"
			);
		exit(1);
		}

/* arguments */

	for (cnt = 1; cnt < argc; cnt++) {
		if (*argv[cnt] == '-') {
			if (cnt + 1 >= argc) {
				xprintf("Missing value.\n");
				goto usage;
				}
			}
		if (strequ(argv[cnt], "-k")) {
			key_method = xtoupper(*argv[++cnt]);
			}
		else if (strequ(argv[cnt], "-r")) {
			rfile = argv[++cnt];
			}
		else if (strequ(argv[cnt], "-s")) {
			if (!SToN(argv[++cnt], &screen_type, 10)) {
				xprintf("Screen type must be an integer.\n");
				goto usage;
				}
			}
		else	{
			xprintf("Unrecognized option '%s'.\n", argv[cnt]);
			goto usage;
			}
		}

/* now can initialize stuff */

	if (!FResLoad(rfile)) exit(1);
	if (!TInit()) {
		xprintf("Can't init terminal %d\n", screen_type);
		exit(1);
		}
	DInit();
	FEnvLoad();

#if defined(MSDOS)
	if (madefor == 'D' || madefor == 'J') JInit();
#endif
	DNewDisplay();

	if (Res_Char(RES_CONF, RES_SHOWSTARTUP) == 'Y') {
		DShow('T', Res_String(NULL, RES_MSGS, RES_SCRATCH), FALSE);
		KPush(KGetChar());
		}

	edit();			/* do the actual editing */

#if defined(MSDOS)
	if (madefor == 'D' || madefor == 'J') JFini();
#endif
	DFini();
	TSetPoint(TMaxRow() - 1,0);
	TFini();
#if defined(MSDOS)
	_exit(0);
#else
	exit(0);
#endif
	}
#else
unsigned int errno;
unsigned int __brklvl;
unsigned char *environ = "";

void
main(void)
	{
	key_method = NUL;
	screen_type = 102;

	JInit();
	if (!FResLoad(RES_FILENAME)) JFini();
	TInit();
	DInit();
	FEnvLoad();

	DNewDisplay();

	if (Res_Char(RES_CONF, RES_SHOWSTARTUP) == 'Y') {
		DShow('T', Res_String(NULL, RES_MSGS, RES_SCRATCH), FALSE);
		KPush(KGetChar());
		}

	edit();			/* do the actual editing */

	JFini();
	DFini();
	TSetPoint(TMaxRow() - 1,0);
	TFini();
	}
#endif


/* ------------------------------------------------------------ */

/* This does the actual editing, we assume that the buffer is
initialized. */

void
edit(void)
	{
	int amt;
	char *cmddesc;

	doabort = FALSE;

	uarg = 1;
	isuarg = FALSE;
	KMacDo(RES_CONF, RES_INITMACRO, TRUE);

/* main loop */

	while (!doabort) {
		DIncrDisplay();
		redo = RES_UNKCMD;

/* get cmd */
		table = 0;
		do	{
			key = KGetChar();
			if (key == KEYQUIT) {
				MExit();
				return;
				}
			} while (key < 0);
		uarg = 1;
		isuarg = FALSE;

/* set up args */
	REDO:
		cmddesc = Res_String(NULL, RES_FUNCID,
			(redo == RES_UNKCMD) ? TabGetCmdID(key, table) : redo);

/* enter first? */
		if (cmddesc[0] == 'E') {
			m.stack_lift = FALSE;
			MEnter();
			if (m.stack_lift) {
				m.r[T] = m.r[Z];
				m.r[Z] = m.r[Y];
				m.r[Y] = m.r[X];
				m.r[X] = x;
				}
			m.stack_lift = TRUE;
			}

/* set up scratch variables */
		x = m.r[X];
		y = m.r[Y];
		z = m.r[Z];
		t = m.r[T];

/* lastx */
		if (cmddesc[3] == 'L') m.r[L] = m.r[X];

/* dispatch */
		if (redo == RES_UNKCMD) {
			while (uarg > 0) {
				TabDispatch(key, table);
				if (--uarg < 0) uarg = 0;
				}
			}
		else	{
			TabDo(redo);
			redo = RES_UNKCMD;
			}

/* drop stack */
		if (cmddesc[1] == '0') {
			}
		else if (cmddesc[1] == '1') {
			m.r[X] = m.r[Y];
			m.r[Y] = m.r[Z];
			m.r[Z] = m.r[T];
			}
		else if (cmddesc[1] == '2') {
			m.r[X] = m.r[Z];
			m.r[Y] = m.r[T];
			m.r[Z] = m.r[T];
			}
		else	{
			m.r[X] = m.r[T];
			m.r[Y] = m.r[T];
			m.r[Z] = m.r[T];
			}

/* save results */
		amt = cmddesc[2] - '0';

/* stack lift disabled and new operation lifts the stack */
		if (!m.stack_lift && cmddesc[1] < cmddesc[2]) {
			amt = cmddesc[2] - cmddesc[1] - 1;
			if (amt == 0) m.r[X] = x;
			}

		if (amt <= 0) {
			}
		else if (amt == 1) {
			m.r[T] = m.r[Z];
			m.r[Z] = m.r[Y];
			m.r[Y] = m.r[X];
			m.r[X] = x;
			}
		else if (amt == 2) {
			m.r[T] = m.r[Y];
			m.r[Z] = m.r[X];
			m.r[Y] = y;
			m.r[X] = x;
			}
		else if (amt == 3) {
			m.r[T] = m.r[X];
			m.r[Z] = z;
			m.r[Y] = y;
			m.r[X] = x;
			}
		else	{
			m.r[T] = t;
			m.r[Z] = z;
			m.r[Y] = y;
			m.r[X] = x;
			}

/* stack lift */
		m.stack_lift = cmddesc[4] == 'E';

		if (redo != RES_UNKCMD) goto REDO;
		}
	}


/* end of LOKI.C -- Loki Text Editor */
