static char _version[] = 
    "@(#) open version 1.20" "\n"
    "version 1.00 Copyright(C) 1995 Hiroyuki Sekiya" "\n"
    "	   current changes (C) 1999 Paulo Custodio" "\n";

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <limits.h>
#include <ctype.h>
#include <direct.h>

#ifdef __TURBOC__
#include <dir.h>
#else
#define fnsplit	    _splitpath
#define setvect	    _dos_setvect
#endif


/* PSC: PAL includes */
#include <pal.h>
#include <palsmsvc.h>

#ifndef SIMPLE_OPEN
#  include "resource.h"
#endif

typedef int BOOL;
typedef unsigned char UCHAR;
typedef unsigned int UINT;
typedef unsigned long int ULONG;
#define m_lock()    c_service(0x4603)
#define m_unlock()  c_service(0x4604)


/* PSC: Constants for keyboard scan codes */
#define SCAN_O	    0x186F	    /* O */
#define SCAN_ENTER  0x1C0D	    /* Enter */
#define SCAN_SLASH  0x352F	    /* / */
#define SCAN_F	    0x2166	    /* F */
#define SCAN_ALT_F  0x2100	    /* Alt-F */
#define SCAN_Q	    0x1071	    /* Q */
#define SCAN_ALT_Q  0x1000	    /* Alt-Q */
#define SCAN_R	    0x1372	    /* R */
#define SCAN_Y	    0x1579	    /* Y */
#define SCAN_ESCAPE 0x011B	    /* Esc */
#define SCAN_PASTE  0xD600	    /* Paste */


/* PSC: add path to 123 and quicken files */
#define DEFAULT_DBPATH	    "a:\\_dat;c:\\_dat;a:\\123;c:\\123;a:\\quicken;c:\\quicken"

/* PSC: Clipboard copy copied from LXREF */
int PutClipboard(char *owner, char *textbuffer)
{
    int err;
    m_lock();
    err = m_open_cb();
    if (err!=CB_OK) {
	m_unlock();
	return err;
    }
    /* Clipboard is now open */
    m_reset_cb(owner);
    m_new_rep("TEXT");
    err = m_cb_write(textbuffer, strlen(textbuffer));
    m_fini_rep();
    m_close_cb();
    m_unlock();
    return err;
}

/* PSC: Critical error handler: return FAIL if non-existent drive A: is accessed */
void __far criterr_handler(unsigned deverror, unsigned errcode, unsigned __far *devhdr)
{
    _hardresume( _HARDERR_FAIL );	/* Return Fail code to caller */
}
void install_criterr_handler()
{
    _harderr( criterr_handler );
}


/* PSC: convert a string to lower case */
char *StringToLower(char *s)
{
    char *p;
    for ( p = s; *p; p++ ) {
	*p = tolower(*p);
    }
    return s;
}

#ifndef SIMPLE_OPEN
/* PSC: GUI handling functions */
static BOOL _GUIStarted = FALSE;

/* Init PAL only when there is a need to ask something to the user */
void GUIStart() {
    if ( !_GUIStarted ) {
	if(!PalInit(1)) FatalExit("Init failed", 1);
	_GUIStarted = TRUE;
    }
}
/* Deinit PAL only if it was initialized */
void GUIEnd() {
    if ( _GUIStarted ) {
	PalDeInit(1);

	_GUIStarted = FALSE;
    }
}

/* PSC: search for common file path of all files given. Return number of
*  characters that match */
int CountCommonPath( char* items[], int count )
{
    int ret = INT_MAX;	    /* number of chars that match */
    int i, j;
    for (i = 0; i < count; i++) {	/* for each item */
	/* search maximum string that matches until '\\' separators */
	for (j = min((int)strlen(items[i]), ret); j >= 0; j-- ) {
	    if ( j <= 0 ) {
		return 0;	/* EXIT, no common part */
	    }
	    else if ( items[i][j-1] == '\\' ) {		/* separator */
		ret = j;	/* max common part */
		if ( i == 0 ||	/* first item OR */
		     _strnicmp(items[0], items[i], j) == 0 ) {
		    break;	/* found biggest match */
		}
	    }
	}
    }
    return ret;
}

/* PSC: ask user to select one item from the list given */
/* return pointer to string selected, NULL if canceled */
char* SelectOneItem( char* items[], int count )
{
    static char *Fkeys[10] = { 
	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "Cancel", "OK"
    };    
    int i, ret, key;
    char commonPath[ _MAX_PATH ];
    int commonCount;

    GUIStart();
    ShowFKeys(Fkeys);

    /* Get common part of path, write into label of dialogue box */
    commonCount = CountCommonPath(items, count);
    strncpy( commonPath, items[0], commonCount );
    commonPath[ commonCount ] = 0;
    SelectFileDlgItems[0].Text = commonPath;   /* NOTE: pointer to stack data */

    InitDialog(&SelectFileDlg);
    /* add strings in same order as they come, so that index = list box entry */
    for (i = 0; i < count; i++) {
	LbAddString(&SelectFileDlg,DLGLIST, LBPOS_LAST, 
		    StringToLower( items[i]+commonCount ));
    }
    /* select first in the list, show it and interact */
    LbSetPos(&SelectFileDlg,DLGLIST, 0);
    ShowDialog(&SelectFileDlg, (640 - SelectFileDlg.Width) /2, 0, 
	       "Open: select file to open");
    do {
	ret = HandleDialog(&SelectFileDlg, &key);
    } while ( ret != DN_OK && ret != DN_CANCEL && key != SCAN_ENTER );
    CloseDialog(&SelectFileDlg);

    SelectFileDlgItems[0].Text = NULL; /* NOTE: remove pointer to stack data */

    return ret==DN_CANCEL ? NULL : items[ LbGetPos(&SelectFileDlg,DLGLIST) ];
}

#endif /* ndef SIMPLE_OPEN */


/* PSC: Original code follows */

#define MENUKEY 0xC800
#define countof(x) (sizeof(x)/(sizeof((x)[0])))

typedef unsigned char	BYTE;
typedef unsigned int	WORD;

typedef struct sAPPINFO {
    char *ext;
    char *envname;	/* Env file, NULL if none */
    WORD keycode;
    struct {
	BOOL clipboard : 1;	/* TRUE to store file name in clipboard */
	BOOL close_before : 1;	/* TRUE to close app before starting it */
	BOOL push_file : 1;	/* TRUE to push "filename\n" to buffer after p_open_keys */
	BOOL only_close : 1;	/* if TRUE: if app is open, close it only, do not re-open (123) */
    } flag;
    WORD *p_open_keys;	/* 0 terminated list of keys to open file, if needed */
    WORD *p_close_keys; /* 0 terminated list of keys to close app */
} APPINFO;

/* Keys for Alt-F, Open, Paste, Enter */
WORD app_afopen_keys[] = {  
    SCAN_ESCAPE, SCAN_ESCAPE,	/* exit from dialog box, if any */
    SCAN_ALT_F, SCAN_O, SCAN_PASTE, SCAN_ENTER, 0
};
/* Keys for Alt-Q */
WORD app_close_keys[] = {
    SCAN_ALT_Q, 0 
};

/* Keys to open and close wk1 */
/* The sequence of 6 Esc chars is to exit from any menu that might be open */
WORD app_wk1_open_keys[] = {
    SCAN_ESCAPE, SCAN_ESCAPE, 
    SCAN_ESCAPE, SCAN_ESCAPE, 
    SCAN_ESCAPE, SCAN_ESCAPE,	/* exit from dialog, if any */
    SCAN_SLASH, SCAN_F, SCAN_R, /* Menu File Retrieve */
    SCAN_ESCAPE, SCAN_ESCAPE,	/* escape from defaults */
    0				/* 123 does not accept paste, need to push each char
				   of file name */
};
WORD app_wk1_close_keys[] = {
    SCAN_ESCAPE, SCAN_ESCAPE, 
    SCAN_ESCAPE, SCAN_ESCAPE, 
    SCAN_ESCAPE, SCAN_ESCAPE,	/* exit from dialog, if any */
    SCAN_SLASH, SCAN_Q, SCAN_Y,
    0
};

#define ENV_FILE_OFFSET	    0	/* PSC: All env files have an offset of 0 */

APPINFO appinfo[] = {
    /* ext   env		   key	  clip	close pushf onlyc 
     open-keys		close-keys */
    {".gdb","c:\\_dat\\db.env",	   0xBA00,FALSE,TRUE, FALSE,FALSE,
     NULL,		app_close_keys },

    {".ndb","c:\\_dat\\note.env",  0xBE00,FALSE,TRUE, FALSE,FALSE,
     NULL,		app_close_keys },

    {".pdb","c:\\_dat\\phone.env", 0xB400,FALSE,TRUE, FALSE,FALSE,
     NULL,		app_close_keys },

    {".adb","c:\\_dat\\apptbk.env",0xB000,FALSE,TRUE, FALSE,FALSE,
     NULL,		app_close_keys },

    {".wdb","c:\\_dat\\world.env", 0xC600,FALSE,TRUE, FALSE,FALSE,
     NULL,		app_close_keys },

    /* PSC: new file types */
    {".pdt",NULL,		   0xAC00,TRUE, FALSE,FALSE,FALSE,
     app_afopen_keys,	app_close_keys },

    {".wk1",NULL,		   0xBC00,FALSE,TRUE, TRUE, TRUE, 
     app_wk1_open_keys,	app_wk1_close_keys },

    /* 3 entries for MEMO: .doc, .txt, any other extension */
    {".doc",NULL,		   0xB800,TRUE, FALSE,FALSE,FALSE,
     app_afopen_keys,	app_close_keys },
    {".txt",NULL,		   0xB800,TRUE, FALSE,FALSE,FALSE,
     app_afopen_keys,	app_close_keys },
    /* this must be the last entry of table */
    {"",    NULL,		   0xB800,TRUE, FALSE,FALSE,FALSE,
     app_afopen_keys,	app_close_keys },
};

int fexist(const char *name)
{
    FILE *fp;

    if ((fp = fopen(name, "rb")) == NULL)
	return 0;
    else {
	fclose(fp);
	return 1;
    }
}

void KbdPushKey(WORD keycode)
{
#ifdef __TURBOC__
    _CX = keycode;
    _AH = 0x05;
    geninterrupt(0x16);
#else
    _asm {
	mov	cx, keycode
	mov	ah, 0x05
	int	0x16
    };
#endif
}
/* PSC: Push a sequence of keys, given as an array of WORDs, 0 terminated */
void KbdPushKeySequence( WORD *keys )
{
    for( ; *keys ; keys++ )
	KbdPushKey( *keys );
}
/* PSC: Push an ASCII string */
void KbdPushKeyString( char *str )
{
    for( ; *str != '\0' ; str++ )
	KbdPushKey( (WORD)(*str) );	/* HACK: for Ascii chars, scan may be 00 */
}


int launch(const char *dir, const char *name, const char *ext)
{
    char path[_MAX_PATH];
    char abspath[_MAX_PATH];
    WORD i;
    APPINFO *thisinfo = NULL;

    if (*ext == '\0') {
	for (i=0; i<countof(appinfo); ++i) {
	    strcat(strcat(strcpy(path, dir), name), appinfo[i].ext);
	    if (fexist(path)) goto LAUNCH;
	}
	return 0;
    } else {
	strcat(strcat(strcpy(path, dir), name), ext);
	/* PSC: path is invariant, make test out of loop */
	if ( ! fexist(path) )
	    return 0;	

	/* PSC: Bug - was counting to countof()-1 */
	for (i=0; i<countof(appinfo) ; ++i)
	    if (appinfo[i].ext[0] == '\0' ||		/* Default: MEMO */
		stricmp(appinfo[i].ext, ext) == 0)	/* or extension matches */
		goto LAUNCH;
	return 0;
    }
LAUNCH:
    /* PSC: get absolute path of file */
    if ( _fullpath( abspath, path, _MAX_PATH ) == NULL ) 
	FatalExit("_fullpath error",1);

    /* PSC: Push keys <Appkey>,<Alt-Q> to close application, if it is open */
    thisinfo = &(appinfo[i]);
    if ( thisinfo->flag.close_before ) {
#ifndef DEBUG
	if (IsAppActive(thisinfo->keycode)) {
	    /* Need to send Appkey, Alt-Q: so that application closes
	    *  and reopens later with new file */
	    KbdPushKey(thisinfo->keycode);
	    KbdPushKeySequence(thisinfo->p_close_keys);
	    if ( thisinfo->flag.only_close )
		return 1;	    /* do not re-open, to let user Save file */
	}
#endif
    }

    /* PSC: store file name in clipboard if clipboard flag is set */
    if ( thisinfo->flag.clipboard ) {
#ifndef DEBUG
	if ( PutClipboard("OPEN", abspath) != CB_OK )
	    return 0;
#endif
    }
    
    /* PSC: envname may be NULL, if there is no env file */
    if ( thisinfo->envname != NULL ) {
#ifndef DEBUG
	FILE *fp;
	if ((fp = fopen(thisinfo->envname, "r+b")) == NULL)
	    return 0;

	fseek(fp, ENV_FILE_OFFSET, SEEK_SET);
	fwrite(abspath, sizeof(abspath[0]), strlen(abspath)+1, fp);
    
	fclose(fp);
#endif
    }

#ifndef DEBUG
    KbdPushKey(thisinfo->keycode);
#endif

    /* PSC: Push keys needed to open file, if any */
    if ( thisinfo->p_open_keys ) {
#ifndef DEBUG
	KbdPushKeySequence( thisinfo->p_open_keys );
#endif
    }

    /* PSC: Push "filename\n" if needed */
    if ( thisinfo->flag.push_file ) {
#ifndef DEBUG
	KbdPushKeyString( abspath );
	KbdPushKey( SCAN_ENTER );
#endif
    }

    return 1;
}

/* PSC: old main, only called with ONE file to open */
int open_main(char *file)
{
    char basedir[_MAX_PATH];
    char dir[_MAX_DIR];
    char name[_MAX_FNAME];
    char ext[_MAX_EXT];
    char *dbpath;
    char *p;
    
    /* PSC: install critical error handler */
    install_criterr_handler();

    /* fBNgAt@CAgqɕ */
    fnsplit(file, basedir, dir, name, ext);
    strcat(basedir, dir);
    if (launch(basedir, name, ext))
	return 0;
    else if (*basedir == '\0') {
	dbpath = getenv("DBPATH");
	if (*dbpath == '\0') 
	    dbpath = DEFAULT_DBPATH;
	while (*dbpath != '\0') {
	    if (*dbpath == ';') ++dbpath;
	    p = basedir;
	    while (*dbpath != '\0' && *dbpath != ';') *p++ = *dbpath++;
	    if (*(p-1) != '\\') *p++ = '\\';
	    *p = '\0';
	    if (launch(basedir, name, ext)) return 0;
	}
    }
    fputs("File not found.\n", stderr);
    return 1;
}

/* PSC: modified to use PAL */
int main(int argc, char **argv)
{
    char *file;
    int ret;
    
    /* check arguments */
    if (argc == 2) {
	file = argv[1];
    }
#ifndef SIMPLE_OPEN
    else if (argc > 2) {
	file = SelectOneItem(argv+1, argc-1);
    }
#endif
    else {
	fputs(_version, stderr);
#ifdef SIMPLE_OPEN
	fputs("Usage: sopen <file>\n", stderr);
#else
	fputs("Usage: open <file-pattern>...\n", stderr);
#endif
	return 1;
    }

#ifndef DEBUG
    if(!CheckSysMgr()) FatalExit("SysMgr not loaded", 1);
#endif
    ret = open_main(file);

#ifndef SIMPLE_OPEN
    GUIEnd();
#endif
    return ret;
}

