//
//		XP[Xg
//

#include <stdio.h>
#include <dos.h>
#include <math.h>
#include <time.h>
#include <string.h>
#include <graphics.h>
#include "hp100.h"

extern int end;

extern int inkey(int);

	 char stem8[] = { 
		 -3,20,
		 7,0x00,17,0x00,
		 0xC0,
		 0xE0,
		 0xF0,
		 0x98,
		 0x8C,
		 0x86,
		 0x83,
		 0x81,
		 0x81,
		 0x81,
		 0x81,
		 0x81,
		 0x81,
		 0x82,
		 0x84,
		 0x88,
		 0x80,
		 0x80
	 };
	 
	 uchar hed4[] = { 
		 4,3,
		 7,0,5,0,
		 0x3E,
		 0x7F,
		 0xFF,
		 0xFF,
		 0xFE,
		 0x7C
		 };

	 uchar hed2[] = { 
		 4,3,
		 7,0,6,0,
		 0x3E,
		 0x71,
		 0xE3,
		 0xE3,
		 0xC7,
		 0x8E,
		 0x7C
	 };

	 uchar spite[] = { 
		 4,3,
		 15,0,6,0,
		 0x00,00,
		 0x00,00,
		 0x00,00,
		 0xFF,0xFF,
		 0x00,00,
		 0x00,00,
		 0x00,00,
	 };

	 uchar hed1[] = { 
		 4,3,
		 7,0,5,0,
		 0x7C,
		 0x8E,
		 0xC7,
		 0xE3,
		 0x71,
		 0x3E
	 };
	 

//
//	XRApՎL
//

	 uchar s_shrp[] = { 
		 0x00,5,
		 7,0,9,0,
		 0x50,
		 0x58,
		 0x70,
		 0xD0,
		 0x50,
		 0x50,
		 0x58,
		 0x70,
		 0xD0,
		 0x50
	 };

 
	 uchar s_flat[] = { 
		 0x00,5,
		 7,0,8,0,
		 0x40,
		 0x40,
		 0x40,
		 0x70,
		 0x48,
		 0x48,
		 0x48,
		 0x50,
		 0x60,
		 0x40
	 };

//
//		ItZbgtputimage
//

void putptn(int x,int y,char *ptn,int m)
{

	int ofsx = *(ptn);
	int ofsy = *(ptn+1);
	x -= ofsx;
	y -= ofsy;

	putimage(x,y,ptn+2,m);

}

 

#define SCX (SQX+8)
#define SCC (SQX+SQW/2)
#define SCW (SQW-16)
#define SCY (SQY+SQH/2)
#define CCY (SCY+3*6)

void draw_keycode(int key)
{
	int x,y;

	x = SQX+50;
	y = SCY-12;

	switch(key){
		case 11:putptn(x +16,y+ 15 ,  s_shrp,OR_PUT);
		case  4:putptn(x +12,y+ 6  ,  s_shrp,OR_PUT);
		case  9:putptn(x +8 ,y- 3  ,  s_shrp,OR_PUT);
		case  2:putptn(x +4 ,y+ 9  ,  s_shrp,OR_PUT);
		case  7:putptn(x    ,y     ,  s_shrp,OR_PUT);
			break;
		case  6  :putptn(x +20,y+9   ,  s_flat,OR_PUT);
		case  1  :putptn(x +16,y+18  ,  s_flat,OR_PUT);
		case  8  :putptn(x +12,y+6   ,  s_flat,OR_PUT);
		case  3  :putptn(x +8 ,y+15  ,  s_flat,OR_PUT);
		case 10  :putptn(x +4 ,y+ 3  ,  s_flat,OR_PUT);
		case  5  :putptn(x    ,y+12  ,  s_flat,OR_PUT);
			break;
		}

}

 

//
//
//

#define SCALEMAX 7

struct _scale_ {
	char name[16];
	int	note[7];
	int	avoid[7];
	};
struct _scale_ scales[] = {
	{	"Ionian",
		0,1,2,3,4,5,6,
		0,1,0,1,0,0,0},
	{	"Dorian",
		1,2,3,4,5,6,7,
		0,1,0,1,0,1,0},
	{	"Phrygian",
		2,3,4,5,6,7,8,
		0,1,0,1,0,1,0},
	{	"Lydian",
		3,4,5,6,7,8,9,
		0,1,0,1,0,1,0},
	{	"Mixo-Lydian",
		4,5,6,7,8,9,10,
		0,1,0,1,0,1,0},
	{	"Aeorian",
		5,6,7,8,9,10,11,
		0,1,0,1,0,1,0},
	{	"Locrian",
		-1,0,1,2,3,4,5,
		0,1,0,1,0,1,0}
	};
	
//
//	tpXP[m[g
//	
int scale_notes[12][8]={
	 0, 2, 4, 5, 7, 9, 11, 12,
	 1, 3, 5, 6, 8,10, 12, 13,
	 2, 4, 6, 7, 9,11, 13, 14,
	 3, 5, 7, 8,10,12, 14, 15,
	 4, 6, 8, 9,11,13, 15, 16,
	 5, 7, 9,10,12,14, 16, 17,
	 6, 8,10,11,13,15, 17, 18,
	 7, 9,11,12,14,16, 18, 19,
	 8,10,12,13,15,17, 19, 20,
	 9,11,13,14,16,18, 20, 21,
	10,12,14,15,17,19, 21, 22,
	11,13,15,16,18,20, 22, 23
	};


draw5line()
{
	extern char gcref[];
	int	x,y,i;

//	setlinestyle(0,0,NORM_WIDTH);
//	rectangle(SQX,SQY,SQX+SQW,SQY+SQH);
//	rectangle(SQX-1,SQY-1,SQX+SQW+1,SQY+SQH+1);

	setfillstyle(0,0);
	bar(SQX+1,SQY+1,SQX+SQW-1,SQY+SQH-1);

	x = SCX;y = SCY;
	
	for(i=-2;i<3;i++){
		line(x,y+i*6,x+SCW,y+i*6);
		}
	putimage(x,y-17,gcref,0);

}

char *getKeyStr(int ky,int scl)
{
	static char *kystrs[12][7] 
	= { {"C","D","E","F","G","A","B"},
	    {"Db","Eb","F","Gb","Ab","Bb","C"},
	    {"D","E","F#","G","A","B","C"},
	    {"Eb","F","G","Ab","Bb","C","D"},
	    {"E","F#","G#","A","B","C#","D#"},
	    {"F","G","A","Bb","C","D","E"},
		{"Gb","Ab","Bb","Cb","Db","Eb","F"},
		{"G","A","B","C","D","E","F#"},
		{"Ab","Bb","C","Db","Eb","F","G"},
		{"A","B","C#","D","E","F#","G#"},
		{"Bb","C","D","Eb","F","G","A"},
		{"B","C#","D#","E","F#","G#","A#"},

	};

	return kystrs[ky][scl];

}

//
//		XP[̕`
//

void drawScale(int ky,int scl)
{
	int	x,y,i;
	uchar	*ptn;	char	s[80];
	static int kyofs[] = {0,1,1,2,2,3,4,4,5,5,6,6};
	int	nt;

	x = SCX+120;
	y = SCY;

	settextstyle(0,HORIZ_DIR,1);
	settextjustify(LEFT_TEXT,CENTER_TEXT);

	sprintf(s,"%s %s",getKeyStr(ky,scl),scales[scl].name);
	outtextxy(SQX+20,SQY+8,s);

	draw_keycode(ky);

	for(i=0;i<7;i++){
//		putptn( x+i*40,CCY-i*3,hed2 ,OR_PUT);
		if(scales[scl].avoid[i])
			 ptn = hed4;
		else ptn = hed2;

		nt = scales[scl].note[i]+kyofs[ky];

		if(scales[scl].note[0]+kyofs[ky] > 5)
			nt -= 7;
		if(scales[scl].note[0]+kyofs[ky] < -1)
			nt += 7;

		if(nt<1)
			putptn(x+i*40-4,CCY,spite,OR_PUT);

		putptn( x+i * 40,CCY-nt*3,ptn,OR_PUT);
		}

}

//
//		Scale Play
//

int	splay=0;
int	pcount=0;
int sscl;
long lasttime;
int	pkey;
int pscl;
int	pofs;

void splay_stop(void)
{
	splay = 0;

	note_off();

}


void do_scl_play(void)
{
	int	nt,n,noct=0;

	if(!splay)
		return;
	if(lasttime == time(0))
		return;
	lasttime = time(0);

	if(pcount > 7){
		splay_stop();
		return;
		}


	n = sscl + pcount++;
	if(n > 7 ){
		n -= 7;
		noct=12;
		}

	nt = scale_notes[pkey][n] + pofs + noct;

//	printf("Note %d\r",nt);

	note_on(nt);

}

void splay_start(int ky,int scl)
{
	pkey = ky;
	pscl = scl;
	sscl = scl;
	pcount = 0;

	if(scale_notes[ky][pscl] > 9)
		pofs = -12;
	else pofs = 0;

	lasttime=time(0);

}


//
//		XP[[h
//

scalmode()
{
	static int	scl=0,ky=0;
	int brk=0,drw=0;
	int	c;

	settextstyle(0,HORIZ_DIR,0);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	outtextxyinv(CLX4,CLY," Scale ");


	while(!end && !brk){
		c = inkey(0);
		drw=0;
		switch(c){
			case UP :scl++;
					drw=1;
					break;
			case DWN:scl--;
					drw=1;
					break;

			case RGT:ky++;
					drw=1;
					break;
			case LFT:ky--;
					drw=1;
					break;

			case F2:metroout(OFF);
					setendmode(0);
					brk=1;
					break;

			case F3:setendmode(F3);		// Exg. Metro mode
					brk = 1;
					break;

			case F9 :end = 1;
					break;

			default : c = c & 0xFF;
				break;

			}

		if((c == ' ') || (c == CR)){
			splay = splay ^ 1;

			if(splay)
				splay_start(ky,scl);
			else splay_stop();
			}

		if(splay && drw){
			splay_start(ky,scl);
			}

		do_scl_play();

		if(scl > 6 )
			scl = 0;
		if(scl < 0 )
			scl = 6;
		if(ky > 11)
			ky = 0;
		if(ky < 0)
			ky=11;

		if(drw){
			draw5line();
			drawScale(ky,scl);
			}
		}

	splay_stop();
	settextstyle(0,HORIZ_DIR,0);
	settextjustify(CENTER_TEXT,CENTER_TEXT);
	outtextxynrm(CLX4,CLY," Scale ");

}

