/* --------------------------------------------------------------------
   Project: PAL General Database routines
   Module:  SHOWHEADER.C
   Author:  Jean-Jacques Moreau
   Started: 11. Aug. 99
   Subject: Show database viewpoint header
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                          standard includes
   -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

/* --------------------------------------------------------------------
                            local includes
   -------------------------------------------------------------------- */

#include "pal.h"


/* --------------------------------------------------------------------
                            local constants
   -------------------------------------------------------------------- */

#define KEYDEPTH   9
#define MAX_X3   213   /* MAX_X / 3 */


/* -------------------------------------------------------------------------
                           Show database viewpoint header
   ------------------------------------------------------------------------- */

static int ShowHeaderForPage(DBDESC *pDD, WORD PageNo)
{
   int f, from, to, offset, width;
   FIELDEF *pField;
   char Buffer[128];

   if(!pDD->NumFields) {
      pDD->ErrorMsg = MISSING_FIELDEFS;
      return 0;
   }

   from=0; to=20;
   offset=PageNo*MAX_X3;

   /* clear screen area */
   SetColor(WHITE_COLOR);
   SetRule(FORCE_RULE);
   if (pDD->ZoomMode == ZOOM_1) {
      Rectangle(0,12,639,25,SOLID_FILL);
      SetColor(BLACK_COLOR);
      Rectangle(0,12,639,25,OUTLINE_FILL);
   } else {
      Rectangle(offset,12,offset+MAX_X3,25,SOLID_FILL);
      SetColor(BLACK_COLOR);
      Rectangle(offset,12,offset+MAX_X3,25,OUTLINE_FILL);
      Line(offset+MAX_X3,26,offset+MAX_X3,MAX_Y-KEYDEPTH-2);
      SetClip(offset+1,0,offset+MAX_X3-1,MAX_Y);
   }
   SelectFont(MEDIUM_FONT);

   offset=offset+13;
   for(f=from;f<to;f++) {
      if (pDD->pVDEF->ColumnInfo[f] == 0x00ff)
         break;

      width=(pDD->pVDEF->ColumnInfo[f] & 0xff00) >> 8;
      pField=pDD->pFDEF[pDD->pVDEF->ColumnInfo[f] & 0x00ff];

      strncpy(Buffer, pField->Name, width-1);
      Buffer[width-1]=0;
      SetRule(TXT_RULE);
      WriteText(offset, 14, Buffer);

      offset=offset + 6 + (width * FNTW(MEDIUM_FONT));

      Line(6+offset-FNTW(MEDIUM_FONT),12,6+offset-FNTW(MEDIUM_FONT),25);
   }
   if (pDD->ZoomMode == ZOOM_3)
      SetClip(0,0,MAX_X,MAX_Y);

   pDD->ErrorMsg = OPERATION_OK;
   return f;
}


/* -------------------------------------------------------------------------
                           Show database viewpoint header
   ------------------------------------------------------------------------- */

int ShowHeader(DBDESC *pDD)
{
   ShowHeaderForPage(pDD, 0);
   if (pDD->ZoomMode == ZOOM_3) {
      ShowHeaderForPage(pDD, 1);
      ShowHeaderForPage(pDD, 2);
   }
}

