/* rtf2html.c */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dox.h"

#define NUMDOCS 3

short whatdoc(char *command, char *filename);

char command_list[NUMDOCS] = "rht";
char *extension_list[NUMDOCS] = {"rtf", "html htm", "txt"}; 


main(int argc, char *argv[])
{
int count, doc;
char *infile, *outfile;
state_type state;

state.font_sensitive = FALSE;
infile = NULL;
outfile = NULL;
state.indoc = doc_rtf;
state.outdoc = doc_html;

help(0);

/* Figure out what's coming in on the command prompt. */
for (count=1;count<argc;count++)
        if (argv[count][0]=='-')
                switch(argv[count][1])
                        {
                        case 'F':
                                doc = whatdoc(argv[count], NULL);
                                if (doc != FAIL)
                                        state.indoc = doc;
                                        
                                break;

                        case 'f':
                                count++;
                                if (count<argc)
                                        infile = argv[count];
                                doc = whatdoc(argv[count-1], infile);
                                if (doc != FAIL)
                                        state.indoc = doc;
                                break;

                        case 'O':
                                doc = whatdoc(argv[count], NULL);
                                if (doc != FAIL)
                                        state.outdoc = doc;
                                break;

                        case 'o':
                                count++;
                                if (count<argc)
                                        outfile = argv[count];
                                doc = whatdoc(argv[count-1], outfile);
                                if (doc != FAIL)
                                        state.outdoc = doc;
                                break;

                        case 's':
                                state.font_sensitive = TRUE;
                                break;

                        case '?':
                                help(1);
                                break;
                        }
                
                else
                        {
                        infile = argv[count];
                        doc = whatdoc(NULL, infile);
                        if (doc != FAIL)
                                state.indoc = doc;
                        }

/* Open input and output streams */
if (infile==NULL)
        state.in = stdin;
else
        if ((state.in = fopen(infile, "rb"))==NULL)
		{
		printf("Could not open %s\n", infile);
		exit(1);
		}
        else    printf("%s opened for reading as a %s file.\n", infile,
                        extension_list[state.indoc]);


if (outfile==NULL)
        state.out = stdout;
else
        if ((state.out = fopen(outfile, "wt"))==NULL)
		{
		printf("Could not open %s\n", infile);
		exit(1);
		}
        else    printf("%s opened for writing as a %s file.\n", outfile,
                        extension_list[state.outdoc]);

/* Convert file. */
convert(&state);

/* Close streams. */
fclose(state.in);
fclose(state.out);
}

void help(unsigned level)
{
switch(level)
        {
        case 0:
                printf("dox. A RTF to HTML converter. (c)1998 Andrew Punch.\n");
                printf("Type  %s -?  for help. Version "VERSION"\n", COMPILE);
                break;

        case 1:
                printf("\nUsage: %s [[-f] <infile>] [-o <outfile>] [-s] [-?]\n", COMPILE);
                printf("[-f] <infile> input File. Default is stdin.\n");
                printf("-o <outfile>  Output file. Default is stdout.\n");
                printf("-s            font Sensitive. Default is off.\n");
                printf("-?            view this help screen.\n");
                exit(0);
                break;
       }
}




void default_style(state_type *state, unsigned init)
{
unsigned count;

if (init)
	{
        state->current[0] = 0;
        state->new[0] = 1;
        state->current[1] = 0;
        state->new[1] = 0;
        state->current[2] = 0;
        state->new[2] = 0;
        }

for (count=PRESERVED;count<MAXSTYLES;count++)
	{
        state->new[count]=FALSE;
	if (init)
                state->current[count]=FALSE;
	}
}


short whatdoc(char *command, char *filename)
{
short count;
char *extension;

if (command!=NULL)
        if (command[2])
                for (count=0;count<NUMDOCS;count++)
                        if (command[2]==command_list[count])
                                return count;


extension = strrchr(filename, '.');

if (extension==NULL)
        {
        printf("Invalid filename");
        return FAIL;
        }
else
        extension++;


if (filename!=NULL)
                for (count=0;count<NUMDOCS;count++)
                        if (strstr(extension_list[count], extension)!=NULL)
                                return count;

return FAIL;
}



/* *********************************************************************** */
/* ****************** File functions. ************************************ */
/* *********************************************************************** */
short nextchar(FILE *instream)
{
short c;
c = fgetc(instream);
ungetc(c, instream);
}

/* Input & output remapping functions. */
void convert(state_type *state)
{
switch(state->indoc)
        {
        case doc_rtf:
                rtf_convert(state);
                break;
        case doc_html:
                html_convert(state);
                break;
        case doc_text:
                text_convert(state);
                break;
        }
}



void output(state_type *state, char *word)
{
switch(state->outdoc)
        {
        case doc_rtf:
                rtf_output(state, word);
                break;
        case doc_html:
                html_output(state, word);
                break;
        case doc_text:
                text_output(state, word);
                break;
        }
}


void update_style(state_type *state)
{
switch(state->outdoc)
        {
        case doc_rtf:
                rtf_update_style(state);
                break;
        case doc_html:
                html_update_style(state);
                break;
        case doc_text:
                text_update_style(state);
                break;
        }
}
