\ CSV2GP ver. 1.1
\ New: multiple e-mail addresses in one item can be used
\ Source file for ForthCMP compiler, version 2.30S
\ Pavel Zampach (zampach@volny.cz), 2002

\ converts CSV file with addresses f.e:
\    Lackland John,johnny@goodold.uk
\    Lionheart Richard,dick@goodold.uk
\    Boys,johnny@goodold.uk,dick@goodold.uk
\ into GP.ADR for Goin' Postal


3000 CONSTANT PSIZE
100 MSDOS
NOMAP
I80186
INCLUDE FILES1
HEX


81 CONSTANT TIB         \ as TIB we can use system memory above 128
VARIABLE >IN
VARIABLE #TIB

 0A CONSTANT LF
100 CONSTANT linelen
CREATE header 5D C, 52 C,
CREATE reclen 0 C, 0 C, 0 C, 0 C,
CREATE line   linelen ALLOT
VARIABLE comcount        \ counter of commas
VARIABLE output
VARIABLE input

1 0 IN/OUT
\ test of IOR
: TIOR ( ior -- )
  IF
    CR ." File error!" CR BYE
  THEN
;

: MAIN
  80 C@ #TIB ! >IN OFF    \ prepare command line for processing

  BL WORD COUNT
  R/O OPEN-FILE TIOR      \ open input file
  input !                 \ write fileid
  S" GP.ADR"
  W/O CREATE-FILE TIOR    \ open output file
  output !                \ write fileid

  BEGIN
    line linelen LF FILL  \ fill line by LF
    comcount OFF          \ null comma counter
    line linelen input @  \ read line
    READ-LINE TIOR        \ ( -- u flag ior )
  WHILE
    DUP DUP               \ 3x no. of chars
    0 DO                  \ 1 - replace comma by LF
      I line + C@
      [CHAR] , = IF
        LF I line + C!
        1 comcount +!     \ increment counter
      THEN
    LOOP
    5 comcount @ - +
    reclen C!             \ 2 - store lenght
    0B comcount @ - +
    header SWAP output @  \ 3 - write header+line
    WRITE-FILE TIOR
  REPEAT                  \ and back...
  DROP                    \ no. of chars from last unsuccesfull reading

  input  @ CLOSE-FILE TIOR
  output @ CLOSE-FILE TIOR
;

INCLUDE FILES2
INCLUDE FORTHLIB
END
