'/* REPLB.BAS Search and replace text strings in text file */
'/*           By: Dale Thorn                               */
'/*           Rev. 15.03.2000                              */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

cls                                                       'clear the DOS screen
ccmd = rtrim$(command$)                         'right-trim user's command line
if ccmd = "" then                            'user did NOT enter a command line
   cmsg = "Usage:  REPLB  filename  searchtext  replacetext"  'set message text
   ctmp = space$(4)                                     'set left margin spaces
   locate 5, 1, 1                                   'locate cursor for messages
   print ctmp; cmsg                                 'display first user message
   print                                           'blank line between messages
   print ctmp; "If 'searchtext' or 'replacetext' contains one or"  '2nd message
   print ctmp; "more blank spaces, place quotes around the text."  '2nd message
   print                                           'blank line between messages
   print ctmp; "If '/C' specified, use case sensitive search."   'third message
   print ctmp; "If '/Q' specified, remove quotes around text."  'fourth message
   close                                                  'close all open files
   system                                           'return to operating system
end if

icas = 0                                      'initialize case-sensitivity flag
iqot = 0                                     'initialize the remove-quotes flag
do                                 'begin loop to process command-line switches
   select case ucase$(right$(ccmd, 2))        'select on a possible User switch
      case "/C"                                'case-sensitive switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/C' parameter
         icas = not 0                           'set the case-sensitive flag ON
      case "/Q"                                 'remove-quotes switch specified
         ccmd = rtrim$(left$(ccmd, len(ccmd) - 2))   'remove the '/Q' parameter
         iqot = not 0                            'set the remove-quotes flag ON
      case else                              'no (more) User switches specified
         exit do                            'no (more) User switches; exit loop
   end select
loop

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())      'parse the user parameters
if iprm <> 1 then                                  'user input wrong parameters
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit
if len(cprm(1)) > len(cprm(0)) then             'replacement string is too long
   i = ifn.msgs("Replacement text too long", 5, 24, 79, 1, 1)
end if                                  'display error message [above] and exit
if not icas then                                'the case-sensitive flag is OFF
   lset cprm(0) = ucase$(cprm(0))                    'uppercase the search text
end if

if iqot then                                      'the remove-quotes flag is ON
   for i = 0 to iprm                               'loop thru user's parameters
      ilen = len(cprm(i))                          'length of current parameter
      if  midchar(cprm(i), 1) = 34 _               'leftmost character is quote
      and midchar(cprm(i), ilen) = 34 _           'rightmost character is quote
      and ilen > 2 then                            'parameter NOT 1 or 2 quotes
         cprm(i) = mid$(cprm(i), 2, ilen - 2)     'remove quotes from parameter
      end if
   next
end if

i = ifn.open(1, cfil, "B", llof)           'open the source file in binary mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

ibuflen = 8192                                  'set length of data file buffer
itxtlen = len(cprm(0))                          'length of user's search string
cfilbuf = space$(ibuflen)                      'initialize the data file buffer
ctstbuf = space$(ibuflen)                      'initialize the data test buffer
lptr = 1                                      'initialize the file read pointer
while lptr <= llof                             'loop until end of the data file
   get 1, lptr, cfilbuf                         'get text data from source file
   lspn = lptr + ibuflen - llof - 1            'amount pointer spans beyond EOF
   if lspn > 0 then                              'file pointer spans beyond EOF
      mid$(cfilbuf, ibuflen - lspn + 1) = string$(lspn, 0)'set EOF area to nulls
   end if
   if icas then                                  'the case-sensitive flag is ON
      lset ctstbuf = cfilbuf                    'put file buffer to test buffer
   else                                         'the case-sensitive flag is OFF
      lset ctstbuf = ucase$(cfilbuf)             'put uppercased buffer to test
   end if
   ifnd = 0                                     'initialize the text-found flag
   ipos = 0                                     'initialize text-found position
   do                                        'begin loop to search/replace text
      ipos = instr(ipos + 1, ctstbuf, cprm(0))  'next text-find posn. in buffer
      if ipos then                              'matching text found in buffer!
         mid$(cfilbuf, ipos) = cprm(1)        'put replacement text into buffer
         ipos = ipos + itxtlen - 1            'move buffer pointer to next posn.
         ifnd = not 0                          'set the text-found flag to TRUE
      end if
   loop while ipos                             'loop until no more text matches
   if ifnd then                                'text match found in above loop!
      put 1, lptr, cfilbuf                   'write changed data to source file
   end if
   lptr = lptr + ibuflen - itxtlen + 1          'move file pointer to next posn.
wend

i = ifn.msgs("Process completed for: " + cfil, 5, 24, 79, 0, 1)'display message
close                                                     'close all open files
system                                              'return to operating system
