/**********************************************************************/
/* convert a PocketQuicken transaction report into a form that can be */
/* imported into lotus 123 (CDF - comma delimited format)             */
/* A.Garzotto, August 1994                                            */
/**********************************************************************/

#include<stdio.h>

/**********************************************************************/

void get(buf, p, a, b)
char *buf, *p;
int a, b;
{
   while ((a <= b) && (buf[a] <= ' ')) a++;
   while ((a <= b) && (buf[b] <= ' ')) b--;
   while (a <= b)
   {
      if (buf[a] != ',')
         *(p++) = buf[a];
      a++;
   }
   *p = '\0';
}

/**********************************************************************/

void process(buf1, buf2, buf3, fp)
char *buf1, *buf2, *buf3;
FILE *fp;
{
   char date[12];
   char spend[12];
   char receive[12];
   char balance[12];
   char payee[40];
   char memo[40];
   char categ[40];
   char num[12];

   if ((buf1[1] < '0') || (buf1[1] > '9')) return;
   if (strlen(buf1) < 79) return;
   get(buf1, spend, 45, 54);
   get(buf1, receive, 58, 67);
   if (!*spend && !*receive) return;
   get(buf1, date, 0, 4);
   get(buf1, num, 6, 11);
   get(buf1, payee, 13, 43);
   get(buf1, balance, 69, 79);
   get(buf2, memo, 13, 43);
   get(buf3, categ, 13, 43);
   fprintf(fp, "\"%s\",", date);
   if (*spend)
      fprintf(fp, "-%s,", spend);
   else
      fprintf(fp, "%s,", receive);
   fprintf(fp, "%s,\"%s\",\"%s\",\"%s\",\"%s\"\n",
           balance, payee, categ, memo, num);
}

/**********************************************************************/

void main(argc, argv)
int argc;
char *argv[];
{
   FILE *fin, *fout;
   char buf0[128], buf1[128], buf2[128];
   char *bufs[4];

   if (argc < 3)
   {
      fprintf(stderr, "Convert Pocket Quicken transaction report to CDF\n");
      fprintf(stderr, "A. Garzotto, 27-AUG-1994\n");
      fprintf(stderr, "USAGE: %s <report file> <CDF file>\n", argv[0]);
      exit(1);
   }
   fin = fopen(argv[1], "r");
   if (fin == NULL)
   {
      fprintf(stderr, "Cannot open file '%s'\n", argv[1]);
      exit(1);
   }
   fout = fopen(argv[2], "w");
   if (fout == NULL)
   {
      fprintf(stderr, "Cannot create file '%s'\n", argv[2]);
      fclose(fin);
      exit(1);
   }
   fprintf(fout, "\"Date\",\"Amount\",\"Balance\",\"Payee\",");
   fprintf(fout, "\"Category\",\"Memo\",\"Number\"\n");
   fgets(buf0, 126, fin);
   fgets(buf1, 126, fin);
   bufs[0] = buf0;
   bufs[1] = buf1;
   bufs[2] = buf2;
   while (fgets(bufs[2], 126, fin))
   {
      process(bufs[0], bufs[1], bufs[2], fout);
      bufs[3] = bufs[0];
      bufs[0] = bufs[1];
      bufs[1] = bufs[2];
      bufs[2] = bufs[3];
   } 
   fclose(fin);
   fclose(fout);
}

/**********************************************************************/
