#include  "lxapi.h"

char far *msgnull="";
char far *msgAppName="TermDemo";
char far *msgTitle="Terminal Demo";
char far *msgQuit="Quit";

int      TxLength,RxLength,RecallPtr,ComHandler;
char     RxBuffer[128],TxBuffer,EvenDummy1;

char far *RxBufferPtr=RxBuffer;
char far *TxBufferPtr=&TxBuffer;
char far *TxLengthPtr=(char *)&TxLength;
char far *RxLengthPtr=(char *)&RxLength;

ComSettings_t  ComSettings;

char far *ComSetPtr=(char *)&ComSettings;

char far **StringTable[]={
  &msgnull, &msgAppName, &msgTitle, &msgQuit, &ComSetPtr,
  &TxLengthPtr, &RxLengthPtr, &RxBufferPtr, &TxBufferPtr
};

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra ,...);
void far DoQuit(void);
int  sprintf(char *,char *,...);

EVENT_NORM  app_event;
LHAPIBLOCK  CapData;

BOOL  Done;

LHFKEY MainFKeys[]= {
  {(PLHRES)&msgQuit,(PLHFUNC)DoQuit,10+FKEY_LAST,0}
};

LHWINDOW TDateTime = {
    DateTime,0,0,0,0,
    0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP};

LHWINDOW MainTitle = {
    TitleBar,0,0,0,0,
    (PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,(PLHMENU)&TDateTime,NO_HELP};

LHWINDOW MainView={
    (PLHCLASS)MainHandler,0,0,640,190,
    (PLHRES)&msgnull,0,0,0,
    NULL,MainFKeys,NO_MENU,NO_HELP};

#if defined(TURBOC)
#define GetDataSeg()  _DS
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg()  _asm_(" mov ax,ds\n")
#endif

void FixupFarPtrs(void)
{
int i,dataseg;
#if defined(MSC)
  _asm {
    mov  ax,ds;
    mov  dataseg,ax;
    }
#else
  dataseg=GetDataSeg();
#endif
  for(i=0; i<countof(StringTable); i++)
    *(((int *)(StringTable[i]))+1) = dataseg;
}

void far DoQuit(void)
{
  Done = TRUE;
}

int far MainHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...)
{
  if(Message==DRAW)
    ClearRect(Window->x,Window->y,Window->w,Window->h);
  return SubclassMsg(Object, Window, Message, Data, Extra);
}

void ComInit(void)
{
  if(ComOpen( &ComHandler, 1 )) m_fini(); /* COM1 */
  ComSettings.Baud=12; ComSettings.Data=3;
  ComSettings.Flow=2; ComSettings.InfraRed=1;
  ComSetParameters(ComHandler, (void far *)&ComSettings);
  ComAcquire(ComHandler,1);/*Exclusive*/
}

void __int__(int no);

void ScrollUp()
{
#if defined(TURBOC)
  _BX=0x0000; _CX=0x0200; _DX=0x1650; _AX=0x0601; __int__(0x10);
#endif
#if defined(LSIC)
  _asm_(" mov ax,601h\n mov bx,0\n mov cx,200h\n mov dx,1650h\n int 10h\n");
#endif
#if defined(MSC)
  _asm {
  mov  ax,601h;
  mov  bx,0;
  mov  cx,200h;
  mov  dx,1650h;
  int  10h;
  }
#endif
}

void PutScreen(UCHAR ch)
{
static int xpos=0,ypos=16;
  if(ch==13)
    {xpos=0; return;}
  if(ch==10){
    ypos+=8;
    if(ypos==184)
      {ypos=176; ScrollUp();}
    return;}
  if(ch>=32){
    DrawChar(xpos,ypos,ch,(UINT )DRAW_NORMAL,FONT_SMALL);
    xpos+=8; if(xpos!=640) return;
    xpos=0; ypos+=8; if(ypos!=184) return;
    ypos=176; ScrollUp(); return;}
}

void main(void)
{
  m_init_app(SYSTEM_MANAGER_VERSION);
  InitializeLHAPI(&CapData);
  SetMenuFont(FONT_NORMAL);
  SetDefaultFont(FONT_NORMAL);
  FixupFarPtrs();
  m_reg_app_name(msgAppName);
  SendMsg( &MainView, CREATE, CREATE_FOCUS, 0 );
  SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );
  ComInit();
  Done = FALSE;
  while(!Done) {
    app_event.do_event = DO_EVENT;
    m_action(&app_event);
    switch(app_event.kind) {
      case E_REFRESH:
      case E_ACTIV:
        FixupFarPtrs(); ReactivateLHAPI(&CapData);
        break;
      case E_DEACT:
        DeactivateLHAPI(); break;
      case E_TERM:
        FixupFarPtrs(); Done = TRUE; break;
      case E_NONE:
        SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
        break;
      case E_KEY:
        if(app_event.data==F10KEY)
          SendMsg(GetFocus(), KEYSTROKE,app_event.data,app_event.scan);
        else {
          TxBuffer=app_event.data; TxLength=1;
          ComSendBytes(ComHandler,TxBufferPtr,1,TxLengthPtr);
        }
    }
    RxLength=128; RecallPtr=0;
    ComReceiveBytes(ComHandler,RxBufferPtr,RxLengthPtr);
    while(RxLength--)
      PutScreen(RxBuffer[RecallPtr++]);
  }
  ComRelease(ComHandler);
  ComClose(ComHandler);
  m_fini();
}
