# Makefile for Loki

# Uncomment exactly one of the following two sections.  After changing
# which one is commented out, you will have to recompile everything.
# You can ensure this recompilation by doing "erase *.obj" or "touch *.h"

# Use these for a regular version with BCD math:

COPTS = -DBCD
LOBJFILES = lbcd.obj ljaguar.obj
LPROG = loki.exe

# Use these for a system-manager compliant version (must use BCD)

# COPTS = -DSYSMGR -DBCD
# LOBJFILES = lbcd.obj smjaguar.obj
# LPROG = loki.exm

# Use these for a regular version with C floats for math:

# COPTS = -f -DFLOAT
# LOBJFILES = ljaguar.obj
# LPROG = loki.exe

# --------------------------------------------------

# In many cases, the tlink program should generate this warning message:
# "Warning: __stklen defined in module NAME.c is duplicated in module STKLEN"

PROGS = $(LPROG)

all:	$(PROGS)

LIB = lib.obj libasm.obj libres.obj xprintf.obj
SPLIB = lib libasm libres xprintf
H = lib.h

CFLAGS = -O

# --------------------------------------------------

# /v for debugging, /m->/s for detailed symbol table
LOPTS = /c/d/m

# -v for debugging
.c.obj:
	tcc $(COPTS) $*

.asm.obj:
	tasm -DNOTWIN $* /mx;

# --------------------------------------------------

loki.ri: loki.res rpage437.res rlanlen.res
	thorres -c 437 -l en -f i loki.res -h lores.h

# --------------------------------------------------

newri: loki.res rpage437.res rlanlen.res
	thorres -c 437 -l en -f i loki.res -h lores.h -new

# --------------------------------------------------
# make IBM PC version

inibmpc.ri:	loki.ri
	copy loki.ri inibmpc.ri

# --------------------------------------------------
# make Jaguar (non system manager) version

indos95.ri:	loki.res rpage850.res rlanlen.res
	thorres -c 850 -l en -f j loki.res -h lores.h -o indos95.ri

# --------------------------------------------------
# make System Manager version

insys95.ri:	loki.res rpage850.res rlanlen.res
	thorres -c 850 -l en -f s loki.res -h lores.h -o insys95.ri

# --------------------------------------------------
# make Cougar DOS version

indos100.ri:	loki.res rpage850.res rlanlen.res
	thorres -c 850 -l en -f d loki.res -h lores.h -o indos100.ri

# --------------------------------------------------
# make Cougar system manager version

insys100.ri:	loki.res rpage850.res rlanlen.res
	thorres -c 850 -l en -f c loki.res -h lores.h -o insys100.ri

# --------------------------------------------------

LH = loki.h lores.h $(H)
LCORE = larith.obj ldate.obj ldisplay.obj lfile.obj lfrac.obj lkey.obj lmisc.obj ltable.obj lterm.obj lunits.obj lxprintf.obj $(LOBJFILES)

$(LCORE):	$(LH)

loki.exe:	loki.ri loki.obj $(LCORE) $(LIB)
	tlink $(LOPTS) @loki.lnk

loki.obj:	loki.c $(LH)
	tcc -c $(CFLAGS) $(COPTS) -DMAIN loki.c

# --------------------------------------------------

loki.exm:	smloki.exe
	copy smloki.exe loki.exm
	makeexm -p loki smloki

smloki.exe:	loki.ri c0s.obj loki.obj $(LCORE) $(LIB)
	tlink $(LOPTS) @smloki.lnk

# --------------------------------------------------

$(LIB):	$(H)

# --------------------------------------------------

# Build diskettes from MS/DOS system

disk:	inibmpc.ri insys95.ri insys100.ri
	touch *.*
	copy README a:
	copy copying.doc a:
	copy filelist a:
	copy filelist.doc a:
	copy indos100.doc a:
	copy indos95.doc a:
	copy inibmpc.doc a:
	copy inibmpc.ri a:
	copy insys100.doc a:
	copy insys100.ri a:
	copy insys95.doc a:
	copy insys95.ri a:
	copy inunix.doc a:
	copy inwin.doc a:
	copy lcmdlist.doc a:
	copy lmenus.doc a:
	copy loki.doc a:
	copy loki.exe a:
	copy loki.exm a:
	copy loki.icn a:
	copy loki.ico a:
	copy loki.pif a:
	copy loki.res a:
	copy lores.h a:
	copy lrpn.doc a:
	copy lserial.doc a:
	copy lunits.doc a:
	copy resource.doc a:
	copy rlanlen.res a:
	copy rpage000.res a:
	copy rpage437.res a:
	copy rpage850.res a:
	copy rpage852.res a:
	copy rpage865.res a:
	copy rpagebeg.res a:
	copy thorres.doc a:
	copy thorres.exe a:
	copy warranty.doc a:

diskc:
	copy README.src a:\src
	copy filelist.src a:\src
	copy larith.c a:\src
	copy lbcd.c a:\src
	copy ldate.c a:\src
	copy ldisplay.c a:\src
	copy lfile.c a:\src
	copy lfrac.c a:\src
	copy ljaguar.c a:\src
	copy lkey.c a:\src
	copy lmisc.c a:\src
	copy loki.c a:\src
	copy loki.h a:\src
	copy loki.lnk a:\src
	copy lokiflt.lnk a:\src
	copy ltable.c a:\src
	copy lterm.c a:\src
	copy lunits.c a:\src
	copy lxprintf.c a:\src
	copy makefile.msd a:\src
	copy makefile.unx a:\src
	copy smjaguar.c a:\src
	copy smloki.lnk a:\src

# --------------------------------------------------

cleanup:
	-erase *.obj
	-erase *.map

cleanall:
	-erase *.obj
	-erase *.map
	-erase *.env
	-erase *.exe
	-erase *.exm
	-erase *.ri

fromfreyja:
	-copy g:\src\f23\c0s.asm .
	-copy g:\src\f23\lib.c .
	-copy g:\src\f23\lib.h .
	-copy g:\src\f23\libasm.asm .
	-copy g:\src\f23\libres.c .
	-copy g:\src\f23\makeexm.exe .
	-copy g:\src\f23\sysmgr.h .
	-copy g:\src\f23\thorres.exe .
	-copy g:\src\f23\turboc.cfg .
	-copy g:\src\f23\xprintf.c .

