#include<stdlib.h>
#include<stdio.h>

#define TYPE_PASSWD 1	/* Undocumented... */

#define SKIP(f, n) fseek((f), (n), SEEK_CUR)

int main(int argc, char *argv[]){
	FILE *f;
	long offset=4;			/* Position of first field */
	int found=0, i;
	char c, password[17],	/* Password length <= 16 chars */
		*not_so_secret=		/* "Secret" key */
		"\xe1\xa8\xf7\x14\x0b\xc5\x49\x42\xac\x73\xfa\xa9\x78\xdd\x48\x6d",
		*padding_data=		/* "Secret" padding data */
		"\xff\x13\x72\x4f\x7f\x22\x40\x37\x7e\x18\x65\x2d\x55\x47\x77\x68";

	if(argc!=2){
		fprintf(stderr,"Usage: hpcrack <filename>\n");
		exit(1);
	}

	/* Open file */
	f=fopen(argv[1], "rb");
	if(f==NULL){
		fprintf(stderr, "Can't open file \"%s\".\n", argv[1]);
		exit(2);
	}

	/* Look up password field */
	while(!feof(f) && !found){
		fseek(f, offset, SEEK_CUR);		/* Go to next field */
		found=(fgetc(f)==TYPE_PASSWD);	/* Determine field type */
		SKIP(f, 1);						/* Skip 1 character */
		c=fgetc(f);						/* Determine field length: */
		offset=(((unsigned)(0xff&fgetc(f))<<8)|(unsigned)(0xff&c))-4;
	}
	SKIP(f, 2);	/* Skip 2 characters */

	if(found)
		/* Decode password */
		for(i=0; i<16; i++)
			password[i]=fgetc(f)^not_so_secret[i];
	else{
		fprintf(stderr, "No password found...\n");
		exit(3);
	}

	/* Remove padding data */
	password[16]='\0';
	for(i=15; password[i]==padding_data[i]; i--)
		password[i]='\0';

	/* Make control characters readable */
	for(; i>=0; i--)
		if(password[i]<0x20)
			password[i]^=0x80;

	/* Print decoded password */
	printf("Password (without quotes): \"%s\"\n", password);

	return 0;
}


