; emmtask.asm - task monitor
; Copyright(C) 1994 Hiroyuki Sekiya


		IDEAL
		INCLUDE "emm200.inc"
		INCLUDE "emmmem.h"
		INCLUDE "emmtask.h"


; memory control block
STRUC _mcb
  mark		DB	?
  owner		DW	?
  size		DW	?
  reserve	DB	3 DUP (?)
  pname		DB	8 DUP (?)
ENDS


SEGMENT		_DEVDAT

in_sysmgr	DB	0		; 0=DOS, 1=VX}l

ENDS		_DEVDAT


SEGMENT		_DEVBSS

dos_map		DW	8 DUP (?)	; DOSł̃̃}bv
sys_map		DW	8 DUP (?)	; VX}lł̃̃}bv
current_psp	_fp	?

ENDS		_DEVBSS


SEGMENT		_DEV

; VX}lPSPǂ̔
; ->	bx	PSP
; <-	zr	VX}l
;	nz	Ⴄ
; ><	--
		EVEN
PROC		is_sysmgr_psp
		push	ds
		dec	bx
		mov	ds, bx
		inc	bx
		cmp	[(_mcb ds:0).owner], bx
		jne	@@exit
		cmp	[WORD (_mcb ds:0).pname], '02'
		je	@@1
		cmp	[WORD (_mcb ds:0).pname], '01'
		jne	@@exit
	@@1:
		cmp	[WORD (_mcb ds:2).pname], '0'
	@@exit:
		pop	ds
		ret
ENDP

		EVEN
PROC		is_in_sysmgr
		pushm	bx, ds
		lds	bx, [cs:current_psp.fp]
		mov	bx, [ds:bx]
		call	is_sysmgr_psp
		popm	ds, bx
		ret
ENDP

; int 21htbNă^XN؂芷Ď
		EVEN
PROC		int21h	FAR
		pushf
		cmp	ah, 50h
		je	@@func50
		cmp	ah, 4Ch
		je	@@func4C
	@@jmpold:
		popf
		DB	0EAh		; jmp xxxx:xxxx
old21h		_fp	?

	@@func4C:
		mov	[cs:in_sysmgr], 0
		jmp	@@jmpold

	@@func50:
		cld

	; ROMĂяoĂ邩H
		push	bp
		mov	bp, sp
		cmp	[WORD bp+6], 0F000h
		pop	bp
		jb	@@jmpold

	; VX}lւ̃^XNXCb`H
		call	is_sysmgr_psp
		je	@@to_sys

	; VX}lDOSւ̃^XNXCb`
	@@to_dos:
		cmp	[cs:in_sysmgr], 1
		jne	@@jmpold

		pushm	di, es
		movseg	es, cs
		mov	di, OFFSET sys_map
		call	save_map_reg
		popm	es, di

		call	[cs:old21h.fp]
		pushf

		pushm	si, ds
		movseg	ds, cs
		mov	si, OFFSET dos_map
		call	restore_map_reg
		popm	ds, si
		jmp	@@done

	; DOSVX}lւ̃^XNXCb`
	@@to_sys:
		cmp	[cs:in_sysmgr], 0
		jne	@@jmpold

		pushm	di, es
		movseg	es, cs
		mov	di, OFFSET dos_map
		call	save_map_reg
		popm	es, di

		call	[cs:old21h.fp]
		pushf

		pushm	si, ds
		movseg	ds, cs
		mov	si, OFFSET sys_map
		call	restore_map_reg
		popm	ds, si

	@@done:
		xor	[cs:in_sysmgr], 1
		popf
		sti
		retf	2
ENDP

ENDS		_DEV


SEGMENT		_TEXT

; ^XNj^
		EVEN
PROC		init_task_mon
		pushm	ax, bx, dx, di, es

		movseg	es, cs
		mov	di, OFFSET dos_map
		call	save_map_reg

		mov	ax, 3521h
		int	21h		; get vector
		mov	[old21h.seg], es
		mov	[old21h.ofs], bx

		mov	dx, OFFSET int21h
		mov	ax, 2521h
		int	21h		; set vector

		push	ds
		mov	ax, 5D06h
		int	21h
		mov	ax, ds
		pop	ds
		mov	[current_psp.seg], ax
		add	si, 10h
		mov	[current_psp.ofs], si

		popm	es, di, dx, bx, ax
		ret
ENDP

ENDS		_TEXT

		END
