/* rtf.c  - Part of dox.c */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dox.h"

#define RTF_ESCAPED 4

char *rtf_style[MAXSTYLES] = {"{\\rtf1\\ansi","\\par", "", "\\q","\\plain","\\fonttbl","\\f",
	"\\b","\\i","\\ul"};

char *rtf_escape[RTF_ESCAPED] = {"\\\\", "\\{", "\\}", "\\;"};
char *rtf_normal[RTF_ESCAPED] = {"\\", "{", "}", ";"};

void rtf_readword(FILE *instream, char *word);
void rtf_paragraph(state_type *state, char *word);

void rtf_convert(state_type *state)
{
char word[81];
short count;

default_style(state, TRUE);
update_style(state);
fgetc(state->in);

while (!feof(state->in))
	{
        rtf_readword(state->in, word);
        switch(word[0])
		{
		case '{':
		case '}':
			break;

		case '\\':
                        rtf_paragraph(state, word);
				/*Also changes style info. */
			break;

		case '\r':
		case '\n':
                        update_style(state);
			break;

		case ' ':
                        update_style(state);
                        fprintf(state->out, " ");
			break;

		default:
                        update_style(state);
                        output(state, word);
                        break;
		}
	}

state->new[st_begin]=FALSE;
update_style(state);
}


void rtf_paragraph(state_type *state, char *word)
{
unsigned wordlen;
unsigned count;
char *found_style=NULL;

/* Get rid of space if present */
wordlen = strlen(word);
if (word[wordlen-1]==' ')
	word[wordlen-1]='\0';

/* Output escape characters. */
if (((found_style=strchr("\\{}", word[1]))!=NULL))
	{
        word[0] = word[2];
        word[1] = '\0';
        output(state, word);
        return;
      	}



/* Search for code in rtf array. */
for (count=1;count<MAXSTYLES;count++)
        if (((found_style=strstr(word, rtf_style[count]))==word))
		break;
     

if (found_style==NULL)
	return;


switch(count)
	{
	case st_break:
		if (word[4]!='d')
                        state->new[count]++;
		break;

	case st_normal:
                default_style(state, FALSE);
		break;

	case st_fonttable:
                while ((!feof(state->in))&&(word[0]!='}'))
                        rtf_readword(state->in, word);
		break;

	case st_centre:
		if (word[2]=='c')
                        state->new[st_centre]=TRUE;
                else state->new[st_centre]=FALSE;
		break;

	case st_fontsize:
                if (state->font_sensitive)
			if (word[2]=='s')
                                state->new[st_fontsize] = atoi(word+3)/2;
                        else state->new[st_fontsize] = 0;
		break;

	default:
                state->new[count]=TRUE;
	}
}



void rtf_update_style(state_type *state)
{
unsigned count, count2, startover;


/* Put in breaks. */
for(;state->new[st_break]>0;state->new[st_break]--)
        fprintf(state->out, "%s\n", rtf_style[st_break]);

state->current[st_break] = state->new[st_break];

startover = FALSE;

/* If at the end of the file declare end of rtf. */
if ((!state->new[st_begin])&&(state->current[st_begin]))
        {
        state->current[st_begin]=FALSE;
        fprintf(state->out, "}");
        return;
        }


if ((!state->new[st_centre])&&state->current[st_centre])
        {
        state->current[st_centre] = FALSE;
        fprintf(state->out, "%sl ", rtf_style[st_centre]);
        }

/* Turn off the necessary styles. */
for (count=0;count<MAXSTYLES;count++)
        if ((!state->new[count])&&(state->current[count]))
                {
                startover = TRUE;
                state->current[count] = FALSE;
                }

if (startover)
        {
        fprintf(state->out, "%s ", rtf_style[st_normal]);
        for (count=PRESERVED;count<MAXSTYLES;count++)
                state->current[count] = FALSE;
        }

/* Change font sizes */
if ((state->new[st_fontsize]!=state->current[st_fontsize])&&state->new[st_fontsize])
	{
        if (state->current[st_fontsize])
                fprintf(state->out, "%s", rtf_style[st_fontsize]);
        fprintf(state->out, "%s%i ", rtf_style[st_fontsize], state->new[st_fontsize]/4);
        state->current[st_fontsize] = state->new[st_fontsize];
	}

if (state->new[st_centre]&&(!state->current[st_centre]))
        {
        state->current[st_centre] = FALSE;
        fprintf(state->out, "%sc ", rtf_style[st_centre]);
        }

/* Switch on the necessary styles. */
for (count=0;count<MAXSTYLES;count++)
        if ((state->new[count])&&(!state->current[count]))
		{
                state->current[count]=TRUE;
                fprintf(state->out, "%s ", rtf_style[count]);
                }


}



void rtf_output(state_type *state, char *word)
{
unsigned count, count2, done;

for (count=0;count<strlen(word);count++)
                {
                done = FALSE;
                for (count2=0;((count2<RTF_ESCAPED)&&(!done));count2++)
                        if (word[count]==rtf_normal[count2][0])
                                {
                                fprintf(state->out, "%s", rtf_escape[count2]);
                                done = TRUE;
                                }
                if (!done)
                        fprintf(state->out, "%c", word[count]);
                }

}


void rtf_readword(FILE *instream, char *word)
{
unsigned c;
unsigned count=0;
unsigned done=FALSE;

while ((count<80)&&(!done)&&(!feof(instream)))
	{
        word[count] = fgetc(instream);
	done=(strrchr("\r\n\t{}; ", word[count])!=NULL);
	count++;

	c = nextchar(instream);
	done=((strrchr("\r\n\t{};\\ ",c)!=NULL)||done);
	if ((c==' ')||(c==';'))
		{
                word[count] = fgetc(instream);
		count++;
		}
	}

word[count]='\0';
}

