'/* TFIND.H  27.04.2001 */

type tfnd                              'pass-structure for text-search function
   buflen as integer                  'main file buffer length (typically cbuf)
   txtlen as integer                 'searchtext string length (typically ctxt)
   bbeg as integer                   'begin byte in file buffer for text search
   burp as integer                'EOF warning flag (valid only if wrap = TRUE)
   chr1 as integer                'when nosp = TRUE, handle same as <= ASCII 32
   chr2 as integer                'when nosp = TRUE, handle same as <= ASCII 32
   csen as integer               'case-sensitivity flag (TRUE = case sensitive)
   fnum as integer               'file channel/unit number for binary-mode file
   lcnt as integer              'OK to count text lines if TRUE and NOT tf.wrap
   llen as integer              'maximum length of a text line in the text file
   load as integer              'load initial buffer at fbeg position when TRUE
   lsav as integer              'saved line length when c/r not found in buffer
   nosp as integer         'eliminate spaces in file buffer for search purposes
   wrap as integer       'wraparound search flag (terminate at fbeg + bbeg - 1)
   wwrd as integer       'whole word search flag (substring match is not valid)
   fbeg as long       'begin byte in file corresponding to begin byte of buffer
   llof as long                  'length of the binary-mode file to be searched
   ltot as long                         '#text lines between bbeg and text find
end type

declare function ifn.tfnd(tf as tfnd, cbuf, ctxt)
declare function ifn.tfnd.load(tf as tfnd, cbuf, ltmp, icas)
declare function ifn.tfnd.nosp(tf as tfnd, cbuf, ctxt)
declare function ifn.tfnd.wwrd(tf as tfnd, cbuf, ctxt, ipos)

common shared cwrdchr           'share valid word characters with all functions
