'/* GETLINE.BAS  28.10.1999 */
'/*
'/*  IN: cbuf - buffer for loading text data in binary file mode
'/*      lptr - current text load position (s/b 1 on first call)
'/*      ifil - DOS/BASIC file handle (opened by calling program)
'/*      imty - OK to return empty ("null") text lines when TRUE
'/*      ieof - current EOF status [initialized to 0 all calls]
'/*
'/* OUT: clin - text line from file (poss. empty if imty = TRUE)
'/*      lptr - load position for next line following this line
'/*      ieof - TRUE if current line is final text line in file

function ifn.getline(cbuf, clin, lptr, ifil, imty, ieof) 'load text line f/file
   llof = lof(ifil)                               'final char. position in file
   ilen = len(cbuf)                               'length of binary file buffer
   ieof = 0                                        'initialize end-of-file flag
   do                                              'loop in event line is blank
      get ifil, lptr, cbuf                        'load buffer from binary file
      lspn = lptr + ilen - llof - 1               'test if buffer is beyond EOF
      if lspn > ilen then                          'EOF overlap > buffer length
         lspn = ilen                               'set EOF overlap==buffer len.
      end if
      if lspn > 0 then                            'file buffer spans beyond EOF
         mid$(cbuf, ilen - lspn + 1) = string$(lspn, 0) 'fill buffer with NULLs
      end if
      ipos1 = instr(cbuf, char(13))               'find carriage-return in line
      ipos2 = instr(cbuf, char(10))               'find line-feed char. in line
      if ipos1 = 0 and ipos2 = 0 then              'neither term. found in line
         if instr(cbuf, char(26)) then             'line terminator is EOF byte
            ipos2 = instr(cbuf, char(26))           'set line-term. to EOF posn.
         elseif instr(cbuf, char(0)) then         'line terminator is NULL byte
            ipos2 = instr(cbuf, char(0))           'set line-term. to NULL posn.
         else                                    'no line terminators available
            ipos2 = istr.lcfn((ilen \ 3) * 2, cbuf, " ") 'end posn.= blank posn.
         end if
      elseif ipos1 > 0 and ipos1 < ipos2 or ipos2 = 0 then'c/r comes before l/f
         ipos2 = ipos1                              'set line-term. to c/r posn.
      end if
      clin = ""                               'deallocate the line buffer first
      clin = left$(cbuf, ipos2 - 1)            'extract line from binary buffer
      if ipos2 <= ilen then                  'find the next line begin position
         iprv = midchar(cbuf, ipos2)          'get character @previous position
         if not(iprv = 26 or iprv = 0) then   'prev. character NOT a terminator
            ipos2 = ipos2 + 1                  'move position past current term.
            if ipos2 <= ilen and iprv <> 32 then'current position within buffer
               ichr = midchar(cbuf, ipos2)   'get character at current position
               if (ichr = 13 or ichr = 10) and ichr <> iprv then'terminator pair
                  ipos2 = ipos2 + 1         'move position past terminator pair
               end if
            end if            'Note use of mid$() instead of midchar() below...
         end if               '......ipos2 may be beyond current length of cbuf
      end if
      lptr = lptr + ipos2 - 1               'move pointer to next load position
      if ipos2 <= ilen then                'end character posn.is within buffer
         ichr = midchar(cbuf, ipos2)       'get char. at text line end position
      else                                'end character posn.NOT within buffer
         ichr = 32                          'set end character to a dummy value
      end if
      if lptr > llof or ichr = 26 or ichr = 0 then    'we're now at end-of-file
         ieof = not 0                              'set the end-of-file flag ON
      end if
   loop while clin = "" and (not(imty or ieof))  'OK to look for non-blank line
end function
