NAME	LNCSMPL
TITLE	Sample Launcher Aware Program
;
;Copyright (C) 1993 WordPerfect Corp., All Rights Reserved
;------------------------------------------------------------
;segments:	cs = _TEXT
;		ds = _DATA
;		es = _DATA

.model	large				;set program to the large model

include lcdef.inc

; The following is the Launcher interface functions.  They all need to be
; declared as far routines to the program.

extrn	lnc_chk_f:far		;Check if Launcher present
extrn	lnc_reg_f:far		;Register with Launcher
extrn	lnc_sld_f:far		;Load/Swap to program (Clear ld_flag first)
extrn	lnc_slf_f:far		;Load/Swap to program (Don't clear ld_flag)
extrn	lnc_prv_f:far		;Load/Swap to program (private launch)
extrn	lnc_xcl_f:far		;Load/Swap to program (exclusive launch)
extrn	lnc_stm_f:far		;Set Launcher menu name (PoC only)
extrn	lnc_gtm_f:far		;Get Launcher menu name (Any program)
extrn	lnc_stp_f:far		;Set the Launcher PoC description (Any program)
extrn	lnc_gtp_f:far		;Get the Launcher PoC description (PoC only)
extrn	lnc_cap_f:far		;Get Active Program list (running or swapped)
extrn	lnc_eld_f:far		;Get Active External Launcher Device list
extrn	lnc_rqx_f:far		;Request permission to exit
extrn	lnc_exc_f:far		;Launcher not loaded. Load with Launcher
extrn	lnc_mdf_f:far		;Begin Macro define feature
extrn	lnc_mex_f:far		;Begin Macro play feature
extrn	lnc_mds_f:far		;Stop Macro define feature
extrn	lnc_dio_f:far		;Enable/Disable Macro support
extrn	lnc_crd_f:far		;Clipboard Read function
extrn	lnc_cwr_f:far		;Clipboard Write function
extrn	lnc_cpd_f:far		;Clipboard Append function
extrn	lnc_cfm_f:far		;Clipboard Format Check function
extrn	lnc_crn_f:far		;Get current Clipboard name/number
extrn	lnc_csn_f:far		;Set new current Clipboard name/number
extrn	lnc_hks_f:far		;Enable/Disable Hot Key support (All programs)
extrn	lnc_hku_f:far		;Enable/Disable Hot Key support (User Programs)
extrn	lnc_lst_f:far		;Get the Last Active Program UMID
extrn	lc_scmd_f:far		;Launcher function call
.data				;defines the data segment

extrn cmdblk:byte
extrn lnchpid:word

public mypsp
public wp
public nullstr

mypsp		dw 0
wpumid		dw 21h
wphk		dw 1100h
curstyp		dw 0
curspos		dw 0
rpinfo		dw 0
wppid		dw 0
attrib		db 0
listbuf		dw 90 dup (0)
wpname		db "WordPerfect 6.0", 0
smplname	db "Launcher Sample Application", 0
nolaunch	db "Launcher not loaded, exiting and reloading with Launcher", 0
errexit		db "Launcher not found, exiting program", 0
wperexit	db "WordPerfect not found, exiting program", 0
swapmsg		db "Launcher has swapped back after loading WordPerfect", 0
menustr		db "Launcher Sample Main Menu", 0Ah, 0Dh, 0Ah, 0Dh
		db "1.  Load/Swap WordPerfect 6.0", 0Ah, 0Dh
		db "2.  Show Resident Program list", 0Ah, 0Dh
		db "3.  Turn off Hot Key support", 0Ah, 0Dh
		db "4.  Turn on Hot Key support", 0Ah, 0Dh
		db "5.  Exit Launcher Sample program", 0Ah, 0Dh, 0Ah, 0Dh
		db "Selection: ", 0
reslist		db "Resident Program List", 0Ah, 0Dh, 0Ah, 0Dh
		db "Currently resident programs are:", 0Ah, 0Dh, 0
pausekey	db "Press any key to continue...", 0
wrongkey	db "Invalid selection.  Please choose 1-5.  (Press any key to continue)", 0
wp		db "WP.EXE", 0
nullstr		db 0, 0
.stack	100h				;defines the stack segment
.code					;defines the code segment

start	proc	far
	mov	ax, _DATA		;set up data segment register
	mov	ds, ax
	mov	mypsp, es		;set mypsp to programs's psp
	push	ds
	pop	es			;set editseg to dataseg
	mov	ah, 8			;get current text attribute
	xor	bh, bh
	int	10h
	mov	attrib, ah
	call	lnc_chk_f		;check if Launcher is loaded
	je	strt10
	mov	si, offset nolaunch	;Display message that Launcher not loaded
	call	otstr
	call	crlf
	xor	ax, ax
	call	lnc_exc_f		;Launcher not loaded, load Launcher (LNCSMPL.COM)
strt10:	call	register		;Register LNCSMPL with Launcher	
	jc	erexit
strt20:	call	drawmnu			;display the LNCSMPL menu screen
	call	getitem			;get menu choice from user
	jnc	strt30
strt25:	call	crlf
	mov	si, offset wrongkey	;display invalid key message
	call	otstr
	mov	ah, 1			;press any key to continue
	int	21h
	jmp	strt20
strt30:	cmp	ax, "5"			;check if exit was pressed
	ja	strt25			;no, but an invalid key was
	je	strt40			;5 was pressed, exit programs
	call	switch			;1-4 was pressed, invoke function
	jmp	strt20
strt40:	mov	cmdblk.lc_func, lc_xall	;tell all programs to exit
	mov	cmdblk.st_cnt, xa_save	;save any changes
	call	lc_scmd_f		;call Launcher
	jmp	exit
erexit:	mov	si, offset errexit	;Launcher not found, exit program
	call	otstr
	call	crlf
	jmp	exit
wperr:	mov	si, offset wperexit	;WordPerfect not found, exit program
	call	otstr
	call	crlf
exit:	mov	ax, 0			;exit the sample program
	mov	ah, 4Ch
	int	21h
start	endp
;proc:	Register
;desc:	register with Launcher w/o a state routine defined
;in:	none
;out:	lnchpid = Launcher PID for this program
;notes: none
;
public	register
register	proc	near
	push	es
	push	cs
	pop	es
	mov	di, -1			;no state routine
	call	lnc_reg_f		;register with Launcher
	pop	es
	ret
register	endp
;proc:	Otstr
;desc:	output the null terminated string found at ds:si to screen
;in:	si is the offset of the string, ds must point to segment of string
;out:	none
;notes:	none
;
public otstr
otstr	proc	near
	push	ax
	push	dx
	push	si
	mov	ah, 2
ostr10:	lodsb
	or	al, al
	jz	ostr20
	mov	dl, al
	int	21h
	jmp	ostr10
ostr20:	pop	si
	pop	dx
	pop	ax
	ret
otstr	endp
;proc:	Crlf
;desc:	Output a carriage return, line feed to the screen
;in:	none
;out:	none
;notes:	none
;
public crlf
crlf	proc	near
	push	ax
	push	dx
	mov	ah, 2
	mov	dl, 0ah
	int	21h
	mov	ah, 2
	mov	dl, 0dh
	int	21h
	pop	dx
	pop	ax
	ret
crlf	endp
;proc:	Loadwp
;desc:	Load WordPerfect 6.0 using the Launcher interface routine
;in:	none
;out:	none
;notes:	This routine sets up the needed information for the lnc_slf_f call
;
public loadwp
loadwp	proc	near
	push	ax
	push	bx
	push	cx
	push	dx
	push	di
	push	si
	push	ds
	pop	es				;set extraseg to dataseg
	mov	ah, 3
	xor	bh, bh
	int	10h
	mov	curstyp, cx			;save the cursor type
	mov	curspos, dx			;save the cursor position
	mov	bx, offset nullstr		;set bx to null for macro dir offset
	mov	ax, seg nullstr			;set ax to null for macro dir segment
	mov	word ptr cmdblk.ld_macd, bx	;set all macro dirs to null
	mov	word ptr cmdblk.ld_macd[2], ax
	mov	word ptr cmdblk.ld_eolm, bx
	mov	word ptr cmdblk.ld_eolm[2], ax
	mov	word ptr cmdblk.ld_gosh, bx
	mov	word ptr cmdblk.ld_gosh[2], ax
	mov	word ptr cmdblk.ld_rtsh, bx
	mov	word ptr cmdblk.ld_rtsh[2], ax
	mov	cx, 0				;don't change macro directories
	mov	bx, offset wp			;assign program name
	mov	si, offset nullstr		;assign	command line
	mov	di, offset nullstr		;assign default directory
	mov	ax, wpumid			;set UMID for WP (must be > 20h)
	mov 	dx, wphk			;set hot key to ALT-CTRL-W
	mov	cmdblk.ld_flag, ?ld_res		;set flag to load WP 6.0 resident
	call	lnc_slf_f			;call Launcher to load WP
	mov	ah, 2				;restore cursor position
	xor	bh, bh
  	mov	dx, curspos
	int	10h
	mov	ah, 1				;restore cursor type
	mov	cx, curstyp
	int	10h
	pop	si
	pop	di
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
loadwp	endp
;proc:	Drawmnu
;desc:	Output the main menu screen to the screen
;in:	none
;out:	none
;notes:	none
;
public drawmnu
drawmnu	proc	near
	push	ax
	push	bx
	push	dx
	push	si
	call	clrscr
	mov	si, offset menustr	;get menu
	call	otstr
	pop	si
	pop	dx
	pop	bx
	pop	ax
	ret
drawmnu	endp
;proc:	Clrscr
;desc:	Clears the screen
;in:	none
;out:	none
;notes:	none
;
public clrscr
clrscr	proc	near
	push	ax
	push	bx
	push	cx
	push	dx
	mov	ah, 7			;init window and clear screen
	xor	al, al
	mov	bh, attrib
	xor	cx, cx
	mov	dh, 24d
	mov	dl, 79d
	int	10h
	mov	ah, 2			;call set cursor position BIOS function
	xor	bx, bx			;set cursor on page 0
	xor	dx, dx			;set cursor at top of window
	int	10h
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	ret
clrscr	endp
;proc:	Getitem
;desc:	Gets the user's menu choice
;in:	none
;out:	AX (specifically AL, AH = 0) contains the ASCII character code selected
;notes:	none
;
public getitem
getitem	proc	near
	mov	ah, 1
	int	21h
	xor	ah, ah
	cmp	ax, 0			;extended ASCII value?
	ja	rtnval			;if not then return
	mov	ah, 1			;else clear out extended code
	int	21h
	stc				;and set carry flag
rtnval:	ret
getitem	endp
;proc:	Switch
;desc:	Switches to the main menu function defined in AX
;in:	AX = ASCII character code of option selected
;out:	none
;notes:	This function will call the function associated with the menu option
;
public switch
switch	proc	near
	cmp	ax, "1"
	je	lswp
	cmp	ax, "2"
	je	getrpl
	cmp	ax, "3"
	je	hkoff
	call	hkson
	jmp	swt10
lswp:	call	swapwp
	jmp	swt10
getrpl:	call	getresp
	jmp	swt10
hkoff:	call	hksoff
	jmp	swt10
swt10:	ret
switch	endp
;proc:	Swapwp
;desc:	Swap to WordPerfect if loaded, Load WordPerfect if not loaded
;in:	none
;out:	none
;notes:	none
;
public swapwp
swapwp	proc	near
	mov	rpinfo, 1			;set internal proc wants info
	call	getresp				;get current resident programs
	cmp	bx, 2				;are there two running?
	je	swp10
	call	loadwp				;if not then load WordPerfect
	jnc	swp90				;loaded OK, exit routine
	jmp	wperr
swp10:	mov	ax, wpumid			;else swap to WordPerfect
	call	lnc_sld_f
swp90:	ret
swapwp	endp
;proc:	Getresp
;desc:	Get information about the resident programs (running or swapped)
;in:	rpinfo = 1, another routine is checking resident program status
;out:	none
;notes:	This routine returns a 3 word wide list for each resident program
;	The buffer is pointed at by ds:si.
;
public getresp
getresp	proc	near
	push	word ptr cmdblk.ld_path		;save these, they get overwritten
	push	word ptr cmdblk.ld_path[2]
	mov	si, offset listbuf		;setup resident list buffer
	call	lnc_cap_f			;call to get resident programs
	jc	gtrp10				;on error quit
	mov	bx, cmdblk.st_cnt		;contains # of programs res.	
	cmp	rpinfo, 1			;internal proc want info?
	je	gtrp10				;then return info, don't print
	call	clrscr
	mov	si, offset reslist		;print out the list
	call	otstr
	mov	di, 0
lp1:	cmp	bx, 0
	je	lstdn
	mov	ax, listbuf[di]			;point at the UMID field
	cmp	ax, wpumid			;is it WP?
	je	wpfnd
	cmp	ax, PoCumid			;or the Sample App?
	je	smplfnd
wpfnd:	mov	si, offset wpname
	call	otstr
	call	crlf
	dec	bx				;decrement the # of programs
	add	di, 6				;move to next UMID field
	jmp	lp1	
smplfnd:mov	si, offset smplname
	call	otstr
	call	crlf
	dec	bx
	add	di, 6
	jmp	lp1
lstdn:	call	crlf
	mov	si, offset pausekey		;wait for keystroke
	call	otstr
	mov	ah, 8
	int	21h
gtrp10:	mov	rpinfo, 0
	pop	word ptr cmdblk.ld_path[2]
	pop	word ptr cmdblk.ld_path
	ret
getresp	endp
;proc:	Hkson
;desc:	Turns on the hot key support for WordPerfect and the Sample Application
;in:	none
;out:	none
;notes:	none
;
public hkson
hkson	proc	near
	mov	ax, 0				;AX=0, then turn on hot keys
	call	lnc_hks_f			;call to change hot key flag
	ret
hkson	endp
;proc:	Hksoff
;desc:	Turns off the hot key support for WordPerfect and the Sample Application
;in:	none
;out:	none
;notes:	none
;
public hksoff
hksoff	proc	near
	mov	ax, 1				;AX=1, then turn off hot keys
	call	lnc_hks_f			;call to change hot key flag
	ret
hksoff	endp
;proc:	Scopy_f
;desc:	Copies an asciiz string
;in:	ds:si - source string pointer
;	es:di - destination string pointer
;out:	di - points at the trailing null which was copied
;notes:	This funtion is required by the Launcher interface
;
public scopy_f
scopy_f	proc	far
	push	ax
	push	si
	cld
scp10:	lodsb
	stosb
	or	al, al
	jnz	scp10
	dec	di
	pop	si
	pop	ax
	ret
scopy_f	endp
;proc:	Fndlnc_f
;desc:	Called by LAUNCH.ASM to find a file
;in:	ds:si - file name to find
;out:	ds:si - full path\filename of file
;notes:	This function is called by lnc_exc_f to find a file.  This routine
;	is not implemented here but must be present for Launcher to work
;	properly.  How this function is implemented is up to the developer.
;
public fndlnc_f
fndlnc_f	proc	far
	ret
fndlnc_f	endp
;proc:	Lnclean_f
;desc:	Clean up for exit from memory
;in:	
;out:
;notes:	This function is called by lnc_exc_f to clean memory when reloading
;	Launcher with this program.  This routine is not implemented here but
;	must be present for Launcher to work properly.  How this function is
;	implemented is up to the developer and the needs of the program.
;
public lnclean_f
lnclean_f	proc	far
	ret
lnclean_f	endp
	end	start
