Name	Launch
Title	Launcher Interface module
;
;  Copyright (C) 1992, 1993 WordPerfect Corp., All Rights Reserved
;------------------------------------------------------------
; Launcher Interface module.  Should be generic enough for most programs to
; plug in directly with no modification.  Includes routine to remove 
; entire program from memory and reload on top of launcher with same cmd line
; parameters.  Leaves behind 300 - 400 byte stub (not including environment),
; but guarantees that program will be run from launcher - if desired.
; ASSUMPTIONS:	(only used by LNC_EXC)
;		SCOPY_F  - copies null terminated string from DS:SI to ES:DI
;		FNDLNC_F - DS:SI = filename to find
;			    if successful (JNC), DS:SI = found path\filename
;			    DS can NOT be changed, SI must change - if found
;		LNCLEAN_F - far routine to clean up any open files, cach, or
;			    allocated resources.  Only called if we are going
;			    to remove current program and reload it after
;			    launcher.
;	EXTRN	MYPSP:WORD  (programs PSP)
;
;segments:	cs = _TEXT
;		ds = _DATA
;		es = 

include	lcdef.inc

;The following functions must be provided for in the users program.  Launcher
;will make calls to these functions if the LNC_EXC_F call is made.  Currently
;the interface requires these programs to exist.  If LNC_EXC_F is not used
;the functions may return without doing anything.

extrn	fndlnc_f:far
extrn	scopy_f:far
extrn	lnclean_f:far
	.data				;data segment

extrn	mypsp:word

public	lnchpid,cmdblk,lnchflg,lnchuid
lnchpid	dw -1				;ID returned by the Launcher
lnchflg	dw 0				;Flags returned by the Launcher
cmdblk	cmd_load <>			;Structure defined in LCDEF.INC
lnchuid	dw 0				;Umid of program registered
	.code				;code segment

;lnc_sld_f
;desc:	Switch to specified program if resident, otherwise try and load it
;in:	LNCHPID = Launcher assigned PID
;	AX = UMID (Unique Menu ID) of program to load
;	DX = Hot-Key
;	CX = macro dirs flag
;		0: already set
;	non-zero : set all null strings (ld_macd, ld_eolm, ld_gosh, ld_rtsh)
;	ES:BX = Program's full path\name
;	ES:SI = Command line parameters to be passed (must have extra word)
;	ES:DI = Default directory (to be CD'd to before EXEC'ing)
;out:	
;ret:	JC = couldn't load the program
;	  cmdblk.lc_err = AX = error code
;	JNC = program was successfully loaded and has exited, or swapped back
;type:	
;notes:	AX (UMID) must always be valid.  If the program is already resident
;	(swapping to an active program) none of the other parameters are
;	necessary (may be left blank).
;
public	lnc_sld_f,lnc_slf_f
lnc_sld_f	proc	far
	mov	cmdblk.ld_flag, 0
lnc_slf_f	label	far		;doesn't clear flags first
lsld00:	push	si
	mov	cmdblk.ld_umid, ax	;set the UMID
	mov	cmdblk.lc_func, lc_load	;Load function
	mov	cmdblk.ld_hotk, dx	;and set the hot key
	mov	word ptr cmdblk.ld_path, bx
	mov	word ptr cmdblk.ld_path[2], es
	mov	word ptr cmdblk.ld_parm, si
	mov	word ptr cmdblk.ld_parm[2], es
	mov	word ptr cmdblk.ld_ddir, di
	mov	word ptr cmdblk.ld_ddir[2], es
	jcxz	lsld30			;should we set macro directories?
	mov	ax, @data		;dataseg		;  yes
	mov	cx, offset lnchpid+1	;high byte is always 0 - NULL string
	mov	word ptr cmdblk.ld_macd, cx
	mov	word ptr cmdblk.ld_macd[2], ax
	mov	word ptr cmdblk.ld_eolm, cx
	mov	word ptr cmdblk.ld_eolm[2], ax
	mov	word ptr cmdblk.ld_gosh, cx
	mov	word ptr cmdblk.ld_gosh[2], ax
	mov	word ptr cmdblk.ld_rtsh, cx
	mov	word ptr cmdblk.ld_rtsh[2], ax
lsld30:	call	lc_scmd
	pop	si
	ret
lnc_sld_f	endp

;lnc_prv
;desc:	Launch a PRIVATE program - non-exclusive
;in:	same as LNC_SLD
;out:	same as LNC_SLD
;ret:	same as LNC_SLD
;type:	
;notes:	This program is not found on the menu and can't be accessed from any
;	other programs RUN menu.  However, if assigned, Hot-Keys are active.
;
public	lnc_prv_f
lnc_prv_f	label	near
	mov	cmdblk.ld_flag, ?ld_prv
	jmp	short lsld00

;lnc_xcl_f
;desc:	Launch and EXCLUSIVE PRIVATE program
;in:	same as LNC_SLD
;out:	cmdblk.lc_err = return code of launcher program - IF CARRY CLEAR!
;ret:	same as LNC_SLD
;type:	
;notes:	Exclusive launches make the parent program unaccessible until they
;	exit.  Example: use for the external MAIL editor.
;
public	lnc_xcl_f
lnc_xcl_f	label	near
	mov	cmdblk.ld_flag, ?ld_xcl+?ld_prv
	jmp	short lsld00
;lc_strn
;desc:	Generic routine called by several string/buffer Launcher commands
;in:	DS:SI = string/buffer to pass
;out:	
;ret:	
;type:	
;notes:	
;
public	lc_strn
lc_strn	proc	far
	mov	word ptr cmdblk.st_strz, si
	mov	word ptr cmdblk.st_strz[2], ds
	call	lc_scmd
	ret
lc_strn	endp
;lnc_gtm_f
;desc:	Get the Launcher Menu name
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for menu name (at least 80 bytes wide)
;out:	
;ret:	JC = none set yet
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	This returns the full path/name of the menu being used by the PoC to
;	launch and switch to other programs.  Only one menu may ever be
;	active at once.  Any programs supporting the "Run" menu must use this
;	to get the list of programs that are available.  Should be called ONCE
;	at startup time.
;
public	lnc_gtm_f
lnc_gtm_f	proc	far
	mov	cmdblk.lc_func, lc_getm
	call	lc_strn
	ret
lnc_gtm_f	endp
;lnc_gtp_f
;desc:	Get the Launcher Program of Choice description
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for Program of Choice (PoC) description (40 byte max)
;out:	
;ret:	JC = none set yet
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	For programs that support the Menu but are NOT the PoC, this returns
;	the string that should be used to describe the PoC on the menu
;	displayed to the user.  Need only be called once, so it is in EDITSEG
;
public	lnc_gtp_f
lnc_gtp_f	proc	far
	mov	cmdblk.lc_func, lc_getp
	call	lc_strn
	ret
lnc_gtp_f	endp
;lnc_cap_f
;desc:	Get list of Currently Active Programs (running or swapped)
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for list
;out:	cmdblk.st_cnt = number of programs resident - including PoC
;	cmdblk.st_wrd2 = current programs UMID
;ret:	JC = couldn't complete request
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	Returns a list of "3 word wide" entries: (1) UMID, (2) memory used (in
;	paragraphs), (3) where program is swapped to.  This can be used to
;	generate a memory map, check for child (private) launches, ...
;
public	lnc_cap_f
lnc_cap_f	proc	far
	mov	cmdblk.lc_func, lc_resp
	call	lc_strn
	ret
lnc_cap_f	endp
;lnc_eld_f
;desc:	Get list of Currently Active ELD Programs (running or swapped)
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = buffer for list
;out:	cmdblk.st_cnt = number of programs resident - including PoC
;ret:	JC = couldn't complete request
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	Returns a list of "3 word wide" entries: (1) UMID, (2) memory used (in
;	paragraphs), (3) where program is swapped to.  This can be used to
;	generate a memory map, check for child (private) launches, ...
;
public	lnc_eld_f
lnc_eld_f	proc	far
	mov	cmdblk.lc_func, lc_reld
	call	lc_strn
	ret
lnc_eld_f	endp
;lnc_mdf_f
;desc:	Begin Launcher's Macro define feature
;in:	DS:SI = filename to save keystrokes in
;	DS:DI = macro description to store in file header
;	CX = length of macro description string
;out:	
;ret:	JC = error code
;	cmdblk.lc_err = AX = error code
;type:	
;notes:	
;
public	lnc_mdf_f
lnc_mdf_f	proc	far
	mov	cmdblk.lc_func, lc_defm
	mov	word ptr cmdblk.st_wrd2, di	;pass in description, name handled
	mov	word ptr cmdblk.st_wrd2[2], ds	;in lc_strn
	mov	word ptr cmdblk.st_cnt, cx	;pass in description length
	call	lc_strn
	ret
lnc_mdf_f	endp

;lnc_mex_f
;desc:	Begin Launchers Macro play feature
;in:	DS:SI = filename to read keystrokes from
;out:	
;ret:	JC = error code
;	cmdblk.lc_err = AX = error code
;type:	
;notes:	
;
public	lnc_mex_f
lnc_mex_f	proc	far
	mov	cmdblk.lc_func, lc_exem
	call	lc_strn
	ret
lnc_mex_f	endp
;lnc_mds_f
;desc:	Stop the Macro define
;in:	CX = number of keystrokes to remove from end of macro
;out:	
;ret:	
;type:	
;notes:	
;
public	lnc_mds_f
lnc_mds_f	proc	far
	mov	cmdblk.lc_func, lc_defs
	mov	cmdblk.st_cnt, cx
	call	lc_scmd
	ret
lnc_mds_f	endp
;lnc_dio_f
;desc:	Set the direct IO mode of Launcher
;in:	AX = 0/1 enable/disable macro support
;out:	
;ret:	
;type:	
;notes:	
;
public	lnc_dio_f
lnc_dio_f	proc	far
	mov	cmdblk.lc_func, lc_dio
	mov	cmdblk.st_cnt, ax
	call	lc_scmd
	ret
lnc_dio_f	endp
;lnc_hks_f
;desc:	Set the Hot Key enable/disable flag in Launcher
;in:	AX = 0/1 enable/disable Hot Key swapping
;out:	
;ret:	
;type:	
;notes:	
;
public	lnc_hks_f
lnc_hks_f	proc	far
	mov	cmdblk.lc_func, lc_hksw
	mov	cmdblk.st_cnt, ax
	call	lc_scmd
	ret
lnc_hks_f	endp
;lnc_hku_f
;desc:	Set the Hot Key enable/disable flag in Launcher (User Programs only)
;in:	AX = 0/1 enable/disable Hot Key swapping
;out:	
;ret:	
;type:	
;notes:	
;
public	lnc_hku_f
lnc_hku_f	proc	far
	mov	cmdblk.lc_func, lc_hksu
	mov	cmdblk.st_cnt, ax
	call	lc_scmd
	ret
lnc_hku_f	endp
;lnc_lst
;desc:	Get the last active program (where swapped from)
;in:	
;out:	cmdblk.st_cnt = UMID of last active program
;ret:	
;type:	
;notes:	
;
public	lnc_lst_f
lnc_lst_f	proc	far
	mov	cmdblk.lc_func, lc_lact	;get Last ACTive program
	call	lc_scmd
	ret
lnc_lst_f	endp
;lnc_crd_f
;desc:	Clipboard Read
;in:	AX = requested format
;out:	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
public	lnc_crd_f
lnc_crd_f	proc	far
	mov	cmdblk.lc_func, lc_cbrd	;Read from the clipboard
	jmp	short lcpd30
lnc_crd_f	endp
;lnc_cwr_f
;desc:	Clipboard Write
;in:	AX = requested format
;out:	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
public	lnc_cwr_f
lnc_cwr_f	proc	far
	mov	cmdblk.lc_func, lc_cbwr	;Request Write to the Clipboard
	jmp	short lcpd30
lnc_cwr_f	endp
;lnc_cpd
;desc:	Clipboard Append
;in:	AX = requested format
;out:	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
public	lnc_cpd_f
lnc_cpd_f	proc	far
	mov	cmdblk.lc_func, lc_cbap	;Request Append to Clipboard
lcpd30:	mov	cmdblk.cb_frmt, ax	;pass requested format
	call	lc_scmd
	ret
lnc_cpd_f	endp
;lnc_cfm
;desc:	Clipboard Format check
;in:	
;out:	AX = format
;	cmdblk.cb_flnm = clipboard filename
;ret:	
;type:	
;notes:	
;
public	lnc_cfm_f
lnc_cfm_f	proc	far
	mov	cmdblk.lc_func, lc_cbfm	;Request Append to Clipboard
lcfm30:	call	lc_scmd
	mov	ax, cmdblk.cb_frmt	;return current format
	ret
lnc_cfm_f	endp
;lnc_crn_f
;desc:	Check current clipboard name/number
;in:	
;out:	AX = current clipboard number
;ret:	
;type:	
;notes:	
;
public	lnc_crn_f
lnc_crn_f	proc	far
	mov	cmdblk.lc_func, lc_cbrn	;Request Append to Clipboard
	jmp	short lcfm30
lnc_crn_f	endp
;lnc_csn_f
;desc:	Set new current clipboard name/number
;in:	AX = new clipboard name/number
;out:	
;ret:	
;type:	
;notes:	
;
public	lnc_csn_f
lnc_csn_f	proc	far
	mov	cmdblk.lc_func, lc_cbsn
	jmp	short lcpd30
lnc_csn_f	endp
;lnc_rqx_f
;desc:	Request permission to Exit
;in:	LNCHPID = Launcher assigned PID
;out:	
;ret:	JC = can't exit
;	cmdblk.lc_err = AX = error code
;type:	
;notes:	ERROR (can't exit) happens IFF requestor is Program of Choice and
;	other programs are still active.
;
public	lnc_rqx_f
lnc_rqx_f	proc	far
	mov	cmdblk.lc_func, lc_reqx	;check if it is OK to exit now
	call	lc_scmd
	ret
lnc_rqx_f	endp
;lc_scmd
;desc:	Local routine to perform Simple, no parameter, function request
;in:	
;out:	
;ret:	
;type:	
;notes:	
;
public	lc_scmd_f
lc_scmd_f	proc	far
	call	lc_scmd
	ret
lc_scmd_f	endp

public	lc_scmd
lc_scmd	proc	near
	push	si			;entry point for parameterless commands
	mov	ax, lnchpid
	mov	cmdblk.lc_pid, ax
	mov	cmdblk.lc_err, 0	;Always clear the error code field
	mov	ax, 5C00h
	mov	si, offset cmdblk
	int	1Ah
	pop	si
	ret
lc_scmd	endp
lnchids	db "WPLAUNCH",0
lcstr	db "LC.EXE",0
envltrs	dw 0				;ENV filename letters ??{WPC}.ENV

;lnc_chk_f
;desc:	Check if Launcher is resident and active
;in:	
;out:	AX = version number
;ret:	JE = Launcher resident
;type:	
;notes:	
;
public	lnc_chk_f
lnc_chk_f	proc	far
	push	si
	push	ds
	push	es
	mov	ax, 5C00h		;Launcher communication function
	mov	cmdblk.lc_func, lc_res	;Check if Launcher resident
	mov	si, offset cmdblk		;pass in the command block
	int	1Ah
	les	di, [si].st_strz	;get pointer to id string
	push	cs
	pop	ds			;DS:SI = id string
	mov	si, offset lnchids		;compare
	mov	cx, 8
	rep	cmpsb
	mov	ax, es:[di+1]		;get the version number
	xchg	ah, al			;put major in AH, minor in AL
	pop	es
	pop	ds
	pop	si
	ret
lnc_chk_f	endp
;lnc_reg_f
;desc:	Register with the Launcher
;in:	ES:DI = Applications STATE communication - like Shell 3.1 (DI=-1=none)
;out:	AX = Launcher PID (Program ID)
;	cmdblk.lc_pid = AX = PID
;ret:	
;type:	
;notes:	If Launcher is resident, will not fail.
;
public	lnc_reg_f
lnc_reg_f	proc	far
	push	si
	mov	ax, 5C00h		;Launcher communication function
	mov	cmdblk.lc_func,lc_ckin	;Check-in/register  with Launcher
	mov	word ptr cmdblk.rg_stat, di	;set STATE routine
	mov	word ptr cmdblk.rg_stat[2], es
	mov	si, offset cmdblk		;pass in the command block
	int	1Ah
	mov	lnchpid, ax
	push	si
	mov	si,[si].rg_flag
	mov	lnchflg,si
	pop	si
	mov	si,[si].rg_umid
	mov	lnchuid,si
	pop	si
	ret
lnc_reg_f	endp
;lnc_stm_f
;desc:	Set the Launcher Menu name
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = menu name to set
;out:	
;ret:	JC = couldn't set it (probably NOT PoC)
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	The PoC should always set this so other programs can use the same menu
;	file for their "Run" menus.  ONLY the PoC may successfully make this
;	call.
;
public	lnc_stm_f
lnc_stm_f	proc	far
	mov	cmdblk.lc_func, lc_setm
	call	lc_strn
	ret
lnc_stm_f	endp
;lnc_stp_f
;desc:	Set the Launcher Program of Choice description
;in:	LNCHPID = Launcher assigned PID
;	DS:SI = Program of Choice (PoC) description to set
;out:	
;ret:	JC = couldn't set it (probably NOT PoC)
;	  cmdblk.lc_err = AX = error code
;type:	
;notes:	This routine should be called ONLY by the PoC.  Others will always get
;	an error.  This is the string that will be displayed on the "Run"
;	menus displayed by Launcher aware programs.
;
public	lnc_stp_f
lnc_stp_f	proc	far
	mov	cmdblk.lc_func, lc_setp
	call	lc_strn
	ret
lnc_stp_f	endp
;execlc
;desc:	EXEC LC
;in:	
;out:	
;ret:	
;type:	
;notes:	
;
public	execlc
execlc	proc	near
	mov	ah, 4Ah			;shrink down to smallest possible
	int	21h
	mov	ax, 4B00h
	mov	bx, 6Ch			;ES:BX = pblock, DX = program name
	int	21h
	mov	ax, 4C00h		;exit upon return
	int	21h
	ret
execlc	endp

codemov	equ $-execlc
;lnc_exc_f
;desc:	Shrink as small as possible, then load launcher and reload me
;in:	AX=ENV file name letters ("WP", "OF", "PR", ...)
;out:	
;ret:	if return, couldn't do it, just continue w/o Launcher
;type:	
;notes:	Launcher is not resident, so find it, load it, and tell it to reload
;	current program.  The STACK MAY NOT be first in memory.  Uses the PSP
;	plus a couple hundred bytes immediately following the PSP to exec
;	Launcher and restart the current program with the same command line.
;
public	lnc_exc_f
lnc_exc_f	proc	far
	mov	envltrs, ax		;save environment letters
	mov	ah, 30h
	int	21h			;get DOS revision
	cmp	al, 3			;DOS 3.1 or later?
	jnb	lcex15			;  no, return
	jmp	lcex90
lcex15:	ja	lcex20			;  yes, OK to load launcher
	cmp	ah, 1			;  maybe, 
	jnb	lcex20			;  3.0, return
	jmp	lcex90
lcex20:	call	chkDL			;Check for /DL (Disable Launcher)
	jnc	lcex23			;  found, do not load launcher
	jmp	lcex90
lcex23:	call	chkcom			;if loaded as .EXE, try for X.COM
	jnc	lcex25
	push	ds
	push	cs
	pop	ds
	mov	si, offset lcstr	;copy "LC.EXE" to dataseg buffer
	mov	di, offset cmdblk
	call	scopy_f
	pop	ds
	mov	si, offset cmdblk	;find full path to LC.EXE
	call	fndlnc_f
	jnc	lcex25			;not found, return
	jmp	lcex90
lcex25:	call	lnclean_f		;free resources before exiting
	mov	es, mypsp		;point ES at the PSP
	cli				;put stack in PSP area
	mov	ss, mypsp		;we have a 128+ byte stack to use now
	mov	sp, 100h
	sti
	push	si			;save pointer to found name (fndlnc)
assume	es:nothing
	mov	ax, es:[2Ch]			;get Environment segment
	mov	word ptr es:[6Ch], ax		;put PBLOCK on top of FCB2
	mov	word ptr es:[6Ch+2], 100h	;pointer to command line
	mov	word ptr es:[6Ch+4], es
	mov	word ptr es:[6Ch+6], -1		;null out FCB1 pointer
	mov	word ptr es:[6Ch+8], -1
	mov	word ptr es:[6Ch+10], -1	;null out FCB2 pointer
	mov	word ptr es:[6Ch+12], -1
	mov	es, ax				;find end of environment
	xor	di, di
	xor	al, al
	mov	cx, -1
lcex30:	repne	scasb
	scasb
	jne	lcex30
	mov	si, di			;copy prog name to build cmd line
	lodsw				;move past count word
	push	ds
	push	es
	mov	es, mypsp
	pop	ds
	mov	di, 101h		;leave space for length byte
	cmp	envltrs, 0		;are there any letters?
	je	lcex35			;  no, skip
	mov	ax, "E/"		;put /EV=??<space> on command line
	stosw
	mov	ax, "=V"
	stosw
	mov	ax, envltrs
	stosw
	mov	al, 20h
	stosb
lcex35:	call	scopy_f
	push	es
	pop	ds			;append command line
	mov	al, 20h			;put in a space delimeter
	stosb
	mov	si, 80h			;get cmd line length
	lodsb
	xor	ah, ah
	mov	cx, ax
	jcxz	lcex38			;fix for some machines
	rep	movsb			;move entire command line
lcex38:	mov	word ptr es:[di], 0Dh	;terminate with CR & NULL
	pop	ds
	mov	ax, di			;calculate length of new cmd line
	sub	ax, 101h
	mov	es:[100h], al		;and store it
	add	di, 2
	mov	dx, di			;save pointer to program name buffer
	pop	si			;copy path\LC.EXE to "permanent" mem
	call	scopy_f
	inc	di			;leave NULL on end
	mov	bx, di			;save pointer to code destination
	mov	ax, cs
	mov	ds, ax
	mov	si, offset execlc
	mov	cx, codemov
	rep	movsb
	mov	cl, 4			;calculate paragraphs
	shr	di, cl
	inc	di			;add one for roundoff
	xchg	bx, di			;BX = paragraphs to keep, DI = code
	push	es			;set DS:DX = program name
	pop	ds
	push	es			;so return takes us to execlc
	push	di
lcex90:	ret
lnc_exc_f	endp
;chkdl
;desc:	Check for /DL Disable Launcher switch on command line
;in:	
;out:	
;ret:	JC = found, do not run launcher
;type:	
;notes:	
;
public	chkdl
chkdl	proc	near
	push	ax
	push	bx
	push	cx
	push	es
	mov	es, mypsp		;ES:DI = command line
	mov	di, 81h
	xor	cx, cx
	mov	cl, es:[80h]		;get length of command line
	mov	al, "/"
ckdl30:	repne	scasb			;scan for any switches
	clc
	jcxz	ckdl90
	mov	bx, es:[di]		;get next two bytes
	and	bx, 0DFDFh		;force to upper case
	cmp	bx, "LD"		;is it /DL?
	jne	ckdl30
	stc				;  yes, return carry set
ckdl90:	pop	es
	pop	cx
	pop	bx
	pop	ax
	ret
chkdl	endp
;chkcom
;desc:	Find Program.EXE and search for Program.COM
;in:	
;out:	
;ret:	
;type:	
;notes:	
;
public	chkcom
chkcom	proc	near
	push	ds
	mov	ds, mypsp
	mov	ds, ds:[2Ch]		;get environment segment
assume	ds:nothing
	xor	si,si			;scan for 2 nulls
ckcm20:	lodsb
	or	al, al			;look for null
	jnz	ckcm20
	cmp	byte ptr [si], 0		;two nulls?
	jne	ckcm20
	add	si, 3			;point at executed string
	mov	di, si			;save pointer to start of name
ckcm25:	lodsb				;find end of the string
	or	al, al
	jnz	ckcm25
	sub	si, 4			;move before the extension
	mov	cx, si			;end of name
ckcm27:	dec	si
	cmp	si, di			;past beginning?
	je	ckcm30			;  yes
	cmp	byte ptr [si-1], '\'
	je	ckcm30
	cmp	byte ptr [si-1], ':'
	jne	ckcm27
ckcm30:	pop	es			;set ES = dataseg
	push	es
	sub	cx, si
	mov	di, offset cmdblk
	rep	movsb
	pop	ds
	mov	word ptr [di], "OC"
	mov	word ptr [di+2], "M"
	mov	si, offset cmdblk
	call	fndlnc_f
	ret
chkcom	endp
	end
