;==============================================================
; CARD.COM is a utility to check the presence of a PCMCIA card
; in the palmtops PC slot. If a card is found, CARD tries to
; read the Product Information Tuple of the CIS (= Card
; Information Structure). This should work for all cards except
; configured I/O cards. The Product Information Tuple is 
; displayed followed by the text "inserted". If no card is
; found, CARD prompts "pulled".
;
; CARD.ASM is free and not copyrighted. Improve it to your
; needs. This is how to assemble CARD.ASM using Turbo Assembler
;
; TASM CARD.ASM                  ;creates CARD.OBJ
; TLINK /T/X CARD.OBJ            ;creates CARD.COM without map
; DEL CARD.OBJ                   ;deletes CARD.OBJ
;
;==============================================================
cseg   segment 'code'
assume cs:cseg,ds:cseg,es:cseg
org    100h
;
  start: 
mov    ax,4dd4h
int    15h              ;get model info
cmp    bx,'HP'
jne    no_palmtop       ;no HP
cmp    cx,0102h
je     is_palmtop       ;it is 100LX or 200LX
  no_palmtop:   
lea    dx,no_hp         ;"runs only on HP Palmtops"
jmp    short print

  is_palmtop:
lea    dx,pulled        ;preload "pulled"
lea    bx,requestTuple  ;load requestTuple structure offset
mov    bufferPtr+2,cs   ;set up buffer's Code Segment
mov    byte ptr func,80h;getFirstTuple 
mov    ax,0B000h        ;CARD_BIOS_REQUEST
int    1ah
or     ax,ax            ;everything ok from int1ah?
je     getTupleData     ;yes
cmp    ax,80h           ;no card found?
je     print            ;yes, hence "pulled"
jmp    short inserted   ;any other ax value means "inserted"
                        ;because we may not have access to CIS
                        ;of a configured i/o card
  getTupleData:
mov    byte ptr func,82h;getTupleData 
mov    ax,0B000h        ;CARD_BIOS_REQUEST
int    1ah
or     ax,ax            ;everything ok from int1ah?
jne    inserted         ;no, but card is still in

lea    di,buffer        ;product information tuple offset
mov    al,[di+1]        ;tuple length
add    di,ax
inc    di               ;first byte after tuple string
mov    al,'$'           ;string terminatior
stosb                   ;set for tuple string
lea    dx,buffer+4      ;begin of string in product info tuple
mov    ah,9
int    21h              ;print

  inserted:
lea    dx,insert        ;"inserted"

  print:
mov    ah,9
int    21h
  quit:
mov    ah,4ch           ;quit
int    21h

;---DATA-------------------------------------------------------

requestTuple:
rlength         db ?
func            db ?
socket          dw 1
flags           dw ?
linkOffset      dd ?
CISOffset       dd 0
attributes      db 0
desiredTuple    db 15h
bufferPtr       dw offset buffer,0
bufferLength    dw 100
tupleOffset     dw 0
bytesRetrieved  db ?

no_hp  db 'runs only on HP Palmtops$'
pulled db 'pulled$'
insert db 'inserted$'

buffer equ this byte

cseg   ends
       end start
