/*
 *  This file is part of qxpense, which is Copyright (C) 1999 Jean-Jacques Moreau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

/* --------------------------------------------------------------------
   Project: QXPense Quick Expense for the HP200LX
   Module:  QXPENSE.C
   Author:  Jean-Jacques Moreau
   Started: 11. Aug. 99
   Subject: Enter expenses on the HP200LX
   -------------------------------------------------------------------- */

#undef PAL
#define NKIT

/******** Include header files *******/

#if defined(PAL)
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <time.h>
#include "pal.h"
#else
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <time.h>
#include "lxapi.h"
#endif
#include "mktime.h"


#define KEYDEPTH 9

#define STACK_TOP     14
#define STACK_BOTTOM 177
#define STACK_LEFT   112

#define MAX_TRANSACTIONS 256
#define MAXROWS   11

typedef struct _TRANSACTION {
   int Day;
   int Month;
   int Year;
   int Category;
   int Trip;
   long int Amount;
   int Cents;
   int Curr;
   int Account;
} TRANSACTION;

char far *msgTestApp="QXPense";
char far *msgAppTopLine="Quick Expenses";
char far *msgDateTitle="Goto";
char far *msgDateB="# of days backward";
char far *msgDateF="# of days forward";
char far *msgAboutTitle="About";
char far *msgAbout1="       About Quick XPenses";
char far *msgAbout2="HP200LX Quick Expense Manager 1.0";
char far *msgAbout3="    This program is Freeware.";
char far *msgAbout4="(c) 1999-2000 Jean-Jacques Moreau";
char far *msgAbout5="  jean-jacques.moreau@wanadoo.fr";
char far *msgOK="OK";


char far *fkeyAdd="Add";
char far *fkeyCategory="Catgry";
char far *fkeyTrip="Trip";
char far *fkeyGoto="Goto";
char far *fkeyAccount="Account";
char far *fkeyCurr="Currcy";

char far *fkeyDayM="nDay-";
char far *fkeyDayP="nDay+";
char far *fkeyToday="Today";
char far *fkeyMonthM="Month-";
char far *fkeyMonthP="Month+";
char far *fkeyYearM="Year-";
char far *fkeyYearP="Year+";
char far *fkeyDateOK="OK";

char far *fkeyCat1="Income";
char far *fkeyCat2="Dining";
char far *fkeyCat3="Shopp'g";
char far *fkeyCat4="Leisure";
char far *fkeyCat5="Lodging";
char far *fkeyCat6="Medical";
char far *fkeyCat7="Tax";
char far *fkeyCat8="Tel.";
char far *fkeyCat9="Transp't";
char far *fkeyCat10="Misc.";

char far *msgCat1="Income";
char far *msgCat2="Dining";
char far *msgCat3="Shopping";
char far *msgCat4="Leisure";
char far *msgCat5="Lodging";
char far *msgCat6="Medical";
char far *msgCat7="Tax";
char far *msgCat8="Telephone";
char far *msgCat9="Transport";
char far *msgCat10="Miscellaneous";

char far *fkeyTrip1="France";
char far *fkeyTrip2="Germany";
char far *fkeyTrip3="UK";
char far *fkeyTrip4="Europe";
char far *fkeyTrip5="USA";
char far *fkeyTrip6="Canada";
char far *fkeyTrip7="Mexico";
char far *fkeyTrip8="Sth Am.";
char far *fkeyTrip9="Japan";
char far *fkeyTrip10="Asia";

char far *msgTrip1="France";
char far *msgTrip2="Germany";
char far *msgTrip3="UK";
char far *msgTrip4="Europe";
char far *msgTrip5="USA";
char far *msgTrip6="Canada";
char far *msgTrip7="Mexico";
char far *msgTrip8="South America";
char far *msgTrip9="Japan";
char far *msgTrip10="Asia";

char far *fkeyAccount1="Cash";
char far *fkeyAccount2="VISA";
char far *fkeyAccount3="AMEX";
char far *fkeyAccount4="Other";
char far *fkeyAccount5="Other";
char far *fkeyAccount6="Other";
char far *fkeyAccount7="Other";
char far *fkeyAccount8="Other";
char far *fkeyAccount9="Other";
char far *fkeyAccount10="Other";

char far *msgAccount1="Cash";
char far *msgAccount2="VISA";
char far *msgAccount3="AMEX";
char far *msgAccount4="Other";
char far *msgAccount5="Other";
char far *msgAccount6="Other";
char far *msgAccount7="Other";
char far *msgAccount8="Other";
char far *msgAccount9="Other";
char far *msgAccount10="Other";

char far *fkeyCurr1="Euro";
char far *fkeyCurr2="Dollar";
char far *fkeyCurr3="Yen";
char far *fkeyCurr4="Pound";
char far *fkeyCurr5="Other";
char far *fkeyCurr6="Other";
char far *fkeyCurr7="Other";
char far *fkeyCurr8="Other";
char far *fkeyCurr9="Other";
char far *fkeyCurr10="Other";

char far *msgCurr1="Euro";
char far *msgCurr2="Dollar";
char far *msgCurr3="Yen";
char far *msgCurr4="Pound";
char far *msgCurr5="Other";
char far *msgCurr6="Other";
char far *msgCurr7="Other";
char far *msgCurr8="Other";
char far *msgCurr9="Other";
char far *msgCurr10="Other";

char far *menuAdd="&Add";
char far *menuDel="&Delete";
char far *menuPurge="&Purge";
char far *menuAbout="&About...";
char far *menuExpense="&Expense";
char far *menuHelp="&Help";
char far *menuQuit="&Quit";

char far *msgENVName="C:\\_DAT\\QXPENSE.ENV";

char far *msgNull="";

#if defined(NKIT)
char far **StringTable[]={
&msgTestApp, &msgAppTopLine, &msgDateTitle, &msgDateB, &msgDateF,
&msgAboutTitle, &msgAbout1, &msgAbout2, &msgAbout3, &msgAbout4, &msgAbout5,
&msgOK,

&fkeyAdd, &fkeyCategory, &fkeyTrip, &fkeyGoto, &fkeyAccount, &fkeyCurr,

&fkeyDayM, &fkeyDayP, &fkeyToday, &fkeyMonthM, &fkeyMonthP, &fkeyYearM,
&fkeyYearP, &fkeyDateOK,

&fkeyCat1, &fkeyCat2, &fkeyCat3, &fkeyCat4, &fkeyCat5, &fkeyCat6, &fkeyCat7,
&fkeyCat8, &fkeyCat9, &fkeyCat10,

&msgCat1, &msgCat2, &msgCat3, &msgCat4, &msgCat5, &msgCat6, &msgCat7, &msgCat8,
&msgCat9, &msgCat10,

&fkeyTrip1, &fkeyTrip2, &fkeyTrip3, &fkeyTrip4, &fkeyTrip5, &fkeyTrip6,
&fkeyTrip7, &fkeyTrip8, &fkeyTrip9, &fkeyTrip10,

&msgTrip1, &msgTrip2, &msgTrip3, &msgTrip4, &msgTrip5, &msgTrip6, &msgTrip7,
&msgTrip8, &msgTrip9, &msgTrip10,

&fkeyAccount1, &fkeyAccount2, &fkeyAccount3, &fkeyAccount4, &fkeyAccount5,
&fkeyAccount6, &fkeyAccount7, &fkeyAccount8, &fkeyAccount9, &fkeyAccount10,

&msgAccount1, &msgAccount2, &msgAccount3, &msgAccount4, &msgAccount5,
&msgAccount6, &msgAccount7, &msgAccount8, &msgAccount9, &msgAccount10,

&fkeyCurr1, &fkeyCurr2, &fkeyCurr3, &fkeyCurr4, &fkeyCurr5, &fkeyCurr6,
&fkeyCurr7, &fkeyCurr8, &fkeyCurr9, &fkeyCurr10,

&msgCurr1, &msgCurr2, &msgCurr3, &msgCurr4, &msgCurr5, &msgCurr6, &msgCurr7,
&msgCurr8, &msgCurr9, &msgCurr10,

&menuAdd, &menuDel, &menuPurge, &menuAbout, &menuExpense, &menuHelp, &menuQuit,

&msgENVName,

&msgNull,
};
#endif

char cursordata[]={
0,0,0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,
    0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,
    0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff,
    0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff,
    0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff,
    0xff,0xff, 0xff,0xff,
    0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff,
    0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff, 0xff,0xff,
    0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,
    0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,
    0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00, 0x00,0x00,
    0x00,0x00, 0x00,0x00};




/**************** Handlers *******************/
#if defined(NKIT)
int far MyCardHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra, ...);
int far DateBHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra, ...);
int far DateFHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra, ...);
#endif

void far DoQuit(void);
void far DoAbout(void);
void far DoAdd(void);
void far DoRemove(void);
void far DoPurge(void);
void far DoClear(void);
void far DoCategory(void);
void far DoTrip(void);
void far DoGoto(void);
void far DoAccount(void);
void far DoCurr(void);
void far DoDayM(void);
void far DoDayP(void);
void far DoToday(void);
void far DoMonthM(void);
void far DoMonthP(void);
void far DoYearM(void);
void far DoYearP(void);
void far DoDateOK(void);
void far DoCat1(void);
void far DoCat2(void);
void far DoCat3(void);
void far DoCat4(void);
void far DoCat5(void);
void far DoCat6(void);
void far DoCat7(void);
void far DoCat8(void);
void far DoCat9(void);
void far DoCat10(void);
void far DoTrip1(void);
void far DoTrip2(void);
void far DoTrip3(void);
void far DoTrip4(void);
void far DoTrip5(void);
void far DoTrip6(void);
void far DoTrip7(void);
void far DoTrip8(void);
void far DoTrip9(void);
void far DoTrip10(void);
void far DoAccount1(void);
void far DoAccount2(void);
void far DoAccount3(void);
void far DoAccount4(void);
void far DoAccount5(void);
void far DoAccount6(void);
void far DoAccount7(void);
void far DoAccount8(void);
void far DoAccount9(void);
void far DoAccount10(void);
void far DoCurr1(void);
void far DoCurr2(void);
void far DoCurr3(void);
void far DoCurr4(void);
void far DoCurr5(void);
void far DoCurr6(void);
void far DoCurr7(void);
void far DoCurr8(void);
void far DoCurr9(void);
void far DoCurr10(void);
void far DoUp(void);
void far DoDown(void);
void far DoPageUp(void);
void far DoPageDown(void);
void far DoHome(void);
void far DoEnd(void);

void Uninitialize(void);
void Redisplay(void);
void SaveENV(void);
char *FormatNum(unsigned long int num);


#if defined(NKIT)
EVENT_NORM app_event;     /* System manager event struct */
LHAPIBLOCK CapData;       /* CAP application data block */
#endif
BOOL Done;                /* Global flag for program termination */


TRANSACTION near Transactions[MAX_TRANSACTIONS];

int depth=0;
int startnumber=1;
int startcents=1;
int RowNo=0;
int RecNo=0;
int MaxRecs=0;
int MaxRows=0;
int LastCategory=0;
int LastTrip=0;
int LastAccount=0;
int LastCurr=0;


char far **CategoryTable[] = {
   &msgCat1, &msgCat2, &msgCat3, &msgCat4, &msgCat5,
   &msgCat6, &msgCat7, &msgCat8, &msgCat9, &msgCat10
};

char far **TripTable[] = {
   &msgTrip1, &msgTrip2, &msgTrip3, &msgTrip4, &msgTrip5,
   &msgTrip6, &msgTrip7, &msgTrip8, &msgTrip9, &msgTrip10
};

char far **AccountTable[] = {
   &msgAccount1, &msgAccount2, &msgAccount3, &msgAccount4, &msgAccount5,
   &msgAccount6, &msgAccount7, &msgAccount8, &msgAccount9, &msgAccount10
};

char far **CurrTable[] = {
   &msgCurr1, &msgCurr2, &msgCurr3, &msgCurr4, &msgCurr5,
   &msgCurr6, &msgCurr7, &msgCurr8, &msgCurr9, &msgCurr10
};


#if defined(NKIT)
LHFKEY MainFKeys[]= {
 {  (PLHRES)&fkeyAdd,     (PLHFUNC)DoAdd,             2,           0 },
 {  (PLHRES)&fkeyCategory,(PLHFUNC)DoCategory,        3,           0 },
 {  (PLHRES)&fkeyTrip,    (PLHFUNC)DoTrip,            4,           0 },
 {  (PLHRES)&fkeyGoto,    (PLHFUNC)DoGoto,            5,           0 },
 {  (PLHRES)&fkeyAccount, (PLHFUNC)DoAccount,         6,           0 },
 {  (PLHRES)&fkeyCurr,    (PLHFUNC)DoCurr,            7+FKEY_LAST, 0 }
};
#else
char *MainFKeys[10] = {
   NULL, "Add", "Cat.", "Trip", "Goto",
   "Account", "Curr.", NULL, NULL, NULL
};
#endif

#if defined(NKIT)
LHFKEY GotoFKeys[]= {
 {  (PLHRES)&fkeyDayM,   (PLHFUNC)DoDayM,             2,           0 },
 {  (PLHRES)&fkeyDayP,   (PLHFUNC)DoDayP,             3,           0 },
 {  (PLHRES)&fkeyToday,  (PLHFUNC)DoToday,            4,           0 },
 {  (PLHRES)&fkeyMonthM, (PLHFUNC)DoMonthM,           5,           0 },
 {  (PLHRES)&fkeyMonthP, (PLHFUNC)DoMonthP,           6,           0 },
 {  (PLHRES)&fkeyYearM,  (PLHFUNC)DoYearM,            7,           0 },
 {  (PLHRES)&fkeyYearP,  (PLHFUNC)DoYearP,            8,           0 },
 {  (PLHRES)&fkeyDateOK, (PLHFUNC)DoDateOK,          10+FKEY_LAST, 0 }
};
#else
char *GotoFKeys[10] = {
   NULL, "nDay-", "nDay+", "Today", "Month-",
   "Month+", "Year-", "Year+", NULL, "OK"
};
#endif

#if defined(NKIT)
LHFKEY CategoryFKeys[]= {
 {  (PLHRES)&fkeyCat1,   (PLHFUNC)DoCat1,             1,           0 },
 {  (PLHRES)&fkeyCat2,   (PLHFUNC)DoCat2,             2,           0 },
 {  (PLHRES)&fkeyCat3,   (PLHFUNC)DoCat3,             3,           0 },
 {  (PLHRES)&fkeyCat4,   (PLHFUNC)DoCat4,             4,           0 },
 {  (PLHRES)&fkeyCat5,   (PLHFUNC)DoCat5,             5,           0 },
 {  (PLHRES)&fkeyCat6,   (PLHFUNC)DoCat6,             6,           0 },
 {  (PLHRES)&fkeyCat7,   (PLHFUNC)DoCat7,             7,           0 },
 {  (PLHRES)&fkeyCat8,   (PLHFUNC)DoCat8,             8,           0 },
 {  (PLHRES)&fkeyCat9,   (PLHFUNC)DoCat9,             9,           0 },
 {  (PLHRES)&fkeyCat10,  (PLHFUNC)DoCat10,           10+FKEY_LAST, 0 }
};
#else
char *CategoryFKeys[10] = {
   "Income", "Dining", "Shopp'g", "Leisure", "Lodging",
   "Medical", "Tax", "Tel.", "Transp't", "Misc."
};
#endif

#if defined(NKIT)
LHFKEY TripFKeys[]= {
 {  (PLHRES)&fkeyTrip1,  (PLHFUNC)DoTrip1,            1,           0 },
 {  (PLHRES)&fkeyTrip2,  (PLHFUNC)DoTrip2,            2,           0 },
 {  (PLHRES)&fkeyTrip3,  (PLHFUNC)DoTrip3,            3,           0 },
 {  (PLHRES)&fkeyTrip4,  (PLHFUNC)DoTrip4,            4,           0 },
 {  (PLHRES)&fkeyTrip5,  (PLHFUNC)DoTrip5,            5,           0 },
 {  (PLHRES)&fkeyTrip6,  (PLHFUNC)DoTrip6,            6,           0 },
 {  (PLHRES)&fkeyTrip7,  (PLHFUNC)DoTrip7,            7,           0 },
 {  (PLHRES)&fkeyTrip8,  (PLHFUNC)DoTrip8,            8,           0 },
 {  (PLHRES)&fkeyTrip9,  (PLHFUNC)DoTrip9,            9,           0 },
 {  (PLHRES)&fkeyTrip10, (PLHFUNC)DoTrip10,          10+FKEY_LAST, 0 }
};
#else
char *TripFKeys[10] = {
   "France", "Germany", "UK", "Europe", "USA",
   "Canada", "Mexico", "Sth Am.", "Japan", "Asia"
};
#endif

#if defined(NKIT)
LHFKEY AccountFKeys[]= {
 {  (PLHRES)&fkeyAccount1,  (PLHFUNC)DoAccount1,         1,           0 },
 {  (PLHRES)&fkeyAccount2,  (PLHFUNC)DoAccount2,         2,           0 },
 {  (PLHRES)&fkeyAccount3,  (PLHFUNC)DoAccount3,         3+FKEY_LAST, 0 }
};
#else
char *AccountFKeys[10] = {
   "Cash", "VISA", "AMEX", NULL, NULL,
   NULL, NULL, NULL, NULL, NULL
};
#endif

#if defined(NKIT)
LHFKEY CurrFKeys[]= {
 {  (PLHRES)&fkeyCurr1,  (PLHFUNC)DoCurr1,            1,           0 },
 {  (PLHRES)&fkeyCurr2,  (PLHFUNC)DoCurr2,            2,           0 },
 {  (PLHRES)&fkeyCurr3,  (PLHFUNC)DoCurr3,            3,           0 },
 {  (PLHRES)&fkeyCurr4,  (PLHFUNC)DoCurr4,            4,           0 },
 {  (PLHRES)&fkeyCurr5,  (PLHFUNC)DoCurr5,            5+FKEY_LAST, 0 }
};
#else
char *CurrFKeys[10] = {
   "Euro", "Dollar", "Yen", "Pound", "Other",
   NULL, NULL, NULL, NULL, NULL
};
#endif


#if defined(NKIT)
LHFKEY OkFkeys[] = {
   { (PLHRES)&msgOK,(PLHFUNC)CMD_ESC, 10+FKEY_LAST, FKEY_SENDMSG }
};
#endif


#if defined(NKIT)
LHMENU ExpenseMenu[] = {
 { (PLHRES)&menuAdd,         (PLHFUNC)DoAdd,   0 ,0, NO_HELP},
 { (PLHRES)&menuDel,         (PLHFUNC)DoRemove,0 ,0, NO_HELP},
 { (PLHRES)&menuPurge,       (PLHFUNC)DoPurge, 0 ,0, NO_HELP},
 { 0, 0, 0, 0}
};

LHMENU HelpMenu[] = {
 { (PLHRES)&menuAbout,       (PLHFUNC)DoAbout, 0 ,0, NO_HELP},
 { 0, 0, 0, 0}
};

LHMENU TopMenu[] = {
 { (PLHRES)&menuExpense,  (PLHFUNC)ExpenseMenu, 0, MENU_PULLDOWN },
 { (PLHRES)&menuQuit,     (PLHFUNC)DoQuit,      0 },
 { (PLHRES)&menuHelp,     (PLHFUNC)HelpMenu,    0, MENU_PULLDOWN },
 { 0, 0, 0, 0}
};
#else
typedef enum {
   CMD_ABOUT = 1,
   CMD_ADD, CMD_DEL, CMD_PURGE,
   CMD_EXIT
} MENUCOMMANDS;

MENUITEM ExpenseItems[] = {
   { "&Add",       MA_VAL, MENUVAL(CMD_ADD)},
   { "&Delete",    MA_VAL, MENUVAL(CMD_DEL)},
   { "&Purge",     MA_VAL, MENUVAL(CMD_PURGE)},
};
MENU ExpenseMenu = { NULL, MS_PULLDN, 0, 0, 3, 3, ExpenseItems };

MENUITEM HelpItems[] = {
   { "&About...",     MA_VAL, MENUVAL(CMD_ABOUT)},
};
MENU HelpMenu = { NULL, MS_PULLDN, 0, 0, 1, 1, HelpItems };

MENUITEM TopItems[] = {
   { "&Expense",      MA_MNU, &ExpenseMenu         },
   { "&Quit",         MA_VAL, MENUVAL(CMD_EXIT) },
   { "&Help",         MA_MNU, &HelpMenu         },
};
MENU TopMenu = { NULL, MS_HORIZ|MS_TOPLVL, 0,0,3,3, TopItems };
#endif


#if defined(NKIT)
LHWINDOW TDateTime = {
    DateTime,0,0,0,0,
    0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP};

LHWINDOW MainTitle = {
    TitleBar,0,0,0,0,
    (PLHRES)&msgAppTopLine,0,0,STYLE_NOFOCUS,
    NULL,PARENT_FKEYS,(PLHMENU)&TDateTime,NO_HELP};

LHWINDOW MainCard={(PLHCLASS)MyCardHandler,
       0,0,640,190,
       (PLHRES)&msgAppTopLine,0,
       0,0,
       NULL,MainFKeys,TopMenu,NO_HELP};

char near DateString[5]= "\0";

LHWINDOW AboutArray[] = {
      {StaticText, 120, 60, 0, 0,
      (PLHRES)&msgAbout1, (PLHDATA)NULL,
      48, STYLE_NOBORDER|STYLE_WHCHAR,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
      {StaticText, 120, 75, 0, 0,
      (PLHRES)&msgAbout2, (PLHDATA)NULL,
      48, STYLE_NOBORDER|STYLE_WHCHAR,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
      {StaticText, 120, 90, 0, 0,
      (PLHRES)&msgAbout3, (PLHDATA)NULL,
      48, STYLE_NOBORDER|STYLE_WHCHAR,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
      {StaticText, 120, 105, 0, 0,
      (PLHRES)&msgAbout4, (PLHDATA)NULL,
      48, STYLE_NOBORDER|STYLE_WHCHAR,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP},
      {StaticText, 120, 120, 0, 0,
      (PLHRES)&msgAbout5, (PLHDATA)NULL,
      48, STYLE_NOBORDER|STYLE_WHCHAR,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW AboutDlg = {
      DialogBox, 90, 35, 410, 120,
      (PLHRES)&msgAboutTitle, (PLHDATA)AboutArray, countof(AboutArray), 0,
      NULL, OkFkeys, NO_MENU, NO_HELP
};

LHWINDOW DateBArray[] = {
      {(PLHCLASS)DateBHandler, 110, 165, 3, 1,
      (PLHRES)&msgDateB, (PLHDATA)DateString, 4, STYLE_WHCHAR,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW DateBDlg = {
      DialogBox, 100, 150, 320, 35,
      (PLHRES)&msgDateTitle, (PLHDATA)DateBArray, countof(DateBArray), 0,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP
};

LHWINDOW DateFArray[] = {
      {(PLHCLASS)DateFHandler, 110, 165, 3, 1,
      (PLHRES)&msgDateF, (PLHDATA)DateString, 4, STYLE_WHCHAR,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP}
};

LHWINDOW DateFDlg = {
      DialogBox, 100, 150, 320, 35,
      (PLHRES)&msgDateTitle, (PLHDATA)DateFArray, countof(DateFArray), 0,
      NULL, PARENT_FKEYS, NO_MENU, NO_HELP
};
#endif


#if defined(NKIT)
#if defined(TURBOC)
#define GetDataSeg() _DS
#define GetCodeSeg() _CS
#define GetStack()   _SP
#endif
#if defined(LSIC)
int _asm_(char *);
#define GetDataSeg() _asm_(" mov ax,ds\n")
#define GetCodeSeg() _asm_(" mov ax,cs\n")
#define GetStack()   _asm_(" mov ax,sp\n")
#endif

void FixupFarPtrs(void)
{
  int i;
  int dataseg;

#if defined(MSC)
  _asm {
    mov  ax,ds;
    mov  dataseg,ax;
    }
#else
  dataseg=GetDataSeg();
#endif

  for (i=0; i<countof(StringTable); i++)
      *(((int *)(StringTable[i]))+1) = dataseg;
}
#endif


#if defined(NKIT)
void __int__(int no);
#endif

void MyCursor(int on)
{
 if (on) {
#if defined(NKIT)
#if defined(TURBOC)
     _SI=FP_OFF(cursordata); _ES=FP_SEG(cursordata); _DS=FP_SEG(cursordata); _AX=0xdc00; __int__(0x10);
     _CX=640-16; _DX=STACK_BOTTOM; _AX=0xdc03; __int__(0x10);
     _AX=0xdc04; __int__(0x10);
     _CX=9; _AX=0xdc02; __int__(0x10);
     _AX=0xdc06; __int__(0x10);
#endif
#if defined(LSIC)
     _asm_(" mov ax,0dc00h\n mov si,offset cursordata\n int 10h\n");
     _asm_(" mov ax,0dc03h\n mov cx,640-16\n mov dx,STACK_BOTTOM\n int 10h\n");
     _asm_(" mov ax,0dc04h\n int 10h\n");
     _asm_(" mov ax,0dc02h\n mov cx,9\n int 10h\n");
     _asm_(" mov ax,0dc06h\n int 10h\n");
#endif
#if defined(MSC)
   _asm {
     mov ax,0dc00h       ; define cursor data
     mov si,offset cursordata
  /* mov es,segment cursordata
     mov ds,segment cursordata */
     int 10h

     mov ax,0dc03h       ; move cursor
     mov cx,640-16
     mov dx,STACK_BOTTOM
     int 10h

     mov ax,0dc04h       ; blink cursor
     int 10h

     mov ax,0dc02h       ; blink rate
     mov cx,9
     int 10h

     mov ax,0dc06h       ; turn on cursor
     int 10h
   }
#endif
#else
/*
   Cursor(CURSOR_INIT);
   DefineCursor(cursordata);
   MoveCursor(640-16,STACK_BOTTOM);
   Cursor(CURSOR_BLINK);
   BlinkRate(9);
   Cursor(CURSOR_ON);
*/
#endif
 } else {
#if defined(NKIT)
#if defined(TURBOC)
   _AX=0x0DC07; __int__(0x10);
#endif
#if defined(LSIC)
   _asm(" mov ax,0dc07h\n int 10h\n");
#endif
#if defined(MSC)
   _asm {
     mov ax,0dc07h       ; turn off graphics cursor
     int 10h
   }
#endif
#else
/*
   Cursor(CURSOR_OFF);
*/
#endif
 }
}


static int Page(int RowNo)
{
   if (RowNo < 0)
      return -1;

   return RowNo/MAXROWS;
}

static int Row(int RowNo)
{
   return RowNo-Page(RowNo)*MAXROWS;
}

int MaxVisiblePages()
{
   return 0;
}

int IsRowVisible(int RowNo)
{
   int PageNo=Page(RowNo);

   return PageNo == 0;
}

int NormalizeRow(int RowNo)
{
   int PageNo=Page(RowNo);
   int NormalizedRow=RowNo;
   int Offset=MAXROWS;

   if (PageNo < 0)
      NormalizedRow=RowNo+Offset;
   else if (PageNo >= MaxVisiblePages())
      NormalizedRow=RowNo-Offset;

   return NormalizedRow;
}

void FirstVisibleRow(int RecNo, int RowNo, int *pTargetRec, int *pTargetRow)
{
   *pTargetRec=(RecNo-RowNo < 0) ? 0 : RecNo-RowNo;
   *pTargetRow=RowNo-(RecNo-(*pTargetRec));
}

void LastVisibleRow(int RecNo, int RowNo, int *pTargetRec, int *pTargetRow)
{
   int Offset=MaxDisplayableRows()-1-RowNo;
   int MaxRecs=depth;

   *pTargetRec=(RecNo+Offset > MaxRecs-1) ? MaxRecs-1 : RecNo+Offset;
   *pTargetRow=RowNo+((*pTargetRec)-RecNo);
}

void SameRowOnPreviousPage(int RecNo, int RowNo, int *pTargetRec, int *pTargetRow)
{
   *pTargetRec=(RecNo-MAXROWS < 0) ? 0 : RecNo-MAXROWS;
   *pTargetRow=RowNo-(RecNo-(*pTargetRec));
}

void SameRowOnNextPage(int RecNo, int RowNo, int *pTargetRec, int *pTargetRow)
{
   int MaxRecs=depth;

   *pTargetRec=(RecNo+MAXROWS > MaxRecs-1) ? MaxRecs-1 : RecNo+MAXROWS;
   *pTargetRow=RowNo+((*pTargetRec)-RecNo);
}

void RowOnPreviousScreen(int RecNo, int RowNo, int *pTargetRec, int *pTargetRow)
{
   int Offset=MAXROWS;

   *pTargetRec=(RecNo-Offset < 0) ? 0 : RecNo-Offset;
   *pTargetRow=RowNo-(RecNo-(*pTargetRec));
}

void RowOnNextScreen(int RecNo, int RowNo, int *pTargetRec, int *pTargetRow)
{
   int Offset=MAXROWS;
   int MaxRecs=depth;

   *pTargetRec=(RecNo+Offset > MaxRecs-1) ? MaxRecs-1 : RecNo+Offset;
   *pTargetRow=RowNo+((*pTargetRec)-RecNo);
}

int MaxDisplayableRows()
{
   return MAXROWS;
}

void ClearRows()
{
#if defined(NKIT)
   ClearRect(0,12,639,200-12+1-KEYDEPTH-2);
#else
   SetColor(WHITE_COLOR);
   SetRule(FORCE_RULE);
   Rectangle(0,12,639,MAX_Y-KEYDEPTH-2,SOLID_FILL);
#endif
}

int ClearRowAtIndex(int RowNo)
{
   int yoffset=13*Row(RowNo);

#if defined(NKIT)
   ClearRect(1,29+yoffset,638,40-29+1);
#else
   SetColor(WHITE_COLOR);
   SetRule(FORCE_RULE);
   Rectangle(1,29+yoffset,MAX_X-1,40+yoffset,SOLID_FILL);
#endif
}

int ClearRowsAtIndex(int FirstRowNo, int RowsNo)
{
   int i;

   for(i = FirstRowNo; i < FirstRowNo+RowsNo; i++)
      ClearRowAtIndex(i);
}

void ShowHeader()
{
   int offset, i;
   char buffer[256], *ptr;
   int tabs[]={9,15,10,14,9,6,-1};
   char *strings[]={"Date", "Category", "Trip", "Amount", "Currency", "Account"};
   char *formats[]={"%-9s\0", "%-15s\0", "%-10s\0", "%-14s\0", "%-9s\0", "%-6s\0"};

#if defined(NKIT)
   ClearRect(0,12,639,25-12+1);
   Rectangle(0,12,639,25-12+1,1,G_OUTLINE);
#else
   SetColor(WHITE_COLOR);
   SetRule(FORCE_RULE);
   Rectangle(0,12,639,25,SOLID_FILL);
   SetColor(BLACK_COLOR);
   Rectangle(0,12,639,25,OUTLINE_FILL);

   SetRule(TXT_RULE);
   SelectFont(MEDIUM_FONT);
#endif

   for(i=0, ptr=buffer; tabs[i]!=-1; i++) {
      sprintf(ptr, formats[i], strings[i]);
      ptr+=strlen(ptr);
   }
#if defined(NKIT)
   DrawText(FNTW(FONT_NORMAL), 14, buffer, DRAW_NORMAL, FONT_NORMAL);
#else
   WriteText(FNTW(MEDIUM_FONT), 14, buffer);
#endif

   for(i=0, offset=0; tabs[i]!=-1; i++) {
#if defined(NKIT)
      Line(offset,12,offset,25,1);
      offset+=tabs[i]*FNTW(FONT_NORMAL);
#else
      Line(offset,12,offset,25);
      offset+=tabs[i]*FNTW(MEDIUM_FONT);
#endif
   }
}

int ShowRowAtIndex(int Index, int RowNo, int IsCurrent)
{
   int yoffset, width;
   char buffer[256], *ptr;

   if(!depth || Index < 0 || Index >= depth) return;

   yoffset=13*Row(RowNo);

   /* clear row area */
#if defined(NKIT)
   Rectangle(0,29+yoffset,638,40-29+1,(IsCurrent) ? 1 : 0,G_SOLIDFILL);
#else
   SetColor((IsCurrent) ? BLACK_COLOR : WHITE_COLOR);
   SetRule(FORCE_RULE);
   Rectangle(1,29+yoffset,MAX_X-1,40+yoffset,SOLID_FILL);

   SetColor((IsCurrent) ? WHITE_COLOR : BLACK_COLOR);
   SetRule(TXT_RULE);
   SelectFont(MEDIUM_FONT);
#endif

   ptr=buffer;

   /* Date */
   sprintf(ptr, "%02d/%02d/%02d \0",
           Transactions[Index].Day, Transactions[Index].Month, (Transactions[Index].Year-1900)%100);
   ptr+=strlen(ptr);

   /* Category */
   sprintf(ptr, "%-15s\0", *(CategoryTable[Transactions[Index].Category]));
   ptr+=strlen(ptr);

   /* Trip */
   sprintf(ptr, "%-10s\0", *(TripTable[Transactions[Index].Trip]));
   ptr+=strlen(ptr);

   /* Amount */
   sprintf(ptr, "%9ld.%02.2d  \0", Transactions[Index].Amount, Transactions[Index].Cents);
   ptr+=strlen(ptr);

   /* Curr */
   sprintf(ptr, "%-9s\0",*(CurrTable[Transactions[Index].Curr]));
   ptr+=strlen(ptr);

   /* Account */
   sprintf(ptr, "%-6s\0", *(AccountTable[Transactions[Index].Account]));

#if defined(NKIT)
   DrawText(FNTW(FONT_NORMAL), 30+yoffset, buffer, (IsCurrent) ? DRAW_INVERT : DRAW_NORMAL, FONT_NORMAL);
#else
   WriteText(FNTW(MEDIUM_FONT), 30+yoffset, buffer);
#endif
}

int ShowRowsAtIndex(int FirstRecIndex, int FirstRowNo, int RowsNo, int IsCurrent)
{
   int i;

   for(i = 0; i < RowsNo; i++)
      ShowRowAtIndex(FirstRecIndex+i, FirstRowNo+i, IsCurrent);
}

int ShowRows(int RecNo, int RowNo)
{
   int TopRec, TopRow, BottomRec, BottomRow;

   FirstVisibleRow(RecNo, RowNo, &TopRec, &TopRow);
   LastVisibleRow(RecNo, RowNo, &BottomRec, &BottomRow);

   ClearRowsAtIndex(0, TopRow);
   ShowRowsAtIndex(TopRec, TopRow, RowNo-TopRow, 0);
   if (depth > 0)
      ShowRowAtIndex(RecNo, RowNo, 1);
   ShowRowsAtIndex(RecNo+1, RowNo+1, BottomRow-RowNo, 0);
   ClearRowsAtIndex(BottomRow+1, MaxDisplayableRows()-BottomRow-1);
}


void AddTrans(void)
{
   time_t ltime;
   struct tm *today;

   if (depth >= MAX_TRANSACTIONS-1)
      return;

   depth++;
   time(&ltime);
   today=localtime(&ltime);
   Transactions[depth-1].Day=today->tm_mday;
   Transactions[depth-1].Month=today->tm_mon+1;
   Transactions[depth-1].Year=today->tm_year+1900;
   Transactions[depth-1].Category=LastCategory;
   Transactions[depth-1].Trip=LastTrip;
   Transactions[depth-1].Amount=0;
   Transactions[depth-1].Cents=0;
   Transactions[depth-1].Curr=LastCurr;
   Transactions[depth-1].Account=LastAccount;

   SaveENV();
}

void RemoveTrans(int Index)
{
   TRANSACTION *pDest, *pSource;

   if (Index < 0 || Index > depth-1)
      return;

   pDest=&(Transactions[Index]);
   pSource=pDest+1;
   memmove(pDest,pSource,sizeof(TRANSACTION)*(depth-Index-1));
   depth--;

   SaveENV();
}

void RemoveAllTrans(void)
{
   depth=0;
   RowNo=0;
   RecNo=0;

   SaveENV();
}


void CreateMainView(void)
{
#if defined(NKIT)
  SendMsg(&MainCard, CREATE, CREATE_FOCUS, 0);
  SendMsg(&MainTitle, CREATE, CREATE_NORMAL, 0 );
#else
  ShowHeader();
  ShowRows(RecNo,RowNo);
  Redisplay();
#endif
}

int ShowNum(char far *ptr)
{
  char buffer[33];
  int i,len;
  char ch;

  /* Get length of string */
  for (len=0; ptr[len]; len++)  ;

  /* Fill up buffer from back to front */
  for (i=sizeof(buffer)-2; i>=0; i--) {
    if (len) ch = ptr[--len];
        else ch = ' ';
    buffer[i] = ch;
  }

  /* terminate string */
  buffer[sizeof(buffer)-1] = 0;

#if defined(NKIT)
  DrawText(STACK_LEFT, STACK_BOTTOM, buffer, DRAW_NORMAL, FONT_LARGE);
#else
  SetColor(BLACK_COLOR);
  SetRule(TXT_RULE);
  SelectFont(LARGE_FONT);
  WriteText(STACK_LEFT,STACK_BOTTOM,buffer);
#endif
}

void Redisplay(void)
{
  char buffer[32];

  if (startnumber || (depth && !Transactions[depth-1].Amount && !Transactions[depth-1].Cents))
    MyCursor(0);

  if (depth) {
    sprintf(buffer, "%ld.%02.2d", Transactions[RecNo].Amount, Transactions[RecNo].Cents);
    ShowNum(buffer);
  } else {
    ShowNum(msgNull);
  }

#if defined(NKIT)
  Rectangle(0,STACK_BOTTOM-5,640,5-3+1,1,G_SOLIDFILL);
  SendMsg(&MainCard, DRAW, DRAW_TITLE, 0);
#else
  SetColor(BLACK_COLOR);
  SetRule(FORCE_RULE);
  Rectangle(0,STACK_BOTTOM-5,640,STACK_BOTTOM-3,SOLID_FILL);
#endif
}


void far DoBeep(void)
{
#if defined(NKIT)
  m_beep();
#endif
}

void far DoQuit(void)
{
  Done = TRUE;
}

void far DoAbout(void)
{
#if defined(NKIT)
  SendMsg(&AboutDlg, CREATE, CREATE_FOCUS, 0);
#endif
}

void far ShowMainFKeys(void)
{
#if defined(NKIT)
  MainCard.Fkey=MainFKeys;
  DrawFKeys(&MainCard,FKEY_ALONE);
#else
  ShowFKeys(MainFKeys);
#endif
}

void far ShowCategoryFKeys(void)
{
#if defined(NKIT)
  MainCard.Fkey=CategoryFKeys;
  DrawFKeys(&MainCard,FKEY_ALONE);
#else
  ShowFKeys(CategoryFKeys);
#endif
}

void far ShowTripFKeys(void)
{
#if defined(NKIT)
  MainCard.Fkey=TripFKeys;
  DrawFKeys(&MainCard,FKEY_ALONE);
#else
  ShowFKeys(TripFKeys);
#endif
}

void far ShowGotoFKeys(void)
{
#if defined(NKIT)
  MainCard.Fkey=GotoFKeys;
  DrawFKeys(&MainCard,FKEY_ALONE);
#else
  ShowFKeys(GotoFKeys);
#endif
}

void far ShowAccountFKeys(void)
{
#if defined(NKIT)
  MainCard.Fkey=AccountFKeys;
  DrawFKeys(&MainCard,FKEY_ALONE);
#else
  ShowFKeys(AccountFKeys);
#endif
}

void far ShowCurrFKeys(void)
{
#if defined(NKIT)
  MainCard.Fkey=CurrFKeys;
  DrawFKeys(&MainCard,FKEY_ALONE);
#else
  ShowFKeys(CurrFKeys);
#endif
}

void far DoAdd(void)
{
  if (depth) { /* adding first transaction? */
    AddTrans();
    DoEnd();
  } else {
    AddTrans();
    RecNo=0;
    RowNo=0;
    ShowRows(RecNo,RowNo);
  }
}

void far DoRemove(void)
{
  if (!depth) return;

  RemoveTrans(RecNo);
  startnumber=1;
  MaxRecs = depth;
  MaxRows = (MaxRecs >= MaxDisplayableRows()) ? MaxDisplayableRows() : MaxRecs;
  if (RecNo > MaxRecs-1) { /* last record? */
     RecNo = (RecNo > 0) ? RecNo-1 : 0;
     RowNo = (RowNo > 0) ? RowNo-1 : MaxDisplayableRows();
  }
  ShowRows(RecNo,RowNo);
  Redisplay();
}

void far DoPurge(void)
{
  RemoveAllTrans();
  startnumber=1;
  ClearRows();
  Redisplay();
  ShowHeader();
}

void far DoClear(void)
{
  startnumber=1;
#if defined(NKIT)
  SendMsg(&MainCard,DRAW,DRAW_ALL,0);
#else
  ShowRows(RecNo, RowNo);
  Redisplay();
#endif
}

void far DoCategory(void)
{
  ShowCategoryFKeys();
}

void far DoTrip(void)
{
  ShowTripFKeys();
}

void far DoGoto(void)
{
  ShowGotoFKeys();
}

void far DoAccount(void)
{
  ShowAccountFKeys();
}

void far DoCurr(void)
{
  ShowCurrFKeys();
}

void far GotoDate(int RecNo, int nDays, int nMonths, int nYears)
{
  time_t CurTime;
  struct tm *pLocTime;

  if (!depth) return;

  /* Get the time here */
  CurTime=time(NULL);
  pLocTime=localtime(&CurTime);

  /* Calculate the date to move to */
  pLocTime->tm_mday=Transactions[RecNo].Day+nDays;
  pLocTime->tm_mon=Transactions[RecNo].Month-1+nMonths;
  pLocTime->tm_year=Transactions[RecNo].Year-1900+nYears;

  CurTime=mktime(pLocTime);
  if (CurTime==(time_t) -1) return;

  /* Move to this new date */
  pLocTime=localtime(&CurTime);

  Transactions[RecNo].Day=pLocTime->tm_mday;
  Transactions[RecNo].Month=pLocTime->tm_mon+1;
  Transactions[RecNo].Year=pLocTime->tm_year+1900;

  SaveENV();

  ShowRowAtIndex(RecNo,RowNo,1);
}

void far DoDayM(void)
{
  if (!depth) return;

#if defined(NKIT)
  SendMsg(&DateBDlg, CREATE, CREATE_FOCUS, 0);
#else
  GotoDate(RecNo,-1,0,0);
#endif
}

void far DoDayP(void)
{
  if (!depth) return;

#if defined(NKIT)
  SendMsg(&DateFDlg, CREATE, CREATE_FOCUS, 0);
#else
  GotoDate(RecNo,1,0,0);
#endif
}

void far DoToday(void)
{
  struct tm *today;
  time_t ltime;

  if (!depth) return;

  time(&ltime);
  today=localtime(&ltime);
  Transactions[RecNo].Day=today->tm_mday;
  Transactions[RecNo].Month=today->tm_mon+1;
  Transactions[RecNo].Year=today->tm_year+1900;
  SaveENV();
  ShowRowAtIndex(RecNo,RowNo,1);
  ShowMainFKeys();
}

void far DoMonthM(void)
{
  if (!depth) return;

  GotoDate(RecNo,0,-1,0);
}

void far DoMonthP(void)
{
  if (!depth) return;

  GotoDate(RecNo,0,1,0);
}

void far DoYearM(void)
{
  if (!depth) return;

  GotoDate(RecNo,0,0,-1);
}

void far DoYearP(void)
{
  if (!depth) return;

  GotoDate(RecNo,0,0,1);
}

void far DoDateOK(void)
{
  ShowMainFKeys();
}

void far SetCategory(int cat)
{
  if (depth)
    Transactions[RecNo].Category=cat;
  LastCategory=cat;
  ShowRowAtIndex(RecNo, RowNo, 1);
  startnumber=1;
  ShowMainFKeys();
  SaveENV();
}

void far DoCat1(void)
{
  SetCategory(0);
}

void far DoCat2(void)
{
  SetCategory(1);
}

void far DoCat3(void)
{
  SetCategory(2);
}

void far DoCat4(void)
{
  SetCategory(3);
}

void far DoCat5(void)
{
  SetCategory(4);
}

void far DoCat6(void)
{
  SetCategory(5);
}

void far DoCat7(void)
{
  SetCategory(6);
}

void far DoCat8(void)
{
  SetCategory(7);
}

void far DoCat9(void)
{
  SetCategory(8);
}

void far DoCat10(void)
{
  SetCategory(9);
}

void far SetTrip(int trip)
{
  if (depth)
    Transactions[RecNo].Trip=trip;
  LastTrip=trip;
  ShowRowAtIndex(RecNo, RowNo, 1);
  startnumber=1;
  ShowMainFKeys();
  SaveENV();
}

void far DoTrip1(void)
{
  SetTrip(0);
}

void far DoTrip2(void)
{
  SetTrip(1);
}

void far DoTrip3(void)
{
  SetTrip(2);
}

void far DoTrip4(void)
{
  SetTrip(3);
}

void far DoTrip5(void)
{
  SetTrip(4);
}

void far DoTrip6(void)
{
  SetTrip(5);
}

void far DoTrip7(void)
{
  SetTrip(6);
}

void far DoTrip8(void)
{
  SetTrip(7);
}

void far DoTrip9(void)
{
  SetTrip(8);
}

void far DoTrip10(void)
{
  SetTrip(9);
}

void far SetAccount(int Account)
{
  if (depth)
    Transactions[RecNo].Account=Account;
  LastAccount=Account;
  ShowRowAtIndex(RecNo, RowNo, 1);
  startnumber=1;
  ShowMainFKeys();
  SaveENV();
}

void far DoAccount1(void)
{
  SetAccount(0);
}

void far DoAccount2(void)
{
  SetAccount(1);
}

void far DoAccount3(void)
{
  SetAccount(2);
}

void far DoAccount4(void)
{
  SetAccount(3);
}

void far DoAccount5(void)
{
  SetAccount(4);
}

void far DoAccount6(void)
{
  SetAccount(5);
}

void far DoAccount7(void)
{
  SetAccount(6);
}

void far DoAccount8(void)
{
  SetAccount(7);
}

void far DoAccount9(void)
{
  SetAccount(8);
}

void far DoAccount10(void)
{
  SetAccount(9);
}

void far SetCurr(int curr)
{
  if (depth)
    Transactions[RecNo].Curr=curr;
  LastCurr=curr;
  ShowRowAtIndex(RecNo, RowNo, 1);
  startnumber=1;
  ShowMainFKeys();
  SaveENV();
}

void far DoCurr1(void)
{
  SetCurr(0);
}

void far DoCurr2(void)
{
  SetCurr(1);
}

void far DoCurr3(void)
{
  SetCurr(2);
}

void far DoCurr4(void)
{
  SetCurr(3);
}

void far DoCurr5(void)
{
  SetCurr(4);
}

void far DoCurr6(void)
{
  SetCurr(5);
}

void far DoCurr7(void)
{
  SetCurr(6);
}

void far DoCurr8(void)
{
  SetCurr(7);
}

void far DoCurr9(void)
{
  SetCurr(8);
}

void far DoCurr10(void)
{
  SetCurr(9);
}

void far GoUp(void)
{
   if ((RowNo > 0) && (RecNo == 0)) { /* first record, middle of screen? */
      RowNo--;
      ShowRows(RecNo, RowNo);
   } else if ((RowNo > 0) && (RecNo > 0)) { /* middle of screen? */
      ShowRowAtIndex(RecNo, RowNo, 0);
      RecNo--; RowNo--;
      ShowRowAtIndex(RecNo, RowNo, 1);
   } else if (RecNo > 0) { /* not at beginning of DB? */
      RecNo--;
      ShowRows(RecNo, RowNo);
   }
}

void far DoUp(void)
{
   GoUp();
   startnumber=1;
   Redisplay();
}

void far GoDown(void)
{
   MaxRecs = depth;
   MaxRows = (MaxRecs >= MaxDisplayableRows()) ? MaxDisplayableRows() : MaxRecs;
   if ((RowNo < MaxRows-1) && (RecNo == MaxRecs-1)) { /* last record, middle of screen? */
      RowNo++;
      ShowRows(RecNo, RowNo);
   } else if ((RowNo < MaxRows-1) && (RecNo < MaxRecs-1)) { /* middle of screen? */
      ShowRowAtIndex(RecNo, RowNo, 0);
      RecNo++; RowNo++;
      ShowRowAtIndex(RecNo, RowNo, 1);
   } else if (RecNo < MaxRecs-1) { /* not at end of DB? */
      RecNo++;
      ShowRows(RecNo, RowNo);
   }
}

void far DoDown(void)
{
   GoDown();
   startnumber=1;
   Redisplay();
}

void far GoPageUp(void)
{
   int TargetRec, TargetRow;

   RowOnPreviousScreen(RecNo, RowNo, &TargetRec, &TargetRow);
   if (IsRowVisible(TargetRow)) { /* minimal redisplay */
      ShowRowAtIndex(RecNo, RowNo, 0);
      ShowRowAtIndex(TargetRec, TargetRow, 1);
      RowNo = TargetRow;
   } else {
      RowNo = NormalizeRow(TargetRow);
      ShowRows(TargetRec, RowNo);
   }
   RecNo = TargetRec;
}

void far DoPageUp(void)
{
   GoPageUp();
   startnumber=1;
   Redisplay();
}

void far GoPageDown(void)
{
   int TargetRec, TargetRow;

   RowOnNextScreen(RecNo, RowNo, &TargetRec, &TargetRow);
   if (IsRowVisible(TargetRow)) { /* minimal redisplay */
      ShowRowAtIndex(RecNo, RowNo, 0);
      ShowRowAtIndex(TargetRec, TargetRow, 1);
      RowNo = TargetRow;
   } else {
      RowNo = NormalizeRow(TargetRow);
      ShowRows(TargetRec, RowNo);
   }
   RecNo = TargetRec;
}

void far DoPageDown()
{
   GoPageDown();
   startnumber=1;
   Redisplay();
}

void far GoHome(void)
{
   if (RecNo > 0) { /* not at beginning already? */
      RecNo = 0;
      RowNo = 0;
      ShowRows(RecNo, RowNo);
   }
}

void far DoHome(void)
{
   GoHome();
   startnumber=1;
   Redisplay();
}

void far GoEnd(void)
{
   MaxRecs = depth;
   MaxRows = (MaxRecs >= MaxDisplayableRows()) ? MaxDisplayableRows() : MaxRecs;
   if (RecNo < MaxRecs-1) { /* not at end already? */
      RecNo = MaxRecs-1;
      RowNo = MaxRows-1;
      ShowRows(RecNo, RowNo);
   }
}

void far DoEnd(void)
{
   GoEnd();
   startnumber=1;
   Redisplay();
}

#if defined(NKIT)
int far DateBHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
   switch (Message) {
      case KEYSTROKE:
         switch(Data) {
            case 0x0d:
            case 0x1b:
            case F10KEY:
               return SendMsg(Window, COMMAND, CMD_ESC, 0);
         }
         break;

      case DESTROY:
         GotoDate(RecNo,-atoi(DateString),0,0);
         break;
   }
   return SubclassMsg(Edit, Window, Message, Data, Extra);
}
#endif

#if defined(NKIT)
int far DateFHandler(PLHWINDOW Window, WORD Message, WORD Data, WORD Extra,...) {
   switch (Message) {
      case KEYSTROKE:
         switch(Data) {
            case 0x0d:
            case 0x1b:
            case F10KEY:
               return SendMsg(Window, COMMAND, CMD_ESC, 0);
         }
         break;

      case DESTROY:
         GotoDate(RecNo,atoi(DateString),0,0);
         break;
   }
   return SubclassMsg(Edit, Window, Message, Data, Extra);
}
#endif

#if defined(NKIT)
int far MyCardHandler(PLHWINDOW Wnd, WORD Message, WORD Data, WORD Extra, ...)
#else
int far MyKeyHandler(WORD Data)
#endif
{
#if defined(NKIT)
  switch (Message) {
    case KEYSTROKE:
      if (Data>='a' && Data<='z')  Data-=32;
#endif

      switch (Data) {
#if defined(NKIT)
        case UPKEY:
#else
        case UP_KEY:
#endif
          DoUp(); return TRUE;

#if defined(NKIT)
        case DOWNKEY:
#else
        case DOWN_KEY:
#endif
          DoDown(); return TRUE;

#if defined(NKIT)
        case LEFTKEY:
        case PAGEUPKEY:
#else
        case LEFT_KEY:
        case PGUP_KEY:
#endif
          DoPageUp(); return TRUE;

#if defined(NKIT)
        case RIGHTKEY:
        case PAGEDOWNKEY:
#else
        case RIGHT_KEY:
        case PGDN_KEY:
#endif
          DoPageDown(); return TRUE;

#if defined(NKIT)
        case HOMEKEY:
#else
        case HOME_KEY:
#endif
          DoHome(); return TRUE;

#if defined(NKIT)
        case ENDKEY:
#else
        case END_KEY:
#endif
          DoEnd(); return TRUE;

#if defined(NKIT)
        case 27:
#else
        case DEL_KEY:
#endif
          if (startnumber)
            DoClear();
          else {
            startnumber=1; MyCursor(0);
          }
          return TRUE;

#if defined(NKIT)
        case 13:
#else
        case ENTER_KEY:
#endif
        case '=':
          if (startnumber) {
            DoAdd();
          } else {
            startnumber=1; MyCursor(0);
          }
          return TRUE;


#if defined(NKIT)
        case 8:
#else
        case BACK_KEY:
#endif
          if (depth && !Transactions[RecNo].Amount)  startnumber=1;

          if (!depth || startnumber) {
            if (depth)
              Transactions[RecNo].Amount=0;
          } else {
            Transactions[RecNo].Amount=Transactions[RecNo].Amount/10;
          }
          Redisplay();
          ShowRowAtIndex(RecNo, RowNo, 1);
          SaveENV();
          return TRUE;

        case 'L':
        case '-':
          if (!depth) return FALSE;

          Transactions[RecNo].Amount=-Transactions[RecNo].Amount;
          Redisplay();
          ShowRowAtIndex(RecNo, RowNo, 1);
          SaveENV();
          return TRUE;

        case '.':
          if (startnumber || !depth) return FALSE;

          startcents=0;
          return TRUE;

        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
          Data -= '0';
          if (startnumber || !depth) {
            if (!depth)
              DoAdd();
            startcents=1;
            Transactions[RecNo].Amount=0;
            Transactions[RecNo].Cents=0;
          }

          if (!startcents) {
            Transactions[RecNo].Cents=(Transactions[RecNo].Cents*10+Data)%100;
          } else {
            Transactions[RecNo].Amount=Transactions[RecNo].Amount*10+Data;
            startnumber=0;
          }
          Redisplay();
          ShowRowAtIndex(RecNo, RowNo, 1);
          SaveENV();
          MyCursor(1);
          return TRUE;

#if defined(PAL)
        case F2_KEY: /* Add */
          DoAdd();
          Redisplay();
          ShowRowAtIndex(RecNo, RowNo, 1);
          SaveENV();
          return TRUE;

        case F3_KEY: /* Category */
          ShowCategoryFKeys();
          Data=GetKey();
          if(Data & 0xff)
             Data &= 0xff;
          switch(Data) {
            case F1_KEY: DoCat1(); break;
            case F2_KEY: DoCat2(); break;
            case F3_KEY: DoCat3(); break;
            case F4_KEY: DoCat4(); break;
            case F5_KEY: DoCat5(); break;
            case F6_KEY: DoCat6(); break;
            case F7_KEY: DoCat7(); break;
            case F8_KEY: DoCat8(); break;
            case F9_KEY: DoCat9(); break;
            case F10_KEY: DoCat10(); break;
          }
          return TRUE;

        case F4_KEY: /* Trip */
          ShowTripFKeys();
          Data=GetKey();
          if(Data & 0xff)
             Data &= 0xff;
          switch(Data) {
            case F1_KEY: DoTrip1(); break;
            case F2_KEY: DoTrip2(); break;
            case F3_KEY: DoTrip3(); break;
            case F4_KEY: DoTrip4(); break;
            case F5_KEY: DoTrip5(); break;
            case F6_KEY: DoTrip6(); break;
            case F7_KEY: DoTrip7(); break;
            case F8_KEY: DoTrip8(); break;
            case F9_KEY: DoTrip9(); break;
            case F10_KEY: DoTrip10(); break;
          }
          return TRUE;

        case F5_KEY: /* Date */
          ShowGotoFKeys();
          Data=GetKey();
          if(Data & 0xff)
             Data &= 0xff;
          switch(Data) {
            case F2_KEY: DoDayM(); break;
            case F3_KEY: DoDayP(); break;
            case F4_KEY: DoToday(); break;
            case F5_KEY: DoMonthM(); break;
            case F6_KEY: DoMonthP(); break;
            case F7_KEY: DoYearM(); break;
            case F8_KEY: DoYearP(); break;
          }
          return TRUE;

        case F6_KEY: /* Account */
          ShowAccountFKeys();
          Data=GetKey();
          if(Data & 0xff)
             Data &= 0xff;
          switch(Data) {
            case F1_KEY: DoAccount1(); break;
            case F2_KEY: DoAccount2(); break;
            case F3_KEY: DoAccount3(); break;
            case F4_KEY: DoAccount4(); break;
            case F5_KEY: DoAccount5(); break;
            case F6_KEY: DoAccount6(); break;
            case F7_KEY: DoAccount7(); break;
            case F8_KEY: DoAccount8(); break;
            case F9_KEY: DoAccount9(); break;
            case F10_KEY: DoAccount10(); break;
          }
          return TRUE;

        case F7_KEY: /* Curr */
          ShowCurrFKeys();
          Data=GetKey();
          if(Data & 0xff)
             Data &= 0xff;
          switch(Data) {
            case F1_KEY: DoCurr1(); break;
            case F2_KEY: DoCurr2(); break;
            case F3_KEY: DoCurr3(); break;
            case F4_KEY: DoCurr4(); break;
            case F5_KEY: DoCurr5(); break;
            case F6_KEY: DoCurr6(); break;
            case F7_KEY: DoCurr7(); break;
            case F8_KEY: DoCurr8(); break;
            case F9_KEY: DoCurr9(); break;
            case F10_KEY: DoCurr10(); break;
          }
          return TRUE;

        case CMD_PURGE:
          DoPurge(); return TRUE;
        case CMD_DEL:
          DoRemove(); return TRUE;
        case CMD_ADD:
          DoAdd(); return TRUE;
#endif
      }
#if defined(NKIT)
      break;

    case DRAW:
       if (Data&DRAW_FRAME) {
          ClearRect(Wnd->x,Wnd->y,Wnd->w,Wnd->h);
       }
       if (Data&DRAW_TITLE) {
         char buffer[64];

         if (depth)
           sprintf(buffer, "%s (%d/%d)", (char *) *(Wnd->Title), RecNo+1, depth);
         else
           sprintf(buffer, "%s", (char *) *(Wnd->Title));
         Rectangle(Wnd->x, Wnd->y, Wnd->w/2, FNTD(FONT_SMALL), 1, G_SOLIDFILL);
         DrawText(Wnd->x+10, Wnd->y, buffer, DRAW_INVERT, FONT_SMALL);
       }
       if (Data&DRAW_CLIENT) {
         ShowHeader();
         ShowRows(RecNo,RowNo);
         Redisplay();
       }
       break;

    }

  SubclassMsg(Object, Wnd, Message, Data, Extra);
#endif
}


#if defined(NKIT)
int ProcessEvent(EVENT_NORM *app_event)
{
    switch (app_event->kind) {      /* Branch on SysMgr event */
      case E_REFRESH:
      case E_ACTIV:
         FixupFarPtrs();
         ReactivateLHAPI(&CapData);
         if (!startnumber && (depth && (Transactions[RecNo].Amount || Transactions[RecNo].Cents)))  MyCursor(1);
         break;

      case E_DEACT:
         MyCursor(0);
         DeactivateLHAPI();
         break;

      case E_TERM:
         FixupFarPtrs();
         Done = TRUE;
         break;

      case E_NONE:
        SendMsg(&TDateTime, DRAW, DRAW_ALL, 0);
        break;

      case E_KEY:
         /* Now send key off to current focus (KeyCode converts gray 101-key */
         /*   arrows/movement scan codes into "normal" scan codes) */
         SendMsg(GetFocus(), KEYSTROKE,
                 /*Fix101Key(*/app_event->data/*,app_event->scan)*/,
                 app_event->scan);   /* Make sure we send the scan code too */
         break;
      }
}
#else
int ProcessEvent(WORD Key)
{
   return MyKeyHandler(Key);
}
#endif



void EventDispatcher(void)
/***
 ***  EventDispatcher grabs events from the System Manager and translates
 ***  them into CAP messages.  Every program will have an Event Dispatcher,
 ***  and the structure should follow this one.
 ***/
{
#if defined(NKIT)
  Done = FALSE;                    /* Set terminate flag to FALSE */

  while (!Done) {                  /* While loop not terminated */
    app_event.do_event = DO_EVENT;

    m_action(&app_event);           /* Grab system manager event */
    ProcessEvent(&app_event);
    }
#else
   WORD Key;

   ShowTopTime("Quick Expenses", FALSE);

   do {
      ShowFKeys(MainFKeys);

      Key = GetKey();
      if(Key & 0xff)
         Key &= 0xff;

      if(Key == MENU_KEY || Key == AF10_KEY || Key == F1_KEY)
         Key = HandleMenu(&TopMenu, 0, 10);

      ProcessEvent(Key);
   } while(Key != ESC_KEY && Key != F10_KEY);
#endif
}


void LoadENV(void)
{
   int handle,e,i;

   startnumber=1;

   if ((handle=open(msgENVName,O_RDONLY | O_BINARY))==-1) goto BadEnv;
   e=read(handle,&depth,sizeof(int));

   /* Couldn't do it properly */
   if (e!=sizeof(int)) {
BadEnv:
      depth=0;
      startnumber=0;
      RowNo=0;
      RecNo=0;
      LastCategory=0;
      LastTrip=0;
      LastAccount=0;
      LastCurr=0;
   } else {
      e=read(handle,&RecNo,sizeof(int));
      e=read(handle,&RowNo,sizeof(int));
      e=read(handle,&LastCategory,sizeof(int));
      e=read(handle,&LastTrip,sizeof(int));
      e=read(handle,&LastAccount,sizeof(int));
      e=read(handle,&LastCurr,sizeof(int));
      for(i=0; i<depth; i++)
        e=read(handle,&(Transactions[i]),sizeof(TRANSACTION));
   }

   close(handle);

   MaxRecs = depth;
   MaxRows = (MaxRecs >= MaxDisplayableRows()) ? MaxDisplayableRows() : MaxRecs;
}


void SaveENV(void)
{
  int handle,e,i;

  if ((handle=open(msgENVName,O_CREAT | O_RDWR | O_BINARY,S_IREAD | S_IWRITE))==-1) return;
  write(handle,&depth,sizeof(int));
  write(handle,&RecNo,sizeof(int));
  write(handle,&RowNo,sizeof(int));
  write(handle,&LastCategory,sizeof(int));
  write(handle,&LastTrip,sizeof(int));
  write(handle,&LastAccount,sizeof(int));
  write(handle,&LastCurr,sizeof(int));
  for(i=0; i<depth; i++) {
     write(handle,&(Transactions[i]),sizeof(TRANSACTION));
  }
  close(handle);
}



void Uninitialize(void)
{
  MyCursor(0);
  SaveENV();
#if defined(NKIT)
  m_fini();
#else
  PalDeInit(1);
#endif
}




void Initialize(void)
{
#if defined(NKIT)
  m_init_app(SYSTEM_MANAGER_VERSION);
  InitializeLHAPI(&CapData);
/* //  m_reg_far(&SysMgrFarPtrs, countof(SysMgrFarPtrs), 0); */

  SetMenuFont(FONT_NORMAL);
  SetDefaultFont(FONT_NORMAL);

/* //  InitResourcedMessages(); */
  FixupFarPtrs();

  m_reg_app_name(msgTestApp);
#else
  if(!PalInit(1))
     FatalExit("Init failed - CGAGRAPH not loaded ?", 1);
#endif

  LoadENV();
  CreateMainView();
#if defined(NKIT)
/*  EnableClock(TRUE); */
#endif
}








void main(void)
/***
 *** C main code
 ***/
{
  Initialize();
  ShowHeader();
  EventDispatcher();
  Uninitialize();
}
