'/* RDUP.BAS Remove  duplicate lines from a sorted text file */
'/*          By: Dale Thorn                                  */
'/*          Rev. 09.07.2002                                 */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = ucase$(rtrim$(command$))         'get the user's command-line parameters
if ccmd = "" then                              'a command line was NOT supplied
   i = ifn.msgs("Usage:  RDUP  filename  offset  comparelen  [/N]", _
                5, 24, 79, 0, 1)
end if                              'display the usage message [above] and exit
ipos1 = instr(ccmd, "/N")               'don't display (except error) messages?
if ipos1 then                                 'user said don't display messages
   imsgdisp = 0                                'set message display flag to OFF
   ccmd = rtrim$(left$(ccmd, ipos1 - 1) + mid$(ccmd, ipos1 + 2))   'remove '/N'
else                                          'user said OK to display messages
   imsgdisp = not 0                             'set message display flag to ON
end if

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse the command-line params
if iprm < 0 or iprm > 1 then            'no. of parameters should be one or two
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1)
end if                      'display no.-of-parameters message [above] and exit

if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)          'invalid filename
end if                       'display invalid-filename message [above] and exit

ioffset = pdqvali(cprm(0)) + 1                     'get the text-compare offset
if ioffset < 1 then                              'text-compare offset NOT valid
   i = ifn.msgs("Invalid compare offset", 5, 24, 79, 1, 1)
end if                         'display compare-offset message [above] and exit
if iprm = 1 then                           'a text-compare length was specified
   icmplen = pdqvali(cprm(1))                      'get the text-compare length
   if icmplen < 1 then                           'text-compare length NOT valid
      i = ifn.msgs("Invalid comparelen", 5, 24, 79, 1, 1)
   end if                      'display compare-length message [above] and exit
else                                   'a text-compare length was NOT specified
   icmplen = 999                        'default the text-compare length to 999
end if

i = ifn.open(1, cfil, "S", llof)       'open the source file in sequential mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
elseif llof = 0 then                          'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if

if cext = "out" then                            'source file extension == "OUT"
   cdst = cnam + ".tmp"                       'set dest.file extension to "TMP"
else                                            'source file extension != "OUT"
   cdst = cnam + ".out"                       'set dest.file extension to "OUT"
end if

if imsgdisp then                              'user said OK to display messages
   i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)            'OK to proceed...
end if

open cdst for output as 2                   'open the destination (output) file
cdup = ""                                          'initialize the compare line
while not eof(1)                               'loop until destination file EOF
   line input #1, clin                         'get a line from the source file
   ctst = ucase$(mid$(clin, ioffset, icmplen))   'get uppercased target segment
   if ctst <> cdup then                'current line differs from previous line
      print #2, clin                       'output the current (different) line
      cdup = ctst                            'save the current (different) line
   end if
wend
close                            'close all files prior to calling BROW program

if imsgdisp then                              'user said OK to display messages
   shell "brow " + cdst                   'browse the destination (output) file
end if
close                                 'close all files in case not closed above
system                                      'return control to operating system
