/*
 * EScan.exm -- Scanner Utility for the ES-300C/GT-6000 (Epson) --
 * Ver 0.4
 * written by Toshiki Sasabe <toshiki@j.email.ne.jp>
 */

#define ESCAN_VERSION "0.4"

#include    "lxapi.h"
#include    "escan.h"
#include    "bmppcx.h"
#include    <stdlib.h>
#include    <dos.h>

#define RESOCOUNT 30
#define RESOLEN 5
#define DEFAULT_RXBUF_SIZE 512
#define FILENAME_PREFIX "PIC"
#define SIGNATURE ('E' + 0x100*'s')		/* = 'Es' */

/* === Global Variables === */

BOOL EnvFileOK=FALSE, RunLxPic=TRUE, DebugMode=FALSE, AreaDefined=FALSE;

/* parameters */
GTSETTINGS Set={0,1,1,1,0x80,0,{100,100},{100,100},{10,10,100,100}};
UCHARXY ZoomTmp;		/* % */
INTXY  ResolutionTmp;	/* DPI */
INTXYWH Area, AreaTmp, 	/* pixel */
        AreaMMTmp;		/*  mm */

/* Values from Scanner info */
int ScannerLevel, ResolutionMax;
INTXY	AreaMax;

int BlockLen, CurrentLine;
UCHAR  StatusByte;
UCHAR	LineColor;		/* from Status byte */

int ColorTableLen;
ULONG ColorTable[0x100]; /* 256 entries max */
	/* 256 for 8 bit, 16 for 4 bit, 2 for 1 bit */
	/* array of (rgbBlue + rgbGreen*0x100 + rgbRed*0x10000L) */
int  Lock, SaveAsIndex=1;
int  TxLength,RxLength,
	 ComHandle, ComPort=COM_LINE_1,
     SetBaudRate, SetComPort, SetParity, SetDataBits, SetStopBits;
ComSettings_t  ComSettings;
int  BmpBitCount, OutBufSize, RxBufSize=DEFAULT_RXBUF_SIZE;
ULONG DataSize;
UCHAR  DefaultRxBuf[DEFAULT_RXBUF_SIZE],TxBuf[16], DepthConv[0x100];
UCHAR  *RxBuf=DefaultRxBuf, *OutBuf;
char *ErrMsg;
char StatusStr[80],ColorStatusStr[64], AreaStatusStr[64],CommandStr[24],
	 ResoXStr[RESOLEN], ResoYStr[RESOLEN],
	 ZoomXStr[6], ZoomYStr[6],
	 SaveDir[64], SaveAsStr[10], SaveFileSpec[80],
	 ScanXStr[6], ScanYStr[6], ScanWStr[6], ScanHStr[6],
	 ScanXPixelStr[6], ScanYPixelStr[6], ScanWPixelStr[6], ScanHPixelStr[6],
	 SaveFormatStr[4], ImageDepthStr[2], BrightnessStr[4],
	 GammaCorrStr[25], ColorCorrStr[25],
	 ColorModeStr[24], DropOutStr[24], DitherStr[12],
	 ParityStr[8], ErrorDispBuf[64];

/* resolution list buffer */
int ResolutionList[RESOCOUNT];
char *ResolutionStrList[RESOCOUNT];
char ResolutionSpace[RESOCOUNT*RESOLEN];
int ResolutionListLen;

/* for listboxes */
char *SaveFormatList[]= { "BMP","ICN","PCX"};
#define SAVE_BMP (0)
#define SAVE_ICN (1)
#define SAVE_PCX (2)

char *RGBList[]= {"-None-","Red","Green","Blue"};
char *ColorModeList[]= {
  "Monochrome",
  "Color (3 scans)",
  "Color (1 scan)"
};
char *GammaList[]= {
  "CRT-A (No Correction)",
  "CRT-B",
  "Printer-A (High res)",
  "Printer-B (Low res)",
  "Printer-C (Mixed image)"
};
UCHAR GammaParam[]={0x01, 0x02, 0x00, 0x10, 0x20};
char *DitherList[]= {
  "-None-",
  "A. Normal",
  "B. Soft",
  "C. Halftone"
};
UCHAR DitherParam[]= {0x01, 0x00, 0x10, 0x20 };
char *ColorCorrectionList[] = {
  "-None-",
  "Impact Printer",
  "Thermal Printer",
  "Inkjet Printer",
  "CRT Display"
};
UCHAR ColorCorrectionParam[]= {0x00,0x10, 0x20, 0x40, 0x80};
char *BrightnessList[]= {"+3","+2", "+1", " 0", "-1", "-2", "-3" };
char BrightnessParam[]= {3,2,1,0,-1,-2,-3};
char *DepthList[]= {"8","7","6","5","4","3","2","1"};
char DepthParam[]= {8,7,6,5,4,3,2,1};
char *ParityList[]= {"None","Odd","Even","Mark","Space"};
char ParityParam[]= {COM_PTY_NO, COM_PTY_ODD, COM_PTY_EVEN,
		COM_PTY_MARK, COM_PTY_SPACE};
FILE OutFile;

/* == Events == */
EVENT  app_event;
LHAPIBLOCK  LHAPIData;
BOOL  Done;

/* == FAR STRINGS === */
char far *msgnull=  "";
char far *msgAppName=   "EScan";
char far *msgTitle= 	"EScan " ESCAN_VERSION
						"  \021 Scan Utility for the ES-300C/GT-6000 \020";
char far *msg_About=	"&About EScan";
char far *msgAbout=		"About This Program";
char far *msgAboutMsg=	"Built on " __TIME__ " " __DATE__ ".\n"
			"Copyright (c) Toshiki Sasabe <toshiki@j.email.ne.jp>.\n"
			"EScan is a copyrighted freeware. Please refer to "
			"EScan.DOC for its copyright notices and distribution policy.";
char far *msgStatus_=   "Status:";
char far *msgImageInfo=	"Image information:";
char far *msgWriteTo=   "Writing to:";
char far *msgScanning=	"Scanning";
char far *msgCommand=	"Command:";
char far *msgSaveAs=	"Save &as";
char far *msgFormat=	"&Format";
char far *msgResolution=	"&Resolution";
char far *msgScanFrom=	"Scan from";
char far *msgScanArea=	"Scan area";
char far *msgX=			"X";
char far *msgY=			"Y";
char far *msg_X=		"&X";
char far *msg_Y=		"&Y";
char far *msg_W=		"&W";
char far *msg_H=		"&H";
char far *msg_Zoom=		"&Zoom(%)";
char far *msgStart=		"Start";
char far *msgColor=		"Color";
char far *msgArea=		"Area";
char far *msgReset=		"Reset";
char far *msgPixel_=	"pixel)";
char far *msgMm_=		"mm (";
char far *msgLock_X_Y=	"&Lock X=Y";
char far *msgReso=		"Reso";
char far *msgZoom=		"Zoom";
char far *msgDropOut=	"D&rop Out";
char far *msgDepth=		"&Image Depth";
char far *msgDither=	"&Dither";
char far *msgBrightness=	"&Brightness";
char far *msgGammaCorr=	"&Gamma Correction";
char far *msgColorCorr=	"&Color Correction";
char far *msgColorMode=	"Color &Mode";
char far *msgOtherSettings=  "Other settings";
char far *msgScan_Area=	"Scan &Area\tF8";
char far *msgScan_Color=	"Scan &Color\tF7";
char far *msg_Start=	"&Start\tF9";
char far *msg_Reset=	"&Reset\tF3";
char far *msg_Action=	"&Action";
char far *msgMessage=   "Message";
char far *msgQuit=      "Quit";
char far *msg_Quit=     "&Quit";
char far *msg_Help=     "&Help";
char far *msgE_xit=     "E&xit\tF10";
char far *msg_Option=	"&Option";
char far *msg_Other=        "&Other";
char far *msg_Communication=    "&Communication";
char far *msgDirectory=    "&Directory for data storage:";
char far *msgLxPic=		"Use &LxPic for viewing";
char far *msgOK=        "OK";
char far *msgCancel=    "Cancel";
char far *msg_Cancel=   "&Cancel";
char far *msgComSet=	"Communication Settings";
char far *msg_Baud=		"&Baud";
char far *msg300=		"300";
char far *msg1200=		"1200";
char far *msg2400=		"2400";
char far *msg4800=		"4800";
char far *msg9600=		"9600";
char far *msg19200=		"19200";
char far *msg38400=		"38400";
char far *msg57600=		"57600";
char far *msg115200=	"115200";
char far *msg_Interface=	"&Interface";
char far *msgCOM1=		"Com1";
char far *msgCOM2=		"Com2";
char far *msgAlternate=	"Alternate";
char far *msgInfrared=	"Infrared";
char far *msg_Parity=	"&Parity:";
char far *msg_DataBits=	"&Data Bits";
char far *msg8=			"8";
char far *msg7=			"7";
char far *msg_StopBits=	"&Stop Bits";
char far *msg2=			"2";
char far *msg1=			"1";
char far *msgFileAlready=	"File Already Exists";
char far *msgReplace=	"Replace existing file?";
char far *EnvFile ="C:\\_DAT\\ESCAN.ENV";
char far *RxBufPtr=DefaultRxBuf;
char far *TxBufPtr=TxBuf;
char far *TxLengthPtr=(char *)&TxLength;
char far *RxLengthPtr=(char *)&RxLength;
char far *ComSetPtr=(char *)&ComSettings;

/* == END FAR STRINGS === */

/* === STRING TABLE === */
char far **StringTable[]={
  &msgnull,
  &msgAppName,
  &msgTitle,
  &msg_About,
  &msgAbout,
  &msgAboutMsg,
  &msgStatus_,
  &msgImageInfo,
  &msgWriteTo,
  &msgScanning,
  &msgCommand,
  &msgSaveAs,
  &msgFormat,
  &msgResolution,
  &msgScanFrom,
  &msgScanArea,
  &msgX,
  &msgY,
  &msg_X,
  &msg_Y,
  &msg_W,
  &msg_H,
  &msg_Zoom,
  &msgStart,
  &msgColor,
  &msgArea,
  &msgReset,
  &msgPixel_,
  &msgMm_,
  &msgLock_X_Y,
  &msgReso,
  &msgZoom,
  &msgDropOut,
  &msgDepth,
  &msgDither,
  &msgBrightness,
  &msgGammaCorr,
  &msgColorCorr,
  &msgColorMode,
  &msgOtherSettings,
  &msgScan_Area,
  &msgScan_Color,
  &msg_Start,
  &msg_Reset,
  &msg_Action,
  &msgMessage,
  &msgQuit,
  &msg_Quit,
  &msg_Help,
  &msgE_xit,
  &msg_Option,
  &msg_Other,
  &msg_Communication,
  &msgDirectory,
  &msgLxPic,
  &msgOK,
  &msgCancel,
  &msg_Cancel,
  &msgComSet,
  &msg_Baud,
  &msg300,
  &msg1200,
  &msg2400,
  &msg4800,
  &msg9600,
  &msg19200,
  &msg38400,
  &msg57600,
  &msg115200,
  &msg_Interface,
  &msgCOM1,
  &msgCOM2,
  &msgAlternate,
  &msgInfrared,
  &msg_Parity,
  &msg_DataBits,
  &msg8,
  &msg7,
  &msg_StopBits,
  &msg2,
  &msg1,
  &msgFileAlready,
  &msgReplace,
  &EnvFile,
  &RxBufPtr,
  &TxBufPtr,
  &TxLengthPtr,
  &RxLengthPtr,
  &ComSetPtr
};
/* === END STRING TABLE === */


/* === PROTOTYPES === */
void DispStatusStr(char *p);
void  DispCommandStr();
void far OpenScanColorDialog(void);
void ConvertColorParam(void);
void ReconvertColorParam(void);
void far OpenScanAreaDialog(void);
void far OpenOtherOptionDialog(void);
void far OpenComOptionDialog(void);
void OpenFileReplaceDialog();
void far OpenDispMsgDialog(void);
void far OpenAboutDialog(void);
void far HourglassOn(int x, int y);
void far HourglassOff(void);
void FixupFarPtrs(void);
void far DoQuit(void);
void far Test(void);
void DispReady(int result);
void far ScanStart(void);
void PixelCalcInit(void);
void PixelCalc(void);
void SetupResolutionList(void);
void SyncResolution(void);
void SetColorStatusStr(void);
char *GetDitherStr(int n);
void SetAreaStatusStr(void);
int GetFileIndex(int currentindex);
int FileExist(char *filespec);
void ReadConfig(void);
void WriteConfig(void);
void far DoNothing(void);
int far Scan(void);
void ResetMeter();
void UpdateMeter(int x);
int OpenSaveFile(void);
int WriteToFile(int n);
void CloseSaveFile(void);
int ReadPrevScanData(void);
int SendAllParam(void);
int GetInfo(void);
int ResetScanner(void);
void far InitScanner(void);
int SendParam(int len);
int ReceiveOneBlock(UCHAR cmd);
int ReceiveBlock(void);
int ComInit(void);
void ComSetDefault(void);
int snd(int DataLength);
int rcv(int DataLength);
void PutImg(int xpos, int ypos, int rule, UCHAR *buf);
void ConvertMonoBmp();
void ConvertColorBmp();
UINT EncodeLine(BYTE *dst, BYTE *src, UINT width);
void InitDepthConv(int outbit, int inbit);
void ErrorDisp(int errornumber);
void LxPic(char *filespec);
int EscKeyCheck(void);
void Pause(int n);
void InitList(void);
void main(void);
/* === END PROTOTYPES === */

/* LH Window structures */

/* Function Keys */

LHFKEY MainFKeys[]= {
 {(PLHRES)&msgnull,(PLHFUNC)Test,FKEY_SHIFT+1,0},
 {(PLHRES)&msgReset,(PLHFUNC)InitScanner,3,0},
 {(PLHRES)&msgColor,(PLHFUNC)OpenScanColorDialog,7,0},
 {(PLHRES)&msgArea,(PLHFUNC)OpenScanAreaDialog,8,0},
 {(PLHRES)&msgStart,(PLHFUNC)ScanStart,9,0},
 {(PLHRES)&msgQuit,(PLHFUNC)DoQuit,10+FKEY_LAST,0}
};

LHFKEY OKCancelFKeys[]= {
 {(PLHRES)&msgCancel,(PLHFUNC)CMD_ESC,9,FKEY_SENDMSG},
 {(PLHRES)&msgOK,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG}
};

LHFKEY OKFKeys[]= {
 {(PLHRES)&msgOK,(PLHFUNC)CMD_DONE,10+FKEY_LAST,FKEY_SENDMSG}
};

/* === Menu === */

LHMENU ActionMenu[]= {
 {(PLHRES)&msg_Start,(PLHFUNC)ScanStart,0,0},
 {(PLHRES)&msgScan_Area,(PLHFUNC)OpenScanAreaDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msgScan_Color,(PLHFUNC)OpenScanColorDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_Reset,(PLHFUNC)InitScanner,0,0},
 {(PLHRES)&msgE_xit,(PLHFUNC)DoQuit,0,MENU_BARBEFORE},
 {0,0,0,0}
};

LHMENU OptionMenu[]= {
 {(PLHRES)&msg_Communication,(PLHFUNC)OpenComOptionDialog,0,MENU_ELLIPSIS},
 {(PLHRES)&msg_Other,(PLHFUNC)OpenOtherOptionDialog,0,MENU_ELLIPSIS},
 {0,0,0,0}
};

LHMENU HelpMenu[]= {
 {(PLHRES)&msg_About,(PLHFUNC)OpenAboutDialog,0,MENU_ELLIPSIS},
 {0,0,0,0}
};


LHMENU MainMenu[]= {
 {(PLHRES)&msg_Action,(PLHFUNC)ActionMenu,0,MENU_PULLDOWN},
 {(PLHRES)&msg_Option,(PLHFUNC)OptionMenu,0,MENU_PULLDOWN},
 {(PLHRES)&msg_Quit,(PLHFUNC)DoQuit,0},
 {(PLHRES)&msg_Help,(PLHFUNC)HelpMenu,0,MENU_PULLDOWN},
 {0,0,0,0}
};

/* Datetime & Title Windows */

LHWINDOW TDateTime = {
	DateTime,0,0,0,0,
	0,0,0,STYLE_DATETIME|STYLE_NOFOCUS,
	NULL,PARENT_FKEYS,PARENT_MENU,NO_HELP};

LHWINDOW MainTitle = {
	TitleBar,0,0,0,0,
	(PLHRES)&msgTitle,0,0,STYLE_NOFOCUS,
	NULL,PARENT_FKEYS,(PLHMENU)&TDateTime,NO_HELP};


/* === Main === */

int far MainHandler(PLHWINDOW, WORD, WORD, WORD,...);

#define ODOMETER MainArray[4]
#define WRITE_TO MainArray[5]

LHWINDOW MainArray[]={
 {  StaticText, 15, 10, 54, 1,						/* 0 */
	(PLHRES)&msgStatus_, (PLHDATA)StatusStr, 0,
	STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 15, 10+17, 0, 1,					/* 1 */
	(PLHRES)&msgImageInfo, NULL, 0,
	STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 65, 10+2*17, 57, 1,					/* 2 */
	(PLHRES)&msgnull, (PLHDATA)ColorStatusStr, 60,
	STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 65, 10+3*17, 57, 1,					/* 3 */
	(PLHRES)&msgnull, (PLHDATA)AreaStatusStr, 60,
	STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {	ProgressMeter, 15, 90, 27, 2,					/* 4 */
	(PLHRES)&msgScanning, NULL, 100,
    STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 15, 90+2*17, 50, 1,					/* 5 */
	(PLHRES)&msgWriteTo, NULL, 60,
	STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 15, 90+4*17, 24, 1,					/* 6 */
	(PLHRES)&msgCommand, (PLHDATA)CommandStr, 0,
	STYLE_NOBORDER|STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP }
};

LHWINDOW MainDialog={
	(PLHCLASS)MainHandler,0,9,640,182,
	(PLHRES)&msgnull,(PLHDATA)MainArray,countof(MainArray),
	STYLE_NOSHADOW,
	NULL,MainFKeys,MainMenu,NO_HELP
};

int far MainHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  if(Msg==DESTROY) return TRUE;		/* shouldn't be destroyed */
  if(Msg==CREATE) {
	;
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void DispStatusStr(char *p)
{
  if(*p != '\0') strcpy(StatusStr, p);
  SendMsg(&MainArray[0], DRAW, DRAW_CLIENT, 0);
}

/*p*/
void  DispCommandStr()
{
  SendMsg(&MainArray[6], DRAW, DRAW_CLIENT, 0);
}



/* === ScanColor === */

int far ScanColorHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

#define DROPOUT_COMBOBOX	ScanColorArray[4]
#define DITHER_COMBOBOX		ScanColorArray[10]
#define COLORCORR_TITLE		ScanColorArray[18]
#define COLORCORR_COMBOBOX	ScanColorArray[19]

#define COLOR_MONO		ScanColorArray[2].Selection
#define DROPOUT_COLOR	ScanColorArray[5].Selection
#define IMAGEDEPTH		ScanColorArray[8].Selection
#define DITHER			ScanColorArray[11].Selection
#define BRIGHTNESS		ScanColorArray[14].Selection
#define GAMMA_CORRECTION	ScanColorArray[17].Selection
#define COLOR_CORRECTION	ScanColorArray[20].Selection


LHWINDOW ScanColorArray[]={
/* Color Mode  */
 {  StaticText, 10, 20+2, 0, 1,							/* 0 */
	(PLHRES)&msgColorMode, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+110, 20, 15, 1,						/* 1 */
	(PLHRES)&msgnull, (PLHDATA)ColorModeStr, 16,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT|STYLE_NOTIFY,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanColorArray[2], NO_HELP},
 {  ListBox, 0, 0, 15, 3,								/* 2 */
 	NULL, (PLHDATA)&ColorModeList, 3,
	STYLE_WHCHAR|STYLE_NOTIFY,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

/* Drop-out Color  */
 {  StaticText, 10+110+160+20, 20+2, 0, 1,				/* 3 */
	(PLHRES)&msgDropOut, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+110+160+20+90, 20, 6, 1,				/* 4 */
	(PLHRES)&msgnull, (PLHDATA)DropOutStr, 7,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanColorArray[5], NO_HELP},
 {  ListBox, 0, 0, 6, 4,								/* 5 */
 	NULL, (PLHDATA)&RGBList, 4,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

/* Image Depth */
 {  StaticText, 10, 37+2, 0, 1,							/* 6 */
	(PLHRES)&msgDepth, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+120, 37, 1, 1,							/* 7 */
	(PLHRES)&msgnull, (PLHDATA)ImageDepthStr, 2,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT|STYLE_NOTIFY,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanColorArray[8], NO_HELP},
 {  ListBox, 0, 0, 1, 8,								/* 8 */
 	NULL, (PLHDATA)&DepthList, 8,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

/* Dither */
 {  StaticText, 180, 37+2, 0, 1,						/* 9 */
	(PLHRES)&msgDither, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 180+70, 37, 11, 1,						/* 10 */
	(PLHRES)&msgnull, (PLHDATA)DitherStr, 10,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanColorArray[11], NO_HELP},
 {  ListBox, 0, 0, 11, 4,								/* 11 */
 	NULL, (PLHDATA)&DitherList, 4,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

/* Brightness */
 {  StaticText, 10, 54+2, 0, 1,						/* 12 */
	(PLHRES)&msgBrightness, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+110, 54, 2, 1,							/* 13 */
	(PLHRES)&msgnull, (PLHDATA)BrightnessStr, 3,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanColorArray[14], NO_HELP},
 {  ListBox, 0, 0, 2, 7,								/* 14 */
 	NULL, (PLHDATA)&BrightnessList, 7,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

/* Gamma Correction */
 {  StaticText, 10, 71+2, 0, 1,							/* 15 */
	(PLHRES)&msgGammaCorr, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+170, 71, 24, 1,						/* 16 */
	(PLHRES)&msgnull, (PLHDATA)GammaCorrStr, 3,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanColorArray[17], NO_HELP},
 {  ListBox, 0, 0, 24, 5,								/* 17 */
 	NULL, (PLHDATA)&GammaList, 5,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

/* Color Correction */
 {  StaticText, 10, 88+2, 0, 1,							/* 18 */
	(PLHRES)&msgColorCorr, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+170, 88, 19, 1,						/* 19 */
	(PLHRES)&msgnull, (PLHDATA)ColorCorrStr, 3,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanColorArray[20], NO_HELP},
 {  ListBox, 0, 0, 19, 5,								/* 20 */
 	NULL,(PLHDATA)&ColorCorrectionList, 5,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

 {  PushButton, 330, 110, 0, 0,
	(PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  PushButton, 420, 110, 0, 0,
	(PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW ScanColorDialog={
	(PLHCLASS)ScanColorHandler,XY_CENTER(520,150),
	(PLHRES)&msgColor,
	(PLHDATA)ScanColorArray,countof(ScanColorArray),
	STYLE_PUSHB_WIDTH,
	NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far ScanColorHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int i;

/* if(Msg==NOTIFY && Data==NOTIFY_CHILDCHANGED) { */
 if(Msg==KEYSTROKE) {
   if (COLOR_MONO!=MONOCHROME_MODE) {
     if ( DROPOUT_COLOR != DROPOUT_NONE ) {
       DROPOUT_COLOR = DROPOUT_NONE;
       SendMsg( &DROPOUT_COMBOBOX, NOTIFY, NOTIFY_CHILDCHANGED, 0);
     }
     DROPOUT_COMBOBOX.Style |= STYLE_NOFOCUS;
     COLORCORR_COMBOBOX.Style &= ~STYLE_NOFOCUS;
     COLORCORR_TITLE.Style &= ~STYLE_GRAY;
   } else {				/* = Color Mode */
     DROPOUT_COMBOBOX.Style &= ~STYLE_NOFOCUS;
     if ( COLOR_CORRECTION != 0 ) {
       COLOR_CORRECTION = 0;
       SendMsg( &COLORCORR_COMBOBOX, NOTIFY, NOTIFY_CHILDCHANGED, 0);
     }
     COLORCORR_COMBOBOX.Style |= STYLE_NOFOCUS;
     COLORCORR_TITLE.Style |= STYLE_GRAY;
   }
   switch(atoi(ImageDepthStr)) {
     case 1:
     case 2:
       DITHER_COMBOBOX.Style &= ~STYLE_NOFOCUS;
       break;
     default:
       if ( DITHER != 0 ) {
       DITHER = 0;
       SendMsg( &DITHER_COMBOBOX, NOTIFY, NOTIFY_CHILDCHANGED, 0);
       }
       DITHER_COMBOBOX.Style |= STYLE_NOFOCUS;
   }
 }
 if(Msg==KEYSTROKE && Data==F10KEY) {      /* Done */
   ConvertColorParam();
   SetColorStatusStr();
   Msg=COMMAND; Data=CMD_ESC;
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenScanColorDialog(void)
{
 SendMsg( &ScanColorDialog, CREATE, CREATE_FOCUS, 0 );
}

/*p*/
void ConvertColorParam(void)
{
  Set.ColorMode= (UCHAR)( COLOR_MONO + 0x10 * DROPOUT_COLOR );
  Set.ImageDepth= DepthParam[IMAGEDEPTH];
  Set.DitherSetting= DitherParam[DITHER];
  Set.Brightness= BrightnessParam[BRIGHTNESS];
  Set.GammaSetting= GammaParam[GAMMA_CORRECTION];
  Set.ColorCorrection= ColorCorrectionParam[COLOR_CORRECTION];
}

/*p*/
void ReconvertColorParam(void)
{
  int i;

  COLOR_MONO= Set.ColorMode&0x0F;
  DROPOUT_COLOR= (Set.ColorMode&0xF0)>>4;
  for (i=0; i<countof(DepthParam); i++)
    if (DepthParam[i]==Set.ImageDepth) IMAGEDEPTH=i;
  for (i=0; i<countof(DitherParam); i++)
    if (DitherParam[i]==Set.DitherSetting)  DITHER=i;
  for (i=0; i<countof(BrightnessParam); i++)
    if (BrightnessParam[i]==Set.Brightness) BRIGHTNESS=i;
  for (i=0; i<countof(GammaParam); i++)
    if (GammaParam[i]==Set.GammaSetting) GAMMA_CORRECTION=i;
  for (i=0; i<countof(ColorCorrectionParam); i++)
    if (ColorCorrectionParam[i]==Set.ColorCorrection) COLOR_CORRECTION=i;
}


/* === ScanArea === */

int far ScanAreaHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

#define SAVEFORMAT_LISTBOX	ScanAreaArray[3]
#define RESO_X_LISTBOX	ScanAreaArray[7]
#define RESO_Y_COMBOBOX	ScanAreaArray[9]
#define RESO_Y_LISTBOX	ScanAreaArray[10]
#define ZOOM_Y_EDITBOX	ScanAreaArray[13]
#define PIXEL_ARRAY_INDEX 20

LHWINDOW ScanAreaArray[]={
/* save file */
 {  Edit, 10, 20, 8, 1,									/* 0 */
	(PLHRES)&msgSaveAs, (PLHDATA)SaveAsStr, 9,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, PARENT_MENU, NO_HELP },
 {  StaticText, 10+180, 20+2, 0, 1,						/* 1 */
	(PLHRES)&msgFormat, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+250, 20, 3, 1,							/* 2 */
	(PLHRES)&msgnull, (PLHDATA)SaveFormatStr, 4,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanAreaArray[3], NO_HELP},
 {  ListBox, 0, 0, 3, 3,								/* 3 */
 	NULL, (PLHDATA)&SaveFormatList, 3,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

/* resolution & zoom */
 {  StaticText, 10, 20+17+8+2, 0, 1,					/* 4 */
	(PLHRES)&msgResolution, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10+110, 20+17+2, 0, 1,					/* 5 */
	(PLHRES)&msgX, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+130, 20+17, 4, 1,						/* 6 */
	(PLHRES)&msgnull, (PLHDATA)ResoXStr, 20,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanAreaArray[7], NO_HELP},
 {  ListBox, 0, 0, 4, 7,								/* 7 */
 	NULL, (PLHDATA)&ResolutionStrList, 0,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

 {  StaticText, 10+110, 20+2*17+2, 0, 1,				/* 8 */
	(PLHRES)&msgY, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 10+130, 20+2*17, 4, 1,					/* 9 */
	(PLHRES)&msgnull, (PLHDATA)ResoYStr, 20,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ScanAreaArray[10], NO_HELP},
 {  ListBox, 0, 0, 4, 7,								/* 10 */
 	NULL, (PLHDATA)&ResolutionStrList, 0,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

 {  StaticText, 210, 20+17+8+2, 0, 1,					/* 11 */
	(PLHRES)&msg_Zoom, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 290, 20+17, 4, 1,								/* 12 */
	(PLHRES)&msgX, (PLHDATA)ZoomXStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  Edit, 290, 20+2*17, 4, 1,							/* 13 */
	(PLHRES)&msgY, (PLHDATA)ZoomYStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

/* Scan Area */
 {  StaticText, 10, 20+3*17+8+2, 0, 1,					/* 14 */
	(PLHRES)&msgScanFrom, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 10+110, 20+3*17, 4, 1,						/* 15 */
	(PLHRES)&msg_X, (PLHDATA)ScanXStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 10+110, 20+4*17, 4, 1,						/* 16 */
	(PLHRES)&msg_Y, (PLHDATA)ScanYStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10, 20+5*17+8+2, 0, 1,					/* 17 */
	(PLHRES)&msgScanArea, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 10+110, 20+5*17, 4, 1,						/* 18 */
	(PLHRES)&msg_W, (PLHDATA)ScanWStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 10+110, 20+6*17, 4, 1,						/* 19 */
	(PLHRES)&msg_H, (PLHDATA)ScanHStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  StaticText, 10+110+70, 20+3*17+2, 4, 1,				/* 20 */
	(PLHRES)&msgMm_, (PLHDATA)ScanXPixelStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10+110+70, 20+4*17+2, 4, 1,				/* 21 */
	(PLHRES)&msgMm_, (PLHDATA)ScanYPixelStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10+110+70, 20+5*17+2, 4, 1,				/* 22 */
	(PLHRES)&msgMm_, (PLHDATA)ScanWPixelStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10+110+70, 20+6*17+2, 4, 1,				/* 23 */
	(PLHRES)&msgMm_, (PLHDATA)ScanHPixelStr, 5,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },

 {  StaticText, 10+110+170, 20+3*17, 0, 1,				/* 24 */
	(PLHRES)&msgPixel_, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10+110+170, 20+4*17, 0, 1,				/* 25 */
	(PLHRES)&msgPixel_, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10+110+170, 20+5*17, 0, 1,				/* 26 */
	(PLHRES)&msgPixel_, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  StaticText, 10+110+170, 20+6*17, 0, 1,				/* 27 */
	(PLHRES)&msgPixel_, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },

 {  GroupBox, 380, 20, 100, 55,
    (PLHRES)&msgLock_X_Y, NULL, 0,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  CheckBox, 380+20, 20+17, 0, 0,						/* 29 */
 	(PLHRES)&msgReso, (PLHDATA)&Lock, LOCK_RESOLUTION,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  CheckBox, 380+20, 20+17*2, 0, 0,						/* 30 */
 	(PLHRES)&msgZoom, (PLHDATA)&Lock, LOCK_ZOOM,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  PushButton, 410, 83, 0, 0,
	(PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  PushButton, 410, 112, 0, 0,
	(PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP }

};

LHWINDOW ScanAreaDialog={
	(PLHCLASS)ScanAreaHandler,XY_CENTER(510,150),
	(PLHRES)&msgArea,
	(PLHDATA)ScanAreaArray,countof(ScanAreaArray),
	STYLE_PUSHB_WIDTH,
	NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far ScanAreaHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int i;

 if(Msg==CREATE) {
   if (COLOR_MONO==MONOCHROME_MODE) {
	 SAVEFORMAT_LISTBOX.LogicalSize=3;		/* BMP ICN PCX */
   } else {
	 SAVEFORMAT_LISTBOX.LogicalSize=1;		/* BMP only */
	 if (SAVEFORMAT_LISTBOX.Selection!=0)
		SAVEFORMAT_LISTBOX.Selection=0;		/* force BMP */
   }
   /* Initial */
   sprintf(ZoomXStr,"%3d", Set.Zoom.x);
   sprintf(ZoomYStr,"%3d", Set.Zoom.y);
   sprintf(ScanXStr,"%4d", Set.AreaMM.x);
   sprintf(ScanYStr,"%4d", Set.AreaMM.y);
   sprintf(ScanWStr,"%4d", Set.AreaMM.w);
   sprintf(ScanHStr,"%4d", Set.AreaMM.h);
   PixelCalc();

 }
 if(Msg==KEYSTROKE) {
   if (Lock&LOCK_RESOLUTION) {
     RESO_Y_COMBOBOX.Style |= STYLE_NOFOCUS;
     if ( RESO_Y_LISTBOX.Selection != RESO_X_LISTBOX.Selection )
		RESO_Y_LISTBOX.Selection = RESO_X_LISTBOX.Selection;
		SendMsg(&RESO_Y_COMBOBOX, NOTIFY, NOTIFY_CHILDCHANGED, 0);
   } else {
     RESO_Y_COMBOBOX.Style &= ~STYLE_NOFOCUS;
   }
   if (Lock&LOCK_ZOOM) {
     ZOOM_Y_EDITBOX.Style |= STYLE_NOFOCUS;
     if ( atoi(ZoomYStr) != atoi(ZoomXStr) ) {
       strcpy(ZoomYStr, ZoomXStr);
	   SendMsg(&ZOOM_Y_EDITBOX, DRAW, DRAW_CLIENT, 0);
     }
   } else {
     ZOOM_Y_EDITBOX.Style &= ~STYLE_NOFOCUS;
   }
   PixelCalc();
   for(i=0; i<4; i++)
	 SendMsg( &ScanAreaArray[PIXEL_ARRAY_INDEX+i], DRAW, DRAW_CLIENT, 0);
 }
 if(Msg==KEYSTROKE && Data==F10KEY) {      /* Done */
	Set.Resolution.x=ResolutionTmp.x; Set.Resolution.y=ResolutionTmp.y;
	Set.Zoom.x=ZoomTmp.x; Set.Zoom.y=ZoomTmp.y;
	Area.x=AreaTmp.x; Area.y=AreaTmp.y;
	Area.w=AreaTmp.w; Area.h=AreaTmp.h;
	Set.AreaMM.x=AreaMMTmp.x; Set.AreaMM.y=AreaMMTmp.y;
	Set.AreaMM.w=AreaMMTmp.w; Set.AreaMM.h=AreaMMTmp.h;

	SetAreaStatusStr();
	AreaDefined=TRUE;

	sprintf(SaveFileSpec, "%s%s.%s", SaveDir, SaveAsStr,SaveFormatStr);
	if ( FileExist(SaveFileSpec)) {
	  OpenFileReplaceDialog();
	  return TRUE;
	} else {
	  Msg=COMMAND; Data=CMD_ESC;
	}
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenScanAreaDialog(void)
{
   SendMsg( &ScanAreaDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === OtherOption === */

int far OtherOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW OtherOptionArray[]={
 {  StaticText, 10, 25, 0, 1,
	(PLHRES)&msgDirectory, NULL, 0,
	STYLE_WHCHAR|STYLE_NOBORDER|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  Edit, 10, 42, 30, 1,
	(PLHRES)&msgnull, (PLHDATA)SaveDir, 64,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  CheckBox, 10, 70, 0, 0,
	(PLHRES)&msgLxPic, (PLHDATA)&RunLxPic, TRUE,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },

 {  PushButton, 345, 60, 0, 0,
	(PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 345, 90, 0, 0,
	(PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW OtherOptionDialog={
	(PLHCLASS)OtherOptionHandler,XY_CENTER(440,135),
	(PLHRES)&msgOtherSettings,
	(PLHDATA)OtherOptionArray,countof(OtherOptionArray),
	STYLE_PUSHB_WIDTH,
	NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far OtherOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
 int n;
 if(Msg==KEYSTROKE && Data==F10KEY) {       /* Done */
   n=strlen(SaveDir);
   if (SaveDir[n-1] != '\\') {
	SaveDir[n]='\\';
	SaveDir[n+1]='\0';
   }
   SaveAsIndex=GetFileIndex(SaveAsIndex);
   sprintf(SaveAsStr, FILENAME_PREFIX "%03d", SaveAsIndex);

   Msg=COMMAND;
   Data=CMD_ESC;
 }
 return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenOtherOptionDialog(void)
{
 SendMsg( &OtherOptionDialog, CREATE, CREATE_FOCUS, 0 );
}


/* === ComOption === */

int far ComOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);
#define PARITY_LISTBOX ComOptionArray[17]

LHWINDOW ComOptionArray[]={
 {  GroupBox, 15, 15, 260, 70,								/* 0 */
	(PLHRES)&msg_Baud, NULL, 0,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 15, 4, 1,								/* 1 */
	(PLHRES)&msg300, (PLHDATA)&SetBaudRate, COM_BR_300,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 15+17, 4, 1,							/* 2 */
	(PLHRES)&msg1200, (PLHDATA)&SetBaudRate, COM_BR_1200,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 15+2*17, 4, 1,							/* 3 */
	(PLHRES)&msg2400, (PLHDATA)&SetBaudRate, COM_BR_2400,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+80, 15, 4, 1,								/* 4 */
	(PLHRES)&msg4800, (PLHDATA)&SetBaudRate, COM_BR_4800,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+80, 15+17, 4, 1,							/* 5 */
	(PLHRES)&msg9600, (PLHDATA)&SetBaudRate, COM_BR_9600,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+80, 15+2*17, 4, 1,							/* 6 */
	(PLHRES)&msg19200, (PLHDATA)&SetBaudRate, COM_BR_19200,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+2*80, 15, 4, 1,								/* 7 */
	(PLHRES)&msg38400, (PLHDATA)&SetBaudRate, COM_BR_38400,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+2*80, 15+17, 4, 1,							/* 8 */
	(PLHRES)&msg57600, (PLHDATA)&SetBaudRate, COM_BR_57600,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+2*80, 15+2*17, 4, 1,						/* 9 */
	(PLHRES)&msg115200, (PLHDATA)&SetBaudRate, COM_BR_115200,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[0], PARENT_FKEYS, NO_MENU, NO_HELP },

 {  GroupBox, 15, 90, 260, 55,								/* 10 */
	(PLHRES)&msg_Interface, NULL, 0,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 15, 4, 1,								/* 11 */
	(PLHRES)&msgCOM1, (PLHDATA)&SetComPort, COM_PORT_1,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[10], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10, 15+17, 4, 1,							/* 12 */
	(PLHRES)&msgCOM2, (PLHDATA)&SetComPort, COM_PORT_2,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[10], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+110, 15, 4, 1,								/* 13 */
	(PLHRES)&msgAlternate, (PLHDATA)&SetComPort, COM_PORT_ALT,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[10], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 10+110, 15+17, 4, 1,							/* 14 */
	(PLHRES)&msgInfrared, (PLHDATA)&SetComPort, COM_PORT_IR,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[10], PARENT_FKEYS, NO_MENU, NO_HELP },

 {  StaticText, 15+275, 19+2, 0, 1,							/* 15 */
	(PLHRES)&msg_Parity, NULL, 0,
	STYLE_WHCHAR|STYLE_XYRELATIVE|STYLE_NOBORDER,
	NULL, NO_FKEYS, NO_MENU, NO_HELP },
 {  ComboBox, 15+275+80, 19, 7, 1,								/* 16 */
	(PLHRES)&msgnull, (PLHDATA)ParityStr, 8,
	STYLE_WHCHAR|STYLE_XYRELATIVE|COMBO_NOEDIT,
	NULL, PARENT_FKEYS, (PLHMENU)&ComOptionArray[17], NO_HELP},
 {  ListBox, 0, 0, 7, 5,									/* 17 */
 	NULL, (PLHDATA)&ParityList, 5,
	STYLE_WHCHAR,
	NULL, NO_FKEYS, NO_MENU, NO_HELP},

 {  GroupBox, 15+275, 19+17, 170, 32,								/* 18 */
	(PLHRES)&msg_DataBits, NULL, 0,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 20, 15, 4, 1,								/* 19 */
	(PLHRES)&msg7, (PLHDATA)&SetDataBits, COM_DATA_7,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[18], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 20+70, 15, 4, 1,							/* 20 */
	(PLHRES)&msg8, (PLHDATA)&SetDataBits, COM_DATA_8,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[18], PARENT_FKEYS, NO_MENU, NO_HELP },

 {  GroupBox, 15+275, 19+17+32+5, 170, 32,					/* 21 */
	(PLHRES)&msg_StopBits, NULL, 0,
	STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 20, 15, 4, 1,								/* 22 */
	(PLHRES)&msg1, (PLHDATA)&SetStopBits, COM_STOP_1,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[21], PARENT_FKEYS, NO_MENU, NO_HELP },
 {  RadioButton, 20+70, 15, 4, 1,							/* 23 */
	(PLHRES)&msg2, (PLHDATA)&SetStopBits, COM_STOP_2,
	STYLE_WHCHAR|STYLE_XYRELATIVE,
	&ComOptionArray[21], PARENT_FKEYS, NO_MENU, NO_HELP },

 {  PushButton, 300, 120, 0, 0,
	(PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 380, 120, 0, 0,
	(PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW ComOptionDialog={
	(PLHCLASS)ComOptionHandler,XY_CENTER(480,160),
	(PLHRES)&msgComSet,
	(PLHDATA)ComOptionArray,countof(ComOptionArray),
	STYLE_PUSHB_WIDTH,
	NULL,OKCancelFKeys,NO_MENU,NO_HELP
};

int far ComOptionHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  int i, result;

  if(Msg==CREATE) {       /* Initial */
	if( ComSettings.InfraRed == COM_IR_ON )
	  SetComPort=COM_PORT_IR;
	else {
	  switch (ComPort) {
	  	case COM_LINE_1: SetComPort=COM_PORT_1; break;
	  	case COM_LINE_2: SetComPort=COM_PORT_2; break;
	  	case COM_LINE_A: SetComPort=COM_PORT_ALT; break;
	  }
	}
	SetBaudRate=ComSettings.Baud;
	SetStopBits=ComSettings.Stop;
	SetDataBits=ComSettings.Data;
	for (i=0; i<5; i++) {
	  if (ComSettings.Parity==ParityParam[i]) {
	    PARITY_LISTBOX.Selection=i;
	    break;
	  }
	}
  }
  if(Msg==KEYSTROKE && Data==F10KEY) {       /* Done */
	ComRelease(ComHandle);
	ComClose(ComHandle);
	switch(SetComPort) {
	  case COM_PORT_1:
		ComPort=COM_LINE_1;
		ComSettings.InfraRed=COM_IR_OFF;
		break;
	  case COM_PORT_2:
		ComPort=COM_LINE_2;
		ComSettings.InfraRed=COM_IR_OFF;
		break;
	  case COM_PORT_ALT:
		ComPort=COM_LINE_A;
		ComSettings.InfraRed=COM_IR_OFF;
		break;
	  case COM_PORT_IR:
		ComPort=COM_LINE_1;
		ComSettings.InfraRed=COM_IR_ON;
		break;
	}
	ComSettings.Baud=SetBaudRate;
	ComSettings.Parity=ParityParam[PARITY_LISTBOX.Selection];
	ComSettings.Stop=SetStopBits;
	ComSettings.Data=SetDataBits;
	ComInit();

    SendMsg(Wnd, DESTROY, DESTROY_NORMAL,0);
    InitScanner();
	return TRUE;
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenComOptionDialog(void)
{
 SendMsg( &ComOptionDialog, CREATE, CREATE_FOCUS, 0 );
}


/* === FileReplace === */

int far FileReplaceHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

LHWINDOW FileReplaceArray[] = {
  { StaticText, 39, 28, 0, 1,
	(PLHRES)&msgReplace, NULL, 0,
	STYLE_WHCHAR|STYLE_NOBORDER|STYLE_NOFOCUS|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 49, 56, 50, 25,
	(PLHRES)&msgOK, (PLHDATA)CMD_DONE, ENTERKEY,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
 {  PushButton, 167, 56, 81, 25,
	(PLHRES)&msgCancel, (PLHDATA)CMD_ESC, 0,
	PUSHB_SENDMSG|STYLE_PUSHBUTTON|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};

LHWINDOW FileReplaceDialog = {
  (PLHCLASS)FileReplaceHandler, XY_CENTER(305,100),
  (PLHRES)&msgFileAlready, (PLHDATA)&FileReplaceArray,
  countof(FileReplaceArray),
  0,
  NULL, OKCancelFKeys, NO_MENU, NO_HELP
};

int far FileReplaceHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  switch (Msg) {
  case KEYSTROKE:
	switch (Data) {
	case F10KEY:
      SendMsg( Wnd, DESTROY, DESTROY_NORMAL, 0 );
      SendMsg( &ScanAreaDialog, DESTROY, DESTROY_NORMAL, 0 );
	  return TRUE;
	}
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*p*/
void OpenFileReplaceDialog()
{
 SendMsg( &FileReplaceDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === DispMsg === */
/*     (one line message display box) */

int far DispMsgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);
#define SET_DISPLAY_MESSAGE(x) DispMsgArray[0].Data=(PLHDATA)(x)

LHWINDOW DispMsgArray[] = {
  { StaticText, 10, 28, 32, 1,
	NULL, NULL, 32,
	STYLE_NOBORDER|STYLE_WHCHAR|STYLE_NOFOCUS|STYLE_XYRELATIVE|TEXT_CENTER,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP },
};

LHWINDOW DispMsgDialog = {
  (PLHCLASS)DispMsgHandler, XY_CENTER(340,60),
  (PLHRES)&msgMessage, (PLHDATA)&DispMsgArray, countof(DispMsgArray),
  0,
  NULL, OKFKeys, NO_MENU, NO_HELP
};

int far DispMsgHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  switch (Msg) {
  case KEYSTROKE:
	switch (Data) {
	case ENTERKEY: case F10KEY: case ESCKEY:
	  Msg=COMMAND;
	  Data=CMD_ESC;
	}
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*p*/
void far OpenDispMsgDialog(void)
{
 SendMsg( &DispMsgDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === About === */

int far AboutHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);

char far **AboutMsgArray[] = {
  &msgTitle,
  &msgAboutMsg
};

LHWINDOW AboutArray[] = {
  { MessageBox, 10, 17, 520, 80,
	NULL, (PLHDATA)&AboutMsgArray, countof(AboutMsgArray),
	STYLE_NOBORDER|STYLE_NOFOCUS|STYLE_XYRELATIVE,
	NULL, PARENT_FKEYS, NO_MENU, NO_HELP }
};


LHWINDOW AboutDialog = {
  (PLHCLASS)AboutHandler, XY_CENTER(540,110),
  (PLHRES)&msgAbout, (PLHDATA)&AboutArray, countof(AboutArray),
  0,
  NULL, OKFKeys, NO_MENU, NO_HELP
};

int far AboutHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  if(Msg==KEYSTROKE) { 		  /* any key to exit */
	Msg=COMMAND;
	Data=CMD_ESC;
  }
  return SubclassMsg(DialogBox, Wnd, Msg, Data, Extra);
}

/*P*/
void far OpenAboutDialog(void)
{
 SendMsg( &AboutDialog, CREATE, CREATE_FOCUS, 0 );
}

/* === Hourglass === */

int far HourglassHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...);


LHWINDOW HourglassDialog = {
  (PLHCLASS)HourglassHandler, XY_CENTER(23,26),
  NULL,NULL,0,
  STYLE_NOBORDER|STYLE_NOFOCUS|STYLE_SAVEUNDER,
  NULL, NO_FKEYS, NO_MENU, NO_HELP
};

int far HourglassHandler(PLHWINDOW Wnd, WORD Msg, WORD Data, WORD Extra,...)
{
  if(Msg==DRAW) {
    PutImg(Wnd->x,Wnd->y,G_FORCE,Hourglass);
  }
  return SubclassMsg(Object, Wnd, Msg, Data, Extra);
}

/*P*/
void far HourglassOn(int x, int y)
{
  if (x==0 && y == 0 ) {
    x=(640-23)/2; y=(200-26)/2;
  }
  HourglassDialog.x=x;
  HourglassDialog.y=y;
  SendMsg( &HourglassDialog, CREATE, CREATE_NORMAL, 0 );
}
/*p*/
void far HourglassOff(void)
{
  SendMsg( &HourglassDialog, DESTROY, DESTROY_NORMAL, 0 );
}


/* === Common functions === */

#define GetDataSeg()  _DS   /* for TC only */
/*P*/
void FixupFarPtrs(void)
{
  int i,dataseg;
  dataseg=GetDataSeg();
  for(i=0; i<countof(StringTable); i++)
	*(((int *)(StringTable[i]))+1) = dataseg;
}

/*P*/
void far DoQuit(void)
{
  Done = TRUE;
}

/* === End Common functions === */


/* === User Fuctions === */

/*P*/
void far Test(void)
{
  OpenFileReplaceDialog();
}

/*p*/
void DispReady(int result)
{
  if (!result) DispStatusStr("Ready");
  else DispStatusStr(" ");
}


/*p*/
void far ScanStart(void)
{
  int result;

  if (AreaDefined==FALSE) result=ERR_NOAREA;
  else result=0;

  if (!result) {
    HourglassOn(0,0);
    result=SendAllParam();
    HourglassOff();
  }
  if (!result) result=Scan();
  if (!result) {
    if (RunLxPic) LxPic(SaveFileSpec);
    SaveAsIndex=GetFileIndex(SaveAsIndex);
    sprintf(SaveAsStr, FILENAME_PREFIX "%03d", SaveAsIndex);
    AreaDefined=FALSE;
    ResetMeter();
  }

  DispReady(result);

  if (result) {
    ErrorDisp(result);
    Pause(25);
  }
}

/*p*/
void PixelCalcInit(void)
{
   Area.x= (int)((unsigned long)Set.AreaMM.x
		   *(unsigned long)Set.Resolution.x
		   *(unsigned long)Set.Zoom.x/2540L);
   Area.y= (int)((unsigned long)Set.AreaMM.y
		   *(unsigned long)Set.Resolution.y
		   *(unsigned long)Set.Zoom.y/2540L);
   Area.w= (int)( ( (unsigned long)(Set.AreaMM.x+Set.AreaMM.w)
					*(unsigned long)Set.Resolution.x
					*(unsigned long)Set.Zoom.x
					/2540L
					-(unsigned long)Area.x + 7L
				  )/8L *8L
				);
   Area.h= (int)( (unsigned long)(Set.AreaMM.y+Set.AreaMM.h)
		   *(unsigned long)Set.Resolution.y
		   *(unsigned long)Set.Zoom.y/2540L )
		   -Area.y;
}

/*p*/
void PixelCalc(void)
{
  INTXY AreaMaxNow;

  ResolutionTmp.x= atoi(ResoXStr);
  ResolutionTmp.y= atoi(ResoYStr);
  ZoomTmp.x= (UCHAR)atoi(ZoomXStr);
  ZoomTmp.y= (UCHAR)atoi(ZoomYStr);

  if(ZoomTmp.x<50) ZoomTmp.x=50;
  if(ZoomTmp.y<50) ZoomTmp.y=50;
  if(ZoomTmp.x>200) ZoomTmp.x=200;
  if(ZoomTmp.y>200) ZoomTmp.y=200;


  AreaMaxNow.x=(int)((long)AreaMax.x*(long)ResolutionTmp.x
    *(long)ZoomTmp.x/(long)ResolutionMax/100L);
  AreaMaxNow.y=(int)((long)AreaMax.y*(long)ResolutionTmp.y
    *(long)ZoomTmp.y/(long)ResolutionMax/100L);

  AreaMMTmp.x=atoi(ScanXStr);
  AreaMMTmp.y=atoi(ScanYStr);
  AreaMMTmp.w=atoi(ScanWStr);
  AreaMMTmp.h=atoi(ScanHStr);

  AreaTmp.x= (int)((unsigned long)AreaMMTmp.x
		   *(unsigned long)ResolutionTmp.x
		   *(unsigned long)ZoomTmp.x/2540L);
  AreaTmp.y= (int)((unsigned long)AreaMMTmp.y
		   *(unsigned long)ResolutionTmp.y
		   *(unsigned long)ZoomTmp.y/2540L);

  if (AreaTmp.x < 0 ) AreaTmp.x=0;
  if (AreaTmp.y < 0 ) AreaTmp.y=0;
  if (AreaTmp.x > (AreaMaxNow.x-8) ) AreaTmp.x=AreaMaxNow.x;
  if (AreaTmp.y > (AreaMaxNow.y-8) ) AreaTmp.y=AreaMaxNow.y;

  AreaTmp.w= (int)( ( (unsigned long)(AreaMMTmp.x+AreaMMTmp.w)
					*(unsigned long)ResolutionTmp.x
					*(unsigned long)ZoomTmp.x
					/2540L
					-(unsigned long)AreaTmp.x + 7L
				  )/8L *8L
				);
  AreaTmp.h= (int)( (unsigned long)(AreaMMTmp.y+AreaMMTmp.h)
		   *(unsigned long)ResolutionTmp.y
		   *(unsigned long)ZoomTmp.y/2540L )
		   -AreaTmp.y;

  if(AreaTmp.w<8) AreaTmp.w=8;
  if(AreaTmp.h<1) AreaTmp.h=1;
  if(AreaTmp.w>(AreaMaxNow.x-AreaTmp.x)/8*8)
     AreaTmp.w=(AreaMaxNow.x-AreaTmp.x)/8*8;
  if(AreaTmp.w>4096) AreaTmp.w=4096;
  if(AreaTmp.h > (AreaMaxNow.y-AreaTmp.y))
     AreaTmp.h = AreaMaxNow.y-AreaTmp.y;

   sprintf(ScanXPixelStr,"%4d", AreaTmp.x);
   sprintf(ScanYPixelStr,"%4d", AreaTmp.y);
   sprintf(ScanWPixelStr,"%4d", AreaTmp.w);
   sprintf(ScanHPixelStr,"%4d", AreaTmp.h);
}

/*p*/
void SetupResolutionList(void)
{
  int i;
  for (i=0; i<ResolutionListLen; i++) {
    sprintf(ResolutionStrList[i], "%d", ResolutionList[i]);
  }
  RESO_X_LISTBOX.LogicalSize= ResolutionListLen;
  RESO_Y_LISTBOX.LogicalSize= ResolutionListLen;
  ResolutionMax=ResolutionList[ResolutionListLen-1];
  SyncResolution();
}


/*p*/
void SyncResolution(void)
{
  int i;
  for(i=0; i<ResolutionListLen; i++) {
    if(Set.Resolution.x==ResolutionList[i])
      RESO_X_LISTBOX.Selection=i;
    if(Set.Resolution.y==ResolutionList[i])
      RESO_Y_LISTBOX.Selection=i;
  }
  Set.Resolution.x= ResolutionList[RESO_X_LISTBOX.Selection];
  Set.Resolution.y= ResolutionList[RESO_Y_LISTBOX.Selection];
}

/*p*/
void SetColorStatusStr(void)
{
  if (DebugMode) {
	sprintf(ColorStatusStr,
      "%c%02X %c%02X %c%02X %c%2d %c%02X %c%02X",
	  SET_COLOR, Set.ColorMode,
	  SET_DEPTH, Set.ImageDepth,
	  SET_DITHER, Set.DitherSetting,
	  SET_BRIGHTNESS, Set.Brightness,
	  SET_GAMMA, Set.GammaSetting,
	  SET_COLOR_CORRECTION, Set.ColorCorrection
    );
  } else {
	sprintf(ColorStatusStr,"%d-bit %s    Dither:%s",
	  Set.ImageDepth, ColorModeList[(Set.ColorMode)&0x0f],
	  GetDitherStr(Set.DitherSetting));
  }
}

/*p*/
char *GetDitherStr(int n)
{
  int i, hit=-1;
  for (i=0; i<countof(DitherParam); i++)
    if (DitherParam[i]==n) hit=i;
  if (hit==-1) return NULL;
  else return DitherList[hit];
}


/*p*/
void SetAreaStatusStr(void)
{
  if (DebugMode) {
    sprintf(AreaStatusStr,
	"%c%04X,%04X %c%02X,%02X %c%04X,%04X,%04X,%04X",
	SET_RESOLUTION, Set.Resolution.x, Set.Resolution.y,
	SET_ZOOM, Set.Zoom.x, Set.Zoom.y,
	SET_AREA, Area.x, Area.y, Area.w, Area.h
    );
  } else {
    sprintf(AreaStatusStr,
	  "DPI: %3dx%3d   Zoom: %3d%%x%3d%%   Pixel: %4dx%4d",
	  Set.Resolution.x, Set.Resolution.y,
	  Set.Zoom.x, Set.Zoom.y,
	  Area.w, Area.h
	);
  }
}

/*P*/
int GetFileIndex(int currentindex)
{
  int i, j, exist=0;
  char filespec[80];
  i=currentindex;
  do {
    exist=0;
    for (j=0; j<3; j++) {
      sprintf(filespec, "%s" FILENAME_PREFIX "%03d.%s",
        SaveDir, i, SaveFormatList[j]);
      if(FileExist(filespec)) exist=1;
    }
    i++;
  } while (exist);
  return (i-1);
}

/*P*/
int FileExist(char *filespec)
{
  NBFILE infile;

  if ( m_openro(&infile,filespec,strlen(filespec),0,1) )
    return 0;
  else {
    m_close(&infile);
    return 1;
  }
}


/*P*/
void ReadConfig(void)
{
  int len, sign;
  NBFILE infile;

  if ( !m_openro(&infile,EnvFile,strlen(EnvFile),0,1)) {
    m_read(&infile, &sign,sizeof(sign), &len);
    if (sign==SIGNATURE) {
      m_read(&infile, SaveDir,sizeof(SaveDir), &len);
      m_read(&infile, &ComSettings,sizeof(ComSettings),&len);
      m_read(&infile, &Set,sizeof(Set),&len);
      m_read(&infile, &Lock,sizeof(Lock),&len);
      m_close(&infile);
      ReconvertColorParam();
      PixelCalcInit();
      EnvFileOK=TRUE;
    } else {
      m_close(&infile);
      EnvFileOK=FALSE;
    }
  }
}

/*P*/
void WriteConfig(void)
{
 int sign=SIGNATURE;
 NBFILE outfile;

 if ( !m_fcreat(&outfile,EnvFile,strlen(EnvFile),0,1)) {
  m_write(&outfile, &sign,sizeof(sign));
  m_write(&outfile, SaveDir,sizeof(SaveDir));
  m_write(&outfile, &ComSettings,sizeof(ComSettings));
  m_write(&outfile, &Set,sizeof(Set));
  m_write(&outfile, &Lock,sizeof(Lock));
  m_close(&outfile);
 }
}


/*P*/
void far DoNothing(void)
{
 ;
}

/*P*/
int far Scan(void)
{
  int result, ScanCycle;
  long maxline;
  UCHAR cmd;

  if (COLOR_MONO==COLOR_MODE_3_SCAN) ScanCycle=3;
  else ScanCycle=1;
  if (COLOR_MONO==MONOCHROME_MODE) maxline=(long)Area.h;
  else maxline=(long)Area.h*3L;

  CurrentLine=0;
  ResetMeter();
  result=OpenSaveFile();
  if (result) return result;

  TxBuf[0]=ESC; TxBuf[1]=cmd=START_SCAN;
  result=snd(2);
  sprintf(CommandStr,">%c (%02x) ", cmd, result);
  DispCommandStr();
  if (result) return result;
  sprintf(StatusStr,"Scanning %dx%d pixels from (%d, %d)",
    Area.w, Area.h, Area.x, Area.y );
  DispStatusStr("");
  while(ScanCycle) {
	result=ReceiveBlock();
	if (!result) {
	  if (StatusByte&(STAUTS_ERROR)) result=ERR_STATUSBYTE;
      else if (BlockLen>RxBufSize) result=ERR_BLOCKLENGTH;
	}
	if (EscKeyCheck()) result=ERR_ESCKEY;
	if(result) {
      ComReset(ComHandle,COM_RESET_RXB);
	  TxBuf[0]=CAN; Snd(1);
	  break;
	}
	if(StatusByte&STATUS_AREA_END) ScanCycle--;
	else {
	  TxBuf[0]=ACK; Snd(1);
    }
    LineColor=(StatusByte&STATUS_COLOR)>>2;
    if (BlockLen) {
      result=WriteToFile(BlockLen);
	  if (result) break;
	  CurrentLine++;
	  if(CurrentLine%10==0) {
        UpdateMeter( (int)((long)CurrentLine*100L/maxline) );
		SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
	  }
	}
  }
  UpdateMeter( (int)((long)CurrentLine*100L/maxline) );
  CloseSaveFile();
  DispStatusStr("Done.");
  Pause(20);
  return result;
}

/*p*/
void ResetMeter()
{
  ODOMETER.LogicalSize=100;
  ODOMETER.Selection=0;
  SendMsg(&ODOMETER, DRAW, DRAW_ALL, 0);
}

/*p*/
void UpdateMeter(int x)
{
  ODOMETER.Selection=x;
  SendMsg(&ODOMETER, DRAW, DRAW_CLIENT, 0);
}

/*P*/
int OpenSaveFile(void)
{
  int i, result;
  UCHAR x;
  ICNHEADER IcnHeader ={1,1,0,0};
  PCXHEADER PcxHeader = {10, 5, 1, 1, {1,1,640,200}, 100, 100,
    {0,0,0, 255,255,255}, 0, 1, 80, 1 };
  BMPHEADER BmpHeader = { 'B'+'M'*0x100, 0, 0, 0, 54, 40, 640, 200,
    1, 1, 0L, 0L, 1000L, 1000L, 0L, 0L };

  if(SAVEFORMAT_LISTBOX.Selection == SAVE_BMP) {
    if (COLOR_MONO==MONOCHROME_MODE) {
      switch(Set.ImageDepth) {
        case 1:
          BmpBitCount=1;   			/* 1 bits, 2 shades (B/W) */
          OutBufSize=(Area.w/8+3)/4*4; /* multiple of 4 bytes */
          break;
        case 2: case 3: case 4:
          BmpBitCount=4;  			/* 4 bits, 16 greyscale */
          OutBufSize=Area.w/2;
          break;
        case 5: case 6: case 7: case 8:
          BmpBitCount=8; 			/* 8 bits, 256 greyscale */
          OutBufSize=Area.w;
          break;
      }
      DataSize=(ULONG)Area.h*(ULONG)OutBufSize;
      RxBufSize=Area.w/(8/Set.ImageDepth);
      InitDepthConv(BmpBitCount, Set.ImageDepth);
    } else {									/* Color */
      BmpBitCount=24;
      OutBufSize=Area.w*3;
      RxBufSize=Area.w/(8/Set.ImageDepth);
      DataSize=(ULONG)Area.h*(ULONG)OutBufSize;
      InitDepthConv(8, Set.ImageDepth);
    }
  } else {						/* PCX */
    OutBufSize=Area.w/4;		/* original size (Area.w/8) */
    							/* plus safety margin       */
    RxBufSize=Area.w/(8/Set.ImageDepth);
  }
  /* ack RxBuf */

  OutBuf=m_alloc(OutBufSize);
  if (OutBuf==0) return ERR_MALLOC;
  if (RxBufSize>DEFAULT_RXBUF_SIZE) {
    RxBuf=m_alloc(RxBufSize);
    if (RxBuf==0) {
      RxBuf=DefaultRxBuf;
      m_free(OutBuf);
      return ERR_MALLOC;
    }
    RxBufPtr=(void far *)RxBuf;
  }
  sprintf(SaveFileSpec, "%s%s.%s", SaveDir, SaveAsStr,SaveFormatStr);
  WRITE_TO.Data=SaveFileSpec;
  SendMsg(&WRITE_TO, DRAW, DRAW_CLIENT, 0);
  /* Pause(50); */

  m_lock();
  m_fcreat(&OutFile, SaveFileSpec, strlen(SaveFileSpec),0,0);

  switch(SAVEFORMAT_LISTBOX.Selection) {
    case SAVE_ICN:
      IcnHeader.x2=Area.w;
      IcnHeader.y2=Area.h;
      result=m_write(&OutFile, &IcnHeader, sizeof(IcnHeader));
      break;
    case SAVE_PCX:
      PcxHeader.Window[0]=1;
      PcxHeader.Window[1]=1;
      PcxHeader.Window[2]=Area.w;
      PcxHeader.Window[3]=Area.h;
      PcxHeader.BytesPerLine=Area.w/8;
      result=m_write(&OutFile, &PcxHeader, sizeof(PcxHeader));
      break;
    case SAVE_BMP:
      if (BmpBitCount==24) ColorTableLen=0;
      else ColorTableLen=1<<BmpBitCount;
      BmpHeader.bfOffBits=54L+(ULONG)(4*ColorTableLen);
      BmpHeader.bfSize=BmpHeader.bfOffBits+DataSize;
      BmpHeader.biWidth=(ULONG)Area.w;
      BmpHeader.biHeight=(ULONG)Area.h;
      BmpHeader.biBitCount=BmpBitCount;
      BmpHeader.biSizeImage=DataSize;
      BmpHeader.biXPelsPerMeter=
        (ULONG)Set.Resolution.x*(ULONG)Set.Zoom.x*100L/254L;
      BmpHeader.biYPelsPerMeter=
        (ULONG)Set.Resolution.y*(ULONG)Set.Zoom.y*100L/254L;
      result=m_write(&OutFile, &BmpHeader, sizeof(BmpHeader));
      if ((!result) && ColorTableLen) {
        for(i=0; i<ColorTableLen; i++) {
          x=0xFF*i/(ColorTableLen-1);
          ColorTable[i]=((long)x)+((long)x)*0x100L+((long)x)*0x10000L;
        }
        result=m_write(&OutFile, &ColorTable, ColorTableLen*4);
	  }
      break;
  }
  return result;
}

/*p*/
int WriteToFile(int n)
{
  int m, result;
  switch(SAVEFORMAT_LISTBOX.Selection) {
    case SAVE_ICN:
      result=m_write(&OutFile, RxBuf, n);
      break;
    case SAVE_PCX:
      m=EncodeLine(OutBuf,RxBuf, n);
      result=m_write(&OutFile, OutBuf, m);
      break;
    case SAVE_BMP:
      switch(COLOR_MONO) {
      case MONOCHROME_MODE:
        ConvertMonoBmp();
        result=m_write(&OutFile, OutBuf, OutBufSize);
        break;
	  case COLOR_MODE_1_SCAN:
        ConvertColorBmp();
        if(LineColor==LINE_LAST_COLOR)
          result=m_write(&OutFile, OutBuf, OutBufSize);
	    break;
      case COLOR_MODE_3_SCAN:
        if(LineColor!=LINE_FIRST_COLOR)
          result=ReadPrevScanData();
        ConvertColorBmp();
        result=m_write(&OutFile, OutBuf, OutBufSize);
        break;
      }
  }
  return result;
}

/*P*/
void CloseSaveFile(void)
{
  m_close(&OutFile);
  m_free(OutBuf);
  RxBuf=DefaultRxBuf;
  RxBufPtr=(void far *)DefaultRxBuf;
  m_unlock();
  WRITE_TO.Data=NULL;
  SendMsg(&WRITE_TO, DRAW, DRAW_CLIENT, 0);

}

/*p*/
int ReadPrevScanData(void)
{
  int len, result=0;
  long pos;
  /* adjust position (54=header length) and read */
  pos=54L+(long)OutBufSize*(long)(CurrentLine%Area.h);
  result=m_seek(&OutFile,0,pos);
  if (!result) result=m_read(&OutFile,OutBuf, OutBufSize, &len);
  /* seek back  */
  if (!result) result=m_seek(&OutFile,1,(long)(-1*len));
  return result;
}

/*P*/
int SendAllParam(void)
{
  int result;

  DispStatusStr("Sending parameters");

  result=SendCmd(SET_COLOR);
  if (!result) {
	TxBuf[0]=Set.ColorMode;
	result=SendParam(1);
  }

  if (!result) result=SendCmd(SET_DEPTH);
  if (!result) {
	TxBuf[0]=Set.ImageDepth;
	result=SendParam(1);
  }

  if (!result) result=SendCmd(SET_DITHER);
  if (!result) {
	TxBuf[0]=Set.DitherSetting;
	result=SendParam(1);
  }

  if (!result) result=SendCmd(SET_BRIGHTNESS);
  if (!result) {
	TxBuf[0]=Set.Brightness;
	result=SendParam(1);
  }

  if (!result) result=SendCmd(SET_GAMMA);
  if (!result) {
	TxBuf[0]=Set.GammaSetting;
	result=SendParam(1);
  }

  if (Set.ColorCorrection) {
    if (!result) result=SendCmd(SET_COLOR_CORRECTION);
    if (!result) {
	  TxBuf[0]=Set.ColorCorrection;
	  result=SendParam(1);
    }
  }
  if (!result) result=SendCmd(SET_RESOLUTION);
  if (!result) {
	*((int *)TxBuf) = Set.Resolution.x;
	*(((int *)TxBuf)+1) = Set.Resolution.y;
	result=SendParam(4);
  }
  if (!result) result=SendCmd(SET_ZOOM);
  if (!result) {
	TxBuf[0]=Set.Zoom.x;
	TxBuf[1]=Set.Zoom.y;
	result=SendParam(2);
  }
  if (!result) result=SendCmd(SET_AREA);
  if (!result) {
	*((int *)TxBuf) = Area.x;
	*(((int *)TxBuf)+1) = Area.y;
	*(((int *)TxBuf)+2) = Area.w;
	*(((int *)TxBuf)+3) = Area.h;
	result=SendParam(8);
  }
  DispReady(result);
  return result;
}

/*P*/
int GetInfo(void)
{
  BOOL done=FALSE;
  int result, i=0,j=0;

  HourglassOn(0,0);
  DispStatusStr("Reading Scanner info");

  result=ReceiveOneBlock(GET_ID);
  if (!result) {
	while(!done) {
	  switch(RxBuf[i]) {
		case 'B':
		  ScannerLevel=*(int *)(RxBuf+i);
		  i +=2;
		  break;
		case 'R':
		  ResolutionList[j++]=RxBuf[i+1]+RxBuf[i+2]*0x100;
		  i +=3;
		  break;
		case 'A':
		  AreaMax.x=RxBuf[i+1]+RxBuf[i+2]*0x100;
		  AreaMax.y=RxBuf[i+3]+RxBuf[i+4]*0x100;
		  i +=5;
		  done=TRUE;
		  break;
		default:
		  i++;
		  break;
	  }
      if (j>=RESOCOUNT) done=TRUE;
	}
	ResolutionListLen=j;
	SetupResolutionList();
	sprintf(StatusStr,"Res.List: %d; Max Res: %d; Area Max %4d x %4d ",
			ResolutionListLen, ResolutionMax, AreaMax.x, AreaMax.y);
    Pause(100);
  }
  HourglassOff();
  DispReady(result);
  return result;
}


/*P*/
int ResetScanner(void)
{
  int result;

  DispStatusStr("Initializing");
  HourglassOn(0,0);
  result=SendCmd(RESET_SCANNER);
  pause(100);
  HourglassOff();
  DispReady(result);
  return result;
}

/*P*/
void far InitScanner(void)
{
 int result;
 result=ResetScanner();
 if (!result) result=GetInfo();
 if (result) ErrorDisp(result);
}

/*P*/
int SendParam(int len)
{
  int result;
  result=snd(len);
  if (!result) result=rcv(1);
  if (!result) if(RxBuf[0]!=ACK) result=1;
  return result;
}

/*P*/
int ReceiveOneBlock(UCHAR cmd)
{
  int result, sndresult;

  ComReset(ComHandle,COM_RESET_TXB|COM_RESET_RXB);

  TxBuf[0]=ESC; TxBuf[1]=cmd;
  sndresult=result=snd(2);

  sprintf(CommandStr,">%c (%02x) ", cmd, result);
  DispCommandStr();

  if (!result) result=ReceiveBlock();
  sprintf(CommandStr,">%c (%02x) <%02x :%02x (%02x)",
    cmd, sndresult, BlockLen, StatusByte, result);
  DispCommandStr();

  return result;
}

int SendCmd(UCHAR cmd)
{
  int result, sndresult;
  BOOL DispFlag = (GetFocus()==&MainDialog) ;

  ComReset(ComHandle,COM_RESET_TXB|COM_RESET_RXB);

  TxBuf[0]=ESC; TxBuf[1]=cmd;
  result=sndresult=snd(2);

  if(DispFlag)  {
    sprintf(CommandStr,">%c (%02x) ", cmd, result);
    DispCommandStr();
  }
  if (!result)result=rcv(1);
  if (DispFlag) {
    sprintf(CommandStr,">%c (%02x) <%02x (%02x)",
	  cmd, sndresult, RxBuf[0], result);
    DispCommandStr();
  }
  if (!result)
	switch (RxBuf[0]) {
	  case ACK: break;
	  case NAK: result=ERR_NAK; break;
	  default:  result=ERR_NO_ACK; break;
	}
  return result;
}

/*P*/
int ReceiveBlock(void)
{
  int result=0;
  result=rcv(4);
  if (!result) {
    if (RxBuf[0] != STX) result=ERR_COMM;
  }
  if (!result) {
    StatusByte=RxBuf[1];
    BlockLen=RxBuf[2] + 0x100 * RxBuf[3];
    if (BlockLen) result=rcv(BlockLen);
  }
  return result;
}

/*P*/
int ComInit(void)
{
  if(ComOpen( &ComHandle, ComPort )) {
   m_thud();
   return 1;
  }
  ComSetParameters(ComHandle, (void far *)&ComSettings);
  ComAcquire(ComHandle,1);  /*Exclusive*/
  /* ComMdmSet(ComHandle,1); */   /* Set DTR */
  /* ComMdmClr(ComHandle,2); */   /* Clear RTS */
  return 0;
}


/*P*/
void ComSetDefault(void)
{
  ComSettings.Baud=COM_BR_19200;
  ComSettings.Data=COM_DATA_8;
  ComSettings.Parity=COM_PTY_EVEN;
  ComSettings.Stop=COM_STOP_1;
  ComSettings.Flow=0x10;    /* 1=NONE 2=XONXOFF 10=RTS-CTS */
  ComSettings.InfraRed=COM_IR_OFF;
}


/*P*/
int snd(int DataLength)
{
 TxLength=DataLength;
 if (!ComSendBytes(ComHandle,TxBufPtr,1,TxLengthPtr)) {
 /*
 while ( ComXmitting(ComHandle) )
   ;
  */
 return 0;
 } else
 return ERR_SENDBYTES;
}

/*P*/
int rcv(int DataLength)
{
 int Received, LoopCount=0;
 for (Received = 0; Received <DataLength ;  ) {
  RxLength = DataLength - Received;
  if (ComReceiveBytes(ComHandle,RxBufPtr+Received,RxLengthPtr))
   return ERR_RCVBYTES;
  Received += RxLength;
  if (!RxLength) {
	++LoopCount;
	Pause(RCV_RETRY_INTERVAL);
  }
  if ( LoopCount > RCV_MAX_RETRY ) return ERR_RCVTIMEOUT;
 }
 return 0;
}

/*P*/
void PutImg(int xpos, int ypos, int rule, UCHAR *buf)
{
  struct REGPACK regs;

  regs.r_ax=0x0E00+rule;
  regs.r_cx=xpos;
  regs.r_dx=ypos;
  regs.r_di=(UINT)buf;
  regs.r_es=_DS;
  intr(0x5f, &regs);
}

/*p*/
void ConvertMonoBmp()
{
  UCHAR x;
  int i, j=RxBufSize-1;
  switch(Set.ImageDepth) {
    case 8:
      for(i=0; i < OutBufSize ; i++ )
        OutBuf[i]=RxBuf[j--];
      break;
    case 7:
      for(i=0; i < OutBufSize ; i++ )
        OutBuf[i]=DepthConv[RxBuf[j--]>>1];
      break;
    case 6:
      for(i=0; i < OutBufSize ; i++ )
        OutBuf[i]=DepthConv[RxBuf[j--]>>2];
      break;
    case 5:
      for(i=0; i < OutBufSize ; i++ )
        OutBuf[i]=DepthConv[RxBuf[j--]>>3];
      break;
    case 4:
      for(i=0; i < OutBufSize ; i++ ) {
        x=RxBuf[j--];
        OutBuf[i]= ((x&0x0F)<<4) | ((x&0xF0)>>4) ;
      }
      break;
    case 3:
      for(i=0; i < OutBufSize ; i++ ) {
        x=RxBuf[j--];
        OutBuf[i]=  ( DepthConv[(x&0x0F)>>1]<<4 )
                  | ( DepthConv[(x&0xF0)>>5] ) ;
      }
      break;
    case 2:
      for(i=0; i < OutBufSize ; i +=2 ) {
        x=RxBuf[j--];
        OutBuf[i]=   ( DepthConv[x&0x03]<< 4 )
                      |  DepthConv[(x&0x0C)>>2] ;
        OutBuf[i+1]= ( DepthConv[(x&0x30)>>4]<< 4 )
                      |  DepthConv[(x&0xC0)>>6] ;
      }
      break;
    case 1:
      for(i=0; i < OutBufSize ; i++ ) {
        if (i>=RxBufSize) OutBuf[i]=0;
        else {
          x=RxBuf[j--];
          OutBuf[i] = ((x&1)<<7)|((x&2)<<5)|((x&4)<<3)|((x&8)<<1)|
                      ((x&16)>>1)|((x&32)>>3)|((x&64)>>5)|((x&128)>>7);
        }
      }
      break;
  }
}

/*p*/
void ConvertColorBmp()
{
  UCHAR x;
  int i,j, displace, zeroshift;
  switch(LineColor) {
    case LINE_GREEN	: displace= 1; break;
    case LINE_RED	: displace= 2; break;
    case LINE_BLUE	: displace= 0; break;
  }
  switch(Set.ImageDepth) {
  case 1:
    for(i=0; i < RxBufSize ; i++ ) {
      x=RxBuf[RxBufSize-1-i];
      for(j=0;j<8;j++)
        OutBuf[i*24+j*3+displace]=DepthConv[(x>>j)&1];
    }
    break;
  case 2:
    for(i=0; i < RxBufSize ; i++ ) {
      x=RxBuf[RxBufSize-1-i];
      for(j=0;j<4;j++)
        OutBuf[i*12+j*3+displace]=DepthConv[(x>>(j*2))&3];
    }
    break;
  case 3:
  case 4:
    zeroshift=4-Set.ImageDepth;
    for(i=0; i < RxBufSize ; i++ ) {
      x=RxBuf[RxBufSize-1-i];
      OutBuf[i*6+displace]  =DepthConv[(x>>zeroshift)    &0x0F];
      OutBuf[i*6+3+displace]=DepthConv[(x>>(4+zeroshift))&0x0F];
    }
    break;
  case 5:  case 6: case 7: case 8:
    zeroshift=8-Set.ImageDepth;
    for(i=0; i < RxBufSize ; i++ ) {
      x=RxBuf[RxBufSize-1-i];
      OutBuf[i*3+displace]  =DepthConv[x>>zeroshift];
    }
    break;
  }
}

/*p*/
UINT EncodeLine(BYTE *dst, BYTE *src, UINT width)
{						/* this function is based on CAPSYS.C */
						/* written by Hiroyuki Sekiya */
	UINT i, j;
	BYTE runlen;
	BYTE this, last;
	BYTE ImageMask=0x00; /* 0xFF for reverse */

	j = 0;
	last = *src ^ ImageMask;
	runlen = 1;
	for (i=1; i<width; i++) {
		this = *(++src) ^ ImageMask;
		if (this == last) {
			runlen++;
			if (runlen == 63) {
				dst[j++] = 0xC0 | 63;
				dst[j++] = last;
				runlen = 0;
			}
		} else {
			if (runlen) {
				if (runlen>1 || ((last & 0xC0) == 0xC0))
					dst[j++] = runlen | 0xC0;
				dst[j++] = last;
			}
			last = this;
			runlen = 1;
		}
	}
	if (runlen) {
		if (runlen>1 || ((last & 0xC0) == 0xC0))
			dst[j++] = runlen | 0xC0;
		dst[j++] = last;
	}
	return j;
}


/*P*/
void InitDepthConv(int outbit, int inbit)
{
  int i;
  for(i=0; i<1<<inbit; i++)
    DepthConv[i]= (1<<outbit-1)*i/(1<<inbit-1);
}

/*P*/
void ErrorDisp(int errornumber)
{
  char msgbuf[16];
  char *errmsg=msgbuf; 	/* default */

  switch(errornumber) {
    case ERR_PORTOPEN:		errmsg=ERR_PORTOPEN_MSG; break;
    case ERR_SENDBYTES:		errmsg=ERR_SENDBYTES_MSG; break;
    case ERR_RCVBYTES:		errmsg=ERR_RCVBYTES_MSG; break;
    case ERR_RCVTIMEOUT:	errmsg=ERR_RCVTIMEOUT_MSG; break;
    case ERR_NAK:			errmsg=ERR_NAK_MSG; break;
    case ERR_NO_ACK:		errmsg=ERR_NO_ACK_MSG; break;
    case ERR_COMM:			errmsg=ERR_COMM_MSG; break;
    case ERR_ESCKEY:		errmsg=ERR_ESCKEY_MSG; break;
    case ERR_NOAREA:		errmsg=ERR_NOAREA_MSG; break;
    default: sprintf(msgbuf, "0x%04x", errornumber); break;
  }
  sprintf(ErrorDispBuf, "Error: %s", errmsg);
  SET_DISPLAY_MESSAGE(&ErrorDispBuf);
  OpenDispMsgDialog();
}

/*P*/
void LxPic(char *filespec)
{
  char cmd[86];
  EXEC_STRUCT st_exec;

  sprintf(cmd,"/C LXPIC %s",filespec);

  st_exec.ex_command_line = cmd;
  st_exec.ex_file_spec = "d:\\dos\\command.com";
  st_exec.ex_DOSsizek = 0xffff;
  st_exec.ex_pause = 0;
  st_exec.ex_lock = 0;

  DeactivateLHAPI();
  app_event.execf.exec_struc_ptr = &st_exec;
  app_event.norm.do_event = DO_EXEC_FULL;
  m_action( &app_event );
  ReactivateLHAPI( &LHAPIData );
}


/*P*/
int EscKeyCheck(void)
{
  int c;
  c=m_QuickKeyCheck();
  if(!c) return 0;
  else m_flush_kb();
  if(c==0x011B) return 1;	/* ESC key scan code */
  else return 0;
}

/*P*/
void Pause(int n)
	/* n: duration (unit 0.01 sec) */
{
 DTM mydtm;
 UINT start_time, stop_time, now_time;
 BOOL overflow;

 m_getdtm((DTM far*)&mydtm);
 start_time = mydtm.dt_second*100 + mydtm.dt_hundreth;
 stop_time = start_time + n;
 if (stop_time>5999) {
   overflow=TRUE;
   stop_time -= 6000;
 } else {
   overflow=FALSE;
 }

 while(TRUE) {
   m_getdtm((DTM far*)&mydtm);
   now_time = mydtm.dt_second*100 + mydtm.dt_hundreth;
   if (overflow) {
	 if (now_time>stop_time && now_time <start_time)
	   break;
   } else {
	 if (now_time>stop_time || now_time <start_time)
	   break;
   }
 }
}

/*P*/
void InitList(void)
{
  int i;
  for (i=0; i<RESOCOUNT; i++)
	ResolutionStrList[i] = ResolutionSpace+i*RESOLEN;

 /* default */
  ResolutionListLen= 3;
  ResolutionList[0]=  50;
  ResolutionList[1]= 100;
  ResolutionList[2]= 200;
  SetupResolutionList();

  AreaMax.x= 1200; 		/* 150 mm -> 6 inch -> 1200 pixel */
  AreaMax.y= 1600;		/* 200 mm -> 8 inch -> 1600 pixel */
}

/*P*/
void main(void)
{
  int result;

  m_init_app(SYSTEM_MANAGER_VERSION);
  m_reg_app_name(msgAppName);
  InitializeLHAPI(&LHAPIData);
  SetDefaultFont(FONT_NORMAL);
  SetMenuFont(FONT_NORMAL);
  FixupFarPtrs();

  /* Initialize */
  InitList();
  ComSetDefault();
  ReadConfig();
  SetColorStatusStr();
  SetAreaStatusStr();
  SaveAsIndex=GetFileIndex(SaveAsIndex);
  sprintf(SaveAsStr, FILENAME_PREFIX "%03d", SaveAsIndex);

  /* Initial Display */
  SendMsg( &MainDialog, CREATE, CREATE_FOCUS, 0 );
  SendMsg( &MainTitle, CREATE, CREATE_NORMAL, 0 );
  ComInit();
  if (EnvFileOK) InitScanner();
  else OpenComOptionDialog();

  Done = FALSE;
  while(!Done) {
	app_event.norm.do_event = DO_EVENT;
	m_action(&app_event);
	switch(app_event.norm.kind) {
	  case E_REFRESH:
	  case E_ACTIV:
		FixupFarPtrs();
		ComInit();
		ReactivateLHAPI(&LHAPIData);
		break;
	  case E_DEACT:
		ComRelease(ComHandle);
		ComClose(ComHandle);
		DeactivateLHAPI();
		break;
	  case E_TERM:
		FixupFarPtrs(); Done = TRUE; break;
	  case E_NONE:
		SendMsg(&TDateTime,DRAW,DRAW_ALL,0);
		break;
	  case E_KEY:
		SendFocusMsg(KEYSTROKE,app_event.norm.data,app_event.norm.scan);
		break;
	}
  }
  WriteConfig();
  ComRelease(ComHandle);
  ComClose(ComHandle);
  app_event.norm.do_event = DO_FINI;
  m_action(&app_event);
}
