//------------------------------------------------------------------------------
// function to open pbk file read-only*/
//------------------------------------------------------------------------------
void
open_pbk_file (char *fn)
{
  if ((pbkf = fopen (fn, "rb")) == NULL)
    {
      printf ("pbk file %s can't be opened\n", fn);
      exit (1);
    }
}
//------------------------------------------------------------------------------
// function to check pbk file header : returns 0 if header is OK
//------------------------------------------------------------------------------
int
check_header ()
{
  int i, j = 0;
  unsigned char hdr;
  unsigned char pbk_hdr[] = { 0xFE, 0xFF, 0x01, 0x00, 0x03 };
  for (i = 0; i < 5; i++)
    {
      hdr = fgetc (pbkf);
      if (hdr != pbk_hdr[i])
	{
	  j++;
	}
    }
  return j;
}
//------------------------------------------------------------------------------
// function to check marker 01:record follows 02: end of records
//------------------------------------------------------------------------------
int
read_marker ()
{
  char m = fgetc (pbkf);
  return m;
}
//------------------------------------------------------------------------------
// function to get record from pbk file
//------------------------------------------------------------------------------
void
get_record ()
{
  unsigned char s1, s2;
  int i, j;
  clear_record ();
  s1 = fgetc (pbkf);
  s2 = fgetc (pbkf);
  recsize = (s2 * 0x100) + s1;
  namesize = fgetc (pbkf);
  phonesize = fgetc (pbkf);
  s1 = fgetc (pbkf);
  s2 = fgetc (pbkf);
  adrsize = (s2 * 0x100) + s1;

  fgets (name_str, namesize + 1, pbkf);
  if (phonesize != 0)
    {
      fgets (phone_str, phonesize + 1, pbkf);
    }
  if (adrsize != 0)
    {
      fgets (address_str, adrsize + 1, pbkf);
    }
  j = recsize - namesize - phonesize - adrsize - 4;
  for (i = 0; i < j; i++)
    {
      fgetc (pbkf);
    }
}
