#ifndef VEC_MATH_H_DEF
#define VEC_MATH_H_DEF

#define mk_po(sname,aaaa,tttt,rrrr) \
     sname.alpha = aaaa;\
     sname.theta = tttt;\
     sname.r     = rrrr;

#define mk_rt(sname,xxxx,yyyy,zzzz) \
     sname.x = xxxx;\
     sname.y = yyyy;\
     sname.z = zzzz;

struct vec_r {
     double x, y, z;
};

struct vec_p {
     double alpha, theta, r;
};

void rect2polar (struct vec_r *rect, struct vec_p *polar);
void polar2rect (struct vec_p *polar, struct vec_r *rect);
double angle (struct vec_r *v1, struct vec_r *v2);
void cross_p (struct vec_r *v1, struct vec_r *v2, struct vec_r *v3);
double dot_p (struct vec_r *v1, struct vec_r *v2);
double modular (struct vec_r *v);
void prn_vec_rect (struct vec_r *rect, char *msg, FILE *stream);
void prn_vec_polar (struct vec_p *polar, char *msg, FILE *stream);

#endif
