#include <stdio.h>
#include <string.h>
#include <dos.h>

#define	THOLD	0x2000

void pset(int x,int y,char color);
int point(int x,int y);

int main(int argc, char *argv[])
{
	union REGS regs;
	char video=0;
	int fp,lenp,i,x,y,size,buf[16008];
	char far *vram=(char far *)0xb8000000;

	if(argc!=4) {
		puts("XBGCV R.1\nusage:\nxbgcv [l|r|c|h|q|k] inputfile outputfile");
	}
	else {
		if(_dos_open(argv[2],0,&fp)==0) {
			_dos_read(fp,(char *)buf,16008,&lenp);
			_dos_close(fp);
			regs.h.ah=0x0f;
			int86(0x10,&regs,&regs);
			video=regs.h.al;
			regs.x.ax=0x0006;
			int86(0x10,&regs,&regs);
			regs.x.cx=0;
			regs.x.dx=0;
			regs.x.di=(unsigned int)buf;
			regs.x.ax=0x0e00;
			int86(0x5f,&regs,&regs);
			for(i=0;i<strlen(argv[1]);i++) {
				buf[0]=1;
				buf[1]=1;
				buf[3]=200;
				regs.x.cx=0;
				regs.x.dx=0;
				regs.x.si=639;
				regs.x.bp=199;
				regs.x.di=(unsigned int)buf;
				regs.x.ax=0x0d00;
				size=16008;
				switch(argv[1][i] & 0xdf) {
				case 'L':
					buf[2]=320;
					regs.x.cx=0;
					regs.x.si=319;
					size=8008;
					break;
				case 'R':
					buf[2]=320;
					regs.x.cx=320;
					regs.x.si=639;
					size=8008;
					break;
				case 'C':
					buf[2]=320;
					regs.x.cx=160;
					regs.x.si=479;
					size=8008;
					break;
				case 'H':
					for(x=0;x<8000;x++) {
						vram[x]&=0xaa;
						vram[x+8192]&=0x55;
					}
					break;
				case 'Q':
					for(x=0;x<8000;x++) {
						vram[x]&=0x44;
						vram[x+8192]&=0x11;
					}
					break;
				case 'K':
					fp=0x100;
					for(x=0;x<640;x++) {
						buf[fp+x]=0x1000/2;
					}
					fp^=0x400;
					lenp=0;
					for(y=0;y<200;y++) {
						for(x=0;x<640;x++) {
							buf[fp+x]=0;
						}
						for(x=0;x<640;x++) {
							lenp+=point(x,y)+buf[(fp^0x400)+x];
							if(lenp>=THOLD) {
								lenp-=THOLD;
								pset(x,y,1);
							}
							else {
								pset(x,y,0);
							}
							lenp/=2;
							buf[fp+x]+=lenp;
						}
						fp^=0x400;
					}
					break;
				}
				int86(0x5f,&regs,&regs);
				if(_dos_creat(argv[3],0,&fp)==0) {
					_dos_write(fp,buf,size,&lenp);
					_dos_close(fp);
				}
			}
			regs.x.ax=video;
			int86(0x10,&regs,&regs);
		}
	}
}

void pset(int x,int y,char color)
{
	union REGS regs;

	regs.h.ah=0x0c;
	regs.h.al=color;
	regs.h.bh=0;
	regs.x.cx=x;
	regs.x.dx=y;
	int86(0x10,&regs,&regs);
}

int point(int x,int y)
{
	union REGS regs;

	if(x<0 || x>639 || y<0 || y>199) {
		return(0);
	}
	regs.h.ah=0x0d;
	regs.h.bh=0;
	regs.x.cx=x;
	regs.x.dx=y;
	int86(0x10,&regs,&regs);
	if(regs.h.al) {
		return(0x1000);
	}
	return(0);
}
