/*
 * Save memory image to a disk file
 *
 * Copyright 1991-1996 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc memsave -fop
 */
#include <stdio.h>

main(argc, argv)
	int argc;
	char *argv[];
{
	unsigned seg, addr, size;
	char buffer[1024];
	FILE *fp;

	if(argc != 3)
		abort("Use: memsave <segment>:<offset>,<size> <filename>");

	/* Process command line args and extract seg, addr, size + filename */
	if(sscanf(argv[1], "%x:%x,%u", &seg, &addr, &size) != 3)
		abort("Invalid segment:offset or size");
	fp = fopen(argv[2], "wvqb");

	/* Copy and save memory 1 buffer at a time */
	while(size > sizeof(buffer)) {
		copy_seg(get_ds(), buffer, seg, addr, sizeof(buffer));
		fput(buffer, sizeof(buffer), fp);
		addr += sizeof(buffer);
		size -= sizeof(buffer); }

	/* Copy and save last partial buffer if any */
	if(size) {
		copy_seg(get_ds(), buffer, seg, addr, size);
		fput(buffer, size, fp); }

	fclose(fp);
}
