@ECHO OFF
rem ***********************************************************************
rem LOADSCHED -- CALLING MERGE/SYNCHRONIZE UTILITIES FROM A BATCH FILE
rem ***********************************************************************

rem This example uses LLRA to copy a user's appt file from the palmtop,
rem Synchronize it with the desktop schedule+, and copy it back.  This is
rem much quicker than performing the synchronize directly on the LLRA drive.

rem ---------------------------------------------------------------------

rem     Use LLRA_ENV /I to test to see if LLRA is installed or not.  A message
rem     will get printed if it isn't loaded or isn't connected.  To see
rem     more options available with LLRA_ENV, type LLRA_ENV /?

cd c:\cpack200
LLRA_ENV /I /s
rem     If LLRA isn't loaded or connected, abort this batch file...
IF ERRORLEVEL 1 GOTO LLRA_ERR

rem     LLRA is connected, so go about our business.
rem     Delete left-over old files
del c:\cpack200\appt.log

rem     These names will change, depending on where your files are on your
rem     desktop or palmtop, what the drive mappings are for LLRA, or
rem     whether you want to copy them off your palmtop at all.
ECHO 
ECHO Copying the Palmtop Appointment file to your PC...
rem  !!!!!!!!!!!!!!!!!!!!  !!!!!!!!!!!!!!!!!!!!!
COPY E:\_DAT\APPT.ADB  C:\CPACK200\APPT.ADB

rem     Check if the pve.ozw file exists
if not exist c:\temp\pve.ozw goto OZW_ERR

ECHO
ECHO Translating Schedule+ file to CDF Format
wizcsv c:\temp\pve.ozw c:\cpack200\pve.cdf

rem     The file is now copied over, so we need to load the Connectivity
rem     Pack support TSR's for running any merge, synchronize, or translate
rem     tasks.
TKERNEL
CG
CLS

rem     Here, we perform the user specific operations.  You can put whatever
rem     merge/sync/xlate tasks you want here.  Look at the file FILETRAN.INI
rem     in the cpack install directory to find the names of the executables
rem     for each task, and all the necessary command line switches.

rem     Actually perform the CDF to Appt translation
echo Translating the CDF file to Appt format
XSTUB A 2 c:\cpack200\pve.cdf 3 c:\cpack200\temp.adb c:\cpack200\appt.log

rem     Merge the two Appt files
echo Synchchronising the Appt files
tinyappt /m0 c:\cpack200\appt.adb c:\cpack200\temp.adb Q c:\cpack200\appt.log 1

rem     Now the appt.adb file is updates
rem     Remove the Connectivity Pack support TSR's.  They must be unloaded
rem     in this order.
CG
UN200

rem     Copy the newly synchronized file back to the palmtop.
ECHO Copying the Appointment file back to your HP 200LX...
copy c:\cpack200\appt.adb e:\_dat\appt.adb

rem     Clean up temporary files
del c:\cpack200\pve.cdf
del c:\cpack200\temp.adb
del c:\temp\pve.ozw
del c:\cpack200\*.ad$

GOTO END

:OZW_ERR
rem    The OZW file could not be found. Ask for it to be exported first
ECHO 
ECHO I could not find the Schedule+ output file c:\temp\pve.ozw
pause
goto end

:LLRA_ERR
rem    There was an LLRA connection error.  Report it to the user and wait
rem    for acknowledgement.
ECHO 
ECHO Problem with LLRA connection. Start Laplink first
PAUSE
:END
