'/* XCOL.BAS Extract column from text  file (make output file) */
'/*          By: Dale Thorn                                    */
'/*          Rev. 26.04.2001                                   */

'$include: 'basdef.h'
'$include: 'filekill.h'
'$include: 'fileopen.h'
'$include: 'longname.h'
'$include: 'messages.h'
'$include: 'midchar.h'
'$include: 'parmstr1.h'
'$include: 'string.h'
'$include: 'basdef.bas'
'$include: 'filekill.bas'
'$include: 'fileopen.bas'
'$include: 'longname.bas'
'$include: 'messages.bas'
'$include: 'midchar.bas'
'$include: 'parmstr1.bas'
'$include: 'string.bas'

ccmd = rtrim$(command$)                    'get the DOS command-line parameters
if ccmd = "" then                     'DOS command-line parameters NOT supplied
   i = ifn.msgs("Usage:  XCOL  filename  offset  length", 5, 24, 79, 0, 1)
end if                                  'display usage message [above] and exit

iprm = parmstr1(ccmd, cfil, cnam, cext, cprm())  'parse command-line parameters
if cnam = "" or len(cnam) > 8 or len(cext) > 3 or instr(cext, ".") then
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if iprm < 0 or iprm > 1 then         'user input too few or too many parameters
   i = ifn.msgs("Invalid number of parameters", 5, 24, 79, 1, 1) 'beep and exit
end if                                  'display error message [above] and exit

isrcofs = pdqvali(cprm(0))                 'get the source (from) column offset
if iprm = 1 then                           'user specified a dest.column length
   idstlen = pdqvali(cprm(1))               'get destination (to) column length
else                                        'user did NOT specify column length
   idstlen = 9999                          'default the dest.(to) column length
end if

if cext = "out" then                       'source filename extension is ".out"
   cdst = cnam + ".tmp"                    'set destination extension to ".tmp"
else                                      'source filename extension NOT ".out"
   cdst = cnam + ".out"                    'set destination extension to ".out"
end if

i = ifn.open(1, cfil, "S", llof)           'open source file in sequential mode
if llof < 0 then                                'user input a wildcard filespec
   i = ifn.msgs("Invalid filename", 5, 24, 79, 1, 1)             'beep and exit
end if                                  'display error message [above] and exit
if llof = 0 then                              'source file nonexistent or empty
   i = ifn.kill(1, cfil)                             'kill the zero-length file
   i = ifn.msgs(cfil + " not found", 5, 24, 79, 1, 1)            'beep and exit
end if                                  'display error message [above] and exit
open cdst for output as 2                     'open the output destination file

i = ifn.msgs("Please standby", 5, 24, 79, 0, 0)        'hide cursor and proceed

while not eof(1)                          'begin loop to read source-file lines
   line input #1, clin                        'read a line from the source file
   print #2, rtrim$(mid$(clin, isrcofs + 1, idstlen)) 'output the new text line
wend

close                                 'close all files in case not closed above
shell "brow " + cdst                                    'browse the output file
system                                                'exit to operating system
