/* CXOR.C Encrypt text by bitwise character masking(XOR) */
/*        By: Dale Thorn                                 */
/*        Rev. 03.03.2003                                */

#include "stdlib.h"
#include "string.h"
#include "stdio.h"
#include "dos.h"
#include "io.h"
#include "ccrp.h"

I spawnlp(I imode, C *cexe, C *cext, C *cfil,...);

V main(I argc, C **argv) {              /* get user's command-line arguments */
   C cmsg[64];                         /* initialize the User message string */
   C cwrd[58] = "!#$%&'()+-.0123456789@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_`{}~";
   C cwrx[58] = "                                                         ";
   U ibuf = 2048;                      /* set the maximum file buffer length */
   C *cchr;                     /* initialize a temporary character variable */
   U idot;                    /* initialize the filename extension separator */
   U idx2;                           /* initialize a temporary loop variable */
   U ilen;                         /* initialize a temporary length variable */
   U indx;                           /* initialize a temporary loop variable */
   U iwrd = strlen(cwrd);             /* initialize length of filename chars */
   L llof;                            /* initialize the file length variable */
   L lrnd;                          /* initialize the randomizer accumulator */
   FILE *ebuf;                         /* get next available DOS file handle */
   U _far *uvadr = 0;                               /* video display pointer */
   I int1[58];                         /* allocate filename sort index array */
   L lnt2[58];                         /* allocate filename sort PRN's array */
   I istk[58];                         /* allocate filename sort stack array */

   if (argc == 1) {                       /* a command line was not supplied */
      strcpy(cmsg, "Usage:  CXOR  filename  [key1  key2  ....]");
      ifn_msgs(cmsg, 4, 24, 79, 0, 1);     /* display usage message and exit */
   }
   if (argc < 3 || argc > 14) {      /* no. of seed keys should be one to 12 */
      ifn_msgs("Invalid number of parameters", 4, 24, 79, 1, 1);
   }                               /* display error message [above] and exit */
   strupr(argv[1]);                         /* uppercase the target filename */
   idot = strcspn(argv[1], "."); /* position of filename extension separator */
   ilen = strlen(argv[1]);                      /* length of target filename */
   if (idot == 0 || idot > 8 || ilen - idot > 4) {        /* filename is bad */
      ifn_msgs("Invalid filename", 4, 24, 79, 1, 1);
   }                               /* display error message [above] and exit */
   if (idot < ilen) {                 /* filename extension separator found! */
      if (strcspn(argv[1] + idot + 1, ".") < ilen - idot - 1) {
         ifn_msgs("Invalid filename", 4, 24, 79, 1, 1);/* 2nd '.' was found! */
      }                            /* display error message [above] and exit */
      if (idot == ilen - 1) {      /* extension separator at end of filename */
         ilen--;                      /* decrement length of target filename */
         argv[1][ilen] = '\0';        /* decrement length of target filename */
      }
   }
   ebuf = fopen(argv[1], "rb+");                   /* open the selected file */
   llof = filelength(fileno(ebuf));           /* get length of selected file */
   if (ebuf == NULL || llof == -1L || llof == 0) {/* length=0 or call failed */
      fclose(ebuf);                               /* close the selected file */
      remove(argv[1]);                          /* kill the zero-length file */
      strcpy(cmsg, argv[1]);                     /* copy filename to message */
      strcat(cmsg, " not found");              /* add "not found" to message */
      ifn_msgs(cmsg, 4, 24, 79, 1, 1);           /* display message and exit */
   }
   ifn_msgs("Applying bitmask", 4, 24, 79, 0, 0);   /* apply bitmask message */
   for (indx = 2; indx < (U)argc; indx ++) {      /* loop thru #of seed keys */
      lrnd = atol(argv[indx]) % (L)1048576;   /* get the randomizer seed key */
      for (idx2 = 0; idx2 < iwrd; idx2++) {   /* loop through array elements */
         int1[idx2] = idx2;              /* offsets from current byte offset */
         lfn_rand(&lrnd);                 /* get the next pseudorandom value */
         lnt2[idx2] = lrnd;                /* put random value to sort array */
      }
      ifn_sort(int1, lnt2, istk, iwrd - 1);         /* sort the random array */
      for (idx2 = 0; idx2 < iwrd; idx2++) {      /* loop thru filename chars */
         cwrx[int1[idx2]] = cwrd[idx2];
      }                     /* shuffle bytes in valid filename chars [above] */
      lrnd = atol(argv[indx]) % (L)1048576;   /* get the randomizer seed key */
      for (idx2 = 0; idx2 < ilen; idx2++) {      /* loop thru filename chars */
         cchr = strchr(cwrx, argv[1][idx2]);  /* filename character position */
         if (cchr == NULL) {              /* character not found in filename */
            ifn_msgs("Invalid character in filename", 4, 24, 79, 1, 1);
         }                         /* display error message [above] and exit */
         lrnd = (lrnd + (cchr - cwrx + 1)) % (L)1048576;/* add value to seed */
         lfn_rand(&lrnd);                     /* reiterate value of seed key */
      }
      itoa(indx - 1, cmsg, 10);                  /* convert 'indx' to string */
      ifn_msgs(cmsg, -21, 24, 79, 0, 0);        /* show layer number message */
      lfn_fxor(ibuf, ebuf, lrnd, llof);       /* apply or remove the bitmask */
   }
   fcloseall();                                      /* close all open files */
   spawnlp(0, "view.exe", "view.exe", argv[1], NULL);  /* browse output file */
}

V lfn_fxor(U ibuf, FILE *ebuf, L lrnd, L llof) { /* perform file XOR process */
   C cmsg[64];                         /* initialize the User message string */
   I ibit;                                /* initialize the random bit value */
   U ibuffbit;                           /* initialize byte pointer variable */
   U ibuffbyt;                         /* initialize buffer pointer variable */
   U ichr1;                             /* initialize byte accumulator value */
   U ichr2;                          /* initialize current buffer byte value */
   U iexp;                             /* initialize the exponent of 2 value */
   L lbyt;                           /* initialize the file pointer variable */
   UC *cbuf = (UC *)malloc(2048);              /* initialize the file buffer */

   for (lbyt = 0; lbyt < llof; lbyt += ibuf) {   /* process in ibuf segments */
      if (llof > (L)ibuf) {                    /* so we don't divide by zero */
         ltoa(lbyt / (llof / 100), cmsg, 10);/* convert percentage to string */
         strcat(cmsg, "%");                  /* append '%' symbol to message */
         ifn_msgs("    ", -24, 24, 79, 0, 0); /* erase prev.complete message */
         ifn_msgs(cmsg, -24, 24, 79, 0, 0);   /* show pct. completed message */
      }
      if (lbyt + ibuf > llof) {          /* curr.file pointer+ibuf spans EOF */
         ibuf = (U)(llof - lbyt);                /* reset file buffer length */
      }
      ifn_read(cbuf, lbyt, ibuf, ebuf); /* read data into source-file buffer */
      for (ibuffbyt = 0; ibuffbyt < ibuf; ibuffbyt++) {/* proc.source buffer */
         ichr1 = 0;                     /* initialize byte accumulator value */
         iexp = 1;                     /* initialize the exponent of 2 value */
         for (ibuffbit = 0; ibuffbit < 8; ibuffbit++) { /* proc.current byte */
            lfn_rand(&lrnd);              /* get the next pseudorandom value */
            if (lrnd < 10) {               /* the pseudorandom value is <= 9 */
               ibit = (I)(lrnd % 2);         /* odd/even value of only digit */
            } else {                      /* the pseudorandom value is >= 10 */
               ibit = (I)((lrnd / 10) % 2);/* odd/even value of last-1 digit */
            }
            ichr1 += ibit * iexp;         /* accumulate bits in current byte */
            iexp *= 2;                      /* increment exponent of 2 value */
         }
         ichr2 = cbuf[ibuffbyt];                /* current buffer byte value */
         cbuf[ibuffbyt] = (UC)(ichr1 ^ ichr2);    /* XOR current buffer byte */
      }
      ifn_write(cbuf, lbyt, ibuf, ebuf); /* write data in source-file buffer */
   }
   free(cbuf);                                 /* deallocate the file buffer */
}

V ifn_sort(I *int1, L *lnt2, I *istk, I imax) {  /* array Quicksort function */
   I iex1;                            /* initialize the outer-loop exit flag */
   I iex2;                            /* initialize the inner-loop exit flag */
   I ilap;                               /* initialize the low array pointer */
   I ilsp;                               /* initialize the low stack pointer */
   I irdx = 0;                                  /* initialize the sort radix */
   I itap;                               /* initialize the top array pointer */
   I itsp;                               /* initialize the top stack pointer */
   I iva1;                  /* initialize array value from low stack pointer */
   L lva2;                  /* initialize array value from low stack pointer */

   istk[0] = 0;                          /* initialize the low array pointer */
   istk[1] = imax;                       /* initialize the top array pointer */
   while (irdx >= 0) {                          /* loop until sort radix < 0 */
      ilsp = istk[irdx + irdx];                 /* set the low stack pointer */
      itsp = istk[irdx + irdx + 1];             /* set the top stack pointer */
      irdx--;                                    /* decrement the sort radix */
      iva1 = int1[ilsp];           /* get array value from low stack pointer */
      lva2 = lnt2[ilsp];           /* get array value from low stack pointer */
      ilap = ilsp;                              /* set the low array pointer */
      itap = itsp + 1;                          /* set the top array pointer */
      iex1 = 0;                       /* initialize the outer-loop exit flag */
      while (!iex1) {                 /* loop to sort within the radix limit */
         itap--;                          /* decrement the top array pointer */
         if (itap == ilap) {         /* top array pointer==low array pointer */
            iex1 = 1;                     /* set the outer-loop exit flag ON */
         } else if (lva2 > lnt2[itap]) {  /* value @low ptr > value @top ptr */
            int1[ilap] = int1[itap];        /* swap low and top array values */
            lnt2[ilap] = lnt2[itap];        /* swap low and top array values */
            iex2 = 0;                 /* initialize the inner-loop exit flag */
            while (!iex2) {         /* loop to compare and swap array values */
               ilap++;                    /* increment the low array pointer */
               if (itap == ilap) {   /* top array pointer==low array pointer */
                  iex1 = 1;               /* set the outer-loop exit flag ON */
                  iex2 = 1;               /* set the inner-loop exit flag ON */
               } else if (lva2 < lnt2[ilap]) {/* value@low ptr<value@low ptr */
                  int1[itap] = int1[ilap];  /* swap top and low array values */
                  lnt2[itap] = lnt2[ilap];  /* swap top and low array values */
                  iex2 = 1;               /* set the inner-loop exit flag ON */
               }
            }
         }
      }
      int1[ilap] = iva1;           /* put array value from low stack pointer */
      lnt2[ilap] = lva2;           /* put array value from low stack pointer */
      if (itsp - ilap > 1) {                     /* low segment-width is > 1 */
         irdx++;                                 /* increment the sort radix */
         istk[irdx + irdx] = ilap + 1;            /* reset low array pointer */
         istk[irdx + irdx + 1] = itsp;            /* reset top array pointer */
      }
      if (itap - ilsp > 1) {                     /* top segment-width is > 1 */
         irdx++;                                 /* increment the sort radix */
         istk[irdx + irdx] = ilsp;                /* reset low array pointer */
         istk[irdx + irdx + 1] = itap - 1;        /* reset top array pointer */
      }
   }
}

V ifn_msgs(C *cmsg, I iofs, I irow, I icol, I ibrp, I iext) {/* display msgs */
   if (iofs >= 0) {                                    /* OK to clear screen */
      io_vcls(7);                                        /* clear the screen */
   }
   io_vdsp(cmsg, 4, abs(iofs), 7);               /* display the user message */
   if (ibrp) {                              /* OK to sound user-alert (beep) */
      printf("\a");                                  /* sound the user-alert */
   }
   if (iext) {                                     /* OK to exit the program */
      io_vcsr(5, 0, 0);                               /* relocate the cursor */
      fcloseall();                                   /* close all open files */
      exit(0);                                              /* return to DOS */
   } else {                                       /* do NOT exit the program */
      io_vcsr(irow, icol, 0);                           /* 'hide' the cursor */
   }
}

V lfn_rand(L *lrnd) {            /* get next pseudorandom number from 'lrnd' */
/* D drnd = (D)*lrnd * (D)214013 + (D)2531011; /* multiply and add magic nos */
/* D dtmp = floor(drnd / (D)1048576) * (D)1048576; /* multiples of 1,048,576 */
/* *lrnd = (L)(drnd - dtmp);                   /* return modulo of 1,048,576 */
   L l1 = *lrnd % 8;                    /* These 5 lines are an integer-only */
   L l2 = (*lrnd - l1) % 16;             /* equivalent to the floating-point */
   L l3 = (*lrnd - l1 - l2) % 64;      /* operations shown above (16-bit DOS */
   L l4 = (*lrnd - l1 - l2 - l3);      /* compiler doesn't have double long) */
   *lrnd = (l1 * 214013 + l2 * 82941 + l3 * 17405 + l4 * 1021 + 2531011) % 1048576;
}

V ifn_read(C *cbuf, L lbyt, U ibuf, FILE *ebuf) {   /* read from binary file */
   fseek(ebuf, lbyt, SEEK_SET);               /* set the buffer-read pointer */
   fread((V *)cbuf, 1, ibuf, ebuf);        /* read data from the binary file */
}

V ifn_write(C *cbuf, L lbyt, U ibuf, FILE *ebuf) {   /* write to binary file */
   fseek(ebuf, lbyt, SEEK_SET);              /* set the buffer-write pointer */
   fwrite((V *)cbuf, 1, ibuf, ebuf);        /* write data to the binary file */
}

U io_vadr(I inop) {                      /* get video address (color or b/w) */
   rg.h.ah = 15;                                   /* video-address function */
   int86(0x10, &rg, &rg);                      /* call DOS for video address */
   if (rg.h.al == 7) {                                /* register A-low is 7 */
      return(0xb000);                                  /* return b/w address */
   } else {                                       /* register A-low is NOT 7 */
      return(0xb800);                                /* return color address */
   }
}

V io_vcls(I iclr) {                                 /* clear screen function */
   I irow;                             /* initialize the row number variable */
   C cdat[81];                             /* initialize the row data buffer */

   memset(cdat, ' ', 80);                       /* clear the row data buffer */
   cdat[80] = '\0';                         /* terminate the row data buffer */
   for (irow = 0; irow < 25; irow++) {          /* loop thru the screen rows */
      io_vdsp(cdat, irow, 0, iclr);       /* display each <blank> screen row */
   }
}

V io_vcsr(I irow, I icol, I icsr) {        /* set cursor position [and size] */
   rg.h.ah = 2;                                  /* cursor-position function */
   rg.h.bh = 0;                                           /* video page zero */
   rg.h.dh = (C)irow;                                          /* row number */
   rg.h.dl = (C)icol;                                       /* column number */
   int86(0x10, &rg, &rg);                     /* call DOS to position cursor */
   if (icsr) {                                      /* cursor-size specified */
      rg.h.ah = 1;                                   /* cursor-size function */
      rg.h.ch = (C)(13 - icsr);                     /* set cursor-begin line */
      rg.h.cl = 12;                                   /* set cursor-end line */
      int86(0x10, &rg, &rg);                  /* call DOS to set cursor size */
   }
}

V io_vdsp(C *cdat, I irow, I icol, I iclr) {       /* display data on screen */
   I ilen = strlen(cdat);                /* length of string to be displayed */
   I iptr;                              /* byte-counter for displayed string */
   U uclr = iclr * 256;                /* unsigned attribute high-byte value */

   if (!uvadr) {                            /* video pointer segment not set */
      FP_SEG(uvadr) = io_vadr(0);               /* set video pointer segment */
   }
   FP_OFF(uvadr) = irow * 160 + icol * 2;        /* set video pointer offset */
   for (iptr = 0; iptr < ilen; iptr ++) {      /* loop thru displayed string */
      *uvadr = uclr + (UC)cdat[iptr];            /* put data to video memory */
      uvadr++;                            /* increment video display pointer */
   }
}
