/* GDB2ADR extracts email addresses from a HP200LX GDB database, so 
 * they can be used in a distribution list for
 * D&A Software's email client Post/LX.
 *
 * (c) 2002 by Daniel Hertrich http://www.daniel-hertrich.de/download
 * 
 * PLEASE BE AWARE THAT THERE IS ALSO A PROGRAM CALLED "PDB2ADR"
 * WHICH LETS YOU CREATE A POST/LX EMAIL PHONEBOOK (POST.ADR)
 * FROM THE HP200LX PHONE BOOK (PHONE.PDB).
 * 
 * needed: GDBIO (http://www.palmtop.net/cgi-bin/search.pl?Query=gdbio)
 *         Post/LX from D&A Software (http://www.dasoft.com)
 *
 * usage:  prepare GDB file with
 *
 *           GDBIO DATABASE.GDB > DATABASE.CDF
 *
 *         use DATABASE.CDF as input file for GDB2ADR and give
 *         as the second parameter the column in the CDF file which
 *         contains the email address. Find that out by loading the 
 *         CDF into an editor and count the columns.
 *
 * example: 
 *     
 *           GDB2ADR DATABASE.CDF 3 > distlist.adr
 *
 *         The distribution list file distlist.adr can then be used
 *         in Post/LX by writing file:distlist.adr into the To: field
 *         of a new email.
 *
 */
 
#define VERSION "1.0"
#define YEAR "2002"
#define TOKLENGTH 80    // maximal length for a token, such as email, phone no, name of phone.cdf
#define LINELENGTH 1024 // maximal length of a line in cdf file

#include <stdlib.h>
#include <stdio.h>
#include <string.h>


FILE *fpi;
int EC;
char testchar;
char line[LINELENGTH];
char email[TOKLENGTH];
char *dup;
char ret = 0;

void hello(char *filename, int EC);
void usage (void);
char *extr_cdf_col(char *cdfline, int c);
void makedistrib(int emailcol);

/* MAIN ============================================== */

int main(int argc, char *argv[])
{
  if (argc != 3) usage();

  EC = atoi(argv[2]);

  hello(argv[1], EC);
  
  if ((fpi=fopen(argv[1],"r"))!=NULL)
  {
    if (EC != 0)  makedistrib(EC);
    else fprintf(stderr,"GDB2ADR:\a\nNothing to do, no column for email given!\n\n");
    fclose(fpi);
    ret = 1;
  }
  else 
  {
    fprintf(stderr,"\n\aError opening input file \"%s\"!\nAbnormal program termination.\n\n",argv[1]);
    ret = 1;
  }
  return(ret);
}



/* HELLO ============================================= */

void hello(char *filename, int EC)
{
  if (filename == NULL)
  {
    filename="NO INPUT FILE NAME GIVEN!";
    ret = 1;
  }
  fprintf(stderr,"\n*** This is GDB2ADR, Version %s, (c) 2002 Daniel Hertrich\n",VERSION);
  fprintf(stderr,"*** Input CDF file: %s\n",filename);
  fprintf(stderr,"*** Column used for reading the email addresses:\n\n", EC);
}

/* USAGE =========================================== */

void usage (void)
{
  printf("\n*** This is GDB2ADR, Version %s, (c) %s Daniel Hertrich\n",VERSION, YEAR);
  printf("\a\n\nError!\nCall of GDB2ADR: GDB2ADR <input CDF file> X > <output ADR file>\n");
  printf("X: number of the CDF file column from which email addresses should be read.\n");
  printf("Are you sure you called GDB2ADR with a CDF file as input? GDB2ADR doesn't\n");
  printf("work with original GDB files, you have to use GDBIO first! See .C file!\n\n");
  exit(1);
}


/* EXTR_CDF_COL ===================================== */
/* give parameters:
      1. copy of a line of a cdf file (made by gdbio)
      2. number of column you want to extract
   get back:
      pointer to string containing string of given column
*/

char *extr_cdf_col(char *cdfline, int c)
{
  static char token[TOKLENGTH];
  char *loc;
  char *temptok = malloc(LINELENGTH*sizeof(char));
  int i = 0;

  temptok[0]=0;
    
  for (i=0; i<c; i++)
  {
    if (i>0) cdfline=loc+3;
    loc=strstr(cdfline,"\",\"");
    if (loc != NULL)
    { 
      strncpy(temptok,cdfline,loc-cdfline);
      temptok[loc-cdfline]='\0';
    }
    else fprintf(stderr,"ERROR! Contact Author! loc is NULL!, c is %i\nCDFLINE is: %s\a\a",c,cdfline);
  }
  strcpy(token,temptok);
  free(temptok);
  return(token);
}


void makedistrib(int emailcol)
{
  static int linecount=0;
  char *lineshort;

  while((testchar=fgetc(fpi))!= EOF)
  {
    fgets(line, LINELENGTH, fpi);
    linecount++;
    strcpy(email,extr_cdf_col(line,emailcol));
    strncpy(lineshort,line,60);
    if (strlen(email) > 0)
    {
      if ((strchr(email,'\@') != NULL) && (strchr(email,' ') == NULL)) 
         printf("%s\n",email);
      else 
      {
        fprintf(stderr,"\a%i: INVALID EMAIL ADDRESS: %s\n\"%s...\n\n",linecount,email,lineshort);
        ret = 1;
      }
    }
  }

  
}

