code SEGMENT PARA
ASSUME ds:nothing,cs:code

 dailytime      equ     0f427h   ; address of "daily greeting crossover" time

 HIR            EQU     22H     ; Hornets Index Register
 HDR            EQU     23H     ; Hornets Data Register
 ;
 ; Write Protect Register.  8 MSB's of 20-bit CPU Address.  This feature
 ; provides 4KByte write protection resolution from a given CPU Address
 ; thru 9FFFFh.   If X is the CPU Address specified by the value in WPR,
 ; then all Addresses A such that:  X <= A <= 9FFFFh  are write protected.
 ;
 WPR            EQU 87h ; R/W   Write Protect Register (CPU Addr [19:12])


 ORG 100h
MAIN PROC FAR
      call get_time
      call print_time
      call SetDailyTime
      mov ax, 4c00h
      int 21h 
MAIN ENDP

 ;****************************************************************************
 ; read digit from command line and return value in ax
 ; (cs:[dx] must point to digit on command line)

get_digit PROC NEAR
      push bx
      mov bx, dx
      mov ah, 0
      mov al, cs:[bx]
      pop bx
      sub al, '0'
      jb  error
      cmp al, 9
      ja  error
      ret
error:pop bx
      mov ax, cs
      mov ds, ax
      mov dx, offset cs:errmessg
      mov ah, 9
      int 21h
      mov ax, 4c01h
      int 21h

get_digit ENDP

 ;****************************************************************************
 ; read time from command line and return in BX

get_time PROC NEAR
      mov dx, 82h
      call get_digit
      mov cx, 600
      mul cx
      mov bx, ax 
      mov dx, 83h
      call get_digit
      mov cx, 60
      mul cx
      add bx, ax
      mov dx, 84h
      call get_digit
      mov cx, 10
      mul cx
      add bx, ax
      mov dx, 85h
      call get_digit
      add bx, ax
      ret
get_time ENDP

 ;****************************************************************************
 ; print confirmation to stdout

print_time PROC NEAR
      push bx
      mov ax, cs
      mov ds, ax
      mov dx, offset cs:confirm
      mov ah, 9
      int 21h
      mov bx, 86h
      mov byte ptr [bx], '$'
      mov dx, 82h
      mov ah, 9
      int 21h 
      mov dx, offset cs:crlf
      mov ah, 9
      int 21h
      pop bx
      ret
print_time ENDP

 ;****************************************************************************
 ; UnProtect: Un Write-Protect RAM, and return old protection boundary and
 ;            old Hornet Index register value.
 ;
 ; Entry: None
 ; Alters: CPU - ax;     HORNET - HIR, WPR
 ; Exit:         ah:old protection boundary  (for later restore).
 ;               al:old Index reg value (for later restore).
 ;*****************************************************************************

 UnProtect PROC NEAR
                push    bx
                in      al,HIR          ; read old Index reg value
                mov     bl,al           ; save it temporarily
                mov     al,WPR
                out     HIR,al
                in      al,HDR
                mov     ah,al           ; ah: Old protection boundary.
                mov     al,0A0h
                out     HDR,al          ; Unprotect!
                mov     al,bl           ; al: Old Index reg value
                pop     bx
                ret
 Unprotect ENDP

 ;****************************************************************************
 ; Protect: Store specified Write-Protect Boundary for the RAM and
 ;          restore Hornet Index register.
 ;
 ; Entry: ah: Value to write to WPR register
 ;        al: Hornet Index register value to restore.
 ; Alters: CPU - al;     HORNET - HIR, WPR
 ; Exit:   Value written to WPR
 ;         Value written to HIR
 ;
 ;    CAUTION:  Some callers assume that the CARRY flag is not altered!
 ;****************************************************************************
 Protect PROC NEAR
                push    bx
                mov     bl,al   ; save Index reg value temporarily.
                mov     al,WPR
                out     HIR,ax  ; Restore old protection boundary.
                mov     al,bl
                out     HIR,al  ; Restore old Hornet index register.
                pop     bx
                ret
 Protect ENDP

 ;
 ; TOE NEXT TURN ON.

 SetDailyTime PROC NEAR
        push    ds
        mov     ax,9000h
        mov     ds,ax

        call    UnProtect
        mov     ds:dailytime,bx            ; save crossover time setting
        call    Protect
        pop     ds

        ret
 SetDailyTime ENDP

errmessg DB "USAGE: GREETIME hhmm"
crlf     DB 13, 10, "$"
confirm  DB "Greeting time set to $"

code ENDS
END MAIN
