code SEGMENT PARA
ASSUME ds:nothing,cs:code

 dailyflags     equ     0f426h   ; address of flags byte for daily greeting

 HIR            EQU     22H     ; Hornets Index Register
 HDR            EQU     23H     ; Hornets Data Register
 ;
 ; Write Protect Register.  8 MSB's of 20-bit CPU Address.  This feature
 ; provides 4KByte write protection resolution from a given CPU Address
 ; thru 9FFFFh.   If X is the CPU Address specified by the value in WPR,
 ; then all Addresses A such that:  X <= A <= 9FFFFh  are write protected.
 ;
 WPR            EQU 87h ; R/W   Write Protect Register (CPU Addr [19:12])


 ORG 100h
MAIN PROC FAR
      call DispDailyGreeting
      mov ax, 4c00h
      int 21h 
MAIN ENDP

 ;****************************************************************************
 ; UnProtect: Un Write-Protect RAM, and return old protection boundary and
 ;            old Hornet Index register value.
 ;
 ; Entry: None
 ; Alters: CPU - ax;     HORNET - HIR, WPR
 ; Exit:         ah:old protection boundary  (for later restore).
 ;               al:old Index reg value (for later restore).
 ;*****************************************************************************

 UnProtect PROC NEAR
                push    bx
                in      al,HIR          ; read old Index reg value
                mov     bl,al           ; save it temporarily
                mov     al,WPR
                out     HIR,al
                in      al,HDR
                mov     ah,al           ; ah: Old protection boundary.
                mov     al,0A0h
                out     HDR,al          ; Unprotect!
                mov     al,bl           ; al: Old Index reg value
                pop     bx
                ret
 Unprotect ENDP

 ;****************************************************************************
 ; Protect: Store specified Write-Protect Boundary for the RAM and
 ;          restore Hornet Index register.
 ;
 ; Entry: ah: Value to write to WPR register
 ;        al: Hornet Index register value to restore.
 ; Alters: CPU - al;     HORNET - HIR, WPR
 ; Exit:   Value written to WPR
 ;         Value written to HIR
 ;
 ;    CAUTION:  Some callers assume that the CARRY flag is not altered!
 ;****************************************************************************
 Protect PROC NEAR
                push    bx
                mov     bl,al   ; save Index reg value temporarily.
                mov     al,WPR
                out     HIR,ax  ; Restore old protection boundary.
                mov     al,bl
                out     HIR,al  ; Restore old Hornet index register.
                pop     bx
                ret
 Protect ENDP

 ;
 ; TO CAUSE THE DAILY GREETING TO POP UP IMMEDIATELY, EXECUTE THE FOLLOWING
 ; ROUTINE.
 ;

 DispDailyGreeting PROC NEAR
        push    ds
        mov ax,9000h
        mov     ds,ax

        call    UnProtect
        or      byte ptr ds:dailyflags,40h          ; set flag to DO GREETING
        call    Protect
        pop     ds

        ret
 DispDailyGreeting ENDP

code ENDS
END MAIN
