#
# Object which stores information about a picture
#
#  http://www.berkhirt.com/HomerProductions/
#  bhirt@berkhirt.com
#
# Copyright (c) 1998 by Brian Hirt, all rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

package DC50PictureInfo;

use DCPictureInfo;

@ISA = qw(DCPictureInfo);

sub new
{
  my $class = shift;

  $class->SUPER::new();
}

sub _setResolutionId
{
# private method, sets the picture resoution id
  my $this = shift;

  $this->{'resolutionId'} = shift;
}

sub resolutionId
{
# returns the picture resolution id 
  my $this = shift;

  return $this->{'resolutionId'};
}

sub resolution
{
# returns the resolution of the picture.
  my $this = shift;

  return DCUtils->resolutionWithId($this->resolutionId);
}

sub _setCompressionModeId
{
# private method, sets the compression mode id
  my $this = shift;

  $this->{'compressionModeId'} = shift;
  'N/A';
}

sub compressionModeId
{
# returns the compression mode for the picture
  my $this = shift;

  return $this->{'compressionModeId'};
  'N/A';
}

sub compressionMode
{
  my $this = shift;

  return DCUtils->compressionModeWithId($this->compressionModeId);
  'N/A';
}

1;
