
#  http://www.berkhirt.com/HomerProductions/
#  bhirt@berkhirt.com
#
# Copyright (c) 1998 by Brian Hirt, all rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

package DC;

# Generic packages
use DCHandle;
use DCUtils;

# Perl libraries
use POSIX;
use Carp;


$debug = 0;

sub new
{
  my $class = shift;
  my $this = {};

  bless $this, $class;

  return $this;
}

sub setDcHandle
{
  my $this = shift;

  $this->{'dcHandle'} = shift;
}

sub dcHandle
{
  my $this = shift;

  $this->{'dcHandle'};
}

sub cachedStatus
{
  my $this = shift;

  $this->{'cachedStatus'};
}

sub clearCachedStatus
{
  my $this = shift;

  delete $this->{'cachedStatus'};
}

sub setCachedStatus
{
  my $this = shift;

  $this->{'cachedStatus'} = shift;
}

sub status
{
  my $this = shift;

  my $status;

  if (defined($this->cachedStatus))
  {
    $status = $this->cachedStatus;
  }
  else
  {
    $status = $this->loadStatusFromCamera;
    $this->setCachedStatus($status);
  }

  return $status;
}

1;
