/* html.c   Part of dox.c handles the html reading and writing. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dox.h"

#define HTML_ESCAPED 4

char *html_style[MAXSTYLES][2] = {
        {"<html>\n","</html>\n"},
        {"<br>\n",""},
        {"<p>\n",""},
        {"<center>","</center>"},
	{"",""},
	{"",""},
	{"<font size=","</font>"},
	{"<b>","</b>"},
	{"<i>","</i>"},
	{"<em>","</em>"}
        };



char *html_escape[HTML_ESCAPED] = {"&amp;", "&lt;", "&gt;", "&quot;"};
char *html_normal[HTML_ESCAPED] = {"&", "<" , ">" , "\""};


void html_readword(FILE *instream, char *word);
void html_paragraph(state_type *state, char *word);


void html_convert(state_type *state)
{
char word[81];
short count;
default_style(state, TRUE);
update_style(state);

while (!feof(state->in))
	{
        html_readword(state->in, word);
        switch(word[0])
		{
                case '<':
                case '&':
                                html_paragraph(state, word);
                               /*Also changes style info. */
			break;

		case '\r':
		case '\n':
                        update_style(state);
			break;

		default:
                        update_style(state);
                        output(state, word);
                        break;
		}
        }

state->new[st_begin]=FALSE;
update_style(state);

}


/* Ouput a word to the output stream. */
void html_output(state_type *state, char *word)
{
unsigned count, count2, done;

for (count=0;count<strlen(word);count++)
                {
                done = FALSE;
                for (count2=0;((count2<HTML_ESCAPED)&&(!done));count2++)
                        if (word[count]==html_normal[count2][0])
                                {
                                fprintf(state->out, "%s", html_escape[count2]);
                                done = TRUE;
                                }
                if (!done)
                        fprintf(state->out, "%c", word[count]);
                }
}



void html_paragraph(state_type *state, char *word)
{
unsigned wordlen;
unsigned count;
char *found_style=NULL;
char extraword[81];

/* Output escape characters. */
if (word[0]=='&')
        {
        for (count=0;count<HTML_ESCAPED;count++)
                if (!strcmp(html_escape[count], word))
                        {
                        output(state, html_normal[count]);
                        return;
                        }

        return;
        }


while(word[strlen(word)-1]!='>')
        {
        html_readword(state->in, extraword);
        strcat(word, extraword);
        }

/* Search for code in html array. */
for (count=1;count<MAXSTYLES;count++)
        if ((found_style=strstr(html_style[count][0], word))==html_style[count][0])
		break;
     
if (found_style!=NULL)
        {
        switch(count)
                {
                case st_break:
                        state->new[count]++;
                        break;
                case st_paragraph:
                        state->new[st_break] = state->new[st_break] + 2;
                        break;
                default:
                        state->new[count] = TRUE;
                }
        return;
        }


/* Search for code in html array. */
for (count=1;count<MAXSTYLES;count++)
        if ((found_style=strstr(html_style[count][1], word))==html_style[count][1])
		break;
     

if (found_style!=NULL)
        {
        state->new[count] = FALSE;
        return;
        }
}



void html_update_style(state_type *state)
{
unsigned count, count2;

/* Turn off the necessary styles. */
for (count=0;count<MAXSTYLES;count++)
        if ((!state->new[count])&&(state->current[count]))
		{
                state->current[count]=FALSE;
		if (count==st_fontsize)
			for (count2=st_fontsize+1;count2<MAXSTYLES;count2++)
                                state->current[count2]=FALSE;

		if (*html_style[count][1]!='\0')
                        fprintf(state->out, "%s", html_style[count][1]);
		}


/* Change font sizes */
if ((state->new[st_fontsize]!=state->current[st_fontsize])&&state->new[st_fontsize])
	{
        if (state->current[st_fontsize])
                fprintf(state->out, "%s", html_style[st_fontsize][1]);
        fprintf(state->out, "%s%i>", html_style[st_fontsize][0], state->new[st_fontsize]/4);
        state->current[st_fontsize] = state->new[st_fontsize];
	}



/* Put in breaks. */
for(;state->new[st_break]>0;state->new[st_break]--)
        fprintf(state->out, "%s", html_style[st_break][0]);

/* Switch on the necessary styles. */
for (count=0;count<MAXSTYLES;count++)
        if ((state->new[count])&&(!state->current[count])&&(count!=st_begin))
		{
                state->current[count]=TRUE;
                fprintf(state->out, "%s", html_style[count][0]);
		}

/* If at the end of the file declare end of html. */
if ((state->new[st_begin])&&(!state->current[st_begin]))
        {
        state->current[st_begin]=TRUE;
        fprintf(state->out, "%s", html_style[st_begin][0]);
        }

}


void html_readword(FILE *instream, char *word)
{
unsigned c;
unsigned count=0;
unsigned done=FALSE;

while ((count<80)&&(!done)&&(!feof(instream)))
	{
        word[count] = fgetc(instream);
        done=(strrchr("\r\n>", word[count])!=NULL);
	count++;

	c = nextchar(instream);
        done=((strrchr("\r\n\t<>&; ",c)!=NULL)||done);
        if ((c=='>')||(c==';'))
		{
                word[count] = fgetc(instream);
		count++;
		}
	}

word[count]='\0';
}
