; emmmem.asm - memory window operations
; Copyright(C) 1994 Hiroyuki Sekiya


		IDEAL
		INCLUDE "emm200.inc"
		INCLUDE "emm67h.h"
		INCLUDE "emmmem.h"


SELECTOR_BASE	=	(FRAME_SEG SHR 9) + 20h  ; = 0x88
; Selector base is the register # of the first memory bank control register
; for the HORNET chip

SEGMENT		_DEV

; maps the logicalRAM address into a physical map page
; ->	bx  Physical Page no to map
;	    dx	Logical 16K ram page to map
; <-	--
; ><	--
		EVEN
PROC	map_ram_page
		pushm	ax, dx

		in	al, 22h  ; save current state of index register
		push	ax

		mov	ax, bx
		add	ax, ax	; page *= 2
		add	al, SELECTOR_BASE
		mov	ah, dl  ; = logical page #
		shrm	ah, 4	; / 16 = no of 256 byte boundary
IF HP200 EQ 2
		and	ah, 01h
ENDIF
		out	22h, ax

		inc	ax
		mov	ah, dl
		shlm	ah, 4
IF HP200 EQ 2
		shrm	dl, 5
ELSEIF HP200 EQ 4
		shrm	dl, 6
		and		dl, 2
ELSE
	ERR
	DISPLAY "Hp200LX Model must be defined as either 2MB or 4MB!"
ENDIF
		add	dl, 9
		or	ah, dl
		out	22h, ax

		pop	ax
		out	22h, al

		popm	dx, ax
		ret
ENDP

; ->	bx	frame number
; <-	--
; ><	--
		EVEN
PROC		unmap_ram_page
		push	ax

		in	al, 22h
		push	ax

		mov	ax, bx
		add	ax, ax
		add	al, SELECTOR_BASE
		out	22h, ax ;register selection 88H 8aH 8cH

		inc	ax
		out	22h, ax

		pop	ax
		out	22h, al

		pop	ax
		ret
ENDP

; save the mapping registers before we modify them
; ->	es:di	buffer in which to save registers
; ><	--
		EVEN
PROC		save_map_reg
		pushm	ax, cx, dx, di

		in	al, 22h
		mov	ah, al

		mov	cx, [cs:max_frame]
		add	cx, cx
		mov	dx, 23h
		mov	al, SELECTOR_BASE
		EVEN
	@@loop:
		out	22h, al
		inc	al
		insb
		loop	@@loop

		mov	al, ah
		out	22h, al

		popm	di, dx, cx, ax
		ret
		ENDP

; EBhẼ}bvԂ𕜋A
; ->	cx	y[W
;	ds:si	͌
; ><	--
		EVEN
PROC		restore_map_reg
		pushm	ax, cx, dx, si

		in	al, 22h
		mov	ah, al

		mov	cx, [cs:max_frame]
		add	cx, cx
		mov	dx, 23h
		mov	al, SELECTOR_BASE
		EVEN
	@@loop:
		out	22h, al
		inc	al
		outsb
		loop	@@loop

		mov	al, ah
		out	22h, al

		popm	si, dx, cx, ax
		ret
ENDP

ENDS		_DEV

		END
