/*
	txt2icn.c: txt to icn
		ver. 1.00 1995-10-18
		ver. 1.01 1995-10-20
		ver. 1.02 1996- 2- 2
			using _dos_getfileattr() for testing if icnfile exists or not
		ver. 1.10 1996- 5- 1
			add -s option : input from stdin
			using int 16h for getting key-board
	
	(c)chawa (Naohiko Kawamura)
	
*/
#include	<stdio.h>
#include	<ctype.h>
#include	<io.h>
#include	<conio.h>
#include	<dos.h>
#include	<errno.h>

#define	TRUE	(1==1)
#define	FALSE	(!TRUE)
#define	NUMOFCOLUMN	(32)
#define	BITOFROW	(44)
#define	HEADERLEN	(8)
#define	BYTEOFROW	((BITOFROW+7)/8)
#define	LBUF	(1024)
#define	NOTOPENICN	(1)
#define	NOTOPENTXT	(2)
#define	DEFAULTNAME	"t2i.icn"

int	strcpy(char *,char *);
int	strlen(char *);
char	*strchr(char *,char);
char	getche(void);
void	exit(int);

char
*str2bit(c,num,onchar)	/* string to bit */
	char	*c;
	int	num;
	char	onchar;
	{
	int	i;	/* counter */
	static	char	bitstr[BYTEOFROW];
	
	for (i=0;i<BYTEOFROW;i++)
		bitstr[i]=0;
	
	num=num<strlen(c) ? num : strlen(c)-1 ;
	for (i=0;i<num;i++)
		bitstr[i/8]|=(*(c+i)==onchar ? 1 : 0 )<<(7-(i%8));
	
	return &bitstr[0];
	}

char
getkb()
	{
	/* get code from key-board */
	
	union REGS inregs;
	union REGS outregs;
	
	inregs.h.ah=0x00;
	
	int86(0x16,&inregs,&outregs);
	
	return outregs.h.al;
	}

int
geticn(txtname,overwrite,icnname,onchar,conin)
	char	*txtname;
	int	overwrite;
	char	*icnname;
	char	onchar;	/* on char. */
	int	conin;	/* switch if input from console */
	{
	FILE	*txtfp;
	FILE	*icnfp;
	char	buf[LBUF];
	char	*rawdata;
	char	icndata[BYTEOFROW*NUMOFCOLUMN+HEADERLEN];	/* raw data of *.icn */
	unsigned	int	attr;	/* attribute */
	int	i,j;	/* counter */
	char	c;
	
	if (conin)
		txtfp=stdin;
	else if ((txtfp=fopen(txtname,"r"))==NULL)	/* cannot open text file */
		return NOTOPENTXT;
	
	for(i=0;i<NUMOFCOLUMN;i++)
		{
		if (fgets(buf,LBUF,txtfp)!=0)
			rawdata=str2bit(buf,BITOFROW,onchar);
		else
			rawdata=str2bit("",BITOFROW,onchar);
		
		for (j=0;j<BYTEOFROW;j++)
			icndata[i*BYTEOFROW+j+HEADERLEN]=*(rawdata+j);
		}
	
	fclose(txtfp);
	
	icndata[0]=0x01;
	icndata[1]=0x00;
	icndata[2]=0x01;
	icndata[3]=0x00;
	icndata[4]=0x2c;
	icndata[5]=0x00;
	icndata[6]=0x20;
	icndata[7]=0x00;
	
	if (_dos_getfileattr(icnname,&attr)!=ENOENT && !overwrite)	/* already exists */
		{
		fputs("\nIcon file \"",stderr);
		fputs(icnname,stderr);
		fputs("\" already exists. Overwrite? (y/else)",stderr);
		c=getkb();
		fputc(c,stderr);
		if ((c!='y')&&(c!='Y'))	return 0;
		}
	if ((icnfp=fopen(icnname,"wb"))==NULL)	/* cannot open icn-file */
		return NOTOPENICN;
	
	for (i=0;i<BYTEOFROW*NUMOFCOLUMN+HEADERLEN;i++)
		fputc(icndata[i],icnfp);
	fclose(icnfp);
	
	return 0;
	}

char
*geticnname(txtname)
	char	*txtname;
	{
	static	char	icnname[80];
	char	*loc;	/* location of '.' */
	int	len;	/* length of icnname */
	
	strcpy(icnname,txtname);
	if ((loc=strchr(icnname,'.'))==NULL)
		{
		/* without extention */
		len=strlen(icnname);
		icnname[len]='.';
		loc=&icnname[len];
		}
	strcpy(loc+1,"icn");
	
	return &icnname[0];
	}

usage(void)
	{
	fputs("\n\ttxt2icn ver 1.02 : txt to icn converter (c)chawa\n\n",stderr);
	fputs("\tUsage: txt2icn [-w] [-s] [-oicnfile] [-n[a]] filenames... \n",stderr);
	fputs("\t\t-w : overwrite even if icon file exists\n",stderr);
	fputs("\t\t-s : input from standard-in\n",stderr);
	fputs("\t\t-o : output file-name is disignated as 'icnfile'\n",stderr);
	fputs("\t\t-n[a] : set 'a' as on-char.  (if not exist 'a' then blank)\n",stderr);
	
	return;
	}

void
errout(s,filename)
	char	*s,*filename;
	{
	fputs("\n\terror : ",stderr);
	fputs(s,stderr);
	fputs(" \"",stderr);
	fputs(filename,stderr);
	fputs("\"\n",stderr);
	return;
	}

main(argc,argv)
	int	argc;
	char	**argv;
	{
	int	progstat=0;
	char	*icnname;
	int	appout=FALSE;	/* switch if output is appointed */
	int	overwrite=FALSE;	/* switch overwrite/not when exist */
	int	conin=FALSE;	/* switch if input from console */
	char	onchar='1';
	
	if (argc<2)
		{
		progstat++;
		usage();
		}
	else
		{
		while(--argc)
			{
			if (**++argv=='-' || **argv=='/')
				{
				/* analyze switch */
				switch(*++*argv)
					{
					case 'w':
					case 'W':
						overwrite=TRUE;
						break;
					case 'n':
					case 'N':
						onchar =*++*argv ? **argv : ' ';
						break;
					case 's':
					case 'S':
						conin=TRUE;
						break;
					case 'o':
					case 'O':
						if (*++*argv)
							{
							appout=TRUE;
							icnname=*argv;
							}
						else
							{
							--*argv;
							errout("missing operand ",--*argv);
							}
						break;
					default:
						progstat++;
						errout("illegal option ",--*argv);
					}
				}
			else
				{
				/* when input from file(s) */
				if (conin) conin=FALSE;
				if (!appout)
					icnname=geticnname(*argv);
				switch(geticn(*argv,overwrite,icnname,onchar,conin))
					{
					case NOTOPENTXT:
						errout("cannot open text-file:",*argv);
						progstat++;
						break;
					case NOTOPENICN:
						errout("cannot open icn-file:",icnname);
						progstat++;
						break;
					}
				}
			}
		
		if (conin)
			{
			/* when input from stdin */
			if (!appout)
				icnname=DEFAULTNAME;
			geticn("",overwrite,icnname,onchar,conin);
			}
		}
	
	exit(progstat);
	}
