/*
 * OPEN Version 1.00
 * Copyright(C) 1995 Hiroyuki Sekiya
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#ifdef __TURBOC__
#include <dir.h>
#else
#define MAXPATH		80
#define MAXDIR		66
#define MAXFILE		9
#define MAXEXT		5
#define fnsplit		_splitpath
#define setvect		_dos_setvect
#endif


#define MENUKEY 0xC800
#define	countof(x) (sizeof(x)/(sizeof((x)[0])))

typedef unsigned char	BYTE;
typedef unsigned int	WORD;

typedef struct sAPPINFO {
	char *ext;
	char *envname;
	WORD envofs;
	WORD keycode;
} APPINFO;

APPINFO appinfo[] = {
	{ ".gdb", "c:\\_dat\\db.env",     0x00, 0xBA00 },
	{ ".ndb", "c:\\_dat\\note.env",   0x00, 0xBE00 },
	{ ".pdb", "c:\\_dat\\phone.env",  0x00, 0xB400 },
	{ ".adb", "c:\\_dat\\apptbk.env", 0x00, 0xB000 },
	{ ".wdb", "c:\\_dat\\world.env",  0x00, 0xC600 }
};

int fexist(const char *name)
{
	FILE *fp;

	if ((fp = fopen(name, "rb")) == NULL)
		return 0;
	else {
		fclose(fp);
		return 1;
	}
}

void PushKey(WORD keycode)
{
#ifdef __TURBOC__
	_CX = keycode;
	_AH = 0x05;
	geninterrupt(0x16);
#else
	_asm {
		mov		cx, keycode
		mov		ah, 0x05
		int		0x16
	};
#endif
}

int launch(const char *dir, const char *name, const char *ext)
{
	FILE *fp;
	static char path[MAXPATH];
	WORD i;

	if (*ext == '\0') {
		for (i=0; i<countof(appinfo); ++i) {
			strcat(strcat(strcpy(path, dir), name), appinfo[i].ext);
			if (fexist(path)) goto LAUNCH;
		}
		return 0;
	} else {
		strcat(strcat(strcpy(path, dir), name), ext);
		for (i=0; i<countof(appinfo)-1; ++i)
			if (stricmp(appinfo[i].ext, ext) == 0 && fexist(path))
				goto LAUNCH;
		return 0;
	}
LAUNCH:
	if ((fp = fopen(appinfo[i].envname, "r+b")) == NULL)
		return 0;
	fseek(fp, appinfo[i].envofs, SEEK_SET);
	fwrite(path, sizeof(path[0]), strlen(path)+1, fp);
	fclose(fp);
	PushKey(appinfo[i].keycode);
	return 1;
}

int main(int argc, char **argv)
{
	static char basedir[MAXPATH];
	static char dir[MAXDIR];
	static char name[MAXFILE];
	static char ext[MAXEXT];
	char *dbpath;
	char *p;

	if (argc < 2) {
		fputs("OPEN Version 1.00 Copyright(C) 1995 Hiroyuki Sekiya\n", stderr);
		fputs("Usage: open <filename>\n", stderr);
		return 1;
	}

	/* fBNgAt@CAgqɕ */
	fnsplit(argv[1], basedir, dir, name, ext);
	strcat(basedir, dir);
	if (launch(basedir, name, ext))
		return 0;
	else if (*basedir == '\0') {
		dbpath = getenv("DBPATH");
		if (*dbpath == '\0') dbpath = "a:\\_dat;c:\\_dat";
		while (*dbpath != '\0') {
			if (*dbpath == ';') ++dbpath;
			p = basedir;
			while (*dbpath != '\0' && *dbpath != ';') *p++ = *dbpath++;
			if (*(p-1) != '\\') *p++ = '\\';
			*p = '\0';
			if (launch(basedir, name, ext)) return 0;
		}
	}
	fputs("File not found.\n", stderr);
	return 1;
}
