#
# Copyright (c) 1998 by Brian Hirt, all rights reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

package DCUtils;

# battery descriptions
my $batteryStates = {};
$batteryStates->{'0'} = "full";
$batteryStates->{'1'} = "low";
$batteryStates->{'2'} = "empty";

# Flash modes descriptions
my $flashModes = {};
$flashModes->{'0'} = "auto";
$flashModes->{'1'} = "fill";
$flashModes->{'2'} = "off";
$flashModes->{'3'} = "auto red-eye";
$flashModes->{'4'} = "fill red-eye";

$DC50_CAMERA_TYPE  = 0x01;
$DC120_CAMERA_TYPE = 0x02;
$DC200_CAMERA_TYPE = 0x03;
$DC210_CAMERA_TYPE = 0x04;

# Known camera types
my $cameraTypes = {};
$cameraTypes->{$DC50_CAMERA_TYPE}  = 'Kodak DC50';
$cameraTypes->{$DC120_CAMERA_TYPE} = 'Kodak DC120 Zoom';
$cameraTypes->{$DC200_CAMERA_TYPE} = 'Kodak DC200';
$cameraTypes->{$DC210_CAMERA_TYPE} = 'Kodak DC210 Zoom';

# Known compression modes
my $compressionModes = {};
$compressionModes->{'0'} = 'none';
$compressionModes->{'1'} = 'low';
$compressionModes->{'2'} = 'medium';
$compressionModes->{'3'} = 'high';

my $resolution = {};
$resolution->{'0'}   = '640x480';  # DC210/DC200
$resolution->{'1'}   = '1152x864'; # DC210/DC200
$resolution->{'50'}  = '768x512';  # hack for DC50, all DC50 pictures are 
				   # actually 768x512
$resolution->{'120'} = '848x488';  # hack for DC120, all DC120 pictures are 
				   # actually 848x488

sub description
{
  my $this = shift;
  my $hash = shift;
  my $id = shift;

  my $descr;

  if (defined($id))
  {
    if (defined($hash->{$id}))
    {
      $descr = $hash->{$id};
    }
    else
    {
      $descr = "unknown ($id)";
    }
  }
  else
  {
    $descr = "undefined";
  }

  return $descr;
}

sub resolutionWithId
{
# returns the resolution
  my $this = shift;
  my $id = shift;

  return $this->description($resolution,$id);
}

sub flashModeWithId
{
# returns the flash mode description
  my $this = shift;
  my $id = shift;

  return $this->description($flashModes,$id);
}

sub compressionModeWithId
{
# returns the compression mode (low/med/high)
  my $this = shift;
  my $id = shift;

  return $this->description($compressionModes,$id);
}

sub cameraTypeWithId
{
# returns the camera type description
  my $this = shift;
  my $id = shift;

  return $this->description($cameraTypes,$id);
}

sub batteryStatus
{
# returns the status of the battery
  my $this = shift;
  my $id = shift;

  return $this->description($batteryStates,$id);
}

1;
