/* DIAL.EXM  v.1.0		1997-03-07  Toshiki		*/

#include  "lxapi.h"
#include <string.h>

#define CFGFILESPEC "C:\\_DAT\\DIAL.CFG"
#define CFGFILELEN  (16)
#define CFGDEFAULT  "COM1:AT&FD:;:ATH0"
#define CFGDEFLEN   (17)
#define ENTERKEY	0x0d
#define SPACEKEY	0x20
#define ESCKEY		0x1b

char far *msgnull="";
char far *msgAppName="Dial";

int		TxLength,ComHandler;
int		PortID=1;
char	TxBuffer[80], CbBuffer[80], CfgBuffer[80];
char	ModemCommand[80], ModemReset[80];
ComSettings_t  ComSettings;

char far *TxLengthPtr=(char *)&TxLength;
char far *ComHandlerPtr=(char *)&ComHandler;
char far *PortIDPtr=(char *)&PortID;
char far *TxBufferPtr=TxBuffer;
char far *CbBufferPtr=CbBuffer;
char far *CfgBufferPtr=CfgBuffer;
char far *ModemCommandPtr=ModemCommand;
char far *ModemResetPtr=ModemReset;
char far *ComSetPtr=( char * )&ComSettings;

char far **StringTable[]={
  &msgnull, &msgAppName, &TxLengthPtr, &ComHandlerPtr, &PortIDPtr,
  &TxBufferPtr, &CbBufferPtr, &CfgBufferPtr, &ModemCommandPtr,
  &ModemResetPtr, &ComSetPtr
};

EVENT_NORM	app_event;
LHAPIBLOCK	LHAPIData;
BOOL  Done;

#define GetDataSeg()  _DS

void FixupFarPtrs(void)
{
int i,dataseg;
  dataseg=GetDataSeg();
  for(i=0; i<countof(StringTable); i++)
    *(((int *)(StringTable[i]))+1) = dataseg;
}

LHWINDOW ShowCommand = {
	StaticText, 0, 189, 80, 1,
	NULL, (PLHDATA)&TxBuffer, 80, 
	STYLE_NOBORDER|STYLE_WHCHAR|DRAW_INVERT,
	NULL, NO_FKEYS, NO_MENU, NO_HELP
};

BOOL ComInit(void)		/* Initialize Communication Port */ 
{
	if ( ComOpen( &ComHandler,PortID ) ) return FALSE;	/* COM1 or 2 */
	ComSettings.Baud=48;		/* 2400 */
	ComSettings.Data=3;			/* 8 bits */
	ComSettings.Flow=2;			/* XON/XOFF */
	ComSettings.InfraRed=1;		/* IR OFF */
	ComSetParameters(ComHandler, (void far *)&ComSettings);
	ComAcquire(ComHandler,1);	/*Exclusive*/
	return TRUE;
}

void ReadCfg( void )		/* Read Configuration File */
{
	FILE fd;
	int lenp, s, ss, d;
	unsigned char c;
	
	m_lock();
	if(m_open(&fd, CFGFILESPEC, CFGFILELEN, 0, 0)) {
	/* if not exist, then create and write default configuration */
		if(!m_create(&fd, CFGFILESPEC, CFGFILELEN, 0, 0)) {
			m_write(&fd, CFGDEFAULT, CFGDEFLEN );
			m_close(&fd);
		}
	} else {
		if(m_read(&fd, CfgBuffer, 80, &lenp)) {
		/* if can't read, then use default config */
			strcpy(CfgBuffer,CFGDEFAULT);
		}	
		m_close(&fd);
	}
	m_unlock();
	/* Should begin with COM?:  If not use default config */
	if ( CfgBuffer[0]=='C' && CfgBuffer[1]=='O' 
	  && CfgBuffer[2]=='M' && CfgBuffer[4]==':' ) {
		PortID=CfgBuffer[3]-'0';
	} else {
		strcpy(CfgBuffer,CFGDEFAULT);
		PortID=1;
	}
	s=5;
	ss=0;
	d=0;
	while( (c=CfgBuffer[s++])!=':' )		/* prefix */
		ModemCommand[d++]=c;
	while( (c=CbBuffer[ss++])!='\0')		/* number from ClipBoard */
		ModemCommand[d++]=c;
	while( (c=CfgBuffer[s++])!=':' )		/* suffix */
		ModemCommand[d++]=c;
	ModemCommand[d++]='\r';
	ModemCommand[d]='\0';
	d=0;
	while( (c=CfgBuffer[s++])!='\0'){		/* Reset Command */
		if(c>=0x20) 
			ModemReset[d++]=c;
	}
	if(d) ModemReset[d++]='\r';
	ModemReset[d]='\0';
	return;
}


BOOL GetCb( void )
{
	int	index, len;

	m_lock();
	if( m_open_cb() != 0 ) {
		m_unlock();
		return	FALSE;
	}
	if( m_rep_index((char far *)"TEXT", (int far *)&index, (unsigned *)&len) != 0 ) {
		m_close_cb();
		m_unlock();
		return	FALSE;
	}
	m_cb_read( index, 0, CbBuffer, len );
	m_close_cb();
	m_unlock();
	return TRUE;
}

void main(void)
{
	m_init_app( SYSTEM_MANAGER_VERSION );
	InitializeLHAPI( &LHAPIData );
	FixupFarPtrs();
	SetMenuFont( FONT_NORMAL );
	SetDefaultFont( FONT_NORMAL );
	m_reg_app_name( msgAppName );

	GetCb();
	ReadCfg();
	ComInit();
	strcpy(TxBuffer,ModemCommand);
    TxLength=strlen( TxBuffer );
    ComSendBytes( ComHandler, TxBufferPtr, 1, TxLengthPtr);
	SendMsg( &ShowCommand, CREATE, CREATE_NORMAL, 0 );

	Done = FALSE;

	while( !Done ) {
		app_event.do_event = DO_EVENT;	
		m_action( &app_event );
		switch( app_event.kind ) {
			case E_ACTIV:		
			case E_REFRESH:		
				FixupFarPtrs();	
				ReactivateLHAPI( &LHAPIData );
				break;
			case E_DEACT:		
				DeactivateLHAPI();
				break;
			case E_TERM:		
			case E_BREAK:
				FixupFarPtrs();	
				Done = TRUE;
				break;
			case E_KEY:
				switch(app_event.data) {
    				case SPACEKEY:
    				case ENTERKEY:
    				case ESCKEY:
						Done=TRUE;
						break;
				}
				break;
			case E_NONE:		
				break;
		 }
	}
	strcpy(TxBuffer,ModemReset);
	TxLength=strlen( TxBuffer );
  	ComSendBytes( ComHandler, TxBufferPtr, 1, TxLengthPtr);
	ComRelease(ComHandler);
	ComClose(ComHandler);

	app_event.do_event = DO_FINI;	
	m_action( &app_event );
}
