/**************************************************************************/
/* Point an shoot utility called from FILER.INI on the HP200LX            */
/* A. Garzotto, October 1994                                              */
/**************************************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <process.h>
#include <errno.h>

#define NO 0
#define YES 1

#define CONFIG "C:\\_DAT\\PNS200.INI"
#define DIRSEP '\\'

/*************************************************************************/

FILE *fp;
char buf[128] = "";
char *key, *data;
char action[80] = "";

extern int errno;

/*************************************************************************/
/* Read configuration file until a matching line is found                */

header(str)
char *str;
{
   while (1)
   {
      if (!strcmp(buf, str)) break;
      if (!fgets(buf, 126, fp))
      {
         fprintf(stderr, "Error in configuration file!\n");
         fprintf(stderr, "Could not find '%s'\n", str);
         fprintf(stderr, "Press any key.\n");
         getch();
         fclose(fp);
         exit (1);
      }
      buf[strlen(buf) - 1] = '\0';
   }
}

/*************************************************************************/
/* check if given file name matches pattern                              */

int match(pat, fname)
char *pat, *fname;
{
   char *p = pat;
   char *q = fname;
   
   if (*p == '*')
   {
      p++;
      while (*q && (*q != '.')) q++;
   }
   while (*p && (*p != '*'))
   {
      if (*p != *q)
      {
         if (*p > 'Z') *p -= 'a' - 'A';
         if (*q > 'Z') *q -= 'a' - 'A';
         if (*p != *q)
            return NO;
      }
      p++; q++;
   }
   if (*p == '*')
   {
      p++;
      while (*q && (*q != '.')) q++;
      if (*q == '.') q++;
   }
   if (!*q) return YES;
   return NO;
}

/*************************************************************************/
/* interpret next line in configuration file                             */

int get_token()
{
   if (!fgets(buf, 126, fp))
      return NO;
   buf[strlen(buf) - 1] = '\0';
   data = strchr(buf, '=');
   if (!data) return NO;
   *data = '\0';
   data++;
   key = buf;
   return YES;
}

/*************************************************************************/
/* print menu line, provided current action set includes this menu item  */

print_menu()
{
   if (strchr(action, *key))
   {
      switch (*key)
      {
         case '|': printf("RETURN - %s\n", data); break;
         case '^': printf("SPACE - %s\n", data); break;
         default: printf("%c - %s\n", *key, data);
      }
   }
}

/*************************************************************************/
/* patch a ENV file to hold the file name                                */

patch(data, name)
char *data, *name;
{
   char fname[128];
   int pos, handle;
   
   sscanf(data, "%s %d", fname, &pos);
   handle = open(fname, O_RDWR|O_BINARY);
   if (handle == -1) return;
   lseek(handle, (long)pos, SEEK_SET);
   write(handle, name, strlen(name) + 1);
   close(handle);
}

/*************************************************************************/
/* double all backslashes in string p                                    */

doubleback(p, q)
char *p, *q;
{
   while (*p)
   {
      if (*p == '\\')
         *(q++) = *p;
      *(q++) = *(p++);
   }
   *q = '\0';
}

/*************************************************************************/
/* split command and overlay program with new one                        */

do_exec(cmd)
char *cmd;
{
   char *argv[10];
   int n = 1;

   argv[0] = cmd;
   while (*cmd)
   {
      if (*cmd == ' ')
      {
         *cmd = '\0';
         argv[n++] = &cmd[1];
      }
      cmd++;
   }
   argv[n] = 0;
   execv(argv[0], argv);
   fprintf(stderr, "Could not execute program '%s'\n", argv[0]);
   switch (errno)
   {
   case E2BIG: fprintf(stderr, "Too many arguments.\n"); break;
   case ENOENT: fprintf(stderr, "Could not find it.\n"); break;
   case ENOEXEC: fprintf(stderr, "It is not executable.\n"); break;
   case ENOMEM: fprintf(stderr,
           "Not enough memory. Close some open applications\n");
        break;
   default: break;
   }
   fprintf(stderr, "Press any key!\n");
   getch();
   exit(1);
}

/*************************************************************************/
/* execute the specified command                                         */

execute(command, arg)
char *command, *arg;
{
   char cmd[160], arg0[80], arg1[80];
   char *p = command;

   strcpy(arg0, arg);
   while (*p && !((p[0] == '%') && ((p[1] == 's') || (p[1] == 'k')))) p++;
   if (*p) p++;
   if (*p == 'k')
   {
      doubleback(arg, arg0);
      *p = 's';
   }
   while (*p && !((p[0] == '%') && (p[1] == 's'))) p++;
   if (*p)
   {
      printf("Please enter arguments...\n");
      gets(arg1);
      sprintf(cmd, command, arg0, arg1);
   }
   else
      sprintf(cmd, command, arg0);
   printf("...\n");
   do_exec(cmd);
}

/*************************************************************************/

main(argc, argv)
int argc;
char **argv;

{
   int ch;
   char *fname;
   
   if (argc < 2)
   {
      fprintf(stderr, "PNS200 V 1.3 - Point and shoot menu for HP200LX\n");
      fprintf(stderr, "A. Garzotto, November 1994\n");
      fprintf(stderr, "This program should be called from FILER.INI\n");
      exit(1);
   }
   fp = fopen(CONFIG, "r");
   if (fp == NULL)
   {
      fprintf(stderr, "Cannot open configuration file '%s'\n", CONFIG);
      fprintf(stderr, "Press any key.\n");
      getch();
      exit(1);
   }
   header("[Match]");
   fname = &argv[1][strlen(argv[1]) - 1];
   while ((*fname != DIRSEP) && (fname > &argv[1][0])) fname--;
   if (*fname == DIRSEP) fname++;
   while (get_token())
   {
      if (match(key, fname))
      {
         strcpy(action, data);
         break;
      }
   }
   if (!*action)
   {
      fclose(fp);
      exit(0);
   }  
   header("[Menu]");
   if (!kbhit() && action[1])
   {
      while (get_token())
         print_menu();
   }
   if (action[1])
   {
      ch = getch();
      if ((ch == '\r') || (ch == '\n') || (ch == '\0')) ch = '|';
      else if (ch == ' ') ch = '^';
      if (!strchr(action, ch))
      {
         fclose(fp);
         exit(0);
      }
      action[0] = (char)ch;
   }
   header("[Patch]");
   while (get_token())
   {
      if (*key == *action)
      {
         patch(data, argv[1]);
         break;
      }
   }
   header("[Action]");
   while (get_token())
   {
      if (*key == *action)
      {
         fclose(fp);
         execute(data, argv[1]);
         break;
      }
   }
}

/*************************************************************************/
