;==============================================================
;To create CHARGE.COM you may either use A86, TASM or MASM:
;
;Using A86
;---------------------
; A86 CHARGE.ASM
;
;Using turbo assembler
;---------------------
; TASM CHARGE.ASM
; TLINK /T CHARGE.OBJ
;
;Using MASM
;----------
; MASM CHARGE.ASM;
; LINK CHARGE.OBJ;
; EXE2BIN CHARGE.EXE CHARGE.COM
;==============================================================

.186
cseg  segment 'code'
      assume cs:cseg,ds:cseg
org   100h

HOT   equ 2E87h         ;Hotkey scancode (Fn-C)
IR_NR equ 09h           ;interrupt number to chain in
TI_TK equ 1ch
                
;-----begin resident part--------------------------------------

  start:
jmp   install            ;inst_new

;-----begin resident data--------------------------------------

tsr   db 'charge'      ;string to identify TSR (7 chars)
hotk  dw HOT            ;hotkey scancode always at offset 10dec
activ db 0              ;0=not active, 1=active
stall db 0              ;0=check voltage,      1=don't check voltage
charg db 0
enabl db 0
adapt db 0
slow  db 0
Old1cAdr dd ?
Old1cSeg dd ?
MSEC1  dw  0
MSEC2  dw  0
MSEC3  dw  0
TIMER1 dw  0
TIMER2 dw  0
TIMER3 dw  0
V   db  0
T1  dw  1440 ;(24 hrs);time to stop charge timer (minutes)
S1  dw  480 ;(8 hrs) ;time to set the stall charger (minutes)
V1  db  1ch   ;low voltage to start charging 0-63 
V2  db  0
Volt db  0
Volts db 0
G1  db  8   ;value for voltage trigger
;-----end resident data----------------------------------------
;-----begin resident code--------------------------------------

  NewInt1ch:
mov  al,0
mov  al,cs:activ
not  al
jz   End1ch
not  byte ptr cs:activ ;toggle activ flag
call Read_V2        ;checks the voltage and if low 
call Compare_Volt      ;enough turns on charging
push bx
push ds
mov  ax,40h
mov  ds,ax
mov  bx,0d4
mov  ax,[bx]
and  ax,8h             ;checks to see if charging is turned on
pop  ds
pop  bx
jnz  Init              ;if so jumps to see if adapter plugged in
jmp  End1ch 

  Init:
push bx
push ds
mov  ax,40h
mov  ds,ax
mov  bx,0d4
mov  ax,[bx]
and  ax,40h             ;checks to see if adapter is plugged in
pop  ds
pop  bx
jnz  End1ch             ;when I have slow charge enabled change to
                        ;Adapter1 right now jumps to end interrupt
                        ;if no adapter

;---------------This part starts all the timers-------
  Charging:
call Clear_Charge_Timer
call Charge_Time
call Stall_Time
call Compare_Volts
not  byte ptr cs:activ   ;toggle activ flag
jmp  End1ch

;--------------code to reset the timers if the adapter---------
;--------------is unplugged-not yet implemented----------------  
  Adapter1:
mov  cs:MSEC1,0
mov  cs:MSEC2,0
mov  cs:MSEC3,0
mov  cs:TIMER1,0
mov  cs:TIMER2,0
mov  cs:TIMER3,0

;--------------------code for emding the interrupt-------------

  End1ch:
pushf
call  dword ptr cs:Old1cAdr
iret

;------------------------code for the charge timer-------------

  Charge_Time:

mov   ax,cs:MSEC1
add   ax,55
cmp   ax,60000
jb    SetMSEC1
inc   cs:TIMER1
sub   ax,60000

  SetMSEC1:
mov   cs:MSEC1,ax
mov   ax,cs:TIMER1
mov   dx,cs:T1              ;enter charge time for T1
cmp   ax,dx
jae   Reset
ret

  Reset:
mov   ax,0
mov   cs:adapt,al
mov   cs:enabl,al
mov   cs:Volts,al
mov   cs:MSEC1,ax
mov   cs:MSEC2,ax
mov   cs:MSEC3,ax
mov   cs:TIMER1,ax
mov   cs:TIMER2,ax
mov   cs:TIMER3,ax
call  charge_off
ret

;------------------this is the stall timer-----------------------
  Stall_Time:
mov   ax,cs:MSEC2
add   ax,55
cmp   ax,60000
jb    SetMSEC2
inc   cs:TIMER2
sub   ax,60000

  SetMSEC2:
mov   cs:MSEC2,ax

  Compare_Stall:
mov  ax,cs:TIMER2
mov  dx,cs:S1  ;stall time. Must be # of minutes
cmp  ax,dx
jae  Reset  
ret

;-------------------code for comparing voltage readings--------
;-------------------and resetting the stall timer- unfinished---

  Compare_Volts:
;mov  al,0
;mov  al,cs:stall
;cmp  al,1
;jz   three_min_time
;call Read_Volt
;mov  cs:stall,1
;mov  cs:TIMER3,0
;mov  cs:MSEC3,0

  three_min_time:
;1 minute timer if 1 minutes jump to Compare
mov  ax,cs:MSEC3
add  ax,55
cmp  ax,60000
jb   SetMSEC3
inc  cs:TIMER3
sub  ax,60000

  SetMSEC3:
mov  cs:MSEC3,ax
mov  ax,cs:TIMER3
cmp  ax,1   ;compares to 1 minutes
jae  Compare
ret

  Compare:
push ax
push dx
mov  ax,0
mov  cs:TIMER3,ax
mov  cs:MSEC3,ax
;mov  cs:stall,al
mov  ax,0
mov  dx,0
call Read_Volt
mov  al,cs:Volt        ;variable voltage reading
mov  dl,cs:Volts       ;base voltage reading
cmp  al,dl             ;compare variable to base and jump   
jg   Reset_Stall_Time  ;to reset stall if variable is greater    
pop  dx                ;just return only if varible and base
pop  ax                ;are equal
ret
                     
  Reset_Stall_Time:  
mov  al,cs:Volt
mov  cs:Volts,al
mov  ax,0
mov  cs:TIMER2,ax
mov  cs:MSEC2,ax
pop  dx
pop  ax
ret

  Read_V2:
push ax
push bx
push ds
mov  ax,40h
mov  ds,ax
mov  bx,09a
mov  al,[bx]
mov  cs:V2,al
pop  ds
pop  bx
pop  ax
ret

  Compare_Volt:
push ax
push bx
mov  ax,0
mov  bx,0
mov  al,cs:V2
mov  bl,cs:V1
cmp  al,bl
jb   charge_on
pop bx
pop ax
ret

;------------------code for clearing the charge timer----------

  Clear_Charge_Timer:
push ax
push dx
push ds
;------------------this unprotects the bios memory-------------
in   al,22h
push bx
mov  bl,al
mov  al,87h
out  22h,al
in   al,23h
mov  bh,al
mov  al,0a0
out  23h,al
;---------------------this changes the charging timer------------
push bx
mov  ax,0
mov  dx,9000h
mov  ds,dx
mov  bx,0f848
mov  [BX],ax
mov  bx,0f84a
mov  [BX],ax
pop  bx
;----------------------this protects bios memory-----------------
mov  ax,bx
and  ax,0ff00
or   ax,87h
out  22h,ax
mov  al,bl
out  22h,al
pop  bx
pop  ds
pop  dx
pop  ax
ret

;-------code for checking the battery voltage----------------
  Read_Volts:
push bx
push ds
mov  ax,40h
mov  ds,ax
mov  bx,09a
mov  al,[bx]
mov  cs:Volts,al
pop  ds
pop  bx
ret

  Read_Volt:
push bx
push ds
mov  ax,40h
mov  ds,ax
mov  bx,09a
mov  al,[bx]
mov  cs:Volt,al
pop  ds
pop  bx
ret

;-----code for charging on and off--------------------------

  charge_on:
pop bx
pop ax
in   al,22h
push bx
mov  bl,al
mov  al,87h
out  22h,al
in   al,23h
mov  bh,al
mov  al,0a0
out  23h,al

push bx
push ds
mov ax,40h
mov ds,ax
mov bx,0d4
mov ax,[bx]
or  ax,8h
mov [bx],ax
pop ds
pop bx

mov  ax,bx
and  ax,0ff00
or   ax,87h
out  22h,ax
mov  al,bl
out  22h,al
pop  bx
mov  cs:enabl,1
ret

  charge_off:
in   al,22h
push bx
mov  bl,al
mov  al,87h
out  22h,al
in   al,23h
mov  bh,al
mov  al,0a0
out  23h,al

push bx
push ds
mov ax,40h
mov ds,ax
mov bx,0d4
mov ax,[bx]
xor  ax,8h
mov [bx],ax
pop ds
pop bx

mov  ax,bx
and  ax,0ff00
or   ax,87h
out  22h,ax
mov  al,bl
out  22h,al
pop  bx
ret

;---------------Code for the Fn-C Hotkey---------------------
  int_new:
pushf                   ;because iret pops flags as well
db    9ah              ;opcode: jmp far


  int_old:
dw    0,0               ;jump to old int
sti
push  ax
not   byte ptr cs:activ ;toggle activ flag
mov   ah,11h            ;key pressed?
call  int16
je    int_end           ;no
cmp   ax,cs:hotk        ;hotkey?
jne   int_end           ;no
mov   ah,10h            ;get hotkey
call  int16

;-----code to switch charging on and off goes here--------------------
  charge_switch:
in   al,22h
push bx
mov  bl,al
mov  al,87h
out  22h,al
in   al,23h
mov  bh,al
mov  al,0a0
out  23h,al

push bx
push ds
mov ax,40h
mov ds,ax
mov bx,0d4
mov ax,[bx]
xor ax,8h
mov [bx],ax
pop ds
pop bx

mov  ax,bx
and  ax,0ff00
or   ax,87h
out  22h,ax
mov  al,bl
out  22h,al
pop  bx

  int_end:
pop  ax
not   byte ptr cs:activ ;toggle activ flag
iret                    ;return from int

;-----resident subroutine INT16--------------------------------

;simulates the keyboard interrupt to prevent light sleep

  int16:
;fkt 10h: read keyboard
;fkt 11h: check keyboard
;         zf=0 key ax available
;         zf=1 no key available
push  bx
push  cx
push  es
mov   bx,40h
mov   es,bx
  int16_1:
mov   bx,es:[1ah]
cmp   bx,es:[1ch]
jne   int16_2
cmp   ah,11h
jne   int16_1
jmp   short int16_e
  int16_2:
mov   cx,es:[bx]
cmp   ah,10h
mov   ax,cx
jne   int16_e
add   bx,2
cmp   bx,es:[82h]
jb    int16_3
mov   bx,es:[80h]
  int16_3:
mov   es:[1ah],bx
  int16_e:
pop   es
pop   cx
pop   bx
ret

RPARA equ ($-offset start+100h)/16+1 ;resident lenght mod 16

;-----end resident part----------------------------------------
;-----begin nonresident code-----------------------------------

  install:
xor   cx,cx
mov   bx,80h
mov   cl,[bx]           ;command tail begin
cmp   cx,0              ;tail available?
jne   inst_t            ;yes
call  resident          ;no, already resident?
jc    inst_0            ;yes
jmp   inst_new    ;no, install new
  inst_0:
lea   dx,tex2           ;...is resident
jmp   inst_e

;tail is available

  inst_t:
call  resident          ;already resident?
if c jmp inst_tr           ;yes
;jc  inst_tr

;tail if not loaded resident

  inst_tl:

  parse:
inc bx
mov   al,[bx]
cmp al,20h
je  parse
cmp al,00d
if z jmp inst_new ;"to install"
cmp al,'/'
je  got_switch
jmp inst_e ;"show help then end install"

  got_switch:
inc bx
mov   al,[bx]
cmp  al,'t'
if z jmp check_number_t
cmp  al,'s'
if z jmp  check_number_s
cmp  al,'v'
if z jmp check_number_v
cmp  al,'g'
if z jmp check_number_g
cmp  al,13
if z jmp inst_new ;"finish install"
jmp inst_e ;"show help end install"

  check_number_t:
mov dx,0
push bx
call char_leng
pop bx
call get_first
mov cx,dx 
inc cx
call multi_er
mov cs:T1,ax

dec cx
call get_first
call multi_er
add cs:T1,ax

dec cx
call get_first
call multi_er
add cs:T1,ax

dec cx
call get_first
call multi_er
add cs:T1,ax

dec cx
call get_first
call multi_er
add cs:T1,ax

dec cx
call get_first
call multi_er
add cs:T1,ax

  check_number_s:
mov dx,0
push bx
mov  cx,7
call char_leng
pop bx
call get_first
mov cx,dx 
inc cx
call multi_er
mov cs:S1,ax

dec cx
call get_first
call multi_er
add cs:S1,ax

dec cx
call get_first
call multi_er
add cs:S1,ax

dec cx
call get_first
call multi_er
add cs:S1,ax

dec cx
call get_first
call multi_er
add cs:S1,ax

dec cx
call get_first
call multi_er
add cs:S1,ax

  check_number_v:
mov dx,0
push bx
mov  cx,7
call char_leng
pop bx
call get_first
mov cx,dx 
inc cx
call multi_er
mov cs:V1,al

dec cx
call get_first
call multi_er
add cs:V1,al

dec cx
call get_first
call multi_er
add cs:V1,al

dec cx
call get_first
call multi_er
add cs:V1,al

dec cx
call get_first
call multi_er
add cs:V1,al

dec cx
call get_first
call multi_er
add cs:V1,al

  check_number_g:
mov dx,0
push bx
mov  cx,7
call char_leng
pop bx
call get_first
mov cx,dx 
inc cx
call multi_er
mov cs:G1,al

dec cx
call get_first
call multi_er
add cs:G1,al

dec cx
call get_first
call multi_er
add cs:G1,al

dec cx
call get_first
call multi_er
add cs:G1,al

dec cx
call get_first
call multi_er
add cs:G1,al

dec cx
call get_first
call multi_er
add cs:G1,al

  get_first:
inc bx
mov   al,[bx]
cmp al,20h
if z jmp parse ;"jump back to the beginning"
cmp al,13
if z jmp inst_new ;"show help and end install" 
cbw
ret

  multi_er:
sub ax,30h
cmp cx,2
je  mult_1
cmp cx,3
je  mult_10
cmp cx,4
je  mult_100
cmp cx,5
je  mult_1000
cmp cx,6
je  mult_10000
ret

  mult_1:
push dx
mov dx,1
mul dx
pop dx
ret

  mult_10:
push dx
mov dx,10
mul dx
pop dx
ret
  
  mult_100:
push dx
mov dx,100
mul dx
pop dx
ret

  mult_1000:
push dx
mov dx,1000
mul dx
pop dx
ret

  mult_10000:
push dx
mov dx,10000
mul dx
pop dx
ret

  char_leng:
inc bx
mov al,[bx]
cmp al,20h
if z ret
cmp al,13
if z ret
inc dx
loop char_leng
ret

;tail if loaded resident

  inst_tr:
inc   bx
mov   al,[bx]
;or    al,20h            ;make lower case
cmp   al,'u'
je    inst_r
loop  inst_tr
lea   dx,help
jmp   short inst_e

  inst_trs:
movsw
mov   ax,es:[DI]
jmp   short inst_ee
 
  inst_e:
mov   ah,9
int   21h
  inst_ee:
mov   ah,4ch            ;end non TSR
int   21h

  inst_R:
lea   dx,tex5
push  es                ;resident codesegment
mov   ah,35h
mov   al,IR_NR
int   21h
mov   bx,es             ;codesegment installed int
pop   es
mov   ax,es
cmp   bx,ax             ;if not equal
jne   inst_e            ;error
push  ds
push  dx

lds   dx,es:dword ptr int_old
mov   ah,25h
mov   al,IR_NR
int   21h

lds   dx,es:dword ptr Old1cAdr
mov   ah,25h
mov   al,TI_TK
int   21h

pop   dx
pop   ds
not   word ptr es:start
mov   ah,49h
int   21h
jc    inst_e
lea   dx,tex4
jmp   inst_e

;-----install new----------------------------------------------

  inst_new:
;push  ax
;push  bx
;push  dx
;mov   ax,cs:S1
;mov   dl,30
;div   dl
;mov   bl,al
;mov   ax,0
;mov   al,bl
;mov   cs:S1,ax
;pop   dx
;pop   bx
;pop   ax

push  ax
push  bx
mov   ax,6003h
mov   bl,01h
int   15h
pop   bx
pop   ax

push  es
mov   ah,35h    ;ask dos for the existing timer tick address
mov   al,TI_TK
int   21h
mov   word ptr Old1cAdr,bx ;save it locally
mov   word ptr Old1cAdr+2,es
pop   es

push  es
mov   ah,35h
mov   al,IR_NR          ;get old int
int   21h
mov   word ptr int_old,bx
mov   word ptr int_old+2,es
pop   es

mov   dx,offset NewInt1ch ;new address
mov   ah,25h    ;point timer tick to our own address
mov   al,TI_TK
int   21h

mov   dx,offset int_new
mov   ah,25h
mov   al,IR_NR ;set int
int   21h

lea   dx,logo
mov   ah,9
int   21h

mov   ax,ds:[002ch]     ;environement block- was 002ch
mov   es,ax
mov   ah,49h            ;release
int   21h

not   word ptr start
mov   dx,128           ;RPARA
mov   ax,3100h          ;stay resident
int   21h

;-----nonresident subroutines----------------------------------

;cf=1:program is already loaded resident at codesegment es
;cf=0:program is not loaded resident.

  resident:
pusha
cld
not    word ptr start   ;was changed at upload
xor    bx,bx
mov    ax,cs            ;search up to cs
  resident_loop:        ;do for every paragraph
inc    bx               ;next paragraph
mov    es,bx            ;in es
cmp    ax,bx            ;done?
clc
je     resident_e       ;end, hence not found
mov    si,offset start  ;offset in our code to compare
mov    di,si            ;offset in resident code
mov    cx,10            ;bytes to compare
rep    cmpsb            ;compare ds:si with es:di
jne    resident_loop    ;not found in this paragraph, loop
stc
  resident_e:
not    word ptr start   ;reset to origin 
popa
ret

;-----begin nonresident data-----------------------------------
                                                           
logo: db 13,10
      db 'Charge v1.0 (c) 2000 John Musielewicz. Replacement ',13,10
      db 'charging controller for the 200LX Palmtop.         ',13,10
      db 13,10
      db 'Charge has changed the battery setting to NI-CAD ',13,10
      db 'and has assumed control of charging.             ',13,10
      db '            For help type charge /?            ',13,10,'$'
help: db 13,10
      db 'Usage: CHARGE [/t##][/s##][/v##][/u][/?]',13,10
      db '/t## = ## is maximum charging time, in minutes. ',13,10
      db '/s## = ## is stall time, in minutes.  ',13,10
      db '/v## = ## voltage level between 0-63. ',13,10
      db '/u   = Unload TSR',13,10
      db 'Fn+C = Hotkey. Toggles charging on and off. ',13,10
      db '       Does not reset charge timers.        ',13,10 
      db '/?   = This page   ',13,10
      db 'Read CHARGE.DOC for more complete information. ',13,10,' $'
tex2: db '...already loaded$'
tex4: db '...unloaded$'
tex5: db '...cannot unload$'

;-----end nonresident data-------------------------------------

cseg  ends
end   start
