@ECHO OFF
SET jet=
IF [%1]==[*] SET jet=REM
IF NOT [%1]==[] IF NOT [%1]==[*] GOTO %1
IF [%1]==[] GOTO HlpDEBUGSCR 
:ADDTOIT
SET io=ADDTOIT.SCR
REM>%io%
>>%io% ECHO ADDTOIT.DOC        January 1993       Jeff Prosise/Dale Lewallen
>>%io% ECHO ----------------------------------------------------------------
>>%io% ECHO Purpose:       Extend path environment variable to any length.
>>%io% ECHO.
>>%io% ECHO Format:        ADDTOIT [drive:] [path]
>>%io% ECHO.
>>%io% ECHO Usage:         ADDTOIT lets you append additional directory names
>>%io% ECHO                to the end of your path environment variable set
>>%io% ECHO                up in your AUTOEXEC.BAT. It lets you break up a 
>>%io% ECHO                long PATH command into several commands. For
>>%io% ECHO                example, to render a path of 
>>%io% ECHO                
>>%io% ECHO                     C:\DOS;C:\WINDOWS;C:\MASM\BIN;
>>%io% ECHO.
>>%io% ECHO                use the following syntax:
>>%io% ECHO.
>>%io% ECHO                     PATH=C:\DOS;C:\WINDOWS;
>>%io% ECHO                     ADDTOIT C:\MASM\BIN
>>%io% ECHO.
>>%io% ECHO                or even:
>>%io% ECHO.
>>%io% ECHO                     PATH=C:\DOS;
>>%io% ECHO                     ADDTOIT C:\WINDOWS
>>%io% ECHO                     ADDTOIT C:\MASM\BIN
>>%io% ECHO.
>>%io% ECHO Remarks:       By breaking a long PATH statement into smaller
>>%io% ECHO                components that fit within DOSs 127-character
>>%io% ECHO                limit on individual commands, you can create PATH
>>%io% ECHO                strings that are limited only by the amount of 
>>%io% ECHO                free space If ADDTOIT displays the "Insufficient
>>%io% ECHO                environment space" error message, increase the
>>%io% ECHO                environment size with a SHELL statement in
>>%io% ECHO                CONFIG.SYS.
>>%io% ECHO.
>>%io% ECHO                Another error message you might see from ADDTOIT
>>%io% ECHO                is "PATH variable not found". This means that the
>>%io% ECHO                environment currently contains no PATH string.
>>%io% ECHO.
>>%io% ECHO                (ADDTOIT can't create a path statement; it can
>>%io% ECHO                only add directory names to an existing PATH.)
>>%io% ECHO.
>>%io% ECHO                One annoying drawback to DOSs SET and PATH 
>>%io% ECHO                commands is that they will display only the first
>>%io% ECHO                127 characters of the PATH, even though DOS uses
>>%io% ECHO                the full ADDTOIT path when it searches your hard
>>%io% ECHO                disk for an executable file.
>>%io% ECHO.
>>%io% ECHO Comments:      Use ADDTOIT in moderation. Long PATH strings slow
>>%io% ECHO                DOS down, and the later a directory name appears
>>%io% ECHO                in a PATH string, the longer it takes DOS to find
>>%io% ECHO                a program file in that directory. Keep your PATH 
>>%io% ECHO                statements as short as possible.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO =========================================================================
>>%io% ECHO N ADDTOIT.COM
>>%io% ECHO E 0100 EB 65 53 79 6E 74 61 78
>>%io% ECHO E 0108 3A 20 41 44 44 54 4F 49
>>%io% ECHO E 0110 54 20 70 61 74 68 73 74
>>%io% ECHO E 0118 72 69 6E 67 0D 0A 24 49
>>%io% ECHO E 0120 6E 73 75 66 66 69 63 69
>>%io% ECHO E 0128 65 6E 74 20 65 6E 76 69
>>%io% ECHO E 0130 72 6F 6E 6D 65 6E 74 20
>>%io% ECHO E 0138 73 70 61 63 65 0D 0A 24
>>%io% ECHO E 0140 50 41 54 48 20 76 61 72
>>%io% ECHO E 0148 69 61 62 6C 65 20 6E 6F
>>%io% ECHO E 0150 74 20 66 6F 75 6E 64 0D
>>%io% ECHO E 0158 0A 24 00 00 00 00 50 41
>>%io% ECHO E 0160 54 48 3D 00 00 00 00 FC
>>%io% ECHO E 0168 BE 81 00 AC 3C 20 74 FB
>>%io% ECHO E 0170 3C 0D 75 0C BA 02 01 B4
>>%io% ECHO E 0178 09 CD 21 B8 01 4C CD 21
>>%io% ECHO E 0180 4E 89 36 5A 01 33 C9 AC
>>%io% ECHO E 0188 3C 0D 74 03 41 EB F8 89
>>%io% ECHO E 0190 0E 5C 01 E8 7A 00 E8 8D
>>%io% ECHO E 0198 00 8B D8 E8 98 00 89 3E
>>%io% ECHO E 01A0 65 01 2B DF BA 1F 01 83
>>%io% ECHO E 01A8 EB 02 3B 1E 5C 01 7C C7
>>%io% ECHO E 01B0 BE 5E 01 33 FF B9 05 00
>>%io% ECHO E 01B8 E8 8C 00 BA 40 01 72 B7
>>%io% ECHO E 01C0 32 C0 B9 FF FF F2 AE 4F
>>%io% ECHO E 01C8 89 3E 63 01 26 80 7D FF
>>%io% ECHO E 01D0 3B 74 0F FF 06 5C 01 FF
>>%io% ECHO E 01D8 0E 5A 01 8B 36 5A 01 C6
>>%io% ECHO E 01E0 04 3B 8B 36 65 01 8B FE
>>%io% ECHO E 01E8 03 3E 5C 01 8B CE 2B 0E
>>%io% ECHO E 01F0 63 01 41 FD 1E 8C C0 8E
>>%io% ECHO E 01F8 D8 F3 A4 1F 8B 36 5A 01
>>%io% ECHO E 0200 8B 3E 63 01 8B 0E 5C 01
>>%io% ECHO E 0208 FC F3 A4 B8 00 4C CD 21
>>%io% ECHO E 0210 8C C0 26 3B 06 16 00 74
>>%io% ECHO E 0218 07 26 8E 06 16 00 EB F0
>>%io% ECHO E 0220 26 8E 06 2C 00 C3 06 8C
>>%io% ECHO E 0228 C0 48 8E C0 26 A1 03 00
>>%io% ECHO E 0230 B1 04 D3 E0 07 C3 FC 32
>>%io% ECHO E 0238 C0 33 FF B9 FF FF F2 AE
>>%io% ECHO E 0240 26 80 3D 00 75 F8 C3 FC
>>%io% ECHO E 0248 26 83 3D 00 74 0F 51 56
>>%io% ECHO E 0250 57 F3 A6 5F 5E 59 74 03
>>%io% ECHO E 0258 47 EB ED F8 C3 F9 C3
>>%io% ECHO RCX
>>%io% ECHO 015F
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < ADDTOIT.SCR > NUL
%jet% GOTO xDEBUGSCR
:ALLDATE
SET io=ALLDATE.SCR
REM>%io%
>>%io% ECHO N DAY.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     AH,2A   ; select get date function
>>%io% ECHO INT     21      ; call INT 21h
>>%io% ECHO MOV     AL,DL   ; put day in AL
>>%io% ECHO MOV     AH,4C   ; select terminate w/ exit code
>>%io% ECHO INT     21      ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO A
>>%io% ECHO W
>>%io% ECHO N MONTH.COM
>>%io% ECHO A 104
>>%io% ECHO MOV     AL,DH   ; put month in AL
>>%io% ECHO.
>>%io% ECHO W
>>%io% ECHO N YEAR.COM
>>%io% ECHO A 104
>>%io% ECHO MOV     AX,CX   ; put year in AX
>>%io% ECHO SUB     AX,07BC ; subtract 1980
>>%io% ECHO MOV     AH,4C   ; select terminate w/ exit code
>>%io% ECHO INT     21
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO D
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ALLDATE.SCR > NUL
%jet% GOTO xDEBUGSCR
:ALLTIME
SET io=ALLTIME.SCR
REM>%io%
>>%io% ECHO N HOUR.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     AH,2C  ; select get time function
>>%io% ECHO INT     21     ; call INT 21h
>>%io% ECHO MOV     AL,CH  ; put hours in AL
>>%io% ECHO MOV     AH,4C  ; select terminate w/ exit code
>>%io% ECHO INT     21     ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO A
>>%io% ECHO W
>>%io% ECHO N MINUTE.COM
>>%io% ECHO A 104
>>%io% ECHO MOV     AL,CL  ; put minutes in AL
>>%io% ECHO.
>>%io% ECHO W
>>%io% ECHO N SECOND.COM
>>%io% ECHO A 104
>>%io% ECHO MOV    AL,DH   ; put seconds in AL
>>%io% ECHO.
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ALLTIME.SCR > NUL
%jet% GOTO xDEBUGSCR
:ALREADY
SET io=ALREADY.SCR
REM>%io%
>>%io% ECHO ALREADY.COM  From PC Computing October 1991
>>%io% ECHO.
>>%io% ECHO Already.com allows you to run programs or batch files only ONCE a day,
>>%io% ECHO at the first BOOT-UP of the day.  It assumes either a system clock, or
>>%io% ECHO that the date and time are consitantly set BEFORE it is called.
>>%io% ECHO.
>>%io% ECHO Already is placed in the autoexec.bat file, (after the DATE command) and
>>%io% ECHO when called, it compares the system date with it's date.  If they are
>>%io% ECHO different, it re-writes itself with the new date, and returns an
>>%io% ECHO ERRORLEVEL <> 1.  If they are the same (ie the computer has booted at
>>%io% ECHO least once that day) it returns and ERRORLEVEL of 1.
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO =================================================
>>%io% ECHO Example autoexec.bat using ALREADY
>>%io% ECHO.
>>%io% ECHO @ECHO OFF
>>%io% ECHO echo.
>>%io% ECHO date
>>%io% ECHO echo.
>>%io% ECHO.
>>%io% ECHO ALREADY.COM
>>%io% ECHO IF ERRORLEVEL 1 GOTO SKIP
>>%io% ECHO.
>>%io% ECHO REM Stuff to do at bootup
>>%io% ECHO call NEW-DAY.BAT
>>%io% ECHO.
>>%io% ECHO :skip
>>%io% ECHO REM Stuff to always do
>>%io% ECHO prompt $P$G
>>%io% ECHO path c:\dos
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO -----------------
>>%io% ECHO N ALREADY.COM
>>%io% ECHO E 0100 B4 2A CD 21 3B 16 37 01
>>%io% ECHO E 0108 75 0B 3B 0E 39 01 75 05
>>%io% ECHO E 0110 B8 01 4C CD 21 89 16 37
>>%io% ECHO E 0118 01 89 0E 39 01 BA 3B 01
>>%io% ECHO E 0120 33 C9 B4 3C CD 21 8B D8
>>%io% ECHO E 0128 BA 00 01 B9 47 00 B4 40
>>%io% ECHO E 0130 CD 21 B8 00 4C CD 21 00
>>%io% ECHO E 0138 00 00 00 41 4C 52 45 41
>>%io% ECHO E 0140 44 59 2E 43 4F 4D 00
>>%io% ECHO RCX
>>%io% ECHO 0047
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < ALREADY.SCR > NUL
%jet% GOTO xDEBUGSCR
:ANSIHERE
SET io=ANSIHERE.SCR
REM>%io%
>>%io% ECHO N ANSIHERE.COM
>>%io% ECHO A 100
>>%io% ECHO JMP 106
>>%io% ECHO.
>>%io% ECHO E 102 1B '[s$'
>>%io% ECHO A 106
>>%io% ECHO MOV     AH,0F    ; get video mode AND current page
>>%io% ECHO INT     10       ; call INT 10h (video)
>>%io% ECHO MOV     AH,03    ; select get cursor position function
>>%io% ECHO INT     10       ; call INT 10h (video)
>>%io% ECHO PUSH    DX       ; save position
>>%io% ECHO MOV     DX,0102  ; DX points to ANSI string
>>%io% ECHO MOV     AH,09    ; select display string function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO MOV     AH,03    ; select get cursor position function
>>%io% ECHO INT     10       ; call INT 10h
>>%io% ECHO POP     AX       ; get old position into AX
>>%io% ECHO SUB     AX,DX    ; subtract new position from it (0 if SAME)
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 21
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < ANSIHERE.SCR > NUL
%jet% GOTO xDEBUGSCR
:ANSITEST
SET io=ANSITEST.SCR
REM>%io%
>>%io% ECHO REM PC/C September 1994, pg 229
>>%io% ECHO REM Returns an ERRORLEVEL 0 is Ansi.sys is active, 1 if it is not.
>>%io% ECHO.
>>%io% ECHO N ANSITEST.COM
>>%io% ECHO E100 B8 00 1A CD 2F FE C0 B4
>>%io% ECHO E108 4C CD 21
>>%io% ECHO RCX
>>%io% ECHO B
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < ANSITEST.SCR > NUL
%jet% GOTO xDEBUGSCR
:ANSIX
SET io=ANSIX.SCR
REM>%io%
>>%io% ECHO N ANSIX.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     SI,0082    ; SI points to command tail
>>%io% ECHO SUB     CH,CH      ; zero out CH
>>%io% ECHO MOV     CL,[SI-02] ; character count in CL
>>%io% ECHO JCXZ    0119       ; no command tail?  skip it!
>>%io% ECHO DEC     CX         ; deduct one for the skipped space
>>%io% ECHO LODSB              ; get a char into AX
>>%io% ECHO CMP     AL,7E      ; is it the tilde?
>>%io% ECHO JNZ     0112       ; if not, print it as is
>>%io% ECHO MOV     AL,1B      ; if it's a tilde, substitute the escape char
>>%io% ECHO XCHG    DX,AX      ; get the char in DL
>>%io% ECHO MOV     AH,02      ; select write character function
>>%io% ECHO INT     21         ; call INT 21h
>>%io% ECHO LOOP    010B       ; go back for the next character
>>%io% ECHO INT     20         ; call INT 20h (terminate process)
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 1B
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ANSIX.SCR > NUL
%jet% GOTO xDEBUGSCR
:ANTIBOOT
SET io=ANTIBOOT.SCR
REM>%io%
>>%io% ECHO Disables CTRL-ALT-DEL keyboard re-boot
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO ===================================================
>>%io% ECHO N ANTIBOOT.COM
>>%io% ECHO E 0100 EB 37 90 00 00 00 00 FB
>>%io% ECHO E 0108 50 E4 60 3C 53 75 24 1E
>>%io% ECHO E 0110 B8 40 00 8E D8 A0 17 00
>>%io% ECHO E 0118 1F 24 0C 3C 0C 75 14 FA
>>%io% ECHO E 0120 E4 61 8A E0 0C 80 E6 61
>>%io% ECHO E 0128 8A C4 E6 61 B0 20 E6 20
>>%io% ECHO E 0130 FB 58 CF 58 2E FF 2E 03
>>%io% ECHO E 0138 01 B8 09 35 CD 21 89 1E
>>%io% ECHO E 0140 03 01 8C 06 05 01 B8 09
>>%io% ECHO E 0148 25 BA 07 01 CD 21 BA 39
>>%io% ECHO E 0150 01 CD 27
>>%io% ECHO RCX
>>%io% ECHO 0053
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ANTIBOOT.SCR > NUL
%jet% GOTO xDEBUGSCR
:AUTOASK
SET io=AUTOASK.SCR
REM>%io%
>>%io% ECHO Returns the ASCII code of the character entered at the prompt.
>>%io% ECHO.
>>%io% ECHO e.g.
>>%io% ECHO.
>>%io% ECHO ECHO Do you want to run CHKDSK?
>>%io% ECHO AUTOASK
>>%io% ECHO IF ERRORLEVEL 89 IF NOT ERRORLEVEL 90 GOTO DOIT
>>%io% ECHO IF ERRORLEVEL 121 IF NOT ERRORLEVEL 122 GOTO DOIT
>>%io% ECHO GOTO END
>>%io% ECHO :DOIT
>>%io% ECHO CHKDSK
>>%io% ECHO :END
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO =======================================================
>>%io% ECHO N AUTOASK.COM
>>%io% ECHO E 0100 EB 0D 0A 00 00 00 5B 00
>>%io% ECHO E 0108 05 00 4E 00 00 00 00 FC
>>%io% ECHO E 0110 BE 81 00 AC 3C 20 74 FB
>>%io% ECHO E 0118 3C 0D 74 03 A2 0A 01 A1
>>%io% ECHO E 0120 02 01 F7 26 06 01 F7 36
>>%io% ECHO E 0128 08 01 A3 04 01 B8 08 35
>>%io% ECHO E 0130 CD 21 89 1E 0B 01 8C 06
>>%io% ECHO E 0138 0D 01 B8 08 25 BA 69 01
>>%io% ECHO E 0140 CD 21 B4 01 CD 16 74 08
>>%io% ECHO E 0148 B4 00 CD 16 0A C0 75 0A
>>%io% ECHO E 0150 83 3E 04 01 00 75 EB A0
>>%io% ECHO E 0158 0A 01 50 B8 08 25 C5 16
>>%io% ECHO E 0160 0B 01 CD 21 58 B4 4C CD
>>%io% ECHO E 0168 21 9C 2E 83 3E 04 01 00
>>%io% ECHO E 0170 74 05 2E FF 0E 04 01 9D
>>%io% ECHO E 0178 2E FF 2E 0B 01
>>%io% ECHO RCX
>>%io% ECHO 007D
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < AUTOASK.SCR > NUL
%jet% GOTO xDEBUGSCR
:AUTOCAPS
SET io=AUTOCAPS.SCR
REM>%io%
>>%io% ECHO Automaticaly turns the CAPs lock OFF when you press the shift key.
>>%io% ECHO Avoids the following:  tHIS IS IN CAPS
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO ============================================
>>%io% ECHO N AUTOCAPS.COM
>>%io% ECHO E 0100 EB 23 00 00 00 00 9C 50
>>%io% ECHO E 0108 E4 60 3C 2A 74 04 3C 36
>>%io% ECHO E 0110 75 0C 1E B8 40 00 8E D8
>>%io% ECHO E 0118 80 26 17 00 BF 1F 58 9D
>>%io% ECHO E 0120 2E FF 2E 02 01 B8 09 35
>>%io% ECHO E 0128 CD 21 89 1E 02 01 8C 06
>>%io% ECHO E 0130 04 01 B8 09 25 BA 06 01
>>%io% ECHO E 0138 CD 21 BA 25 01 CD 27
>>%io% ECHO RCX
>>%io% ECHO 003F
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < AUTOCAPS.SCR > NUL
%jet% GOTO xDEBUGSCR
:BIGBUF
SET io=BIGBUF.SCR
REM>%io%
>>%io% ECHO BIGBUF.COM                    June 1992                Challenge
>>%io% ECHO                                                           Solved
>>%io% ECHO ----------------------------------------------------------------
>>%io% ECHO Usage:    Load BIGBUF in your AUTOEXEC.BAT file to run.
>>%io% ECHO.
>>%io% ECHO Comments: The February 1992 Challenge invited you to overcom 
>>%io% ECHO           DOS's 15-character keyboard buffer limit. Although 
>>%io% ECHO           shareware programs can do this, we try to provide
>>%io% ECHO           solutions that you can type in and use immediately.
>>%io% ECHO.
>>%io% ECHO           Our winning entry comes from 13-year-old Charles 
>>%io% ECHO           Lepple of Alexandria, Virginia, who submitted a
>>%io% ECHO           DEBUG script that extends the keyboard buffer.
>>%io% ECHO           We've enhanced his solution to include some
>>%io% ECHO           error-trapping code. 
>>%io% ECHO           
>>%io% ECHO Notes:    BIGBUF is a TSR that used 512 bytes of RAM and must
>>%io% ECHO           be loaded somewhere in the first 64k of conventional
>>%io% ECHO           memory due to BIOS restrictions. If BIGBUF is loaded
>>%io% ECHO           higher, it displays the message, "Error: BIGBUF must
>>%io% ECHO           be loaded lower", and does not extend the buffer. If
>>%io% ECHO           BIGBUF complains that it must be loaded lower, do so
>>%io% ECHO           by loading it earlier in the startup sequence. That
>>%io% ECHO           is, make it the first or second TSR rather than the
>>%io% ECHO           tenth. If all goes well, BIGBUF will report:
>>%io% ECHO           "Keyboard buffer extended to 127 characters."
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO --------------------------------------------
>>%io% ECHO.
>>%io% ECHO N BIGBUF.COM
>>%io% ECHO E 0100 EB 52 45 72 72 6F 72 3A
>>%io% ECHO E 0108 20 42 49 47 42 55 46 20
>>%io% ECHO E 0110 6D 75 73 74 20 62 65 20
>>%io% ECHO E 0118 6C 6F 61 64 65 64 20 6C
>>%io% ECHO E 0120 6F 77 65 72 0D 0A 24 4B
>>%io% ECHO E 0128 65 79 62 6F 61 72 64 20
>>%io% ECHO E 0130 62 75 66 66 65 72 20 65
>>%io% ECHO E 0138 78 74 65 6E 64 65 64 20
>>%io% ECHO E 0140 74 6F 20 31 32 37 20 63
>>%io% ECHO E 0148 68 61 72 61 63 74 65 72
>>%io% ECHO E 0150 73 0D 0A 24 8C C8 3D 00
>>%io% ECHO E 0158 10 76 08 B4 09 BA 02 01
>>%io% ECHO E 0160 CD 21 C3 2D 30 00 B1 04
>>%io% ECHO E 0168 D3 E0 1E BB 40 00 8E DB
>>%io% ECHO E 0170 A3 80 00 A3 1A 00 A3 1C
>>%io% ECHO E 0178 00 05 00 01 A3 82 00 1F
>>%io% ECHO E 0180 B4 49 8E 06 2C 00 CD 21
>>%io% ECHO E 0188 B4 09 BA 27 01 CD 21 BA
>>%io% ECHO E 0190 00 02 CD 27
>>%io% ECHO RCX
>>%io% ECHO 0094
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < BIGBUF.SCR > NUL
%jet% GOTO xDEBUGSCR
:BIGCURSO
SET io=BIGCURSO.SCR
REM>%io%
>>%io% ECHO N BIGCURSO.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AH,1  ; (c) DOS World, September 1997, Issue 35, page 65
>>%io% ECHO MOV CX,7  ; Set cursor type to full size
>>%io% ECHO INT 10    ; through video BIOS
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 8
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < BIGCURSO.SCR > NUL
%jet% GOTO xDEBUGSCR
:BIOSDATE
SET io=BIOSDATE.SCR
REM>%io%
>>%io% ECHO N BIOSDATE.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     AX,F000
>>%io% ECHO MOV     DS,AX    ; DS points to ROM BIOS
>>%io% ECHO MOV     SI,FFF5  ; BIOS date is at offset FFF5
>>%io% ECHO MOV     CX,0008  ; loop for 8 characters
>>%io% ECHO MOV     AH,02    ; select character output function
>>%io% ECHO LODSB            ; get a character into DL
>>%io% ECHO MOV     DL,AL    ; move it to AL
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO LOOP    010D     ; process the next character
>>%io% ECHO RET              ; return
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 15
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < BIOSDATE.SCR > NUL
%jet% GOTO xDEBUGSCR
:BLINKOFF
SET io=BLINKOFF.SCR
REM>%io%
>>%io% ECHO N BLINKOFF.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AX,1003
>>%io% ECHO MOV BL,0
>>%io% ECHO INT 10    ; (c) DOS World, Sep 1995, #23, page 12
>>%io% ECHO INT 20    ; turns off blinking characters
>>%io% ECHO           ; Use: BLINKOFF
>>%io% ECHO RCX
>>%io% ECHO 9
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < BLINKOFF.SCR > NUL
%jet% GOTO xDEBUGSCR
:BLINKON
SET io=BLINKON.SCR
REM>%io%
>>%io% ECHO N BLINKON.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AX,1003
>>%io% ECHO MOV BL,1
>>%io% ECHO INT 10    ; (c) DOS World, Sep 1995, #23, pg 12
>>%io% ECHO INT 20    ; turns on blinking characters
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 9
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < BLINKON.SCR > NUL
%jet% GOTO xDEBUGSCR
:BLOAD
SET io=BLOAD.SCR
REM>%io%
>>%io% ECHO M 100 L FA0 B800:0000
>>%io% ECHO Q
DEBUG < BLOAD.SCR > NUL
%jet% GOTO xDEBUGSCR
:BORDER
SET io=BORDER.SCR
REM>%io%
>>%io% ECHO N BORDER.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AX,[5D] ; DOS World, Number 35, SEP 1997
>>%io% ECHO CMP AH,20   ; Programmer: Robert L. Hummel
>>%io% ECHO JNE 10C     ; Adds color box to outermost border
>>%io% ECHO MOV AH,30   ; of screen, i.e., the overscan area
>>%io% ECHO XCHG AL,AH  ; Usage: BORDER [0-63]
>>%io% ECHO SUB AX,3030 ; where 0 to 63 are numbers that 
>>%io% ECHO XCHG AL,AH  ; designate the color value 
>>%io% ECHO AAD         ; (works on VGA monitors)
>>%io% ECHO MOV BH,AL
>>%io% ECHO MOV AX,1001
>>%io% ECHO INT 10
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 1B
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < BORDER.SCR > NUL
%jet% GOTO xDEBUGSCR
:BOXAT
SET io=BOXAT.SCR
REM>%io%
>>%io% ECHO N BOXAT.COM
>>%io% ECHO A 100
>>%io% ECHO JMP 133
>>%io% ECHO DB  00,00,00,00,00,00,00
>>%io% ECHO DB  DA,C4,BF,B3,C0,C4,D9
>>%io% ECHO DB  C9,CD,BB,BA,C8,CD,BC
>>%io% ECHO DB  DB,DB,DB,DB,DB,DB,DB
>>%io% ECHO DB  B2,B2,B2,B2,B2,B2,B2
>>%io% ECHO DB  B1,B1,B1,B1,B1,B1,B1
>>%io% ECHO DB  B0,B0,B0,B0,B0,B0,B0
>>%io% ECHO MOV  SI,81
>>%io% ECHO CALL 18D        ; (c) DOS World, Aug 1996, page 22, draws boxes
>>%io% ECHO DEC  AH         ; by Robert L. Hummel
>>%io% ECHO MOV  [102],AH   ; Usage: BOXAT row col nrow ncol style
>>%io% ECHO CALL 18D
>>%io% ECHO DEC  AH
>>%io% ECHO MOV  [103],AH
>>%io% ECHO CALL 18D        ; Box Scores for 5th parameter:
>>%io% ECHO MOV  [104],AH   ; 1         single line, ASCII 179
>>%io% ECHO CALL 18D        ; 2         double line, ASCII 186
>>%io% ECHO MOV  [105],AH   ; 3         solid block, ASCII 219
>>%io% ECHO MOV  AH,F       ; 4         75 shaded block, ASCII 178
>>%io% ECHO INT  10         ; 5         50 shaded block, ASCII 177
>>%io% ECHO MOV [108],BH    ; 6         15 shaded block, ASCII 176
>>%io% ECHO MOV AH,3
>>%io% ECHO INT 10
>>%io% ECHO MOV [106],DX
>>%io% ECHO CALL 18D
>>%io% ECHO DEC AH
>>%io% ECHO CMP AH,5
>>%io% ECHO JA 18C
>>%io% ECHO MOV AL,7
>>%io% ECHO MUL AH
>>%io% ECHO MOV SI,109
>>%io% ECHO ADD SI,AX
>>%io% ECHO MOV DH,[102]
>>%io% ECHO MOV DL,[103]
>>%io% ECHO CALL 1AA
>>%io% ECHO MOV AH,2
>>%io% ECHO MOV DX,[106]
>>%io% ECHO INT 10
>>%io% ECHO RET
>>%io% ECHO MOV AX,2901
>>%io% ECHO MOV DI,5C
>>%io% ECHO INT 21
>>%io% ECHO PUSH SI
>>%io% ECHO MOV SI,5D
>>%io% ECHO SUB AX,AX
>>%io% ECHO LODSB
>>%io% ECHO CMP AL,20
>>%io% ECHO JZ 1A8
>>%io% ECHO SUB AL,30
>>%io% ECHO AAD
>>%io% ECHO MOV AH,AL
>>%io% ECHO JMP 19B
>>%io% ECHO POP SI
>>%io% ECHO RET
>>%io% ECHO MOV BP,DX
>>%io% ECHO MOV BH,[108]
>>%io% ECHO CALL 1E8
>>%io% ECHO LODSB
>>%io% ECHO SUB CH,CH
>>%io% ECHO MOV CL,[104]
>>%io% ECHO DEC CL
>>%io% ECHO DEC CL
>>%io% ECHO PUSH CX
>>%io% ECHO MOV DX,BP
>>%io% ECHO INC DH
>>%io% ECHO MOV BP,DX
>>%io% ECHO MOV AH,2
>>%io% ECHO INT 10
>>%io% ECHO MOV AH,A
>>%io% ECHO MOV CX,1
>>%io% ECHO INT 10
>>%io% ECHO MOV AH,2
>>%io% ECHO ADD DL,[105]
>>%io% ECHO DEC DL
>>%io% ECHO INT 10
>>%io% ECHO MOV AH,A
>>%io% ECHO MOV CX,1
>>%io% ECHO INT 10
>>%io% ECHO POP CX
>>%io% ECHO LOOP 1BE
>>%io% ECHO MOV DX,BP
>>%io% ECHO INC DH
>>%io% ECHO MOV AH,2
>>%io% ECHO INT 10
>>%io% ECHO LODSB
>>%io% ECHO MOV AH,E
>>%io% ECHO INT 10
>>%io% ECHO LODSB
>>%io% ECHO MOV AH,A
>>%io% ECHO SUB CH,CH
>>%io% ECHO MOV CL,[105]
>>%io% ECHO DEC CX
>>%io% ECHO ADD DX,CX
>>%io% ECHO DEC CX
>>%io% ECHO INT 10
>>%io% ECHO MOV AH,2
>>%io% ECHO INT 10
>>%io% ECHO LODSB
>>%io% ECHO MOV AH,A
>>%io% ECHO MOV CX,1
>>%io% ECHO INT 10
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 10D
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < BOXAT.SCR > NUL
%jet% GOTO xDEBUGSCR
:BSAVE
SET io=BSAVE.SCR
REM>%io%
>>%io% ECHO RCX
>>%io% ECHO FA0
>>%io% ECHO W B800:0000
>>%io% ECHO Q
DEBUG < BSAVE.SCR > NUL
%jet% GOTO xDEBUGSCR
:BU
SET io=BU.SCR
REM>%io%
>>%io% ECHO N BU.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  SP,0200     ; Adjust stack pointer
>>%io% ECHO MOV  SI,0150     ; Offset of parameter block
>>%io% ECHO MOV  BX,0        ; Use our environment
>>%io% ECHO MOV  [SI],BX     ; 1st parameter block entry
>>%io% ECHO MOV  BX,01C0     ; Offset of command-line tail
>>%io% ECHO MOV  [SI+2],BX   ; 2nd parameter block entry
>>%io% ECHO MOV  AX,CS       ; Put our code segment in AX
>>%io% ECHO MOV  [SI+4],AX   ; 3rd parameter block entry
>>%io% ECHO MOV  BX,005C     ; Offset of FCB #1
>>%io% ECHO MOV  [SI+6],BX   ; 4th parameter block entry
>>%io% ECHO MOV  [SI+8],AX   ; 5th parameter block entry
>>%io% ECHO MOV  BX,006C     ; Offset of FCB #2
>>%io% ECHO MOV  [SI+A],BX   ; 6th parameter block entry
>>%io% ECHO MOV  [SI+C],AX   ; 7th parameter block entry
>>%io% ECHO MOV  BX,0020     ; Shrink program's memory 
>>%io% ECHO MOV  AH,4A       ; to 32 paragraphs
>>%io% ECHO INT  21          ; Call DOS service 4Ah
>>%io% ECHO MOV  BX,SI       ; Offset of parameter block
>>%io% ECHO MOV  DX,0180     ; Offset of program name
>>%io% ECHO MOV  AX,4B00     ; Service 4Bh, function 00h
>>%io% ECHO INT  21          ; Call DOS
>>%io% ECHO JNC  146         ; Jump to MOV AL,0 if no error
>>%io% ECHO MOV  DX,160      ; Offset of error message
>>%io% ECHO MOV  AH,09       ; Prepare to display error
>>%io% ECHO INT  21          ; Display error message
>>%io% ECHO MOV  AL,1        ; Set ERRORLEVEL=FAILURE
>>%io% ECHO JMP  148         ; Jump to MOV AH,4C
>>%io% ECHO MOV  AL,0        ; Set ERRORLEVEL=SUCCESS
>>%io% ECHO MOV  AH,4C       ; Prepare to exit
>>%io% ECHO INT  21          ; Exit to DOS
>>%io% ECHO NOP              ; ====DATA STARTS HERE========
>>%io% ECHO ORG  150         ; Put parameter block at 0150h
>>%io% ECHO DW   0, 0, 0, 0, 0, 0, 0
>>%io% ECHO ORG  160         ; Put error message at 160h
>>%io% ECHO DB   'Error running BACKUP.EXE', 0D, 0A, '$'
>>%io% ECHO ORG  180         ; Put program name at 0180h
>>%io% ECHO DB   'C:\DOS\BACKUP.EXE', 0
>>%io% ECHO ORG  1C0         ; Put command tail at 01C0h
>>%io% ECHO DB   0C, ' C:\*.* A: /S', 0D
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 100
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < BU.SCR > NUL
%jet% GOTO xDEBUGSCR
:BUFFER
SET io=BUFFER.SCR
REM>%io%
>>%io% ECHO BUFFER   SCR
>>%io% ECHO.
>>%io% ECHO     Stuffs characters into the key buffer.
>>%io% ECHO.
>>%io% ECHO Syntax:     (in a batch file) e.g.
>>%io% ECHO     buffer /frtest
>>%io% ECHO     123
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO N BUFFER.COM
>>%io% ECHO E 0100 BB 01 00 8A 16 80 00 38
>>%io% ECHO E 0108 DA 7E 1A 8A 8F 81 00 80
>>%io% ECHO E 0110 F9 3F 75 02 B1 0D B4 05
>>%io% ECHO E 0118 53 CD 16 5B 3C 01 74 05
>>%io% ECHO E 0120 80 C3 01 EB DE B8 4C 00
>>%io% ECHO E 0128 CD 21
>>%io% ECHO RCX
>>%io% ECHO 002A
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < BUFFER.SCR > NUL
%jet% GOTO xDEBUGSCR
:CAPSLOCK
SET io=CAPSLOCK.SCR
REM>%io%
>>%io% ECHO N CAPSLKON.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  AX,0040    ; BIOS's data segment address
>>%io% ECHO MOV  DS,AX      ; Put segment address in DS
>>%io% ECHO MOV  SI,0017    ; Offset of 1st flag byte
>>%io% ECHO CLI             ; Disable interrupts
>>%io% ECHO MOV  AL,[SI]    ; Read 1st flag byte into AL
>>%io% ECHO OR   AL,40      ; Set bit 6 of 1st flag byte
>>%io% ECHO MOV  [SI],AL    ; Write flag byte to memory
>>%io% ECHO STI             ; Restore interrupts
>>%io% ECHO MOV  AX,4C00    ; Prepare to exit
>>%io% ECHO INT  21         ; Exit to DOS
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 15
>>%io% ECHO W
>>%io% ECHO.
>>%io% ECHO N CAPSLKOF.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  AX,0040    ; BIOS's data segment address
>>%io% ECHO MOV  DS,AX      ; Put segment address in DS
>>%io% ECHO MOV  SI,0017    ; Offset of 1st flag byte
>>%io% ECHO CLI             ; Disable interrupts
>>%io% ECHO MOV  AL,[SI]    ; Read 1st flag byte into AL
>>%io% ECHO AND  AL,BF      ; Clear bit 6 of 1st flag byte
>>%io% ECHO MOV  [SI],AL    ; Write flag byte to memory
>>%io% ECHO STI             ; Restore interrupts
>>%io% ECHO MOV  AX,4C00    ; Prepare to exit
>>%io% ECHO INT  21         ; Exit to DOS
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 15
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < CAPSLOCK.SCR > NUL
%jet% GOTO xDEBUGSCR
:CHKDRV
SET io=CHKDRV.SCR
REM>%io%
>>%io% ECHO N CHKDRV.COM
>>%io% ECHO A 100
>>%io% ECHO OR   AL,AL   ;AL=0 if 1st drive valid
>>%io% ECHO JZ   010A       ; or FF if invalid
>>%io% ECHO MOV  AL,02      ;Return errorlevel=2
>>%io% ECHO MOV  AH,4C      ;Terminate
>>%io% ECHO INT  21         ; thru DOS
>>%io% ECHO MOV  DL,[005C]  ;Get drive number+1
>>%io% ECHO DEC  DL         ; subtract 1
>>%io% ECHO JNS  0116       ; not negative if okay
>>%io% ECHO MOV  AL,03      ;Return errorlevel=3
>>%io% ECHO JMP  0106       ; exit
>>%io% ECHO MOV  AH,04      ;Verify diskette fn
>>%io% ECHO MOV  AL,01      ; 1 sector
>>%io% ECHO MOV  CH,00      ; track 0
>>%io% ECHO MOV  CL,01      ; sector 1
>>%io% ECHO MOV  DH,00      ; side 0
>>%io% ECHO INT  13         ; thru BIOS
>>%io% ECHO JNC  012C       ;NoCarry=okay
>>%io% ECHO MOV  AH,00      ;Reset diskette
>>%io% ECHO INT  13         ; thru BIOS
>>%io% ECHO MOV  AL,01      ;Return errorlevel=1
>>%io% ECHO JMP  0106       ; exit
>>%io% ECHO MOV  AL,00      ;Return errorlevel=1
>>%io% ECHO JMP  0106       ; exit
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 30
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CHKDRV.SCR > NUL
%jet% GOTO xDEBUGSCR
:CKHAN
SET io=CKHAN.SCR
REM>%io%
>>%io% ECHO N CKHAN.COM
>>%io% ECHO A 100
>>%io% ECHO SUB     BX,BX    ; zero out BX
>>%io% ECHO INC     BX       ; (:loop) add one to BX
>>%io% ECHO MOV     AX,3D00  ; select open file function
>>%io% ECHO MOV     DX,0114  ; DS:DX points to filename NUL
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO JNC     0102     ; if successful, jump back to :loop
>>%io% ECHO DEC     BX       ; deduct one for unsuccessful try
>>%io% ECHO MOV     AL,BL    ; put count in AL
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code
>>%io% ECHO INT     21       ; call INT 21h                    
>>%io% ECHO DB 'NUL' 00
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 18
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CKHAN.SCR > NUL
%jet% GOTO xDEBUGSCR
:CLDBOOT
SET io=CLDBOOT.SCR
REM>%io%
>>%io% ECHO CLDBOOT  SCR
>>%io% ECHO.
>>%io% ECHO     Cold boots the PC
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO A 0100
>>%io% ECHO MOV AX,40
>>%io% ECHO MOV DS,AX
>>%io% ECHO JMP FFFF:0000
>>%io% ECHO.
>>%io% ECHO N CLDBOOT.COM
>>%io% ECHO RCX
>>%io% ECHO 10
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CLDBOOT.SCR > NUL
%jet% GOTO xDEBUGSCR
:CLEARKEY
SET io=CLEARKEY.SCR
REM>%io%
>>%io% ECHO N CLEARKEY.COM
>>%io% ECHO E 0100 B8 40 00 8E D8 FA A1 1A
>>%io% ECHO E 0108 00 A3 1C 00 FB C3
>>%io% ECHO RCX
>>%io% ECHO 000E
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CLEARKEY.SCR > NUL
%jet% GOTO xDEBUGSCR
:CODES
SET io=CODES.SCR
REM>%io%
>>%io% ECHO N CODES.COM
>>%io% ECHO A 100
>>%io% ECHO JMP     11C      ; jump over data area
>>%io% ECHO.
>>%io% ECHO E 102 '  ASCII: 000  Scan: 000' 0D 0A '$'
>>%io% ECHO A11C
>>%io% ECHO CLD              ; forward direction
>>%io% ECHO MOV     AH,00    ; select read character function
>>%io% ECHO INT     16       ; call INT 16h (keyboard)
>>%io% ECHO PUSH    AX       ; save the result
>>%io% ECHO MOV     AH,0A    ; select write character function
>>%io% ECHO SUB     BX,BX    ; zero out BX
>>%io% ECHO MOV     CX,0001  ; write one character
>>%io% ECHO INT     10       ; call INT 10h (video)
>>%io% ECHO MOV     AH,03    ; select get cursor position function
>>%io% ECHO INT     10       ; call INT 10h (video)
>>%io% ECHO INC     DL       ; next character position
>>%io% ECHO MOV     AH,02    ; select set cursor position function
>>%io% ECHO INT     10       ; call INT 10h (video)
>>%io% ECHO POP     AX       ; retrieve key value
>>%io% ECHO PUSH    AX       ; ... and save it again
>>%io% ECHO MOV     DI,010B  ; point to ASCII numbers in string
>>%io% ECHO CALL    014F     ; convert ASCII code in AL to 3-digit number
>>%io% ECHO MOV     DI,0116  ; point to scan numbers in string
>>%io% ECHO POP     AX       ; retrieve the result
>>%io% ECHO XCHG    AH,AL    ; get scan code into AL
>>%io% ECHO CALL    014F     ; convert scan code in AL to 3-digit number
>>%io% ECHO MOV     AH,09    ; select display string function
>>%io% ECHO MOV     DX,0102  ; DX is address of data string
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO JMP     011D     ; do it all again
>>%io% ECHO                  ; begin subroutine
>>%io% ECHO SUB     AH,AH    ; zero out AH
>>%io% ECHO MOV     BL,64    ; put 100 in BL
>>%io% ECHO DIV     BL       ; divide by 100, leaving 100's in AL
>>%io% ECHO MOV     BH,AH    ; save tens and ones
>>%io% ECHO OR      AL,30    ; convert AL to ASCII digit...
>>%io% ECHO STOSB            ; ... and store it
>>%io% ECHO MOV     AL,BH    ; retrieve tens and ones
>>%io% ECHO AAM              ; separate the digits
>>%io% ECHO OR      AX,3030  ; convert both to ASCII
>>%io% ECHO XCHG    AH,AL    ; tens in AL, ones in AH
>>%io% ECHO STOSB            ; store tens
>>%io% ECHO XCHG    AH,AL    ; now put ones in AL
>>%io% ECHO STOSB            ; store ones
>>%io% ECHO RET              ; end subroutine                
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 68
>>%io% ECHO W
>>%io% ECHO.
>>%io% ECHO N ENCODES.COM
>>%io% ECHO A11D
>>%io% ECHO MOV AH,10
>>%io% ECHO.
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CODES.SCR > NUL
%jet% GOTO xDEBUGSCR
:COLOR
SET io=COLOR.SCR
REM>%io%
>>%io% ECHO N COLOR.COM
>>%io% ECHO A       100
>>%io% ECHO MOV     AH,2
>>%io% ECHO MOV     BH,0
>>%io% ECHO XOR     DX,DX      ; (c) DOS World, Jan, 1998, pg 20
>>%io% ECHO INT     10         ; Lets you choose screen and text
>>%io% ECHO MOV     AH,9       ; colors for your MS-DOS session.
>>%io% ECHO MOV     BH,0       ; Use: COLOR
>>%io% ECHO MOV     CX,0FA0    ; Be sure to substitute a value
>>%io% ECHO MOV     AL,20      ; for ?? in the final MOV instr.
>>%io% ECHO MOV     BL,1F      ; Assign the background color as
>>%io% ECHO INT     10         ; the first hex digit; forground
>>%io% ECHO INT     20         ; color as the second hex digit.
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 17
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < COLOR.SCR > NUL
%jet% GOTO xDEBUGSCR
:CRITERR1
SET io=CRITERR1.SCR
REM>%io%
>>%io% ECHO N CRITERR1.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  AX,3C00  ; DOS function 3Ch - Create file
>>%io% ECHO MOV  DX,0200  ; Offset of filename
>>%io% ECHO MOV  CX,CS    ; 
>>%io% ECHO MOV  DS,CX    ; Segment of filename
>>%io% ECHO INT  21       ; Call DOS to create file
>>%io% ECHO JNC  115      ; If successful, terminate
>>%io% ECHO MOV  DX,240   ; Else, display error message
>>%io% ECHO MOV  AH,09    ; Function 09h - Display string
>>%io% ECHO INT  21       ; Call DOS to display string 
>>%io% ECHO MOV  DX,220   ; Offset to terminate message
>>%io% ECHO MOV  AH,09    ; Function 09h - Display string
>>%io% ECHO INT  21       ; Call DOS to display string 
>>%io% ECHO MOV  AX,4C00  ; DOS function 4Ch - Terminate
>>%io% ECHO INT  21       ; Call DOS to exit
>>%io% ECHO ORG  200      ; Put filename at offset 200h
>>%io% ECHO DB   'A:\TMP.TMP', 0
>>%io% ECHO ORG  220      ; Terminate message
>>%io% ECHO DB   'Program terminated normally', 0D, 0A, '$'
>>%io% ECHO ORG  240      ; Error message
>>%io% ECHO DB   'Unable to create file', 0D, 0A, '$'
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 200
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CRITERR1.SCR > NUL
%jet% GOTO xDEBUGSCR
:CRITERR2
SET io=CRITERR2.SCR
REM>%io%
>>%io% ECHO N CRITERR2.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  AX,CS         ; Transfer current code segment
>>%io% ECHO MOV  DS,AX         ;   into register DS
>>%io% ECHO MOV  AH,25         ; DOS Funct. 25h - Set int. vector
>>%io% ECHO MOV  AL,24         ; Interrupt vector to set
>>%io% ECHO MOV  DX,0200       ; Offset of address of our handler
>>%io% ECHO INT  21            ; Call int 21h, function 25h
>>%io% ECHO MOV  AX,3D00       ; DOS Function 3Dh - Open file
>>%io% ECHO MOV  DX,0170       ; Offset of filename
>>%io% ECHO INT  21            ; Call DOS to open file
>>%io% ECHO MOV  AX,4C00       ; DOS Function 4Ch - Terminate
>>%io% ECHO INT  21            ; Call DOS to exit
>>%io% ECHO ORG  170           ; Allow 127 characters for filename
>>%io% ECHO DB  'A:\TMP.TMP',0
>>%io% ECHO NOP  ;************************************************
>>%io% ECHO ORG  200           ; CRITICAL-ERROR HANDLER
>>%io% ECHO PUSH DS            ; Save DS register
>>%io% ECHO PUSH DX            ; Save DX register
>>%io% ECHO MOV  AX,CS         ; Get our code segment
>>%io% ECHO MOV  DS,AX         ;   and put it into DS
>>%io% ECHO MOV  DX,0280       ; Offset of message text
>>%io% ECHO MOV  AH,09         ; DOS function 9h - Display string
>>%io% ECHO INT  21            ; Call DOS to display message
>>%io% ECHO POP  DX            ; Restore DX
>>%io% ECHO POP  DS            ; Restore DS
>>%io% ECHO MOV  AL,2          ; Action=2 (Terminate program)
>>%io% ECHO IRET               ; Return from interrupt routine
>>%io% ECHO ORG 280            ; Critical-error message
>>%io% ECHO DB  'Critical-Error Encountered'
>>%io% ECHO DB  '  -  Program Aborted.', 0D, 0A, '$'
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 200
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CRITERR2.SCR > NUL
%jet% GOTO xDEBUGSCR
:CRITERR3
SET io=CRITERR3.SCR
REM>%io%
>>%io% ECHO N CRITERR3.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  AX,CS         ; Transfer current code segment
>>%io% ECHO MOV  DS,AX         ;   into register DS
>>%io% ECHO MOV  AH,25         ; DOS Funct. 25h - Set int. vector
>>%io% ECHO MOV  AL,24         ; Interrupt vector to set
>>%io% ECHO MOV  DX,0200       ; Offset of address of our handler
>>%io% ECHO INT  21            ; Call int 21h, function 25h
>>%io% ECHO MOV  AX,3D00       ; DOS Function 3Dh - Open file
>>%io% ECHO MOV  DX,0170       ; Offset of filename
>>%io% ECHO INT  21            ; Call DOS to open file
>>%io% ECHO MOV  AH,40         ; DOS Function 40h - Write data
>>%io% ECHO MOV  BX,4          ; Handle: 4 = PRN
>>%io% ECHO MOV  CX,1          ; Write 1 byte
>>%io% ECHO MOV  DX,1FE        ; Offset of form feed byte
>>%io% ECHO INT  21            ; Call DOS to open file
>>%io% ECHO MOV  AX,4C00       ; DOS Function 4Ch - Terminate
>>%io% ECHO INT  21            ; Call DOS to exit
>>%io% ECHO ORG  170           ; Allow 127 characters for filename
>>%io% ECHO DB  'A:\TMP.TMP',0
>>%io% ECHO ORG  1FE           ; Form feed byte
>>%io% ECHO DB  0C
>>%io% ECHO NOP  ;************************************************
>>%io% ECHO ORG  200           ; CRITICAL-ERROR HANDLER
>>%io% ECHO PUSH DS            ; Save DS register
>>%io% ECHO PUSH DX            ; Save DX register
>>%io% ECHO MOV  DX,CS         ; Get our code segment
>>%io% ECHO MOV  DS,DX         ;   and put it into DS
>>%io% ECHO MOV  DX,0280       ; Offset of disk error message
>>%io% ECHO TEST AH,80         ; Check bit 7 of AH for disk error
>>%io% ECHO JZ   211           ; Skip next inst. if disk error
>>%io% ECHO MOV  DX,02A0       ; Offset of non-disk error message
>>%io% ECHO MOV  AH,09         ; DOS function 9h - Display string
>>%io% ECHO INT  21            ; Call DOS to display message
>>%io% ECHO POP  DX            ; Restore DX
>>%io% ECHO POP  DS            ; Restore DS
>>%io% ECHO MOV  AL,3          ; Action=3 (Fail operation)
>>%io% ECHO IRET               ; Return from interrupt routine
>>%io% ECHO ORG 280            ; Error messages
>>%io% ECHO DB  'Critical disk error', 0D, 0A, '$'
>>%io% ECHO ORG 2A0
>>%io% ECHO DB  'Critical non-disk error', 0D, 0A, '$'
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 200
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < CRITERR3.SCR > NUL
%jet% GOTO xDEBUGSCR
:CURSOR
SET io=CURSOR.SCR
REM>%io%
>>%io% ECHO N CURSOR.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AH,3      ; DOS World, July 1997, Number 34, page 46
>>%io% ECHO XOR BX,BX     ; Use CURSOR.SCR to make program which toggles
>>%io% ECHO INT 10        ; the cursor on and off.
>>%io% ECHO XOR CH,20
>>%io% ECHO MOV AH,1
>>%io% ECHO INT 10
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO E
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < CURSOR.SCR > NUL
%jet% GOTO xDEBUGSCR
:DOW
SET io=DOW.SCR
REM>%io%
>>%io% ECHO N DOW.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     AH,2A  ; select get date function
>>%io% ECHO INT     21     ; call INT 21h
>>%io% ECHO MOV     AH,4C  ; select terminate w/ exit code
>>%io% ECHO INT     21     ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 8
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < DOW.SCR > NUL
%jet% GOTO xDEBUGSCR
:DR
SET io=DR.SCR
REM>%io%
>>%io% ECHO n dr.com
>>%io% ECHO a 100
>>%io% ECHO ; This is the script file for DR.COM  A simple directory lister.
>>%io% ECHO ; See DR.TXT for the discussion on how the file is created and full
>>%io% ECHO ;  comments.
>>%io% ECHO ; Start of full listing for DR.COM version 1.00
>>%io% ECHO jmp 01ED
>>%io% ECHO db 0D,0A,'DR.COM v1.00'
>>%io% ECHO db 0D,0A,'A simple directory lister to show how to program in DEBUG'
>>%io% ECHO db 0D,0A,'(c)opyright 1997   Forever Young Software'
>>%io% ECHO db 0D,0A,0A,'$'
>>%io% ECHO db 0D,0A,'Current Directory:   '
>>%io% ECHO db 0
>>%io% ECHO db ':\'
>>%io% ECHO db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
>>%io% ECHO db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
>>%io% ECHO db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
>>%io% ECHO db 0D,0A,'$'
>>%io% ECHO db '*.*',0
>>%io% ECHO db 'An error occured$'
>>%io% ECHO mov  ah,09                  ; print our header text
>>%io% ECHO mov  dx,0103                ;
>>%io% ECHO int  21                     ;
>>%io% ECHO mov  ah,19                  ; get current drive letter
>>%io% ECHO int  21                     ;
>>%io% ECHO add  al,41                  ; add 'A' to it (for printing ascii letter)
>>%io% ECHO mov  [0192],al              ; put it at front of path
>>%io% ECHO mov  ah,47                  ; get current directory
>>%io% ECHO xor  dl,dl                  ; current drive
>>%io% ECHO mov  si,0195                ; put in our buffer above
>>%io% ECHO int  21                     ;
>>%io% ECHO jc   024B                   ; if error
>>%io% ECHO mov  ah,09                  ; print the current full path
>>%io% ECHO mov  dx,017B                ;
>>%io% ECHO int  21                     ;
>>%io% ECHO mov  dx,0195                ; prepare to create a new dta temporarily
>>%io% ECHO mov  ah,1A                  ; "set dta addr" service of int 21h
>>%io% ECHO int  21                     ;
>>%io% ECHO mov  di,01B3                ; put '$' in filename area for our printing
>>%io% ECHO mov  cx,14                  ;
>>%io% ECHO mov  al,24                  ;
>>%io% ECHO rep                         ;
>>%io% ECHO stosb                       ;
>>%io% ECHO mov  ah,4E                  ; find first dir entry
>>%io% ECHO mov  dx,01D8                ;
>>%io% ECHO mov  cx,0020                ; archive only (no dirs, etc.)
>>%io% ECHO int  21                     ;
>>%io% ECHO jc   024A                   ; if carry - done (no more found)
>>%io% ECHO mov  ah,09                  ; else print the filename
>>%io% ECHO mov  dx,01B3                ;
>>%io% ECHO int  21                     ;
>>%io% ECHO mov  ah,09                  ; and a CRLF
>>%io% ECHO mov  dx,01D5                ;
>>%io% ECHO int  21                     ;
>>%io% ECHO mov  di,01B3                ; put '$' in filename area for our printing
>>%io% ECHO mov  cx,14                  ;
>>%io% ECHO mov  al,24                  ;
>>%io% ECHO rep                         ;
>>%io% ECHO stosb                       ;
>>%io% ECHO mov  ah,4F                  ; find next directory entry
>>%io% ECHO int  21                     ;
>>%io% ECHO jnc  022C                   ; if no carry, cont. with find next
>>%io% ECHO ret                         ; if carry - done (no more found)
>>%io% ECHO mov  ah,09                  ; was an error so print error message
>>%io% ECHO mov  dx,01DC                ;
>>%io% ECHO int  21                     ;
>>%io% ECHO ret                         ;
>>%io% ECHO.
>>%io% ECHO rcx
>>%io% ECHO 0253
>>%io% ECHO w
>>%io% ECHO q
>>%io% ECHO.
DEBUG < DR.SCR > NUL
%jet% GOTO xDEBUGSCR
:DREADY
SET io=DREADY.SCR
REM>%io%
>>%io% ECHO DREADY.COM checks to see if disk drive is ready
>>%io% ECHO ===============================================
>>%io% ECHO N DREADY.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     DL,[5C]  ; get drive from first FCB (1=A:, 2=B:, ...)
>>%io% ECHO CMP     DL,0     ; if 0, assume A:
>>%io% ECHO JZ      10B
>>%io% ECHO DEC     DL       ; disk function needs 0=A:, 1=B:, ...
>>%io% ECHO MOV     CX, 3    ; Loop three times, in case motor not ready
>>%io% ECHO PUSH    CX       ; Save CX - it will be used below
>>%io% ECHO MOV     AH,04    ; Select Verify sector function
>>%io% ECHO MOV     AL,01    ; verify one sector
>>%io% ECHO MOV     CH,00    ; start w/ on cylinder 0
>>%io% ECHO MOV     CL,01    ; first sector
>>%io% ECHO MOV     DH,00    ; use head 0
>>%io% ECHO MOV     BX,0200  ; sector buffer offset in BX
>>%io% ECHO INT     13       ; call INT 13h
>>%io% ECHO JNC     129      ; Ok?  Exit!
>>%io% ECHO PUSH    AX       ; Not Ok?  Save error code in AX
>>%io% ECHO MOV     AH,0     ; ... and reset disk
>>%io% ECHO INT     13       ; call INT 13h
>>%io% ECHO POP     AX       ; Get back error code
>>%io% ECHO POP     CX       ; restore CX for loop count
>>%io% ECHO LOOP    10E      ; try again
>>%io% ECHO XCHG    AH,AL    ; error code in AL
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 2F
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < DREADY.SCR > NUL
%jet% GOTO xDEBUGSCR
:ENCRYPT
SET io=ENCRYPT.SCR
REM>%io%
>>%io% ECHO ENCRYPT.DOC        January 1993        Matthew Lake/Jeff Prosise
>>%io% ECHO ----------------------------------------------------------------
>>%io% ECHO Purpose:       Keep your files secret by providing password-
>>%io% ECHO                level protection through encryption.
>>%io% ECHO.
>>%io% ECHO Files          ENCRYPT.COM, SCRAMBLE.BAT, SEE.BAT, GET.BAT,
>>%io% ECHO   Required:      and SECRET.BAT
>>%io% ECHO.
>>%io% ECHO Format:        Type ENCRYPT at the DOS command line to to see
>>%io% ECHO                the program's command-line syntax for usage.
>>%io% ECHO.
>>%io% ECHO Usage:         The password-protection routines in this file set
>>%io% ECHO                are all based on a smill file-encryption program
>>%io% ECHO                called ENCRYPT.COM. The four batch files 
>>%io% ECHO                (SCRAMBLE, SEE, GET, and SECRET) enhance the 
>>%io% ECHO                program.
>>%io% ECHO                
>>%io% ECHO                SCRAMBLE encrypts files with a password you 
>>%io% ECHO                     provide.
>>%io% ECHO                SEE shows text hidden in encrypted files when you
>>%io% ECHO                     provide the correct password.
>>%io% ECHO                GET extracts files from encryption.
>>%io% ECHO                SECRET enables you to write confidential 
>>%io% ECHO                     information in a text file and encrypt it 
>>%io% ECHO                     in one step.
>>%io% ECHO.
>>%io% ECHO Remarks:       Although ENCRYPT works fine by itself, its
>>%io% ECHO                complicated command-line syntax and rudimentary
>>%io% ECHO                help instructions leave a little to be desired.
>>%io% ECHO                To make things easier (and to guard against
>>%io% ECHO                typing mistakes), use the batch files SCRAMBLE,
>>%io% ECHO                SEE, and GET.
>>%io% ECHO.
>>%io% ECHO SCRAMBLE.BAT   Enter SCRAMBLE at the DOS prompt for instructions
>>%io% ECHO                for using SCRAMBLE.BAT. To encrypt an existing file
>>%io% ECHO                of any sort--text, formatted text, etc.--use the
>>%io% ECHO                following syntax:
>>%io% ECHO.
>>%io% ECHO                     SCRAMBLE [source] [password] [target]
>>%io% ECHO.
>>%io% ECHO                If you miss any of the three required parameters,
>>%io% ECHO                the batch file's IF (%3)==0 GOTO INFO line jumps
>>%io% ECHO                to a help paragraph. You can customize any line
>>%io% ECHO                in this paragraph (just remember to precede any
>>%io% ECHO                line you want to see onscreen with an ECHO command).
>>%io% ECHO.
>>%io% ECHO                The batch file offers to delete the original file as
>>%io% ECHO                a security measure. If you want to delete the 
>>%io% ECHO                original, press Enter. For a little protection against
>>%io% ECHO                DOSs UNDELETE command, the batch file overwrites the
>>%io% ECHO                original file with a single word so that once you've
>>%io% ECHO                deleted the file, it's extremely difficult to restore
>>%io% ECHO                the information. This poses a risk to your data (if
>>%io% ECHO                you forget the password, you'll never get your file
>>%io% ECHO                back), but it also provides a fair amount of security.
>>%io% ECHO.
>>%io% ECHO                If you don't want to delete the original file, simply
>>%io% ECHO                press Ctrl-C or Ctrl-Break when the batch file prompts
>>%io% ECHO                you, and answer Y to DOSs question "Terminate Batch
>>%io% ECHO                Operation?" If you don't like this option, just
>>%io% ECHO                delete the lines between ECHO and :INFO or precede
>>%io% ECHO                each of the lines with REM to make them remarks
>>%io% ECHO                instead of instructions.
>>%io% ECHO.
>>%io% ECHO SEE.BAT        If you want to scan an encrypted text file without
>>%io% ECHO                first decrypting it, use SEE.BAT. This batch file
>>%io% ECHO                requires only two parameters: the encrypted file's
>>%io% ECHO                name and the password. The batch file redirects
>>%io% ECHO                decrypted information to the DOS command MORE, 
>>%io% ECHO                which displays it onscreen one page at a time.
>>%io% ECHO                When you've finished reading the file, SEE clears
>>%io% ECHO                the screen so that nobody else can see your files.
>>%io% ECHO                If you don't want to clear the screen, press
>>%io% ECHO                Ctrl-C or Ctrl-Break to stop the batch file.
>>%io% ECHO.
>>%io% ECHO GET.BAT        To extract a file from its encrypted form and have
>>%io% ECHO                it on disk, use GET. This batch file requires three
>>%io% ECHO                parameters: the encrypted source file, its password,
>>%io% ECHO                and the target file name. The DIR %3 command at the
>>%io% ECHO                end of the batch file verifies that the file has 
>>%io% ECHO                been decrypted. If you get a FILE NOT FOUND state-
>>%io% ECHO                ment, it's because there was a problem creating it.
>>%io% ECHO                Make sure you entered the encrypted file's name
>>%io% ECHO                correctly and that it's in the current directory or
>>%io% ECHO                in your path. Then try running GET again.
>>%io% ECHO.
>>%io% ECHO SECRET.BAT     To make a quick, confidential file of secret 
>>%io% ECHO                information, use SECRET, which sends the text you
>>%io% ECHO                type to ENCRYPT.  This batch file requires two
>>%io% ECHO                parameters: output filename and password. First,
>>%io% ECHO                the batch file uses COPY CON to create a text file
>>%io% ECHO                from the characters you type. Enter data line by
>>%io% ECHO                line and DOS stuffs it into a temporary file called
>>%io% ECHO                TEMP.TMP. When you've finished entering data, press
>>%io% ECHO                Ctrl-Z (of F6) and Enter. The batch file then calls
>>%io% ECHO                ENCRYPT.COM and passes it the name of the temporary
>>%io% ECHO                file and the two parameters you entered at the DOS
>>%io% ECHO                prompt when you invoked SECRET. Finally, SECRET 
>>%io% ECHO                overwrites the temporary file with a single word to
>>%io% ECHO                make it difficult to recover and then deletes it.
>>%io% ECHO.
>>%io% ECHO Refer to the article on pages 272 through 276 for more information 
>>%io% ECHO about this program file.
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO ================================================================
>>%io% ECHO REM GET.BAT
>>%io% ECHO @ECHO OFF 
>>%io% ECHO IF (%3)==() GOTO INFO
>>%io% ECHO ENCRYPT "%2" <%1 >%3 
>>%io% ECHO DIR %3
>>%io% ECHO GOTO END
>>%io% ECHO :INFO 
>>%io% ECHO ECHO.
>>%io% ECHO ECHO GET retrieves files you've encrypted with HIDE or ENCRYPT
>>%io% ECHO ECHO Use this syntax: 
>>%io% ECHO ECHO GET file password decrypted_filename 
>>%io% ECHO ECHO.
>>%io% ECHO :END
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO ================================================================
>>%io% ECHO REM HIDE.BAT
>>%io% ECHO @ECHO OFF 
>>%io% ECHO IF (%3)==() GOTO INFO
>>%io% ECHO ENCRYPT "%2" <%1 >%3 
>>%io% ECHO ECHO. 
>>%io% ECHO ECHO HIDE will remove every trace of the file you just hid, 
>>%io% ECHO ECHO except for password-protected information in an encrypted file, 
>>%io% ECHO ECHO unless you enter CTRL-C or CTRL-BREAK now. 
>>%io% ECHO ECHO Press any other key to delete the original file.
>>%io% ECHO ECHO. 
>>%io% ECHO PAUSE >NUL
>>%io% ECHO ECHO SECRET >%1 
>>%io% ECHO DEL %1 
>>%io% ECHO GOTO END
>>%io% ECHO :INFO 
>>%io% ECHO ECHO.
>>%io% ECHO ECHO HIDE uses ENCRYPT.COM to encrypt a file you want to keep secret 
>>%io% ECHO ECHO Use this syntax: 
>>%io% ECHO ECHO HIDE file password encrypted_filename 
>>%io% ECHO ECHO.
>>%io% ECHO :END
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO ================================================================
>>%io% ECHO REM SECRET.BAT
>>%io% ECHO @ECHO OFF
>>%io% ECHO IF (%2)==() GOTO INFO
>>%io% ECHO ECHO Enter your secret below. 
>>%io% ECHO ECHO Press Enter at the end of each line. 
>>%io% ECHO ECHO Use as many lines as necessary. 
>>%io% ECHO ECHO When you're done, press Ctrl-Z, Enter.
>>%io% ECHO COPY CON TEMP.TMP > NUL
>>%io% ECHO ENCRYPT "%2" <TEMP.TMP >%1
>>%io% ECHO ECHO SECRET >TEMP.TMP
>>%io% ECHO DEL TEMP.TMP > NUL
>>%io% ECHO GOTO END
>>%io% ECHO :INFO 
>>%io% ECHO ECHO.
>>%io% ECHO ECHO SECRET.BAT lets you enter text, and uses
>>%io% ECHO ECHO ENCRYPT.COM to hide it in a file of your choice. 
>>%io% ECHO ECHO Use this syntax for the command: 
>>%io% ECHO ECHO SECRET filename password 
>>%io% ECHO ECHO.
>>%io% ECHO :END
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO ================================================================
>>%io% ECHO REM SEE.BAT
>>%io% ECHO @ECHO OFF 
>>%io% ECHO IF (%2)==() GOTO INFO
>>%io% ECHO ENCRYPT "%2" <%1 | MORE
>>%io% ECHO GOTO OUT
>>%io% ECHO :INFO 
>>%io% ECHO ECHO.
>>%io% ECHO ECHO SEE uses ENCRYPT to display information hidden in encrypted files 
>>%io% ECHO ECHO Use this syntax: 
>>%io% ECHO ECHO SEE file password 
>>%io% ECHO ECHO.
>>%io% ECHO GOTO END
>>%io% ECHO :OUT 
>>%io% ECHO ECHO. 
>>%io% ECHO ECHO Press any key to clear the screen, or press
>>%io% ECHO ECHO Ctrl-C to quit the batch file and keep the info displayed.
>>%io% ECHO PAUSE > NUL
>>%io% ECHO CLS
>>%io% ECHO :END
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO ================================================================
>>%io% ECHO N ENCRYPT.COM 
>>%io% ECHO E 0100 EB 34 53 79 6E 74 61 78 
>>%io% ECHO E 0108 3A 20 45 4E 43 52 59 50 
>>%io% ECHO E 0110 54 20 22 70 61 73 73 77 
>>%io% ECHO E 0118 6F 72 64 22 20 3C 69 6E 
>>%io% ECHO E 0120 66 69 6C 65 20 3E 6F 75 
>>%io% ECHO E 0128 74 66 69 6C 65 0D 0A 24 
>>%io% ECHO E 0130 00 00 00 00 00 00 FC BE 
>>%io% ECHO E 0138 81 00 AC 3C 20 74 FB 3C 
>>%io% ECHO E 0140 0D 74 61 3C 22 75 5D 8B 
>>%io% ECHO E 0148 EE 33 C9 AC 3C 22 74 07
>>%io% ECHO E 0150 3C 0D 74 50 41 EB F4 0B 
>>%io% ECHO E 0158 C9 74 49 89 0E 34 01 B8 
>>%io% ECHO E 0160 00 80 33 D2 F7 36 34 01 
>>%io% ECHO E 0168 F7 26 34 01 A3 30 01 B4 
>>%io% ECHO E 0170 3F BB 00 00 8B 0E 30 01 
>>%io% ECHO E 0178 BA C4 01 CD 21 72 20 0B 
>>%io% ECHO E 0180 C0 74 1C A3 32 01 E8 24 
>>%io% ECHO E 0188 00 B4 40 BB 01 00 8B 0E 
>>%io% ECHO E 0190 32 01 BA C4 01 CD 21 72 
>>%io% ECHO E 0198 06 3B 06 30 01 73 D0 B8 
>>%io% ECHO E 01A0 00 4C CD 21 B4 09 BA 02 
>>%io% ECHO E 01A8 01 CD 21 EB F2 8B F5 BF 
>>%io% ECHO E 01B0 C4 01 8B 0E 32 01 AC 3C 
>>%io% ECHO E 01B8 22 75 03 8B F5 AC 30 05 
>>%io% ECHO E 01C0 47 E2 F3 C3 
>>%io% ECHO RCX 
>>%io% ECHO C4 
>>%io% ECHO W 
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < ENCRYPT.SCR > NUL
%jet% GOTO xDEBUGSCR
:ENVFREE
SET io=ENVFREE.SCR
REM>%io%
>>%io% ECHO N ENVFREE.COM
>>%io% ECHO A 100
>>%io% ECHO JMP 0104            ;Jump into loop
>>%io% ECHO MOV DS,AX           ;Address parent's PSP
>>%io% ECHO MOV BX,DS           ;Get current PSP in BX
>>%io% ECHO MOV AX,[0016]       ;Get parent's PSP in AX
>>%io% ECHO CMP AX,BX           ;If not =, loop
>>%io% ECHO JNZ 0102
>>%io% ECHO MOV AX,[002C]       ;Get seg of Env
>>%io% ECHO PUSH AX             ;Save it
>>%io% ECHO POP ES
>>%io% ECHO DEC AX              ;Point to MCB
>>%io% ECHO MOV DS,AX           ;Address it
>>%io% ECHO MOV BX,[0003]       ;Get length in 16-byte paragraphs
>>%io% ECHO MOV CX, 4
>>%io% ECHO SHL BX, CL          ;Convert length to bytes
>>%io% ECHO SUB AX, AX          ;Zero AX for use in comparison
>>%io% ECHO SUB DI, DI          ;Start at offset 0
>>%io% ECHO MOV CX, BX          ;Limit search to known size
>>%io% ECHO DEC CX              ;Last word starts 2 bytes before size
>>%io% ECHO DEC CX              ;Search for 0-word on each byte
>>%io% ECHO                     ;Begin search loop
>>%io% ECHO SCASW               ;ES:DI points to 0?
>>%io% ECHO JE 12C              ;End of environment? jump out!
>>%io% ECHO DEC DI              ;Nope, next byte
>>%io% ECHO LOOP 126            ;Try again, but don't exceed size
>>%io% ECHO MOV AX, CX          ;Env. size in bytes into AX
>>%io% ECHO MOV CX, 4
>>%io% ECHO SHR AX, CL          ;Convert length to paragraphs
>>%io% ECHO OR  AH,AH           ;Top byte 0?
>>%io% ECHO JZ  0139
>>%io% ECHO MOV AL,FF           ;Set to max
>>%io% ECHO MOV AH,4C           ;Terminate
>>%io% ECHO INT 21
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 3F
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ENVFREE.SCR > NUL
%jet% GOTO xDEBUGSCR
:ENVSIZE
SET io=ENVSIZE.SCR
REM>%io%
>>%io% ECHO N ENVSIZE.COM
>>%io% ECHO A 100
>>%io% ECHO JMP 0104            ;Jump into loop
>>%io% ECHO MOV DS,AX           ;Address parent's PSP
>>%io% ECHO MOV BX,DS           ;Get current PSP in BX
>>%io% ECHO MOV AX,[0016]       ;Get parent's PSP in AX
>>%io% ECHO CMP AX,BX           ;If not =, loop
>>%io% ECHO JNZ 0102
>>%io% ECHO MOV AX,[002C]       ;Get seg of Env
>>%io% ECHO DEC AX              ;Point to MCB
>>%io% ECHO MOV DS,AX           ;Address it
>>%io% ECHO MOV AX,[0003]       ;Get length
>>%io% ECHO OR  AH,AH           ;Top byte 0?
>>%io% ECHO JZ  011C
>>%io% ECHO MOV AL,FF           ;Set to max
>>%io% ECHO MOV AH,4C           ;Terminate
>>%io% ECHO INT 21
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 20
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ENVSIZE.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQDISKS1
SET io=EQDISKS1.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO MOV  AX,0040   ; Look inside ROM BIOS
>>%io% ECHO MOV  DS,AX     ;   equipment area
>>%io% ECHO MOV  AX,[0010] ;   at equipment byte
>>%io% ECHO AND  AL,1      ; Mask leaving bit 0
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQDISKS1.COM
>>%io% ECHO RCX
>>%io% ECHO E
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < EQDISKS1.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQDISKS2
SET io=EQDISKS2.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO INT  11        ; Call BIOS interrupt 11h
>>%io% ECHO AND  AL,1      ; Mask leaving bit 1
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQDISKS2.COM
>>%io% ECHO RCX
>>%io% ECHO 8
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < EQDISKS2.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQDRIVES
SET io=EQDRIVES.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO INT  11        ; Call BIOS interrupt 11h
>>%io% ECHO AND  AL,C0     ; Mask leaving bits 6 & 7
>>%io% ECHO MOV  CL,2      ; Ready to rotate 2 bits
>>%io% ECHO ROL  AL,CL     ; Do it
>>%io% ECHO INC  AL        ; Add one to result
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQDRIVES.COM
>>%io% ECHO RCX
>>%io% ECHO E
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < EQDRIVES.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQGAME
SET io=EQGAME.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO INT  11        ; Call BIOS interrupt 11h
>>%io% ECHO AND  AX,1000   ; Mask leaving bit 12
>>%io% ECHO MOV  CL,4      ; Ready to rotate 4 bits
>>%io% ECHO ROL  AX,CL     ; Do it
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQGAME.COM
>>%io% ECHO RCX
>>%io% ECHO D
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < EQGAME.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQMATH
SET io=EQMATH.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO INT  11        ; Call BIOS interrupt 11h
>>%io% ECHO AND  AX,2      ; Mask leaving bit 1
>>%io% ECHO ROR  AL,1      ; Do it
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQMATH.COM
>>%io% ECHO RCX
>>%io% ECHO B
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < EQMATH.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQPPORTS
SET io=EQPPORTS.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO INT  11        ; Call BIOS interrupt 11h
>>%io% ECHO AND  AX,C000   ; Mask leaving bits 14,15
>>%io% ECHO MOV  CL,2      ; Ready to rotate 2 bits
>>%io% ECHO ROL  AX,CL     ; Do it
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQPPORTS.COM
>>%io% ECHO RCX
>>%io% ECHO D
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO.
DEBUG < EQPPORTS.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQSPORTS
SET io=EQSPORTS.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO INT  11        ; Call BIOS interrupt 11h
>>%io% ECHO AND  AX,0E00   ; Mask leaving bits 9,10,11
>>%io% ECHO MOV  CL,7      ; Ready to rotate 7 bit
>>%io% ECHO ROL  AX,CL     ; Do it
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQSPORTS.COM
>>%io% ECHO RCX
>>%io% ECHO D
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
>>%io% ECHO.
DEBUG < EQSPORTS.SCR > NUL
%jet% GOTO xDEBUGSCR
:EQVIDEO
SET io=EQVIDEO.SCR
REM>%io%
>>%io% ECHO A
>>%io% ECHO INT  11        ; Call BIOS interrupt 11h
>>%io% ECHO AND  AL,30     ; Mask leaving bits 4,5
>>%io% ECHO MOV  CL,4      ; Ready to rotate 4 bits
>>%io% ECHO ROR  AL,CL     ; Do it
>>%io% ECHO MOV  AH,4C     ; Exit with ERRORLEVEL
>>%io% ECHO INT  21        ;   via DOS
>>%io% ECHO.
>>%io% ECHO N EQVIDEO.COM
>>%io% ECHO RCX
>>%io% ECHO C
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < EQVIDEO.SCR > NUL
%jet% GOTO xDEBUGSCR
:ESC
SET io=ESC.SCR
REM>%io%
>>%io% ECHO N ESC.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     SI,0082
>>%io% ECHO SUB     CH,CH
>>%io% ECHO MOV     CL,[SI-02]
>>%io% ECHO JCXZ    0119
>>%io% ECHO DEC     CX
>>%io% ECHO LODSB
>>%io% ECHO CMP     AL,7E
>>%io% ECHO JNZ     0112
>>%io% ECHO MOV     AL,1B
>>%io% ECHO XCHG    DX,AX
>>%io% ECHO MOV     AH,02
>>%io% ECHO INT     21
>>%io% ECHO LOOP    010B
>>%io% ECHO INT     20
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 1B
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ESC.SCR > NUL
%jet% GOTO xDEBUGSCR
:FASTKEY
SET io=FASTKEY.SCR
REM>%io%
>>%io% ECHO Resets the keyboard repeat rate and delay rate to the fastest possible.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO =============================================
>>%io% ECHO N FASTKEY.COM
>>%io% ECHO E 0100 B8 05 03 BB 03 00 CD 16
>>%io% ECHO E 0108 CD 20
>>%io% ECHO RCX
>>%io% ECHO 000A
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < FASTKEY.SCR > NUL
%jet% GOTO xDEBUGSCR
:FILES
SET io=FILES.SCR
REM>%io%
>>%io% ECHO N FILES.COM
>>%io% ECHO A 100
>>%io% ECHO SUB     DX,DX      ; zero out DX
>>%io% ECHO MOV     AH,52      ; select get list-of-lists function
>>%io% ECHO INT     21         ; call INT 21h
>>%io% ECHO ADD     BX,04      ; ES:BX points to pointer to first SFT
>>%io% ECHO ES:
>>%io% ECHO LES     BX,[BX]    ; ES:BX points to an SFT
>>%io% ECHO CMP     BX,FFFF    ; offset = FFFF?
>>%io% ECHO JE      117        ; if so, done!
>>%io% ECHO ES:                ; ES segment override
>>%io% ECHO ADD     DX,[BX+4]  ; get number of files in this SFT
>>%io% ECHO JMP     109        ; follow pointer to next SFT
>>%io% ECHO MOV     AL,DL      ; put number in AX
>>%io% ECHO MOV     AH,4C      ; select terminate w/ exit code function
>>%io% ECHO INT     21         ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 1D
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < FILES.SCR > NUL
%jet% GOTO xDEBUGSCR
:FIND-CD
SET io=FIND-CD.SCR
REM>%io%
>>%io% ECHO N FIND-CD.COM
>>%io% ECHO E100 E8 "P"0 BA 96 2 B4 9 CD "!1"C9 B8 B 15 "1"DB CD "/"81
>>%io% ECHO E114 FB AD AD "u"B 9 C0 "u"19 "A"81 F9 1A 0 "r"E8 BA A4 2 B4
>>%io% ECHO E128 9 CD "!"BD B9 2 E8 D3 0 B8 1 "L"CD "!"80 C1 "A"88 E B4
>>%io% ECHO E13C 2 88 E BF 2 BA B1 2 B4 9 CD "!"BD B9 2 E8 DC 0 B8 0 "L"
>>%io% ECHO E151 CD "!"8B 1E 16 0 83 FB 8 "vY"8E C3 "&"A1 0 0 "="CD " u"
>>%io% ECHO E166 "N&"A1 ","0 "H"8E C0 40 "&"8A E 0 0 80 F9 "Mt"5 80 F9
>>%io% ECHO E17B "Zu7&;"1E 1 0 "u0&"8B 1E 3 0 83 FB 2 "r&"F6 C7 F0 "u!"
>>%io% ECHO E194 B1 4 D3 E3 89 1E "^"0 A3 "\"0 8E C0 BE FF FF "F&"83 "<"
>>%io% ECHO E1A8 0 "u"F9 "FF)"F3 89 1E "`"0 F8 C3 "1"C0 A3 "\"0 A3 "^"0
>>%io% ECHO E1BD A3 "`"0 F9 C3 A1 "\"0 83 F8 0 "t4"8E C0 "1"DB "&9"1F 74
>>%io% ECHO E1D2 "+1"F6 8A 2 "&:"0 "u"11 "F<=u"F4 "&"80 "8"0 "t"3 "F"EB
>>%io% ECHO E1E9 F7 "F"F8 C3 "&"8B 0 "F<"0 "u"F8 80 FC 0 "t"4 1 F3 EB D5
>>%io% ECHO E1FE "1"DB 89 DE F9 C3 E8 BB FF "r"1F 1 "6`"0 "&"80 "8"0 "u"
>>%io% ECHO E212 7 "&"C7 7 0 0 F8 C3 "&"8B 0 "&"89 7 "C"83 F8 0 "u"F4 F8
>>%io% ECHO E227 C3 F9 C3 A1 "\"0 83 F8 0 "tb"8E C0 "1"F6 89 F2 8A 2 "F"
>>%io% ECHO E23B "<=u"6 9 D2 "u"2 89 F2 "<"0 "u"EF 9 D2 "tGB9"F2 "t"B2
>>%io% ECHO E252 89 F1 E8 "k"FF A1 "`"0 "r"2 1 F0 "9"C1 "w2"E8 9F FF "1"
>>%io% ECHO E266 DB "&9"1F "u"8 A1 "`"0 ")"C8 "H"EB C 8B 1E "^"0 A1 "`"0
>>%io% ECHO E27B ")"C3 "K)"C8 A3 "`"0 "1"F6 8A 2 "&"88 0 "F<"0 "u"F6 "&"
>>%io% ECHO E290 88 0 F8 C3 F9 C3 "CD-ROM drive $not found."D A "$is A:"
>>%io% ECHO E2B6 D A "$CDROM=A:"0
>>%io% ECHO RCX
>>%io% ECHO 1C2
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < FIND-CD.SCR > NUL
%jet% GOTO xDEBUGSCR
:FINDCD
SET io=FINDCD.SCR
REM>%io%
>>%io% ECHO N FINDCD.COM
>>%io% ECHO A 100
>>%io% ECHO JMP   018D     ;jump over data
>>%io% ECHO DB "FINDCD 1.0 Copyright (c)" 20
>>%io% ECHO DB "1996, Robert L. Hummel"
>>%io% ECHO DB D A A
>>%io% ECHO DB "MSCDEX $"
>>%io% ECHO DB "not resident$"
>>%io% ECHO DB "ver: 00.00"
>>%io% ECHO DB D A 20
>>%io% ECHO DB "CDs found: 00"
>>%io% ECHO DB D A 20 20 20 20
>>%io% ECHO DB "Drives:" 20
>>%io% ECHO DB 24 24 24 24 24 24 24 24
>>%io% ECHO DB 24 24 24 24 24 24 24 24
>>%io% ECHO DB 24 24 24 24 24 24 24 24
>>%io% ECHO DB 24 24 24
>>%io% ECHO MOV   AH,09    ;display string
>>%io% ECHO MOV   DX,0103  ; copyright
>>%io% ECHO INT   21       ; thru DOS
>>%io% ECHO MOV   AX,1500  ;MSCDEX call fn
>>%io% ECHO SUB   BX,BX    ; install check
>>%io% ECHO INT   2F       ; multiplex
>>%io% ECHO OR    BX,BX    ; 0=not installed
>>%io% ECHO JNZ   01AE
>>%io% ECHO MOV   DX,013D  ;say not present
>>%io% ECHO SUB   AL,AL    ; exit code 0
>>%io% ECHO PUSH  AX       ; save it
>>%io% ECHO MOV   AH,09    ;display string
>>%io% ECHO INT   21       ; thru DOS
>>%io% ECHO POP   AX       ;get exit code
>>%io% ECHO MOV   AH,4C    ; terminate
>>%io% ECHO INT   21       ; thru DOS
>>%io% ECHO MOV   CX,BX    ;save drive count
>>%io% ECHO MOV   AL,BL    ;move to AL
>>%io% ECHO AAM
>>%io% ECHO OR    AX,3030  ; make ASCII
>>%io% ECHO XCHG  AH,AL    ; change order
>>%io% ECHO MOV   [162],AX; save in string
>>%io% ECHO MOV   AX,150C  ;get version fn
>>%io% ECHO INT   2F       ; multiplex
>>%io% ECHO MOV   AL,BH    ;AL=major ver
>>%io% ECHO AAM
>>%io% ECHO OR    AX,3030  ; make ASCII
>>%io% ECHO XCHG  AH,AL    ; change order
>>%io% ECHO MOV   [14F],AX; save in string
>>%io% ECHO MOV   AL,BL    ;AL=minor ver
>>%io% ECHO AAM
>>%io% ECHO OR    AX,3030  ; make ASCII
>>%io% ECHO XCHG  AH,AL    ; change order
>>%io% ECHO MOV   [152],AX; save instring
>>%io% ECHO MOV   AX,150D  ;get drive letters fn
>>%io% ECHO MOV   BX,0172  ; DS:BX = buffer
>>%io% ECHO MOV   SI,BX    ; save address
>>%io% ECHO INT   2F       ; multiplex
>>%io% ECHO MOV   AL,CL    ;# drives is exit code
>>%io% ECHO ADD   Byte [SI],41 ;convert to letters
>>%io% ECHO INC   SI       ; next drive
>>%io% ECHO LOOP  01E5     ; for all drives
>>%io% ECHO MOV   DX,014A  ;show summary msg
>>%io% ECHO JMP   01A4     ; display and exit
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO F0
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < FINDCD.SCR > NUL
%jet% GOTO xDEBUGSCR
:FMT360
SET io=FMT360.SCR
REM>%io%
>>%io% ECHO N FMT360.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  SP,0200     ; Adjust stack pointer
>>%io% ECHO MOV  SI,0150     ; Offset of parameter block
>>%io% ECHO MOV  BX,0        ; Use our environment
>>%io% ECHO MOV  [SI],BX     ; 1st parameter block entry
>>%io% ECHO MOV  BX,01C0     ; Offset of command-line tail
>>%io% ECHO MOV  [SI+2],BX   ; 2nd parameter block entry
>>%io% ECHO MOV  AX,CS       ; Put our code segment in AX
>>%io% ECHO MOV  [SI+4],AX   ; 3rd parameter block entry
>>%io% ECHO MOV  BX,005C     ; Offset of FCB #1
>>%io% ECHO MOV  [SI+6],BX   ; 4th parameter block entry
>>%io% ECHO MOV  [SI+8],AX   ; 5th parameter block entry
>>%io% ECHO MOV  BX,006C     ; Offset of FCB #2
>>%io% ECHO MOV  [SI+A],BX   ; 6th parameter block entry
>>%io% ECHO MOV  [SI+C],AX   ; 7th parameter block entry
>>%io% ECHO MOV  BX,0020     ; Shrink program's memory 
>>%io% ECHO MOV  AH,4A       ; to 32 paragraphs
>>%io% ECHO INT  21          ; Call DOS service 4Ah
>>%io% ECHO MOV  BX,SI       ; Offset of parameter block
>>%io% ECHO MOV  DX,0180     ; Offset of program name
>>%io% ECHO MOV  AX,4B00     ; Service 4Bh, function 00h
>>%io% ECHO INT  21          ; Call DOS
>>%io% ECHO JNC  146         ; Jump to MOV AL,0 if no error
>>%io% ECHO MOV  DX,160      ; Offset of error message
>>%io% ECHO MOV  AH,09       ; Prepare to display error
>>%io% ECHO INT  21          ; Display error message
>>%io% ECHO MOV  AL,1        ; Set ERRORLEVEL=FAILURE
>>%io% ECHO JMP  148         ; Jump to MOV AH,4C
>>%io% ECHO MOV  AL,0        ; Set ERRORLEVEL=SUCCESS
>>%io% ECHO MOV  AH,4C       ; Prepare to exit
>>%io% ECHO INT  21          ; Exit to DOS
>>%io% ECHO NOP              ; ====DATA STARTS HERE========
>>%io% ECHO ORG  150         ; Put parameter block at 0150h
>>%io% ECHO DW   0, 0, 0, 0, 0, 0, 0
>>%io% ECHO ORG  160         ; Put error message at 160h
>>%io% ECHO DB   'Error running FORMAT.BIN', 0D, 0A, '$'
>>%io% ECHO ORG  180         ; Put program name at 0180h
>>%io% ECHO DB   'C:\DOS\FORMAT.BIN', 0
>>%io% ECHO ORG  1C0         ; Put command tail at 01C0h
>>%io% ECHO DB   0A, ' A: /F:360', 0D
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 100
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < FMT360.SCR > NUL
%jet% GOTO xDEBUGSCR
:FULLSCR
SET io=FULLSCR.SCR
REM>%io%
>>%io% ECHO REM Debug script to swtich DOS session to full screen in MS-Win
>>%io% ECHO REM PC/C July 94 p 194
>>%io% ECHO.
>>%io% ECHO N FULLSCR.COM
>>%io% ECHO E 0100 EB 04 00 00 00 00 B8 84
>>%io% ECHO E 0108 16 BB 15 00 CD 2F 0B FF
>>%io% ECHO E 0110 75 06 8C C0 0B C0 74 0F
>>%io% ECHO E 0118 89 3E 02 01 8C 06 04 01
>>%io% ECHO E 0120 B8 01 00 FF 1E 02 01 BB
>>%io% ECHO E 0128 00 4C CD 21
>>%io% ECHO RCX
>>%io% ECHO 2C
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < FULLSCR.SCR > NUL
%jet% GOTO xDEBUGSCR
:GETCH
SET io=GETCH.SCR
REM>%io%
>>%io% ECHO  a
>>%io% ECHO  XOR AX,AX
>>%io% ECHO  INT 16
>>%io% ECHO  MOV AH,4C
>>%io% ECHO  INT 21
>>%io% ECHO  
>>%io% ECHO  rcx
>>%io% ECHO  8
>>%io% ECHO  ngetch.com
>>%io% ECHO  w
>>%io% ECHO  q
DEBUG < GETCH.SCR > NUL
%jet% GOTO xDEBUGSCR
:GETEXKEY
SET io=GETEXKEY.SCR
REM>%io%
>>%io% ECHO N GETEXKEY.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AH,0     ; Select function 0, read character
>>%io% ECHO INT 16       ; Call the keyboard interrupt
>>%io% ECHO XCHG AH,AL   ; Swap ASCII code w/ scan code
>>%io% ECHO CMP AH,0     ; Was ASCII code 0?
>>%io% ECHO JZ 10D       ; If so, jump over next line
>>%io% ECHO XOR AL,AL    ; Zero out exit code
>>%io% ECHO MOV AH,4C    ; Select terminate w/ exit code function
>>%io% ECHO INT 21       ; Call interrupt 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 11
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < GETEXKEY.SCR > NUL
%jet% GOTO xDEBUGSCR
:GETKEY
SET io=GETKEY.SCR
REM>%io%
>>%io% ECHO N GETKEY.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AH,0    ; Select function 0, read character
>>%io% ECHO INT 16      ; Call the keyboard interrupt
>>%io% ECHO MOV AH,4C   ; Select terminate w/ exit code function
>>%io% ECHO INT 21      ; Call interrupt 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 8
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < GETKEY.SCR > NUL
%jet% GOTO xDEBUGSCR
:GLOBAL
SET io=GLOBAL.SCR
REM>%io%
>>%io% ECHO Executes DOS command in all subdirectories
>>%io% ECHO ===========================================
>>%io% ECHO n GLOBAL.COM
>>%io% ECHO.
>>%io% ECHO e 100 E9 33 1 0 3A 5C 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 110 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 120 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 130 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 140 0 0 0 0 0 0 0 0 2F 63 20 0 0 0 0 0 
>>%io% ECHO e 150 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 160 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 170 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 180 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 190 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 1A0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 1B0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 1C0 0 0 0 0 0 0 0 0 0 0 0 2A 2E 2A 0 2E 
>>%io% ECHO e 1D0 2E 0 4E 65 65 64 20 44 6F 73 20 32 2E 30 20 6F 
>>%io% ECHO e 1E0 72 20 67 72 65 61 74 65 72 D A A 24 D A 20 
>>%io% ECHO e 1F0 20 20 55 53 41 47 45 3A 20 20 47 4C 4F 42 41 4C 
>>%io% ECHO e 200 20 3C 61 6E 79 20 64 6F 73 20 63 6F 6D 6D 61 6E 
>>%io% ECHO e 210 64 3E D A A 24 D A A 44 6F 6E 65 20 77 69 
>>%io% ECHO e 220 74 68 20 61 6C 6C 20 64 69 72 65 63 74 6F 72 69 
>>%io% ECHO e 230 65 73 D A A 24 BC D7 F FB FC B4 30 CD 21 3C 
>>%io% ECHO e 240 2 73 B BA D2 1 E 1F B4 9 CD 21 CD 20 B4 19 
>>%io% ECHO e 250 CD 21 8A D0 FE C2 4 41 2E A2 3 1 BE 6 1 B4 
>>%io% ECHO e 260 47 CD 21 BE 80 0 AC A C0 75 5 BA ED 1 EB D6 
>>%io% ECHO e 270 4 3 2E A2 47 1 AC 3C D 74 F0 4E BF 4B 1 B9 
>>%io% ECHO e 280 80 0 F3 A4 BB D7 F 83 C3 F B1 4 D3 EB B4 4A 
>>%io% ECHO e 290 CD 21 E8 1B 0 B4 3B BA 3 1 CD 21 BA 16 2 B4 
>>%io% ECHO e 2A0 9 CD 21 CD 20 52 B4 3B BA 3 1 CD 21 5A EB 96 
>>%io% ECHO e 2B0 55 83 EC 31 8B EC 83 C5 4 6 B4 2F CD 21 89 5E 
>>%io% ECHO e 2C0 FC 8C 46 FE 7 B4 1A 8B D5 CD 21 B4 B CD 21 E8 
>>%io% ECHO e 2D0 76 0 BA CB 1 B9 10 0 B4 4E CD 21 72 27 80 7E 
>>%io% ECHO e 2E0 1E 2E 74 16 F6 46 15 10 74 10 8B D5 83 C2 1E B4 
>>%io% ECHO e 2F0 3B CD 21 B4 B CD 21 E8 B6 FF B4 4F B9 10 0 CD 
>>%io% ECHO e 300 21 72 2 EB D9 BA CF 1 B4 3B CD 21 1E 8E 5E FE 
>>%io% ECHO e 310 8B 56 FC B4 1A CD 21 1F 83 C4 31 5D C3 5C 43 4F 
>>%io% ECHO e 320 4D 4D 41 4E 44 2E 43 4F 4D 0 43 4F 4D 53 50 45 
>>%io% ECHO e 330 43 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
>>%io% ECHO e 340 0 0 0 0 0 0 0 0 55 1E 6 6 B4 2F CD 21 
>>%io% ECHO e 350 2E 8C 6 46 3 2E 89 1E 44 3 7 BF 2A 3 8B 1E 
>>%io% ECHO e 360 2C 0 2E 89 1E 32 3 E8 64 0 72 59 8B D6 8C C8 
>>%io% ECHO e 370 2E A3 36 3 2E A3 3A 3 2E A3 3E 3 2E C7 6 34 
>>%io% ECHO e 380 3 47 1 2E C7 6 38 3 5C 0 2E C7 6 3C 3 6C 
>>%io% ECHO e 390 0 BB 32 3 2E 8C 16 40 3 2E 89 26 42 3 B8 0 
>>%io% ECHO e 3A0 4B CD 21 FA 2E 8E 16 40 3 2E 8B 26 42 3 FB 2E 
>>%io% ECHO e 3B0 8E 1E 46 3 2E 8B 16 44 3 B4 1A CD 21 7 1F B4 
>>%io% ECHO e 3C0 4D CD 15 5D C3 8C C8 8E D8 BE 1D 3 EB 9E 8E DB 
>>%io% ECHO e 3D0 57 26 8A 5 A C0 74 6 E8 38 0 47 EB F3 4F 8B 
>>%io% ECHO e 3E0 D7 8B CF 5F 2B CF 41 8B FA 2B F6 AC A C0 75 6 
>>%io% ECHO e 3F0 80 7C 1 0 74 1B E8 1A 0 88 44 FF 3C 3D 75 EB 
>>%io% ECHO e 400 56 57 51 83 EE 2 FD F2 A6 FC 59 5F 5E 75 DC F8 
>>%io% ECHO e 410 C3 F9 C3 3C 61 72 6 3C 7A 77 2 2C 20 C3 90 0 
>>%io% ECHO rcx
>>%io% ECHO 31F
>>%io% ECHO w
>>%io% ECHO q
DEBUG < GLOBAL.SCR > NUL
%jet% GOTO xDEBUGSCR
:GOTOROW
SET io=GOTOROW.SCR
REM>%io%
>>%io% ECHO N GOTOROW.COM
>>%io% ECHO A    100
>>%io% ECHO MOV  AH,F      ; Lets you place the cursor on any row
>>%io% ECHO INT  10        ; on screen
>>%io% ECHO PUSH BX        ; DOS World, Jan, 1995, pg 34
>>%io% ECHO SUB  AX,AX
>>%io% ECHO MOV  SI,5D
>>%io% ECHO LODSB
>>%io% ECHO CMP  AL,20
>>%io% ECHO JZ   117
>>%io% ECHO SUB  AL,30
>>%io% ECHO AAD
>>%io% ECHO MOV  AH,AL
>>%io% ECHO JMP  10A
>>%io% ECHO DEC  AH
>>%io% ECHO MOV  DH,AH
>>%io% ECHO SUB  DL,DL
>>%io% ECHO MOV  AH,2
>>%io% ECHO POP  BX
>>%io% ECHO INT  10
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO R CX
>>%io% ECHO 23
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < GOTOROW.SCR > NUL
%jet% GOTO xDEBUGSCR
:GSONOFF
SET io=GSONOFF.SCR
REM>%io%
>>%io% ECHO A 100
>>%io% ECHO MOV AX,1200
>>%io% ECHO MOV BL,33
>>%io% ECHO INT 10
>>%io% ECHO MOV AH,0F
>>%io% ECHO INT 10
>>%io% ECHO MOV AH,00
>>%io% ECHO INT 10
>>%io% ECHO MOV AX,4C00
>>%io% ECHO INT 21
>>%io% ECHO.
>>%io% ECHO N GSON.COM
>>%io% ECHO R CX
>>%io% ECHO 14
>>%io% ECHO W
>>%io% ECHO A 100
>>%io% ECHO MOV AX,1201
>>%io% ECHO.
>>%io% ECHO N GSOFF.COM
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < GSONOFF.SCR > NUL
%jet% GOTO xDEBUGSCR
:H2D
SET io=H2D.SCR
REM>%io%
>>%io% ECHO H2D.COM                                             Jeff Prosise
>>%io% ECHO HEX2DEC                                                July 1992
>>%io% ECHO ________________________________________________________________
>>%io% ECHO Purpose:       Convert hexadecimal numbers to decimal.
>>%io% ECHO.
>>%io% ECHO Format:        To use the program, type H2D followed by a
>>%io% ECHO                hexadecimal number. H2D will display the 
>>%io% ECHO                decimal equivalent onscreen.
>>%io% ECHO.
>>%io% ECHO Remarks:       Type H2D A42, for example, and the program
>>%io% ECHO                replies with 2626, the decimal equivalent of
>>%io% ECHO                hex A42. H2D will accept numbers as high as
>>%io% ECHO                FFFFFFFF (equal to 4,294,967,296). If you 
>>%io% ECHO                exceed this boundary or enter characters that 
>>%io% ECHO                aren't valid hex digits, H2D displays the 
>>%io% ECHO                message, `Error: Invalid digit or number too
>>%io% ECHO                large."
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO --------------------------------------------
>>%io% ECHO.
>>%io% ECHO N H2D.COM
>>%io% ECHO E 0100 EB 30 90 00 00 00 00 45
>>%io% ECHO E 0108 72 72 6F 72 3A 20 49 6E
>>%io% ECHO E 0110 76 61 6C 69 64 20 64 69
>>%io% ECHO E 0118 67 69 74 20 6F 72 20 6E
>>%io% ECHO E 0120 75 6D 62 65 72 20 74 6F
>>%io% ECHO E 0128 6F 20 6C 61 72 67 65 0D
>>%io% ECHO E 0130 0A 24 FC BE 81 00 AC 3C
>>%io% ECHO E 0138 20 74 FB 3C 0D 74 37 33
>>%io% ECHO E 0140 C9 4E AC 3C 20 74 2F 3C
>>%io% ECHO E 0148 0D 74 2B 83 F9 08 74 35
>>%io% ECHO E 0150 41 E8 3A 00 72 2F 51 8B
>>%io% ECHO E 0158 1E 03 01 A1 05 01 B9 04
>>%io% ECHO E 0160 00 D1 E3 D1 D0 E2 FA 03
>>%io% ECHO E 0168 DA 15 00 00 89 1E 03 01
>>%io% ECHO E 0170 A3 05 01 59 EB CC 8B 1E
>>%io% ECHO E 0178 03 01 A1 05 01 E8 3F 00
>>%io% ECHO E 0180 B8 00 4C CD 21 B4 09 BA
>>%io% ECHO E 0188 07 01 CD 21 EB F2 3C 30
>>%io% ECHO E 0190 72 2B 3C 39 77 09 8A D0
>>%io% ECHO E 0198 80 EA 30 32 F6 F8 C3 3C
>>%io% ECHO E 01A0 41 72 1A 3C 46 77 07 8A
>>%io% ECHO E 01A8 D0 80 EA 37 EB ED 3C 61
>>%io% ECHO E 01B0 72 0B 3C 66 77 07 8A D0
>>%io% ECHO E 01B8 80 EA 57 EB DE 79 C3 33
>>%io% ECHO E 01C0 C9 BF 0A 00 33 D2 F7 F7
>>%io% ECHO E 01C8 8B F0 8B C3 F7 F7 8B D8
>>%io% ECHO E 01D0 8B C6 41 52 0B C0 75 EC
>>%io% ECHO E 01D8 0B D8 75 E8 B4 02 5A 80
>>%io% ECHO E 01E0 C2 30 CD 21 E2 F6 B4 09
>>%io% ECHO E 01E8 BA 2F 01 CD 21 C3
>>%io% ECHO RCX
>>%io% ECHO EE
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < H2D.SCR > NUL
%jet% GOTO xDEBUGSCR
:INPUT
SET io=INPUT.SCR
REM>%io%
>>%io% ECHO a100
>>%io% ECHO push cs         ; Set up the data segment
>>%io% ECHO pop  ds
>>%io% ECHO ;
>>%io% ECHO ; GET_CHAR: get a character and decide what it is
>>%io% ECHO mov  ah,08  ; get char from user & put in CL
>>%io% ECHO int  21
>>%io% ECHO mov  cl,al
>>%io% ECHO mov  al,[0162]  ; put current value in AL
>>%io% ECHO cmp  cl,08      ; if char=BACKSPC goto PROC_BKSP
>>%io% ECHO jz   014c
>>%io% ECHO cmp  cl,0d      ; if char=RETURN goto PROC_RETURN
>>%io% ECHO jz   0148
>>%io% ECHO cmp  cl,00      ; if char=FUN_KEY goto PROC_FNKY
>>%io% ECHO jz   013c
>>%io% ECHO cmp  cl,39      ; if char!=DIGIT goto ERROR
>>%io% ECHO ja   0140
>>%io% ECHO sub  cl,30
>>%io% ECHO jb   0140   ; <fall through to DIGIT>
>>%io% ECHO ;
>>%io% ECHO ; DIGIT: add the digit the user entered to the
>>%io% ECHO ;        current value
>>%io% ECHO mul  byte ptr [0167]        ; Mult current val by 10
>>%io% ECHO add  al,cl      ; add the digit the user entered
>>%io% ECHO adc  ah,00
>>%io% ECHO jnz  0140       ; if value > 255 goto ERROR
>>%io% ECHO mov  [0162],al  ; store new value
>>%io% ECHO or   al,al      ; if value=0 goto GET_CHAR
>>%io% ECHO jz   0102       ; (i.e. don't print leading 0s)
>>%io% ECHO mov  dl,30      ; print character user entered
>>%io% ECHO add  dl,cl
>>%io% ECHO jmp  0142
>>%io% ECHO ;
>>%io% ECHO ; PROC_FNKY: remove rest of func. key & ignore
>>%io% ECHO mov  ah,08      ; read the second half of func.
>>%io% ECHO int  21         ; key (with no echo) and fall
>>%io% ECHO                 ; through to:
>>%io% ECHO ;
>>%io% ECHO ; ERROR: beep at user, and go back to GET_CHAR
>>%io% ECHO mov  dl,07      ; send beep to user
>>%io% ECHO mov  ah,02
>>%io% ECHO int  21
>>%io% ECHO jmp  0102       ; goto GET_CHAR
>>%io% ECHO ;
>>%io% ECHO ; PROC_RETURN: return to DOS with new ERRLEVEL
>>%io% ECHO mov  ah,4c
>>%io% ECHO int  21
>>%io% ECHO ;
>>%io% ECHO ; PROC_BKSP: remove previous character from
>>%io% ECHO ;            val and screen
>>%io% ECHO or   al,al      ; if there's no char in val
>>%io% ECHO jz   0140       ; or on screen, goto ERROR
>>%io% ECHO xor  ah,ah      ; remove char from value
>>%io% ECHO div  byte ptr [0167]
>>%io% ECHO mov  [0162],al  ; store new value
>>%io% ECHO mov  ah,09      ; print a backspace to screen
>>%io% ECHO mov  dx,0163
>>%io% ECHO int  21
>>%io% ECHO jmp  0102       ; goto GET_CHAR
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO e 162
>>%io% ECHO 00 08 20 08 24 0a
>>%io% ECHO rbx
>>%io% ECHO 0
>>%io% ECHO rcx
>>%io% ECHO 68
>>%io% ECHO n input.com
>>%io% ECHO w
>>%io% ECHO q
DEBUG < INPUT.SCR > NUL
%jet% GOTO xDEBUGSCR
:ISAREADY
SET io=ISAREADY.SCR
REM>%io%
>>%io% ECHO Utility to test if Drive a: is ready.
>>%io% ECHO.
>>%io% ECHO Usage:
>>%io% ECHO.
>>%io% ECHO the_loop
>>%io% ECHO echo Insert Disk in A:
>>%io% ECHO IsAReady.com
>>%io% ECHO if     errorlevel 1 goto the_loop
>>%io% ECHO if not errorlevel 1 echo Drive ready
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO Cut Here
>>%io% ECHO --------------------------
>>%io% ECHO N ISAREADY.COM
>>%io% ECHO E 0100 B8 24 25 BA 13 01 CD 21
>>%io% ECHO E 0108 B4 1C B2 01 CD 21 B8 00
>>%io% ECHO E 0110 4C CD 21 B8 01 4C CD 21
>>%io% ECHO RCX
>>%io% ECHO 0018
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < ISAREADY.SCR > NUL
%jet% GOTO xDEBUGSCR
:ISDOS33
SET io=ISDOS33.SCR
REM>%io%
>>%io% ECHO N ISDOS33.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     AH,30    ; select get DOS version function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO XCHG    AH,AL    ; get major # in AH, minor in AL
>>%io% ECHO CMP     AX,031E  ; compare with 3.30
>>%io% ECHO MOV     AL,00    ; put 0 in AL for exit code
>>%io% ECHO JNB     010F     ; was version not below 3.30?
>>%io% ECHO INC     AL       ; if NOT, increment AL to 1
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 13
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ISDOS33.SCR > NUL
%jet% GOTO xDEBUGSCR
:ISDOS50
SET io=ISDOS50.SCR
REM>%io%
>>%io% ECHO N ISDOS50.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     AH,30    ; select get DOS version function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO XCHG    AH,AL    ; get major # in AH, minor in AL
>>%io% ECHO CMP     AX,0500  ; compare with 5.00
>>%io% ECHO MOV     AL,00    ; put 0 in AL for exit code
>>%io% ECHO JNB     010F     ; was version not below 5.00?
>>%io% ECHO INC     AL       ; if NOT, increment AL to 1
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 13
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ISDOS50.SCR > NUL
%jet% GOTO xDEBUGSCR
:ISENHANC
SET io=ISENHANC.SCR
REM>%io%
>>%io% ECHO N ISENHANC.COM
>>%io% ECHO A100
>>%io% ECHO MOV     AX,0040
>>%io% ECHO MOV     DS,AX      ; DS points to BIOS data area
>>%io% ECHO MOV     BH,[0017]  ; put shift state byte in BH
>>%io% ECHO MOV     AH,12      ; select (enhanced) get status function
>>%io% ECHO INT     16         ; call INT 16h (keyboard)
>>%io% ECHO CMP     BH,AL      ; results the same?
>>%io% ECHO JNZ     012A       ; if not, not enhanced
>>%io% ECHO MOV     BL,BH      ; save existing key state
>>%io% ECHO XOR     BH,20      ; toggle one bit...
>>%io% ECHO MOV     [0017],BH  ; ...and store changed byte
>>%io% ECHO MOV     AH,12      ; select (enhanced) get status function
>>%io% ECHO INT     16         ; call INT 16h (keyboard)
>>%io% ECHO MOV     [0017],BL  ; restore existing key state
>>%io% ECHO CMP     BH,AL      ; results the same?
>>%io% ECHO JNZ     012A       ; if not, not enhanced
>>%io% ECHO MOV     AL,00      ; is enhanced - return 0
>>%io% ECHO JMP     012C       ; jump to exit-w/-code
>>%io% ECHO MOV     AL,01      ; not enhanced - return 1
>>%io% ECHO MOV     AH,4C      ; select terminate w/ exit code function
>>%io% ECHO INT     21         ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 30
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < ISENHANC.SCR > NUL
%jet% GOTO xDEBUGSCR
:KBHIT
SET io=KBHIT.SCR
REM>%io%
>>%io% ECHO  a
>>%io% ECHO  MOV AH,01 ; KBHIT.COM will wait for user input and return an errorlevel
>>%io% ECHO  INT 16    ; for the key hit; can be used to display message after if a
>>%io% ECHO  JNZ 0108  ; certain key is hit.  Example:
>>%io% ECHO  XOR AL,AL ;    :loop
>>%io% ECHO  MOV AH,4C ;    kbhit
>>%io% ECHO  INT 21    ;    if errorlevel 65 if not errorlevel 91 echo Upper case letter
>>%io% ECHO  
>>%io% ECHO  rcx
>>%io% ECHO  0c
>>%io% ECHO  nkbhit.com
>>%io% ECHO  w
>>%io% ECHO  q
>>%io% ECHO   
DEBUG < KBHIT.SCR > NUL
%jet% GOTO xDEBUGSCR
:KEYCODE
SET io=KEYCODE.SCR
REM>%io%
>>%io% ECHO KeyCode.scr
>>%io% ECHO.
>>%io% ECHO Returns the ASCII and scan codes for pressed keys.
>>%io% ECHO.
>>%io% ECHO Line 1 = MOV AH, 00 = regular keyboard
>>%io% ECHO          MOV AH, 10 = for extended keyboard
>>%io% ECHO.
>>%io% ECHO Press CRTL-BREAK to exit program...
>>%io% ECHO.
>>%io% ECHO (From PC Magazine, User to User, Jan 28, 92)
>>%io% ECHO.
>>%io% ECHO Cut here --|
>>%io% ECHO --------------------------------------------------------------------------
>>%io% ECHO N KEYCODE.COM
>>%io% ECHO A 100
>>%io% ECHO JMP 0126
>>%io% ECHO DB  " =  "
>>%io% ECHO DB  "      hex     "
>>%io% ECHO DB  "    "
>>%io% ECHO DB  "    decimal",0D,0A,24
>>%io% ECHO MOV AH, 10        ;for regular keyboard, change to MOV AH, 00
>>%io% ECHO INT 16            ;return scan code AH, ascii in AL
>>%io% ECHO MOV BX, AX        ;store in BX.  BX is uneffected by
>>%io% ECHO MOV DL, AL        ;    hexidecimal or decimal routine
>>%io% ECHO MOV AH, 02
>>%io% ECHO INT 21            ;see if ascii printable character
>>%io% ECHO MOV DI, 0106      ;pointer to start of hex template
>>%io% ECHO CALL 0151         ;call hexadecimal routine
>>%io% ECHO MOV AL, BL        ;ascii value in AL
>>%io% ECHO MOV DI, 011A
>>%io% ECHO CALL 0170         ;call decimal routine
>>%io% ECHO MOV AL, BH        ;scan value in AL
>>%io% ECHO MOV DI, 0116
>>%io% ECHO CALL 0170         ;call decimal routine
>>%io% ECHO MOV DX, 0102      ;display all values
>>%io% ECHO MOV AH, 09
>>%io% ECHO INT 21
>>%io% ECHO JMP 0126          ;go again.  Quit with Ctrl-Break
>>%io% ECHO MOV CX, 0404      ;HEXIDECIMAL: counter in CH, rotate value in CL
>>%io% ECHO ROL BX, CL        ;get digit in BL. (Note that 4 rotations
>>%io% ECHO MOV AL, BL        ;     will leave BX unchanged, when done.)
>>%io% ECHO AND AL, 0F        ;zero high bits--do one number at a time
>>%io% ECHO OR AL, 30         ;add 30h, makes display-able ascii value
>>%io% ECHO CMP AL, 3A        ;digit 0-9 if below                       
>>%io% ECHO JL 0162           ;jump to SHOW
>>%io% ECHO ADD AL, 07        ;else make letter A-F
>>%io% ECHO MOV [DI], AL      ;place with DI pointer
>>%io% ECHO INC DI            ;next position right
>>%io% ECHO CMP CH, 03        ;have we got end of scan code?
>>%io% ECHO JNZ 016B
>>%io% ECHO INC DI            ;  if so, then leave one space
>>%io% ECHO DEC CH            ;decrease counter
>>%io% ECHO JNZ 0154          ;if counter not zero, go again
>>%io% ECHO RET
>>%io% ECHO MOV CX, 030A      ;DECIMAL: counter in CH, divisor in CL
>>%io% ECHO XOR AH, AH        ;zero AH
>>%io% ECHO DIV CL            ;divide AL by 0A (10 d), remainder in AH
>>%io% ECHO OR  AH, 30        ;make AH a display-able ascii value
>>%io% ECHO MOV [DI], AH      ;and place with pointer
>>%io% ECHO DEC DI            ;move one posiiton left
>>%io% ECHO DEC CH            ;decrease counter
>>%io% ECHO JZ 018A           ;if counter zero, jump to return
>>%io% ECHO CMP AL, 00        ;still a numerator to work with?
>>%io% ECHO JNZ 0173          ;  if so, go again
>>%io% ECHO MOV BYTE PTR [DI], 20 ;fill out three digits with blanks
>>%io% ECHO JMP 017C          ;      if necessary, to clear work area
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO R CX
>>%io% ECHO 8B
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < KEYCODE.SCR > NUL
%jet% GOTO xDEBUGSCR
:KEYPRESS
SET io=KEYPRESS.SCR
REM>%io%
>>%io% ECHO NKEYPRESS.COM
>>%io% ECHO A100
>>%io% ECHO MOV AH,1   ; Select function 1, get keyboard status
>>%io% ECHO INT 16     ; Call the keyboard interrupt
>>%io% ECHO MOV AL,1   ; Set an exit code of 1
>>%io% ECHO JNZ 10A    ; If key waiting, jump over next line
>>%io% ECHO SUB AL,AL  ; Set an exit code of 0
>>%io% ECHO MOV AH,4C  ; Select terminate w/ exit code function
>>%io% ECHO INT 21     ; Call interrupt 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 0E
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < KEYPRESS.SCR > NUL
%jet% GOTO xDEBUGSCR
:KEYSUB
SET io=KEYSUB.SCR
REM>%io%
>>%io% ECHO N KEYSUB.COM
>>%io% ECHO A 100
>>%io% ECHO JMP 158        ; DOS World magazine, July, 1994, Number 16
>>%io% ECHO DW 0,0
>>%io% ECHO STI
>>%io% ECHO PUSH BX        ; creates program that enables a
>>%io% ECHO PUSH AX        ; key to have a new meaning
>>%io% ECHO PUSHF
>>%io% ECHO CALL 0:0
>>%io% ECHO POP BX
>>%io% ECHO PUSHF
>>%io% ECHO CMP BH,1
>>%io% ECHO JBE 120
>>%io% ECHO CMP BH,10
>>%io% ECHO JZ 120
>>%io% ECHO CMP BH,11
>>%io% ECHO JNZ 12B
>>%io% ECHO CS:
>>%io% ECHO CMP AX,[102]
>>%io% ECHO JNZ 12B
>>%io% ECHO CS:
>>%io% ECHO MOV AX,[104]
>>%io% ECHO POPF
>>%io% ECHO POP BX
>>%io% ECHO RETF 2
>>%io% ECHO DB "Press key to redefine$"
>>%io% ECHO DB D,A
>>%io% ECHO DB "Press new value$"
>>%io% ECHO MOV BH,10
>>%io% ECHO MOV AX,12FF
>>%io% ECHO INT 16
>>%io% ECHO CMP AL,FF
>>%io% ECHO JNZ 165
>>%io% ECHO SUB BH,BH
>>%io% ECHO MOV DI,102
>>%io% ECHO CLD
>>%io% ECHO MOV CX,2
>>%io% ECHO MOV DX,130
>>%io% ECHO MOV AH,9
>>%io% ECHO INT 21
>>%io% ECHO MOV AH,BH
>>%io% ECHO INT 16
>>%io% ECHO STOSW
>>%io% ECHO MOV DX,146
>>%io% ECHO LOOP 16F
>>%io% ECHO MOV AX,3516
>>%io% ECHO INT 21
>>%io% ECHO MOV [10B],BX
>>%io% ECHO MOV [10D],ES
>>%io% ECHO MOV AX,2516
>>%io% ECHO MOV DX,106
>>%io% ECHO INT 21
>>%io% ECHO MOV AH,49
>>%io% ECHO MOV ES,[2C]
>>%io% ECHO INT 21
>>%io% ECHO MOV DX,130
>>%io% ECHO INT 27
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 9F
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < KEYSUB.SCR > NUL
%jet% GOTO xDEBUGSCR
:LPTSTAT
SET io=LPTSTAT.SCR
REM>%io%
>>%io% ECHO N LPTSTAT.COM
>>%io% ECHO E100 06 B8 40 00 8E C0 26 A1 08 00 3D 00 00 74 0D BA
>>%io% ECHO E110 A5 01 B4 09 CD 21 BA 00 00 E8 31 00 26 A1 0A 00
>>%io% ECHO E120 3D 00 00 74 0D BA AC 01 B4 09 CD 21 BA 01 00 E8
>>%io% ECHO E130 1B 00 26 A1 0C 00 3D 00 00 74 0D BA B3 01 B4 09
>>%io% ECHO E140 CD 21 BA 02 00 E8 05 00 B8 00 4C CD 21 B4 02 CD
>>%io% ECHO E150 17 50 80 E4 80 BA BA 01 74 03 BA C9 01 B4 09 CD
>>%io% ECHO E160 21 58 50 80 E4 40 BA DC 01 74 03 BA E5 01 B4 09
>>%io% ECHO E170 CD 21 58 50 80 E4 20 BA EB 01 74 03 BA F3 01 B4
>>%io% ECHO E180 09 CD 21 58 50 80 E4 10 BA FF 01 74 03 BA 0E 02
>>%io% ECHO E190 B4 09 CD 21 58 80 E4 08 BA 19 02 74 03 BA 25 02
>>%io% ECHO E1A0 B4 09 CD 21 C3 4C 50 54 31 3A 20 24 4C 50 54 32
>>%io% ECHO E1B0 3A 20 24 4C 50 54 33 3A 20 24 70 72 69 6E 74 65
>>%io% ECHO E1C0 72 20 62 75 73 79 2C 20 24 70 72 69 6E 74 65 72
>>%io% ECHO E1D0 20 6E 6F 74 20 62 75 73 79 2C 20 24 6E 6F 20 61
>>%io% ECHO E1E0 63 6B 2C 20 24 61 63 6B 2C 20 24 70 61 70 65 72
>>%io% ECHO E1F0 2C 20 24 70 61 70 65 72 20 6F 75 74 2C 20 24 6E
>>%io% ECHO E200 6F 74 20 73 65 6C 65 63 74 65 64 2C 20 24 73 65
>>%io% ECHO E210 6C 65 63 74 65 64 2C 20 24 6E 6F 20 65 72 72 6F
>>%io% ECHO E220 72 2E 0D 0A 24 65 72 72 6F 72 2E 0D 0A 24
>>%io% ECHO RCX
>>%io% ECHO 12E
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < LPTSTAT.SCR > NUL
%jet% GOTO xDEBUGSCR
:MAJMINVR
SET io=MAJMINVR.SCR
REM>%io%
>>%io% ECHO N MAJORVER.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     AH,30    ; select get DOS version function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 8
>>%io% ECHO W
>>%io% ECHO.
>>%io% ECHO N MINORVER.COM
>>%io% ECHO A 104
>>%io% ECHO XCHG    AH,AL    ; switch major and minor version #
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code function
>>%io% ECHO INT     21       ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO A
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < MAJMINVR.SCR > NUL
%jet% GOTO xDEBUGSCR
:MEGSFREE
SET io=MEGSFREE.SCR
REM>%io%
>>%io% ECHO MEGSFREE SCR
>>%io% ECHO.
>>%io% ECHO     Returns an ERRORLEVEL = to the number of free megs on the argument
>>%io% ECHO     drive, rounded down.
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO A 0100
>>%io% ECHO CLD
>>%io% ECHO MOV SI,0081
>>%io% ECHO LODSB
>>%io% ECHO CMP AL,20
>>%io% ECHO JZ 0104
>>%io% ECHO XOR DL,DL
>>%io% ECHO CMP AL,0D
>>%io% ECHO JZ 0115
>>%io% ECHO AND AL,DF
>>%io% ECHO SUB AL,40
>>%io% ECHO MOV DL,AL
>>%io% ECHO MOV AH,36
>>%io% ECHO INT 21
>>%io% ECHO MUL CX
>>%io% ECHO MUL BX
>>%io% ECHO MOV CX,0014
>>%io% ECHO SHR DX,1
>>%io% ECHO RCR AX,1
>>%io% ECHO LOOP 0120
>>%io% ECHO CMP AX,00FF
>>%io% ECHO JBE 012E
>>%io% ECHO MOV AX,00FF
>>%io% ECHO MOV AH,4C
>>%io% ECHO INT 21
>>%io% ECHO.
>>%io% ECHO N MEGSFREE.COM
>>%io% ECHO RCX
>>%io% ECHO 32
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < MEGSFREE.SCR > NUL
%jet% GOTO xDEBUGSCR
:MEMSIZE
SET io=MEMSIZE.SCR
REM>%io%
>>%io% ECHO N MEMSIZE.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AX,ES
>>%io% ECHO DEC AX
>>%io% ECHO MOV ES,AX      ;ES points to memory control block
>>%io% ECHO ES:
>>%io% ECHO MOV BX,[0003]  ;get block size in BX
>>%io% ECHO MOV AX,0280    ;280h = (1024 * 10) / 16
>>%io% ECHO XCHG AX,BX     ;divisor in BX, dividend in AX
>>%io% ECHO SUB DX,DX      ;zero out DX
>>%io% ECHO DIV BX         ;perform division to get number of 10k chunks
>>%io% ECHO MOV AH,4C      ; select terminate w/ exit code function
>>%io% ECHO INT 21         ; call INT 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 17
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < MEMSIZE.SCR > NUL
%jet% GOTO xDEBUGSCR
:NCOMPARE
SET io=NCOMPARE.SCR
REM>%io%
>>%io% ECHO E100  2B C0 BE 80 00 46 80 3C  20 74 FA 80 3C 0D 74 1A
>>%io% ECHO E110  8B FE 40 46 80 3C 0D 74  11 80 3C 20 75 F5 46 80
>>%io% ECHO E120  3C 20 74 FA 80 3C 0D 74  01 40 3D 02 00 75 22 8B
>>%io% ECHO E130  D7 E8 23 00 72 1B 8B D8  8B D6 E8 1A 00 72 12 3B
>>%io% ECHO E140  D8 74 0A 7C 04 B0 01 EB  0A B0 02 EB 06 B0 00 EB
>>%io% ECHO E150  02 B0 FF B4 4C CD 21 52  56 FC 8B F2 2B D2 AC 3C
>>%io% ECHO E160  30 72 12 3C 39 77 0E 25  0F 00 E8 10 00 72 07 03
>>%io% ECHO E170  D0 72 03 EB E9 F8 8B C2  5E 5A C3 00 00 89 16 7B
>>%io% ECHO E180  01 D1 E2 D1 E2 03 16 7B  01 D1 E2 C3
>>%io% ECHO NNCOMPARE.COM
>>%io% ECHO RCX            ; (c) DOS World
>>%io% ECHO 8C
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < NCOMPARE.SCR > NUL
%jet% GOTO xDEBUGSCR
:NOPRSCR
SET io=NOPRSCR.SCR
REM>%io%
>>%io% ECHO NOPRSCR  SCR
>>%io% ECHO.
>>%io% ECHO This debug script turns OFF the prn-scr key.
>>%io% ECHO Note that the 01 at the end of line 7 can be changed to a 00
>>%io% ECHO to turn the prt-scr ky back on.
>>%io% ECHO.
>>%io% ECHO When this program is run, the system thinks it is in the middle of
>>%io% ECHO a prn-scr and will therefor not start another.
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO A 100
>>%io% ECHO MOV AX,0050
>>%io% ECHO PUSH AX
>>%io% ECHO POP ES
>>%io% ECHO MOV DI,0000
>>%io% ECHO ES:
>>%io% ECHO MOV BYTE PTR [DI],01
>>%io% ECHO MOV AH,4C
>>%io% ECHO INT 21
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 10
>>%io% ECHO N NOPRSCR.COM
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < NOPRSCR.SCR > NUL
%jet% GOTO xDEBUGSCR
:NOSOUND
SET io=NOSOUND.SCR
REM>%io%
>>%io% ECHO NOSOUND.COM                           Dale Lewallen/Jeff Prosise
>>%io% ECHO                                                        July 1992
>>%io% ECHO ----------------------------------------------------------------
>>%io% ECHO Purpose:       Disable your PC's internal speaker.
>>%io% ECHO.
>>%io% ECHO Format:        Place the file NOSOUND.COM in your \DOS
>>%io% ECHO                Directory.  Then, to use the program, type 
>>%io% ECHO                NOSOUND at the DOS Prompt.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO --------------------------------------------
>>%io% ECHO.
>>%io% ECHO N NOSOUND.COM
>>%io% ECHO E 0100 EB 1A 00 00 00 00 9C 2E
>>%io% ECHO E 0108 FF 1E 02 01 9C 50 FB E4
>>%io% ECHO E 0110 61 EB 00 24 FC E6 61 58
>>%io% ECHO E 0118 9D CA 02 00 B8 1C 35 CD
>>%io% ECHO E 0120 21 89 1E 02 01 8C 06 04
>>%io% ECHO E 0128 01 B8 1C 25 BA 06 01 CD
>>%io% ECHO E 0130 21 BA 1C 01 CD 27
>>%io% ECHO RCX
>>%io% ECHO 36
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < NOSOUND.SCR > NUL
%jet% GOTO xDEBUGSCR
:NOWAIT
SET io=NOWAIT.SCR
REM>%io%
>>%io% ECHO NOWAIT   SCR
>>%io% ECHO.
>>%io% ECHO This debug script resets the numbre of re-tries BIOS makes to the
>>%io% ECHO printer.
>>%io% ECHO.
>>%io% ECHO Change the 01 at the end of the 7th line to the number of re-tries.
>>%io% ECHO The usual system default is 20.
>>%io% ECHO  
>>%io% ECHO Also, the port address is:
>>%io% ECHO 0078 for LPT1:
>>%io% ECHO 0079 for LPT2:
>>%io% ECHO 007A for LPT3:
>>%io% ECHO 007B for LPT4:
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO A 100
>>%io% ECHO MOV AX,0040
>>%io% ECHO PUSH AX
>>%io% ECHO POP ES
>>%io% ECHO MOV DI,0078
>>%io% ECHO ES:
>>%io% ECHO MOV BYTE PTR [DI],03
>>%io% ECHO MOV AH,4C
>>%io% ECHO INT 21
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 10
>>%io% ECHO N NOWAIT.COM
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < NOWAIT.SCR > NUL
%jet% GOTO xDEBUGSCR
:NUMLKOFF
SET io=NUMLKOFF.SCR
REM>%io%
>>%io% ECHO N NUMLKOFF.COM
>>%io% ECHO A 100
>>%io% ECHO POP DS           ; (c) DOS World, Sep, 1997, Issue 35, pg 66
>>%io% ECHO AND BY [417],DF  ; Turn Numlock off
>>%io% ECHO INT 20           ; Exit to DOS
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 8
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < NUMLKOFF.SCR > NUL
%jet% GOTO xDEBUGSCR
:NUMLKON
SET io=NUMLKON.SCR
REM>%io%
>>%io% ECHO N NUMLKON.COM
>>%io% ECHO A 100
>>%io% ECHO POP DS          ; (c) DOS World, September 1997, Issue 35, page 66
>>%io% ECHO OR  BY [417],20 ; Turn Numlock on
>>%io% ECHO INT 20          ; Exit to DOS
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 8
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < NUMLKON.SCR > NUL
%jet% GOTO xDEBUGSCR
:NUMLOCK
SET io=NUMLOCK.SCR
REM>%io%
>>%io% ECHO NUMLOCK  SCR
>>%io% ECHO.
>>%io% ECHO Toggles the numberlock key.
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO A 0100
>>%io% ECHO CLD
>>%io% ECHO MOV SI,0081
>>%io% ECHO MOV AX,0040
>>%io% ECHO MOV ES,AX
>>%io% ECHO LODSB
>>%io% ECHO CMP AL,20
>>%io% ECHO JZ 0109
>>%io% ECHO CMP AL,0D
>>%io% ECHO JZ 0127
>>%io% ECHO CMP AL,2B
>>%io% ECHO JNZ 011D
>>%io% ECHO ES:
>>%io% ECHO OR BYTE PTR [0017],20
>>%io% ECHO RET
>>%io% ECHO CMP AL,2D
>>%io% ECHO JNZ 0127
>>%io% ECHO ES:
>>%io% ECHO AND BYTE PTR [0017],DF
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO N NUMLOCK.COM
>>%io% ECHO RCX
>>%io% ECHO 28
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < NUMLOCK.SCR > NUL
%jet% GOTO xDEBUGSCR
:PREFIX
SET io=PREFIX.SCR
REM>%io%
>>%io% ECHO N PREFIX.COM
>>%io% ECHO A
>>%io% ECHO PUSH CS         ; Adds string to each line of specified ASCII file.
>>%io% ECHO POP  DS         ; (c) DOS World
>>%io% ECHO MOV  DX, 0157
>>%io% ECHO MOV  [0155],DX
>>%io% ECHO MOV  AH,3F
>>%io% ECHO MOV  BX,0000
>>%io% ECHO MOV  CX,0001
>>%io% ECHO MOV  DX,[0155]
>>%io% ECHO INC  WORD PTR [0155]
>>%io% ECHO INT  21
>>%io% ECHO CMP  AX,0000
>>%io% ECHO JNZ  0125
>>%io% ECHO MOV  AX,4C00
>>%io% ECHO INT  21
>>%io% ECHO PUSH DX
>>%io% ECHO POP  SI
>>%io% ECHO MOV  AH,[SI]
>>%io% ECHO CMP  AH,0A
>>%io% ECHO JZ   0130
>>%io% ECHO JMP  0109
>>%io% ECHO PUSH AX
>>%io% ECHO MOV  BX,0001
>>%io% ECHO XOR  CH,CH
>>%io% ECHO MOV  CL,[0080]
>>%io% ECHO MOV  DX,0081
>>%io% ECHO MOV  AH,40
>>%io% ECHO INT  21
>>%io% ECHO MOV  AH,40
>>%io% ECHO MOV  BX,0001
>>%io% ECHO MOV  CX,[0155]
>>%io% ECHO SUB  CX,0157
>>%io% ECHO MOV  DX,0157
>>%io% ECHO INT  21
>>%io% ECHO JMP  0102
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 155
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < PREFIX.SCR > NUL
%jet% GOTO xDEBUGSCR
:PRSCR
SET io=PRSCR.SCR
REM>%io%
>>%io% ECHO PRSCR    SCR
>>%io% ECHO.
>>%io% ECHO This debug script turns ON the prn-scr key.
>>%io% ECHO Note that the 00 at the end of line 7 can be changed to a 01
>>%io% ECHO to turn the prt-scr key off.
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO A 100
>>%io% ECHO MOV AX,0050
>>%io% ECHO PUSH AX
>>%io% ECHO POP ES
>>%io% ECHO MOV DI,0000
>>%io% ECHO ES:
>>%io% ECHO MOV BYTE PTR [DI],00
>>%io% ECHO MOV AH,4C
>>%io% ECHO INT 21
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 10
>>%io% ECHO N PRSCR.COM
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < PRSCR.SCR > NUL
%jet% GOTO xDEBUGSCR
:PRTLOG
SET io=PRTLOG.SCR
REM>%io%
>>%io% ECHO REM Debug script to toggle print logging of the command line.
>>%io% ECHO REM PC/C Jul 94 p192
>>%io% ECHO.
>>%io% ECHO N PRTLOG.COM
>>%io% ECHO E 0100 EB 2F 53 79 6E 74 61 78
>>%io% ECHO E 0108 3A 20 4C 4F 47 47 49 4E
>>%io% ECHO E 0110 47 20 4F 4E 7C 4F 46 46
>>%io% ECHO E 0118 0D 0A 24 52 66 71 75 69
>>%io% ECHO E 0120 72 65 73 20 44 4F 53 20
>>%io% ECHO E 0128 35 20 6F 72 20 36 0D 0A
>>%io% ECHO E 0130 24 B4 30 CD 21 BA 1B 01
>>%io% ECHO E 0138 3C 05 72 3E 3C 06 77 3A
>>%io% ECHO E 0140 FC BE 81 00 AC 3C 20 74
>>%io% ECHO E 0148 FB 3C 09 74 F7 BA 02 01
>>%io% ECHO E 0150 3C 0D 74 26 4E AD 25 DF
>>%io% ECHO E 0158 DF 3C 4F 75 1D B0 FF 80
>>%io% ECHO E 0160 FC 4E 74 07 32 C0 80 FC
>>%io% ECHO E 0168 46 75 0F 50 B4 34 CD 21
>>%io% ECHO E 0170 58 26 A2 FE 02 B8 00 4C
>>%io% ECHO E 0178 CD 21 B4 09 CD 21 B8 01
>>%io% ECHO E 0180 4C CD 21
>>%io% ECHO RCX
>>%io% ECHO 83
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < PRTLOG.SCR > NUL
%jet% GOTO xDEBUGSCR
:RANDOM
SET io=RANDOM.SCR
REM>%io%
>>%io% ECHO 00
>>%io% ECHO 0000000000000000    ' XOR MASK
>>%io% ECHO 0000000000000000    ' Ciphertext 0
>>%io% ECHO 0000000000000000    ' Ciphertext 1
>>%io% ECHO 00                  ' Plaintext byte mask
>>%io% ECHO 0                   ' use CBC
>>%io% ECHO 0                   ' extra XOR
>>%io% ECHO 0                   ' random vector (0=seed with timer, 1=use input, >1=seed)
>>%io% ECHO 00000000000000      ' starting key
>>%io% ECHO 2000                 ' number of clocks
>>%io% ECHO.
DEBUG < RANDOM.SCR > NUL
%jet% GOTO xDEBUGSCR
:REBOOT
SET io=REBOOT.SCR
REM>%io%
>>%io% ECHO REBOOT   SCR
>>%io% ECHO.
>>%io% ECHO     Warm boots the PC
>>%io% ECHO.
>>%io% ECHO cut here --\/
>>%io% ECHO -------------------------------------
>>%io% ECHO A 0100
>>%io% ECHO MOV AX,40
>>%io% ECHO MOV DS,AX
>>%io% ECHO MOV WORD PTR [72],1234
>>%io% ECHO JMP FFFF:0000
>>%io% ECHO.
>>%io% ECHO N REBOOT.COM
>>%io% ECHO RCX
>>%io% ECHO 10
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < REBOOT.SCR > NUL
%jet% GOTO xDEBUGSCR
:RENDIR
SET io=RENDIR.SCR
REM>%io%
>>%io% ECHO -
>>%io% ECHO.
>>%io% ECHO -^C
>>%io% ECHO -^C
>>%io% ECHO -
DEBUG < RENDIR.SCR > NUL
%jet% GOTO xDEBUGSCR
:RESET
SET io=RESET.SCR
REM>%io%
>>%io% ECHO N RESET.COM
>>%io% ECHO A 100
>>%io% ECHO MOV AX,0040
>>%io% ECHO MOV DX,AX
>>%io% ECHO MOV AX,1234
>>%io% ECHO MOV [0072],AX
>>%io% ECHO JMP F000:FFF0
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 10
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < RESET.SCR > NUL
%jet% GOTO xDEBUGSCR
:ROLL
SET io=ROLL.SCR
REM>%io%
>>%io% ECHO N ROLL.COM
>>%io% ECHO A 100
>>%io% ECHO JMP   0193
>>%io% ECHO DB  "Usage: ROLL < filename"
>>%io% ECHO DB  D A 24
>>%io% ECHO DB  "File error"
>>%io% ECHO DB  D A 24
>>%io% ECHO DB  "Roll 1.0"
>>%io% ECHO DB  20 FE 20
>>%io% ECHO DB  "Copyright (c) 1998"
>>%io% ECHO DB  ", Robert L. Hummel"
>>%io% ECHO DB  D A 20
>>%io% ECHO DB  "Faster +"
>>%io% ECHO DB  20 20
>>%io% ECHO DB  "Slower -"
>>%io% ECHO DB  20 20
>>%io% ECHO DB  "Pause=space"
>>%io% ECHO DB  20 20
>>%io% ECHO DB  "Quit=Esc"
>>%io% ECHO DB  0
>>%io% ECHO DB  "CON"
>>%io% ECHO DW  0 0 9 0 0
>>%io% ECHO DB  0
>>%io% ECHO MOV   AX,4400
>>%io% ECHO SUB   BX,BX
>>%io% ECHO INT   21
>>%io% ECHO JNB   01A1
>>%io% ECHO MOV   DX,011C
>>%io% ECHO JMP   01A9
>>%io% ECHO TEST  DL,80
>>%io% ECHO JZ    01B0
>>%io% ECHO MOV   DX,0103
>>%io% ECHO MOV   AH,09
>>%io% ECHO INT   21
>>%io% ECHO JMP   0285
>>%io% ECHO MOV   AH,3E
>>%io% ECHO MOV   BX,0001
>>%io% ECHO INT   21
>>%io% ECHO JB    019C
>>%io% ECHO MOV   AX,3D01
>>%io% ECHO MOV   DX,0185
>>%io% ECHO INT   21
>>%io% ECHO JB    019C
>>%io% ECHO MOV   AX,3523
>>%io% ECHO INT   21
>>%io% ECHO MOV   [018E],BX
>>%io% ECHO MOV   [0190],ES
>>%io% ECHO MOV   AX,2523
>>%io% ECHO MOV   DX,0310
>>%io% ECHO INT   21
>>%io% ECHO MOV   AH,0F
>>%io% ECHO INT   10
>>%io% ECHO DEC   AH
>>%io% ECHO MOV   [0189],AH
>>%io% ECHO MOV   [018B],BH
>>%io% ECHO MOV   BL,BH
>>%io% ECHO SUB   BH,BH
>>%io% ECHO ADD   BX,BX
>>%io% ECHO LEA   SI,[BX+0450]
>>%io% ECHO SUB   AX,AX
>>%io% ECHO MOV   ES,AX
>>%io% ECHO ES:
>>%io% ECHO MOV   AL,[0484]
>>%io% ECHO MOV   [018A],AL
>>%io% ECHO MOV   AX,0600
>>%io% ECHO MOV   BH,1F
>>%io% ECHO SUB   CX,CX
>>%io% ECHO MOV   DX,[0189]
>>%io% ECHO INT   10
>>%io% ECHO MOV   AX,0600
>>%io% ECHO MOV   BH,71
>>%io% ECHO MOV   CX,[0189]
>>%io% ECHO MOV   DX,CX
>>%io% ECHO DEC   CH
>>%io% ECHO SUB   CL,CL
>>%io% ECHO MOV   DH,01
>>%io% ECHO INT   10
>>%io% ECHO MOV   AH,02
>>%io% ECHO MOV   BH,[018B]
>>%io% ECHO MOV   DX,[0189]
>>%io% ECHO DEC   DH
>>%io% ECHO SUB   DL,DL
>>%io% ECHO INT   10
>>%io% ECHO MOV   AH,40
>>%io% ECHO MOV   BX,0001
>>%io% ECHO MOV   CX,005C
>>%io% ECHO MOV   DX,0129
>>%io% ECHO INT   21
>>%io% ECHO ES:
>>%io% ECHO SUB   Byte [0484],02
>>%io% ECHO MOV   AH,02
>>%io% ECHO MOV   BH,[018B]
>>%io% ECHO SUB   DX,DX
>>%io% ECHO INT   10
>>%io% ECHO MOV   CL,[018A]
>>%io% ECHO SUB   CL,03
>>%io% ECHO SUB   CH,CH
>>%io% ECHO PUSH  CX
>>%io% ECHO CALL  0289
>>%io% ECHO POP   CX
>>%io% ECHO JB    0275
>>%io% ECHO CMP   Byte [0192],00
>>%io% ECHO JNZ   0275
>>%io% ECHO LOOP  0251
>>%io% ECHO CMP   Byte [0192],00
>>%io% ECHO JNZ   0275
>>%io% ECHO CALL  02B7
>>%io% ECHO CALL  02D9
>>%io% ECHO JB    0275
>>%io% ECHO CALL  0289
>>%io% ECHO JNB   0261
>>%io% ECHO MOV   AL,[018A]
>>%io% ECHO ES:
>>%io% ECHO MOV   [0484],AL
>>%io% ECHO MOV   AX,2523
>>%io% ECHO LDS   DX,[018E]
>>%io% ECHO INT   21
>>%io% ECHO MOV   AH,4C
>>%io% ECHO INT   21
>>%io% ECHO MOV   AH,3F
>>%io% ECHO SUB   BX,BX
>>%io% ECHO MOV   CX,0001
>>%io% ECHO MOV   DX,0080
>>%io% ECHO INT   21
>>%io% ECHO JB    02B6
>>%io% ECHO OR    AX,AX
>>%io% ECHO STC
>>%io% ECHO JZ    02B6
>>%io% ECHO MOV   AH,40
>>%io% ECHO MOV   BX,0001
>>%io% ECHO MOV   CX,BX
>>%io% ECHO MOV   DX,0080
>>%io% ECHO INT   21
>>%io% ECHO CMP   Byte [0080],0D
>>%io% ECHO JZ    0289
>>%io% ECHO ES:
>>%io% ECHO CMP   Byte [SI],00
>>%io% ECHO JNZ   0289
>>%io% ECHO CLC
>>%io% ECHO RET
>>%io% ECHO STI
>>%io% ECHO ES:
>>%io% ECHO MOV   AX,[046C]
>>%io% ECHO ES:
>>%io% ECHO MOV   DX,[046E]
>>%io% ECHO ADD   AX,[018C]
>>%io% ECHO ADC   DX,+00
>>%io% ECHO ES:
>>%io% ECHO CMP   DX,[046E]
>>%io% ECHO JA    02C8
>>%io% ECHO JB    02D8
>>%io% ECHO ES:
>>%io% ECHO CMP   AX,[046C]
>>%io% ECHO JA    02D1
>>%io% ECHO RET
>>%io% ECHO MOV   AH,01
>>%io% ECHO INT   16
>>%io% ECHO JNZ   02E2
>>%io% ECHO CLC
>>%io% ECHO JMP   030F
>>%io% ECHO SUB   AH,AH
>>%io% ECHO INT   16
>>%io% ECHO MOV   BX,[018C]
>>%io% ECHO CMP   AL,2B
>>%io% ECHO JNZ   02F7
>>%io% ECHO DEC   BX
>>%io% ECHO JS    02D9
>>%io% ECHO MOV   [018C],BX
>>%io% ECHO JMP   02D9
>>%io% ECHO CMP   AL,2D
>>%io% ECHO JNZ   0300
>>%io% ECHO INC   BX
>>%io% ECHO JZ    02D9
>>%io% ECHO JMP   02F1
>>%io% ECHO CMP   AL,20
>>%io% ECHO JNZ   030A
>>%io% ECHO SUB   AH,AH
>>%io% ECHO INT   16
>>%io% ECHO JMP   02D9
>>%io% ECHO CMP   AL,1B
>>%io% ECHO JNZ   02D9
>>%io% ECHO STC
>>%io% ECHO RET
>>%io% ECHO CS:
>>%io% ECHO INC   Byte [0192]
>>%io% ECHO IRET
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 216
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < ROLL.SCR > NUL
%jet% GOTO xDEBUGSCR
:SAYAT
SET io=SAYAT.SCR
REM>%io%
>>%io% ECHO N SAYAT.COM
>>%io% ECHO A 100
>>%io% ECHO MOV CL,80
>>%io% ECHO DEC CL            ; SAYAT.SCR, DOS World, pg 34, Nov 1994
>>%io% ECHO SUB CH,CH         ; Lets you access special characters &
>>%io% ECHO MOV AL,22         ; display them on screen.
>>%io% ECHO MOV DI,81
>>%io% ECHO REPNZ             ; Usage: SAYAT nRow nCol "Msg"
>>%io% ECHO SCASB             ; Example: SAYAT 8 33 "Backup Options"
>>%io% ECHO JNZ 159
>>%io% ECHO MOV BP,DI         ; You can specify any of the 16 colors
>>%io% ECHO REPNZ             ; listed below for the foreground; the
>>%io% ECHO SCASB             ; background can only include the zero
>>%io% ECHO JNZ 159           ; through seven colors. If you use the
>>%io% ECHO DEC DI            ; values 3 to 15 for the background,
>>%io% ECHO MOV AH,F          ; DOS selects colors 0 through 7 but
>>%io% ECHO INT 10            ; the foreground will blink.
>>%io% ECHO PUSH BX
>>%io% ECHO SUB AX,AX         ; 0 black
>>%io% ECHO MOV SI,5D         ; 1 blue
>>%io% ECHO LODSB             ; 2 green
>>%io% ECHO CMP AL,20         ; 3 cyan
>>%io% ECHO JZ 12D            ; 4 red
>>%io% ECHO SUB AL,30         ; 5 magneta
>>%io% ECHO AAD               ; 6 brown
>>%io% ECHO MOV AH,AL         ; 7 gray (standard white)
>>%io% ECHO JMP 120           ; 8 dark grey
>>%io% ECHO DEC AH            ; 9 light blue
>>%io% ECHO MOV DH,AH         ;10 light green
>>%io% ECHO SUB AX,AX         ;11 light cyan
>>%io% ECHO MOV SI,6D         ;12 light red
>>%io% ECHO LODSB             ;13 light magneta
>>%io% ECHO CMP AL,20         ;14 yellow
>>%io% ECHO JZ 143            ;15 bright white
>>%io% ECHO SUB AL,30
>>%io% ECHO AAD
>>%io% ECHO MOV AH,AL
>>%io% ECHO JMP 136
>>%io% ECHO DEC AH
>>%io% ECHO MOV DL,AH
>>%io% ECHO MOV AH,2
>>%io% ECHO POP BX
>>%io% ECHO INT 10
>>%io% ECHO MOV AH,40
>>%io% ECHO MOV BX,1
>>%io% ECHO MOV DX,BP
>>%io% ECHO MOV CX,DI
>>%io% ECHO SUB CX,DX
>>%io% ECHO INT 21
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO R CX
>>%io% ECHO 5A
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
>>%io% ECHO.
DEBUG < SAYAT.SCR > NUL
%jet% GOTO xDEBUGSCR
:SETEXIT
SET io=SETEXIT.SCR
REM>%io%
>>%io% ECHO N SETEXIT.COM
>>%io% ECHO A 100
>>%io% ECHO MOV     SI,0080  ; SI points to command tail
>>%io% ECHO MOV     CL,[SI]  ; CL gets length of command tail
>>%io% ECHO SUB     CH,CH    ; zero out CH
>>%io% ECHO SUB     AL,AL    ; zero out AL
>>%io% ECHO JCXZ    125      ; length 0?  Quit!
>>%io% ECHO DEC     CX       ; skip the space
>>%io% ECHO ADD     SI,2     ; SI points to first char of parameter
>>%io% ECHO                  ; loop start
>>%io% ECHO LODSB            ; load a char into AL
>>%io% ECHO SUB     AL,30    ; convert char to number
>>%io% ECHO JL      0121     ; less than 0? skip it
>>%io% ECHO CMP     AL,9     ; compare with 9
>>%io% ECHO JA      0121     ; greater? skip it
>>%io% ECHO XCHG    BX,AX    ; swap BX and AX
>>%io% ECHO MOV     DX,0A    ; put 10 (decimal) in DX
>>%io% ECHO MUL     DL       ; multiply AL by 10
>>%io% ECHO XCHG    BX,AX    ; swap BX and AX
>>%io% ECHO ADD     BL,AL    ; add to BL
>>%io% ECHO LOOP    010F     ; if CX > 0, jump back to loop start
>>%io% ECHO XCHG    BL,AL    ; put total in AL
>>%io% ECHO MOV     AH,4C    ; select terminate w/ exit code function
>>%io% ECHO INT     21       ; call interrupt 21h
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 29
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < SETEXIT.SCR > NUL
%jet% GOTO xDEBUGSCR
:SHIFTKEY
SET io=SHIFTKEY.SCR
REM>%io%
>>%io% ECHO SHIFTKEY                  July 1992                 Jeff Prosise
>>%io% ECHO ----------------------------------------------------------------
>>%io% ECHO Purpose:        Assign a different key to prevent Windows from
>>%io% ECHO                 loading from your AUTOEXEC.BAT. (The default
>>%io% ECHO                 is either SHIFT key on your keyboard.)
>>%io% ECHO.
>>%io% ECHO Usage:          Add SHIFTKEY.COM to your AUTOEXEC.BAT file on
>>%io% ECHO                 a line prior to the line that loads Windows.
>>%io% ECHO.
>>%io% ECHO Modification:   To modify SHIFTKEY.COM to use other than the
>>%io% ECHO                 SHIFT key, modify the code as follows:
>>%io% ECHO.
>>%io% ECHO                 To use the ALT key, change the 03 in the line
>>%io% ECHO                 that begins with 0100 to read 08.
>>%io% ECHO.
>>%io% ECHO                 To use the CTRL key, change the 03 in the line
>>%io% ECHO                 that begins with 0100 to read 04.
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO Sample Batch fragment:
>>%io% ECHO.
>>%io% ECHO     ShiftKey.com
>>%io% ECHO     If errorlevel 1 goto NoShift
>>%io% ECHO     {Stuff to do}
>>%io% ECHO     :NoShift
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO The complete program code is listed below.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO -------------------------------------------------------------------------
>>%io% ECHO N SHIFTKEY.COM
>>%io% ECHO E 0100 B4 02 CD 16 24 03 B4 4C
>>%io% ECHO E 0108 CD 21
>>%io% ECHO RCX
>>%io% ECHO A
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < SHIFTKEY.SCR > NUL
%jet% GOTO xDEBUGSCR
:SHIFTMOD
SET io=SHIFTMOD.SCR
REM>%io%
>>%io% ECHO SFTMOD                                               James Flynn
>>%io% ECHO                                                   September 1992
>>%io% ECHO ----------------------------------------------------------------
>>%io% ECHO.
>>%io% ECHO Purpose:       SFTMOD is a solved challenge from the May 1992
>>%io% ECHO                issue.  David DeVere of Pittsburgh, PA, who 
>>%io% ECHO                asked if there was a way to change the keyboard
>>%io% ECHO                so that the command and period keys produced those
>>%io% ECHO                punctuation marks even when the Shift key was
>>%io% ECHO                pressed.
>>%io% ECHO.
>>%io% ECHO                The winner of the challenge was James Flynn from
>>%io% ECHO                Rutland, Illinois.  Jim's solution is to create
>>%io% ECHO                a small .COM file called SHIFTMOD.COM to remap
>>%io% ECHO                the < and > keys to type only a period or a comma.
>>%io% ECHO.
>>%io% ECHO Usage:         Place SHIFTMOD in your AUTOEXEC.BAT file so that
>>%io% ECHO                the key remaps each time you boot your PC.
>>%io% ECHO.
>>%io% ECHO Remarks:       The keyboard remapping will not work under Windows.
>>%io% ECHO                You can still enter the < and > keys if you first
>>%io% ECHO                hold down both shift keys.
>>%io% ECHO.
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO --------------------------------------
>>%io% ECHO N SHIFTMOD.COM
>>%io% ECHO E 0100 EB 5A 49 6E 73 74 61 6C
>>%io% ECHO E 0108 6C 65 64 0D 0A 24 00 00
>>%io% ECHO E 0110 00 00 00 9C 50 E4 60 3C
>>%io% ECHO E 0118 33 72 3A 3C 34 77 36 06
>>%io% ECHO E 0120 2B C0 8E C0 26 A0 17 04
>>%io% ECHO E 0128 2E A2 12 01 24 03 3C 03
>>%io% ECHO E 0130 74 22 26 80 26 17 04 FC
>>%io% ECHO E 0138 07 58 9D 9C 2E FF 1E 0E
>>%io% ECHO E 0140 01 9C 50 06 2B C0 8E C0
>>%io% ECHO E 0148 2E A0 12 01 26 A2 17 04
>>%io% ECHO E 0150 07 58 9D CF 07 58 9D 2E
>>%io% ECHO E 0158 FF 2E 0E 01 BA 02 01 B4
>>%io% ECHO E 0160 09 CD 21 B8 09 35 CD 21
>>%io% ECHO E 0168 89 1E 0E 01 8C 06 10 01
>>%io% ECHO E 0170 B8 09 25 BA 13 01 CD 21
>>%io% ECHO E 0178 BA 16 00 B8 00 31 CD 21
>>%io% ECHO RCX
>>%io% ECHO 80
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < SHIFTMOD.SCR > NUL
%jet% GOTO xDEBUGSCR
:SHOFLAGS
SET io=SHOFLAGS.SCR
REM>%io%
>>%io% ECHO N SHOFLAGS.COM
>>%io% ECHO A 100
>>%io% ECHO MOV  AH,0F    ; First, we get the current
>>%io% ECHO INT  10       ;  video mode from video BIOS
>>%io% ECHO MOV  AH,00    ; Next, reset the video mode
>>%io% ECHO INT  10       ;  to clear the screen
>>%io% ECHO MOV  AH,01    ; Call video BIOS to make the
>>%io% ECHO MOV  CX,2000  ;  cursor invisible by using
>>%io% ECHO INT  10       ;  an invalid cursor shape
>>%io% ECHO MOV  SI,016B  ; Load offset of header text
>>%io% ECHO MOV  AH,0E    ; Load Write Char. function # 
>>%io% ECHO MOV  BX,0001  ; Load default video page/color
>>%io% ECHO MOV  AL,[SI]  ; Get character from header
>>%io% ECHO CMP  AL,00    ; Is it the end of the header?
>>%io% ECHO JZ   0122     ; If so, jump to next section
>>%io% ECHO INT  10       ; Display character from header
>>%io% ECHO INC  SI       ; Advance to next character
>>%io% ECHO JMP  0117     ; Repeat until header complete
>>%io% ECHO MOV  AX,0040  ; Load BIOS data segment address
>>%io% ECHO MOV  DS,AX    ;  into segment register DS
>>%io% ECHO MOV  DI,8000  ; Put bitmask into DI
>>%io% ECHO MOV  CH,[17]  ; Put 1st flag byte into CH
>>%io% ECHO MOV  CL,[18]  ; Put 2nd flag byte into CL
>>%io% ECHO MOV  AH,02    ; Call video BIOS to position
>>%io% ECHO MOV  DX,0100  ;  cursor at start of 2nd line
>>%io% ECHO INT  10       ;  before showing flags' status
>>%io% ECHO MOV  AL,58    ; Put character 'X' in AL
>>%io% ECHO TEST DI,CX    ; Test for flag bit set or clear
>>%io% ECHO JNZ  0141     ; If flag set, keep 'X' in AL
>>%io% ECHO MOV  AL,20    ; Else, put space character in AL
>>%io% ECHO MOV  AH,0E    ; Call video BIOS to write the
>>%io% ECHO INT  10       ;  character in AL to the screen
>>%io% ECHO MOV  AL,20    ; Call video BIOS to write a
>>%io% ECHO INT  10       ;  space character between flags
>>%io% ECHO MOV  AH,01    ; Call the keyboard service to
>>%io% ECHO INT  16       ;  see if user has pressed a key
>>%io% ECHO JNZ  0151     ; If key pressed, go and get it
>>%io% ECHO JMP  0159     ; Else, go do next flag bit
>>%io% ECHO MOV  AH,00    ; Call keyboard service to read
>>%io% ECHO INT  16       ;  character in keyboard buffer
>>%io% ECHO CMP  AL,00    ; Is it a printable character?
>>%io% ECHO JNZ  015F     ; If so, jump to end of program
>>%io% ECHO ROR  DI,1     ; Shift right by one bit
>>%io% ECHO JC   012A     ; If 16 flags done, reread flags
>>%io% ECHO JMP  0139     ; Else, go do the next flag bit
>>%io% ECHO MOV  AH,01    ; Call video BIOS to make the
>>%io% ECHO MOV  CX,0607  ;  cursor visible again
>>%io% ECHO INT  10       ;
>>%io% ECHO MOV  AX,4C00  ; Exit to DOS with a return
>>%io% ECHO INT  21       ;  code of 00h
>>%io% ECHO DB   '7 6 5 4 3 2 1 0 7 6 5 4 3 2 1 0', 0
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 8B
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < SHOFLAGS.SCR > NUL
%jet% GOTO xDEBUGSCR
:SWAPPORT
SET io=SWAPPORT.SCR
REM>%io%
>>%io% ECHO N SWAPPORT.COM
>>%io% ECHO A 100
>>%io% ECHO XOR AX,AX           ; DOS World, Sep 1993, #11, pg 13
>>%io% ECHO MOV DS,AX           ; Swaps LPT1 & LPT2
>>%io% ECHO MOV SI,408
>>%io% ECHO MOV AX,[SI]
>>%io% ECHO MOV BX,[SI+2]
>>%io% ECHO XCHG AX,BX
>>%io% ECHO MOV [SI],AX
>>%io% ECHO MOV [SI+2],BX
>>%io% ECHO INT 20
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 15
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < SWAPPORT.SCR > NUL
%jet% GOTO xDEBUGSCR
:SWAPPRN
SET io=SWAPPRN.SCR
REM>%io%
>>%io% ECHO N SWAPPRN.COM
>>%io% ECHO A 100
>>%io% ECHO POP DS        ; (C) DOS World, September 1997, Issue 35, page 68
>>%io% ECHO MOV SI,408    ; Switch port assignments for printers attached to
>>%io% ECHO LODSW         ; LPT1 and LPT2
>>%io% ECHO XCHG AX,[SI]
>>%io% ECHO MOV [SI-2],AX
>>%io% ECHO INT 20
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO C
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < SWAPPRN.SCR > NUL
%jet% GOTO xDEBUGSCR
:TRUNAM
SET io=TRUNAM.SCR
REM>%io%
>>%io% ECHO N TRUNAM.COM
>>%io% ECHO A 100
>>%io% ECHO XOR  AH,AH       ; Clear AH
>>%io% ECHO MOV  AL,[80]     ; Get command line length
>>%io% ECHO MOV  SI,AX       ; Move length to SI
>>%io% ECHO ADD  SI,81       ; Calc. end of command line
>>%io% ECHO MOV  [SI],BYTE 0 ; Tag on ASCII/Z terminator
>>%io% ECHO MOV  SI,81       ; Offset of command line
>>%io% ECHO ORG  111         ; ====REMOVE LEADING SPACES===
>>%io% ECHO CMP  [SI],BYTE 0 ; End of command line?
>>%io% ECHO JE   14D         ; If so, exit program
>>%io% ECHO CMP  [SI],BYTE 20; Leading space character?
>>%io% ECHO JNE  11E         ; If not, stop advancing
>>%io% ECHO INC  SI          ; Else, advance to next char
>>%io% ECHO JMP  111         ; Repeat test
>>%io% ECHO ORG  11E         ; ====RESOLVE PATH NAME=======
>>%io% ECHO MOV  DI,200      ; Offset of dest. buffer
>>%io% ECHO MOV  AH,60       ; Function 60h - Resolve path
>>%io% ECHO INT  21          ; Call DOS to resolve path
>>%io% ECHO JNC  133         ; If successful, show pathname
>>%io% ECHO SUB  AX,2        ; Else, indentify error
>>%io% ECHO MOV  CL,5        ; Generate offset into array
>>%io% ECHO SHL  AX,CL       ;     of error messages
>>%io% ECHO MOV  DI,160      ; Offset of 1st error message
>>%io% ECHO ADD  DI,AX       ; Index DI into error messages
>>%io% ECHO ORG  133         ; ----TOP OF LOOP-------------
>>%io% ECHO MOV  AH,02       ; Function 02h - Output char
>>%io% ECHO MOV  DL,[DI]     ; Get next character
>>%io% ECHO CMP  DL,0        ; Is it the zero byte?
>>%io% ECHO JE   141         ; If so, jump out of loop
>>%io% ECHO INT  21          ; Output character
>>%io% ECHO INC  DI          ; Increment DI to next char.
>>%io% ECHO JMP  133         ; Jump to top of loop
>>%io% ECHO ORG  141         ; ====TERMINATE===============
>>%io% ECHO MOV  AH,02       ; Function 02h - Output char
>>%io% ECHO MOV  DL,0D       ; Character = carriage return
>>%io% ECHO INT  21          ; Call DOS to output CR
>>%io% ECHO MOV  AH,02       ; Function 02h - Output char
>>%io% ECHO MOV  DL,0A       ; Character = line feed
>>%io% ECHO INT  21          ; Call DOS to output LF
>>%io% ECHO MOV  AX,4C00     ; Function 4Ch - Terminate
>>%io% ECHO INT  21          ; Call DOS to exit program
>>%io% ECHO ORG  160         ; Error messages
>>%io% ECHO DB   'Invalid source name', 0
>>%io% ECHO ORG  180         ; Error messages
>>%io% ECHO DB   'Invalid drive or path', 0
>>%io% ECHO ORG  200         ; 128 byte path name buffer
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 180
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < TRUNAM.SCR > NUL
%jet% GOTO xDEBUGSCR
:WAIT
SET io=WAIT.SCR
REM>%io%
>>%io% ECHO WAIT.COM                 August 1992                   Ed Quillen
>>%io% ECHO -----------------------------------------------------------------
>>%io% ECHO Purpose:       WAIT is a short utility that lets you build a
>>%io% ECHO                delay into any batch file and determine its 
>>%io% ECHO                duration on a case-by-case basis.
>>%io% ECHO.
>>%io% ECHO                If you press any key before WAIT reaches its
>>%io% ECHO                timeout, it returns the errorlevel that can
>>%io% ECHO                take you past a step in your batch file.
>>%io% ECHO.
>>%io% ECHO Format:        To use the program, insert the word WAIT on its
>>%io% ECHO                own line in a batch file, followed by a number
>>%io% ECHO                that represents how many seconds you want the 
>>%io% ECHO                file to wait before it moves to the next line.
>>%io% ECHO.
>>%io% ECHO                On the line directly beneath WAIT, insert
>>%io% ECHO.
>>%io% ECHO                     IF ERRORLEVEL 1 GOTO
>>%io% ECHO.
>>%io% ECHO                followed by a location (label) name such as 
>>%io% ECHO                SKIP in the example below.  In this example, the
>>%io% ECHO                batch file waits ten seconds before backing up 
>>%io% ECHO                or skips to an impertinent message at the end if 
>>%io% ECHO                you press a key.
>>%io% ECHO.
>>%io% ECHO                ECHO Will back up in 10 seconds unless you press a key
>>%io% ECHO                WAIT 10
>>%io% ECHO                IF ERRORLEVEL 1 GOTO SKIP
>>%io% ECHO                BACKUP C:\*.* /S A:
>>%io% ECHO                GOTO END
>>%io% ECHO                :SKIP
>>%io% ECHO                Echo Hey, you really should back up
>>%io% ECHO                :END
>>%io% ECHO.
>>%io% ECHO cut here
>>%io% ECHO --------------------------------------------
>>%io% ECHO.
>>%io% ECHO N WAIT.COM
>>%io% ECHO E 0100 BF 5B 00 33 C0 33 C9 33
>>%io% ECHO E 0108 D2 BE 82 00 38 4C FE 74
>>%io% ECHO E 0110 2D AC 3C 0D 74 16 2C 30
>>%io% ECHO E 0118 72 F7 3C 09 77 F3 8B DA
>>%io% ECHO E 0120 D1 E2 D1 E2 03 D3 D1 E2
>>%io% ECHO E 0128 03 D0 EB E5 0B D2 74 0E
>>%io% ECHO E 0130 B8 B6 00 F7 E2 33 D2 BB
>>%io% ECHO E 0138 0A 00 F7 F3 8B F8 B8 40
>>%io% ECHO E 0140 00 8E D8 BB 6C 00 8B 77
>>%io% ECHO E 0148 02 03 3F 13 F1 8B 07 8B
>>%io% ECHO E 0150 57 02 38 4F 04 74 03 83
>>%io% ECHO E 0158 C2 18 3B D6 72 06 77 0E
>>%io% ECHO E 0160 3B C7 73 0A B2 FF B4 06
>>%io% ECHO E 0168 CD 21 74 E1 FE C1 8A C1
>>%io% ECHO E 0170 B4 4C CD 21
>>%io% ECHO RCX
>>%io% ECHO 0074
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < WAIT.SCR > NUL
%jet% GOTO xDEBUGSCR
:WAIT4SYS
SET io=WAIT4SYS.SCR
REM>%io%
>>%io% ECHO N WAIT4SYS.COM
>>%io% ECHO A100
>>%io% ECHO MOV  AX,0040    ; BIOS's data segment address
>>%io% ECHO MOV  DS,AX      ; Put segment address in DS
>>%io% ECHO MOV  SI,0018    ; Offset of 2nd flag byte
>>%io% ECHO MOV  AL,[SI]    ; Read 2nd flag byte into AL
>>%io% ECHO AND  AL,04      ; Test bit 3 (SysReq flag)
>>%io% ECHO JZ   0108       ; If clear, read byte again
>>%io% ECHO MOV  AX,4C00    ; Prepare to exit
>>%io% ECHO INT  21         ; Exit to DOS
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 13
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < WAIT4SYS.SCR > NUL
%jet% GOTO xDEBUGSCR
:WILLFIT
SET io=WILLFIT.SCR
REM>%io%
>>%io% ECHO N WILLFIT.COM
>>%io% ECHO A 100
>>%io% ECHO CLD
>>%io% ECHO SUB BX,BX
>>%io% ECHO OR AL,AL
>>%io% ECHO JNZ 10C        ; DOS World, July 1997, Number 34, page 42
>>%io% ECHO INC BX         ; Creates program which determines whether 
>>%io% ECHO OR AH,AH       ; a group of files will fit on target disk
>>%io% ECHO JZ 112         ; by returing errorlevel:
>>%io% ECHO MOV AL,BL      ;      0 source drive invalid
>>%io% ECHO MOV AH,4C      ;      1 destination drive invalid
>>%io% ECHO INT 21         ;      2 source-file specification missing
>>%io% ECHO INC BX         ;      3 destination-drive specification missing
>>%io% ECHO MOV SI,81      ;      4 files won't fit on destination drive
>>%io% ECHO LODSB          ;      files will fit on destination drive
>>%io% ECHO CMP AL,D       ; Use: WILLFIT [path]filename.ext D:
>>%io% ECHO JZ 10C         ; The first argument is the source-file specifier
>>%io% ECHO CMP AL,20      ; which can include wildcards.
>>%io% ECHO JZ 116        
>>%io% ECHO DEC SI         
>>%io% ECHO MOV DX,SI
>>%io% ECHO INC BX
>>%io% ECHO LODSB
>>%io% ECHO CMP AL,D
>>%io% ECHO JZ 10C
>>%io% ECHO CMP AL,20
>>%io% ECHO JNZ 123
>>%io% ECHO MOV Byte PTR [SI-1],0
>>%io% ECHO SUB DI,DI
>>%io% ECHO SUB BP,BP
>>%io% ECHO MOV AH,4E
>>%io% ECHO MOV CX,1
>>%io% ECHO INT 21
>>%io% ECHO JB 14F
>>%io% ECHO JMP 145
>>%io% ECHO MOV AH,4F
>>%io% ECHO INT 21
>>%io% ECHO JB 14F
>>%io% ECHO ADD BP,[9A]
>>%io% ECHO ADC DI,[9C]
>>%io% ECHO JMP 13F
>>%io% ECHO MOV DL,[6C]
>>%io% ECHO OR DL,DL
>>%io% ECHO JZ 10C
>>%io% ECHO INC BX
>>%io% ECHO MOV SI,BX
>>%io% ECHO MOV AH,36
>>%io% ECHO INT 21
>>%io% ECHO DB 93
>>%io% ECHO MUL CX
>>%io% ECHO JMP 167
>>%io% ECHO SHL AX,1
>>%io% ECHO RCL DX,1
>>%io% ECHO SHR BX,1
>>%io% ECHO OR BX,BX
>>%io% ECHO JNZ 163
>>%io% ECHO MOV BX,SI
>>%io% ECHO CMP DI,DX
>>%io% ECHO JB 179
>>%io% ECHO JA 10C
>>%io% ECHO CMP BP,AX
>>%io% ECHO JA 10C
>>%io% ECHO MOV BL,FF
>>%io% ECHO JMP 10C
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 7D
>>%io% ECHO W
>>%io% ECHO Q
>>%io% ECHO.
DEBUG < WILLFIT.SCR > NUL
%jet% GOTO xDEBUGSCR
:WINAT
SET io=WINAT.SCR
REM>%io%
>>%io% ECHO N WINAT.COM
>>%io% ECHO A 100
>>%io% ECHO MOV SI,81
>>%io% ECHO CALL 13B     ; DOS World, Aug 1996, Special issue #10, page 20
>>%io% ECHO DEC AH       ; by (c) Robert L. Hummel
>>%io% ECHO MOV CH,AH    ; Draws a window at designated spot on screen.
>>%io% ECHO CALL 13B     ; Usage: WINAT row col nrow ncol foreground background
>>%io% ECHO DEC AH       ; where col represents the leftmost column
>>%io% ECHO MOV CL,AH    ; and row represents the uppermost row of
>>%io% ECHO CALL 13B     ; the window.  The paremeters ncol & nrow
>>%io% ECHO DEC AH       ; specify the number of rows and collumns
>>%io% ECHO MOV DH,AH    ; in the windows. Foreground & background
>>%io% ECHO ADD DH,CH    ; colors are specified by the 5th and 6th
>>%io% ECHO CALL 13B     ; parameters. The 16 colors of the MS-DOS
>>%io% ECHO DEC AH       ; spectrum are used:
>>%io% ECHO MOV DL,AH
>>%io% ECHO ADD DL,CL    ; 0  black
>>%io% ECHO CALL 13B     ; 1  blue
>>%io% ECHO MOV BH,AH    ; 2  green
>>%io% ECHO CALL 13B     ; 3  cyan
>>%io% ECHO SHL AH,1     ; 4  red
>>%io% ECHO SHL AH,1     ; 5  magenta
>>%io% ECHO SHL AH,1     ; 6  brown
>>%io% ECHO SHL AH,1     ; 7  grey
>>%io% ECHO OR BH,AH     ; 8  dark grey
>>%io% ECHO MOV AX,600   ; 9  light blue
>>%io% ECHO INT 10       ; 10 light green
>>%io% ECHO RET          ; 11 light cyan
>>%io% ECHO MOV AX,2901  ; 12 light red
>>%io% ECHO MOV DI,5C    ; 11 light magenta
>>%io% ECHO INT 21       ; 14 yellow
>>%io% ECHO PUSH SI      ; 15 bright white
>>%io% ECHO MOV SI,5D
>>%io% ECHO SUB AX,AX    ; Comments added by
>>%io% ECHO LODSB        : John P. Jones, 2000
>>%io% ECHO CMP AL,20
>>%io% ECHO JZ 156
>>%io% ECHO SUB AL,30
>>%io% ECHO AAD
>>%io% ECHO MOV AH,AL
>>%io% ECHO JMP 149
>>%io% ECHO POP SI
>>%io% ECHO RET
>>%io% ECHO.
>>%io% ECHO RCX
>>%io% ECHO 58
>>%io% ECHO W
>>%io% ECHO Q
DEBUG < WINAT.SCR > NUL
%jet% GOTO xDEBUGSCR
:HlpDEBUGSCR
ECHO 100 MS-DOS DEBUG Scripts packed by DEBS2BAT.BAT
ECHO To unpack a script, pass name of script with no extension to DEBUGSCR.BAT
ECHO To unpack all scripts, pass an asterik ('*' character) to DEBUGSCR.BAT
ECHO.
ECHO ADDTOIT.SCR        ALLDATE.SCR     ALLTIME.SCR     ALREADY.SCR     ANSIHERE.SCR
ECHO ANSITEST.SCR       ANSIX.SCR       ANTIBOOT.SCR    AUTOASK.SCR     AUTOCAPS.SCR
ECHO BIGBUF.SCR         BIGCURSO.SCR    BIOSDATE.SCR    BLINKOFF.SCR    BLINKON.SCR 
ECHO BLOAD.SCR          BORDER.SCR      BOXAT.SCR       BSAVE.SCR       BU.SCR      
ECHO BUFFER.SCR         CAPSLOCK.SCR    CHKDRV.SCR      CKHAN.SCR       CLDBOOT.SCR 
ECHO CLEARKEY.SCR       CODES.SCR       COLOR.SCR       CRITERR1.SCR    CRITERR2.SCR
ECHO CRITERR3.SCR       CURSOR.SCR      DOW.SCR         DR.SCR          DREADY.SCR  
ECHO ENCRYPT.SCR        ENVFREE.SCR     ENVSIZE.SCR     EQDISKS1.SCR    EQDISKS2.SCR
ECHO EQDRIVES.SCR       EQGAME.SCR      EQMATH.SCR      EQPPORTS.SCR    EQSPORTS.SCR
ECHO EQVIDEO.SCR        ESC.SCR         FASTKEY.SCR     FILES.SCR       FIND-CD.SCR 
ECHO FINDCD.SCR         FMT360.SCR      FULLSCR.SCR     GETCH.SCR       GETEXKEY.SCR
ECHO GETKEY.SCR         GLOBAL.SCR      GOTOROW.SCR     GSONOFF.SCR     H2D.SCR     
ECHO INPUT.SCR          ISAREADY.SCR    ISDOS33.SCR     ISDOS50.SCR     ISENHANC.SCR
ECHO KBHIT.SCR          KEYCODE.SCR     KEYPRESS.SCR    KEYSUB.SCR      LPTSTAT.SCR 
ECHO MAJMINVR.SCR       MEGSFREE.SCR    MEMSIZE.SCR     NCOMPARE.SCR    NOPRSCR.SCR 
ECHO NOSOUND.SCR        NOWAIT.SCR      NUMLKOFF.SCR    NUMLKON.SCR     NUMLOCK.SCR 
ECHO PREFIX.SCR         PRSCR.SCR       PRTLOG.SCR      RANDOM.SCR      REBOOT.SCR  
ECHO RENDIR.SCR         RESET.SCR       ROLL.SCR        SAYAT.SCR       SETEXIT.SCR 
ECHO SHIFTKEY.SCR       SHIFTMOD.SCR    SHOFLAGS.SCR    SWAPPORT.SCR    SWAPPRN.SCR 
ECHO TRUNAM.SCR         WAIT.SCR        WAIT4SYS.SCR    WILLFIT.SCR     WINAT.SCR   
PAUSE > NUL
:xDEBUGSCR 
SET io=
